/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__CONTEXT_HPP)
#include <Context.hpp>
#endif

#if !defined(__STATE_HPP)
#include <State.hpp>
#endif

namespace corelinux
{
   // Default constructor

   Context::Context( void )
      :
      theState( NULLPTR )
   {
      ;  // do nothing
   }

   // Copy constructor

   Context::Context( ContextCref aContext )
      :
      theState( aContext.getState() )
   {
      ;  // do nothing
   }

   // Destructor

   Context::~Context( void )
   {
      setState( NULLPTR );  
   }

   // Assignment operator

   ContextRef Context::operator=( ContextCref aContext )
   {
      if( *this == aContext )
      {
         ;  // do nothing
      }
      else
      {
         setState( aContext.getState() );
      }
      return (*this);
   }

   // Equality operator

   bool  Context::operator==( ContextCref aContext ) const
   {
      return ( this == &aContext );
   }

   // Request the context operation involving the state

   void  Context::request( void ) throw ( NullPointerException )
   {
      if( theState != NULLPTR )
      {
         theState->handle();
      }
      else
      {
         throw NullPointerException( LOCATION );
      }
   }

   // Change the state of the context

   void  Context::changeState( StatePtr aState )
   {
      setState( aState );
   }

   // Retrieve the state pointer

   StatePtr Context::getState( void ) const
   {
      return theState;
   }

   // Set the state pointer

   void  Context::setState( StatePtr aState )
   {
      theState = aState;
   }

}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/17 03:44:10 $
   $Locker:  $
*/



