#if   !defined(__SUBJECT_HPP)
#define __SUBJECT_HPP

/*
   CoreLinux++ 
   Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__EVENT_HPP)
#include <Event.hpp>
#endif

#if   !defined(__ITERATOR_HPP)
#include <Iterator.hpp>
#endif

namespace corelinux
{
   DECLARE_CLASS( Subject );
   DECLARE_CLASS( Observer );

   /**
   Subject knows its Observer objects, communicates with its observers 
   through event notification.
   */

   class Subject
   {
   public:

      //
      // Constructors and destructor
      //

                        /**
                        Default constructor 
                        */

                        Subject( void ) ;

                        /**
                        Copy constructor 
                        @param Subject const referencee
                        */

                        Subject( SubjectCref );

                        /// Virtual destructor 

      virtual           ~Subject( void );   

      //
      // Operator overloads
      //

               /// Assignment operator

               SubjectRef   operator=( SubjectCref );

               /// Equality operator

               bool operator==( SubjectCref ) const;

               /// In-Equality operator

               bool operator!=( SubjectCref ) const;
      //
      // Accessors
      //


      //
      // Mutators
      //

               /**
               Add an observer for a specific event
               @param Event the type of event interested in
               @exception NullPointer exception if event is null
               */

      virtual  void  addObserver( ObserverPtr, Event<Identifier> * ) 
                  throw ( NullPointerException ) = 0 ;

               /**
               Remove an observer from all event notifications
               @param Observer to remove
               @exception NullPointer exception Observer is null
               */
               
      virtual  void  removeObserver( ObserverPtr ) 
                  throw ( NullPointerException ) = 0 ;

               /**
               Remove an observer from specific event notifications
               @param Observer to remove
               @exception NullPointer exception Observer or Event is null
               */

      virtual  void  removeObserver( ObserverPtr, Event<Identifier> *  ) 
                  throw ( NullPointerException ) = 0 ;

      //
      // Iterator Factory methods
      //
               /**
               Create a iterator for all observers
               @return Iterator
               */

      virtual  Iterator<ObserverPtr> *createIterator( void ) = 0;

               /**
               Create a iterator for observers of this event
               @param Event defines the event type predicate
               @return Iterator
               @exception NullPointerException if event null
               */

      virtual  Iterator<ObserverPtr> *createIterator( Event<Identifier> * ) 
                  throw ( NullPointerException ) = 0 ;

               /**
               Deletes the iterator instance
               @param Iterator
               @exception NullPointerException if iterator null
               */

      virtual  void destroyIterator( Iterator<ObserverPtr> * ) 
                  throw ( NullPointerException ) = 0 ;

   protected:

      //
      // Activity
      //

               /**
               Performs the notification of observers for a
               specific event
               @param Event key
               @exception NullPointerException if event is null
               */

      virtual  void  notifyObservers( Event<Identifier> * )
                  throw ( NullPointerException ) ;

               /**
               Performs the notification of ALL observers for a
               with a specific event
               @param Event key
               @exception NullPointerException if event is null
               */

      virtual  void  notifyAllObservers( Event<Identifier> * )
                  throw ( NullPointerException ) ;
   private:

   };
}

#endif // if !defined(__SUBJECT_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/07 14:53:13 $
   $Locker:  $
*/


