/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "complearn-rczlib.h"

#include "complearn-rczlib-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 18 "complearn-rczlib.gob"

/*
Copyright (c) 2003-2008 Rudi Cilibrasi, Rulers of the RHouse
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. Neither the name of the University nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE RULERS AND CONTRIBUTORS ``AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE RULERS OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.
*/
#include "complearn.h"
#include "privconf.h"
#ifdef HAVE_DLFCN_H
#include <dlfcn.h>
#endif

#ifdef HAVE_ZLIB_H
#include <zlib.h>
#endif

#if HAVE_ZLIB_H
static struct ZlibDynamicAdaptorCB zlibsda = {
  (int (*)(unsigned char *dbuff,unsigned long *p, unsigned char *src, unsigned long sz, int level) ) compress2,
  (int (*)(unsigned char *dbuff,unsigned long *p, unsigned char *src, unsigned long sz) ) uncompress
};
#else
static struct ZlibDynamicAdaptorCB zlibsda;
#endif

static struct ZlibDynamicAdaptorCB zlibdda;
static int haveTriedDL; /* Singleton */

struct ZlibDynamicAdaptorCB *complearn_grab_zlib_dacb(void) {
  if (zlibsda.compress2)
    return &zlibsda;
  if (!haveTriedDL) {
    void *lib_handle;
    haveTriedDL = 1;
#if HAVE_DLFCN_H
    lib_handle = dlopen("libz.so", RTLD_LAZY);
    if (lib_handle) {
      zlibdda.compress2= dlsym(lib_handle,"compress2");
      zlibdda.uncompress= dlsym(lib_handle,"uncompress");
    }
#endif
  }
  return zlibdda.compress2 ? &zlibdda : NULL;
}

static GString *priv_decompress(CompLearnRealCompressor *rc,const GString *src)
{
  struct ZlibDynamicAdaptorCB *zlib = complearn_grab_zlib_dacb();
  GString *result = NULL;
  if (zlib) {
    int i;
    unsigned char *dbuff = NULL;
    int triedp;
    triedp = src->len * 3.0 + 1;
    unsigned long p;
    do {
      if (dbuff != NULL)
        free(dbuff);
      p = triedp;
      dbuff = (unsigned char*)g_malloc(p);
      i = zlib->uncompress(dbuff, &p,(unsigned char *) src->str,src->len);
      triedp = 2*triedp;
      } while (i == -5);  /* Z_BUF_ERROR */
    if (i == 0) /* Z_OK */
      result = g_string_new_len((char *) dbuff, p);
    if (dbuff)
      g_free(dbuff);
  }
  return result;
}

#define _( O ) gettext( O )

#line 123 "complearn-rczlib.c"
/* self casting macros */
#define SELF(x) COMPLEARN_RCZLIB(x)
#define SELF_CONST(x) COMPLEARN_RCZLIB_CONST(x)
#define IS_SELF(x) COMPLEARN_IS_RCZLIB(x)
#define TYPE_SELF COMPLEARN_TYPE_RCZLIB
#define SELF_CLASS(x) COMPLEARN_RCZLIB_CLASS(x)

#define SELF_GET_CLASS(x) COMPLEARN_RCZLIB_GET_CLASS(x)

/* self typedefs */
typedef CompLearnRCZLib Self;
typedef CompLearnRCZLibClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void complearn_rczlib_init (CompLearnRCZLib * o) G_GNUC_UNUSED;
static void complearn_rczlib_class_init (CompLearnRCZLibClass * c) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_COMPRESSION_LEVEL
};

/* pointer to the class of our parent */
static CompLearnRealCompressorAdaptorClass *parent_class = NULL;

/* Short form macros */
#define self_get_compression_level complearn_rczlib_get_compression_level
#define self_set_compression_level complearn_rczlib_set_compression_level
#define self_new complearn_rczlib_new
#define self_compress complearn_rczlib_compress
#define self_decompress complearn_rczlib_decompress
#define self_blurb complearn_rczlib_blurb
#define self_name complearn_rczlib_name
#define self_compressor_version complearn_rczlib_compressor_version
#define self_is_decompressible complearn_rczlib_is_decompressible
#define self_window_size complearn_rczlib_window_size
#define self_is_operational complearn_rczlib_is_operational
#define self_is_threadsafe complearn_rczlib_is_threadsafe
#define self_clone complearn_rczlib_clone


static void
___CompLearn_Real_Compressor_init (CompLearnRealCompressorIface *iface)
{
#line 132 "complearn-rczlib.gob"
	iface->compress = self_compress;
#line 155 "complearn-rczlib.gob"
	iface->decompress = self_decompress;
#line 159 "complearn-rczlib.gob"
	iface->blurb = self_blurb;
#line 163 "complearn-rczlib.gob"
	iface->name = self_name;
#line 167 "complearn-rczlib.gob"
	iface->compressor_version = self_compressor_version;
#line 171 "complearn-rczlib.gob"
	iface->is_decompressible = self_is_decompressible;
#line 180 "complearn-rczlib.gob"
	iface->window_size = self_window_size;
#line 184 "complearn-rczlib.gob"
	iface->is_operational = self_is_operational;
#line 188 "complearn-rczlib.gob"
	iface->is_threadsafe = self_is_threadsafe;
#line 192 "complearn-rczlib.gob"
	iface->clone = self_clone;
#line 190 "complearn-rczlib.c"
}

GType
complearn_rczlib_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (CompLearnRCZLibClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) complearn_rczlib_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (CompLearnRCZLib),
			0 /* n_preallocs */,
			(GInstanceInitFunc) complearn_rczlib_init,
			NULL
		};

		static const GInterfaceInfo CompLearn_Real_Compressor_info = {
			(GInterfaceInitFunc) ___CompLearn_Real_Compressor_init,
			NULL,
			NULL
		};

		type = g_type_register_static (COMPLEARN_TYPE_REAL_COMPRESSOR_ADAPTOR, "CompLearnRCZLib", &info, (GTypeFlags)0);
		g_type_add_interface_static (type,
			COMPLEARN_TYPE_REAL_COMPRESSOR,
			&CompLearn_Real_Compressor_info);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((CompLearnRCZLib *)g_object_new(complearn_rczlib_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static CompLearnRCZLib * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static CompLearnRCZLib *
GET_NEW_VARG (const char *first, ...)
{
	CompLearnRCZLib *ret;
	va_list ap;
	va_start (ap, first);
	ret = (CompLearnRCZLib *)g_object_new_valist (complearn_rczlib_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "CompLearn:RCZLib::finalize"
	CompLearnRCZLib *self G_GNUC_UNUSED = COMPLEARN_RCZLIB (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
complearn_rczlib_init (CompLearnRCZLib * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "CompLearn:RCZLib::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,COMPLEARN_TYPE_RCZLIB,CompLearnRCZLibPrivate);
}
#undef __GOB_FUNCTION__
static void 
complearn_rczlib_class_init (CompLearnRCZLibClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "CompLearn:RCZLib::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(CompLearnRCZLibPrivate));

	parent_class = g_type_class_ref (COMPLEARN_TYPE_REAL_COMPRESSOR_ADAPTOR);

	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_int
		("compression_level" /* name */,
		 _("compression_level") /* nick */,
		 _("Compression level for ZLib, 1-9") /* blurb */,
		 1 /* minimum */,
		 9 /* maximum */,
		 9 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_COMPRESSION_LEVEL,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "CompLearn:RCZLib::set_property"
{
	CompLearnRCZLib *self G_GNUC_UNUSED;

	self = COMPLEARN_RCZLIB (object);

	switch (property_id) {
	case PROP_COMPRESSION_LEVEL:
		{
#line 118 "complearn-rczlib.gob"
self->_priv->compression_level = g_value_get_int (VAL);
#line 310 "complearn-rczlib.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "CompLearn:RCZLib::get_property"
{
	CompLearnRCZLib *self G_GNUC_UNUSED;

	self = COMPLEARN_RCZLIB (object);

	switch (property_id) {
	case PROP_COMPRESSION_LEVEL:
		{
#line 118 "complearn-rczlib.gob"
g_value_set_int (VAL, self->_priv->compression_level);
#line 341 "complearn-rczlib.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 118 "complearn-rczlib.gob"
gint 
complearn_rczlib_get_compression_level (CompLearnRCZLib * self)
#line 361 "complearn-rczlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCZLib::get_compression_level"
{
#line 118 "complearn-rczlib.gob"
		gint val; g_object_get (G_OBJECT (self), "compression_level", &val, NULL); return val;
}}
#line 368 "complearn-rczlib.c"
#undef __GOB_FUNCTION__

#line 118 "complearn-rczlib.gob"
void 
complearn_rczlib_set_compression_level (CompLearnRCZLib * self, gint val)
#line 374 "complearn-rczlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCZLib::set_compression_level"
{
#line 118 "complearn-rczlib.gob"
		g_object_set (G_OBJECT (self), "compression_level", val, NULL);
}}
#line 381 "complearn-rczlib.c"
#undef __GOB_FUNCTION__

#line 127 "complearn-rczlib.gob"
GObject * 
complearn_rczlib_new (void)
#line 387 "complearn-rczlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCZLib::new"
{
#line 128 "complearn-rczlib.gob"
	
    GObject *ret = (GObject *) GET_NEW;
    return G_OBJECT (ret);
  }}
#line 396 "complearn-rczlib.c"
#undef __GOB_FUNCTION__

#line 132 "complearn-rczlib.gob"
GString * 
complearn_rczlib_compress (CompLearnRealCompressor * rc, const GString * src)
#line 402 "complearn-rczlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCZLib::compress"
{
#line 133 "complearn-rczlib.gob"
	

    GString *result = NULL;
    struct ZlibDynamicAdaptorCB *zlib = complearn_grab_zlib_dacb();
    int s;

    unsigned char *dbuff;
    unsigned long p;

    if (zlib == NULL)
      return result;

    p = (int)(src->len*1.2) + 12;
  dbuff = (unsigned char*)g_malloc(p);
  s = (zlib->compress2)(dbuff,&p,(unsigned char *) src->str,src->len,complearn_rczlib_get_compression_level(COMPLEARN_RCZLIB(rc)));
  if (s != 0) {    /* Z_OK */
    g_error(_("Unknown error: zlibBuff returned %d"),s);
  }
  result = g_string_new_len((char *) dbuff, p);
  g_free(dbuff);
  return result;
  }}
#line 429 "complearn-rczlib.c"
#undef __GOB_FUNCTION__

#line 155 "complearn-rczlib.gob"
GString * 
complearn_rczlib_decompress (CompLearnRealCompressor * rc, const GString * src)
#line 435 "complearn-rczlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCZLib::decompress"
{
#line 156 "complearn-rczlib.gob"
	
    return priv_decompress(rc, src);
  }}
#line 443 "complearn-rczlib.c"
#undef __GOB_FUNCTION__

#line 159 "complearn-rczlib.gob"
GString * 
complearn_rczlib_blurb (CompLearnRealCompressor * rc)
#line 449 "complearn-rczlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCZLib::blurb"
{
#line 160 "complearn-rczlib.gob"
	
    return g_string_new("Lempel-Ziv 77 zlib");
  }}
#line 457 "complearn-rczlib.c"
#undef __GOB_FUNCTION__

#line 163 "complearn-rczlib.gob"
GString * 
complearn_rczlib_name (CompLearnRealCompressor * rc)
#line 463 "complearn-rczlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCZLib::name"
{
#line 164 "complearn-rczlib.gob"
	
    return g_string_new("zlib");
  }}
#line 471 "complearn-rczlib.c"
#undef __GOB_FUNCTION__

#line 167 "complearn-rczlib.gob"
GString * 
complearn_rczlib_compressor_version (CompLearnRealCompressor * rc)
#line 477 "complearn-rczlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCZLib::compressor_version"
{
#line 168 "complearn-rczlib.gob"
	
    return g_string_new("1.2.3");
  }}
#line 485 "complearn-rczlib.c"
#undef __GOB_FUNCTION__

#line 171 "complearn-rczlib.gob"
gboolean 
complearn_rczlib_is_decompressible (CompLearnRealCompressor * rc, const GString * input)
#line 491 "complearn-rczlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCZLib::is_decompressible"
{
#line 172 "complearn-rczlib.gob"
	
    if (input->len == 0 || (guchar) input->str[0] != 0x78)
      return FALSE;
    GString *t = priv_decompress(rc, input);
    if (t != NULL)
      g_string_free(t, TRUE);
    return t != NULL;
  }}
#line 504 "complearn-rczlib.c"
#undef __GOB_FUNCTION__

#line 180 "complearn-rczlib.gob"
guint64 
complearn_rczlib_window_size (CompLearnRealCompressor * rc)
#line 510 "complearn-rczlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCZLib::window_size"
{
#line 181 "complearn-rczlib.gob"
	
    return 32768*8;
  }}
#line 518 "complearn-rczlib.c"
#undef __GOB_FUNCTION__

#line 184 "complearn-rczlib.gob"
gboolean 
complearn_rczlib_is_operational (CompLearnRealCompressor * rc)
#line 524 "complearn-rczlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCZLib::is_operational"
{
#line 185 "complearn-rczlib.gob"
	
    return complearn_grab_zlib_dacb() != NULL;
  }}
#line 532 "complearn-rczlib.c"
#undef __GOB_FUNCTION__

#line 188 "complearn-rczlib.gob"
gboolean 
complearn_rczlib_is_threadsafe (CompLearnRealCompressor * rc)
#line 538 "complearn-rczlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCZLib::is_threadsafe"
{
#line 189 "complearn-rczlib.gob"
	
    return TRUE;
  }}
#line 546 "complearn-rczlib.c"
#undef __GOB_FUNCTION__

#line 192 "complearn-rczlib.gob"
CompLearnRealCompressor * 
complearn_rczlib_clone (CompLearnRealCompressor * rc)
#line 552 "complearn-rczlib.c"
{
#define __GOB_FUNCTION__ "CompLearn:RCZLib::clone"
{
#line 193 "complearn-rczlib.gob"
	
    CompLearnRCZLib *res = COMPLEARN_RCZLIB(complearn_rczlib_new());
    complearn_rczlib_set_compression_level(res, complearn_rczlib_get_compression_level(COMPLEARN_RCZLIB(rc)));
    return COMPLEARN_REAL_COMPRESSOR(res);
    }}
#line 562 "complearn-rczlib.c"
#undef __GOB_FUNCTION__
