


#include "ctcore.h"

#include <stdio.h>


int main(int argc, char **argv) {
  ERRORCODE err;
  CTCORETABLE *ct;

  fprintf(stderr,"Initializing core module.\n");
  err=CTCore_ModuleInit();
  if (!Error_IsOk(err)) {
    char errbuff[256];
    Error_ToString(err,errbuff, sizeof(errbuff));
    fprintf(stderr,
	    "main: An error occurred:\n"
	    " (%s)\n",
	    errbuff);
  }

  ct=CTCore_new();
  fprintf(stderr,"Initializing core.\n");
  err=CTCore_Init(ct);
  if (!Error_IsOk(err)) {
    char errbuff[256];
    Error_ToString(err,errbuff, sizeof(errbuff));
    fprintf(stderr,
	    "main: An error occurred:\n"
	    " (%s)\n",
	    errbuff);
  }
  fprintf(stderr,"Done.\n");

  fprintf(stderr,"Deinitializing core.\n");
  err=CTCore_Fini(ct);
  if (!Error_IsOk(err)) {
    char errbuff[256];
    Error_ToString(err,errbuff, sizeof(errbuff));
    fprintf(stderr,
	    "main: An error occurred:\n"
	    " (%s)\n",
	    errbuff);
  }
  CTCore_free(ct);
  fprintf(stderr,"Done.\n");

  fprintf(stderr,"Deinitializing core module.\n");
  err=CTCore_ModuleFini();
  if (!Error_IsOk(err)) {
    char errbuff[256];
    Error_ToString(err,errbuff, sizeof(errbuff));
    fprintf(stderr,
	    "main: An error occurred:\n"
	    " (%s)\n",
	    errbuff);
  }

  fprintf(stderr,"Program done.\n");
  return 0;
}

