#!/usr/bin/perl -w

use strict;
use LWP::UserAgent;
use HTTP::Request;
use HTTP::Headers;

my $ip = shift || '10.0.0.1';

my $ua = LWP::UserAgent->new;
my $headers = HTTP::Headers->new();

$headers->header('X-Forwarded-For' => "192.168.0.1, " . $ip);
$headers->header('X-Host' => 'localhost');

my $request = HTTP::Request->new('GET', 'http://localhost:8080/', $headers);

my $response = $ua->request($request);

if ($response->is_success) {
    print "Ok! Please check your server log for a supposed connection from $ip\n";
} else {
    print "Something went wrong\n";
}

__END__
