/*
 * cefs.h
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _CEFS_H_
#define _CEFS_H_

struct RAPIHandle;

using namespace std;

struct directory;

class CEFS{
    struct credentials *cred;
    struct dir_cache *cache;
    struct list_head *cfg;

    char* stored_file;
    int writing;
    char* stored_data;
    unsigned int stored_data_len;
    struct RAPIHandle* rhnd;
	
 public:
    CEFS(struct list_head*, struct dir_cache*, struct credentials*);
    ~CEFS();

    int do_mount();
    void do_umount();
    int do_readdir(char*, struct directory*);
    int do_stat(char*, struct lufs_fattr*);
    int do_mkdir(char*, int);
    int do_rmdir(char*);
    int do_create(char*, int);
    int do_unlink(char*);
    int do_rename(char*, char*);
    int do_open(char*, unsigned);
    int do_release(char*);
    int do_read(char*, long long, unsigned long, char*);
    int do_write(char*, long long, unsigned long, char*);
//    int do_readlink(char*, char*, int);
//    int do_link(char*, char*);
//    int do_symlink(char*, char*);
    int do_setattr(char*, struct lufs_fattr*);
};

#endif
