dnl ########################
dnl Scan directories for a given file
dnl ########################
AC_DEFUN(AC_SCAN_DIRS,
[
$3=""
for i in $2;
do
  for j in $1;
  do
    if test -r "$i/$j"; then
      $3=$i
      break 2
    fi
  done
done
])

AC_DEFUN(AC_FIND_FILE,
[
AC_MSG_CHECKING([for file ($3)])
filepath=""
for i in $2;
do
 a=$3
 eval filepath=`ls $i/$a 2>/dev/null | tail -1`
 if test -n "$filepath"; then
    break
 fi
done
if test x$filepath = x ; then
AC_MSG_RESULT([not found])
AC_MSG_ERROR([*** Cannot find $3 in $2.])
else
AC_MSG_RESULT([found $filepath])
fi
AC_DEFINE_UNQUOTED($1,"$filepath")
])

dnl AC_PATH_PACKAGE(PACKAGE_NAME, HEADER_FILE_PROBE, VARIABLE_PREFIX)
dnl Search for the installation directory of a given package; This macro defines
dnl and substitutes ${VARIABLE_PREFIX}_INCDIR, ${VARIABLE_PREFIX}_LIBDIR
dnl ${VARIABLE_PREFIX}_BINDIR and ${VARIABLE_PREFIX}_PKGLIBDIR as needed
dnl to refer respectively to its include and library directories.

AC_DEFUN(AC_PATH_PACKAGE,
[
destdir=$DESTDIR
AC_ARG_WITH(dest-dir,
    [  --with-dest-dir=DIR       where the files will be locally stored ],
    [
	case "$withval" in
	"" | y | ye | yes | n | no)
	    AC_MSG_ERROR([*** You must supply an argument to the --dest-dir option.])
	  ;;
	esac
	destdir="$withval"
    ])

withdir=""
AC_MSG_CHECKING([for $1])
AC_ARG_WITH($1-dir,
    [  --with-$1-dir=DIR       where the $1 package is installed ],
    [
	case "$withval" in
	"" | y | ye | yes | n | no)
	    AC_MSG_ERROR([*** You must supply an argument to the --$1-dir option.])
	  ;;
	esac
	withdir="$withval"
    ])

AC_CACHE_VAL(ac_cv_$1_dir,
	[
	ac_cv_$1_dir=""
	test "x$prefix" = xNONE && zprefix=$ac_default_prefix || zprefix=$prefix
	package_incdirs="$withdir/include $destdir$zprefix/include /usr/local/$1/include /usr/local/include /usr/include"
	AC_SCAN_DIRS($2, $package_incdirs, package_incdir)
	if test -n "$package_incdir"; then
	eval ac_cv_$1_dir=`cd $package_incdir && cd ..; pwd`
	fi
	])

eval cv=$ac_cv_$1_dir
if test -z "$cv"; then
AC_MSG_RESULT([assuming $destdir$prefix (use --with-$1-dir to override)])
cv=$destdir$prefix
else
AC_MSG_RESULT([found in $cv])
fi
root=$3_ROOTDIR
includes=$3_INCDIR
libs=$3_LIBDIR
pkglibs=$3_PKGLIBDIR
programs=$3_BINDIR
eval $root=$cv
eval $includes=$cv/include
eval $libs=$cv/lib
eval $pkglibs=$cv/lib/$1
eval $programs=$cv/bin
AC_SUBST($3_ROOTDIR)dnl
AC_SUBST($3_INCDIR)dnl
AC_SUBST($3_LIBDIR)dnl
AC_SUBST($3_PKGLIBDIR)dnl
AC_SUBST($3_BINDIR)dnl
])

dnl AC_PATH_XREQUIRED() requires X libs. This frag has been
dnl lifted nearly "as is" from Postgresql's configure.in script.

AC_DEFUN(AC_PATH_XREQUIRED,
[
	save_LIBS="$LIBS"
	save_CFLAGS="$CFLAGS"
	save_CPPFLAGS="$CPPFLAGS"
	save_LDFLAGS="$LDFLAGS"

	AC_PATH_XTRA

	LIBS="$LIBS $X_EXTRA_LIBS"
	CFLAGS="$CFLAGS $X_CFLAGS"
	CPPFLAGS="$CPPFLAGS $X_CFLAGS"
	LDFLAGS="$LDFLAGS $X_LIBS"

	dnl Check for X library

	X11_LIBS=""
	AC_CHECK_LIB(X11, XOpenDisplay, X11_LIBS="-lX11",,${X_PRE_LIBS})
	if test "$X11_LIBS" = ""; then
		dnl Not having X is bad news, period. Let the user fix this.
		AC_MSG_ERROR([The X11 library '-lX11' could not be found,
so I won't go further. Please use the configure
options '--x-includes=DIR' and '--x-libraries=DIR'
to specify the X location. See the file 'config.log'
for further diagnostics.])
	fi
	AC_SUBST(X_LIBS)
	AC_SUBST(X11_LIBS)
	AC_SUBST(X_PRE_LIBS)

	LIBS="$save_LIBS"
	CFLAGS="$save_CFLAGS"
	CPPFLAGS="$save_CPPFLAGS"
	LDFLAGS="$save_LDFLAGS"
])

dnl AC_POSIX_SIGHANDLER() determines whether
dnl signal handlers are posix compliant. This frag
dnl has been adapted from readline's aclocal.m4.

AC_DEFUN(AC_POSIX_SIGHANDLER,
[AC_MSG_CHECKING([if signal handlers are posix compliant])
AC_CACHE_VAL(ac_cv_posix_sighandler,
[AC_TRY_COMPILE([#include <sys/types.h>
#include <signal.h>
#ifdef signal
#undef signal
#endif
#ifdef __cplusplus
extern "C"
#endif
void (*signal(void))(void);],
[int i;], ac_cv_posix_sighandler=no, ac_cv_posix_sighandler=yes)])dnl
AC_MSG_RESULT($ac_cv_posix_sighandler)
if test $ac_cv_posix_sighandler = yes; then
AC_DEFINE(HAVE_POSIX_SIGHANDLER)
fi
])

dnl AC_GCC_MOREFLAGS() determines whether
dnl the current compiler is GCC and accepts some
dnl specific additional flags.

AC_DEFUN(AC_GCC_MOREFLAGS,
[AC_MSG_CHECKING([if C compiler is GNU C])
AC_CACHE_VAL(ac_cv_using_gcc_for_c,
[AC_LANG_C
AC_TRY_COMPILE([],
[#ifdef __GNUC__
  yes;
#endif],
ac_cv_using_gcc_for_c=no, ac_cv_using_gcc_for_c=yes)])dnl
if test $ac_cv_using_gcc_for_c = yes; then
AC_MSG_RESULT(yes)
AC_MSG_CHECKING([if C compiler supports -fwritable-strings -fdollars-in-identifiers])
save_CFLAGS="$CFLAGS"
CFLAGS="-fwritable-strings -fdollars-in-identifiers -Werror"
AC_CACHE_VAL(ac_cv_cc_moreflags,
[AC_TRY_COMPILE([],
[int i = 0; return i; ],
ac_cv_cc_moreflags="-fwritable-strings -fdollars-in-identifiers -fpcc-struct-return", ac_cv_cc_moreflags="")])dnl
CFLAGS="$save_CFLAGS $ac_cv_cc_moreflags"
else
AC_MSG_RESULT(no)
fi
if test -z "$ac_cv_cc_moreflags"; then
AC_MSG_RESULT(no)
else
AC_MSG_RESULT(yes)
fi
AC_MSG_CHECKING([if C++ compiler is GNU C++])
AC_CACHE_VAL(ac_cv_using_gcc_for_cxx,
[AC_LANG_CPLUSPLUS
AC_TRY_COMPILE([],
[#ifdef __GNUC__
  yes;
#endif],
ac_cv_using_gcc_for_cxx=no, ac_cv_using_gcc_for_cxx=yes)])dnl
if test $ac_cv_using_gcc_for_cxx = yes; then
AC_MSG_RESULT(yes)
save_CXXFLAGS="$CXXFLAGS"
AC_MSG_CHECKING([if C++ compiler supports -fno-exceptions])
CXXFLAGS="-fno-exceptions -Werror"
AC_CACHE_VAL(ac_cv_cxx_noex,
[AC_TRY_COMPILE([],
[int i = 0; return i; ],
ac_cv_cxx_noex="-fno-exceptions", ac_cv_cxx_noex="")])dnl
if test -z "$ac_cv_cxx_noex"; then
AC_MSG_RESULT(no)
else
AC_MSG_RESULT(yes)
fi
AC_MSG_CHECKING([if C++ compiler supports -fnonnull-objects])
CXXFLAGS="-fnonnull-objects -Werror"
AC_CACHE_VAL(ac_cv_cxx_nonnull,
[AC_TRY_COMPILE([],
[int i = 0; return i; ],
ac_cv_cxx_nonnull="-fnonnull-objects",ac_cv_cxx_nonnull="")])dnl
if test -z "$ac_cv_cxx_nonnull"; then
AC_MSG_RESULT(no)
else
AC_MSG_RESULT(yes)
fi
CXXFLAGS="$save_CXXFLAGS -fwritable-strings -fdollars-in-identifiers -fpcc-struct-return $ac_cv_cxx_noex $ac_cv_cxx_nonnull"
else
AC_MSG_RESULT(no)
fi
AC_LANG_C])

dnl AC_LTT_CONFIG -- process LTT configuration options

AC_DEFUN(AC_LTT_CONFIG,
[
AC_MSG_CHECKING(debug mode enabled)
AC_ARG_ENABLE(debug,
	[ --enable-debug	Enable debug support],
	[CFLAGS="$CFLAGS -g -O2"; with_debug=yes],
	[CFLAGS="$CFLAGS -O2"; with_debug=no])
test x$with_debug = xyes && LTT_DEBUG=1 || LTT_DEBUG=0
AC_SUBST(LTT_DEBUG)
AM_CONDITIONAL(ENABLE_LTT_DEBUG,test ${LTT_DEBUG} = 1)
AC_MSG_RESULT($with_debug)

AC_MSG_CHECKING(RTAI support)
AC_ARG_WITH(rtai,
[  --with-rtai           RTAI support [default=yes]],
test "$withval" = no || with_rtai=yes, with_rtai=yes)
test x$with_rtai = xyes && SUPP_RTAI=1 || SUPP_RTAI=0
AC_SUBST(SUPP_RTAI)
AM_CONDITIONAL(WITH_SUPP_RTAI,test ${SUPP_RTAI} = 1)
AC_MSG_RESULT($with_rtai)

AC_MSG_CHECKING(GTK interface enabled)
AC_ARG_WITH(gtk,
[  --with-gtk           Use GTK interface [default=yes]],
test "$withval" = no || with_gtk=yes, with_gtk=yes)
test x$with_gtk = xyes && GTK_ENV=1 || GTK_ENV=0
AC_SUBST(GTK_ENV)
AM_CONDITIONAL(WITH_GTK_ENV,test ${GTK_ENV} = 1)
AC_MSG_RESULT($with_gtk)

AC_MSG_CHECKING(target native mode enabled)
AC_ARG_ENABLE(target-native,
	[ --enable-target-native	Enable target native mode],
	[use_native=yes],
	[use_native=no])
test x$use_native = xyes && TARGET_NATIVE=1 || TARGET_NATIVE=0
AC_SUBST(TARGET_NATIVE)
AM_CONDITIONAL(ENABLE_TARGET_NATIVE,test ${TARGET_NATIVE} = 1)
AC_MSG_RESULT($use_native)

AC_MSG_CHECKING(unpacked structs)
AC_ARG_ENABLE(unpacked-structs,
	[ --enable-unpacked-structs	Use unpacked structs],
	[use_unpacked=yes],
	[use_unpacked=no])
test x$use_unpacked = xyes && LTT_UNPACKED_STRUCTS=1 || LTT_UNPACKED_STRUCTS=0
AC_SUBST(LTT_UNPACKED_STRUCTS)
AM_CONDITIONAL(ENABLE_LTT_UNPACKED_STRUCTS,test ${LTT_UNPACKED_STRUCTS} = 1)
AC_MSG_RESULT($use_unpacked)
])
