/*
 * File: pixmaps.c
 * Auth: Jean-Hugues Deschenes, some icons by Eric Harlow
 *
 * Pixmaps used in toolbars and functions to handle them
 */

#include "Pixmap.h"

/* The pictures */
#include "Icons/New.xpm"            /* Bitmap for "new" */
#include "Icons/Open.xpm"           /* Bitmap for "open" */
#include "Icons/Close.xpm"          /* Bitmap for "close" */
#include "Icons/Dump.xpm"           /* Bitmap for "dump to file" */
#include "Icons/ZoomIn.xpm"         /* Bitmap for "zoom in" */
#include "Icons/ZoomOut.xpm"        /* Bitmap for "zoom out" */
#include "Icons/Find.xpm"           /* Bitmap for "Go To Event" */
#include "Icons/Horizon.xpm"        /* Bitmap for "Horizon" */
#include "Icons/SchedChng.xpm"      /* Bitmap for "schedule change" */
#include "Icons/KernelTimer.xpm"    /* Bitmap for "kernel timer" */
#include "Icons/SysCall.xpm"        /* Bitmap for "system call" */
#include "Icons/Trap.xpm"           /* Bitmap for "trap" */
#include "Icons/BottomHalf.xpm"     /* Bitmap for "bottom half" */
#include "Icons/IOStart.xpm"        /* Bitmap for "I/O Start" */
#include "Icons/IOEnd.xpm"          /* Bitmap for "I/O End" */
#include "Icons/IRQ.xpm"            /* Bitmap for "IRQ" */

#include "Icons/RTAIMount.xpm"      /* Bitmap for "RTAI Mount" */
#include "Icons/RTAIUmount.xpm"     /* Bitmap for "RTAI Unmount" */
#include "Icons/RTAIIrq.xpm"        /* Bitmap for "RTAI IRQ" */
#include "Icons/RTAITask.xpm"       /* Bitmap for "RTAI Task" */
#include "Icons/RTAITimer.xpm"      /* Bitmap for "RTAI Timer" */
#include "Icons/RTAISem.xpm"        /* Bitmap for "RTAI Semaphore" */
#include "Icons/RTAIMsg.xpm"        /* Bitmap for "RTAI Message" */
#include "Icons/RTAIRPC.xpm"        /* Bitmap for "RTAI RPC" */
#include "Icons/RTAIMbx.xpm"        /* Bitmap for "RTAI Mail-box" */
#include "Icons/RTAIFifo.xpm"       /* Bitmap for "RTAI FIFO" */
#include "Icons/RTAIShm.xpm"        /* Bitmap for "RTAI Shared memory" */
#include "Icons/RTAIPosix.xpm"      /* Bitmap for "RTAI Posix" */
#include "Icons/RTAILXRT.xpm"       /* Bitmap for "RTAI LXRT" */
#include "Icons/RTAILXRTI.xpm"      /* Bitmap for "RTAI LXRT-Informed" */

#include "Icons/IconTextOFF.xpm"    /* Bitmap for "icon text toggle" */
#include "Icons/SysCallsOFF.xpm"    /* Bitmap for "Syscall toggle" */
#include "Icons/IRQsOFF.xpm"        /* Bitmap for "IRQ toggle" */
#include "Icons/TrapsOFF.xpm"       /* Bitmap for "Traps toggle" */
#include "Icons/BottomHalfOFF.xpm"  /* Bitmap for "SoftIRQ toggle" */
#include "Icons/SchedChngOFF.xpm"   /* Bitmap for "Schedule change toggle" */
#include "Icons/KernelTimerOFF.xpm" /* Bitmap for "kernel timer" */

#include "Icons/SlowH.xpm"          /* Bitmap for "Slow horizontal lines draw" */
#include "Icons/SlowV.xpm"          /* Bitmap for "Slow vertical lines draw" */
#include "Icons/SlowI.xpm"          /* Bitmap for "Slow icon draw" */

#include "Icons/mini-LTT.xpm"       /* Main window icon */

/*
 * CreateWidgetFromXpm
 *
 * Using the window information and the string with the icon color/data, 
 * create a widget that represents the data.  Once done, this widget can
 * be added to buttons or other container widgets.
 *
 * This function modified from CreateWidgetFromXpm (c)Eric Harlow
 */
GtkWidget *CreateWidgetFromXpm (GtkWidget *widget, gchar **xpm_data)
{
  
  GdkBitmap *mask;
  GdkPixmap *pixmap_data;
  GtkStyle  *style;
  GtkWidget *pixmap_widget;

  /* Get the pixmap from gdk */
  style = gtk_widget_get_style( widget );
  pixmap_data = gdk_pixmap_create_from_xpm_d( widget->window,  &mask,
					      &style->bg[GTK_STATE_NORMAL],
					      (gchar **)xpm_data );

  pixmap_widget = gtk_pixmap_new (pixmap_data, mask);
  gtk_widget_show (pixmap_widget);
  
  return (pixmap_widget);
}
