/*
 *  Linux snipes, a text-based maze-oriented game for linux.
 *  Copyright (C) 1997 Jeremy Boulton.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Jeremy Boulton is reachable via electronic mail at
 *  boultonj@ugcs.caltech.edu.
 */

#ifndef SNIPES_KEY_DEFS

#define SNIPES_KEY_DEFS


int get_config_from_dumpkeys( void );
int translate_raw_key( int key );


#define RELEASE(n)	(128+n)


#define KEYBOARD_KEY_DOWN_C			1
#define KEYBOARD_KEY_DOWN_Z			2
#define KEYBOARD_KEY_DOWN_A			3
#define KEYBOARD_KEY_DOWN_S			4
#define KEYBOARD_KEY_DOWN_D			5
#define KEYBOARD_KEY_DOWN_W			6
#define KEYBOARD_KEY_DOWN_ARR_U		7
#define KEYBOARD_KEY_DOWN_ARR_L		8
#define KEYBOARD_KEY_DOWN_ARR_D 	9
#define KEYBOARD_KEY_DOWN_ARR_R		10
#define KEYBOARD_KEY_DOWN_CTRL	 	11
#define KEYBOARD_KEY_DOWN_SPACE	 	12

#define KEYBOARD_KEY_UP_C			RELEASE(1)
#define KEYBOARD_KEY_UP_Z			RELEASE(2)
#define KEYBOARD_KEY_UP_A			RELEASE(3)
#define KEYBOARD_KEY_UP_S			RELEASE(4)
#define KEYBOARD_KEY_UP_D			RELEASE(5)
#define KEYBOARD_KEY_UP_W			RELEASE(6)
#define KEYBOARD_KEY_UP_ARR_U		RELEASE(7)
#define KEYBOARD_KEY_UP_ARR_L		RELEASE(8)
#define KEYBOARD_KEY_UP_ARR_D 		RELEASE(9)
#define KEYBOARD_KEY_UP_ARR_R		RELEASE(10)
#define KEYBOARD_KEY_UP_CTRL	 	RELEASE(11)
#define KEYBOARD_KEY_UP_SPACE	 	RELEASE(12)


#endif // SNIPES_KEY_DEFS
