/*
 * store.c -- common lslk storage
 *
 * V. Abell
 * Purdue University Computing Center
 */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell.
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */
#ifndef lint
static char copyright[] =
"@(#) Copyright 1996 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: store.c,v 1.5 99/11/10 14:56:47 abe Exp $";
#endif
 

#include "lslk.h"


/*
 * Local global variables
 */

struct lfile *Lfile = NULL;		/* file selections */
struct lhaddr *Lhaddr = NULL;		/* local host address cache */
struct llock_info *Lock = NULL;		/* the local lock info table */
struct llock_info *Lp = NULL;		/* the current Lock[] pointer */
struct mounts *Mnt = NULL;		/* the local mount table */
gid_t Mygid;				/* real GID of lslk process */
uid_t Myuid;				/* real UID of lslk process */
int NLfile = 0;				/* size of Lfile table */
int NLockA = 0;				/* allocated size of Lock table */
int NLockU = 0;				/* used size of Lock table */

#if	defined(HASKOPT)
char *Nmlst = (char *)NULL;		/* kernel name list path */
#endif	/* defined(HASKOPT) */

int NMnt = 0;				/* the size of Mnt[] */
int NNwad = 0;				/* the size of Nwad[] */
int NPid = 0;				/* the size of Pid[] */
struct nwad *Nwad = NULL;		/* network address selections */
short Oand = 0;				/* AND (-a) option value */
short Oblock = 0;			/* avoid kernel blocks (-b) option
					 * value */
short Oconv = 1;			/* host name convert (-c) option */
short Ohelp = 0;			/* help (-h) option value */
short Oovhd = 0;			/* avoid fork overhead (-O) option
					 * value */
short Owarn = 1;			/* warn (-w) option value */
short Overs = 0;			/* version (-v) option value */
unsigned long *Pid = NULL;		/* PID selection numbers */
char *Pn = NULL;			/* program name */
int Selopt = 0;				/* selection options */
short Setgid = 0;			/* setgid state */
short Setuidroot = 0;			/* setuid-root state */
int TmLimit = TMLIMIT;			/* readlink()/stat() timeout sec. */
