from shellprocess import *
from utils import *
from CDROM import *

class LCDRecordDialog(QDialog):
	def __init__(self, lib, albumPath):
		self.process = None
		QDialog.__init__(self)
##~ 		QProgressDialog.__init__(self,i18n("Burn Album to CD"),None,100,None,"progress",True)
		self.lib = lib
		self.albumPath = albumPath

		vl = QVBoxLayout(self,15)
		hl = QHBoxLayout(vl)
		
		l = QLabel(i18n("Device: "), self)
		hl.addWidget(l)

		self.burnerCombo = QComboBox(self)
		hl.addWidget(self.burnerCombo)
		
		self.sizeLabel = QLabel("", self)
		vl.addWidget(self.sizeLabel)
		
		vl.addStretch()
		hl = QHBoxLayout(vl)
		hl.addStretch()
		self.exportButton = QPushButton(i18n("Burn"), self)
		hl.addWidget(self.exportButton)
		self.exportButton.setDefault(True)
		hl.addSpacing(5)
		self.cancelButton = QPushButton(i18n("Cancel"), self)
		hl.addWidget(self.cancelButton)

		QObject.connect(self.exportButton, SIGNAL("clicked()"), self, SLOT("accept()"))
		QObject.connect(self.cancelButton, SIGNAL("clicked()"), self, SLOT("reject()"))

		# set Estimated Size string
		b = lib.getTotalSize(lib.getAlbum(albumPath)['KeyList'])
		self.sizeLabel.setText(u"%s %s" % (i18n("Estimated Size: "), LUtils.humanByteOutput(b)))
		
		# load devices
		self.devices = CDROMS().burnerInfo()
		for d in self.devices:
			self.burnerCombo.insertItem(d['Manufacturer']+" "+d['Model'])

		if len(self.devices) == 0:
			self.exportButton.setDisabled(True)
			self.burnerCombo.insertItem(i18n("No Burners Found!"))

	def ensureMedia(self, devInfo):
		drive = devInfo['Drive']
		if not drive:
			return False

		while not drive.checkForWriteableMedia():
			drive.ejectMedia()
			if KMessageBox.warningContinueCancel(self, i18n("Please insert a blank CDR disc."), i18n("CDR Media")) == KMessageBox.Continue:
				continue
			else:
				return False
		return True


	def burn(self):
		print "BURN"
		
		self.progress = QProgressDialog(i18n("Burn Album to CD"), None, 100, None, "progress", True)
		self.progress.setCaption(i18n("Burn CD"))
		self.progress.setLabelText(i18n("Creating Album Image"))
		self.progress.setMinimumDuration(0)
		self.progress.setTotalSteps(100)
		self.progress.setProgress(0)
		QObject.connect(self, PYSIGNAL("canceled"), self.canceled)
		self.progress.setCaption(i18n("Burn Album"))
		self.progress.setAutoClose(False)
		self.progress.setAutoReset(False)
		self.progress.show()
		dir = self.lib.createAlbumLinks(self.albumPath)
		self.progress.setLabelText(i18n("Finding CDR Device"))
		self.progress.setProgress(30)
		d = self.devices[self.burnerCombo.currentItem()]
		self.progress.setLabelText(i18n("Initializing CDR Device"))
		if not self.ensureMedia(d):
			self.complete()
			return
		self.progress.setProgress(60)
		self.process = LBurnDirProcess(dir, d)
		QObject.connect(self.process, PYSIGNAL("status"), self.countUpdate)
		QObject.connect(self.process,PYSIGNAL("done"),self.complete)
		QObject.connect(self.process,PYSIGNAL("abort"),self.canceled)
		print "RUN"
		self.process.run()

	def canceled(self):
		print "CANCEL"
		if self.process and self.process.isRunning():
			self.process.kill()
			self.process = None
		if self.progress:
			self.progress = None
			
		self.emit(PYSIGNAL("complete"), (self, 1))
			
	def complete(self):
		if self.progress:
			self.progress = None
		self.emit(PYSIGNAL("complete"), (self, 0))
	
	def countUpdate(self, percent):
		print "UPDATE",percent
		self.progress.setLabelText(i18n("Burning: %i%% Complete" % (percent)))
		self.progress.setProgress(percent)	
					
class LCDRecord(QObject):
	def __init__(self):
		self.process = None
		
	def class_canRecord():
		return CDR.canBurn()
	canRecord = staticmethod(class_canRecord)
	
	def recordDirectory(self, path):
		pass
	

class LBurnDirProcess(LShellProcess):
	def __init__(self, path, device, dummy = False):
		LShellProcess.__init__(self)
		self.path = path
		self.dummy = dummy
		self.device = device
		self.convertLineEndings = True
		self.pattern = re.compile(r"(\d+\.\d+)\% done")

	def buildCommand(self):
		# mkisofs -f {path} | cdrecord [-dummy] -eject dev={device} - 
		self.setExecutable('nice')
		s = str(self.quote(self.path))
		args = ['mkisofs','-f',s,'|','cdrecord','driveropts=burnfree','-eject']
		if self.dummy:
			args.append("-dummy")
		args.append("dev=%s" % self.device['Address'])
		args.append("gracetime=2")
##~ 		args.append("speed=%d" % self.device['MaxSpeed'])
		args.append("-")
		self.totalTime = 0
		self.setArguments(args)
		print "% "," ".join(args)
	
	def processLines(self,lines):
		for line in lines:
			print "*",line
			mo = self.pattern.search(line)
			if mo:
				print "PERCENT",float(mo.group(1))
				self.emit(PYSIGNAL('status'),(int(float(mo.group(1))),100))
				
			elif line.find("Operation starts.") != -1:
				self.emit(PYSIGNAL('status'),(0,100,False))
				print "START WRITING"
			elif line.find("written:") != -1:
				self.emit(PYSIGNAL('status'),(100,100,False))
		

if __name__ == "__main__":
	import sys
##~ 	import time
	print "################### FIND DEVICE"
	d = CDR.getBurnerDevices()
	print "################### INIT DEVICE"
	if len(d):
		p = LBurnDirProcess("root/My Documents/My Photos/Lphoto Library/albums/Photo Library", d[0], True)
		p.run()
	else:
		print "No Device"
	
	a = QApplication(sys.argv)
	QObject.connect(p,SIGNAL("processExited(KProcess *)"),a.quit)
	a.exec_loop()
	print "Complete."
	
	




