/* Copyright (C) 2000-2003 Markus Lausser (sgop@users.sf.net)
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <string.h>
#include <stdlib.h>
#include <netinet/in.h>
#include <time.h>

#include "support.h"
#include "lopster.h"
#include "global.h"
#include "chat.h"
#include "handler.h"
#include "utils.h"
#include "exec.h"
#include "log.h"

static const char* Events[EVENT_NUMBER] = {
  "IM",
  "UPLOAD_REQUEST",
  "DOWNLOAD_FINISHED",
  "USER_ONLINE",
  "USER_OFFLINE",
  "UPLOAD_START",
  "DOWNLOAD_START",
  "MESSAGE_REPLY",
  "DIRECT_BROWSED",
  "WHOIS_REQUEST",
  "FIRST_DOWNLOAD",
  "LAST_DOWNLOAD"
};

void check_uploads_again();

void ext_handle(unsigned int type, const char *user,
		const char *data) {
  if(!global.external_handler ||
     type >= EVENT_NUMBER) return;
  
  if ((global.external_events & (1<<type)) == 0) return;

  exec_command_safe(0, 0, global.external_handler, Events[type],
		    user ? user : "", data ? data : "", 0);
}

HANDLER(not_implemented) {
  char* str;
  chat_page_t* page;
  
  l_log(net, "protocol",
	LOG_PROTOCOL, "** Unknown [%d] [%s]\n",
	net->c_type, data);
  
  page = chat_page_get_printable();
  chat_print_time_stamp(page, M_PUBLIC);
  chat_print_prefix(page, 0);
  chat_print_text(page, M_PUBLIC, "user", "[");
  chat_print_network(page, M_PUBLIC, net, 0, 1);
  chat_print_text(page, M_PUBLIC, "user", "]");
  str = g_strdup_printf(" ** not implemented yet: %d: [%s]\n", net->c_type, data);
  chat_print_text(page, M_PUBLIC, "message", str);
  g_free(str);
}
