/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <sys/types.h>
#include <ctype.h>
#ifndef CYGWIN
#include <unistd.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <time.h>
#include <netdb.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>

#include <gtk/gtk.h>

#include "lopster.h"
#include "support.h"
#include "md5.h"
#include "connection.h"
#include "commands.h"
#include "interface.h"
#include "callbacks.h"
#include "scheme.h"
#include "handler.h"
#include "log.h"
#include "global.h"
#include "chat.h"
#include "search.h"
#include "share.h"
#include "transfer.h"
#include "hotlist.h"
#include "resume.h"
#include "server.h"
#include "dialog.h"
#include "wizard.h"
#include "exec.h"
#include "statistic.h"
#include "filetips.h"
#include "string_list.h"
#include "subscription.h"
#include "userinfo.h"

#include "../pixmaps/speedgreen.xpm"
#include "../pixmaps/speedyellow.xpm"
#include "../pixmaps/speedred.xpm"
#include "../pixmaps/speedgray.xpm"
#include "../pixmaps/folder.xpm"
#include "../pixmaps/folder_open.xpm"
#include "../pixmaps/user1.xpm"	//
#include "../pixmaps/user2.xpm"	//
#include "../pixmaps/ignore.xpm"
#include "../pixmaps/enemy.xpm"
#include "../pixmaps/enemy2.xpm"
#include "../pixmaps/friend.xpm"
#include "../pixmaps/d16x16.xpm"

typedef struct {
  gint src_fd;
  gint dest_fd;
  char* src;
} move_t;

const char LineSpeedShort[12][20] = {
  "?",
  "14.4",
  "28.8",
  "33.6",
  "56K",
  "64K",
  "128K",
  "Cable",
  "DSL",
  "T1",
  "T3+",
  "_?_"
};

char Network[5][20] = {
  "Unknown",
  "Opennap",
  "SlavaNap",
  "CQ_NAP",
  "Napster"
};

char *Browser[BROWSER_NO] = {
  "None",
  "Netscape",
  "Mozilla",
  "Lynx",
  "w3m",
  "Opera"
};

int SocketStatus[S_NUMBER] = {
  S_INACTIVE,
  S_CONNECTING,
  S_INFO,
  S_FINISHED,
  S_DOWNLOADING,
  S_UPLOADING,
  S_TIMEOUT,
  S_REJECT,
  S_INCOMPLETE,
  S_CANCELED,
  S_INFO1,
  S_INFO2,
  S_INFO3,
  S_WAITING,
  S_FIREWALL,
  S_CONERROR,
  S_QUEUED,
  S_REMOTE,
  S_UNAVAILABLE,
  S_RESUME_ERR,
  S_DELETE,
  S_IO
};

const GtkTargetEntry lib_target_table[1] = { 
  {"library-drag-table", 0, 0}
};

int ColorTable(int i1, int i2)
{
  static int table[10][10] = {
    {0, 1, 2, 3, 4, 5, 6, 7, 8, 9},
    {10, 11, 12, 13, 14, 15, 0, 1, 1, 1},
    {-2, -2, -2, -2, -2, -2, -2, -2, -2, -2},
    {1, 4, 3, 5, 2, 6, 10, 15, -3, -3},
    {1, 1, 1, 1, 1, 1, 1, 1, -4, -4},
    {14, 7, 9, 8, 12, 13, 11, 0, 15, 5},
    {-6, -6, -6, -6, -6, -6, -6, -6, -6, -6},
    {-7, -7, -7, -7, -7, -7, -7, -7, -7, -7},
    {-8, -8, -8, -8, -8, -8, -8, -8, -8, -8},
    {-9, -9, -9, -9, -9, -9, -9, -9, -9, -9}
  };
  if (i1 < 0)
    return 0;			// white
  if (i2 < 0)
    return 0;			// white
  if (i1 >= 10)
    return 0;			// white
  if (i2 >= 10)
    return 0;			// white
  if (table[i1][i2] < 0)
    return 0;			// white
  else
    return table[i1][i2];
}

int ColorTable2(int index)
{
  static int table[8] = {
    1, 4, 3, 5, 2, 6, 10, 15
  };

  if (index < 0)
    return 1;			// black
  if (index >= 8)
    return 1;			// black
  return table[index];
};

global_t global;
char tstr[10][512];
char *list[10] = {
  tstr[0], tstr[1],
  tstr[2], tstr[3],
  tstr[4], tstr[5],
  tstr[6], tstr[7],
  tstr[8], tstr[9]
};
char rc_line[2049];

unsigned long extract_bytes(char* string) {
  char* pos;
  unsigned long result = 0;

  if (!string) return 0;
  if (!isdigit(*string)) return 0;

  pos = string;
  while (isdigit(*pos)) {
    result *= 10;
    result += *pos -'0';
    pos++;
  }

  if (*pos == ' ') pos++;
  switch (*pos) {
  case 'm': 
  case 'M': 
    result *= 1024*1024;
    break;
  case 'k': 
  case 'K': 
    result *= 1024;
    break;
  case 'b': 
  case 'B': 
  case ' ': 
  case 0: 
  default:
    break;
  }
  
  return result;
}

// dont pass str == NULL !
char *print_bytes(char *str, unsigned long bytes) {
  if (bytes == 0)
    sprintf(str, "0B");
  else if (bytes%(1024*1024) == 0)
    sprintf(str, "%luM", bytes/1024/1024);
  else if (bytes%1024 == 0)
    sprintf(str, "%luK", bytes/1024);
  else
    sprintf(str, "%luB", bytes);
  return str;
}

int extract_duration(char* string) {
  char* pos;
  unsigned long result = 0;

  if (!string) return 0;
  if (!isdigit(*string)) return 0;

  pos = string;
  while (isdigit(*pos)) {
    result *= 10;
    result += *pos -'0';
    pos++;
  }

  if (*pos == ' ') pos++;

  switch (*pos) {
  case 'h': 
  case 'H': 
    result *= 3600;
    break;
  case 'm': 
  case 'M': 
    result *= 60;
    break;
  case 's': 
  case 'S': 
  case ' ': 
  case 0: 
  default:
    break;
  }
  
  return result;
}

// dont pass str == NULL !
char* print_duration(char* str, int seconds) {
  if (seconds == 0)
    sprintf(str, "0s");
  else if (seconds%(60*60) == 0)
    sprintf(str, "%dh", seconds/60/60);
  else if (seconds%60 == 0)
    sprintf(str, "%dm", seconds/60);
  else
    sprintf(str, "%ds", seconds);
  return str;
}

char *print_size(char *str, double bytes)
{
  if (bytes < 1024)
    sprintf(str, "%ld B", (long) bytes);
  else if (bytes < 1024 * 128)
    sprintf(str, "%.2f KB", bytes / 1024.0);
  else if (bytes < 1024 * 1024)
    sprintf(str, "%.1f KB", bytes / 1024.0);
  else if (bytes < 1024 * 1024 * 128)
    sprintf(str, "%.2f MB", bytes / 1024.0 / 1024.0);
  else if (bytes < 1024 * 1024 * 1024)
    sprintf(str, "%.1f MB", bytes / 1024.0 / 1024.0);
  else
    sprintf(str, "%.1f GB", bytes / 1024.0 / 1024.0 / 1024.0);

  return str;
}

char *print_time_short(char *str, int secs)
{
  int min = secs / 60;
  int sec = secs % 60;
  int hour = min / 60;

  min = min % 60;

  *str = 0;
  if (hour) {
    sprintf(str, "%s%d:%s%d:%s%d", (hour > 9) ? "" : "0", hour,
	    (min > 9) ? "" : "0", min, (sec > 9) ? "" : "0", sec);
  } else {
    sprintf(str, "%s%d:%s%d", (min > 9) ? "" : "0", min,
	    (sec > 9) ? "" : "0", sec);
  }
  return str;
}

// format hours:minutes:seconds
char *print_time(char *str, int secs)
{
  int min = secs / 60;
  int sec = secs % 60;
  int hour = min / 60;

  min = min % 60;

  *str = 0;
  sprintf(str, "%s%d:%s%d:%s%d", (hour > 9) ? "" : "0", hour,
	  (min > 9) ? "" : "0", min, (sec > 9) ? "" : "0", sec);
  return str;
}

/* format:
   1:23 d
   2:59 h
   3:59 m
   59 s   */
char *print_time_average(char *str, int secs)
{
  int sec = secs;
  int min = secs / 60;
  int hour = min / 60;
  int day = hour / 24;

  min = min % 60;
  sec = secs % 60;
  hour = hour % 24;

  *str = 0;
  if (day) {
    sprintf(str, "%d:%s%d d", day, (hour > 9) ? "" : "0", hour);
  } else if (hour) {
    sprintf(str, "%s%d:%s%d h", (hour > 9) ? "" : "0", hour,
	    (min > 9) ? "" : "0", min);
  } else if (min) {
    sprintf(str, "%s%d:%s%d m", (min > 9) ? "" : "0", min,
	    (sec > 9) ? "" : "0", sec);
  } else {
    sprintf(str, "%s%d s", (sec > 9) ? "" : "0", sec);
  }
  return str;
}

char *print_speed(char *str, long bytes, int withdot)
{
  if (withdot) {
    if (bytes < 1024)
      sprintf(str, "%ld B/s", bytes);
    else if (bytes < 1024 * 128)
      sprintf(str, "%.2f KB/s", (double) bytes / 1024.0);
    else if (bytes < 1024 * 1024)
      sprintf(str, "%.1f KB/s", (double) bytes / 1024.0);
    else
      sprintf(str, "%.1f MB/s", (double) bytes / 1024.0 / 1024.0);
  } else {
    if (bytes < 1024)
      sprintf(str, "%ld B/s", bytes);
    else if (bytes < 1024 * 8)
      sprintf(str, "%.1f KB/s", (double) bytes / 1024.0);
    else if (bytes < 1024 * 1024)
      sprintf(str, "%ld KB/s", bytes / 1024);
    else if (bytes < 1024 * 1024 * 8)
      sprintf(str, "%.1f MB/s", (double) bytes / 1024.0 / 1024.0);
    else
      sprintf(str, "%ld MB/s", bytes / 1024 / 1024);
  }

  return str;
}

void detect_line_pixs(int speed, GdkPixmap ** pixmap, GdkBitmap ** bitmap)
{
  if (speed > 10 || speed < 1) {
    *pixmap = global.pix.sgray;
    *bitmap = global.pix.sgrayb;
  } else if (speed <= 3) {
    *pixmap = global.pix.sred;
    *bitmap = global.pix.sredb;
  } else if (speed <= 6) {
    *pixmap = global.pix.syellow;
    *bitmap = global.pix.syellowb;
  } else if (speed <= 10) {
    *pixmap = global.pix.sgreen;
    *bitmap = global.pix.sgreenb;
  } else {
    *pixmap = global.pix.sgray;
    *bitmap = global.pix.sgrayb;
  }
}

void detect_speed_pixs(double rate, GdkPixmap ** pixmap, GdkBitmap ** bitmap)
{
  if (rate > global.options.speedgreen) {
    *pixmap = global.pix.sgreen;
    *bitmap = global.pix.sgreenb;
  } else if (rate > global.options.speedyellow) {
    *pixmap = global.pix.syellow;
    *bitmap = global.pix.syellowb;
  } else if (rate > global.options.speedred) {
    *pixmap = global.pix.sred;
    *bitmap = global.pix.sredb;
  } else if (rate > 0) {
    *pixmap = global.pix.sgray;
    *bitmap = global.pix.sgrayb;
  } else {
    *pixmap = global.pix.dummy;
    *bitmap = global.pix.dummyb;
  }
}


char *extract_last_dir(char *filename)
{
  static char dir[2048];
  char *pos1;
  char *pos2;

  pos1 = strchr(filename, '/');
  pos2 = strrchr(filename, '/');
  if (!pos1)
    return NULL;
  if (pos1 == pos2)
    return NULL;

  pos2[0] = 0;
  pos1 = strrchr(filename, '/') + 1;
  strcpy(dir, pos1);
  pos2[0] = '/';

  return dir;
}

char *extract_filename(char *filename)
{
  char *pos1;

  pos1 = strrchr(filename, '/');
  if (!pos1)
    return filename;
  else
    return (pos1 + 1);
}

void convert_local_name(char *fname)
{
  if (!fname) return;

  while (*fname) {
    if (*fname == '?') *fname = '_';
    else if (*fname == '*') *fname = '_';
    else if (*fname == ':') *fname = '_';
    fname++;
  }
}

char *rename_file(char *filename)
{
  struct stat st;
  char *result;
  char *base = l_strdup(filename);
  char *suff;
  int cnt = 1;

  suff = strrchr(base, '.');
  if (suff) {
    *suff = 0;
    suff++;
  }
  l_free(filename);
  while (1) {
    if (suff)
      result = l_strdup_printf("%s_%d.%s", base, cnt, suff);
    else
      result = l_strdup_printf("%s_%d", base, cnt);
    if (stat(result, &st) < 0)
      break;
    l_free(result);
    result = NULL;
    if (cnt >= 100)
      break;
    cnt++;
  }
  l_free(base);

  return result;
}

char *extract_short_name(char *longname)
{
  char dir_sep;
  char *pos1;
  char *pos2;

  // extracting short name
  dir_sep = '/';		// ext file system

  pos1 = strchr(longname, dir_sep);
  pos2 = strrchr(longname, dir_sep);
  if (pos1 == pos2) {		// none or only one sep found
    return longname;
  } else {
    pos2[0] = 'Q';
    pos1 = strrchr(longname, dir_sep);
    pos2[0] = dir_sep;
    pos1++;
    return pos1;
  }
}

char *convert_to_win(char *name)
{
  char *ptr;

  ptr = name;
  if (!ptr || !*ptr)
    return NULL;

  while (*ptr) {
    if (*ptr == '/')
      *ptr = '\\';
    ptr++;
  }

  return ptr;
}

char *convert_to_unix(char *name)
{
  char *ptr;

  convert_file(name);
  ptr = name;
  if (!ptr || !*ptr)
    return NULL;

  while (*ptr) {
    if (*ptr == '\\')
      *ptr = '/';
    ptr++;
  }

  return ptr;
}

int speed2int(char *linespeed)
{
  int i1;

  for (i1 = 0; i1 < 11; i1++) {
    if (!strcmp(linespeed, LineSpeed(i1)))
      return i1;
  }

  return 0;
}

int level2int(char *level)
{
  int i1;

  if (level[0] == '\"') {
    level++;
    level[strlen(level) - 1] = 0;
  }
  for (i1 = 0; i1 < 5; i1++) {
    if (!strncasecmp(level, Level(i1), 3))
      return i1;
  }

  return -1;
}

int mime2int(char *mime)
{
  int i1;

  for (i1 = 0; i1 < MIME_SIZE; i1++) {
    if (!strcmp(mime, MimeNames(i1))) {
      return i1;
    }
  }

  return 0;
}

int mime2int_(char *mime)
{
  int i1;

  for (i1 = 0; i1 < MIME_SIZE; i1++) {
    if (!strcmp(mime, MimeNames_(i1))) {
      return i1;
    }
  }

  return 0;
}

int status2int(char *status)
{
  if (!strcmp("Inactive", status))
    return STATUS_INACTIVE;
  else if (!strcmp("Active", status))
    return STATUS_ACTIVE;
  else if (!strcmp("Active (Remote)", status))
    return STATUS_REMOTE;
  else if (!strcmp("Remote", status))
    return STATUS_REMOTE;
  else if (!strcmp("Cloaked", status))
    return STATUS_CLOAKED;
  else if (!strcmp("Leeched", status))
    return STATUS_LEECHED;
  else if (!strcmp("Muzzled", status))
    return STATUS_MUZZLED;
  else if (!strcmp("Unknown", status))
    return STATUS_UNKNOWN;
  else
    return STATUS_UNKNOWN;
}

int timestamp2int(char* stamp) {
  if (!l_strcasecmp(stamp, _("None")))
    return TIME_NONE;
  else if (!l_strcasecmp(stamp, _("Hour:Minute")))
    return TIME_HOUR_MIN;
  else if (!l_strcasecmp(stamp, _("BeatTime")))
    return TIME_BEATTIME;
  else
    return TIME_HOUR_MIN_SEC;
}

int browser2int(char *browser)
{
  int i1;

  for (i1 = 0; i1 < BROWSER_NO; i1++) {
    if (!l_strcasecmp(browser, _(Browser[i1])))
      return i1;
  }
  return BROWSER_NONE;
}

int channelmode2int(char* mode) {
  if (*mode == '+') mode++;
  else if (*mode == '-') mode++;

  if (!l_strcasecmp(mode, "REGISTERED"))
    return CMODE_REGISTERED;
  else if (!l_strcasecmp(mode, "TOPIC"))
    return CMODE_TOPIC;
  else if (!l_strcasecmp(mode, "PRIVATE"))
    return CMODE_PRIVATE;
  else if (!l_strcasecmp(mode, "INVITE"))
    return CMODE_INVITE;
  else if (!l_strcasecmp(mode, "MODERATED"))
    return CMODE_MODERATED;
  else if (!l_strcasecmp(mode, "QUIET"))
    return CMODE_QUIET;
  else return 0;
}

char *LineSpeed(int no)
{
  switch (no) {
  case 0:
    return _("unknown");
  case 1:
    return _("14.4 kbps");
  case 2:
    return _("28.8 kbps");
  case 3:
    return _("33.6 kbps");
  case 4:
    return _("56 kbps");
  case 5:
    return _("64K ISDN");
  case 6:
    return _("128K ISDN");
  case 7:
    return _("Cable");
  case 8:
    return _("DSL");
  case 9:
    return _("T1");
  case 10:
    return _("T3+");
  default:
    return _("_unknown_");
  };
}

int verify_speed(int speed)
{
  if (speed < 0) speed = 0;
  else if (speed > 10) speed = 0;

  return speed;
}

char *MimeNames(int no)
{
  switch (no) {
  case MIME_NONE:
    return _("other");
  case MIME_MP3:
    return _("mp3");
  case MIME_AUDIO:
    return _("audio");
  case MIME_VIDEO:
    return _("video");
  case MIME_APPLICATION:
    return _("application");
  case MIME_IMAGE:
    return _("image");
  case MIME_TEXT:
    return _("text");
  default:
    return _("other");
  };
}
char *MimeNames_(int no)
{
  switch (no) {
  case MIME_NONE:
    return "other";
  case MIME_MP3:
    return "mp3";
  case MIME_AUDIO:
    return "audio";
  case MIME_VIDEO:
    return "video";
  case MIME_APPLICATION:
    return "application";
  case MIME_IMAGE:
    return "image";
  case MIME_TEXT:
    return "text";
  default:
    return "other";
  };
}

char *UserStatus(int status)
{
  switch (status) {
  case STATUS_INACTIVE:
    return _("Inactive");
  case STATUS_ACTIVE:
    return _("Active");
  case STATUS_REMOTE:
    return _("Remote");
  case STATUS_CLOAKED:
    return _("Cloaked");
  case STATUS_LEECHED:
    return _("Leeched");
  case STATUS_MUZZLED:
    return _("Muzzled");
  case STATUS_UNKNOWN:
    return _("Unknown");
  default:
    return _("Unknown");
  };
}

char* TimeStamp(int id) {
  switch (id) {
  case TIME_NONE:
    return _("None");
  case TIME_BEATTIME:
    return _("BeatTime");
  case TIME_HOUR_MIN:
    return _("Hour:Minute");
  case TIME_HOUR_MIN_SEC:
  default:
    return _("Hour:Minute:Second");
  }
  return "??";
}

char *WebBrowser(int browser)
{
  if ((browser < 0) || (browser > BROWSER_NO))
    return _(Browser[BROWSER_NONE]);
  return _(Browser[browser]);
}

char* ChannelMode(int id) {
  switch (id) {
  case CMODE_TOPIC:
    return "TOPIC";
  case CMODE_REGISTERED:
    return "REGISTERED";
  case CMODE_INVITE:
    return "INVITE";
  case CMODE_QUIET:
    return "QUIET";
  case CMODE_MODERATED:
    return "MODERATED";
  case CMODE_PRIVATE:
    return "PRIVATE";
  default:
    return "??";
  }
}

char* Level(int level) {
  switch (level) {
  case 0: return "Leech";
  case 1: return "User";
  case 2: return "Moderator";
  case 3: return "Administrator";
  case 4: return "Elite";
  }
  return "?level?";
};

char* LevelShort(int level) {
  switch (level) {
  case 0: return "Leech";
  case 1: return "User";
  case 2: return "Mod";
  case 3: return "Admin";
  case 4: return "Elite";
  }
  return "?level?";
};

int browser_running(int browser)
{
  struct stat st;
  char *command = NULL;
  int res = 0;

  switch (browser) {
  case BROWSER_NETSCAPE:
    command = l_strdup_printf("%s/.netscape/lock", g_get_home_dir());
    if (lstat(command, &st) < 0)
      res = 0;
    else
      res = 1;
    break;
  case BROWSER_MOZILLA:
    break;
  case BROWSER_NONE:
  default:
    break;
  }

  if (command)
    l_free(command);
  return res;
}

char *browser_command(int browser)
{
  int exist;
  char *command = NULL;
  char *term = g_getenv("TERM");
  static char *default_term = "xterm";

  if (!term || !(*term))
    term = default_term;

  exist = browser_running(browser);

  switch (browser) {
  case BROWSER_NETSCAPE:
    if (exist)
      command = l_strdup("netscape -remote 'openURL(%s, new-window)'");
    else
      command = l_strdup("netscape \"%s\"");
    break;
  case BROWSER_MOZILLA:
    command = l_strdup("mozilla \"%s\"");
    break;
  case BROWSER_LYNX:
    command = l_strdup_printf("%s -e lynx \"%%s\"", term);
    break;
  case BROWSER_W3M:
    command = l_strdup_printf("%s -e w3m \"%%s\"", term);
    break;
  case BROWSER_OPERA:
    command = l_strdup_printf("opera \"%%s\"");
    break;
  case BROWSER_NONE:
  default:
    break;
  }
  return command;
}

void browse_url(char *url)
{
  char *command = NULL;
  char *pattern;
  int i;
  gchar *argv[4];
  gint pid;

  pattern = browser_command(global.options.browser);
  if (!pattern)
    return;

  command = l_strdup_printf(pattern, url);
  l_free(pattern);

  pid = fork();
  if (pid == 0) {
    argv[0] = "sh";
    argv[1] = "-c";
    argv[2] = command;
    argv[3] = 0;
    for (i = 3; i < 256; i++)
      close(i);
    setsid();
    execve("/bin/sh", argv, environ);
    exit(-1);
  }
  if (command) {
    //    printf("[%s]\n", command);
    l_free(command);
  }
}

int version_is_up_to_date(char *version)
{
  char *vers = l_strdup(version);
  char *pos;
  int res;

  if (strchr(VERSION, '-')) {	// local dev version
    if (!strcmp(vers, VERSION))
      res = 1;
    else
      res = 0;
  } else if ((pos = strchr(vers, '-'))) {	// remote dev version
    *pos = 0;
    if (!strcmp(vers, VERSION))
      res = 1;
    else
      res = 0;
  } else {
    if (!strcmp(vers, VERSION))
      res = 1;
    else
      res = 0;
  }

  l_free(vers);
  return res;
}

/*
int version_is_up_to_date2(char* version) {
  int l1 = strlen(version);
  int l2 = strlen(VERSION);

  if (l1 < l2) l2 = l1;
  //  printf("comp %d bytes [%s][%s]\n", l1, version, VERSION);
  if (!strncmp(version, VERSION, l2)) return 1;
  else return 0;
}
*/
int guess_mime(char *suffix)
{
  if (!l_strcasecmp(suffix, "mp3"))
    return MIME_MP3;
  else if (!l_strcasecmp(suffix, "wav"))
    return MIME_AUDIO;
  else if (!l_strcasecmp(suffix, "au"))
    return MIME_AUDIO;
  else if (!l_strcasecmp(suffix, "ogg"))
    return MIME_AUDIO;
  else if (!l_strcasecmp(suffix, "mpg"))
    return MIME_VIDEO;
  else if (!l_strcasecmp(suffix, "mpeg"))
    return MIME_VIDEO;
  else if (!l_strcasecmp(suffix, "avi"))
    return MIME_VIDEO;
  else if (!l_strcasecmp(suffix, "asf"))
    return MIME_VIDEO;
  else if (!l_strcasecmp(suffix, "rm"))
    return MIME_VIDEO;
  else if (!l_strcasecmp(suffix, "ram"))
    return MIME_VIDEO;
  else if (!l_strcasecmp(suffix, "mov"))
    return MIME_VIDEO;
  else if (!l_strcasecmp(suffix, "wmf"))
    return MIME_VIDEO;
  else if (!l_strcasecmp(suffix, "bmp"))
    return MIME_IMAGE;
  else if (!l_strcasecmp(suffix, "pgn"))
    return MIME_IMAGE;
  else if (!l_strcasecmp(suffix, "jpg"))
    return MIME_IMAGE;
  else if (!l_strcasecmp(suffix, "jpeg"))
    return MIME_IMAGE;
  else if (!l_strcasecmp(suffix, "gif"))
    return MIME_IMAGE;
  else if (!l_strcasecmp(suffix, "tiff"))
    return MIME_IMAGE;
  else if (!l_strcasecmp(suffix, "tif"))
    return MIME_IMAGE;
  else if (!l_strcasecmp(suffix, "xpm"))
    return MIME_IMAGE;
  else if (!l_strcasecmp(suffix, "ps"))
    return MIME_TEXT;
  else if (!l_strcasecmp(suffix, "txt"))
    return MIME_TEXT;
  else if (!l_strcasecmp(suffix, "doc"))
    return MIME_TEXT;
  else if (!l_strcasecmp(suffix, "dvi"))
    return MIME_TEXT;
  else if (!l_strcasecmp(suffix, "lyx"))
    return MIME_TEXT;
  else if (!l_strcasecmp(suffix, "pdf"))
    return MIME_TEXT;
  else if (!l_strcasecmp(suffix, "gz"))
    return MIME_APPLICATION;
  else if (!l_strcasecmp(suffix, "iso"))
    return MIME_APPLICATION;
  else if (!l_strcasecmp(suffix, "zip"))
    return MIME_APPLICATION;
  else if (!l_strcasecmp(suffix, "bz2"))
    return MIME_APPLICATION;
  else if (!l_strcasecmp(suffix, "exe"))
    return MIME_APPLICATION;
  else if (!l_strcasecmp(suffix, "dll"))
    return MIME_APPLICATION;
  else if (!l_strcasecmp(suffix, "deb"))
    return MIME_APPLICATION;
  else if (!l_strcasecmp(suffix, "rpm"))
    return MIME_APPLICATION;
  else
    return -1;
}

int find_valid_bitrate(int bitrate)
{
  int i1;
  const int BitRate[18] = {
    8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, 192, 224,
    256, 320
  };
  for (i1 = 0; i1 < 18; i1++) {
    if (bitrate <= BitRate[i1])
      return BitRate[i1];
  }
  return 32;
}

int get_beats(time_t tim)
{
  double beats;
  long h2;
  struct tm *gtime;

  tim += 3600;
  gtime = gmtime(&tim);

  h2 = (60 * gtime->tm_hour + gtime->tm_min) * 60 + gtime->tm_sec;
  beats = h2 / 86.4;

  return beats;
}

char *current_time(char *stime, int mode)
{
  struct tm *ltime;

  ltime = localtime(&global.current_time);

  switch (mode) {
  case TIME_HOUR_MIN:
    sprintf(stime, "[%s%d:%s%d] ",
	    (ltime->tm_hour < 10) ? "0" : "", ltime->tm_hour,
	    (ltime->tm_min < 10) ? "0" : "", ltime->tm_min);
    break;
  case TIME_BEATTIME:
    sprintf(stime, "[%3d] ", get_beats(global.current_time));
    break;
  case TIME_HOUR_MIN_SEC:
  default:
    sprintf(stime, "[%s%d:%s%d:%s%d] ",
	    (ltime->tm_hour < 10) ? "0" : "", ltime->tm_hour,
	    (ltime->tm_min < 10) ? "0" : "", ltime->tm_min,
	    (ltime->tm_sec < 10) ? "0" : "", ltime->tm_sec);
    break;
  }

  return stime;
}

char *ntoa(unsigned int ip)
{
  struct in_addr a;

  memset(&a, 0, sizeof(a));
  a.s_addr = ip;
  return (inet_ntoa(a));
}

int directory_exists(char *dir)
{
  struct stat st;

  if (stat(dir, &st) < 0)
    return 0;
  else
    return 1;
}

void create_dir(char *dir)
{
  char *pos;
  char *slash;

  if (!dir)
    return;

  slash = dir;
  while ((pos = strchr(slash + 1, '/')) != NULL) {
    pos[0] = 0;
    if (!directory_exists(dir)) {
      if (mkdir(dir, 7 * 64 + 5 * 8 + 5)) {
	printf("Could not create folder [%s]\n", dir);
	return;
      }
    }
    pos[0] = '/';
    slash = pos;
  }
  if (!directory_exists(dir)) {
    if (mkdir(dir, 7 * 64 + 5 * 8 + 5)) {
      printf("Could not create folder [%s]\n", dir);
      return;
    }
  }
}

void sigpipe_handler(int val)
{
  printf("sigpipe: Broken pipe: %d\n", val);
}

void sigseg_handler(int val)
{
  static volatile int cnt = 0;

  cnt++;
  switch (cnt) {
  case 1:
    printf("sigseg: segmentation fault: %d\n", val);
    if (global.status.rc_read)
      printf("sigseg: rc-file was read\n");
    else {
      printf(_("sigseg: rc-file was *NOT* read\n"));
      printf(_("sigseg: last line read: [%s]\n"), rc_line);
      printf(_("sigseg: It seems to be an upgrade problem\n"));
      printf(_("sigseg: Please report this problem (this output and a backtrace if you know something about)\n"));
      printf(_("sigseg: Deleting (renaming) the rcfile (%s) should solve the problem\n"),
	     global.options.config_file);
    }
    if (global.status.geometry_read)
      printf("sigseg: geometry was read\n");
    else
      printf("sigseg: geometry was *NOT* read\n");
    if (global.status.access_read)
      printf("sigseg: access list was read\n");
    else
      printf("sigseg: access list was *NOT* read\n");
    if (global.status.search_read)
      printf("sigseg: search patterns were read\n");
    else
      printf("sigseg: search patterns weren *NOT* read\n");

    printf(_("sigseg: please report the reason if you know\n"));
    printf("--------------------------------------------------\n");
    printf(_("sigseg: trying to do normal exit\n"));
    if (global.status.rc_read) {
      global_exit();
    } else {
      gtk_exit(-1);
    }
    break;
  case 2:
    printf(_("sigseg: normal exit failed\n"));
    if (global.status.geometry_read) {
      printf(_("sigseg: trying to save geometry\n"));
      write_geometry();
      printf(_("sigseg: geometry saved\n"));
    }
    cnt++;
    if (global.status.rc_read) {
      printf(_("sigseg: trying to save rc-file\n"));
      write_rc();
      printf(_("sigseg: rc-file saved\n"));
    }
    cnt++;
    printf(_("sigseg: trying to log statistic\n"));
    statistic_log(&global.statistic);
    printf(_("sigseg: statistic logged, exiting...\n"));
    cnt++;
    gtk_exit(-2);
    break;
  case 3:
    printf(_("sigseg: saving geometry failed, force exit\n"));
    exit(-3);
    break;
  case 4:
    printf(_("sigseg: saving rc-file failed, force exit\n"));
    exit(-4);
    break;
  case 5:
    printf(_("sigseg: logging statistic failed, force exit\n"));
    exit(-5);
    break;
  case 6:
  default:
    printf(_("sigseg: forcing exit\n"));
    exit(-7);
  }
}

void sigchld_handler(int val ATTR_UNUSED)
{
  //  printf("sigchld: %d\n", val);
}

void update_status_line(int highlight)
{
  GtkWidget *temp;
  char t[1024];

  // user
  temp = lookup_widget(global.win, "label271");
  if (SERVER && SERVER->nick)
    gtk_label_set_text(GTK_LABEL(temp), SERVER->nick);
  else
    gtk_label_set_text(GTK_LABEL(temp), global.user.username);
  temp = lookup_widget(global.win, "label272");
  gtk_label_set_text(GTK_LABEL(temp), LevelShort(global.user.level));
  temp = lookup_widget(global.win, "label273");
  gtk_label_set_text(GTK_LABEL(temp), UserStatus(global.user.status));
  temp = lookup_widget(global.win, "label274");
  if (global.reply)
    sprintf(t, _("Reply: %s"), global.reply);
  else
    sprintf(t, _("Reply: <None>"));
  gtk_label_set_text(GTK_LABEL(temp), t);
  gtk_widget_set_style(temp, global.style[highlight]);

  // server
  if (SERVER && (global.status.connection == 2)) {
    temp = lookup_widget(global.win, "label275");
    gtk_label_set_text(GTK_LABEL(temp),
		       SERVER->description ? SERVER->description : "???");
    temp = lookup_widget(global.win, "label278");
    if (SERVER->network == N_OPENNAP) {
      sprintf(t, "%s %d.%d", Network[SERVER->network], SERVER->major, SERVER->minor);
      gtk_label_set_text(GTK_LABEL(temp), t);
    } else if (SERVER->network == N_SLAVANAP) {
      sprintf(t, "%s %d.%d.%d", Network[SERVER->network], 
	      SERVER->major, SERVER->minor, SERVER->micro);
      gtk_label_set_text(GTK_LABEL(temp), t);
    } else if (SERVER->network == N_CQ_NAP) {
      sprintf(t, "%s %d.%s%d", Network[SERVER->network], 
	      SERVER->major, SERVER->minor<10?"0":"", SERVER->minor);
      gtk_label_set_text(GTK_LABEL(temp), t);
    } else {
      gtk_label_set_text(GTK_LABEL(temp), Network[SERVER->network]);
    }
  } else {
    temp = lookup_widget(global.win, "label275");
    gtk_label_set_text(GTK_LABEL(temp), _("Not connected"));
    temp = lookup_widget(global.win, "label278");
    gtk_label_set_text(GTK_LABEL(temp), "???");

    // clear server stats
    temp = lookup_widget(global.win, "label280");
    gtk_label_set_text(GTK_LABEL(temp), _("Users"));
    temp = lookup_widget(global.win, "label281");
    gtk_label_set_text(GTK_LABEL(temp), _("Files"));
    temp = lookup_widget(global.win, "label282");
    gtk_label_set_text(GTK_LABEL(temp), _("GB"));
  }
}

/*
char* strcasestr(char *str, char *sub) {
  char* p;
  char* startn = NULL;
  char* *np = NULL;

  for (p = str; *p; p++) {
    if (np) {
      if (toupper(*p) == toupper(*np)) {
	if (!*++np)
	  return startn;
      } else np = NULL;
    } else if (toupper(*p) == toupper(*sub)) {
      np = sub + 1;
      startn = p;
    }
  }
  
  return NULL;
}
*/

char *strcasestr(char *str, char *sub)
{
  int len;
  int max_pos;
  int str_pos;
  int sub_pos;

  if (!str || !sub)
    return NULL;

  len = strlen(sub);
  max_pos = strlen(str) - len;
  str_pos = 0;
  sub_pos = 0;
  while (str_pos <= max_pos) {
    while (toupper(str[str_pos + sub_pos]) == toupper(sub[sub_pos])) {
      sub_pos++;
      if (sub_pos == len)
	return &(str[str_pos]);
    }
    str_pos++;
    sub_pos = 0;
  }

  return NULL;
}

int idle_function(gpointer data ATTR_UNUSED)
{
  GtkWidget *temp;

  gtk_timeout_add(600000, remove_dead_transfers, NULL);
  gtk_timeout_add(1200000, channel_refresh, NULL);
  //  gtk_timeout_add(3600000, user_info_cleanup, NULL);
  global.timer = gtk_timeout_add(1000, global_timer, NULL);

  global.resume_timer =
    gtk_timeout_add(global.options.resume_timeout * 60 * 1000, resume_timer,  NULL);

  if (global.options.auto_connect) {
    on_connect_activate(NULL, NULL);
    temp = lookup_widget(global.connect_win, "combo_entry12");
    gtk_entry_set_text(GTK_ENTRY(temp), _("Last Server"));
    on_connection_ok_clicked(NULL, NULL);
  }

  if (global.options.check_version == 1) {
    //    printf("version checker\n");
    latest_version_get(0);
  }

  if (!global.auto_save || !lib_load(global.auto_save, 0))
    lib_refresh();

  return 0;
}

////////////////////////////////////////////////////
// geometry stuff
////////////////////////////////////////////////////

void geo_error(int cnt, char *line)
{
  printf(_("unparsable line %d in geometry file: [%s]\n"), cnt, line);
}

char *is_clist(char *line)
{
  if (!strncasecmp(line, "DOWNLOAD_COLUMN", 15)) {
    return "ctree4";
  } else if (!strncasecmp(line, "RESUME_COLUMN", 13)) {
    return "ctree5";
  } else if (!strncasecmp(line, "UPLOAD_COLUMN", 13)) {
    return "transfer_up";
  } else if (!strncasecmp(line, "BROWSE_COLUMN", 13)) {
    return (char *) 3;
  } else if (!strncasecmp(line, "SEARCH_COLUMN", 13)) {
    return (char *) 2;
  } else if (!strncasecmp(line, "LIB_COLUMN", 10)) {
    return "lib_tree";
  } else if (!strncasecmp(line, "CHANNEL_COLUMN", 14)) {
    return "channel_list";
  } else if (!strncasecmp(line, "SERVER_COLUMN", 13)) {
    return "server_ctree";
  } else if (!strncasecmp(line, "SELECTED_COLUMN", 15)) {
    return "clist11";
  } else if (!strncasecmp(line, "HISTORY_COLUMN", 14)) {
    return "clist34";
  } else if (!strncasecmp(line, "HOTLIST_COLUMN", 14)) {
    return "clist16";
  } else if (!strncasecmp(line, "ACCESS_COLUMN", 13)) {
    return "ctree3";
  } else if (!strncasecmp(line, "ONLINE_COLUMN", 13)) {
    return (char *) 1;
  } else {
    return NULL;
  }
}
char *is_paned(char *line)
{
  if (!strncasecmp(line, "SERVER_PANED_POS", 16)) {
    return "vpaned2";
  } else if (!strncasecmp(line, "HOT_PANED_POS", 13)) {
    return "hpaned1";
  } else if (!strncasecmp(line, "STATISTIC_PANED_POS", 19)) {
    return "hpaned3";
  } else if (!strncasecmp(line, "ONLINE_PANED_POS", 16)) {
    return (char *) 1;
  } else if (!strncasecmp(line, "WALLOP_PANED_POS", 16)) {
    return (char *) 2;
  } else {
    return NULL;
  }
}

void read_geometry()
{
  char File[1024];
  FILE *file;
  char line[500];
  char *pos1;
  char *pos2;
  char *pos3;
  int line_cnt;
  GtkCList *clist = NULL;
  int online;
  GtkWidget *temp = NULL;

  strcpy(File, global.options.config_dir);
  strcat(File, "/geometry");

  if ((file = fopen(File, "r")) == NULL) {
    global.status.geometry_read = 1;
    return;
  }

  line_cnt = 0;
  while (fgets(line, 400, file)) {
    line_cnt++;
    (strchr(line, '\n'))[0] = 0;
    if ((line[0] == '#') || (line[0] == ' ') || (line[0] == 0)) {
    } else if (!strncasecmp(line, "POSITION", 8)) {
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2 = strrchr(pos1 + 1, ' ');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2[0] = 0;
      gtk_widget_set_uposition(global.win, atoi(pos1 + 1), atoi(pos2 + 1));
    } else if (!strncasecmp(line, "SIZE", 4)) {
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2 = strrchr(pos1 + 1, ' ');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2[0] = 0;
      gtk_window_set_default_size(GTK_WINDOW(global.win),
				  atoi(pos1 + 1), atoi(pos2 + 1));
    } else if (!strncasecmp(line, "DETACHED", 8)) {
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      global.extra_win = atoi(pos1 + 1);
    } else if (!strncasecmp(line, "GEOMETRY", 8)) {
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2 = strchr(pos1 + 1, ',');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      global.geometry[atoi(pos1 + 1)].x = atoi(pos2 + 1);
      pos2 = strchr(pos2 + 1, ',');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      global.geometry[atoi(pos1 + 1)].y = atoi(pos2 + 1);
      pos2 = strchr(pos2 + 1, ',');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      global.geometry[atoi(pos1 + 1)].width = atoi(pos2 + 1);
      pos2 = strchr(pos2 + 1, ',');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      global.geometry[atoi(pos1 + 1)].height = atoi(pos2 + 1);
    } else if ((pos1 = is_paned(line)) != NULL) {
      if (pos1 == (char *) 1)
	online = 1;
      else if (pos1 == (char *) 2)
	online = 2;
      else {
	online = 0;
	temp = lookup_widget(global.win, pos1);
      }
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      if (online == 1)
	global.paned_pos = atoi(pos1 + 1);
      else if (online == 2)
	global.paned_pos2 = atoi(pos1 + 1);
      else
      gtk_paned_set_position(GTK_PANED(temp), atoi(pos1 + 1));
    } else if ((pos1 = is_clist(line)) != NULL) {
      if (pos1 == (char *) 1)
	online = 1;
      else if (pos1 == (char *) 2)
	online = 2;
      else if (pos1 == (char *) 3)
	online = 3;
      else {
	online = 0;
	clist = GTK_CLIST(lookup_widget(global.win, pos1));
      }
      pos1 = strchr(line, '=');
      if (!pos1) {
	geo_error(line_cnt, line);
	continue;
      }
      pos2 = strchr(pos1 + 1, ',');
      if (!pos2) {
	geo_error(line_cnt, line);
	continue;
      }
      if (online == 1)
	global.online_width[atoi(pos1 + 1)] = atoi(pos2 + 1);
      else
    if (online == 2)
      global.search_width[atoi(pos1 + 1)] = atoi(pos2 + 1);
      else
    if (online == 3)
      global.browse_width[atoi(pos1 + 1)] = atoi(pos2 + 1);
      else
      gtk_clist_set_column_width(clist, atoi(pos1 + 1), atoi(pos2 + 1));
      pos3 = strchr(pos2 + 1, ',');
      if (pos3) {
	if (online == 1) {
	  global.online_show[atoi(pos1 + 1)] = atoi(pos3 + 1);
	} else if (online == 2) {
	  global.search_show[atoi(pos1 + 1)] = atoi(pos3 + 1);
	} else if (online == 3) {
	  global.browse_show[atoi(pos1 + 1)] = atoi(pos3 + 1);
	} else {
	  gtk_clist_set_column_visibility(clist, atoi(pos1 + 1),
					  atoi(pos3 + 1));
	}
      }
    } else {
      geo_error(line_cnt, line);
    }
  }
  global.status.geometry_read = 1;
  fclose(file);
}

void write_geometry()
{
  char filename[1024];
  FILE *fd;
  GtkCList *clist;
  GtkPaned *paned;
  int i1;
  int x = 0;
  int y = 0;

  sprintf(filename, "%s/geometry", global.options.config_dir);

  if ((fd = fopen(filename, "w")) == NULL) {
    g_warning(_("could not save geometry"));
    return;
  }

  if (global.win->window) {
    gdk_window_get_origin(global.win->window, &x, &y);
    fprintf(fd, "POSITION=%d %d\n", x, y);
  } else {
    g_warning("write_geometry: global.win->window == NULL");
  }

  fprintf(fd, "SIZE=%d %d\n", global.win->allocation.width,
	  global.win->allocation.height);
  fprintf(fd, "DETACHED=%d\n", global.extra_win);

  for (i1 = 0; i1 < G_SIZE; i1++) {
    fprintf(fd, "GEOMETRY=%d,%d,%d,%d,%d\n", i1,
	    global.geometry[i1].x, global.geometry[i1].y,
	    global.geometry[i1].width, global.geometry[i1].height);
  }

  clist = GTK_CLIST(lookup_widget(global.win, "ctree4"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "DOWNLOAD_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "ctree5"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "RESUME_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "UPLOAD_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  for (i1 = 0; i1 < 5; i1++) {
    fprintf(fd, "BROWSE_COLUMN=%d,%d,%d\n", i1,
	    global.browse_width[i1], global.browse_show[i1]);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "clist16"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "HOTLIST_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "lib_tree"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "LIB_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "channel_list"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "CHANNEL_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "server_ctree"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "SERVER_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "clist11"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "SELECTED_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "clist34"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "HISTORY_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }
  for (i1 = 0; i1 < 3; i1++) {
    fprintf(fd, "ONLINE_COLUMN=%d,%d,%d\n", i1,
	    global.online_width[i1], global.online_show[i1]);
  }
  for (i1 = 0; i1 < 7; i1++) {
    fprintf(fd, "SEARCH_COLUMN=%d,%d,%d\n", i1,
	    global.search_width[i1], global.search_show[i1]);
  }
  clist = GTK_CLIST(lookup_widget(global.win, "ctree3"));
  for (i1 = 0; i1 < clist->columns; i1++) {
    fprintf(fd, "ACCESS_COLUMN=%d,%d,%d\n", i1,
	    clist->column[i1].width, clist->column[i1].visible);
  }

  fprintf(fd, "ONLINE_PANED_POS=%d\n", global.paned_pos);
  fprintf(fd, "WALLOP_PANED_POS=%d\n", global.paned_pos2);

  paned = GTK_PANED(lookup_widget(global.win, "vpaned2"));
  fprintf(fd, "SERVER_PANED_POS=%d\n", paned->child1_size);

  paned = GTK_PANED(lookup_widget(global.win, "hpaned1"));
  fprintf(fd, "HOT_PANED_POS=%d\n", paned->child1_size);

  paned = GTK_PANED(lookup_widget(global.win, "hpaned3"));
  fprintf(fd, "STATISTIC_PANED_POS=%d\n", paned->child1_size);

  fclose(fd);
}

////////////////////////////////////////////////////
// rcfile stuff
////////////////////////////////////////////////////

void read_rc()
{
  FILE *file;
  char *pos1;
  char *pos2;
  char *pos3;
  int section = 0;
  server_t *server;
  GtkWidget *temp;
  int changes = 1;
  int usermode_set = 0;
  char scheme[1024] = "";
  int line = 0;

  if ((file = fopen(global.options.config_file, "r")) == NULL) {
    g_warning(_("could not load rc-file [%s]"), global.options.config_file);
    changes = 0;
    wizard_start();
    //    on_preferences_activate(NULL, NULL);
  } else {
    while (fgets(rc_line, 2048, file)) {
      line++;
      pos1 = strchr(rc_line, '\n');
      if (!pos1) {
	printf("line %d in rc-file [%s] too long, exiting\n", line,
	       global.options.config_file);
	exit(1);
      }
      *pos1 = 0;
      if ((rc_line[0] == '#') || (rc_line[0] == ' ') || (rc_line[0] == 0)) {
      } else if (!strncasecmp(rc_line, "Section", 7)) {
	pos1 = strchr(rc_line, '[') + 1;
	pos2 = strrchr(rc_line, ']');
	pos2[0] = 0;
	if (!l_strcasecmp(pos1, "User"))
	  section = 1;
	else if (!l_strcasecmp(pos1, "Path"))
	  section = 2;
	else if (!l_strcasecmp(pos1, "Network"))
	  section = 3;
	else if (!l_strcasecmp(pos1, "Hotlist"))
	  section = 4;
	else if (!l_strcasecmp(pos1, "Server"))
	  section = 5;
	else if (!l_strcasecmp(pos1, "Chat"))
	  section = 6;
	else if (!l_strcasecmp(pos1, "Buttons"))
	  section = 7;
	else if (!l_strcasecmp(pos1, "Global"))
	  section = 8;
	else if (!l_strcasecmp(pos1, "Library"))
	  section = 9;
	else {
	  g_warning("unknown section in rc-file [%s]", pos1);
	}
      } else if (section == 1) {
	if (!strncasecmp(rc_line, "NAME", 4)) {
	  strcpy(global.user.username, &rc_line[5]);
	} else if (!strncasecmp(rc_line, "PASSWORD", 8)) {
	  strcpy(global.user.password, &rc_line[9]);
	} else if (!strncasecmp(rc_line, "EMAIL", 5)) {
	  strcpy(global.user.email, &rc_line[6]);
	} else if (!strncasecmp(rc_line, "MODE", 4)) {
	  make_list_from_string(&global.usermode, rc_line + 5, " ");
	  usermode_set = 1;
	} else {
	  g_warning(_("unknown tag in section USER [%s]"), rc_line);
	}
      } else if (section == 2) {
	if (!strncasecmp(rc_line, "DOWNLOAD", 8)) {
	  int i1;
	  pos1 = strchr(rc_line, '=') + 1;
	  if (!isdigit((int) (*pos1))) {	// backward compatible
	    i1 = MIME_MP3;
	    pos2 = pos1;
	  } else {
	    pos2 = strchr(pos1, ':');
	    *pos2 = 0;
	    pos2++;
	    i1 = atoi(pos1);
	  }
	  if (global.mimetype[i1].download)
	    l_free(global.mimetype[i1].download);
	  global.mimetype[i1].download = l_strdup(pos2);
	} else if (!strncasecmp(rc_line, "INCOMPLETE", 10)) {
	  global.incomplete_path = l_strdup(&rc_line[11]);
	} else if (!strncasecmp(rc_line, "SUFFIX", 6)) {
	  int i1;
	  suffix_t *suffix;

	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = strchr(pos1, ':');
	  *pos2 = 0;
	  pos2++;
	  i1 = atoi(pos1);
	  pos1 = strchr(pos2, ':');
	  *pos1 = 0;
	  pos1++;
	  pos3 = strchr(pos1, ':');

	  suffix = (suffix_t *) l_malloc(sizeof(suffix_t));
	  suffix->suffix = l_strdup(pos2);
	  if (pos3) {
	    *pos3 = 0;
	    pos3++;
	    suffix->as_mp3 = atoi(pos3);
	  }
	  if (i1 == MIME_MP3)
	    suffix->as_mp3 = 1;
	  suffix->application = l_strdup(pos1);

	  global.mimetype[i1].suffixes =
	      g_list_append(global.mimetype[i1].suffixes, suffix);
	} else if (!strncasecmp(rc_line, "SHARED", 6)) {
	  int i1;
	  pos1 = strchr(rc_line, '=') + 1;
	  if (!isdigit((int) (*pos1))) {	// backward compatible
	    i1 = MIME_MP3;
	    pos2 = pos1;
	  } else {
	    pos2 = strchr(pos1, ':');
	    *pos2 = 0;
	    pos2++;
	    i1 = atoi(pos1);
	  }
	  global.mimetype[i1].shared =
	      g_list_append(global.mimetype[i1].shared, l_strdup(pos2));
	} else {
	  g_warning(_("unknown tag in section PATH [%s]"), rc_line);
	}
      } else if (section == 3) {
	if (!strncasecmp(rc_line, "LINESPEED", 9)) {
	  sscanf(rc_line + 10, "%d", &(global.user.linespeed));
	} else if (!strncasecmp(rc_line, "PORT", 4)) {
	  sscanf(rc_line + 5, "%d", &(global.network.port));
	} else if (!strncasecmp(rc_line, "ALLOWEDPORTS", 12)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.allowed_ports = create_allowed_ports(pos1);
	} else if (!strncasecmp(rc_line, "MAX_DOWNLOADS", 13)) {
	  sscanf(rc_line + 14, "%d", &(global.limit.max_downloads));
	} else if (!strncasecmp(rc_line, "MAX_UPLOADS", 11)) {
	  sscanf(rc_line + 12, "%d", &(global.limit.max_uploads));
	} else if (!strncasecmp(rc_line, "MAX_LARGE", 9)) {
	  sscanf(rc_line + 10, "%d", &(global.limit.max_large));
	} else if (!strncasecmp(rc_line, "LARGE_SIZE", 10)) {
	  sscanf(rc_line + 11, "%d", &(global.limit.large_size));
	} else if (!strncasecmp(rc_line, "DEFAULT_DOWNLOADS", 17)) {
	  sscanf(rc_line + 18, "%d", &(global.limit.default_downloads));
	} else if (!strncasecmp(rc_line, "DEFAULT_UPLOADS", 15)) {
	  sscanf(rc_line + 16, "%d", &(global.limit.default_uploads));
	} else if (!strncasecmp(rc_line, "AutoRetry", 9)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.auto_retry = atoi(pos1);
	} else if (!strncasecmp(rc_line, "DOWNLOAD_PERCENT", 16)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.limit.download_percent = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ResumeAbort", 11)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos1 = arg(pos1, 0);
	  if (pos1) global.options.resume_abort[0] = atoi(pos1);
	  pos1 = arg(NULL, 0);
	  if (pos1) global.options.resume_abort[1] = atoi(pos1);
	  pos1 = arg(NULL, 0);
	  if (pos1) global.options.resume_abort[2] = atoi(pos1);
	  pos1 = arg(NULL, 0);
	  if (pos1) global.options.resume_abort[3] = atoi(pos1);
	} else if (!strncasecmp(rc_line, "FIREWALL", 8)) {
	  sscanf(rc_line + 9, "%d", &(global.network.firewall));
	} else if (!strncasecmp(rc_line, "AutoConnect", 11)) {
	  sscanf(rc_line + 12, "%d", &(global.options.auto_connect));
	} else if (!strncasecmp(rc_line, "TransferTimeout", 15)) {
	  sscanf(rc_line + 16, "%d", &(global.network.transfer_timeout));
	} else if (!strncasecmp(rc_line, "DLAutoremove", 12)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.dl_autoremove = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ULAutoremove", 12)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.ul_autoremove = atoi(pos1);
	} else if (!strncasecmp(rc_line, "TransferUpdate", 14)) {
	  sscanf(rc_line + 15, "%d", &(global.network.transfer_delay));
	  if (global.network.transfer_delay <= 0)
	    global.network.transfer_delay = 1;
	} else if (!strncasecmp(rc_line, "AllowDCC", 8)) {
	  sscanf(rc_line + 9, "%d", &(global.options.allow_dcc));
	} else if (!strncasecmp(rc_line, "DownloadBandwidth", 17)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = strchr(pos1, ':');
	  *pos2 = 0;
	  pos2++;
	  global.down_width.limit = atoi(pos1);
	  global.down_width.maxval = atoi(pos2);
	} else if (!strncasecmp(rc_line, "UploadBandwidth", 15)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = strchr(pos1, ':');
	  *pos2 = 0;
	  pos2++;
	  global.up_width.limit = atoi(pos1);
	  global.up_width.maxval = atoi(pos2);
	} else if (!strncasecmp(rc_line, "AutoSearch", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.auto_search = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ResumeTimeout", 13)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.resume_timeout = atoi(pos1);
	} else if (!strncasecmp(rc_line, "AdvancedUpload", 14)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.advanced_upload = atoi(pos1);
	} else if (!strncasecmp(rc_line, "AutoresumeDownload", 18)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.autoresume_download = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ConfirmDelete", 13)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.confirm_delete = atoi(pos1);
	} else if (!strncasecmp(rc_line, "CheckLibForDownload", 19)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.check_lib_for_download = atoi(pos1);
	} else if (!strncasecmp(rc_line, "EmulateWinMX", 12)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.emulate_winmx = atoi(pos1);
        } else if (!strncasecmp(rc_line, "TransferSpeedLights", 19)) {
          // Weasel75
	  pos1 = strchr(rc_line, '=');
          if (!pos1 || sscanf(pos1+1, "%d %d %d",
			      &(global.options.speedred),
			      &(global.options.speedyellow),
			      &(global.options.speedgreen) ) != 3)
            { // load failed (malformed string), so use defaults
	      // normally in read_rc default values are not set
              global.options.speedred    = SPEED_RED;
              global.options.speedyellow = SPEED_YELLOW;
              global.options.speedgreen  = SPEED_GREEN;
            }
	} else {
	  g_warning(_("unknown tag in section NETWORK [%s]"), rc_line);
	}
      } else if (section == 4) {
	if (!strncasecmp(rc_line, "USER", 4)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = strchr(pos1, ':');
	  if (pos2 && (*pos2)) {
	    *pos2 = 0;
	    pos2++;
	  } else
	    pos2 = NULL;
	  hotlist_add(pos1, pos2, 1);
	} else if (!strncasecmp(rc_line, "ShortNames", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  temp = lookup_widget(global.win, "checkbutton18");
	  if (atoi(pos1))
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
	  else
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
	} else {
	  g_warning(_("unknown tag in section HOTLIST [%s]"), rc_line);
	}
      } else if (section == 5) {
	if (!strncasecmp(rc_line, "Server", 6)) {
	  server = server_new();
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = strchr(pos1, ':');
	  *pos2 = 0;
	  server_set_address(server, pos1);
	  pos1 = pos2 + 1;
	  pos2 = strchr(pos1, ':');
	  *pos2 = 0;
	  sscanf(pos1, "%d", &(server->port));
	  pos1 = pos2 + 1;
	  pos2 = strchr(pos1, ':');
	  *pos2 = 0;
	  server_set_description(server, pos1);
	  pos1 = pos2 + 1;
	  pos2 = strchr(pos1, ':');
	  sscanf(pos1, "%d", &(server->meta));
	  *pos2 = 0;
	  pos1 = pos2 + 1;
	  pos2 = strchr(pos1, ':');
	  *pos2 = 0;
	  server->nick = l_strdup(pos1);
	  pos1 = pos2 + 1;
	  pos2 = strchr(pos1, ':');
	  if (pos1)
	    server->passwd = l_strdup(pos1);
	  else
	    server->passwd = l_strdup(global.user.password);
	  add_server_to_list(server);
	} else if (!strncasecmp(rc_line, "Last", 4)) {
	  server = server_new();
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = strchr(pos1, ':');
	  *pos2 = 0;
	  server_set_address(server, pos1);
	  pos1 = pos2 + 1;
	  pos2 = strchr(pos1, ':');
	  *pos2 = 0;
	  sscanf(pos1, "%d", &(server->port));
	  pos1 = pos2 + 1;
	  pos2 = strchr(pos1, ':');
	  *pos2 = 0;
	  server_set_description(server, pos1);
	  pos1 = pos2 + 1;
	  pos2 = strchr(pos1, ':');
	  sscanf(pos1, "%d", &(server->meta));
	  if (!pos2) {
	    server_destroy(server);
	  } else {
	    *pos2 = 0;
	    pos1 = pos2 + 1;
	    pos2 = strchr(pos1, ':');
	    *pos2 = 0;
	    server_set_nick(server, pos1);
	    pos1 = pos2 + 1;
	    pos2 = strchr(pos1, ':');
	    if (pos1)
	      server_set_passwd(server, pos1);
	    else
	      server_set_passwd(server, global.user.password);
	    global.last_server = server;
	  }
	} else {
	  g_warning(_("unknown tag in section SERVER [%s]"), rc_line);
	}
      } else if (section == 6) {
	if (!strncasecmp(rc_line, "Alias", 5)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = strchr(rc_line, ':');
	  pos2[0] = 0;
	  pos2++;
	  command_make_alias(pos2, pos1);
	} else if (!strncasecmp(rc_line, "Highlight", 9)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 0);
	  while (pos2) {
	    highlight_add(pos2);
	    pos2 = arg(NULL, 0);
	  }
	} else if (!strncasecmp(rc_line, "Friend", 6)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 0);
	  while (pos2) {
	    friend_add(pos2);
	    pos2 = arg(NULL, 0);
	  }
	} else if (!strncasecmp(rc_line, "Enemy", 5)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 0);
	  while (pos2) {
	    enemy_add(pos2);
	    pos2 = arg(NULL, 0);
	  }
	} else if (!strncasecmp(rc_line, "NoDownload", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 0);
	  while (pos2) {
	    nodownload_add(pos2);
	    pos2 = arg(NULL, 0);
	  }
	} else if (!strncasecmp(rc_line, "Scheme", 6)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  strcpy(scheme, pos1);
	} else if (!strncasecmp(rc_line, "ShowJoins", 9)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.show_joins = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ShowParts", 9)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.show_parts = atoi(pos1);
	} else if (!strncasecmp(rc_line, "RecentTimeout", 13)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.recent_timeout = atoi(pos1);
	} else if (!strncasecmp(rc_line, "PublicIgnore", 12)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.public_ignore = atoi(pos1);
	} else if (!strncasecmp(rc_line, "Channel", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 0);
	  while (pos2) {
	    autojoin_add(pos2);
	    pos2 = arg(NULL, 0);
	  }
	} else if (!strncasecmp(rc_line, "Logging", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.logging = atoi(pos1);
	} else if (!strncasecmp(rc_line, "LogExpire", 9)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.log_expire = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ColorParse", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.parse_color = atoi(pos1);
	} else if (!strncasecmp(rc_line, "Piping", 6)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.piping = atoi(pos1);
	} else if (!strncasecmp(rc_line, "NoPiping", 8)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.no_piping = atoi(pos1);
	} else if (!strncasecmp(rc_line, "TimeStamps", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.timestamps = atoi(pos1);
	} else if (!strncasecmp(rc_line, "RejoinOpen", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.channel_rejoin = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ColoredNicks", 12)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.colored_nicks = atoi(pos1);
	} else if (!strncasecmp(rc_line, "RejoinWhenKicked", 14)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.rejoin_when_kicked = atoi(pos1);
	} else {
	  g_warning(_("unknown tag in section CHAT [%s]"), rc_line);
	}
      } else if (section == 7) {
	if (!strncasecmp(rc_line, "Chat", 4)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  temp = lookup_widget(global.win, "button114");
	  set_button_state(temp, atoi(pos1));
	} else if (!strncasecmp(rc_line, "Connect", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.connect_button = atoi(pos1);
	} else if (!strncasecmp(rc_line, "Search0", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  temp = lookup_widget(global.win, "button115");
	  set_button_state(temp, atoi(pos1));
	} else if (!strncasecmp(rc_line, "Search1", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  temp = lookup_widget(global.win, "button330");
	  set_button_state(temp, atoi(pos1));
	} else if (!strncasecmp(rc_line, "Search2", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  temp = lookup_widget(global.win, "button331");
	  set_button_state(temp, atoi(pos1));
	} else {
	  g_warning(_("unknown tag in section BUTTONS [%s]"), rc_line);
	}
      } else if (section == 8) {
	if (!strncasecmp(rc_line, "Player", 6)) {	//backward 
	  suffix_t *suffix;

	  pos1 = strchr(rc_line, '=') + 1;
	  suffix = (suffix_t *) l_malloc(sizeof(suffix_t));
	  suffix->suffix = l_strdup("mp3");
	  suffix->application = l_strdup(pos1);
	  suffix->as_mp3 = 1;
	  global.mimetype[MIME_MP3].suffixes =
	      g_list_append(global.mimetype[MIME_MP3].suffixes, suffix);
	} else if (!strncasecmp(rc_line, "Version", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  if (!strcmp(pos1, VERSION))
	    changes = 0;
	} else if (!strncasecmp(rc_line, "PopupCreate", 11)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.popup_create = atoi(pos1);
	} else if (!strncasecmp(rc_line, "ClientInfo", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  if (global.clientinfo)
	    l_free(global.clientinfo);
	  global.clientinfo = l_strdup(pos1);
	} else if (!strncasecmp(rc_line, "Afk", 3)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  temp = lookup_widget(global.win, "entry50");
	  gtk_entry_set_text(GTK_ENTRY(temp), pos1);
	  temp = lookup_widget(global.win, "button125");
	  gtk_widget_set_sensitive(temp, FALSE);
	} else if (!strncasecmp(rc_line, "AutoReconnect", 13)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.auto_reconnect = atoi(pos1);
	} else if (!strncasecmp(rc_line, "AutoResume", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.auto_resume = atoi(pos1);
	} else if (!strncasecmp(rc_line, "PingResults", 11)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  temp = lookup_widget(global.win, "checkbutton45");
	  if (atoi(pos1))
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
	  else
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
	} else if (!strncasecmp(rc_line, "PingCommand", 11)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  if (global.ping_command)
	    l_free(global.ping_command);
	  global.ping_command = l_strdup(pos1);
	} else if (!strncasecmp(rc_line, "MAX_SEARCHES", 12)) {
	  sscanf(rc_line + 13, "%d", &(global.limit.max_searches));
	  global.limit.max_searches_real = global.limit.max_searches;
	} else if (!strncasecmp(rc_line, "DirectBrowse", 12)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  temp = lookup_widget(global.win, "checkbutton44");
	  if (atoi(pos1))
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
	  else
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
	} else if (!strncasecmp(rc_line, "RetryTimeout", 12)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 0);
	  if (pos2) global.options.retry_timeout[0] = atoi(pos2);
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.retry_timeout[1] = atoi(pos2);
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.retry_timeout[2] = atoi(pos2);
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.retry_timeout[3] = atoi(pos2);
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.retry_timeout[4] = atoi(pos2);
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.retry_timeout[5] = atoi(pos2);
	} else if (!strncasecmp(rc_line, "UploadPriority", 14)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  pos2 = arg(pos1, 0);
	  if (pos2) global.options.upload_priority[0] = atoi(pos2);
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.upload_priority[1] = atoi(pos2);
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.upload_priority[2] = atoi(pos2);
	  pos2 = arg(NULL, 0);
	  if (pos2) global.options.upload_priority[3] = atoi(pos2);
	} else if (!strncasecmp(rc_line, "NapigatorUseProxy", 17)) {
		pos1 = strchr(rc_line, '=') + 1;
		global.napigator.use_proxy = atoi(pos1);
	} else if (!strncasecmp(rc_line, "NapigatorProxyUrl", 17)) {
		pos1 = strchr(rc_line, '=') + 1;
		if (global.napigator.proxy_url){
			l_free(global.napigator.proxy_url);
		}
		global.napigator.proxy_url = l_strdup(pos1);
	} else if (!strncasecmp(rc_line, "NapigatorProxyPort", 18)) {
		pos1 = strchr(rc_line, '=') + 1;
		global.napigator.proxy_port = atoi(pos1);
	} else if (!strncasecmp(rc_line, "TabStyle", 8)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.tab_style = atoi(pos1);
	} else if (!strncasecmp(rc_line, "AccessTimeout", 13)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.access_timeout = atoi(pos1);
	} else if (!strncasecmp(rc_line, "AccessSave", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.access_save = atoi(pos1);
	} else if (!strncasecmp(rc_line, "CheckVersion", 12)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.check_version = atoi(pos1);
	} else if (!strncasecmp(rc_line, "TimeDisplay", 11)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.time_display = atoi(pos1);
	} else if (!strncasecmp(rc_line, "Browser", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.options.browser = atoi(pos1);
	} else if (!strncasecmp(rc_line, "IdleBar", 7)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  temp = lookup_widget(global.win, "frame320");
	  if (atoi(pos1))
	    gtk_widget_show(temp);
	  else
	    gtk_widget_hide(temp);
	} else {
	  g_warning(_("unknown tag in section GLOBAL [%s]"), rc_line);
	}
      } else if (section == 9) {
	if (!strncasecmp(rc_line, "ShortNames", 10)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  temp = lookup_widget(global.win, "checkbutton19");
	  if (atoi(pos1))
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
	  else
	    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
	} else if (!strncasecmp(rc_line, "DummyMD5", 8)) {
	  sscanf(rc_line + 9, "%d", &(global.options.dummy_md5));
	} else if (!strncasecmp(rc_line, "AutoSave", 8)) {
	  pos1 = strchr(rc_line, '=') + 1;
	  global.auto_save = l_strdup(pos1);
	} else {
	  g_warning(_("unknown tag in section LIBRARY [%s]"), rc_line);
	}
      } else {
	g_warning(_("unparsable rc_line [%s]"), rc_line);
      }
    }
    fclose(file);
  }

  if (!usermode_set) {
    strcpy(rc_line,
	   "ERROR CHANGE SERVER MUZZLE WALLOP CLOAK FLOOD WHOIS MSG LEVEL PING BAN KILL PORT");
    make_list_from_string(&global.usermode, rc_line, " ");
  }

  scheme_load_global(scheme);

  if (changes) {
    // reset the version checker, if enabled
    if (global.options.check_version)
      global.options.check_version = 1;
    // show changes
    changes_dialog(_("Changes since Version 0.9.9"));
  }
  global.status.rc_read = 1;
}

void write_rc()
{
  char *RCFile;
  FILE *file;
  GList *dlist;
  server_t *server;
  command_t *comm;
  int i1;
  char *str;
  GtkWidget *temp;
  suffix_t *suffix;
  hot_t *hot;

  //  printf("write rc\n");
  RCFile = l_strdup_printf("%s/lopsterrc.new", global.options.config_dir);

  if ((file = fopen(RCFile, "w")) == NULL) {
    l_free(RCFile);
    g_warning(_("could not write rc-file %s"), RCFile);
    return;
  }

  fprintf(file, "# DANGER! Only edit if you know what you are doing\n");
  fprintf(file, "###################################\n");
  fprintf(file, "\nSection [USER]\n");
  fprintf(file, "Name=%s\n", global.user.username);
  fprintf(file, "Password=%s\n", global.user.password);
  fprintf(file, "EMail=%s\n", global.user.email);
  if (global.usermode) {
    fprintf(file, "Mode=%s\n",
	    make_string_from_list(global.usermode, " "));
  }

  fprintf(file, "\nSection [PATH]\n");
  for (i1 = 0; i1 < MIME_SIZE; i1++) {
    if (global.mimetype[i1].download)
      fprintf(file, "Download=%d:%s\n", i1, global.mimetype[i1].download);
  }
  for (i1 = 0; i1 < MIME_SIZE; i1++) {
    for (dlist = global.mimetype[i1].shared; dlist; dlist = dlist->next) {
      fprintf(file, "Shared=%d:%s\n", i1, (char *) (dlist->data));
    }
  }
  if (global.incomplete_path)
    fprintf(file, "Incomplete=%s\n", global.incomplete_path);
  for (i1 = 1; i1 < MIME_SIZE; i1++) {
    for (dlist = global.mimetype[i1].suffixes; dlist; dlist = dlist->next) {
      suffix = (suffix_t *) (dlist->data);
      fprintf(file, "Suffix=%d:%s:%s:%d\n", i1,
	      suffix->suffix, suffix->application, suffix->as_mp3);
    }
  }

  fprintf(file, "\nSection [GLOBAL]\n");
  fprintf(file, "Version=%s\n", VERSION);
  fprintf(file, "PopupCreate=%d\n", global.options.popup_create);
  if (global.clientinfo)
    fprintf(file, "ClientInfo=%s\n", global.clientinfo);
  fprintf(file, "AutoReconnect=%d\n", global.options.auto_reconnect);
  fprintf(file, "AutoResume=%d\n", global.options.auto_resume);
  temp = lookup_widget(global.win, "checkbutton44");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    fprintf(file, "DirectBrowse=1\n");
  } else {
    fprintf(file, "DirectBrowse=0\n");
  }
  temp = lookup_widget(global.win, "checkbutton45");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    fprintf(file, "PingResults=1\n");
  } else {
    fprintf(file, "PingResults=0\n");
  }
  if (global.ping_command)
    fprintf(file, "PingCommand=%s\n", global.ping_command);
  fprintf(file, "Max_Searches=%d\n", global.limit.max_searches);
  fprintf(file, "TabStyle=%d\n", global.options.tab_style);
  fprintf(file, "AccessTimeout=%d\n", global.options.access_timeout);
  fprintf(file, "AccessSave=%d\n", global.options.access_save);
  fprintf(file, "CheckVersion=%d\n", global.options.check_version);
  fprintf(file, "TimeDisplay=%d\n", global.options.time_display);
  fprintf(file, "Browser=%d\n", global.options.browser);
  temp = lookup_widget(global.win, "frame320");
  fprintf(file, "IdleBar=%d\n", GTK_WIDGET_VISIBLE(temp));

  temp = lookup_widget(global.win, "entry50");
  str = gtk_entry_get_text(GTK_ENTRY(temp));
  fprintf(file, "AFK=%s\n", str);
  fprintf(file, "RetryTimeout=%d %d %d %d %d %d\n",
	  global.options.retry_timeout[0], global.options.retry_timeout[1],
	  global.options.retry_timeout[2], global.options.retry_timeout[3],
	  global.options.retry_timeout[4], global.options.retry_timeout[5]);
  fprintf(file, "UploadPriority=%d %d %d %d\n",
	  global.options.upload_priority[0], global.options.upload_priority[1],
	  global.options.upload_priority[2], global.options.upload_priority[3]);
  fprintf(file, "NapigatorUseProxy=%d\n", global.napigator.use_proxy);
  if (global.napigator.proxy_url) {
    fprintf(file, "NapigatorProxyUrl=%s\n", global.napigator.proxy_url);
  }
  fprintf(file, "NapigatorProxyPort=%d\n", global.napigator.proxy_port);
  
  fprintf(file, "\nSection [Network]\n");
  fprintf(file, "Linespeed=%d\n", global.user.linespeed);
  fprintf(file, "Port=%d\n", global.network.port);
  str = create_string_from_ports(global.allowed_ports);
  if (str)
    fprintf(file, "AllowedPorts=%s\n", str);
  l_free(str);
  fprintf(file, "Firewall=%d\n", global.network.firewall);
  fprintf(file, "Max_Downloads=%d\n", global.limit.max_downloads);
  fprintf(file, "Max_Uploads=%d\n", global.limit.max_uploads);
  fprintf(file, "Max_Large=%d\n", global.limit.max_large);
  fprintf(file, "Large_Size=%d\n", global.limit.large_size);
  fprintf(file, "Default_Downloads=%d\n", global.limit.default_downloads);
  fprintf(file, "Default_Uploads=%d\n", global.limit.default_uploads);
  fprintf(file, "Download_Percent=%d\n", global.limit.download_percent);
  fprintf(file, "AutoRetry=%d\n", global.options.auto_retry);
  fprintf(file, "ResumeAbort=%d %d %d %d\n",
	  global.options.resume_abort[0], global.options.resume_abort[1],
	  global.options.resume_abort[2], global.options.resume_abort[3]);
  fprintf(file, "AutoConnect=%d\n", global.options.auto_connect);
  fprintf(file, "TransferTimeout=%d\n", global.network.transfer_timeout);
  fprintf(file, "TransferUpdate=%d\n", global.network.transfer_delay);
  fprintf(file, "DLAutoremove=%d\n", global.options.dl_autoremove);
  fprintf(file, "ULAutoremove=%d\n", global.options.ul_autoremove);
  fprintf(file, "AllowDCC=%d\n", global.options.allow_dcc);
  fprintf(file, "DownloadBandwidth=%ld:%ld\n",
	  global.down_width.limit, global.down_width.maxval);
  fprintf(file, "UploadBandwidth=%ld:%ld\n",
	  global.up_width.limit, global.up_width.maxval);
  fprintf(file, "AdvancedUpload=%d\n", global.options.advanced_upload);
  fprintf(file, "AutoresumeDownload=%d\n", global.options.autoresume_download);
  fprintf(file, "ConfirmDelete=%d\n", global.options.confirm_delete);
  fprintf(file, "CheckLibForDownload=%d\n", global.options.check_lib_for_download);
  fprintf(file, "EmulateWinMX=%d\n", global.options.emulate_winmx);

  fprintf(file, "AutoSearch=%d\n", global.options.auto_search);
  fprintf(file, "ResumeTimeout=%d\n", global.options.resume_timeout);
  fprintf(file, "TransferSpeedLights=%d %d %d\n", global.options.speedred,
          global.options.speedyellow, 
          global.options.speedgreen);

  fprintf(file, "\nSection [Hotlist]\n");

  for (dlist = global.hotlist; dlist; dlist = dlist->next) {
    hot = (hot_t *) (dlist->data);
    if (!hot->visible)
      continue;
    fprintf(file, "User=%s:%s\n", hot->user,
	    (hot->description) ? (hot->description) : "");
  }

  temp = lookup_widget(global.win, "checkbutton18");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    fprintf(file, "ShortNames=0\n");
  } else {
    fprintf(file, "ShortNames=1\n");
  }

  fprintf(file, "\nSection [Server]\n");

  temp = lookup_widget(global.win, "clist11");
  i1 = 0;
  for (dlist = global.servers; dlist; dlist = dlist->next) {
    server = (server_t *) (dlist->data);
    fprintf(file, "Server=%s:%d:%s:%d:%s:%s\n", server->address,
	    server->port, server->description, server->meta,
	    server->nick ? server->nick : "",
	    server->passwd ? server->passwd : "");
  }

  if (global.last_server) {
    fprintf(file, "Last=%s:%d:%s:%d:%s:%s\n",
	    global.last_server->address,
	    global.last_server->port,
	    global.last_server->description,
	    global.last_server->meta,
	    global.last_server->nick ? global.last_server->nick : "",
	    global.last_server->passwd ? global.last_server->passwd : "");
  }
  // chat
  fprintf(file, "\nSection [Chat]\n");
  for (dlist = global.commands; dlist; dlist = dlist->next) {
    comm = dlist->data;
    if (comm->is_alias) {
      fprintf(file, "Alias=%s:%s\n", comm->name, &(comm->syntax[4]));
    }
  }
  if (global.string_list[LIST_HIGHLIGHT]) {
    i1 = 0;
    for (dlist = global.string_list[LIST_HIGHLIGHT]; dlist; dlist = dlist->next) {
      if (i1 == 0) fprintf(file, "Highlight=");
      str = (char *) (dlist->data);
      fprintf(file, "%s ", str);
      i1 += strlen(str)+1;
      if (i1 > 1024) {
	i1 = 0;
	fprintf(file, "\n");
      } else if (!dlist->next) {
	fprintf(file, "\n");
      }
    }
  }
  if (global.string_list[LIST_FRIEND]) {
    i1 = 0;
    for (dlist = global.string_list[LIST_FRIEND]; dlist; dlist = dlist->next) {
      if (i1 == 0) fprintf(file, "Friend=");
      str = (char *) (dlist->data);
      fprintf(file, "%s ", str);
      i1 += strlen(str)+1;
      if (i1 > 1024) {
	i1 = 0;
	fprintf(file, "\n");
      } else if (!dlist->next) {
	fprintf(file, "\n");
      }
    }
  }
  if (global.string_list[LIST_ENEMY]) {
    i1 = 0;
    for (dlist = global.string_list[LIST_ENEMY]; dlist; dlist = dlist->next) {
      if (i1 == 0) fprintf(file, "Enemy=");
      str = (char *) (dlist->data);
      fprintf(file, "%s ", str);
      i1 += strlen(str)+1;
      if (i1 > 1024) {
	i1 = 0;
	fprintf(file, "\n");
      } else if (!dlist->next) {
	fprintf(file, "\n");
      }
    }
  }
  if (global.string_list[LIST_NODOWNLOAD]) {
    i1 = 0;
    for (dlist = global.string_list[LIST_NODOWNLOAD]; dlist; dlist = dlist->next) {
      if (i1 == 0) fprintf(file, "NoDownload=");
      str = (char *) (dlist->data);
      fprintf(file, "%s ", str);
      i1 += strlen(str)+1;
      if (i1 > 1024) {
	i1 = 0;
	fprintf(file, "\n");
      } else if (!dlist->next) {
	fprintf(file, "\n");
      }
    }
  }
  if (global.scheme)
    fprintf(file, "Scheme=%s\n", global.scheme->name);
  fprintf(file, "ShowJoins=%d\n", global.options.show_joins);
  fprintf(file, "ShowParts=%d\n", global.options.show_parts);
  fprintf(file, "RecentTimeout=%d\n", global.options.recent_timeout);
  fprintf(file, "PublicIgnore=%d\n", global.options.public_ignore);
  fprintf(file, "Logging=%d\n", global.options.logging);
  fprintf(file, "LogExpire=%d\n", global.options.log_expire);

  if (global.string_list[LIST_AUTOJOIN]) {
    fprintf(file, "Channel=");
    for (dlist = global.string_list[LIST_AUTOJOIN]; dlist;
	 dlist = dlist->next) {
      str = (char *) (dlist->data);
      fprintf(file, "%s ", str);
    }
    fprintf(file, "\n");
  }
  fprintf(file, "ColorParse=%d\n", global.options.parse_color);
  fprintf(file, "Piping=%d\n", global.options.piping);
  fprintf(file, "NoPiping=%d\n", global.options.no_piping);
  fprintf(file, "TimeStamps=%d\n", global.options.timestamps);
  fprintf(file, "RejoinOpen=%d\n", global.options.channel_rejoin);
  fprintf(file, "ColoredNicks=%d\n", global.options.colored_nicks);
  fprintf(file, "RejoinWhenKicked=%d\n", global.options.rejoin_when_kicked);

  // buttons
  fprintf(file, "\nSection [Buttons]\n");
  temp = lookup_widget(global.win, "pix2");
  fprintf(file, "Chat=%d\n", GTK_WIDGET_VISIBLE(temp));
  temp = lookup_widget(global.win, "pix4");
  fprintf(file, "Search0=%d\n", GTK_WIDGET_VISIBLE(temp));
  temp = lookup_widget(global.win, "pixmap51");
  fprintf(file, "Search1=%d\n", GTK_WIDGET_VISIBLE(temp));
  temp = lookup_widget(global.win, "pixmap53");
  fprintf(file, "Search2=%d\n", GTK_WIDGET_VISIBLE(temp));
  fprintf(file, "Connect=%d\n", global.connect_button);

  fprintf(file, "\nSection [Library]\n");
  temp = lookup_widget(global.win, "checkbutton19");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    fprintf(file, "ShortNames=0\n");
  } else {
    fprintf(file, "ShortNames=1\n");
  }
  if (global.auto_save)
    fprintf(file, "AutoSave=%s\n", global.auto_save);
  fprintf(file, "DummyMD5=%d\n", global.options.dummy_md5);

  if (!ferror(file)) {
    rename(RCFile, global.options.config_file);
  } else {
    g_warning(_("Could not write [%s]\n"), RCFile);
  }

  l_free(RCFile);
  fclose(file);
}

void setup_sensitive(int section)
{				// 0=opennap 1=destination
  int opennap;			// 2=mediatype
  int search;
  int mp3;
  int advanced;
  char *text;
  GtkWidget *temp;
  server_t *server = NULL;

  if (global.napster)
    server = (server_t *) (global.napster->data);
  if (server && opennap_version(0, 0))
    opennap = TRUE;
  else
    opennap = FALSE;

  temp = lookup_widget(global.win, "combo_entry19");
  text = gtk_entry_get_text(GTK_ENTRY(temp));

  search = destination2int(text);

  temp = lookup_widget(global.win, "combo_entry17");
  text = gtk_entry_get_text(GTK_ENTRY(temp));
  /*
     if ((!strcmp(_("mp3"), text)) ||
     (!strcmp(_("any"), text))) mp3 = 1;
   */
  if (!strcmp(_("mp3"), text))
    mp3 = 1;
  else
    mp3 = 0;

  advanced = opennap | (search != DEST_NAPSTER);
  if (!advanced)
    mp3 = 1;

  // menues
  if (section == 0) {
    temp = lookup_widget(global.win, "banned_users");
    gtk_widget_set_sensitive(temp, opennap);
    temp = lookup_widget(global.win, "linked_servers");
    gtk_widget_set_sensitive(temp, opennap);
    temp = lookup_widget(global.win, "client_statistic");
    gtk_widget_set_sensitive(temp, opennap);
    temp = lookup_widget(global.win, "spinbutton42");
    gtk_widget_set_sensitive(temp, opennap);
  }
  //  temp = lookup_widget(global.win, "entry69");
  //  gtk_widget_set_sensitive(temp, advanced);
  temp = lookup_widget(global.win, "combo9");
  gtk_widget_set_sensitive(temp, advanced);
  temp = lookup_widget(global.win, "entry128");
  gtk_widget_set_sensitive(temp, mp3 & advanced);
  temp = lookup_widget(global.win, "entry130");
  gtk_widget_set_sensitive(temp, mp3 & advanced);
  temp = lookup_widget(global.win, "entry127");
  gtk_widget_set_sensitive(temp, advanced);
  temp = lookup_widget(global.win, "entry129");
  gtk_widget_set_sensitive(temp, advanced);

  temp = lookup_widget(global.win, "combo13");
  gtk_widget_set_sensitive(temp, search != DEST_LIBRARY);
  temp = lookup_widget(global.win, "search_line2");
  gtk_widget_set_sensitive(temp, search != DEST_LIBRARY);

  temp = lookup_widget(global.win, "combo11");
  gtk_widget_set_sensitive(temp, mp3);
  temp = lookup_widget(global.win, "search_bitrate2");
  gtk_widget_set_sensitive(temp, mp3);
  temp = lookup_widget(global.win, "combo12");
  gtk_widget_set_sensitive(temp, mp3);
  temp = lookup_widget(global.win, "search_frequency2");
  gtk_widget_set_sensitive(temp, mp3);
}

void setup_commands()
{
  command_new(C_WHISPER, "msg",
	      "/msg <user> <text>",
	      _("Send a private message <text> to the User <user>"),
	      L_USER, F_CHAT, lopster_whisper);
  command_new(C_EMOTE, "me",
	      "/me <text>",
	      _("Send action description <text> on the current channel."),
	      L_USER, F_CHAT, lopster_emote);
  command_new(C_JOIN, "join",
	      "/join <channel>",
	      _("Join channel <channel>."), L_USER, F_CHAT, lopster_join);

  command_new(C_EMAIL, "email",
	      "/email <address>",
	      _("Change e-mail address to <address>."),
	      L_USER, F_UMOD, lopster_email);
  command_new(C_SPEED, "speed",
	      "/speed [<user>] [<speed>]",
	      _
	      ("It will change the link speed for <user>. If no user is given your own link speed is modified"),
	      L_USER, F_UMOD, lopster_speed);
  command_new(C_DATAPORT, "dataport", "dataport [<user>] <port>",
	      _
	      ("Changes the dataport of <user> to <port>. If no user is specified it changes your own port"),
	      L_USER, F_UMOD, lopster_dataport);
  command_new(C_PASSWORD, "password", "/password [<user>] <password>",
	      _
	      ("It will change the password for <user> (admin or higher). If no user is given your own password is modified"),
	      L_USER, F_UMOD, lopster_password);
  command_new(C_LEVEL, "level", "/level <user> <level>",
	      _("Change level of <user> with a lower level than yours."),
	      L_USER, F_UMOD, lopster_level);
  command_new(C_USERMODE, "usermode", "/usermode [[-]args <...>]",
	      _
	      ("Show or set current usermode (ERROR BAN CHANGE KILL LEVEL SERVER MUZZLE PORT WALLOP CLOAK FLOOD PING MSG WHOIS)"),
	      L_USER, F_UMOD, lopster_usermode);
  command_new(C_WHOIS, "whois", "/whois [-text] [<user>]",
	      _("Show whois info for <user>."), L_USER, F_INFO,
	      lopster_whois);
  command_new(C_HELP, "help", "/help [<command>|all]",
	      _("Type /help for a list of commands, type /help all for all commands, type /help <command> for a description of <command>"),
	      L_USER, F_INFO, lopster_help);
  command_new(C_DISC, "disc", "/disc", _("Disconnect from server."),
	      L_USER, F_MISC, lopster_disc);
  command_new(C_RAW, "raw", "/raw <type> [<arg>....]", "?", L_MOD, F_MOD,
	      lopster_raw);
  command_new(C_BAN, "ban", "/ban <user|ip> [[<timeout>[<m|h|d>]] <reason>]",
	      _("Ban user or ip from server"), L_MOD, F_MOD, lopster_ban);
  command_new(C_UNBAN, "unban", "/unban <user|ip>",
	      _("Remove the ban on a user or ip."), L_MOD, F_MOD,
	      lopster_unban);
  command_new(C_CLOAK, "cloak", "/cloak",
	      _("Toggle your invisible state."), L_MOD, F_MOD,
	      lopster_cloak);
  command_new(C_CHCLEAR, "chclear", "/chclear [<channel>]",
	      _
	      ("Clear the channel from users with a lower level than yours. If no channel is specified the current channel is used."),
	      L_USER, F_OP, lopster_chclear);
  command_new(C_KILL, "kill", "/kill <user>",
	      _
	      ("Kill (disconnect) <user> with a lower lower level than yours."),
	      L_USER, F_MOD, lopster_kill);
  command_new(C_LINKS, "links", "/links [GET|PRINT]",
	      _("Get or show list of all linked servers."), L_USER, F_INFO,
	      lopster_links);
  command_new(C_CHLIST, "chlist", "/chlist",
	      _("List all channels in channel list"), L_USER, F_CLIENT,
	      lopster_chlist);
  command_new(C_PART, "part", "/part", _("Part the current channel."),
	      L_USER, F_CHAT, lopster_part);
  command_new(C_WALLOP, "wallop", "/wallop <text>",
	      _
	      ("Send a message to all users with level moderator or higher."),
	      L_MOD, F_MOD, lopster_wallop);
  command_new(C_STATS, "stats", "/stats", _("Show server statistics."),
	      L_USER, F_INFO, lopster_stats);
  command_new(C_SCHEME, "scheme", "/scheme <name>",
	      _("Loading Color scheme <name>."), L_USER, F_CLIENT,
	      lopster_scheme);
  command_new(C_ALIAS, "alias", "/alias <alias> <command>",
	      _("Making new <alias> for <command>."), L_USER, F_CLIENT,
	      lopster_alias);
  command_new(C_AFK, "away", "/away [<text>]",
	      _
	      ("If argument text is given, your status is set to AFK. Users sending you private messages will receive <text> as a private message. If no argument is given AFK is deactivated."),
	      L_USER, F_CLIENT, lopster_afk);
  command_new(C_PUBLIC, "public", "/public <text>",
	      _("Force to send public message"), L_USER, F_CHAT,
	      lopster_public);
  command_new(C_REPLY, "reply", "/reply <text>",
	      _("Reply to the user who sent the last private message"),
	      L_USER, F_CHAT, lopster_reply);
  command_new(C_PRIVATE, "private", "/private <user>",
	      _("Create new page for private messaging to <user>"), L_USER,
	      F_CHAT, lopster_private);
  command_new(C_CONN, "conn", "/conn",
	      _("Connect to the last server used."), L_USER, F_MISC,
	      lopster_conn);
  command_new(C_MOTD, "motd", "/motd",
	      _("Show server's \"Message Of The Day\"."), L_USER, F_INFO,
	      lopster_motd);
  command_new(C_QUIT, "quit", "/quit", _("Exit program."), L_USER, F_MISC,
	      lopster_quit);
  command_new(C_IGNORE, "ignore", "/ignore [<user>]",
	      _
	      ("ignore user <user>. If User is not given, ignore list is shown"),
	      L_USER, F_CHAT, lopster_ignore);
  command_new(C_UNIGNORE, "unignore", "/unignore <user>",
	      _("Unignores <user>"), L_USER, F_CHAT, lopster_unignore);
  command_new(C_MUZZLE, "muzzle", "/muzzle <user> [<reason>]",
	      _("Muzzle <user> with a lower level than yours."), L_MOD,
	      F_MOD, lopster_muzzle);
  command_new(C_UNMUZZLE, "unmuzzle", "/unmuzzle <user>",
	      _("Unmuzzle <user> with a lower level than yours."), L_MOD,
	      F_MOD, lopster_unmuzzle);
  command_new(C_CHBAN, "chban", "/chban <channel> <user|ip> [<reason>]",
	      _("Ban <user|ip> from <channel>"), L_USER, F_OP,
	      lopster_chban);
  command_new(C_CHUNBAN, "chunban",
	      "/chunban <channel> [<user|ip> [<reason>]]",
	      _("Unban <user|ip> from <channel>. If no user is specified, the ban list is cleared"),
	      L_USER, F_OP, lopster_chunban);
  command_new(C_TOPIC, "topic", "/topic <chn> <topic>",
	      _("Set the topic of channel <chn> to <topic>."), L_USER,
	      F_OP, lopster_topic);
  command_new(C_VERSION, "version", "/version", _("Show server version."),
	      L_MOD, F_MOD, lopster_version);
  command_new(C_CLEAR, "clear", "/clear [BOTTOM|TOP]",
	      _("Clears to current channel window"), L_USER, F_CLIENT,
	      lopster_clear);
  command_new(C_NUKE, "nuke", "/nuke <user>",
	      _("Nuke a <user> (delete account) with lower level than yours your yourself"),
	      L_MOD, F_MOD, lopster_nuke);
  /*
  command_new(C_UNNUKE, "unnuke", "/unnuke <user>",
	      _("Nuke a <user> (delete accout)"), L_MOD, F_MOD,
	      lopster_unnuke);
  */
  command_new(C_GLOBAL, "global", "/global <text>",
	      _("Send global message to all users."), L_ADMIN, F_ADMIN,
	      lopster_global);
  command_new(C_KICK, "kick", "/kick <channel> <user> [<reason>]",
	      _("Kick <user> with a lower level than yours from the <channel>."),
	      L_USER, F_OP, lopster_kick);
  command_new(C_CVERSION, "cversion", "/cversion",
	      _
	      ("Prints out the client version, if in a channel via public message"),
	      L_USER, F_INFO, lopster_cversion);
  command_new(C_PING, "ping", "/ping <user>", _("Ping <user>."), L_USER,
	      F_MISC, lopster_ping);
  command_new(C_SPING, "sping", "/sping <server>", _("Ping <server>."),
	      L_USER, F_MISC, lopster_sping);
  command_new(C_ECHO, "echo", "/echo <text>",
	      _
	      ("Echo <text> to current window. What's this command good for?"),
	      L_USER, F_CLIENT, lopster_echo);
  command_new(C_CHLIMIT, "chlimit", "/chlimit [<channel>] [<limit>]",
	      _
	      ("Change max. user limit of <channel> to <limit>. If no limit is specified the current limit is shown. If no channel is specified the current channel is used."),
	      L_USER, F_OP, lopster_chlimit);
  command_new(C_CHLEVEL, "chlevel", "/chlevel [<channel>] [<level>]",
	      _
	      ("Set the minimum level required to join <channel>. If no level is given the current level is shown.If no channel is given the current channel is used."),
	      L_USER, F_OP, lopster_chlevel);
  command_new(C_SSTATS, "sstats", "/sstats [<server>]",
	      _("Show the server stats of <server> or local server if no argument is given (moderator or higher)"), L_USER,
	      F_INFO, lopster_sstats);
  command_new(C_CHMODE, "chmode", "/chmode [<channel>] [<+|-><mode>]",
	      _
	      ("Set mode for <channel>. If no mode is given the current mode is displayed. If no channel is given the current channel is used. Mode may be one of PRIVATE, MODERATED, INVITE, TOPIC, REGISTERED."),
	      L_USER, F_OP, lopster_chmode);
  command_new(C_CHWALLOP, "chwallop", "/chwallop <message>",
	      _("Send message to all channel operators"), L_USER, F_OP,
	      lopster_chwallop);
  command_new(C_OP, "op", "/op [<channel>] [<user>]",
	      _
	      ("Set <user> as operator on the current channel. If no channel is given the current channel is used, if no user is given the operator list is shown"),
	      L_USER, F_OP, lopster_op);
  command_new(C_DEOP, "deop", "/deop  [<channel>] <user>",
	      _
	      ("Remove <user> as operator on the current channel or the specified channel."),
	      L_USER, F_OP, lopster_deop);
  command_new(C_KILLGHOST, "killghost", "/killghost <ghost> [<passwd>]",
	      _
	      ("kill your <ghost>. if no password is given, the current password is used"),
	      L_USER, F_MISC, lopster_killghost);
  command_new(C_FRIEND, "friend", "/friend <user>",
	      _("Add/remove a user to/from the friend list"), L_USER,
	      F_CLIENT, lopster_friend);
  command_new(C_ENEMY, "enemy", "/enemy <user>",
	      _("Add/remove a user to/from the enemy list"), L_USER,
	      F_CLIENT, lopster_enemy);
  command_new(C_HOTADD, "hotadd", "/hotadd <user> [<description>]",
	      _("Add a user to the hot list"), L_USER, F_CLIENT,
	      lopster_hotadd);
  command_new(C_HOTREM, "hotrem", "/hotrem <user>",
	      _("Remove a user from the hot list"), L_USER, F_CLIENT,
	      lopster_hotrem);
  command_new(C_LOCATE, "locate", "/locate <user>",
	      _("Display on which server <user> is"), L_USER, F_INFO,
	      lopster_locate);
  command_new(C_CLIENTS, "clients", "/clients",
	      _("Display clients versions if server has enabled logs"),
	      L_USER, F_INFO, lopster_clients);
  command_new(C_INVITE, "invite", "/invite [<channel>] <user>",
	      _("Invite <user> to <channel> or the current channel"),
	      L_USER, F_CHAT, lopster_invite);
  command_new(C_CHMUZZLE, "chmuzzle", "/chmuzzle [<user> [<reason>]]",
	      _
	      ("Muzzle <user>. If no user is specified the muzzle list is shown"),
	      L_USER, F_OP, lopster_chmuzzle);
  command_new(C_CHUNMUZZLE, "chunmuzzle",
	      "/chunmuzzle [<channel>] <user> [\"reason\"]",
	      _("Unmuzzle <user> with a lower level than yours."), L_USER,
	      F_OP, lopster_chunmuzzle);
  command_new(C_CHVOICE, "chvoice", "/chvoice [<channel>] [<user>]",
	      _
	      ("Give <user> voice to speak in channel If no channel is given the current channel is used. If no user is specified the voice list is shown"),
	      L_USER, F_OP, lopster_chvoice);
  command_new(C_CHUNVOICE, "chunvoice", "/chunvoice [<channel>] <user>",
	      _("Remove voice from <user> to speak in channel."), L_USER,
	      F_OP, lopster_chunvoice);
  command_new(C_CLIENTINFO, "clientinfo", "/clientinfo [<info>]",
	      _("Set yout client info to <info>"), L_USER, F_CLIENT,
	      lopster_clientinfo);
  command_new(C_GUSER, "guser", "/guser [<server> [<flags>]]",
	      _
	      ("List all users. Flags may be a list of the characters: e=ELITE, a=ADMIN, m=MODERATOR, l=LEECH, z=MUZZLED, c=CLOAKED"),
	      L_MOD, F_MOD, lopster_guser);
  command_new(C_SCONFIG, "sconfig", "/sconfig [var [value]]",
	      _
	      ("Request server config. To change a variable you have to be ELITE."),
	      L_MOD, F_MOD, lopster_sconfig);
  command_new(C_CLONES, "clones", "/clones <all|<channel>|<IP>> [<num>]",
	      _
	      ("Show all clones or for specified IP or channel. Only available if global user list was received."),
	      L_MOD, F_MOD, lopster_clones);
  command_new(C_EXEC, "exec",
	      "/exec [-out|-msg <user>|-wallop|-chop|-quiet|-global|-kill <id>] [<command>]",
	      _
	      ("Executes <command>. Without arguments the current processes are listed."),
	      L_USER, F_CLIENT, lopster_exec);
  command_new(C_WHOWAS, "whowas", "/whowas <user>",
	      _("Query information about <user>. Moderator or higher."),
	      L_MOD, F_MOD, lopster_whowas);
  command_new(C_RAINBOW, "rainbow", "/rainbow [sep] <size> <text>",
	      _
	      ("Send the <text> with rainbow colors as a public message. Color is changed after <size> letters. <sep> is a not colored text, that is inserted between the color changes."),
	      L_USER, F_CLIENT, lopster_rainbow);
  command_new(C_RCOLORS, "rcolors", "/rcolor [<-reset|color_codes>]",
	      _("Setup the colors for command /rainbow"), L_USER, F_CLIENT,
	      lopster_rcolors);
  command_new(C_BROWSE, "browse", "/browse [<user> [<max>]] ",
	      _("Browse at most <max> files from <user>"), L_USER,
	      F_CLIENT, lopster_browse);
  command_new(C_SEND, "send", "/send <user> <file>",
	      _("Send a file to user."), L_USER, F_CLIENT, lopster_send);
  command_new(C_SLINK, "slink", "/slink <server> [<remote server>]", _("Attempts to link the current server to <server>. If <remote_server> is given, then that server attempts to make the link instead of the local server."), L_ADMIN, F_ADMIN, lopster_slink);	// admin
  command_new(C_SDELINK, "sdelink", "/sdelink <server> [<reason>]", _("delink current server from <server>."), L_ADMIN, F_ADMIN, lopster_sdelink);	// admin
  command_new(C_SREMOVE, "sremove", "/sremove <server> [<reason>]", _("requests that <server> be removed from the table of allowed links."), L_ELITE, F_ADMIN, lopster_sremove);	// elite
  command_new(C_SKILL, "skill", "/skill <server> [<reason>]", _("cause the server to shutdown."), L_ELITE, F_ADMIN, lopster_skill);	// elite
  command_new(C_SRELOAD, "sreload", "/srelead [<server>]", 
	      _("Reload the server configuration of local server or <server>"), L_ELITE, F_ADMIN, lopster_sreload);	// elite
  command_new(C_SRECONFIG, "sreconfig", "/sreconfig <var>", 
	      _("reset <var> to its default value"), L_ELITE, F_ADMIN, lopster_sreconfig);	// elite
  command_new(C_SHISTOGRAM, "shistogram", "/shistogram", _("Report statistics for server commands."), L_ELITE, F_ADMIN, lopster_shistogram);	// elite
  command_new(C_MASSKILL, "masskill",
	      "/masskill <ip> [<reason>]",
	      _("Kill all users with <ip>."),
	      L_MOD, F_MOD, lopster_masskill);
  command_new(C_REGISTER, "register",
	      "/register [<user> <passwd> <email> [<level>]]",
	      _
	      ("Admin command to force registration of a nickname. If no arguments are given, then your current nick is registered."),
	      L_ADMIN, F_ADMIN, lopster_register);
  command_new(C_REDIRECT, "redirect", "/redirect <user> <server> <port>",
	      _("Redirect client to another server."), L_ADMIN, F_ADMIN,
	      lopster_redirect);
  command_new(C_CYCLE, "cycle", "/cycle <user> <server>",
	      _("Redirect client to a metaserver."), L_ADMIN, F_ADMIN,
	      lopster_cycle);
  command_new(C_LIMIT, "limit",
	      "/limit <add|remove|list> <ip>[/ip mask] [<count>]",
	      _
	      ("This command allowes to setup specific clone limits to IPs."),
	      L_MOD, F_MOD, lopster_limit);
  command_new(C_ILINE, "iline",
	      "/iline <add|remove|list> <ip>[/ip mask] [<count>]",
	      _
	      ("Setup the IPs that are only allowed to connect. <count> is useless here"),
	      L_MOD, F_MOD, lopster_iline);
  command_new(C_DLINE, "dline",
	      "/dline <add|remove|list> <ip>[/ip mask] [<count>]",
	      _
	      ("Setup IPs, that are not allowed to connect, unless they are in elines. <count> is useless here"),
	      L_MOD, F_MOD, lopster_dline);
  command_new(C_ELINE, "eline",
	      "/eline <add|remove|list> <ip>[/ip mask] [<count>]",
	      _
	      ("IPs that are allowed to connect, although they are in dlines. <count> is useless here"),
	      L_MOD, F_MOD, lopster_eline);
  command_new(C_PRETEND, "pretend",
	      "/pretend <command> [<data>]",
	      _("this pretends a message from the server"),
	      L_USER, F_MOD, lopster_pretend);
#ifdef TRAFFIC_DEBUG
  command_new(C_TRAFFIC, "traffic",
	      "/traffic",
	      _("Display Lopster <-> Server traffic"),
	      L_MOD, F_MOD, lopster_traffic);
#endif
#ifdef PROTOCOL_DEBUG
  command_new(C_TEST, "test",
	      "/test",
	      _("Internal test function"), L_MOD, F_MOD, lopster_test);
#endif
}

void create_pixmaps()
{
  GtkStyle *style;

  style = gtk_widget_get_style(global.win);
  global.pix.sgreen = gdk_pixmap_create_from_xpm_d(global.win->window,
						   &(global.pix.sgreenb),
						   &style->
						   bg[GTK_STATE_NORMAL],
						   speedgreen_xpm);
  global.pix.sred = gdk_pixmap_create_from_xpm_d(global.win->window,
						 &(global.pix.sredb),
						 &style->
						 bg[GTK_STATE_NORMAL],
						 speedred_xpm);
  global.pix.syellow = gdk_pixmap_create_from_xpm_d(global.win->window,
						    &(global.pix.syellowb),
						    &style->
						    bg[GTK_STATE_NORMAL],
						    speedyellow_xpm);
  global.pix.sgray = gdk_pixmap_create_from_xpm_d(global.win->window,
						  &(global.pix.sgrayb),
						  &style->
						  bg[GTK_STATE_NORMAL],
						  speedgray_xpm);

  global.pix.folder = gdk_pixmap_create_from_xpm_d(global.win->window,
						   &(global.pix.folderb),
						   &style->
						   bg[GTK_STATE_NORMAL],
						   folder);
  global.pix.folder_open = gdk_pixmap_create_from_xpm_d(global.win->window,
							&(global.pix.
							  folder_openb),
							&style->
							bg
							[GTK_STATE_NORMAL],
							folder_open);
  global.pix.user1 = gdk_pixmap_create_from_xpm_d(global.win->window,
						  &(global.pix.user1b),
						  &style->
						  bg[GTK_STATE_NORMAL],
						  user_on);
  global.pix.user2 = gdk_pixmap_create_from_xpm_d(global.win->window,
						  &(global.pix.user2b),
						  &style->
						  bg[GTK_STATE_NORMAL],
						  user_off);
  global.pix.ignore = gdk_pixmap_create_from_xpm_d(global.win->window,
						   &(global.pix.ignoreb),
						   &style->
						   bg[GTK_STATE_NORMAL],
						   ignore_xpm);
  global.pix.enemy = gdk_pixmap_create_from_xpm_d(global.win->window,
						  &(global.pix.enemyb),
						  &style->
						  bg[GTK_STATE_NORMAL],
						  enemy_xpm);
  global.pix.enemy2 = gdk_pixmap_create_from_xpm_d(global.win->window,
						   &(global.pix.enemy2b),
						   &style->
						   bg[GTK_STATE_NORMAL],
						   enemy2_xpm);
  global.pix.friend = gdk_pixmap_create_from_xpm_d(global.win->window,
						   &(global.pix.friendb),
						   &style->
						   bg[GTK_STATE_NORMAL],
						   friend_xpm);
  global.pix.dummy = gdk_pixmap_create_from_xpm_d(global.win->window,
						  &(global.pix.dummyb),
						  &style->
						  bg[GTK_STATE_NORMAL],
						  dummy_xpm);
}

void setup_main_tab()
{
  GtkWidget *temp;
  GtkWidget *temps[8];
  int show;
  int i1;

  temp = lookup_widget(global.win, "notebook1");
  if (!global.options.tab_style)
    gtk_notebook_set_show_tabs(GTK_NOTEBOOK(temp), FALSE);
  else {
    if (global.options.tab_style & TAB_ICON)
      show = 1;
    else
      show = 0;
    temps[0] = lookup_widget(global.win, "pixmap10");
    temps[1] = lookup_widget(global.win, "pixmap1");
    temps[2] = lookup_widget(global.win, "pixmap2");
    temps[3] = lookup_widget(global.win, "pixmap3");
    temps[4] = lookup_widget(global.win, "pixmap11");
    temps[5] = lookup_widget(global.win, "pixmap5");
    temps[6] = lookup_widget(global.win, "pixmap23");
    temps[7] = lookup_widget(global.win, "pixmap42");
    for (i1 = 0; i1 < 8; i1++) {
      if (show)
	gtk_widget_show(temps[i1]);
      else
	gtk_widget_hide(temps[i1]);
    }
    if (global.options.tab_style & TAB_TEXT)
      show = 1;
    else
      show = 0;
    temps[0] = lookup_widget(global.win, "label293");
    temps[1] = lookup_widget(global.win, "note_chat");
    temps[2] = lookup_widget(global.win, "note_library");
    temps[3] = lookup_widget(global.win, "note_search");
    temps[4] = lookup_widget(global.win, "label465");
    temps[5] = lookup_widget(global.win, "note_transfer");
    temps[6] = lookup_widget(global.win, "label530");
    temps[7] = lookup_widget(global.win, "label915");
    for (i1 = 0; i1 < 8; i1++) {
      if (show)
	gtk_widget_show(temps[i1]);
      else
	gtk_widget_hide(temps[i1]);
    }
    gtk_notebook_set_show_tabs(GTK_NOTEBOOK(temp), TRUE);
  }

}

void setup_widgets()
{
  GtkWidget *temp;
  char text[1024];
  int i1, i2;

  sprintf(text, "Lopster %s", VERSION);
  gtk_window_set_title(GTK_WINDOW(global.win), text);

  setup_main_tab();

  temp = lookup_widget(global.win, "notebook3");
  gtk_notebook_popup_enable(GTK_NOTEBOOK(temp));

  temp = lookup_widget(global.win, "lib_tree");
  gtk_clist_set_compare_func(GTK_CLIST(temp), browse_compare);
  gtk_clist_set_use_drag_icons(GTK_CLIST(temp), TRUE);
  gtk_drag_source_set(temp, GDK_BUTTON1_MASK, lib_target_table, 1, GDK_ACTION_COPY);

  temp = lookup_widget(global.win, "ctree4");
  gtk_clist_set_compare_func(GTK_CLIST(temp), download_compare);

  temp = lookup_widget(global.win, "ctree5");
  gtk_widget_realize(temp);
  gtk_clist_set_compare_func(GTK_CLIST(temp), download_compare2);

  temp = lookup_widget(global.win, "server_ctree");
  gtk_clist_set_compare_func(GTK_CLIST(temp), server_compare);

  temp = lookup_widget(global.win, "clist16");
  gtk_clist_set_compare_func(GTK_CLIST(temp), hotlist_compare);
  gtk_clist_set_sort_column(GTK_CLIST(temp), 1);
  gtk_clist_set_auto_sort(GTK_CLIST(temp), TRUE);
  gtk_clist_set_sort_type(GTK_CLIST(temp), GTK_SORT_DESCENDING);

  temp = lookup_widget(global.win, "ctree3");
  gtk_clist_set_compare_func(GTK_CLIST(temp), access_compare);
  gtk_clist_set_sort_column(GTK_CLIST(temp), 1);
  //  gtk_clist_set_auto_sort(GTK_CLIST(temp), TRUE);

  temp = lookup_widget(global.win, "combo_entry23");
  switch (global.options.show_joins) {
  case 0:
    gtk_entry_set_text(GTK_ENTRY(temp), _("None"));
    break;
  case 1:
  default:
    gtk_entry_set_text(GTK_ENTRY(temp), _("All"));
    break;
  }
  temp = lookup_widget(global.win, "combo_entry22");
  switch (global.options.show_parts) {
  case 0:
    gtk_entry_set_text(GTK_ENTRY(temp), _("None"));
    break;
  case 1:
    gtk_entry_set_text(GTK_ENTRY(temp), _("Recent Users"));
    break;
  case 2:
  default:
    gtk_entry_set_text(GTK_ENTRY(temp), _("All"));
    break;
  }

  temp = lookup_widget(global.win, "combo_entry26");
  gtk_entry_set_text(GTK_ENTRY(temp), TimeStamp(global.options.timestamps));

  i2 = global.options.access_timeout;
  if (i2 < 0)
    i1 = -i2;
  else
    i1 = i2;

  temp = lookup_widget(global.win, "spinbutton61");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), i1 / 24);
  temp = lookup_widget(global.win, "spinbutton62");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), i1 % 24);

  if (i2 > 0) {
    temp = lookup_widget(global.win, "checkbutton64");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
  }
  global.options.access_timeout = i2;

  temp = lookup_widget(global.win, "checkbutton63");
  if (global.options.access_save)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
  else
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);

  temp = lookup_widget(global.win, "spinbutton55");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.options.recent_timeout);

  temp = lookup_widget(global.win, "checkbutton10");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.options.public_ignore);

  temp = lookup_widget(global.win, "checkbutton21");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.options.parse_color);

  temp = lookup_widget(global.win, "spinbutton5");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.max_downloads);
  temp = lookup_widget(global.win, "spinbutton35");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.default_downloads);
  temp = lookup_widget(global.win, "spinbutton6");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.max_uploads);
  temp = lookup_widget(global.win, "spinbutton36");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.default_uploads);
  temp = lookup_widget(global.win, "spinbutton53");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), global.limit.max_large);
  temp = lookup_widget(global.win, "spinbutton54");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.large_size);

  temp = lookup_widget(global.win, "spinbutton42");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.max_searches);

  temp = lookup_widget(global.win, "channel_list");
  gtk_clist_set_sort_column(GTK_CLIST(temp), 0);
  gtk_clist_set_auto_sort(GTK_CLIST(temp), TRUE);
  gtk_clist_set_compare_func(GTK_CLIST(temp), channel_compare);

  temp = lookup_widget(global.win, "transfer_up");
  gtk_clist_set_sort_column(GTK_CLIST(temp), 0);
  gtk_clist_set_compare_func(GTK_CLIST(temp), transfer_compare);
  gtk_clist_set_reorderable(GTK_CLIST(temp), TRUE);
  gtk_clist_set_use_drag_icons(GTK_CLIST(temp), TRUE);

  temp = lookup_widget(global.win, "clist34");
  gtk_clist_set_reorderable(GTK_CLIST(temp), TRUE);
  gtk_clist_set_use_drag_icons(GTK_CLIST(temp), TRUE);

  temp = lookup_widget(global.win, "global_users");
  gtk_widget_set_sensitive(temp, FALSE);

  temp = lookup_widget(global.win, "clist11");
  gtk_clist_set_reorderable(GTK_CLIST(temp), TRUE);
  gtk_clist_set_use_drag_icons(GTK_CLIST(temp), TRUE);

  temp = lookup_widget(global.win, "checkbutton35");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
			       global.options.auto_resume);

  temp = lookup_widget(global.win, "checkbutton70");
  if (global.options.autoresume_download)
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
  else
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);

  temp = lookup_widget(global.win, "drawingarea7");
  i1 = gdk_string_height(temp->style->font, "0,123456789 MBG") * 2;
  gtk_widget_set_usize(temp, -2, i1);
  temp = lookup_widget(global.win, "drawingarea8");
  gtk_widget_set_usize(temp, -2, i1);
  temp = lookup_widget(global.win, "drawingarea9");
  gtk_widget_set_usize(temp, -2, i1);

  temp = lookup_widget(global.win, "label293");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "note_chat");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "note_library");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "note_search");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "label465");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "note_transfer");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "label530");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "label915");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "button328");
  temp = GTK_BIN(temp)->child;
  gtk_widget_set_style(temp, global.style[3]);

  temp = lookup_widget(global.win, "frame195");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "frame143");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "frame142");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "frame141");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "label467");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "label6");
  gtk_widget_set_style(temp, global.style[3]);
  temp = lookup_widget(global.win, "search_artist");
  gtk_widget_set_style(temp, global.style[4]);
  temp = lookup_widget(global.win, "entry69");
  gtk_widget_set_style(temp, global.style[4]);

  print_topright_corner();

  global.down_width.area = lookup_widget(global.win, "drawingarea1");
  global.down_width.label_max = lookup_widget(global.win, "label536");
  global.down_width.label_cur = lookup_widget(global.win, "label538");
  global.up_width.area = lookup_widget(global.win, "drawingarea2");
  global.up_width.label_max = lookup_widget(global.win, "label541");
  global.up_width.label_cur = lookup_widget(global.win, "label542");

  temp = lookup_widget(global.win, "combo_entry28");
  gtk_entry_set_text(GTK_ENTRY(temp), LifeTime(PATTERN_TEMPORARY));
  
  if (global.options.auto_search) {
    temp = lookup_widget(global.win, "checkbutton46");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
  }
  temp = lookup_widget(global.win, "spinbutton48");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), global.options.resume_timeout);

  for (i1 = 0; i1 < G_SIZE - G_SIZE_ADD; i1++) {
    if (global.extra_win & (1 << i1)) {
      global.extra_win ^= (1 << i1);
      temp = main_tab_detach(i1);
      /*
      while (gtk_events_pending())
	gtk_main_iteration();
      */
    }
  }
  if (global.extra_win & (1 << (G_SIZE - 2))) {
    temp = search_fields_detach2();
    /*
    while (gtk_events_pending())
      gtk_main_iteration();
    */
  }
  if (global.extra_win & (1 << (G_SIZE - 1))) {
    temp = search_fields_detach();
    /*
    while (gtk_events_pending())
      gtk_main_iteration();
    */
  }
}

void setup_buttons()
{
  GtkWidget *temp;

  temp = lookup_widget(global.win, "button114");	//chat
  set_up_button(temp, "pix1", "pix2", "frame98");
  temp = lookup_widget(global.win, "button115");	//search
  set_up_button(temp, "pix3", "pix4", "hbox710");
  temp = lookup_widget(global.win, "button330");
  set_up_button(temp, "pixmap50", "pixmap51", "table38");
  temp = lookup_widget(global.win, "button331");
  set_up_button(temp, "pixmap52", "pixmap53", "scrolledwindow96");
}

void setup_mime()
{
  int i1;

  for (i1 = 0; i1 < MIME_SIZE; i1++) {
    global.mimetype[i1].shared = NULL;
    global.mimetype[i1].download = l_strdup("");;
    global.mimetype[i1].suffixes = NULL;
  }
}

void setup_global_vars()
{
  int i1;

  global.user.username[0] = 0;
  global.user.password[0] = 0;
  global.user.email[0] = 0;
  global.user.level = L_USER;
  global.user.status = STATUS_INACTIVE;
  global.user.linespeed = 0;
  global.user.shared = 0;
  global.user.bytes = 0;
  global.user.status = STATUS_INACTIVE;
  global.user.files = NULL;

  global.timer = -1;

  global.connect_win = NULL;
  global.whois_win = NULL;
  global.options_win = NULL;
  global.ban_win = NULL;
  global.usermode_win = NULL;
  global.client_win = NULL;
  global.user_win = NULL;
  global.socket_win = NULL;
  global.splash_win = NULL;
  global.string_win = NULL;
  global.file_win = NULL;
  global.queue_win = NULL;
  global.subscription_win = NULL;

  global.status.searching = 0;
  global.status.connection = 0;
  global.status.exiting = 0;
  global.status.rc_read = 0;
  global.status.geometry_read = 0;
  global.status.access_read = 0;
  global.status.search_read = 0;

  global.limit.cur_uploads = 0;
  global.limit.cur_downloads = 0;
  global.limit.cur_large = 0;
  global.limit.cur_real_downloads = 0;
  global.limit.cur_real_uploads = 0;
  global.limit.max_uploads = 3;
  global.limit.max_downloads = 5;
  global.limit.max_large = 3;
  global.limit.large_size = 20;
  global.limit.default_uploads = 2;
  global.limit.default_downloads = 3;
  global.limit.max_searches = 2;
  global.limit.max_searches_real = 2;
  global.limit.download_percent = 0;

  global.network.firewall = 0;
  global.network.transfer_timeout = 500;
  global.network.transfer_delay = 1;
  global.network.port = 6699;

  global.options.config_dir = NULL;
  global.options.config_file = NULL;
  global.options.auto_connect = 0;
  global.options.auto_reconnect = 5;
  global.options.auto_resume = 1;
  global.options.auto_search = 1;
  global.options.allow_dcc = 0;
  global.options.show_joins = 1;
  global.options.show_parts = 2;
  global.options.recent_timeout = 60;
  global.options.public_ignore = 0;
  global.options.logging = 0;
  global.options.parse_color = 1;
  global.options.dummy_md5 = 1;
  global.options.popup_create = 3;
  global.options.log_expire = 5;	// 5 hours
  global.options.auto_retry = RETRY_INCOMPLETE;
  global.options.resume_abort[0] = 0;
  global.options.resume_abort[1] = 0;
  global.options.resume_abort[2] = 30;
  global.options.resume_abort[3] = 100;
  global.options.dl_autoremove = REMOVE_D_ABORTED;
  global.options.ul_autoremove = REMOVE_U_ABORTED;
  global.options.timestamps = TIME_HOUR_MIN;
  global.options.login_mode = 0;
  global.options.tab_style = TAB_ICON | TAB_TEXT;
  global.options.channel_rejoin = 1;
  global.options.confirm_delete = 1;
  global.options.access_timeout = 30 * 24;	// 30 days
  global.options.access_save = 1;
  global.options.check_version = 1;
  global.options.piping =
    PIPE_AWAY_LOG | PIPE_WALLOP | PIPE_GLOBAL | PIPE_SERVER |
    PIPE_DOWNLOAD | PIPE_UPLOAD;
  global.options.no_piping = NOPIPE_PROTOCOL1 | NOPIPE_PROTOCOL2;
  global.options.colored_nicks = 1;
  global.options.rejoin_when_kicked = 1;
  global.options.resume_timeout = 60;
  global.options.check_lib_for_download = 1;
  global.options.time_display = 0;
  global.options.browser = BROWSER_NETSCAPE;
  global.options.speedgreen=SPEED_GREEN;
  global.options.speedred=SPEED_RED;
  global.options.speedyellow=SPEED_YELLOW;
  global.options.emulate_winmx=0;
  global.napigator.use_proxy = 0;
  global.napigator.proxy_url = NULL;
  global.napigator.proxy_port = 3128;

  global.servers = NULL;
  for (i1 = 0; i1 < STRING_LIST_NO; i1++)
    global.string_list[i1] = NULL;
  global.commands = NULL;
  global.scheme = NULL;
  global.chat_history = NULL;
  global.afk.message = NULL;
  global.reply = NULL;
  global.last_server = NULL;
  global.incomplete_path = NULL;
  global.connect_button = 0;
  global.usermode = NULL;
  global.incomplete = NULL;
  global.queue = NULL;
  global.share_queue = NULL;
  global.clientinfo = NULL;
  global.online_width[0] = 100;
  global.online_width[1] = 30;
  global.online_width[2] = 60;
  global.online_show[0] = 1;
  global.online_show[1] = 1;
  global.online_show[2] = 1;
  global.paned_pos = 730;
  global.paned_pos2 = 0;
  global.clones = NULL;
  global.client_list = NULL;
  global.links = NULL;
  global.allowed_links = NULL;
  global.sockets = NULL;
  global.extra_win = 0;
  global.chat_pages = NULL;
  global.searches = NULL;
  global.appearance = NULL;
  global.userstamp = NULL;
  global.whois_requests = NULL;
  global.speed_requests = NULL;
  global.reconnect_timer = -1;
  global.resume_timer = -1;
  global.my_ip = 0;
  global.path_warned = 0;
#ifdef ENABLE_WHITE_BOARD
  global.whiteboards = NULL;
#endif

  global.down_width.limit = 1024 * 1024;
  global.down_width.current = 0;
  global.down_width.maxval = 1024 * 1024;
  global.up_width.limit = 1024 * 128;
  global.up_width.current = 0;
  global.up_width.maxval = 1024 * 128;
  global.options.advanced_upload = AU_RESTART;
  global.options.autoresume_download = 1;

  global.search_width[0] = 462;
  global.search_width[1] = 80;
  global.search_width[2] = 80;
  global.search_width[3] = 80;
  global.search_width[4] = 80;
  global.search_width[5] = 80;
  for (i1 = 0; i1 < 7; i1++)
    global.search_show[i1] = 1;

  global.rainbow_colors = l_strdup("RrpPBbcCgGYy");
  global.allowed_ports = NULL;

  global.auto_save = NULL;
  global.execs = NULL;
  global.pings = NULL;
  global.ping_command = l_strdup("/bin/ping -c 3 $IP");

  global.browse_width[0] = 369;
  global.browse_width[1] = 80;
  global.browse_width[2] = 80;
  global.browse_width[3] = 80;
  global.browse_width[4] = 80;
  for (i1 = 0; i1 < 5; i1++)
    global.browse_show[i1] = 1;

  for (i1 = 0; i1 < G_SIZE; i1++)
    global.geometry[i1].x = global.geometry[i1].y =
      global.geometry[i1].width = global.geometry[i1].height = -1;

  global.options.retry_timeout[0] = 10;
  global.options.retry_timeout[1] = 300;
  global.options.retry_timeout[2] = 10;
  global.options.retry_timeout[3] = 300;
  global.options.retry_timeout[4] = 300;
  global.options.retry_timeout[5] = 300;

  global.userinfo = NULL;
  global.options.upload_priority[PRI_FRIEND] = 0;
  global.options.upload_priority[PRI_DOWNLOAD] = 0;
  global.options.upload_priority[PRI_SHARE] = 0;
  global.options.upload_priority[PRI_NONE] = 0;

  global.options.config_dir = NULL;
}

void setup_styles()
{
  GdkFont* font;

  global.style[0] = gtk_widget_get_style(global.win);

  global.style[1] = gtk_style_new();
  global.style[1]->font = global.style[0]->font;
  global.style[1]->fg[GTK_STATE_NORMAL].pixel =
      global.style[0]->fg[GTK_STATE_SELECTED].pixel;
  global.style[1]->fg[GTK_STATE_NORMAL].red = 65535;
  global.style[1]->fg[GTK_STATE_NORMAL].green = 0;
  global.style[1]->fg[GTK_STATE_NORMAL].blue = 0;

  global.style[2] = gtk_style_new();
  global.style[2]->font = global.style[0]->font;
  global.style[2]->base[GTK_STATE_NORMAL].pixel =
      global.style[0]->base[GTK_STATE_NORMAL].pixel;
  global.style[2]->base[GTK_STATE_NORMAL].red = 0;
  global.style[2]->base[GTK_STATE_NORMAL].green = 0;
  global.style[2]->base[GTK_STATE_NORMAL].blue = 0;

  global.style[2]->text[GTK_STATE_NORMAL].pixel =
      global.style[0]->text[GTK_STATE_NORMAL].pixel;
  global.style[2]->text[GTK_STATE_NORMAL].red = 65535;
  global.style[2]->text[GTK_STATE_NORMAL].green = 65535;
  global.style[2]->text[GTK_STATE_NORMAL].blue = 65535;

  global.style[3] = gtk_style_new();
  font = gdk_font_load("-adobe-helvetica-bold-r-normal-*-*-120-*-*-p-*-iso8859-1");
  if (font) global.style[3]->font = font;

  global.style[4] = gtk_style_new();

  global.style[5] = gtk_style_new();
  font = gdk_font_load("-adobe-helvetica-bold-r-normal-*-*-120-*-*-p-*-iso8859-1");
  if (font) global.style[5]->font = font;
  global.style[5]->fg[GTK_STATE_NORMAL].red = 65535;
  global.style[5]->fg[GTK_STATE_NORMAL].green = 0;
  global.style[5]->fg[GTK_STATE_NORMAL].blue = 0;
}

void global_init()
{
  GtkWidget *temp;
  char str[2048];
  user_t *user;

  global.current_time = time(NULL);

  advance_progress(_("Setting up lopster styles..."), 0.15);
  setup_styles();

  if (!global.options.config_dir)
    global.options.config_dir = l_strdup_printf("%s/.lopster", g_get_home_dir());

  if (!global.options.config_file)
    global.options.config_file = 
      l_strdup_printf("%s/lopsterrc", global.options.config_dir);

  //  printf("lopsterhome [%s]\n", global.options.config_dir);
  sprintf(str, "%s/log", global.options.config_dir);
  create_dir(str);
  sprintf(str, "%s/schemes", global.options.config_dir);
  create_dir(str);
  sprintf(str, "%s/share", global.options.config_dir);
  create_dir(str);

  global.start_time = global.current_time;
  global.session_start = l_strdup(ctime(&global.start_time));
  global.session_start[strlen(global.session_start) - 1] = 0;

  printf(_("Lopster started at %s\n"), global.session_start);

  temp = lookup_widget(global.win, "notebook6");
  user = (user_t *) l_malloc(sizeof(user_t));
  user->shared = 0;
  user->bytes = 0;
  user->files = NULL;		// unused
  gtk_object_set_data(GTK_OBJECT(temp), "browse_stats", user);

  gdk_color_parse("#ffffff", &global.color_table[0]);	// W
  gdk_color_parse("#000000", &global.color_table[1]);	// Bl
  gdk_color_parse("#0000aa", &global.color_table[2]);	// b_
  gdk_color_parse("#00aa00", &global.color_table[3]);	// g_
  gdk_color_parse("#aa0000", &global.color_table[4]);	// r_
  gdk_color_parse("#aa5500", &global.color_table[5]);	// y_
  gdk_color_parse("#aa00aa", &global.color_table[6]);	// p_
  gdk_color_parse("#ff5555", &global.color_table[7]);	// R_
  gdk_color_parse("#ffff55", &global.color_table[8]);	// Y_
  gdk_color_parse("#55ff55", &global.color_table[9]);	// G
  gdk_color_parse("#00aaaa", &global.color_table[10]);	// c
  gdk_color_parse("#55ffff", &global.color_table[11]);	// C
  gdk_color_parse("#5555ff", &global.color_table[12]);	// B_
  gdk_color_parse("#ff55ff", &global.color_table[13]);	// P_
  gdk_color_parse("#555555", &global.color_table[14]);	//dG
  gdk_color_parse("#aaaaaa", &global.color_table[15]);	// w_


  // creating pixmaps
  advance_progress(_("Creating pixmaps..."), 0.20);
  create_pixmaps();

  advance_progress(_("Setting up chat pages..."), 0.25);

  global.current_page = chat_page_new("Channels", P_FIX);
  global.current_page->tlabel = lookup_widget(global.win, "label253");
  global.current_page->mlabel = lookup_widget(global.win, "label253");
  global.current_page->toplevel =
      lookup_widget(global.win, "scrolledwindow50");
  gtk_object_set_data(GTK_OBJECT(global.current_page->mlabel), "page",
		      global.current_page);

  filetips_init();

  advance_progress(_("Reading geometry..."), 0.30);
  read_geometry();

  // setting up
  advance_progress(_("Reading link-file..."), 0.35);
  read_allowed_links();

  // setting up signal handlers
  advance_progress(_("Setting up signal handlers..."), 0.39);
  signal(SIGPIPE, sigpipe_handler);
  signal(SIGSEGV, sigseg_handler);
  //  signal(SIGCHLD, sigchld_handler);

  // setting up commands
  advance_progress(_("Setting up commands..."), 0.43);
  setup_commands();

  // setting up show/hide buttons
  advance_progress(_("Setting buttons..."), 0.47);
  setup_buttons();

  //
  advance_progress(_("Setting up mimetypes..."), 0.51);
  setup_mime();

  // reading rc file
  advance_progress(_("Reading rc-file..."), 0.55);
  read_rc();

  advance_progress(_("Checking allowed ports..."), 0.59);
  if (!global.allowed_ports) {
    global.allowed_ports = create_allowed_ports("6680-6699");
  }
  // always insert the mp3 suffix
  advance_progress(_("Checking for mimetype mp3..."), 0.63);
  if (!check_suffix(".mp3", MIME_MP3)) {
    suffix_t *suffix;

    suffix = (suffix_t *) l_malloc(sizeof(suffix_t));
    suffix->suffix = l_strdup("mp3");
    suffix->application = l_strdup("");
    suffix->as_mp3 = 1;
    global.mimetype[MIME_MP3].suffixes =
	g_list_append(global.mimetype[MIME_MP3].suffixes, suffix);
  }
  // setting up some GtkWidgets
  advance_progress(_("Setting up widgets..."), 0.67);
  setup_widgets();

  // creating  listening port
  advance_progress(_("Creating dataport..."), 0.71);
  create_upload_port(global.network.port, TRUE);

  // loading resume list
  advance_progress(_("Loading incomplete files..."), 0.75);
  sprintf(str, "%s/incomplete.list", global.options.config_dir);
  resume_load(str, 0);

  // loading saved searches
  advance_progress(_("Loading search patterns..."), 0.80);
  search_pattern_load();

  advance_progress(_("Loading subscriptions..."), 0.83);
  subscription_load();

  update_status_line(0);

  advance_progress(_("Initializing statistic..."), 0.85);
  user_info_load();
  statistic_init(&global.statistic);

  advance_progress(_("Invoking startup processes..."), 0.95);
  gtk_idle_add(idle_function, NULL);
}

void global_exit()
{

  //  transfer_cancel_running();

  if (global.status.access_read) {
    user_info_save();
    access_save();
  }
  
  napster_disconnect(NULL);

  extra_win_get_geometry();

  if (global.timer >= 0)
    gtk_timeout_remove(global.timer);

  // destroying all sockets

  exec_kill_all();

  if (global.status.rc_read) write_rc();

  if (global.status.geometry_read) write_geometry();

  statistic_log(&global.statistic);

  write_allowed_links();

  // deleting commands
  command_delete_all();

  // l_freeing allowed links
  free_links(global.allowed_links);
  global.allowed_links = NULL;


  // and delete the global file list

  gtk_main_quit();
}


void destroy_file_row(gpointer data)
{
  file_t *file;

  file = (file_t *) data;

  if (file->longname)
    l_free(file->longname);
  if (file->shortname)
    l_free(file->shortname);
  if (file->winname)
    l_free(file->winname);
  if (file->user)
    l_free(file->user);
  if (file->md5)
    l_free(file->md5);
  l_free(file);
}

gint
channel_compare(GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2)
{

  char *text1 = NULL;
  char *text2 = NULL;
  int u1, u2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  text1 = GTK_CELL_TEXT(row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_TEXT(row2->cell[clist->sort_column])->text;

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  if ((clist->sort_column == 4) || (clist->sort_column == 0)) {
    return l_strcasecmp(text1, text2);
  } else if ((clist->sort_column == 1) ||
	     (clist->sort_column == 2) || (clist->sort_column == 3)) {
    sscanf(text1, "%d", &u1);
    sscanf(text2, "%d", &u2);
    if (u1 < u2)
      return -1;
    if (u1 > u2)
      return 1;
    return 0;
  } else {
    return 0;
  }
}

gint browse_compare(GtkCList * clist,
		    gconstpointer ptr1, gconstpointer ptr2)
{
  file_t *file1;
  file_t *file2;
  char *text1 = NULL;
  char *text2 = NULL;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  if (clist->sort_column == 0) {
    text1 = GTK_CELL_TEXT(row1->cell[0])->text;
    text2 = GTK_CELL_TEXT(row2->cell[0])->text;
    if (!text2)
      return (text1 != NULL);
    if (!text1)
      return -1;
    return l_strcasecmp(text1, text2);
  }

  file1 = row1->data;
  file2 = row2->data;

  if (!file2)
    return (file1 != NULL);
  if (!file1)
    return -1;

  if (clist->sort_column == 1) {
    if (file1->size < file2->size)
      return -1;
    if (file1->size > file2->size)
      return 1;
    return 0;
  } else if (clist->sort_column == 2) {
    if (file1->bitrate < file2->bitrate)
      return -1;
    if (file1->bitrate > file2->bitrate)
      return 1;
    return 0;
  } else if (clist->sort_column == 3) {
    if (file1->frequency < file2->frequency)
      return -1;
    if (file1->frequency > file2->frequency)
      return 1;
    return 0;
  } else if (clist->sort_column == 4) {
    if (file1->duration < file2->duration)
      return -1;
    if (file1->duration > file2->duration)
      return 1;
    return 0;
  } else {
    return 0;
  }
}

gint socket_compare(GtkCList * clist,
		    gconstpointer ptr1, gconstpointer ptr2)
{
  socket_t *socket1;
  socket_t *socket2;
  transfer_t *t1;
  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;
  float d1, d2;

  socket1 = row1->data;
  if (!socket1) return 0;
  socket2 = row2->data;
  if (!socket2) return 0;

  switch (clist->sort_column) {
  case 0:
    d1 = socket1->type;
    d2 = socket2->type;
    if (socket1->type == S_TRANSFER) {
      t1 = socket1->data;
      if (t1 && t1->type == T_UPLOAD) d1 += 0.5;
    }
    if (socket2->type == S_TRANSFER) {
      t1 = socket2->data;
      if (t1 && t1->type == T_UPLOAD) d2 += 0.5;
    }
    if (d1 < d2) return -1;
    if (d1 > d2) return 1;
    return 0;
  case 1:
    if (ntohl(socket1->ip_long) < ntohl(socket2->ip_long))
      return -1;
    if (ntohl(socket1->ip_long) > ntohl(socket2->ip_long))
      return 1;
    return 0;
  case 2:
    if (ntohs(socket1->port) < ntohs(socket2->port))
      return -1;
    if (ntohs(socket1->port) > ntohs(socket2->port))
      return 1;
    return 0;
  case 3:
    if (ntohs(socket1->cnt) < ntohs(socket2->cnt))
      return -1;
    if (ntohs(socket1->cnt) > ntohs(socket2->cnt))
      return 1;
    return 0;
  case 4:
    if (ntohs(socket1->fd) < ntohs(socket2->fd))
      return -1;
    if (ntohs(socket1->fd) > ntohs(socket2->fd))
      return 1;
    return 0;
  case 5:
    if (ntohs(socket1->timeout) < ntohs(socket2->timeout))
      return -1;
    if (ntohs(socket1->timeout) > ntohs(socket2->timeout))
      return 1;
    return 0;
  }  
  return 0;
}

gint transfer_compare(GtkCList * clist,
		      gconstpointer ptr1, gconstpointer ptr2)
{

  socket_t *socket;
  transfer_t *transfer1;
  transfer_t *transfer2;
  double p1, p2;
  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  socket = row1->data;
  if (!socket)
    return 0;
  transfer1 = socket->data;
  if (!transfer1)
    return 0;
  socket = row2->data;
  transfer2 = socket->data;
  if (!transfer2)
    return 0;

  /*
  if ((transfer1->status == S_FINISHED) && (transfer2->status != S_FINISHED)) {
    if (clist->sort_type == GTK_SORT_ASCENDING) return -1;
    else return 1;
  }
  if ((transfer1->status != S_FINISHED) && (transfer2->status == S_FINISHED)) {
    if (clist->sort_type == GTK_SORT_ASCENDING) return 1;
    else return -1;
  }

  if (transfer_in_progress(transfer1) && !transfer_in_progress(transfer2)) {
    if (clist->sort_type == GTK_SORT_ASCENDING) return -1;
    else return 1;
  }
  if (!transfer_in_progress(transfer1) && transfer_in_progress(transfer2)) {
    if (clist->sort_type == GTK_SORT_ASCENDING) return 1;
    else return -1;
  }
  */
  switch (clist->sort_column) {
  case 0:
    if (!transfer1->shortname || !transfer2->shortname)
      return 0;
    return l_strcasecmp(transfer1->shortname, transfer2->shortname);
    break;
  case 1:
    if (transfer1->size < transfer2->size)
      return -1;
    if (transfer1->size > transfer2->size)
      return 1;
    return 0;
    break;
  case 2:
    return l_strcasecmp(transfer1->user_info->user, transfer2->user_info->user);
    break;
  case 3:
    if (transfer1->status < transfer2->status)
      return -1;
    if (transfer1->status > transfer2->status)
      return 1;
    return 0;
    
  case 4:
    if (transfer1->user_info->linespeed < transfer2->user_info->linespeed)
      return -1;
    if (transfer1->user_info->linespeed > transfer2->user_info->linespeed)
      return 1;
    return 0;
    break;
  case 5:
    if (transfer1->size)
      p1 = (double) transfer1->progress / (double) transfer1->size;
    else
      p1 = 0;
    if (transfer2->size)
      p2 = (double) transfer2->progress / (double) transfer2->size;
    else
      p2 = 0;
    if (p1 < p2)
      return -1;
    if (p1 > p2)
      return 1;
    return 0;
    break;
  case 6:
    if (transfer1->rate < transfer2->rate)
      return -1;
    if (transfer1->rate > transfer2->rate)
      return 1;
    return 0;
    break;
  case 7:
    if (transfer1->timeleft < transfer2->timeleft)
      return -1;
    if (transfer1->timeleft > transfer2->timeleft)
      return 1;
    return 0;
    break;
  }
  return 0;
}

gint trans_comp(transfer_t * t1, transfer_t * t2, int col)
{
  double p1, p2;

  if (!t1)
    return 0;
  if (!t2)
    return 0;

  switch (col) {
  case 0:
    l_strcasecmp(t1->shortname, t2->shortname);
    break;
  case 1:
    if (t1->size < t2->size)
      return -1;
    if (t1->size > t2->size)
      return 1;
    return 0;
    break;
  case 2:
    return l_strcasecmp(t1->user_info->user, t2->user_info->user);
    break;
  case 3:
    if (t1->status < t2->status)
      return -1;
    if (t1->status > t2->status)
      return 1;
    return 0;
    break;
  case 4:
    if (t1->user_info->linespeed < t2->user_info->linespeed)
      return -1;
    if (t1->user_info->linespeed > t2->user_info->linespeed)
      return 1;
    return 0;
    break;
  case 5:
    if (t1->size)
      p1 = (double) t1->progress / (double) t1->size;
    else
      p1 = 0;
    if (t2->size)
      p2 = (double) t2->progress / (double) t2->size;
    else
      p2 = 0;
    if (p1 < p2)
      return -1;
    if (p1 > p2)
      return 1;
    return 0;
    break;
  case 6:
    if (t1->rate < t2->rate)
      return -1;
    if (t1->rate > t2->rate)
      return 1;
    return 0;
    break;
  case 7:
    if (t1->timeleft < t2->timeleft)
      return -1;
    if (t1->timeleft > t2->timeleft)
      return 1;
    return 0;
    break;
  }
  return 0;
}

gint trans_comp2(transfer_t * t1, transfer_t * t2, int col)
{
  double p1, p2;
  
  if (!t1)
    return 0;
  if (!t2)
    return 0;

  switch (col) {
  case 0:
    return l_strcasecmp(t1->shortname, t2->shortname);
    break;
  case 1:
    if (t1->size < t2->size)
      return -1;
    if (t1->size > t2->size)
      return 1;
    return 0;
    break;
  case 2:
    return l_strcasecmp(t1->user_info->user, t2->user_info->user);
    break;
  case 3:
    if (t1->size)
      p1 = (double) t1->progress / (double) t1->size;
    else
      p1 = 0;
    if (t2->size)
      p2 = (double) t2->progress / (double) t2->size;
    else
      p2 = 0;
    if (p1 < p2)
      return -1;
    if (p1 > p2)
      return 1;
    return 0;
    break;
  case 4:
    if (t1->status < t2->status)
      return -1;
    if (t1->status > t2->status)
      return 1;
    return 0;
    break;
  }
  return 0;
}

gint resume_comp(resume_t * r1, resume_t * r2, int col)
{
  double p1, p2;
  int l1, l2;

  if (!r1)
    return 0;
  if (!r2)
    return 0;

  switch (col) {
  case 0:
    return l_strcasecmp(extract_filename(r1->filename),
		      extract_filename(r2->filename));
    break;
  case 1:
    if (r1->size < r2->size)
      return -1;
    if (r1->size > r2->size)
      return 1;
    return 0;
    break;
  case 2:
    if (!r2->user)
      return (r1->user != NULL);
    if (!r1->user)
      return -1;
    return l_strcasecmp(r1->user, r2->user);
    break;
  case 3:
    if (r1->search)
      l1 = g_list_length(r1->search->results);
    else
      l1 = 0;
    if (r2->search)
      l2 = g_list_length(r2->search->results);
    else
      l2 = 0;
    if (l1 < l2)
      return -1;
    if (l1 > l2)
      return 1;
    return 0;
    break;
  case 4:
    return 0;
    break;
  case 5:
    if (r1->size)
      p1 = (double) r1->local_size / (double) r1->size;
    else
      p1 = 0;
    if (r2->size)
      p2 = (double) r2->local_size / (double) r2->size;
    else
      p2 = 0;
    if (p1 < p2)
      return -1;
    if (p1 > p2)
      return 1;
    return 0;
    break;
  case 6:
    return 0;
    break;
  case 7:
    return 0;
    break;
  }
  return 0;
}

gint resume_comp2(resume_t * r1, resume_t * r2, int col)
{
  double p1, p2;
  int l1, l2;
  time_t tim1;
  time_t tim2;

  if (!r1)
    return 0;
  if (!r2)
    return 0;

  switch (col) {
  case 0:
    return l_strcasecmp(extract_filename(r1->filename),
		      extract_filename(r2->filename));
    break;
  case 1:
    if (r1->size < r2->size)
      return -1;
    if (r1->size > r2->size)
      return 1;
    return 0;
    break;
  case 2:
    if (!r2->user)
      return (r1->user != NULL);
    if (!r1->user)
      return -1;
    return l_strcasecmp(r1->user, r2->user);
    break;
  case 3:
    if (r1->size)
      p1 = (double) r1->local_size / (double) r1->size;
    else
      p1 = 0;
    if (r2->size)
      p2 = (double) r2->local_size / (double) r2->size;
    else
      p2 = 0;
    if (p1 < p2)
      return -1;
    if (p1 > p2)
      return 1;
    return 0;
    break;
  case 4:
    if (r1->search)
      l1 = g_list_length(r1->search->results);
    else
      l1 = 0;
    if (r2->search)
      l2 = g_list_length(r2->search->results);
    else
      l2 = 0;
    if (l1 < l2)
      return -1;
    if (l1 > l2)
      return 1;
    return 0;
    break;
  case 5:
    tim1 = resume_time_of_death(r1);
    tim2 = resume_time_of_death(r2);
    if (tim2 == 0) return 1;
    if (tim1 == 0) return -1;
    if (tim2 == 1) return -1;
    if (tim1 == 1) return 1;
    if (r1->last_access+tim1 < r2->last_access+tim2)
      return -1;
    if (r1->last_access+tim1 > r2->last_access+tim2)
      return 1;
    return 0;
    break;
  }
  return 0;
}

gint download_compare(GtkCList * clist,
		      gconstpointer ptr1, gconstpointer ptr2)
{
  resume_t *resume1;
  resume_t *resume2;
  socket_t *socket1;
  socket_t *socket2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  GtkCTreeRow *rowt1 = (GtkCTreeRow *) ptr1;
  GtkCTreeRow *rowt2 = (GtkCTreeRow *) ptr2;

  if ((rowt1->parent && !rowt2->parent) ||
      (!rowt1->parent && rowt2->parent))
    return 0;

  if (rowt1->parent) {
    socket1 = row1->data;
    socket2 = row2->data;
    return trans_comp(socket1->data, socket2->data, clist->sort_column);
  } else {
    resume1 = row1->data;
    resume2 = row2->data;

    /*
    if ((resume1->status == R_FINISHED) && (resume2->status != R_FINISHED)) {
      if (clist->sort_type == GTK_SORT_ASCENDING) return -1;
      else return 1;
    }
    if ((resume1->status != R_FINISHED) && (resume2->status == R_FINISHED)) {
      if (clist->sort_type == GTK_SORT_ASCENDING) return 1;
      else return -1;
    }
    */
    if (!resume2->socket) {
      if (!resume1->socket) {
	return resume_comp(resume1, resume2, clist->sort_column);
      } else
	if (clist->sort_type == GTK_SORT_ASCENDING) return -1;
	else return 1;
    } else {
      if (!resume1->socket)
	if (clist->sort_type == GTK_SORT_ASCENDING) return 1;
	else return -1;
      else {
	if (clist->sort_column == 0)
	  return resume_comp(resume1, resume2, clist->sort_column);
	else
	  return trans_comp(resume1->socket->data,
			    resume2->socket->data, clist->sort_column);
      }
    }
  }
}

gint download_compare2(GtkCList * clist,
		       gconstpointer ptr1, gconstpointer ptr2)
{
  resume_t *resume1;
  resume_t *resume2;
  socket_t *socket1;
  socket_t *socket2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  GtkCTreeRow *rowt1 = (GtkCTreeRow *) ptr1;
  GtkCTreeRow *rowt2 = (GtkCTreeRow *) ptr2;

  if ((rowt1->parent && !rowt2->parent) ||
      (!rowt1->parent && rowt2->parent))
    return 0;

  if (rowt1->parent) {
    socket1 = row1->data;
    socket2 = row2->data;
    return trans_comp2(socket1->data, socket2->data, clist->sort_column);
  } else {
    resume1 = row1->data;
    resume2 = row2->data;
    if (!resume2->socket) {
      if (!resume1->socket) {
	return resume_comp2(resume1, resume2, clist->sort_column);
      } else
	if (clist->sort_type == GTK_SORT_ASCENDING)
	  return -1;
	else
	  return 1;
    } else {
      if (!resume1->socket)
	if (clist->sort_type == GTK_SORT_ASCENDING)
	  return 1;
	else
	  return -1;
      else {
	return trans_comp2(resume1->socket->data,
			   resume2->socket->data, clist->sort_column);
      }
    }
  }
}

gint hotlist_compare(GtkCList * clist,
		     gconstpointer ptr1, gconstpointer ptr2)
{

  hot_t *hot1;
  hot_t *hot2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  hot1 = row1->data;
  if (!hot1)
    return 0;
  hot2 = row2->data;
  if (!hot2)
    return 0;

  switch (clist->sort_column) {
  case 0:
    if (hot1->online == hot2->online) {
      return l_strcasecmp(hot1->user, hot2->user);
    } else {
      if (hot1->online < hot2->online)
	return -1;
      if (hot1->online > hot2->online)
	return 1;
    }
    break;
  case 1:
    if ((hot1->online == HOT_ONLINE) && (hot2->online == HOT_ONLINE)) {
      if (hot1->speed < hot2->speed)
	return -1;
      if (hot1->speed > hot2->speed)
	return 1;
    } else {
      if (hot1->online < hot2->online)
	return -1;
      if (hot1->online > hot2->online)
	return 1;
    }
    return 0;
    break;
  }
  return 0;
}

gint access_compare(GtkCList * clist,
		    gconstpointer ptr1, gconstpointer ptr2)
{

  access_t *ac1;
  access_t *ac2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  ac1 = row1->data;
  if (!ac1)
    return 0;
  ac2 = row2->data;
  if (!ac2)
    return 0;

  switch (clist->sort_column) {
  case 0:
    return l_strcasecmp(ac1->name, ac2->name);
    break;
  case 1:
    if (ac1->accesses < ac2->accesses)
      return -1;
    if (ac1->accesses > ac2->accesses)
      return 1;
    return 0;
    break;
  case 2:
    if (ac1->last < ac2->last)
      return -1;
    if (ac1->last > ac2->last)
      return 1;
    return 0;
    break;
  }
  return 0;
}

gint
client_compare(GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2)
{

  char *text1 = NULL;
  char *text2 = NULL;
  int u1, u2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  text1 = GTK_CELL_TEXT(row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_TEXT(row2->cell[clist->sort_column])->text;

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  if (clist->sort_column == 1) {
    return l_strcasecmp(text1, text2);
  } else if (clist->sort_column == 0) {
    sscanf(text1, "%d", &u1);
    sscanf(text2, "%d", &u2);
    if (u1 < u2)
      return -1;
    if (u1 > u2)
      return 1;
    return 0;
  } else {
    return 0;
  }
}

void make_list_from_string(GList ** glist, char *text, char *sep)
{
  char *pos2;
  GList *dlist;

  for (dlist = *glist; dlist; dlist = dlist->next) {
    l_free(dlist->data);
  }
  if (*glist)
    g_list_free(*glist);
  *glist = NULL;

  pos2 = strtok(text, sep);
  while (pos2) {
    if (strlen(pos2) > 0) {
      *glist = g_list_append(*glist, l_strdup(pos2));
    }
    pos2 = strtok(NULL, sep);
  }
}

char *make_string_from_list(GList * glist, char *sep)
{
  static char result[2048];
  char *text;
  GList *dlist;

  result[0] = 0;
  if (glist == NULL) {
    return result;
  }

  for (dlist = glist; dlist; dlist = dlist->next) {
    text = (char *) (dlist->data);
    if (strlen(result) > 0)
      strcat(result, sep);
    strcat(result, text);
  }

  return result;
}

void clones_clear()
{
  GList *dlist;
  GList *dlist2;
  clone_t *clone;

  for (dlist = global.clones; dlist; dlist = dlist->next) {
    clone = (clone_t *) (dlist->data);
    for (dlist2 = clone->nicks; dlist2; dlist2 = dlist2->next) {
      l_free(dlist2->data);
    }
    g_list_free(clone->nicks);
    l_free(clone->ip);
    l_free(clone);
  }
  g_list_free(global.clones);
  global.clones = NULL;
}

client_t *is_client_in_list(GList * glist, char *t)
{
  GList *dlist;
  client_t *client;

  dlist = g_list_first(glist);
  while (dlist) {
    client = (client_t *) (dlist->data);
    if (!strcmp(t, client->info) && (client->cnt > 0))
      return client;
    dlist = g_list_next(dlist);
  }
  return NULL;
}

char *is_string_in_list(GList * glist, char *t)
{
  GList *dlist;
  char *text;

  dlist = g_list_first(glist);

  while (dlist) {
    text = (char *) (dlist->data);
    if (!l_strcasecmp(t, text)) {
      return text;
    }
    dlist = g_list_next(dlist);
  }
  return NULL;
}

char *is_prefix_in_list(GList * glist, char *t)
{
  GList *dlist;
  char *text;

  dlist = g_list_first(glist);

  //  printf("user: %s\n", t);
  while (dlist) {
    text = (char *) (dlist->data);
    //    printf("%s\n", text);
    if (t == NULL)
      return text;
    if (!strncasecmp(t, text, strlen(t))) {
      return text;
    }
    dlist = g_list_next(dlist);
  }
  return NULL;
}

int cmp_str(char *s1, char *s2)
{
  int i1, len;

  i1 = strlen(s1);
  len = strlen(s2);

  if (i1 < len)
    len = i1;

  for (i1 = 0; i1 < len; i1++) {
    if (toupper(s1[i1]) != toupper(s2[i1]))
      break;
  }
  return i1;
}

int calc_list_prefix(GList * glist)
{
  int res;
  int temp;
  char *text;

  if (!glist) return 0;

  text = glist->data;
  res = strlen(text);

  for (; glist; glist = glist->next) {
    temp = cmp_str(glist->data, text);
    if (temp < res) res = temp;
  }
  return res;
}

int calc_command_prefix(GList * glist)
{
  int res;
  int temp;
  char *text;
  command_t *command;
  
  if (!glist) return 0;

  command = glist->data;
  text = command->name;
  res = strlen(text);

  for ( ; glist; glist = glist->next) {
    command = glist->data;
    temp = cmp_str(command->name, text);
    if (temp < res) res = temp;
  }
  return res;
}

void play_file(char *filename)
{
  char *command;
  suffix_t *suffix;
  struct stat st;

  //  printf("checking file [%s]\n", filename);
  if (stat(filename, &st) < 0)
    return;

  suffix = get_suffix(filename);
  if (!suffix) {
    openfile_dialog(_("Cannot open file: Unknown Suffix"));
    return;
  }
  if (!suffix->application || (strlen(suffix->application) == 0)) {
    command =
	l_strdup_printf(_
			("Cannot open file [%s]\nNo application specified for suffix [%s]"),
			filename, suffix->suffix);
    openfile_dialog(command);
    l_free(command);
    return;
  }

  command = l_strdup_printf("-quiet %s \"%s\"", suffix->application, filename);
  exec_command(command);
  l_free(command);
}

void set_last_server(server_t * server)
{
  if (global.last_server) {
    server_destroy(global.last_server);
  }
  global.last_server = server_copy(server);;
}

void set_button_state(GtkWidget * button, int open)
{
  GtkWidget *temp;

  if (open) {
    temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "pix_open"));
    gtk_widget_hide(temp);
    temp =
	GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "pix_closed"));
    gtk_widget_show(temp);
    temp =
	GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "con_widget"));
    gtk_widget_show(temp);
  } else {
    temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "pix_open"));
    gtk_widget_show(temp);
    temp =
	GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "pix_closed"));
    gtk_widget_hide(temp);
    temp =
	GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "con_widget"));
    gtk_widget_hide(temp);
  }
}

int toggle_button_state(GtkWidget * button)
{
  GtkWidget *temp;

  temp = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(button), "con_widget"));

  if (GTK_WIDGET_VISIBLE(temp)) {
    set_button_state(button, 0);
    return 0;
  } else {
    set_button_state(button, 1);
    return 1;
  }
}

void set_up_button(GtkWidget * button, char *pix1, char *pix2, char *wid)
{
  GtkObject *obj;
  GtkWidget *temp;

  obj = GTK_OBJECT(button);
  temp = lookup_widget(button, pix1);
  gtk_object_set_data(obj, "pix_open", temp);
  temp = lookup_widget(button, pix2);
  gtk_object_set_data(obj, "pix_closed", temp);
  temp = lookup_widget(button, wid);
  gtk_object_set_data(obj, "con_widget", temp);
}

void set_up_button2(GtkWidget * button,
		    GtkWidget * pix1, GtkWidget * pix2, GtkWidget * wid)
{
  GtkObject *obj;

  obj = GTK_OBJECT(button);
  gtk_object_set_data(obj, "pix_open", pix1);
  gtk_object_set_data(obj, "pix_closed", pix2);
  gtk_object_set_data(obj, "con_widget", wid);
}

void show_bans(char *channel)
{
  GtkWidget *temp;
  char str[1024];
  char *data;

  if (global.ban_win) {
    temp = lookup_widget(global.ban_win, "clist3");
    gtk_clist_clear(GTK_CLIST(temp));
  } else {
    global.ban_win = create_ban_win();
    gtk_widget_show(global.ban_win);
  }

  data = gtk_object_get_user_data(GTK_OBJECT(global.ban_win));
  if (data)
    l_free(data);
  if (channel) {
    sprintf(str, _("Banned Users for Channel %s"), channel);
    send_command(CMD_CLIENT_CHANNEL_BAN_LIST, channel);
    gtk_object_set_data(GTK_OBJECT(global.ban_win), "channel", l_strdup(channel));
  } else {
    sprintf(str, _("Global banned Users"));
    send_command(CMD_CLIENT_BANLIST, "");
    gtk_object_set_data(GTK_OBJECT(global.ban_win), "channel", NULL);
    temp = lookup_widget(global.ban_win, "button186");
    if (global.user.level > L_USER) {
      gtk_widget_set_sensitive(temp, TRUE);
    } else {
      gtk_widget_set_sensitive(temp, FALSE);
    }
  }
  gtk_window_set_title(GTK_WINDOW(global.ban_win), str);
}

/////////////////////////////////////////////////////////////
// the code of the cparse() is almost copied from TekNap
/////////////////////////////////////////////////////////////
char *cparse(char *input)
{
  int read;
  int write;
  int noappend = 1;
  static char output[2048];

  read = write = 0;

  while (input[read]) {
    if (input[read] == '%') {
      read++;
      switch (input[read]) {
      case 'k':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '0';
	break;
      case 'r':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '1';
	break;
      case 'g':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '2';
	break;
      case 'y':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '3';
	break;
      case 'b':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '4';
	break;
      case 'm':
      case 'p':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '5';
	break;
      case 'c':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '6';
	break;
      case 'w':
	output[write++] = '\003';
	output[write++] = '3';
	output[write++] = '7';
	break;

      case 'K':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++] = '0';
	break;
      case 'R':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++] = '1';
	break;
      case 'G':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++] = '2';
	break;
      case 'Y':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++] = '3';
	break;
      case 'B':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++] = '4';
	break;
      case 'M':
      case 'P':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++] = '5';
	break;
      case 'C':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++] = '6';
	break;
      case 'W':
	output[write++] = '\003';
	output[write++] = '5';
	output[write++] = '7';
	break;

      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
	output[write++] = '\003';
	output[write++] = ',';
	output[write++] = '4';
	output[write++] = input[read];
	break;

      case 'F':
	output[write++] = '\006';
	break;
      case 'n':
	output[write++] = '\003';
	output[write++] = '\017';
	break;
      case 'N':
	noappend = 1;
	break;
      case '%':
	output[write++] = input[read];
	break;
      default:
	output[write++] = '%';
	output[write++] = input[read];
	break;
      }
      read++;
    } else {
      output[write++] = input[read++];
    }
  }
  if (noappend == 0) {
    output[write++] = '\003';
    output[write++] = '-';
    output[write++] = '1';
  }
  output[write] = 0;

  return output;
}

void client_message(char *text, const char *fmt, ...)
{
  va_list ap;
  char text2[1024];
  char *prefix;

  va_start(ap, fmt);
  vsprintf(text2, fmt, ap);
  va_end(ap);

  chat_print_time_stamp(global.current_page, M_PUBLIC);
  if (global.scheme) {
    prefix = cparse(global.scheme->client_prefix);
    chat_print("message", prefix);
  }
  if (text) {
    prefix = cparse("%W[");
    chat_print("message", prefix);
    chat_print("message", text);
    prefix = cparse("%W] ");
    chat_print("message", prefix);
  }
  chat_print_ln("message", text2);
}

void server_message(char *text, const char *fmt, ...)
{
  va_list ap;
  char text2[2048];
  char *prefix;
  chat_page_t *page;

  if (global.options.no_piping & NOPIPE_SERVER) return;

  va_start(ap, fmt);
  vsprintf(text2, fmt, ap);
  va_end(ap);

  if (global.options.piping & PIPE_SERVER) {
    page = chat_page_search("Server", P_OTHER);
    if (!page)
      page = create_other_page("Server", _("Server"));
  } else {
    page = global.current_page;
  }

  chat_print_time_stamp(page, M_PUBLIC);
  prefix = cparse(global.scheme->server_prefix);
  chat_print_colored(page, M_PUBLIC, "error", prefix);
  if (text) {
    prefix = cparse("%W[");
    chat_print_colored(page, M_PUBLIC, "error", prefix);
    chat_print_colored(page, M_PUBLIC, "error", text);
    prefix = cparse("%W] ");
    chat_print_colored(page, M_PUBLIC, "error", prefix);
  }
  chat_print_colored(page, M_PUBLIC, "error", text2);
  chat_print_colored(page, M_PUBLIC, "error", "\n");
}

void protocol_message(int direction, int type, char* text)
{
  char text2[2048];
  char *prefix;
  chat_page_t *page;

  page = chat_page_search("Protocol", P_OTHER);
  if (!page)
    page = create_other_page("Protocol", _("Protocol"));
  if (!page) return;

  chat_print_time_stamp(page, M_PUBLIC);
  if (!direction) prefix = cparse("%K>%r>%R> ");
  else prefix = cparse("%C<%c<%K< ");
  chat_print_colored(page, M_PUBLIC, "error", prefix);

  sprintf(text2, "%5d ", type);
  chat_print_colored(page, M_PUBLIC, "error", text2);
  chat_print_colored(page, M_PUBLIC, "message", "[");
  chat_print_colored(page, M_PUBLIC, "text", text);
  chat_print_colored(page, M_PUBLIC, "message", "]");
  chat_print_colored(page, M_PUBLIC, "text", "\n");
}

void toggle_friend(char *user)
{
  if (string_list_search(LIST_FRIEND, user)) {
    friend_remove(user);
  } else {
    friend_add(user);
  }
}

void toggle_enemy(char *user)
{
  if (string_list_search(LIST_ENEMY, user)) {
    enemy_remove(user);
  } else {
    enemy_add(user);
  }
}

void toggle_nodownload(char *user)
{
  if (string_list_search(LIST_NODOWNLOAD, user)) {
    nodownload_remove(user);
  } else {
    nodownload_add(user);
  }
}

void opennap_notify()
{
  client_message(_("Message"),
		 _("Opennap commands are not allowed on this server"));
}

int opennap_version(int major, int minor)
{
  if (!global.napster)
    return 1;
  if (SERVER->network == N_NAPSTER)
    return 0;
  if (SERVER->network == N_SLAVANAP)
    return 1;
  if (SERVER->network == N_CQ_NAP)
    return 1;

  return ((SERVER->major > major) ||
	  ((SERVER->major == major) && (SERVER->minor >= minor)));
}

char *arg(char *data, int last)
{
  static char *string;
  char *pos;
  char *pos2;

  if (data)
    string = data;
  if (!string)
    return NULL;

  if (!last)
    while (isspace(*string))
      string++;

  if (last) {
    pos = string;
    string = NULL;
    if (*pos == 0)
      return NULL;
    else
      return pos;
  }
  if (*string == '\"') {
    pos = ++string;
    pos2 = strchr(string, '\"');
    if (pos2) {
      *pos2 = 0;
      string = pos2 + 1;
      if (*string == ' ')
	string++;
      return pos;
    } else {
      string = NULL;
      return NULL;
    }
  } else {
    pos = string;
    pos2 = strchr(string, ' ');
    if (pos2) {
      *pos2 = 0;
      string = pos2 + 1;
    } else {
      string = NULL;
    }
    if (*pos == 0)
      return NULL;
    else
      return pos;
  }

  return NULL;
}

void convert_chars(char *text, char from, char to)
{
  char *pos;

  while ((pos = strchr(text, from)) != NULL)
    pos[0] = to;
}

GtkWidget *create_customize_win(GtkCList * clist)
{
  GtkWidget *customize_win;
  GtkWidget *frame138;
  GtkWidget *vbox84;
  GtkWidget *vbox85;
  GtkWidget *checkbutton;
  GtkWidget *hseparator19;
  GtkWidget *frame139;
  GtkWidget *hbox213;
  GtkWidget *button151;
  GtkWidget *button152;
  int i1;
  char wname[1024];
  GtkWidget *title;

  customize_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data(GTK_OBJECT(customize_win), "customize_win",
		      customize_win);
  gtk_window_set_title(GTK_WINDOW(customize_win), _("Customize List"));
  gtk_window_set_modal(GTK_WINDOW(customize_win), TRUE);
  gtk_window_set_policy(GTK_WINDOW(customize_win), FALSE, TRUE, TRUE);

  frame138 = gtk_frame_new(NULL);
  gtk_widget_ref(frame138);
  gtk_object_set_data_full(GTK_OBJECT(customize_win), "frame138", frame138,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(frame138);
  gtk_container_add(GTK_CONTAINER(customize_win), frame138);
  gtk_container_set_border_width(GTK_CONTAINER(frame138), 5);

  vbox84 = gtk_vbox_new(FALSE, 5);
  gtk_widget_ref(vbox84);
  gtk_object_set_data_full(GTK_OBJECT(customize_win), "vbox84", vbox84,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox84);
  gtk_container_add(GTK_CONTAINER(frame138), vbox84);
  gtk_container_set_border_width(GTK_CONTAINER(vbox84), 5);

  vbox85 = gtk_vbox_new(FALSE, 0);
  gtk_widget_ref(vbox85);
  gtk_object_set_data_full(GTK_OBJECT(customize_win), "vbox85", vbox85,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox85);
  gtk_box_pack_start(GTK_BOX(vbox84), vbox85, TRUE, TRUE, 0);

  for (i1 = 0; i1 < clist->columns; i1++) {
    title = gtk_clist_get_column_widget(clist, i1);
    sprintf(wname, _("Show column \"%s\""), GTK_LABEL(title)->label);
    checkbutton = gtk_check_button_new_with_label(wname);
    gtk_widget_ref(checkbutton);
    sprintf(wname, "check%d", i1);
    gtk_object_set_data_full(GTK_OBJECT(customize_win), wname, checkbutton,
			     (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show(checkbutton);
    gtk_box_pack_start(GTK_BOX(vbox85), checkbutton, FALSE, FALSE, 0);
    if (clist->column[i1].visible)
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton), TRUE);
    else
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton), FALSE);
  }

  hseparator19 = gtk_hseparator_new();
  gtk_widget_ref(hseparator19);
  gtk_object_set_data_full(GTK_OBJECT(customize_win), "hseparator19",
			   hseparator19,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hseparator19);
  gtk_box_pack_start(GTK_BOX(vbox84), hseparator19, FALSE, FALSE, 0);

  frame139 = gtk_frame_new(NULL);
  gtk_widget_ref(frame139);
  gtk_object_set_data_full(GTK_OBJECT(customize_win), "frame139", frame139,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(frame139);
  gtk_box_pack_start(GTK_BOX(vbox84), frame139, FALSE, FALSE, 0);
  gtk_frame_set_shadow_type(GTK_FRAME(frame139), GTK_SHADOW_IN);

  hbox213 = gtk_hbox_new(TRUE, 5);
  gtk_widget_ref(hbox213);
  gtk_object_set_data_full(GTK_OBJECT(customize_win), "hbox213", hbox213,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox213);
  gtk_container_add(GTK_CONTAINER(frame139), hbox213);
  gtk_widget_set_usize(hbox213, -2, 37);
  gtk_container_set_border_width(GTK_CONTAINER(hbox213), 5);

  button151 = gtk_button_new_with_label(_("Apply"));
  gtk_widget_ref(button151);
  gtk_object_set_data_full(GTK_OBJECT(customize_win), "button151",
			   button151, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(button151);
  gtk_box_pack_start(GTK_BOX(hbox213), button151, TRUE, TRUE, 0);

  button152 = gtk_button_new_with_label(_("Close"));
  gtk_widget_ref(button152);
  gtk_object_set_data_full(GTK_OBJECT(customize_win), "button152",
			   button152, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(button152);
  gtk_box_pack_start(GTK_BOX(hbox213), button152, TRUE, TRUE, 0);

  gtk_signal_connect(GTK_OBJECT(customize_win), "destroy",
		     GTK_SIGNAL_FUNC(on_customize_win_destroy), NULL);
  gtk_signal_connect(GTK_OBJECT(button151), "clicked",
		     GTK_SIGNAL_FUNC(on_button1x_clicked), NULL);
  gtk_signal_connect(GTK_OBJECT(button152), "clicked",
		     GTK_SIGNAL_FUNC(on_button2x_clicked), NULL);
  gtk_object_set_data(GTK_OBJECT(customize_win), "ref_clist", clist);

  return customize_win;
}

void show_clients()
{
  GtkWidget *temp;

  if (!global.client_win) {
    global.client_win = create_client_win();
    temp = lookup_widget(global.client_win, "clist8");
    gtk_clist_set_sort_column(GTK_CLIST(temp), 0);
    gtk_clist_set_auto_sort(GTK_CLIST(temp), TRUE);
    gtk_clist_set_compare_func(GTK_CLIST(temp), client_compare);

    cmd_version_stats("");
  }
  gtk_widget_show(global.client_win);

  if (!global.client_list)
    on_button149_clicked(NULL, NULL);
}

gint
user2_compare(GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2)
{

  char *text1 = NULL;
  char *text2 = NULL;
  unsigned long l1, l2;
  GdkColor color = { 0, 0xff00, 0xbf00, 0xbf00 };

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  text1 = GTK_CELL_TEXT(row1->cell[clist->sort_column])->text;
  text2 = GTK_CELL_TEXT(row2->cell[clist->sort_column])->text;

  if (!text2)
    return (text1 != NULL);

  if (!text1)
    return -1;

  if (clist->sort_column == 0) {
    return l_strcasecmp(text1, text2);
  } else if (clist->sort_column == 1) {
    l1 = inet_network(text1);
    l2 = inet_network(text2);
    if (l1 < l2)
      return -1;
    else if (l1 > l2)
      return 1;
    else {
      row1->background = color;
      row1->bg_set = TRUE;
      if (GTK_WIDGET_REALIZED(clist))
	gdk_color_alloc(gtk_widget_get_colormap(GTK_WIDGET(clist)),
			&row1->background);
      row2->background = color;
      row2->bg_set = TRUE;
      if (GTK_WIDGET_REALIZED(clist))
	gdk_color_alloc(gtk_widget_get_colormap(GTK_WIDGET(clist)),
			&row2->background);

      return 0;
    }
  }
  return 0;
}

void show_global_users(char *args, int clear)
{
  GtkWidget *temp;

  if (global.user_win) {
    temp = lookup_widget(global.user_win, "clist12");
  } else {
    global.user_win = create_user_win();
    on_entry74_changed(NULL, NULL);
    temp = lookup_widget(global.user_win, "clist12");
    gtk_clist_set_compare_func(GTK_CLIST(temp),
			       (GtkCListCompareFunc) user2_compare);
  }
  if (clear) {
    clones_clear();
    gtk_clist_clear(GTK_CLIST(temp));
  }
  gtk_widget_show(global.user_win);

  if (args) {
    send_command(CMD_CLIENT_GLOBAL_USER_LIST, args);
    temp = lookup_widget(global.user_win, "button164");
    gtk_widget_set_sensitive(temp, FALSE);
  }
}

void convert_file(char *name)
{
  char *pos;
  char *pos2;

  if (strncmp(name, "|||", 3))
    return;

  pos2 = name;
  pos = strrchr(name, '.');
  if (!pos)
    return;
  while (pos2 + 3 < pos) {
    pos2[0] = pos2[3];
    pos2++;
  }
  pos2[0] = 0;
  pos2 = strrchr(name, '|');
  if (!pos2)
    return;
  pos2[0] = '.';

  return;
}

file_t *file_dup(file_t * file)
{
  file_t *dest;

  dest = (file_t *) l_malloc(sizeof(file_t));
  if (file->longname)
    dest->longname = l_strdup(file->longname);
  if (file->winname)
    dest->winname = l_strdup(file->winname);
  if (file->shortname)
    dest->shortname = l_strdup(file->shortname);
  if (file->user)
    dest->user = l_strdup(file->user);
  if (file->md5)
    dest->md5 = l_strdup(file->md5);
  dest->size = file->size;
  dest->ip = file->ip;
  dest->bitrate = file->bitrate;
  dest->frequency = file->frequency;
  dest->duration = file->duration;
  dest->linespeed = file->linespeed;
  dest->flags = file->flags;
  dest->local = file->local;
  dest->mime_type = file->mime_type;
  dest->ping = file->ping;

  return dest;
}

int get_mimetype(char *name)
{
  GList *dlist;
  char *suf;
  suffix_t *suffix;
  int i1;

  suf = strrchr(name, '.');
  if (!suf)
    return 0;
  else
    suf++;

  for (i1 = 1; i1 < MIME_SIZE; i1++) {
    for (dlist = global.mimetype[i1].suffixes; dlist; dlist = dlist->next) {
      suffix = (suffix_t *) (dlist->data);
      if (!l_strcasecmp(suf, suffix->suffix))
	return i1;
    }
  }
  return 0;
}

suffix_t *get_suffix(char *name)
{
  GList *dlist;
  char *suf;
  suffix_t *suffix;
  int i1;

  suf = strrchr(name, '.');
  if (!suf)
    return NULL;
  else
    suf++;

  for (i1 = 1; i1 < MIME_SIZE; i1++) {
    for (dlist = global.mimetype[i1].suffixes; dlist; dlist = dlist->next) {
      suffix = (suffix_t *) (dlist->data);
      if (!l_strcasecmp(suf, suffix->suffix))
	return suffix;
    }
  }
  return NULL;
}

void on_safe_exit_cancel(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data ATTR_UNUSED)
{
  global.status.exiting = E_NONE;
  lib_apply();
}

GtkWidget *create_mode_popup(void)
{
  GtkWidget *mode_popup;
  GtkWidget *separator;
  GtkAccelGroup *mode_popup_accels;
  GtkWidget *mode;
  
  mode_popup = gtk_menu_new();
  gtk_object_set_data(GTK_OBJECT(mode_popup), "mode_popup", mode_popup);
  mode_popup_accels =
    gtk_menu_ensure_uline_accel_group(GTK_MENU(mode_popup));

  if (global.status.connection < 2) {
    mode = gtk_menu_item_new_with_label(_("Not connected"));
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    gtk_widget_set_sensitive(mode, FALSE);
  } else if (!opennap_version(0, 0)) {
    mode = gtk_menu_item_new_with_label(_("Opennap only"));
    gtk_widget_ref(mode);
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    gtk_widget_set_sensitive(mode, FALSE);
  } else {
    if (global.status.exiting == E_SAFE) {
      mode = gtk_menu_item_new_with_label(_("Cancel safe exit"));
      gtk_widget_show(mode);
      gtk_container_add(GTK_CONTAINER(mode_popup), mode);
      gtk_signal_connect(GTK_OBJECT(mode), "activate",
			 GTK_SIGNAL_FUNC(on_safe_exit_cancel), NULL);
      separator = gtk_menu_item_new();
      gtk_widget_show(separator);
      gtk_container_add(GTK_CONTAINER(mode_popup), separator);
      gtk_widget_set_sensitive(separator, FALSE);
    }

    mode =
	gtk_check_menu_item_new_with_label(_
					   ("Show server error messages"));
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (is_string_in_list(global.usermode, "ERROR"))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *) 0);

    mode = gtk_check_menu_item_new_with_label(_("Show bans messages"));
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (is_string_in_list(global.usermode, "BAN"))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *) 1);

    mode =
	gtk_check_menu_item_new_with_label(_
					   ("Show configuration changed"));
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (is_string_in_list(global.usermode, "CHANGE"))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *) 2);

    mode = gtk_check_menu_item_new_with_label(_("Show kill messages"));
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (is_string_in_list(global.usermode, "KILL"))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *) 3);

    mode = gtk_check_menu_item_new_with_label(_("Show level changes"));
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (is_string_in_list(global.usermode, "LEVEL"))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *) 4);

    mode = gtk_check_menu_item_new_with_label(_("Show server messages"));
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (is_string_in_list(global.usermode, "SERVER"))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *) 5);

    mode = gtk_check_menu_item_new_with_label(_("Show muzzle messages"));
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (is_string_in_list(global.usermode, "MUZZLE"))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *) 6);

    mode = gtk_check_menu_item_new_with_label(_("Show dataport changes"));
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (is_string_in_list(global.usermode, "PORT"))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *) 7);

    mode = gtk_check_menu_item_new_with_label(_("Show wallops"));
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (is_string_in_list(global.usermode, "WALLOP"))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *) 8);

    mode = gtk_check_menu_item_new_with_label(_("Show cloaks"));
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (is_string_in_list(global.usermode, "CLOAK"))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *) 9);

    mode = gtk_check_menu_item_new_with_label(_("Show floods"));
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (is_string_in_list(global.usermode, "FLOOD"))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *) 10);

    mode = gtk_check_menu_item_new_with_label(_("Show pings"));
    gtk_widget_show(mode);
    gtk_container_add(GTK_CONTAINER(mode_popup), mode);
    if (is_string_in_list(global.usermode, "PING"))
       gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
    gtk_signal_connect(GTK_OBJECT(mode), "activate",
		       GTK_SIGNAL_FUNC(on_mode_activate), (void *) 11);

    if (opennap_version(0, 38)) {
      mode =
	  gtk_check_menu_item_new_with_label(_("Allow private message"));
      gtk_widget_show(mode);
      gtk_container_add(GTK_CONTAINER(mode_popup), mode);
      if (is_string_in_list(global.usermode, "MSG"))
	 gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
      gtk_signal_connect(GTK_OBJECT(mode), "activate",
			 GTK_SIGNAL_FUNC(on_mode_activate), (void *) 12);

      mode = gtk_check_menu_item_new_with_label(_("Show whois requests"));
      gtk_widget_show(mode);
      gtk_container_add(GTK_CONTAINER(mode_popup), mode);
      if (is_string_in_list(global.usermode, "WHOIS"))
	 gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
      gtk_signal_connect(GTK_OBJECT(mode), "activate",
			 GTK_SIGNAL_FUNC(on_mode_activate), (void *) 13);
    }
  }
  return mode_popup;
}

GtkWidget *create_user_popup(int mode)
{
  GtkWidget *popup;
  GtkWidget *popup2;
  GtkAccelGroup *popup_accels;
  GtkWidget *item;
  GtkWidget *item2;
  GtkWidget *separator;
  char *user;
  int in_hot;
  hot_t *hot;
  int subscribed;
  char* temp;
  user_info_t* userinfo;
  char speed[1024];

  user = get_popup_user(mode);
  hot = hotlist_search_user(user);
  in_hot = (hot && hot->visible);
  subscribed = (subscription_user_search(user) != NULL);

  popup = gtk_menu_new();
  gtk_object_set_data(GTK_OBJECT(popup), "popup", popup);
  popup_accels = gtk_menu_ensure_uline_accel_group(GTK_MENU(popup));
  
  if (mode == M_TEXT) {
    item = gtk_menu_item_new_with_label(user);
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(popup), item);

    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup), separator);
    gtk_widget_set_sensitive(separator, FALSE);
    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup), separator);
    gtk_widget_set_sensitive(separator, FALSE);
  }
  item = gtk_menu_item_new_with_label(_("Private Mode"));
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_private_mode_activate),
		     (gpointer) mode);

  item = gtk_menu_item_new_with_label(_("Whisper"));
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_whisper_activate),
		     (gpointer) mode);

  separator = gtk_menu_item_new();
  gtk_widget_show(separator);
  gtk_container_add(GTK_CONTAINER(popup), separator);
  gtk_widget_set_sensitive(separator, FALSE);

  if (mode == M_WHOIS)
    item = gtk_menu_item_new_with_label(_("Refresh Whois"));
  else
    item = gtk_menu_item_new_with_label(_("Whois User..."));
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);
  gtk_signal_connect(GTK_OBJECT(item), "activate",
		     GTK_SIGNAL_FUNC(on_whois_user_activate),
		     (gpointer) mode);
  if (mode != M_HOTLIST) {
    if (in_hot) {
      item = gtk_menu_item_new_with_label(_("Remove from Hotlist"));
      gtk_widget_show(item);
      gtk_container_add(GTK_CONTAINER(popup), item);
      gtk_signal_connect(GTK_OBJECT(item), "activate",
			 GTK_SIGNAL_FUNC(on_remove_from_hotlist_activate),
			 (gpointer) mode);
    } else {
      item = gtk_menu_item_new_with_label(_("Add to Hotlist"));
      gtk_widget_show(item);
      gtk_container_add(GTK_CONTAINER(popup), item);
      gtk_signal_connect(GTK_OBJECT(item), "activate",
			 GTK_SIGNAL_FUNC(on_add_to_hotlist_activate),
			 (gpointer) mode);
    }
    if (mode != M_BROWSE) {
      item = gtk_menu_item_new_with_label(_("Browse Files"));
      gtk_widget_show(item);
      gtk_container_add(GTK_CONTAINER(popup), item);
      gtk_signal_connect(GTK_OBJECT(item), "activate",
			 GTK_SIGNAL_FUNC(on_browse_files_activate),
			 (gpointer) mode);
    }
  }
  if (!hot || (hot->online != HOT_OFFLINE)) {
    item = gtk_menu_item_new_with_label(_("Locate User"));
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(popup), item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(on_locate_activate),
		       (gpointer) mode);

    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup), separator);
    gtk_widget_set_sensitive(separator, FALSE);

    item = gtk_menu_item_new_with_label(_("Send File..."));
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(popup), item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(on_send_file_activate),
		       (gpointer) mode);

  }
  separator = gtk_menu_item_new();
  gtk_widget_show(separator);
  gtk_container_add(GTK_CONTAINER(popup), separator);
  gtk_widget_set_sensitive(separator, FALSE);

  item = gtk_menu_item_new_with_label(_("Status"));
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);

  popup2 = gtk_menu_new();
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), popup2);
  item2 = gtk_check_menu_item_new_with_label(_("Always allow upload"));
  gtk_widget_show(item2);
  gtk_container_add(GTK_CONTAINER(popup2), item2);
  if (string_list_search(LIST_FRIEND, user)) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(item2), TRUE);
  }
  gtk_signal_connect(GTK_OBJECT(item2), "activate",
		     GTK_SIGNAL_FUNC(on_friend_activate), (gpointer) mode);
  item2 = gtk_check_menu_item_new_with_label(_("Never allow upload"));
  gtk_widget_show(item2);
  gtk_container_add(GTK_CONTAINER(popup2), item2);
  if (string_list_search(LIST_ENEMY, user)) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(item2), TRUE);
  }
  gtk_signal_connect(GTK_OBJECT(item2), "activate",
		     GTK_SIGNAL_FUNC(on_enemy_activate), (gpointer) mode);
  item2 = gtk_check_menu_item_new_with_label(_("Never autoresume from user"));
  gtk_widget_show(item2);
  gtk_container_add(GTK_CONTAINER(popup2), item2);
  if (string_list_search(LIST_NODOWNLOAD, user)) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(item2), TRUE);
  }
  gtk_signal_connect(GTK_OBJECT(item2), "activate",
		     GTK_SIGNAL_FUNC(on_nodownload_activate), (gpointer) mode);
  item2 = gtk_check_menu_item_new_with_label(_("Ignored"));
  gtk_widget_show(item2);
  gtk_container_add(GTK_CONTAINER(popup2), item2);
  if (string_list_search(LIST_IGNORE, user)) {
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(item2), TRUE);
  }
  gtk_signal_connect(GTK_OBJECT(item2), "activate",
		     GTK_SIGNAL_FUNC(on_ignore_activate), (gpointer) mode);
  if ((mode != M_SUBSCRIPTION) || 1) {
    item2 = gtk_check_menu_item_new_with_label(_("In subscription list"));
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
    if (subscribed) {
      gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(item2), TRUE);
    }
    gtk_signal_connect(GTK_OBJECT(item2), "activate",
		       GTK_SIGNAL_FUNC(on_subscribe_activate), (gpointer) mode);
  }

  item = gtk_menu_item_new_with_label(_("Transfer Info"));
  gtk_widget_show(item);
  gtk_container_add(GTK_CONTAINER(popup), item);

  userinfo = user_info_search(user, 0);

  popup2 = gtk_menu_new();
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), popup2);
  if (!userinfo) {
    item2 = gtk_menu_item_new_with_label(_("No transfer info found"));
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
  } else {
    if (userinfo->last_server) {
      temp = l_strdup_printf(_("Last userinfo from: %sreceived from %s"), 
			     ctime(&(userinfo->last_seen)), userinfo->last_server);
    } else {
      temp = l_strdup_printf(_("Last userinfo from: %s"), 
			     ctime(&(userinfo->last_seen)));
      temp[strlen(temp)-1] = 0;
    }
    item2 = gtk_menu_item_new_with_label(temp);
    l_free(temp);
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
    if (userinfo->timestamp > 1) {
      temp = l_strdup_printf(_("Shares %d files with speed %s"), 
			     userinfo->shares, LineSpeed(userinfo->linespeed));
      item2 = gtk_menu_item_new_with_label(temp);
      l_free(temp);
      gtk_widget_show(item2);
      gtk_container_add(GTK_CONTAINER(popup2), item2);
    }

    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup2), separator);
    gtk_widget_set_sensitive(separator, FALSE);

    temp = l_strdup_printf(_("%d (%d) Downloads"),
			   userinfo->cur[0], userinfo->real_cur[0]);
    item2 = gtk_menu_item_new_with_label(temp);
    l_free(temp);
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
    if (userinfo->max[0] == -2)
      temp = l_strdup_printf(_("Limit: Unlimited"));
    else if (userinfo->max[0] == -1)
      temp = l_strdup_printf(_("Limit: Default"));
    else temp = l_strdup_printf(_("Limit: %d"), userinfo->max[0]);
    item2 = gtk_menu_item_new_with_label(temp);
    l_free(temp);
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
    if (userinfo->limit[0] == 0)
      temp = l_strdup_printf(_("Bandwidth Limit: Unlimited"));
    else
      temp = l_strdup_printf(_("Bandwidth Limit: %s"),
			     print_speed(speed, userinfo->limit[0], 1));
    item2 = gtk_menu_item_new_with_label(temp);
    l_free(temp);
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);

    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup2), separator);
    gtk_widget_set_sensitive(separator, FALSE);

    temp = l_strdup_printf(_("%d (%d) Uploads"),
			   userinfo->cur[1], userinfo->real_cur[1]);
    item2 = gtk_menu_item_new_with_label(temp);
    l_free(temp);
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
    if (userinfo->max[1] == -2)
      temp = l_strdup_printf(_("Limit: Unlimited"));
    else if (userinfo->max[1] == -1)
      temp = l_strdup_printf(_("Limit: Default"));
    else temp = l_strdup_printf(_("Limit: %d"), userinfo->max[1]);
    item2 = gtk_menu_item_new_with_label(temp);
    l_free(temp);
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
    if (userinfo->limit[1] == 0)
      temp = l_strdup_printf(_("Bandwidth Limit: Unlimited"));
    else
      temp = l_strdup_printf(_("Bandwidth Limit: %s"),
			     print_speed(speed, userinfo->limit[1], 1));
    item2 = gtk_menu_item_new_with_label(temp);
    l_free(temp);
    gtk_widget_show(item2);
    gtk_container_add(GTK_CONTAINER(popup2), item2);
  }



  item = create_bandwidth_popup(mode);
  if (item) {
    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup), separator);
    gtk_widget_set_sensitive(separator, FALSE);
    
    gtk_container_add(GTK_CONTAINER(popup), item);
  }

  if (((mode == M_ONLINE) || (mode == M_TEXT)) &&
      ((global.user.level > L_USER) ||string_list_search(LIST_OPCHANNEL,
							 global.
							 current_page->
							 name))
      && in_channel())
  {
    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup), separator);
    gtk_widget_set_sensitive(separator, FALSE);

    if (opennap_version(0, 0)) {
      item = gtk_menu_item_new_with_label(_("Muzzle in channel"));
      gtk_widget_show(item);
      gtk_container_add(GTK_CONTAINER(popup), item);
      gtk_signal_connect(GTK_OBJECT(item), "activate",
			 GTK_SIGNAL_FUNC(on_chmuzzle_activate),
			 (gpointer) mode);
    }
    item = gtk_menu_item_new_with_label(_("Kick from channel"));
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(popup), item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(on_kick_activate), (gpointer) mode);
    item = gtk_menu_item_new_with_label(_("Ban from channel"));
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(popup), item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(on_chban_activate),
		       (gpointer) mode);
  }

  if (global.user.level > L_USER) {
    separator = gtk_menu_item_new();
    gtk_widget_show(separator);
    gtk_container_add(GTK_CONTAINER(popup), separator);
    gtk_widget_set_sensitive(separator, FALSE);

    item = gtk_menu_item_new_with_label(_("Muzzle User"));
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(popup), item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(on_muzzle_activate),
		       (gpointer) mode);
    item = gtk_menu_item_new_with_label(_("Kill User"));
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(popup), item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(on_kill_activate), (gpointer) mode);
    item = gtk_menu_item_new_with_label(_("Ban User"));
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(popup), item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(on_ban_activate), (gpointer) mode);
    item = gtk_menu_item_new_with_label(_("Nuke User"));
    gtk_widget_show(item);
    gtk_container_add(GTK_CONTAINER(popup), item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
		       GTK_SIGNAL_FUNC(on_nuke_activate), (gpointer) mode);
  }

  return popup;
}

int cnt_pot(long num)
{
  int cnt = 0;

  while ((1 << cnt) < num)
    cnt++;

  return cnt;
}

int calc_x(long val, long max, int width)
{
  if (val > max)
    return width;
  else
    return (int) (((double) val / (double) max) * (double) width);
}

void draw_band_width(bandwidth_t * bandwidth, int full)
{
  char str[1024];
  int height;
  int width;
  GtkWidget *area = bandwidth->area;
  long x1, x2;
  int i1;
  int overrun;
  int borderx = area->style->klass->xthickness;
  int bordery = area->style->klass->ythickness;
  int text_height;

  if (full) {
    print_speed(str, bandwidth->limit, 1);
    gtk_label_set_text(GTK_LABEL(bandwidth->label_max), str);
  }
  print_speed(str, bandwidth->current, 1);
  gtk_label_set_text(GTK_LABEL(bandwidth->label_cur), str);

  width = bandwidth->area->allocation.width;
  height = bandwidth->area->allocation.height;

  if (!area->window)
    return;
  text_height = gdk_string_height(area->style->font, "0123456789BKM") + 4;
  if (full) {
    // background
    gtk_paint_box(area->style, area->window,
		  GTK_STATE_NORMAL, GTK_SHADOW_OUT,
		  NULL, area, "frame", 0, 0, width, height);

    x1 = 1;
    while (calc_x(x1, bandwidth->maxval, width - 11 - 2 * borderx) < 70) x1 *=2;
    i1 = 0;
    while (i1*x1 <= bandwidth->maxval) {
      x2 = calc_x(x1 * i1, bandwidth->maxval, width - 11 - 2 * borderx) +
	5 + borderx;
      print_speed(str, x1 * i1, 0);
      gtk_paint_string(area->style, area->window,
		       GTK_STATE_NORMAL,
		       NULL, area, "label",
		       x2 + 5, text_height - 2, str);
      gdk_draw_line(area->window,
		    area->style->fg_gc[GTK_STATE_NORMAL],
		    x2, 0, x2, height);
      i1++;
    }
    gtk_paint_box(area->style, area->window,
		  GTK_STATE_NORMAL, GTK_SHADOW_IN,
		  NULL, area, "trough",
		  5, text_height, width - 10, height - text_height - 5);
  }
  // bar
  x1 = calc_x(bandwidth->current, bandwidth->maxval,
	      width - 10 - 2 * borderx);
  if (bandwidth->current > bandwidth->maxval) {
    overrun = 1;
    x1 -= 10;
  } else
    overrun = 0;

  if (x1 > 0) {
    gtk_paint_box(area->style, area->window,
		  GTK_STATE_PRELIGHT, GTK_SHADOW_OUT,
		  NULL, area, "bar",
		  5 + borderx,
		  text_height + bordery,
		  x1, height - 5 - text_height - 2 * bordery);
  }
  gtk_paint_flat_box(area->style, area->window,
		     GTK_STATE_NORMAL, GTK_SHADOW_NONE,
		     NULL, area, "entry_bg",
		     5 + borderx + x1,
		     text_height + bordery,
		     width - 10 - x1 - 2 * borderx,
		     height - 5 - text_height - 2 * bordery);
  if (overrun) {
    gtk_paint_arrow(area->style, area->window,
		    GTK_STATE_PRELIGHT, GTK_SHADOW_OUT,
		    NULL, area, "hscrollbar", GTK_ARROW_RIGHT, TRUE,
		    5 + borderx + x1,
		    text_height + bordery,
		    width - 10 - x1 - 2 * borderx,
		    height - 5 - text_height - 2 * bordery);
  }
  
  x1 = calc_x(bandwidth->limit, bandwidth->maxval,
	      width - 11 - 2 * borderx) + 5 + borderx;

  if (bandwidth->limit <= bandwidth->maxval) {
    gtk_paint_arrow(area->style, area->window,
		    GTK_STATE_NORMAL, GTK_SHADOW_OUT,
		    NULL, area, "vscrollbar", GTK_ARROW_UP, TRUE,
		    x1 - 6,
		    text_height + bordery,
		    12, height - text_height - 2 * bordery);
  }
}

void extra_win_get_geometry()
{
  int i1;
  GtkWidget *win;
  char str[1024];

  for (i1 = 0; i1 < G_SIZE - G_SIZE_ADD; i1++) {
    if (global.extra_win & (1 << i1)) {
      sprintf(str, "extra%d", i1);
      win = gtk_object_get_data(GTK_OBJECT(global.win), str);
      if (!win)
	continue;
      if (win->window) {
	gdk_window_get_origin(win->window,
			      &global.geometry[i1].x,
			      &global.geometry[i1].y);
      }
      global.geometry[i1].width = win->allocation.width;
      global.geometry[i1].height = win->allocation.height;
    }
  }
  if (global.extra_win & (1 << (G_SIZE - 1))) {
    win = gtk_object_get_data(GTK_OBJECT(global.win), "fields");
    if (win && win->window) {
      gdk_window_get_origin(win->window,
			    &global.geometry[G_SIZE - 1].x,
			    &global.geometry[G_SIZE - 1].y);
    }
    global.geometry[G_SIZE - 1].width = win->allocation.width;
    global.geometry[G_SIZE - 1].height = win->allocation.height;
  }
  if (global.extra_win & (1 << (G_SIZE - 2))) {
    win = gtk_object_get_data(GTK_OBJECT(global.win), "fields2");
    if (win && win->window) {
      gdk_window_get_origin(win->window,
			    &global.geometry[G_SIZE - 2].x,
			    &global.geometry[G_SIZE - 2].y);
    }
    global.geometry[G_SIZE - 2].width = win->allocation.width;
    global.geometry[G_SIZE - 2].height = win->allocation.height;
  }
}

void lopster_wait(int msec)
{
  struct timeval start;
  struct timeval cur;

  gettimeofday(&start, NULL);
  do {
    gettimeofday(&cur, NULL);
  } while ((cur.tv_sec - start.tv_sec) * 1000 +
	   (cur.tv_usec - start.tv_usec) / 1000 < msec);
}

void advance_progress(char *message, gfloat per)
{
  GtkProgressBar *progress;
  GtkLabel *label;

  if (per >= 1) return;

  if (!global.splash_win) return;

  progress =
      GTK_PROGRESS_BAR(lookup_widget(global.splash_win, "progress"));
  label = GTK_LABEL(lookup_widget(global.splash_win, "label"));
  if (message)
    gtk_label_set_text(label, message);
  gtk_progress_bar_update(progress, per);

  while (gtk_events_pending())
    gtk_main_iteration();
  //  lopster_wait(500);
}

GtkWidget *main_tab_detach(int no)
{
  char str[1024];
  char title[1024];
  GtkWidget *widget;
  GtkWidget *window;
  GtkWidget *temp;

  //  printf("detach %d %d\n", no, global.extra_win);
  if (global.extra_win & (1 << no))
    return NULL;

  switch (no) {
  case 0:
    strcpy(title, _("Server"));
    strcpy(str, "vbox98");
    temp = lookup_widget(global.win, "detach_server");
    break;
  case 1:
    strcpy(title, _("Chat"));
    strcpy(str, "vbox15");
    temp = lookup_widget(global.win, "detach_chat");
    break;
  case 2:
    strcpy(title, _("Library"));
    strcpy(str, "vbox2");
    temp = lookup_widget(global.win, "detach_library");
    break;
  case 3:
    strcpy(title, _("Search"));
    strcpy(str, "vbox5");
    temp = lookup_widget(global.win, "detach_search");
    break;
  case 4:
    strcpy(title, _("Hotlist"));
    strcpy(str, "vbox124");
    temp = lookup_widget(global.win, "detach_hotlist");
    break;
  case 5:
    strcpy(title, _("Downloads"));
    strcpy(str, "vbox8");
    temp = lookup_widget(global.win, "detach_downloads");
    break;
  case 6:
    strcpy(title, _("Uploads"));
    strcpy(str, "vbox139");
    temp = lookup_widget(global.win, "detach_uploads");
    break;
  case 7:
    strcpy(title, _("Statistic"));
    strcpy(str, "vbox171");
    temp = lookup_widget(global.win, "detach_statistic");
    break;
  default:
    return NULL;
  }
  gtk_widget_set_sensitive(temp, FALSE);

  widget = lookup_widget(global.win, str);
  if (!widget)
    return NULL;

  global.extra_win |= (1 << no);

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  sprintf(str, "extra%d", no);
  gtk_object_set_data(GTK_OBJECT(global.win), str, window);
  gtk_window_set_policy(GTK_WINDOW(window), TRUE, TRUE, FALSE);
  gtk_window_set_default_size(GTK_WINDOW(window),
			      (global.geometry[no].width ==
			       -1) ? widget->allocation.width : global.
			      geometry[no].width,
			      (global.geometry[no].height ==
			       -1) ? widget->allocation.height : global.
			      geometry[no].height);
  gtk_window_set_title(GTK_WINDOW(window), title);

  gtk_widget_ref(widget);
  gtk_container_remove(GTK_CONTAINER(widget->parent), widget);
  gtk_container_add(GTK_CONTAINER(window), widget);
  gtk_widget_unref(widget);

  gtk_signal_connect(GTK_OBJECT(window), "delete_event",
		     GTK_SIGNAL_FUNC(on_extra_win_delete), (gpointer) no);

  if ((global.geometry[no].x >= 0) &&(global.geometry[no].y >= 0)) {
    gtk_widget_set_uposition(window, global.geometry[no].x, global.geometry[no].y);
  }

  gtk_my_widget_show(window);

  return window;
}

clone_t *is_ip_in_clones(GList * glist, char *ip)
{
  GList *dlist;
  clone_t *clone;

  dlist = g_list_first(glist);
  while (dlist) {
    clone = (clone_t *) (dlist->data);
    if (!strcmp(clone->ip, ip))
      return clone;
    dlist = dlist->next;
  }
  return NULL;
}

int get_version(char *data)
{
  if (!strncasecmp("VERSION opennap", data, 15)) {
    SERVER->network = N_OPENNAP;
    sscanf(data + 16, "%d.%d", &(SERVER->major), &(SERVER->minor));
    return N_OPENNAP;
  } else if (!strncasecmp("VERSION SlavaNap", data, 16)) {
    SERVER->network = N_SLAVANAP;
    sscanf(data + 17, "%d.%d.%d", &(SERVER->major), &(SERVER->minor),
	   &(SERVER->micro));
    return N_SLAVANAP;
  } else if (!strncasecmp("VERSION CQ_NAP", data, 14)) {
    SERVER->network = N_CQ_NAP;
    sscanf(data + 15, "%d.%d", &(SERVER->major), &(SERVER->minor));
    return N_CQ_NAP;
  } else {
    SERVER->network = N_NAPSTER;
    return N_NAPSTER;
  }
}

void get_server(char *data)
{
  if (!strncasecmp("SERVER ", data, 7)) {
    if (global.links)
      free_links(global.links);
    global.links = (link_t *) l_malloc(sizeof(link_t));
    global.links->server = l_strdup(data + 7);
    global.links->links = NULL;
    global.links->ping = 0;
  }
}

void convert_port_list(GList * list)
{
  GList *dlist;
  char *ports;
  char *sep;
  int p1, p2, temp;
  int *res;

  for (dlist = list; dlist; dlist = dlist->next) {
    ports = (char *) (dlist->data);
    if (!ports)
      continue;
    //    printf("changing [%s] to ", ports);
    sep = strchr(ports, '-');
    if (sep) {
      *sep = 0;
      p1 = atoi(ports);
      p2 = atoi(sep + 1);
      if (p1 > p2) {
	temp = p1;
	p1 = p2;
	p2 = temp;
      }
    } else {
      p1 = p2 = atoi(ports);
    }
    l_free(ports);

    dlist->data = l_malloc(sizeof(int) * 2);
    res = (int *) (dlist->data);
    res[0] = p1;
    res[1] = p2;
    //    printf("[%d-%d]\n", res[0], res[1]);
  }
}

gint ports_compare_func(gconstpointer a, gconstpointer b)
{
  int *p1 = (int *) a;
  int *p2 = (int *) b;

  if (!p2)
    return (p1 != NULL);
  if (!p1)
    return -1;

  if (p1[0] < p2[0])
    return -1;
  if (p1[0] > p2[0])
    return 1;
  return 0;
}

GList *simplify_port_list(GList ** list)
{
  GList *dlist;
  int *res;
  int *res2 = NULL;

  *list = g_list_sort(*list, (GCompareFunc) ports_compare_func);

  if (!(*list))
    return NULL;
  dlist = *list;
  res = (int *) (dlist->data);
  dlist = dlist->next;
  while (dlist) {
    res2 = (int *) (dlist->data);
    dlist = dlist->next;
    //    printf("[%d-%d][%d-%d]\n", res[0], res[1], res2[0], res2[1]);
    if (res[1] + 1 >= res2[0]) {
      if (res2[1] > res[1])
	res[1] = res2[1];
      *list = g_list_remove(*list, res2);
    } else {
      res = res2;
    }
  }
  return *list;
}

GList *create_allowed_ports(char *string)
{
  GList *temp_list = NULL;
  char *temp;

  if (!string || !(*string))
    return NULL;

  temp = l_strdup(string);
  make_list_from_string(&temp_list, temp, ",");
  l_free(temp);
  convert_port_list(temp_list);
  simplify_port_list(&temp_list);
  return temp_list;
}

int get_next_port(GList * list, int last)
{
  GList *dlist;
  int *res;
  int new_port = last + 1;

  if (!list)
    return 0;
  for (dlist = list; dlist; dlist = dlist->next) {
    res = (int *) (dlist->data);
    if (res[1] < new_port)
      continue;
    break;
  }
  if (!dlist) {			// last port too high, getting first allowed port
    res = (int *) (list->data);
    return res[0];
  }
  // ok, segment found that may includes last+1, check min value
  // new_port <= res[1]
  if (new_port < res[0])
    return res[0];
  else
    return new_port;
}

char *create_string_from_ports(GList * list)
{
  char *result = NULL;
  GList *dlist;
  int len = 0;
  char str[1024];
  int *res;

  for (dlist = list; dlist; dlist = dlist->next) {
    res = (int *) (dlist->data);
    if (res[0] == res[1])
      sprintf(str, "%d", res[0]);
    else
      sprintf(str, "%d-%d", res[0], res[1]);
    len += strlen(str) + 1;
  }
  result = (char *) l_malloc(sizeof(char) * len);
  *result = 0;
  for (dlist = list; dlist; dlist = dlist->next) {
    res = (int *) (dlist->data);
    if (res[0] == res[1])
      sprintf(str, "%d", res[0]);
    else
      sprintf(str, "%d-%d", res[0], res[1]);
    if (*result)
      strcat(result, ",");
    strcat(result, str);
  }
  return result;
}

void destroy_allowed_ports(GList * list)
{
  GList *dlist;
  if (!list)
    return;

  for (dlist = list; dlist; dlist = dlist->next) {
    l_free(dlist->data);
  }
  g_list_free(list);
}

int port_is_allowed(GList * list, int port)
{
  GList *dlist;
  int *res;

  for (dlist = list; dlist; dlist = dlist->next) {
    res = (int *) (dlist->data);
    if ((port >= res[0]) && (port <= res[1]))
      return 1;
  }
  return 0;
}

void gtk_my_widget_show(GtkWidget * widget)
{
  GList *dlist;

  if (global.splash_win) {
    dlist = gtk_object_get_data(GTK_OBJECT(global.win), "hidden");
    dlist = g_list_append(dlist, widget);
    gtk_object_set_data(GTK_OBJECT(global.win), "hidden", dlist);
  } else {
    gtk_widget_show(widget);
  }
}

void gtk_my_widget_show_all()
{
  GList *dlist;
  GList *hidden;

  hidden = gtk_object_get_data(GTK_OBJECT(global.win), "hidden");
  for (dlist = hidden; dlist; dlist = dlist->next) {
    gtk_widget_show(GTK_WIDGET(dlist->data));
  }
  g_list_free(hidden);
  gtk_object_set_data(GTK_OBJECT(global.win), "hidden", NULL);
}

void switch_to_page(int no)
{
  char str[1024];
  GtkWidget *temp;
  int i1, sum;

  if (global.extra_win & (1 << no)) {
    sprintf(str, "extra%d", no);
    temp = gtk_object_get_data(GTK_OBJECT(global.win), str);
    if (temp->window)
      gdk_window_raise(temp->window);
  } else {
    sum = no;
    for (i1 = 0; i1 < no; i1++)
      if (global.extra_win & (1 << i1))
	sum--;
    temp = lookup_widget(global.win, "notebook1");
    gtk_notebook_set_page(GTK_NOTEBOOK(temp), sum);
  }
}

int notebook_page_current() {
  GtkWidget *temp;
  int nth;
  int i1;

  temp = lookup_widget(global.win, "notebook1");
  nth = gtk_notebook_get_current_page(GTK_NOTEBOOK(temp));
  for (i1 = 0; i1 < G_SIZE - G_SIZE_ADD; i1++) {
    if ((global.extra_win & (1 << i1)) == 0) nth--;
    if (nth < 0) break;
  }
  return i1;
}

int notebook_page_visible(int no)
{
  GtkWidget *temp;
  int sum;
  int i1;

  if (global.extra_win & (1 << no))
    return 1;
  else {
    temp = lookup_widget(global.win, "notebook1");
    sum = gtk_notebook_get_current_page(GTK_NOTEBOOK(temp));
    for (i1 = 0; i1 < no; i1++)
      if (global.extra_win & (1 << i1))
	sum++;
    if (sum == no)
      return 1;
    else
      return 0;
  }
}

void print_topright_corner()
{
  struct tm *ltime;
  char *text;
  int hour;
  GtkWidget *temp;
  char comm[1024];

  temp = lookup_widget(global.win, "label914");
  if (global.options.time_display == 0) {
    text = l_strdup_printf(_("Boot time: %s"), global.session_start);
  } else if (global.options.time_display == 1) {
    text =
	l_strdup_printf(_("Uptime: %s"),
			print_time(comm, global.current_time - global.start_time));
  } else if (global.options.time_display == 2) {
    ltime = localtime(&global.current_time);
    if (ltime->tm_hour == 12)
      hour = ltime->tm_hour;
    else
      hour = ltime->tm_hour % 12;
    text = l_strdup_printf(_("Time: %s%d:%s%d:%s%d %sm"),
			   (hour < 10) ? "0" : "", hour,
			   (ltime->tm_min < 10) ? "0" : "", ltime->tm_min,
			   (ltime->tm_sec < 10) ? "0" : "", ltime->tm_sec,
			   (ltime->tm_hour < 12) ? "a" : "p");
  } else if (global.options.time_display == 3) {
    text = l_strdup_printf(_("Beats: %3d"), get_beats(global.current_time));
  } else {
    return;
  }
  gtk_label_set_text(GTK_LABEL(temp), text);
  l_free(text);
}

void set_user_level(int level)
{
  chat_page_t *page;
  GList *dlist;
  GtkWidget *temp;

  global.user.level = level;
#ifdef GLOBAL_DEBUG
  printf("user level: %d\n", global.user.level);
#endif
  if (global.user.level >= L_MOD) {
    temp = lookup_widget(global.win, "global_users");
    gtk_widget_set_sensitive(temp, TRUE);
    temp = lookup_widget(global.win, "banned_users");
    gtk_widget_set_sensitive(temp, TRUE);
    temp = lookup_widget(global.win, "client_statistic");
    gtk_widget_set_sensitive(temp, TRUE);
  } else {
    temp = lookup_widget(global.win, "global_users");
    gtk_widget_set_sensitive(temp, FALSE);
    temp = lookup_widget(global.win, "banned_users");
    gtk_widget_set_sensitive(temp, FALSE);
    temp = lookup_widget(global.win, "client_statistic");
    gtk_widget_set_sensitive(temp, FALSE);
  }

  if (global.user.level > L_USER) {
    for (dlist = global.chat_pages; dlist; dlist = dlist->next) {
      page = (chat_page_t *) (dlist->data);
      if (page->type != P_PUBLIC) continue;
      opchannel_add(page->name);
    }
  }
  update_status_line(0);
}

gint file_move_idle(gpointer data) {
  gint return_tmp, return_tmp2;
  move_t* fds = data;
  static char buffer[1024*64];

  return_tmp = read(fds->src_fd, buffer, 1024*64);
  if (return_tmp < 0) {
    g_warning("file_move_idle(): error reading while moving file to save directory (%s)\n", g_strerror(errno));
    goto no_success;
  }
  if (!return_tmp) goto success;
  
  return_tmp2 = write(fds->dest_fd, buffer, return_tmp);
  if (return_tmp2 < 0) {
    g_warning("file_move_idle(): error writing while moving file to save directory (%s)\n", g_strerror(errno));
    goto no_success;
  }
  if (return_tmp < 1024*64) goto success;

  return 1;

 success:
  unlink(fds->src);
 no_success:
  close(fds->src_fd); close(fds->dest_fd);
  l_free(fds->src);
  l_free(fds);
  return 0;
}

void file_move(char* src, char* dest)
{
  gint return_tmp;
  move_t *fds;

  if (!strcmp(src, dest)) return;

  /* First try and link it to the new locatation */
  return_tmp = rename(src, dest);

  if (return_tmp == -1 && (errno == EXDEV || errno == EPERM)) {
    /* link failed becase either the two paths aren't on the */
    /* same filesystem or the filesystem doesn't support hard */
    /* links, so we have to do a copy. */
    
    gint tmp_src, tmp_dest;
    if ((tmp_src  = open(src, O_RDONLY)) < 0) {
      g_warning("Unable to open() file '%s' (%s) !\n", src, g_strerror(errno));
      return;
    }

    if ((tmp_dest = open(dest, O_WRONLY | O_CREAT | O_TRUNC, 0644)) < 0) {
      close(tmp_src);
      g_warning("Unable to create file '%s' (%s) !\n", src, g_strerror(errno));
      return;
    }
    
    fds = l_malloc(sizeof(move_t));
    fds->src_fd = tmp_src;
    fds->dest_fd = tmp_dest;
    fds->src = l_strdup(src);
    gtk_idle_add(file_move_idle, fds);
  }
  
  return;
}

/*
transfer_t* queue_info(user_info_t* userinfo, int* info, int max) {
  GtkCList* clist;
  int row;
  transfer_t* transfer;
  socket_t* socket;
  transfer_t* found = NULL;

  clist = GTK_CLIST(lookup_widget(global.win, "transfer_up"));
  row = 0;
  while (1) {
    if (row >= clist->rows) break;
    socket = gtk_clist_get_row_data(clist, row);
    transfer = (socket->data);
    if (transfer->status != S_QUEUED) continue;
    if (transfer->userinfo == userinfo) {
      if (!found) found = transfer;
    } else {
      if (user_info_priority(transfer->userinfo) > pri) (*info)++;
    }
    row++;
  }
  return found;
}

void send_user_status(char* user) {
  user_info_t* userinfo;
  int pri;
  char* str;
  int status;
  transfer_t* found;

  userinfo = user_info_search(user);
  if (!userinfo) {
    send_private(user, "Your status hasn't been registered yet.", 0);
    return;
  }

  pri = user_info_priority(userinfo);
  str = l_strdup_printf("Your transfer priority is %d", pri);
  send_private(user, str, 0);
  l_free(str);
  if (userinfo->cur >= userinfo->max) {
    str = l_strdup_printf("You have your maximum number of %d transfers running",
			  userinfo->cur);
    send_private(user, str, 0);
    l_free(str);
    return;
  }
  found = queue_info(userinfo, &status, pri);
  if (found) {
    str = l_strdup_printf("Your latest queued file is %s", transfer->shortname);
    send_private(user, str, 0);
    l_free(str);
    str = l_strdup_printf("Your queue position is %d", status);
    send_private(user, str, 0);
    l_free(str);
    return;
  } else {
    send_private(user, "No queued files found from you", 0);
  }
}
*/
