/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define CONFIG_FILE	"/etc/logtool/logtool.conf"	/* This is the logtool config file	*/
/* we don't have default colorization files and such anymore, we just take default config file	*/

#define LSIZE		8096	/* how big a line of text will we read? */

/* You shouldn't muck around with anything below this line less you know what you're doing	*/

#define DATE_LONG 	0	/* If we display the full date */
#define DATE_SHORT 	1	/* If we display the short date */

#define HOST_DEFAULT	0	/* display the host-field as-is */
#define NG_HOST_NAME	1	/* syslog-ng display name of host only */
#define NG_HOST_IP	2	/* display the origin host IP only */
#define NG_HOST_BOTH	3	/* display hostname and IP */

/* define values of TRUE and FALSE so code is more readable */
#define TRUE		1	/* the value of TRUE 	*/
#define FALSE		0	/* the value of FALSE 	*/

/* Define the version specific stuff's */
#define PROGRAM_NAME    "logtool"
#define AUTHORS         "A.L.Lambert"
#define VERSION         "1.2.5"
#define PRINT_VERSION   printf("%s version %s, copyright Y2K-current %s\n", PROGRAM_NAME, VERSION, AUTHORS);

/*
 * Define's for the different event types we might see.  See regex.c for the rest
 * of the stuff to go with this (like the REGEX's for each event type and such)
 */
#define EVENT_UNKNOWN   0
#define EVENT_SYSLOG    1
#define EVENT_SNORT     2
#define EVENT_IPTABLES	3

/* 
 * These define the different output formats.  Unless you know what you're doing, 
 * don't muck with em.
 */
#define OUTPUT_ANSI		0
#define OUTPUT_ASCII		1
#define OUTPUT_CSV		2
#define OUTPUT_HTML		3
#define OUTPUT_RAW		4
#define OUTPUT_CURSES		5	/* this don't exist yet :)	*/

