import gtk

import TrashFolderTree
import BaseWindow
import MetaData

class View(BaseWindow.View):

    def __init__(self, app_model):
    	model = BaseWindow.Model(MetaData.Document())
    	BaseWindow.View.__init__(self, model, 
				 Controller(model, self),
				 TrashFolderTree.View(self, 
				    	    	      model.doc, 
				    	    	      model.xml),
				 app_model)
    	self.main_window.set_title("Trashcan - Lodju")

	# Disable menu entries that don't do anything useful in a
	# trash can window.
	for name in ["new_folder", "show_trashcan", "import", "save"]:
	    item = self.model.get_widget(name)
	    item.set_sensitive(gtk.FALSE)

    def close(self):
    	self.model.doc.storage.discard()
    	BaseWindow.View.close(self)

class Controller(BaseWindow.Controller):

    def on_delete_folder_activate(self, *args):
    	for iter in self.view.folder_tree.controller.get_selection_iters():
	    self.view.folder_tree.model.store.remove(iter)
