//===-- ARMPerfectShuffle.h - NEON Perfect Shuffle Table ------------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
// This file, which was autogenerated by llvm-PerfectShuffle, contains data
// for the optimal way to build a perfect shuffle using neon instructions.
//
//===----------------------------------------------------------------------===//

// 31 entries have cost 0
// 242 entries have cost 1
// 1374 entries have cost 2
// 3515 entries have cost 3
// 1390 entries have cost 4
// 9 entries have cost 5

// This table is 6561*4 = 26244 bytes in size.
static const unsigned PerfectShuffleTable[6561+1] = {
  135053414U,	// <0,0,0,0>: Cost 1 vdup0 LHS
  1543503974U,	// <0,0,0,1>: Cost 2 vext2 <0,0,0,0>, LHS
  2819407872U,	// <0,0,0,2>: Cost 3 vuzpr LHS, <0,0,0,0>
  2568054923U,	// <0,0,0,3>: Cost 3 vext1 <3,0,0,0>, <3,0,0,0>
  1476398390U,	// <0,0,0,4>: Cost 2 vext1 <0,0,0,0>, RHS
  2550140624U,	// <0,0,0,5>: Cost 3 vext1 <0,0,0,0>, <5,1,7,3>
  2550141434U,	// <0,0,0,6>: Cost 3 vext1 <0,0,0,0>, <6,2,7,3>
  2591945711U,	// <0,0,0,7>: Cost 3 vext1 <7,0,0,0>, <7,0,0,0>
  135053414U,	// <0,0,0,u>: Cost 1 vdup0 LHS
  2556117094U,	// <0,0,1,0>: Cost 3 vext1 <1,0,0,1>, LHS
  1879883878U,	// <0,0,1,1>: Cost 2 vzipr LHS, LHS
  1618133094U,	// <0,0,1,2>: Cost 2 vext3 <1,2,3,0>, LHS
  2568063116U,	// <0,0,1,3>: Cost 3 vext1 <3,0,0,1>, <3,0,0,1>
  2556120374U,	// <0,0,1,4>: Cost 3 vext1 <1,0,0,1>, RHS
  2617246864U,	// <0,0,1,5>: Cost 3 vext2 <0,0,0,0>, <1,5,3,7>
  3629863418U,	// <0,0,1,6>: Cost 4 vext1 <1,0,0,1>, <6,2,7,3>
  2591953904U,	// <0,0,1,7>: Cost 3 vext1 <7,0,0,1>, <7,0,0,1>
  1884528742U,	// <0,0,1,u>: Cost 2 vzipr LHS, LHS
  3088351334U,	// <0,0,2,0>: Cost 3 vtrnr <0,2,0,2>, LHS
  2953625764U,	// <0,0,2,1>: Cost 3 vzipr LHS, <0,2,0,2>
  2014101606U,	// <0,0,2,2>: Cost 2 vtrnr LHS, LHS
  2631181989U,	// <0,0,2,3>: Cost 3 vext2 <2,3,0,0>, <2,3,0,0>
  2562100534U,	// <0,0,2,4>: Cost 3 vext1 <2,0,0,2>, RHS
  3635842768U,	// <0,0,2,5>: Cost 4 vext1 <2,0,0,2>, <5,1,7,3>
  2617247674U,	// <0,0,2,6>: Cost 3 vext2 <0,0,0,0>, <2,6,3,7>
  2591962097U,	// <0,0,2,7>: Cost 3 vext1 <7,0,0,2>, <7,0,0,2>
  2014543974U,	// <0,0,2,u>: Cost 2 vtrnr LHS, LHS
  2635163787U,	// <0,0,3,0>: Cost 3 vext2 <3,0,0,0>, <3,0,0,0>
  3704260849U,	// <0,0,3,1>: Cost 4 vext2 <2,2,0,0>, <3,1,2,3>
  2686492933U,	// <0,0,3,2>: Cost 3 vext3 <0,3,2,0>, <0,3,2,0>
  2617248156U,	// <0,0,3,3>: Cost 3 vext2 <0,0,0,0>, <3,3,3,3>
  2617248258U,	// <0,0,3,4>: Cost 3 vext2 <0,0,0,0>, <3,4,5,6>
  3913302016U,	// <0,0,3,5>: Cost 4 vuzpr <3,4,5,6>, <0,0,0,0>
  3690990218U,	// <0,0,3,6>: Cost 4 vext2 <0,0,0,0>, <3,6,2,7>
  3690990275U,	// <0,0,3,7>: Cost 4 vext2 <0,0,0,0>, <3,7,0,1>
  2635163787U,	// <0,0,3,u>: Cost 3 vext2 <3,0,0,0>, <3,0,0,0>
  2643790738U,	// <0,0,4,0>: Cost 3 vext2 <4,4,0,0>, <4,0,5,1>
  2718712146U,	// <0,0,4,1>: Cost 3 vext3 <5,6,7,0>, <0,4,1,5>
  2718712156U,	// <0,0,4,2>: Cost 3 vext3 <5,6,7,0>, <0,4,2,6>
  3641829519U,	// <0,0,4,3>: Cost 4 vext1 <3,0,0,4>, <3,0,0,4>
  2643791016U,	// <0,0,4,4>: Cost 3 vext2 <4,4,0,0>, <4,4,0,0>
  1543507254U,	// <0,0,4,5>: Cost 2 vext2 <0,0,0,0>, RHS
  2846277632U,	// <0,0,4,6>: Cost 3 vuzpr RHS, <0,0,0,0>
  3665720307U,	// <0,0,4,7>: Cost 4 vext1 <7,0,0,4>, <7,0,0,4>
  1543507497U,	// <0,0,4,u>: Cost 2 vext2 <0,0,0,0>, RHS
  2684354972U,	// <0,0,5,0>: Cost 3 vext3 <0,0,0,0>, <0,5,0,7>
  2617249488U,	// <0,0,5,1>: Cost 3 vext2 <0,0,0,0>, <5,1,7,3>
  3696299808U,	// <0,0,5,2>: Cost 4 vext2 <0,u,0,0>, <5,2,7,2>
  3690991471U,	// <0,0,5,3>: Cost 4 vext2 <0,0,0,0>, <5,3,7,0>
  2617249734U,	// <0,0,5,4>: Cost 3 vext2 <0,0,0,0>, <5,4,7,6>
  2617249796U,	// <0,0,5,5>: Cost 3 vext2 <0,0,0,0>, <5,5,5,5>
  2718712274U,	// <0,0,5,6>: Cost 3 vext3 <5,6,7,0>, <0,5,6,7>
  3923378176U,	// <0,0,5,7>: Cost 4 vuzpr <5,1,7,3>, <0,0,0,0>
  2720039396U,	// <0,0,5,u>: Cost 3 vext3 <5,u,7,0>, <0,5,u,7>
  2684355053U,	// <0,0,6,0>: Cost 3 vext3 <0,0,0,0>, <0,6,0,7>
  3786113526U,	// <0,0,6,1>: Cost 4 vext3 <4,6,2,0>, <0,6,1,7>
  2617250298U,	// <0,0,6,2>: Cost 3 vext2 <0,0,0,0>, <6,2,7,3>
  3704263240U,	// <0,0,6,3>: Cost 4 vext2 <2,2,0,0>, <6,3,7,0>
  3729478234U,	// <0,0,6,4>: Cost 4 vext2 <6,4,0,0>, <6,4,0,0>
  3717534443U,	// <0,0,6,5>: Cost 4 vext2 <4,4,0,0>, <6,5,7,1>
  2617250616U,	// <0,0,6,6>: Cost 3 vext2 <0,0,0,0>, <6,6,6,6>
  2657727309U,	// <0,0,6,7>: Cost 3 vext2 <6,7,0,0>, <6,7,0,0>
  2658390942U,	// <0,0,6,u>: Cost 3 vext2 <6,u,0,0>, <6,u,0,0>
  2659054575U,	// <0,0,7,0>: Cost 3 vext2 <7,0,0,0>, <7,0,0,0>
  3934208000U,	// <0,0,7,1>: Cost 4 vuzpr <7,0,1,2>, <0,0,0,0>
  3934265508U,	// <0,0,7,2>: Cost 4 vuzpr <7,0,2,0>, <0,2,0,2>
  3734787298U,	// <0,0,7,3>: Cost 4 vext2 <7,3,0,0>, <7,3,0,0>
  2617251174U,	// <0,0,7,4>: Cost 3 vext2 <0,0,0,0>, <7,4,5,6>
  3665743970U,	// <0,0,7,5>: Cost 4 vext1 <7,0,0,7>, <5,6,7,0>
  3665744562U,	// <0,0,7,6>: Cost 4 vext1 <7,0,0,7>, <6,5,0,7>
  2617251436U,	// <0,0,7,7>: Cost 3 vext2 <0,0,0,0>, <7,7,7,7>
  2659054575U,	// <0,0,7,u>: Cost 3 vext2 <7,0,0,0>, <7,0,0,0>
  135053414U,	// <0,0,u,0>: Cost 1 vdup0 LHS
  1879884445U,	// <0,0,u,1>: Cost 2 vzipr LHS, LHS
  2014101660U,	// <0,0,u,2>: Cost 2 vtrnr LHS, LHS
  2568120467U,	// <0,0,u,3>: Cost 3 vext1 <3,0,0,u>, <3,0,0,u>
  1476463926U,	// <0,0,u,4>: Cost 2 vext1 <0,0,0,u>, RHS
  1543510170U,	// <0,0,u,5>: Cost 2 vext2 <0,0,0,0>, RHS
  2870165504U,	// <0,0,u,6>: Cost 3 vuzpr RHS, <0,0,0,0>
  2592011255U,	// <0,0,u,7>: Cost 3 vext1 <7,0,0,u>, <7,0,0,u>
  135053414U,	// <0,0,u,u>: Cost 1 vdup0 LHS
  2631188480U,	// <0,1,0,0>: Cost 3 vext2 <2,3,0,1>, <0,0,0,0>
  1557446758U,	// <0,1,0,1>: Cost 2 vext2 <2,3,0,1>, LHS
  2819448842U,	// <0,1,0,2>: Cost 3 vuzpr LHS, <0,0,1,1>
  3020734464U,	// <0,1,0,3>: Cost 3 vtrnl LHS, <0,0,0,0>
  2568129846U,	// <0,1,0,4>: Cost 3 vext1 <3,0,1,0>, RHS
  3641872080U,	// <0,1,0,5>: Cost 4 vext1 <3,0,1,0>, <5,1,7,3>
  2592019278U,	// <0,1,0,6>: Cost 3 vext1 <7,0,1,0>, <6,7,0,1>
  2592019448U,	// <0,1,0,7>: Cost 3 vext1 <7,0,1,0>, <7,0,1,0>
  1557447325U,	// <0,1,0,u>: Cost 2 vext2 <2,3,0,1>, LHS
  1524252774U,	// <0,1,1,0>: Cost 2 vext1 <u,0,1,1>, LHS
  2556191459U,	// <0,1,1,1>: Cost 3 vext1 <1,0,1,1>, <1,0,1,1>
  2960310374U,	// <0,1,1,2>: Cost 3 vzipr <1,2,3,0>, LHS
  3020734474U,	// <0,1,1,3>: Cost 3 vtrnl LHS, <0,0,1,1>
  1524256054U,	// <0,1,1,4>: Cost 2 vext1 <u,0,1,1>, RHS
  2580082247U,	// <0,1,1,5>: Cost 3 vext1 <5,0,1,1>, <5,0,1,1>
  2597999098U,	// <0,1,1,6>: Cost 3 vext1 <u,0,1,1>, <6,2,7,3>
  2597999610U,	// <0,1,1,7>: Cost 3 vext1 <u,0,1,1>, <7,0,1,2>
  1524258514U,	// <0,1,1,u>: Cost 2 vext1 <u,0,1,1>, <u,0,1,1>
  1494401126U,	// <0,1,2,0>: Cost 2 vext1 <3,0,1,2>, LHS
  2556199652U,	// <0,1,2,1>: Cost 3 vext1 <1,0,1,2>, <1,0,1,2>
  2562172349U,	// <0,1,2,2>: Cost 3 vext1 <2,0,1,2>, <2,0,1,2>
  835584U,	// <0,1,2,3>: Cost 0 copy LHS
  1494404406U,	// <0,1,2,4>: Cost 2 vext1 <3,0,1,2>, RHS
  2568146640U,	// <0,1,2,5>: Cost 3 vext1 <3,0,1,2>, <5,1,7,3>
  2568147450U,	// <0,1,2,6>: Cost 3 vext1 <3,0,1,2>, <6,2,7,3>
  1518294010U,	// <0,1,2,7>: Cost 2 vext1 <7,0,1,2>, <7,0,1,2>
  835584U,	// <0,1,2,u>: Cost 0 copy LHS
  2631190676U,	// <0,1,3,0>: Cost 3 vext2 <2,3,0,1>, <3,0,1,0>
  3696969948U,	// <0,1,3,1>: Cost 4 vext2 <1,0,0,1>, <3,1,0,0>
  2631190856U,	// <0,1,3,2>: Cost 3 vext2 <2,3,0,1>, <3,2,3,0>
  2692539367U,	// <0,1,3,3>: Cost 3 vext3 <1,3,3,0>, <1,3,3,0>
  2631191042U,	// <0,1,3,4>: Cost 3 vext2 <2,3,0,1>, <3,4,5,6>
  3704932898U,	// <0,1,3,5>: Cost 4 vext2 <2,3,0,1>, <3,5,0,2>
  2657733296U,	// <0,1,3,6>: Cost 3 vext2 <6,7,0,1>, <3,6,7,0>
  2639817411U,	// <0,1,3,7>: Cost 3 vext2 <3,7,0,1>, <3,7,0,1>
  2692908052U,	// <0,1,3,u>: Cost 3 vext3 <1,3,u,0>, <1,3,u,0>
  2631191442U,	// <0,1,4,0>: Cost 3 vext2 <2,3,0,1>, <4,0,5,1>
  3704933322U,	// <0,1,4,1>: Cost 4 vext2 <2,3,0,1>, <4,1,2,3>
  2568160934U,	// <0,1,4,2>: Cost 3 vext1 <3,0,1,4>, <2,3,0,1>
  2568161432U,	// <0,1,4,3>: Cost 3 vext1 <3,0,1,4>, <3,0,1,4>
  2568162614U,	// <0,1,4,4>: Cost 3 vext1 <3,0,1,4>, RHS
  1557450038U,	// <0,1,4,5>: Cost 2 vext2 <2,3,0,1>, RHS
  2631191884U,	// <0,1,4,6>: Cost 3 vext2 <2,3,0,1>, <4,6,0,2>
  2592052220U,	// <0,1,4,7>: Cost 3 vext1 <7,0,1,4>, <7,0,1,4>
  1557450281U,	// <0,1,4,u>: Cost 2 vext2 <2,3,0,1>, RHS
  3704933959U,	// <0,1,5,0>: Cost 4 vext2 <2,3,0,1>, <5,0,1,1>
  2631192272U,	// <0,1,5,1>: Cost 3 vext2 <2,3,0,1>, <5,1,7,3>
  3696308006U,	// <0,1,5,2>: Cost 4 vext2 <0,u,0,1>, <5,2,7,u>
  2718712976U,	// <0,1,5,3>: Cost 3 vext3 <5,6,7,0>, <1,5,3,7>
  2657734598U,	// <0,1,5,4>: Cost 3 vext2 <6,7,0,1>, <5,4,7,6>
  2657734660U,	// <0,1,5,5>: Cost 3 vext2 <6,7,0,1>, <5,5,5,5>
  2651099172U,	// <0,1,5,6>: Cost 3 vext2 <5,6,0,1>, <5,6,0,1>
  3704934518U,	// <0,1,5,7>: Cost 4 vext2 <2,3,0,1>, <5,7,0,2>
  2631192839U,	// <0,1,5,u>: Cost 3 vext2 <2,3,0,1>, <5,u,7,3>
  2592063590U,	// <0,1,6,0>: Cost 3 vext1 <7,0,1,6>, LHS
  3704934780U,	// <0,1,6,1>: Cost 4 vext2 <2,3,0,1>, <6,1,2,3>
  2631193082U,	// <0,1,6,2>: Cost 3 vext2 <2,3,0,1>, <6,2,7,3>
  3704934984U,	// <0,1,6,3>: Cost 4 vext2 <2,3,0,1>, <6,3,7,0>
  2592066870U,	// <0,1,6,4>: Cost 3 vext1 <7,0,1,6>, RHS
  3721523947U,	// <0,1,6,5>: Cost 4 vext2 <5,1,0,1>, <6,5,7,1>
  2657735480U,	// <0,1,6,6>: Cost 3 vext2 <6,7,0,1>, <6,6,6,6>
  1583993678U,	// <0,1,6,7>: Cost 2 vext2 <6,7,0,1>, <6,7,0,1>
  1584657311U,	// <0,1,6,u>: Cost 2 vext2 <6,u,0,1>, <6,u,0,1>
  2657735672U,	// <0,1,7,0>: Cost 3 vext2 <6,7,0,1>, <7,0,1,0>
  3731477571U,	// <0,1,7,1>: Cost 4 vext2 <6,7,0,1>, <7,1,0,3>
  2631193772U,	// <0,1,7,2>: Cost 3 vext2 <2,3,0,1>, <7,2,3,0>
  2661053667U,	// <0,1,7,3>: Cost 3 vext2 <7,3,0,1>, <7,3,0,1>
  2657736038U,	// <0,1,7,4>: Cost 3 vext2 <6,7,0,1>, <7,4,5,6>
  3721524621U,	// <0,1,7,5>: Cost 4 vext2 <5,1,0,1>, <7,5,1,0>
  2657736158U,	// <0,1,7,6>: Cost 3 vext2 <6,7,0,1>, <7,6,1,0>
  2657736300U,	// <0,1,7,7>: Cost 3 vext2 <6,7,0,1>, <7,7,7,7>
  2657736322U,	// <0,1,7,u>: Cost 3 vext2 <6,7,0,1>, <7,u,1,2>
  1494450278U,	// <0,1,u,0>: Cost 2 vext1 <3,0,1,u>, LHS
  1557452590U,	// <0,1,u,1>: Cost 2 vext2 <2,3,0,1>, LHS
  2960310941U,	// <0,1,u,2>: Cost 3 vzipr <1,2,3,0>, LHS
  835584U,	// <0,1,u,3>: Cost 0 copy LHS
  1494453558U,	// <0,1,u,4>: Cost 2 vext1 <3,0,1,u>, RHS
  1557452954U,	// <0,1,u,5>: Cost 2 vext2 <2,3,0,1>, RHS
  2631194800U,	// <0,1,u,6>: Cost 3 vext2 <2,3,0,1>, <u,6,0,2>
  1518343168U,	// <0,1,u,7>: Cost 2 vext1 <7,0,1,u>, <7,0,1,u>
  835584U,	// <0,1,u,u>: Cost 0 copy LHS
  2618589184U,	// <0,2,0,0>: Cost 3 vext2 <0,2,0,2>, <0,0,0,0>
  1544847462U,	// <0,2,0,1>: Cost 2 vext2 <0,2,0,2>, LHS
  1745666150U,	// <0,2,0,2>: Cost 2 vuzpr LHS, LHS
  2886516736U,	// <0,2,0,3>: Cost 3 vzipl LHS, <0,0,0,0>
  2562231606U,	// <0,2,0,4>: Cost 3 vext1 <2,0,2,0>, RHS
  3635973840U,	// <0,2,0,5>: Cost 4 vext1 <2,0,2,0>, <5,1,7,3>
  2586120488U,	// <0,2,0,6>: Cost 3 vext1 <6,0,2,0>, <6,0,2,0>
  2592093185U,	// <0,2,0,7>: Cost 3 vext1 <7,0,2,0>, <7,0,2,0>
  1746108518U,	// <0,2,0,u>: Cost 2 vuzpr LHS, LHS
  2618589942U,	// <0,2,1,0>: Cost 3 vext2 <0,2,0,2>, <1,0,3,2>
  2618590004U,	// <0,2,1,1>: Cost 3 vext2 <0,2,0,2>, <1,1,1,1>
  2618590102U,	// <0,2,1,2>: Cost 3 vext2 <0,2,0,2>, <1,2,3,0>
  2886518438U,	// <0,2,1,3>: Cost 3 vzipl LHS, <2,3,0,1>
  2556267830U,	// <0,2,1,4>: Cost 3 vext1 <1,0,2,1>, RHS
  2645132432U,	// <0,2,1,5>: Cost 3 vext2 <4,6,0,2>, <1,5,3,7>
  2586128681U,	// <0,2,1,6>: Cost 3 vext1 <6,0,2,1>, <6,0,2,1>
  3725509931U,	// <0,2,1,7>: Cost 4 vext2 <5,7,0,2>, <1,7,3,0>
  2886559398U,	// <0,2,1,u>: Cost 3 vzipl LHS, <2,3,0,1>
  1524334694U,	// <0,2,2,0>: Cost 2 vext1 <u,0,2,2>, LHS
  2618590744U,	// <0,2,2,1>: Cost 3 vext2 <0,2,0,2>, <2,1,2,3>
  2618590824U,	// <0,2,2,2>: Cost 3 vext2 <0,2,0,2>, <2,2,2,2>
  2886516900U,	// <0,2,2,3>: Cost 3 vzipl LHS, <0,2,0,2>
  1524337974U,	// <0,2,2,4>: Cost 2 vext1 <u,0,2,2>, RHS
  2598080208U,	// <0,2,2,5>: Cost 3 vext1 <u,0,2,2>, <5,1,7,3>
  2645133242U,	// <0,2,2,6>: Cost 3 vext2 <4,6,0,2>, <2,6,3,7>
  2598081530U,	// <0,2,2,7>: Cost 3 vext1 <u,0,2,2>, <7,0,1,2>
  1524340444U,	// <0,2,2,u>: Cost 2 vext1 <u,0,2,2>, <u,0,2,2>
  2618591382U,	// <0,2,3,0>: Cost 3 vext2 <0,2,0,2>, <3,0,1,2>
  2691876528U,	// <0,2,3,1>: Cost 3 vext3 <1,2,3,0>, <2,3,1,2>
  3692333360U,	// <0,2,3,2>: Cost 4 vext2 <0,2,0,2>, <3,2,0,3>
  2618591644U,	// <0,2,3,3>: Cost 3 vext2 <0,2,0,2>, <3,3,3,3>
  2618591746U,	// <0,2,3,4>: Cost 3 vext2 <0,2,0,2>, <3,4,5,6>
  2839560294U,	// <0,2,3,5>: Cost 3 vuzpr <3,4,5,6>, LHS
  3692333706U,	// <0,2,3,6>: Cost 4 vext2 <0,2,0,2>, <3,6,2,7>
  2698807012U,	// <0,2,3,7>: Cost 3 vext3 <2,3,7,0>, <2,3,7,0>
  2618592030U,	// <0,2,3,u>: Cost 3 vext2 <0,2,0,2>, <3,u,1,2>
  2618592146U,	// <0,2,4,0>: Cost 3 vext2 <0,2,0,2>, <4,0,5,1>
  3692334062U,	// <0,2,4,1>: Cost 4 vext2 <0,2,0,2>, <4,1,6,3>
  2226718152U,	// <0,2,4,2>: Cost 3 vrev <2,0,2,4>
  2568235169U,	// <0,2,4,3>: Cost 3 vext1 <3,0,2,4>, <3,0,2,4>
  2562264374U,	// <0,2,4,4>: Cost 3 vext1 <2,0,2,4>, RHS
  1544850742U,	// <0,2,4,5>: Cost 2 vext2 <0,2,0,2>, RHS
  1772535910U,	// <0,2,4,6>: Cost 2 vuzpr RHS, LHS
  2592125957U,	// <0,2,4,7>: Cost 3 vext1 <7,0,2,4>, <7,0,2,4>
  1544850985U,	// <0,2,4,u>: Cost 2 vext2 <0,2,0,2>, RHS
  2691876686U,	// <0,2,5,0>: Cost 3 vext3 <1,2,3,0>, <2,5,0,7>
  2618592976U,	// <0,2,5,1>: Cost 3 vext2 <0,2,0,2>, <5,1,7,3>
  2618593056U,	// <0,2,5,2>: Cost 3 vext2 <0,2,0,2>, <5,2,7,2>
  3964905940U,	// <0,2,5,3>: Cost 4 vzipl LHS, <3,4,0,5>
  2645135302U,	// <0,2,5,4>: Cost 3 vext2 <4,6,0,2>, <5,4,7,6>
  2645135364U,	// <0,2,5,5>: Cost 3 vext2 <4,6,0,2>, <5,5,5,5>
  2645135458U,	// <0,2,5,6>: Cost 3 vext2 <4,6,0,2>, <5,6,7,0>
  2849636454U,	// <0,2,5,7>: Cost 3 vuzpr <5,1,7,3>, LHS
  2645135620U,	// <0,2,5,u>: Cost 3 vext2 <4,6,0,2>, <5,u,7,0>
  2645135656U,	// <0,2,6,0>: Cost 3 vext2 <4,6,0,2>, <6,0,2,0>
  2645135740U,	// <0,2,6,1>: Cost 3 vext2 <4,6,0,2>, <6,1,2,3>
  2618593786U,	// <0,2,6,2>: Cost 3 vext2 <0,2,0,2>, <6,2,7,3>
  2718713786U,	// <0,2,6,3>: Cost 3 vext3 <5,6,7,0>, <2,6,3,7>
  2645135980U,	// <0,2,6,4>: Cost 3 vext2 <4,6,0,2>, <6,4,2,0>
  2645136068U,	// <0,2,6,5>: Cost 3 vext2 <4,6,0,2>, <6,5,2,7>
  2645136184U,	// <0,2,6,6>: Cost 3 vext2 <4,6,0,2>, <6,6,6,6>
  2645136206U,	// <0,2,6,7>: Cost 3 vext2 <4,6,0,2>, <6,7,0,1>
  2618594272U,	// <0,2,6,u>: Cost 3 vext2 <0,2,0,2>, <6,u,7,3>
  2645136378U,	// <0,2,7,0>: Cost 3 vext2 <4,6,0,2>, <7,0,1,2>
  2860466278U,	// <0,2,7,1>: Cost 3 vuzpr <7,0,1,2>, LHS
  3692336303U,	// <0,2,7,2>: Cost 4 vext2 <0,2,0,2>, <7,2,3,3>
  2701166596U,	// <0,2,7,3>: Cost 3 vext3 <2,7,3,0>, <2,7,3,0>
  2645136742U,	// <0,2,7,4>: Cost 3 vext2 <4,6,0,2>, <7,4,5,6>
  2863448166U,	// <0,2,7,5>: Cost 3 vuzpr <7,4,5,6>, LHS
  3718878688U,	// <0,2,7,6>: Cost 4 vext2 <4,6,0,2>, <7,6,1,2>
  2645137004U,	// <0,2,7,7>: Cost 3 vext2 <4,6,0,2>, <7,7,7,7>
  2645137026U,	// <0,2,7,u>: Cost 3 vext2 <4,6,0,2>, <7,u,1,2>
  1524383846U,	// <0,2,u,0>: Cost 2 vext1 <u,0,2,u>, LHS
  1544853294U,	// <0,2,u,1>: Cost 2 vext2 <0,2,0,2>, LHS
  1793441894U,	// <0,2,u,2>: Cost 2 vuzpr LHS, LHS
  2886518445U,	// <0,2,u,3>: Cost 3 vzipl LHS, <2,3,0,u>
  1524387126U,	// <0,2,u,4>: Cost 2 vext1 <u,0,2,u>, RHS
  1544853658U,	// <0,2,u,5>: Cost 2 vext2 <0,2,0,2>, RHS
  1796423782U,	// <0,2,u,6>: Cost 2 vuzpr RHS, LHS
  2645137664U,	// <0,2,u,7>: Cost 3 vext2 <4,6,0,2>, <u,7,0,1>
  1544853861U,	// <0,2,u,u>: Cost 2 vext2 <0,2,0,2>, LHS
  2618597376U,	// <0,3,0,0>: Cost 3 vext2 <0,2,0,3>, <0,0,0,0>
  2618597478U,	// <0,3,0,1>: Cost 3 vext2 <0,2,0,3>, LHS
  2618597541U,	// <0,3,0,2>: Cost 3 vext2 <0,2,0,3>, <0,2,0,3>
  3692339443U,	// <0,3,0,3>: Cost 4 vext2 <0,2,0,3>, <0,3,0,0>
  2691877044U,	// <0,3,0,4>: Cost 3 vext3 <1,2,3,0>, <3,0,4,5>
  3765618873U,	// <0,3,0,5>: Cost 4 vext3 <1,2,3,0>, <3,0,5,1>
  3765618883U,	// <0,3,0,6>: Cost 4 vext3 <1,2,3,0>, <3,0,6,2>
  3665908746U,	// <0,3,0,7>: Cost 4 vext1 <7,0,3,0>, <7,0,3,0>
  2618598045U,	// <0,3,0,u>: Cost 3 vext2 <0,2,0,3>, LHS
  2562310246U,	// <0,3,1,0>: Cost 3 vext1 <2,0,3,1>, LHS
  3692340020U,	// <0,3,1,1>: Cost 4 vext2 <0,2,0,3>, <1,1,1,1>
  2691877105U,	// <0,3,1,2>: Cost 3 vext3 <1,2,3,0>, <3,1,2,3>
  2568284327U,	// <0,3,1,3>: Cost 3 vext1 <3,0,3,1>, <3,0,3,1>
  2562313526U,	// <0,3,1,4>: Cost 3 vext1 <2,0,3,1>, RHS
  3765618956U,	// <0,3,1,5>: Cost 4 vext3 <1,2,3,0>, <3,1,5,3>
  3636056570U,	// <0,3,1,6>: Cost 4 vext1 <2,0,3,1>, <6,2,7,3>
  3665916939U,	// <0,3,1,7>: Cost 4 vext1 <7,0,3,1>, <7,0,3,1>
  2695858471U,	// <0,3,1,u>: Cost 3 vext3 <1,u,3,0>, <3,1,u,3>
  1482604646U,	// <0,3,2,0>: Cost 2 vext1 <1,0,3,2>, LHS
  1482605302U,	// <0,3,2,1>: Cost 2 vext1 <1,0,3,2>, <1,0,3,2>
  2556348008U,	// <0,3,2,2>: Cost 3 vext1 <1,0,3,2>, <2,2,2,2>
  2556348566U,	// <0,3,2,3>: Cost 3 vext1 <1,0,3,2>, <3,0,1,2>
  1482607926U,	// <0,3,2,4>: Cost 2 vext1 <1,0,3,2>, RHS
  2556350160U,	// <0,3,2,5>: Cost 3 vext1 <1,0,3,2>, <5,1,7,3>
  2556350970U,	// <0,3,2,6>: Cost 3 vext1 <1,0,3,2>, <6,2,7,3>
  2598155258U,	// <0,3,2,7>: Cost 3 vext1 <u,0,3,2>, <7,0,1,2>
  1482610478U,	// <0,3,2,u>: Cost 2 vext1 <1,0,3,2>, LHS
  3692341387U,	// <0,3,3,0>: Cost 4 vext2 <0,2,0,3>, <3,0,0,0>
  2635851999U,	// <0,3,3,1>: Cost 3 vext2 <3,1,0,3>, <3,1,0,3>
  2636515632U,	// <0,3,3,2>: Cost 3 vext2 <3,2,0,3>, <3,2,0,3>
  2691877276U,	// <0,3,3,3>: Cost 3 vext3 <1,2,3,0>, <3,3,3,3>
  3692341762U,	// <0,3,3,4>: Cost 4 vext2 <0,2,0,3>, <3,4,5,6>
  3778374059U,	// <0,3,3,5>: Cost 4 vext3 <3,3,5,0>, <3,3,5,0>
  3692341898U,	// <0,3,3,6>: Cost 5 vext2 <0,2,0,3>, <3,6,2,7>
  3665933325U,	// <0,3,3,7>: Cost 4 vext1 <7,0,3,3>, <7,0,3,3>
  2640497430U,	// <0,3,3,u>: Cost 3 vext2 <3,u,0,3>, <3,u,0,3>
  3692342162U,	// <0,3,4,0>: Cost 4 vext2 <0,2,0,3>, <4,0,5,1>
  2232617112U,	// <0,3,4,1>: Cost 3 vrev <3,0,1,4>
  2232690849U,	// <0,3,4,2>: Cost 3 vrev <3,0,2,4>
  3306506410U,	// <0,3,4,3>: Cost 4 vrev <3,0,3,4>
  3765987832U,	// <0,3,4,4>: Cost 4 vext3 <1,2,u,0>, <3,4,4,5>
  2618600758U,	// <0,3,4,5>: Cost 3 vext2 <0,2,0,3>, RHS
  2705369605U,	// <0,3,4,6>: Cost 3 vext3 <3,4,6,0>, <3,4,6,0>
  3665941518U,	// <0,3,4,7>: Cost 4 vext1 <7,0,3,4>, <7,0,3,4>
  2618601001U,	// <0,3,4,u>: Cost 3 vext2 <0,2,0,3>, RHS
  3765619234U,	// <0,3,5,0>: Cost 4 vext3 <1,2,3,0>, <3,5,0,2>
  3692342992U,	// <0,3,5,1>: Cost 4 vext2 <0,2,0,3>, <5,1,7,3>
  3708268318U,	// <0,3,5,2>: Cost 4 vext2 <2,u,0,3>, <5,2,7,0>
  3648031234U,	// <0,3,5,3>: Cost 4 vext1 <4,0,3,5>, <3,4,5,6>
  2232846516U,	// <0,3,5,4>: Cost 3 vrev <3,0,4,5>
  3779701325U,	// <0,3,5,5>: Cost 4 vext3 <3,5,5,0>, <3,5,5,0>
  2718714461U,	// <0,3,5,6>: Cost 3 vext3 <5,6,7,0>, <3,5,6,7>
  3779848799U,	// <0,3,5,7>: Cost 4 vext3 <3,5,7,0>, <3,5,7,0>
  2233141464U,	// <0,3,5,u>: Cost 3 vrev <3,0,u,5>
  3648036966U,	// <0,3,6,0>: Cost 4 vext1 <4,0,3,6>, LHS
  3306375322U,	// <0,3,6,1>: Cost 4 vrev <3,0,1,6>
  3692343802U,	// <0,3,6,2>: Cost 4 vext2 <0,2,0,3>, <6,2,7,3>
  3703624266U,	// <0,3,6,3>: Cost 4 vext2 <2,1,0,3>, <6,3,7,2>
  3306596533U,	// <0,3,6,4>: Cost 4 vrev <3,0,4,6>
  3306670270U,	// <0,3,6,5>: Cost 4 vrev <3,0,5,6>
  3733484344U,	// <0,3,6,6>: Cost 4 vext2 <7,1,0,3>, <6,6,6,6>
  2706770608U,	// <0,3,6,7>: Cost 3 vext3 <3,6,7,0>, <3,6,7,0>
  2706844345U,	// <0,3,6,u>: Cost 3 vext3 <3,6,u,0>, <3,6,u,0>
  3796437698U,	// <0,3,7,0>: Cost 4 vext3 <6,3,7,0>, <3,7,0,0>
  2659742787U,	// <0,3,7,1>: Cost 3 vext2 <7,1,0,3>, <7,1,0,3>
  3734148244U,	// <0,3,7,2>: Cost 4 vext2 <7,2,0,3>, <7,2,0,3>
  3734811877U,	// <0,3,7,3>: Cost 4 vext2 <7,3,0,3>, <7,3,0,3>
  3733484902U,	// <0,3,7,4>: Cost 4 vext2 <7,1,0,3>, <7,4,5,6>
  3781028591U,	// <0,3,7,5>: Cost 4 vext3 <3,7,5,0>, <3,7,5,0>
  3736802776U,	// <0,3,7,6>: Cost 4 vext2 <7,6,0,3>, <7,6,0,3>
  3733485103U,	// <0,3,7,7>: Cost 4 vext2 <7,1,0,3>, <7,7,1,0>
  2664388218U,	// <0,3,7,u>: Cost 3 vext2 <7,u,0,3>, <7,u,0,3>
  1482653798U,	// <0,3,u,0>: Cost 2 vext1 <1,0,3,u>, LHS
  1482654460U,	// <0,3,u,1>: Cost 2 vext1 <1,0,3,u>, <1,0,3,u>
  2556397160U,	// <0,3,u,2>: Cost 3 vext1 <1,0,3,u>, <2,2,2,2>
  2556397718U,	// <0,3,u,3>: Cost 3 vext1 <1,0,3,u>, <3,0,1,2>
  1482657078U,	// <0,3,u,4>: Cost 2 vext1 <1,0,3,u>, RHS
  2618603674U,	// <0,3,u,5>: Cost 3 vext2 <0,2,0,3>, RHS
  2556400122U,	// <0,3,u,6>: Cost 3 vext1 <1,0,3,u>, <6,2,7,3>
  2598204410U,	// <0,3,u,7>: Cost 3 vext1 <u,0,3,u>, <7,0,1,2>
  1482659630U,	// <0,3,u,u>: Cost 2 vext1 <1,0,3,u>, LHS
  2617278468U,	// <0,4,0,0>: Cost 3 vext2 <0,0,0,4>, <0,0,0,4>
  2631213158U,	// <0,4,0,1>: Cost 3 vext2 <2,3,0,4>, LHS
  2819408076U,	// <0,4,0,2>: Cost 3 vuzpr LHS, <0,2,4,6>
  3642091695U,	// <0,4,0,3>: Cost 4 vext1 <3,0,4,0>, <3,0,4,0>
  2657755474U,	// <0,4,0,4>: Cost 3 vext2 <6,7,0,4>, <0,4,1,5>
  2691877778U,	// <0,4,0,5>: Cost 3 vext3 <1,2,3,0>, <4,0,5,1>
  2691877788U,	// <0,4,0,6>: Cost 3 vext3 <1,2,3,0>, <4,0,6,2>
  3665982483U,	// <0,4,0,7>: Cost 4 vext1 <7,0,4,0>, <7,0,4,0>
  2691877805U,	// <0,4,0,u>: Cost 3 vext3 <1,2,3,0>, <4,0,u,1>
  2568355942U,	// <0,4,1,0>: Cost 3 vext1 <3,0,4,1>, LHS
  3704955700U,	// <0,4,1,1>: Cost 4 vext2 <2,3,0,4>, <1,1,1,1>
  2631213974U,	// <0,4,1,2>: Cost 3 vext2 <2,3,0,4>, <1,2,3,0>
  2568358064U,	// <0,4,1,3>: Cost 3 vext1 <3,0,4,1>, <3,0,4,1>
  2568359222U,	// <0,4,1,4>: Cost 3 vext1 <3,0,4,1>, RHS
  1906753638U,	// <0,4,1,5>: Cost 2 vzipr RHS, LHS
  3114713098U,	// <0,4,1,6>: Cost 3 vtrnr RHS, <0,0,1,1>
  2592248852U,	// <0,4,1,7>: Cost 3 vext1 <7,0,4,1>, <7,0,4,1>
  1908744294U,	// <0,4,1,u>: Cost 2 vzipr RHS, LHS
  2562392166U,	// <0,4,2,0>: Cost 3 vext1 <2,0,4,2>, LHS
  2238573423U,	// <0,4,2,1>: Cost 3 vrev <4,0,1,2>
  2562393560U,	// <0,4,2,2>: Cost 3 vext1 <2,0,4,2>, <2,0,4,2>
  2631214761U,	// <0,4,2,3>: Cost 3 vext2 <2,3,0,4>, <2,3,0,4>
  2562395446U,	// <0,4,2,4>: Cost 3 vext1 <2,0,4,2>, RHS
  3111272550U,	// <0,4,2,5>: Cost 3 vtrnr <4,0,5,1>, LHS
  2040971366U,	// <0,4,2,6>: Cost 2 vtrnr RHS, LHS
  2592257045U,	// <0,4,2,7>: Cost 3 vext1 <7,0,4,2>, <7,0,4,2>
  2041118822U,	// <0,4,2,u>: Cost 2 vtrnr RHS, LHS
  3704957078U,	// <0,4,3,0>: Cost 4 vext2 <2,3,0,4>, <3,0,1,2>
  3704957169U,	// <0,4,3,1>: Cost 4 vext2 <2,3,0,4>, <3,1,2,3>
  3704957232U,	// <0,4,3,2>: Cost 4 vext2 <2,3,0,4>, <3,2,0,3>
  3704957340U,	// <0,4,3,3>: Cost 4 vext2 <2,3,0,4>, <3,3,3,3>
  3704957442U,	// <0,4,3,4>: Cost 4 vext2 <2,3,0,4>, <3,4,5,6>
  3312618388U,	// <0,4,3,5>: Cost 4 vrev <4,0,5,3>
  3312692125U,	// <0,4,3,6>: Cost 4 vrev <4,0,6,3>
  3713583814U,	// <0,4,3,7>: Cost 4 vext2 <3,7,0,4>, <3,7,0,4>
  3704957726U,	// <0,4,3,u>: Cost 4 vext2 <2,3,0,4>, <3,u,1,2>
  2710899880U,	// <0,4,4,0>: Cost 3 vext3 <4,4,0,0>, <4,4,0,0>
  3704957924U,	// <0,4,4,1>: Cost 4 vext2 <2,3,0,4>, <4,1,5,2>
  3642123945U,	// <0,4,4,2>: Cost 4 vext1 <3,0,4,4>, <2,3,0,4>
  3642124467U,	// <0,4,4,3>: Cost 4 vext1 <3,0,4,4>, <3,0,4,4>
  2718715088U,	// <0,4,4,4>: Cost 3 vext3 <5,6,7,0>, <4,4,4,4>
  2631216438U,	// <0,4,4,5>: Cost 3 vext2 <2,3,0,4>, RHS
  2846277836U,	// <0,4,4,6>: Cost 3 vuzpr RHS, <0,2,4,6>
  3666015255U,	// <0,4,4,7>: Cost 4 vext1 <7,0,4,4>, <7,0,4,4>
  2631216681U,	// <0,4,4,u>: Cost 3 vext2 <2,3,0,4>, RHS
  2568388710U,	// <0,4,5,0>: Cost 3 vext1 <3,0,4,5>, LHS
  2568389526U,	// <0,4,5,1>: Cost 3 vext1 <3,0,4,5>, <1,2,3,0>
  3636159963U,	// <0,4,5,2>: Cost 4 vext1 <2,0,4,5>, <2,0,4,5>
  2568390836U,	// <0,4,5,3>: Cost 3 vext1 <3,0,4,5>, <3,0,4,5>
  2568391990U,	// <0,4,5,4>: Cost 3 vext1 <3,0,4,5>, RHS
  2592280674U,	// <0,4,5,5>: Cost 3 vext1 <7,0,4,5>, <5,6,7,0>
  1618136374U,	// <0,4,5,6>: Cost 2 vext3 <1,2,3,0>, RHS
  2592281624U,	// <0,4,5,7>: Cost 3 vext1 <7,0,4,5>, <7,0,4,5>
  1618136392U,	// <0,4,5,u>: Cost 2 vext3 <1,2,3,0>, RHS
  2691878220U,	// <0,4,6,0>: Cost 3 vext3 <1,2,3,0>, <4,6,0,2>
  3765620052U,	// <0,4,6,1>: Cost 4 vext3 <1,2,3,0>, <4,6,1,1>
  2712374620U,	// <0,4,6,2>: Cost 3 vext3 <4,6,2,0>, <4,6,2,0>
  3704959560U,	// <0,4,6,3>: Cost 4 vext2 <2,3,0,4>, <6,3,7,0>
  2712522094U,	// <0,4,6,4>: Cost 3 vext3 <4,6,4,0>, <4,6,4,0>
  4054237677U,	// <0,4,6,5>: Cost 4 vzipr RHS, <0,6,0,7>
  2712669568U,	// <0,4,6,6>: Cost 3 vext3 <4,6,6,0>, <4,6,6,0>
  2657760081U,	// <0,4,6,7>: Cost 3 vext2 <6,7,0,4>, <6,7,0,4>
  2712817042U,	// <0,4,6,u>: Cost 3 vext3 <4,6,u,0>, <4,6,u,0>
  3731502074U,	// <0,4,7,0>: Cost 4 vext2 <6,7,0,4>, <7,0,1,2>
  3934208204U,	// <0,4,7,1>: Cost 4 vuzpr <7,0,1,2>, <0,2,4,6>
  3934298316U,	// <0,4,7,2>: Cost 4 vuzpr <7,0,2,4>, <0,2,4,6>
  3734820070U,	// <0,4,7,3>: Cost 4 vext2 <7,3,0,4>, <7,3,0,4>
  3731502438U,	// <0,4,7,4>: Cost 4 vext2 <6,7,0,4>, <7,4,5,6>
  3937190092U,	// <0,4,7,5>: Cost 4 vuzpr <7,4,5,6>, <0,2,4,6>
  2713333201U,	// <0,4,7,6>: Cost 3 vext3 <4,7,6,0>, <4,7,6,0>
  3731502700U,	// <0,4,7,7>: Cost 4 vext2 <6,7,0,4>, <7,7,7,7>
  2713480675U,	// <0,4,7,u>: Cost 3 vext3 <4,7,u,0>, <4,7,u,0>
  2691878382U,	// <0,4,u,0>: Cost 3 vext3 <1,2,3,0>, <4,u,0,2>
  2631218990U,	// <0,4,u,1>: Cost 3 vext2 <2,3,0,4>, LHS
  2562442718U,	// <0,4,u,2>: Cost 3 vext1 <2,0,4,u>, <2,0,4,u>
  2568415415U,	// <0,4,u,3>: Cost 3 vext1 <3,0,4,u>, <3,0,4,u>
  2562444598U,	// <0,4,u,4>: Cost 3 vext1 <2,0,4,u>, RHS
  1906754205U,	// <0,4,u,5>: Cost 2 vzipr RHS, LHS
  1618136617U,	// <0,4,u,6>: Cost 2 vext3 <1,2,3,0>, RHS
  2592306203U,	// <0,4,u,7>: Cost 3 vext1 <7,0,4,u>, <7,0,4,u>
  1618136635U,	// <0,4,u,u>: Cost 2 vext3 <1,2,3,0>, RHS
  3636191334U,	// <0,5,0,0>: Cost 4 vext1 <2,0,5,0>, LHS
  2637856870U,	// <0,5,0,1>: Cost 3 vext2 <3,4,0,5>, LHS
  3636192735U,	// <0,5,0,2>: Cost 4 vext1 <2,0,5,0>, <2,0,5,0>
  3642165432U,	// <0,5,0,3>: Cost 4 vext1 <3,0,5,0>, <3,0,5,0>
  3636194614U,	// <0,5,0,4>: Cost 4 vext1 <2,0,5,0>, RHS
  3711598998U,	// <0,5,0,5>: Cost 4 vext2 <3,4,0,5>, <0,5,0,1>
  2718715508U,	// <0,5,0,6>: Cost 3 vext3 <5,6,7,0>, <5,0,6,1>
  3047604224U,	// <0,5,0,7>: Cost 3 vtrnl RHS, <0,0,0,0>
  2637857437U,	// <0,5,0,u>: Cost 3 vext2 <3,4,0,5>, LHS
  1500659814U,	// <0,5,1,0>: Cost 2 vext1 <4,0,5,1>, LHS
  2574402294U,	// <0,5,1,1>: Cost 3 vext1 <4,0,5,1>, <1,0,3,2>
  2574403176U,	// <0,5,1,2>: Cost 3 vext1 <4,0,5,1>, <2,2,2,2>
  2574403734U,	// <0,5,1,3>: Cost 3 vext1 <4,0,5,1>, <3,0,1,2>
  1500662674U,	// <0,5,1,4>: Cost 2 vext1 <4,0,5,1>, <4,0,5,1>
  2574405328U,	// <0,5,1,5>: Cost 3 vext1 <4,0,5,1>, <5,1,7,3>
  2574406138U,	// <0,5,1,6>: Cost 3 vext1 <4,0,5,1>, <6,2,7,3>
  2691878608U,	// <0,5,1,7>: Cost 3 vext3 <1,2,3,0>, <5,1,7,3>
  1500665646U,	// <0,5,1,u>: Cost 2 vext1 <4,0,5,1>, LHS
  2568437862U,	// <0,5,2,0>: Cost 3 vext1 <3,0,5,2>, LHS
  2244546120U,	// <0,5,2,1>: Cost 3 vrev <5,0,1,2>
  3636209121U,	// <0,5,2,2>: Cost 4 vext1 <2,0,5,2>, <2,0,5,2>
  2568439994U,	// <0,5,2,3>: Cost 3 vext1 <3,0,5,2>, <3,0,5,2>
  2568441142U,	// <0,5,2,4>: Cost 3 vext1 <3,0,5,2>, RHS
  3120595046U,	// <0,5,2,5>: Cost 3 vtrnr <5,5,5,5>, LHS
  3765620504U,	// <0,5,2,6>: Cost 4 vext3 <1,2,3,0>, <5,2,6,3>
  3047604244U,	// <0,5,2,7>: Cost 3 vtrnl RHS, <0,0,2,2>
  2568443694U,	// <0,5,2,u>: Cost 3 vext1 <3,0,5,2>, LHS
  3710937274U,	// <0,5,3,0>: Cost 4 vext2 <3,3,0,5>, <3,0,5,2>
  3790024505U,	// <0,5,3,1>: Cost 4 vext3 <5,3,1,0>, <5,3,1,0>
  3318369874U,	// <0,5,3,2>: Cost 4 vrev <5,0,2,3>
  3710937475U,	// <0,5,3,3>: Cost 4 vext2 <3,3,0,5>, <3,3,0,5>
  2637859284U,	// <0,5,3,4>: Cost 3 vext2 <3,4,0,5>, <3,4,0,5>
  3790319453U,	// <0,5,3,5>: Cost 4 vext3 <5,3,5,0>, <5,3,5,0>
  3790393190U,	// <0,5,3,6>: Cost 4 vext3 <5,3,6,0>, <5,3,6,0>
  2716725103U,	// <0,5,3,7>: Cost 3 vext3 <5,3,7,0>, <5,3,7,0>
  2640513816U,	// <0,5,3,u>: Cost 3 vext2 <3,u,0,5>, <3,u,0,5>
  2637859730U,	// <0,5,4,0>: Cost 3 vext2 <3,4,0,5>, <4,0,5,1>
  3711601637U,	// <0,5,4,1>: Cost 4 vext2 <3,4,0,5>, <4,1,5,3>
  3636225507U,	// <0,5,4,2>: Cost 4 vext1 <2,0,5,4>, <2,0,5,4>
  3648170452U,	// <0,5,4,3>: Cost 4 vext1 <4,0,5,4>, <3,4,0,5>
  3636227382U,	// <0,5,4,4>: Cost 4 vext1 <2,0,5,4>, RHS
  2637860150U,	// <0,5,4,5>: Cost 3 vext2 <3,4,0,5>, RHS
  2718715836U,	// <0,5,4,6>: Cost 3 vext3 <5,6,7,0>, <5,4,6,5>
  2718715846U,	// <0,5,4,7>: Cost 3 vext3 <5,6,7,0>, <5,4,7,6>
  2637860393U,	// <0,5,4,u>: Cost 3 vext2 <3,4,0,5>, RHS
  3792457683U,	// <0,5,5,0>: Cost 4 vext3 <5,6,7,0>, <5,5,0,1>
  3704966864U,	// <0,5,5,1>: Cost 4 vext2 <2,3,0,5>, <5,1,7,3>
  3711602411U,	// <0,5,5,2>: Cost 4 vext2 <3,4,0,5>, <5,2,1,3>
  3642206397U,	// <0,5,5,3>: Cost 4 vext1 <3,0,5,5>, <3,0,5,5>
  3318533734U,	// <0,5,5,4>: Cost 4 vrev <5,0,4,5>
  2718715908U,	// <0,5,5,5>: Cost 3 vext3 <5,6,7,0>, <5,5,5,5>
  2657767522U,	// <0,5,5,6>: Cost 3 vext2 <6,7,0,5>, <5,6,7,0>
  2718715928U,	// <0,5,5,7>: Cost 3 vext3 <5,6,7,0>, <5,5,7,7>
  2718715937U,	// <0,5,5,u>: Cost 3 vext3 <5,6,7,0>, <5,5,u,7>
  2592358502U,	// <0,5,6,0>: Cost 3 vext1 <7,0,5,6>, LHS
  3788918835U,	// <0,5,6,1>: Cost 4 vext3 <5,1,4,0>, <5,6,1,7>
  3711603194U,	// <0,5,6,2>: Cost 4 vext2 <3,4,0,5>, <6,2,7,3>
  3785748546U,	// <0,5,6,3>: Cost 4 vext3 <4,5,6,0>, <5,6,3,4>
  2592361782U,	// <0,5,6,4>: Cost 3 vext1 <7,0,5,6>, RHS
  2592362594U,	// <0,5,6,5>: Cost 3 vext1 <7,0,5,6>, <5,6,7,0>
  3792384089U,	// <0,5,6,6>: Cost 4 vext3 <5,6,6,0>, <5,6,6,0>
  1644974178U,	// <0,5,6,7>: Cost 2 vext3 <5,6,7,0>, <5,6,7,0>
  1645047915U,	// <0,5,6,u>: Cost 2 vext3 <5,6,u,0>, <5,6,u,0>
  3765620854U,	// <0,5,7,0>: Cost 4 vext3 <1,2,3,0>, <5,7,0,2>
  3699659876U,	// <0,5,7,1>: Cost 4 vext2 <1,4,0,5>, <7,1,4,0>
  3792752774U,	// <0,5,7,2>: Cost 4 vext3 <5,7,2,0>, <5,7,2,0>
  3734828263U,	// <0,5,7,3>: Cost 4 vext2 <7,3,0,5>, <7,3,0,5>
  2661750072U,	// <0,5,7,4>: Cost 3 vext2 <7,4,0,5>, <7,4,0,5>
  3792457896U,	// <0,5,7,5>: Cost 4 vext3 <5,6,7,0>, <5,7,5,7>
  3660140874U,	// <0,5,7,6>: Cost 4 vext1 <6,0,5,7>, <6,0,5,7>
  2719379635U,	// <0,5,7,7>: Cost 3 vext3 <5,7,7,0>, <5,7,7,0>
  2719453372U,	// <0,5,7,u>: Cost 3 vext3 <5,7,u,0>, <5,7,u,0>
  1500717158U,	// <0,5,u,0>: Cost 2 vext1 <4,0,5,u>, LHS
  2637862702U,	// <0,5,u,1>: Cost 3 vext2 <3,4,0,5>, LHS
  2574460520U,	// <0,5,u,2>: Cost 3 vext1 <4,0,5,u>, <2,2,2,2>
  2568489152U,	// <0,5,u,3>: Cost 3 vext1 <3,0,5,u>, <3,0,5,u>
  1500720025U,	// <0,5,u,4>: Cost 2 vext1 <4,0,5,u>, <4,0,5,u>
  2637863066U,	// <0,5,u,5>: Cost 3 vext2 <3,4,0,5>, RHS
  2574463482U,	// <0,5,u,6>: Cost 3 vext1 <4,0,5,u>, <6,2,7,3>
  1646301444U,	// <0,5,u,7>: Cost 2 vext3 <5,u,7,0>, <5,u,7,0>
  1500722990U,	// <0,5,u,u>: Cost 2 vext1 <4,0,5,u>, LHS
  2574467174U,	// <0,6,0,0>: Cost 3 vext1 <4,0,6,0>, LHS
  2637865062U,	// <0,6,0,1>: Cost 3 vext2 <3,4,0,6>, LHS
  2250576168U,	// <0,6,0,2>: Cost 3 vrev <6,0,2,0>
  3779113269U,	// <0,6,0,3>: Cost 4 vext3 <3,4,6,0>, <6,0,3,4>
  2574470042U,	// <0,6,0,4>: Cost 3 vext1 <4,0,6,0>, <4,0,6,0>
  3648212688U,	// <0,6,0,5>: Cost 4 vext1 <4,0,6,0>, <5,1,7,3>
  2586415436U,	// <0,6,0,6>: Cost 3 vext1 <6,0,6,0>, <6,0,6,0>
  2913386496U,	// <0,6,0,7>: Cost 3 vzipl RHS, <0,0,0,0>
  2637865629U,	// <0,6,0,u>: Cost 3 vext2 <3,4,0,6>, LHS
  2574475366U,	// <0,6,1,0>: Cost 3 vext1 <4,0,6,1>, LHS
  3699663668U,	// <0,6,1,1>: Cost 4 vext2 <1,4,0,6>, <1,1,1,1>
  2990489702U,	// <0,6,1,2>: Cost 3 vzipr <6,2,7,3>, LHS
  3642247362U,	// <0,6,1,3>: Cost 4 vext1 <3,0,6,1>, <3,0,6,1>
  2574478235U,	// <0,6,1,4>: Cost 3 vext1 <4,0,6,1>, <4,0,6,1>
  2580450932U,	// <0,6,1,5>: Cost 3 vext1 <5,0,6,1>, <5,0,6,1>
  2993094758U,	// <0,6,1,6>: Cost 3 vzipr <6,6,6,6>, LHS
  2913388198U,	// <0,6,1,7>: Cost 3 vzipl RHS, <2,3,0,1>
  2574481198U,	// <0,6,1,u>: Cost 3 vext1 <4,0,6,1>, LHS
  1500741734U,	// <0,6,2,0>: Cost 2 vext1 <4,0,6,2>, LHS
  2574484214U,	// <0,6,2,1>: Cost 3 vext1 <4,0,6,2>, <1,0,3,2>
  2574485096U,	// <0,6,2,2>: Cost 3 vext1 <4,0,6,2>, <2,2,2,2>
  2574485654U,	// <0,6,2,3>: Cost 3 vext1 <4,0,6,2>, <3,0,1,2>
  1500744604U,	// <0,6,2,4>: Cost 2 vext1 <4,0,6,2>, <4,0,6,2>
  2574487248U,	// <0,6,2,5>: Cost 3 vext1 <4,0,6,2>, <5,1,7,3>
  2574488013U,	// <0,6,2,6>: Cost 3 vext1 <4,0,6,2>, <6,2,2,3>
  2691879418U,	// <0,6,2,7>: Cost 3 vext3 <1,2,3,0>, <6,2,7,3>
  1500747566U,	// <0,6,2,u>: Cost 2 vext1 <4,0,6,2>, LHS
  3711608982U,	// <0,6,3,0>: Cost 4 vext2 <3,4,0,6>, <3,0,1,2>
  3324268834U,	// <0,6,3,1>: Cost 4 vrev <6,0,1,3>
  3324342571U,	// <0,6,3,2>: Cost 4 vrev <6,0,2,3>
  3711609244U,	// <0,6,3,3>: Cost 4 vext2 <3,4,0,6>, <3,3,3,3>
  2637867477U,	// <0,6,3,4>: Cost 3 vext2 <3,4,0,6>, <3,4,0,6>
  3796292150U,	// <0,6,3,5>: Cost 4 vext3 <6,3,5,0>, <6,3,5,0>
  3666154056U,	// <0,6,3,6>: Cost 4 vext1 <7,0,6,3>, <6,3,7,0>
  2722697800U,	// <0,6,3,7>: Cost 3 vext3 <6,3,7,0>, <6,3,7,0>
  2640522009U,	// <0,6,3,u>: Cost 3 vext2 <3,u,0,6>, <3,u,0,6>
  2637867932U,	// <0,6,4,0>: Cost 3 vext2 <3,4,0,6>, <4,0,6,2>
  3324277027U,	// <0,6,4,1>: Cost 4 vrev <6,0,1,4>
  2250608940U,	// <0,6,4,2>: Cost 3 vrev <6,0,2,4>
  3711609997U,	// <0,6,4,3>: Cost 4 vext2 <3,4,0,6>, <4,3,6,0>
  3648244638U,	// <0,6,4,4>: Cost 4 vext1 <4,0,6,4>, <4,0,6,4>
  2637868342U,	// <0,6,4,5>: Cost 3 vext2 <3,4,0,6>, RHS
  2723287696U,	// <0,6,4,6>: Cost 3 vext3 <6,4,6,0>, <6,4,6,0>
  3779039902U,	// <0,6,4,7>: Cost 4 vext3 <3,4,5,0>, <6,4,7,5>
  2637868585U,	// <0,6,4,u>: Cost 3 vext2 <3,4,0,6>, RHS
  2718716594U,	// <0,6,5,0>: Cost 3 vext3 <5,6,7,0>, <6,5,0,7>
  3711610576U,	// <0,6,5,1>: Cost 4 vext2 <3,4,0,6>, <5,1,7,3>
  3786265284U,	// <0,6,5,2>: Cost 4 vext3 <4,6,4,0>, <6,5,2,7>
  3711610736U,	// <0,6,5,3>: Cost 5 vext2 <3,4,0,6>, <5,3,7,1>
  3723554695U,	// <0,6,5,4>: Cost 4 vext2 <5,4,0,6>, <5,4,0,6>
  3792458460U,	// <0,6,5,5>: Cost 4 vext3 <5,6,7,0>, <6,5,5,4>
  3792458472U,	// <0,6,5,6>: Cost 4 vext3 <5,6,7,0>, <6,5,6,7>
  3784643307U,	// <0,6,5,7>: Cost 4 vext3 <4,4,0,0>, <6,5,7,1>
  2718716594U,	// <0,6,5,u>: Cost 3 vext3 <5,6,7,0>, <6,5,0,7>
  3786412796U,	// <0,6,6,0>: Cost 4 vext3 <4,6,6,0>, <6,6,0,0>
  3765621511U,	// <0,6,6,1>: Cost 4 vext3 <1,2,3,0>, <6,6,1,2>
  3704975866U,	// <0,6,6,2>: Cost 4 vext2 <2,3,0,6>, <6,2,7,3>
  3642288327U,	// <0,6,6,3>: Cost 4 vext1 <3,0,6,6>, <3,0,6,6>
  3786412836U,	// <0,6,6,4>: Cost 4 vext3 <4,6,6,0>, <6,6,4,4>
  3666178146U,	// <0,6,6,5>: Cost 4 vext1 <7,0,6,6>, <5,6,7,0>
  2718716728U,	// <0,6,6,6>: Cost 3 vext3 <5,6,7,0>, <6,6,6,6>
  2718716738U,	// <0,6,6,7>: Cost 3 vext3 <5,6,7,0>, <6,6,7,7>
  2718716747U,	// <0,6,6,u>: Cost 3 vext3 <5,6,7,0>, <6,6,u,7>
  2718716750U,	// <0,6,7,0>: Cost 3 vext3 <5,6,7,0>, <6,7,0,1>
  2724909910U,	// <0,6,7,1>: Cost 3 vext3 <6,7,1,0>, <6,7,1,0>
  3786117986U,	// <0,6,7,2>: Cost 4 vext3 <4,6,2,0>, <6,7,2,3>
  2725057384U,	// <0,6,7,3>: Cost 3 vext3 <6,7,3,0>, <6,7,3,0>
  2718716790U,	// <0,6,7,4>: Cost 3 vext3 <5,6,7,0>, <6,7,4,5>
  2718716800U,	// <0,6,7,5>: Cost 3 vext3 <5,6,7,0>, <6,7,5,6>
  3792458629U,	// <0,6,7,6>: Cost 4 vext3 <5,6,7,0>, <6,7,6,2>
  2725352332U,	// <0,6,7,7>: Cost 3 vext3 <6,7,7,0>, <6,7,7,0>
  2718716822U,	// <0,6,7,u>: Cost 3 vext3 <5,6,7,0>, <6,7,u,1>
  1500790886U,	// <0,6,u,0>: Cost 2 vext1 <4,0,6,u>, LHS
  2637870894U,	// <0,6,u,1>: Cost 3 vext2 <3,4,0,6>, LHS
  2574534248U,	// <0,6,u,2>: Cost 3 vext1 <4,0,6,u>, <2,2,2,2>
  2574534806U,	// <0,6,u,3>: Cost 3 vext1 <4,0,6,u>, <3,0,1,2>
  1500793762U,	// <0,6,u,4>: Cost 2 vext1 <4,0,6,u>, <4,0,6,u>
  2637871258U,	// <0,6,u,5>: Cost 3 vext2 <3,4,0,6>, RHS
  2574537210U,	// <0,6,u,6>: Cost 3 vext1 <4,0,6,u>, <6,2,7,3>
  2691879904U,	// <0,6,u,7>: Cost 3 vext3 <1,2,3,0>, <6,u,7,3>
  1500796718U,	// <0,6,u,u>: Cost 2 vext1 <4,0,6,u>, LHS
  2256401391U,	// <0,7,0,0>: Cost 3 vrev <7,0,0,0>
  2718716922U,	// <0,7,0,1>: Cost 3 vext3 <5,6,7,0>, <7,0,1,2>
  2256548865U,	// <0,7,0,2>: Cost 3 vrev <7,0,2,0>
  3990487040U,	// <0,7,0,3>: Cost 4 vzipl <5,1,7,3>, <0,0,0,0>
  2718716952U,	// <0,7,0,4>: Cost 3 vext3 <5,6,7,0>, <7,0,4,5>
  2718716962U,	// <0,7,0,5>: Cost 3 vext3 <5,6,7,0>, <7,0,5,6>
  2621284845U,	// <0,7,0,6>: Cost 3 vext2 <0,6,0,7>, <0,6,0,7>
  3993174016U,	// <0,7,0,7>: Cost 4 vzipl <5,5,7,7>, <0,0,0,0>
  2718716984U,	// <0,7,0,u>: Cost 3 vext3 <5,6,7,0>, <7,0,u,1>
  2580521062U,	// <0,7,1,0>: Cost 3 vext1 <5,0,7,1>, LHS
  3654263542U,	// <0,7,1,1>: Cost 4 vext1 <5,0,7,1>, <1,0,3,2>
  2586494630U,	// <0,7,1,2>: Cost 3 vext1 <6,0,7,1>, <2,3,0,1>
  3654264982U,	// <0,7,1,3>: Cost 4 vext1 <5,0,7,1>, <3,0,1,2>
  2580523922U,	// <0,7,1,4>: Cost 3 vext1 <5,0,7,1>, <4,0,5,1>
  2580524669U,	// <0,7,1,5>: Cost 3 vext1 <5,0,7,1>, <5,0,7,1>
  2586497366U,	// <0,7,1,6>: Cost 3 vext1 <6,0,7,1>, <6,0,7,1>
  2999812198U,	// <0,7,1,7>: Cost 3 vzipr <7,7,7,7>, LHS
  2580526894U,	// <0,7,1,u>: Cost 3 vext1 <5,0,7,1>, LHS
  2580529254U,	// <0,7,2,0>: Cost 3 vext1 <5,0,7,2>, LHS
  1182749690U,	// <0,7,2,1>: Cost 2 vrev <7,0,1,2>
  3654272616U,	// <0,7,2,2>: Cost 4 vext1 <5,0,7,2>, <2,2,2,2>
  2727711916U,	// <0,7,2,3>: Cost 3 vext3 <7,2,3,0>, <7,2,3,0>
  2580532534U,	// <0,7,2,4>: Cost 3 vext1 <5,0,7,2>, RHS
  2580532862U,	// <0,7,2,5>: Cost 3 vext1 <5,0,7,2>, <5,0,7,2>
  2586505559U,	// <0,7,2,6>: Cost 3 vext1 <6,0,7,2>, <6,0,7,2>
  3134029926U,	// <0,7,2,7>: Cost 3 vtrnr <7,7,7,7>, LHS
  1183265849U,	// <0,7,2,u>: Cost 2 vrev <7,0,u,2>
  3792458979U,	// <0,7,3,0>: Cost 4 vext3 <5,6,7,0>, <7,3,0,1>
  3330241531U,	// <0,7,3,1>: Cost 4 vrev <7,0,1,3>
  3330315268U,	// <0,7,3,2>: Cost 4 vrev <7,0,2,3>
  3792459008U,	// <0,7,3,3>: Cost 4 vext3 <5,6,7,0>, <7,3,3,3>
  3787740430U,	// <0,7,3,4>: Cost 4 vext3 <4,u,6,0>, <7,3,4,u>
  3712281127U,	// <0,7,3,5>: Cost 4 vext2 <3,5,0,7>, <3,5,0,7>
  3712944760U,	// <0,7,3,6>: Cost 4 vext2 <3,6,0,7>, <3,6,0,7>
  3802412321U,	// <0,7,3,7>: Cost 4 vext3 <7,3,7,0>, <7,3,7,0>
  3714272026U,	// <0,7,3,u>: Cost 4 vext2 <3,u,0,7>, <3,u,0,7>
  3654287462U,	// <0,7,4,0>: Cost 4 vext1 <5,0,7,4>, LHS
  2256507900U,	// <0,7,4,1>: Cost 3 vrev <7,0,1,4>
  2256581637U,	// <0,7,4,2>: Cost 3 vrev <7,0,2,4>
  3330397198U,	// <0,7,4,3>: Cost 4 vrev <7,0,3,4>
  3786413405U,	// <0,7,4,4>: Cost 4 vext3 <4,6,6,0>, <7,4,4,6>
  2718717286U,	// <0,7,4,5>: Cost 3 vext3 <5,6,7,0>, <7,4,5,6>
  2729260393U,	// <0,7,4,6>: Cost 3 vext3 <7,4,6,0>, <7,4,6,0>
  3792459127U,	// <0,7,4,7>: Cost 4 vext3 <5,6,7,0>, <7,4,7,5>
  2718717313U,	// <0,7,4,u>: Cost 3 vext3 <5,6,7,0>, <7,4,u,6>
  3712282238U,	// <0,7,5,0>: Cost 4 vext2 <3,5,0,7>, <5,0,7,2>
  3712282320U,	// <0,7,5,1>: Cost 4 vext2 <3,5,0,7>, <5,1,7,3>
  3789804957U,	// <0,7,5,2>: Cost 4 vext3 <5,2,7,0>, <7,5,2,7>
  3654297780U,	// <0,7,5,3>: Cost 4 vext1 <5,0,7,5>, <3,0,4,5>
  2256737304U,	// <0,7,5,4>: Cost 3 vrev <7,0,4,5>
  3654299265U,	// <0,7,5,5>: Cost 4 vext1 <5,0,7,5>, <5,0,7,5>
  2718717377U,	// <0,7,5,6>: Cost 3 vext3 <5,6,7,0>, <7,5,6,7>
  3792459210U,	// <0,7,5,7>: Cost 4 vext3 <5,6,7,0>, <7,5,7,7>
  2257032252U,	// <0,7,5,u>: Cost 3 vrev <7,0,u,5>
  3712946519U,	// <0,7,6,0>: Cost 4 vext2 <3,6,0,7>, <6,0,7,2>
  2256524286U,	// <0,7,6,1>: Cost 3 vrev <7,0,1,6>
  3712946682U,	// <0,7,6,2>: Cost 4 vext2 <3,6,0,7>, <6,2,7,3>
  3660278229U,	// <0,7,6,3>: Cost 4 vext1 <6,0,7,6>, <3,4,0,6>
  3792459262U,	// <0,7,6,4>: Cost 4 vext3 <5,6,7,0>, <7,6,4,5>
  2656457394U,	// <0,7,6,5>: Cost 3 vext2 <6,5,0,7>, <6,5,0,7>
  3792459281U,	// <0,7,6,6>: Cost 4 vext3 <5,6,7,0>, <7,6,6,6>
  2730661396U,	// <0,7,6,7>: Cost 3 vext3 <7,6,7,0>, <7,6,7,0>
  2658448293U,	// <0,7,6,u>: Cost 3 vext2 <6,u,0,7>, <6,u,0,7>
  3792459303U,	// <0,7,7,0>: Cost 4 vext3 <5,6,7,0>, <7,7,0,1>
  3934208226U,	// <0,7,7,1>: Cost 4 vuzpr <7,0,1,2>, <0,2,7,1>
  3801454139U,	// <0,7,7,2>: Cost 4 vext3 <7,2,3,0>, <7,7,2,3>
  3804771905U,	// <0,7,7,3>: Cost 4 vext3 <7,7,3,0>, <7,7,3,0>
  3792459343U,	// <0,7,7,4>: Cost 4 vext3 <5,6,7,0>, <7,7,4,5>
  3792459352U,	// <0,7,7,5>: Cost 4 vext3 <5,6,7,0>, <7,7,5,5>
  3730200066U,	// <0,7,7,6>: Cost 4 vext2 <6,5,0,7>, <7,6,5,0>
  2718717548U,	// <0,7,7,7>: Cost 3 vext3 <5,6,7,0>, <7,7,7,7>
  2718717548U,	// <0,7,7,u>: Cost 3 vext3 <5,6,7,0>, <7,7,7,7>
  2580578406U,	// <0,7,u,0>: Cost 3 vext1 <5,0,7,u>, LHS
  1182798848U,	// <0,7,u,1>: Cost 2 vrev <7,0,1,u>
  2731619977U,	// <0,7,u,2>: Cost 3 vext3 <7,u,2,0>, <7,u,2,0>
  2731693714U,	// <0,7,u,3>: Cost 3 vext3 <7,u,3,0>, <7,u,3,0>
  2580581686U,	// <0,7,u,4>: Cost 3 vext1 <5,0,7,u>, RHS
  2580582020U,	// <0,7,u,5>: Cost 3 vext1 <5,0,7,u>, <5,0,7,u>
  2586554717U,	// <0,7,u,6>: Cost 3 vext1 <6,0,7,u>, <6,0,7,u>
  2999812765U,	// <0,7,u,7>: Cost 3 vzipr <7,7,7,7>, LHS
  1183315007U,	// <0,7,u,u>: Cost 2 vrev <7,0,u,u>
  135053414U,	// <0,u,0,0>: Cost 1 vdup0 LHS
  1544896614U,	// <0,u,0,1>: Cost 2 vext2 <0,2,0,u>, LHS
  1745666204U,	// <0,u,0,2>: Cost 2 vuzpr LHS, LHS
  2886959104U,	// <0,u,0,3>: Cost 3 vzipl LHS, <0,0,0,0>
  1476988214U,	// <0,u,0,4>: Cost 2 vext1 <0,0,u,0>, RHS
  2691880694U,	// <0,u,0,5>: Cost 3 vext3 <1,2,3,0>, <u,0,5,1>
  2691880704U,	// <0,u,0,6>: Cost 3 vext3 <1,2,3,0>, <u,0,6,2>
  2913533952U,	// <0,u,0,7>: Cost 3 vzipl RHS, <0,0,0,0>
  135053414U,	// <0,u,0,u>: Cost 1 vdup0 LHS
  1500880998U,	// <0,u,1,0>: Cost 2 vext1 <4,0,u,1>, LHS
  1927659622U,	// <0,u,1,1>: Cost 2 vzipr LHS, LHS
  1618138926U,	// <0,u,1,2>: Cost 2 vext3 <1,2,3,0>, LHS
  2886960806U,	// <0,u,1,3>: Cost 3 vzipl LHS, <2,3,0,1>
  1500883885U,	// <0,u,1,4>: Cost 2 vext1 <4,0,u,1>, <4,0,u,1>
  1930641510U,	// <0,u,1,5>: Cost 2 vzipr RHS, LHS
  2574627322U,	// <0,u,1,6>: Cost 3 vext1 <4,0,u,1>, <6,2,7,3>
  2691880795U,	// <0,u,1,7>: Cost 3 vext3 <1,2,3,0>, <u,1,7,3>
  1618138980U,	// <0,u,1,u>: Cost 2 vext3 <1,2,3,0>, LHS
  1482973286U,	// <0,u,2,0>: Cost 2 vext1 <1,0,u,2>, LHS
  1482973987U,	// <0,u,2,1>: Cost 2 vext1 <1,0,u,2>, <1,0,u,2>
  2061877350U,	// <0,u,2,2>: Cost 2 vtrnr LHS, LHS
  835584U,	// <0,u,2,3>: Cost 0 copy LHS
  1482976566U,	// <0,u,2,4>: Cost 2 vext1 <1,0,u,2>, RHS
  2556718800U,	// <0,u,2,5>: Cost 3 vext1 <1,0,u,2>, <5,1,7,3>
  2064859238U,	// <0,u,2,6>: Cost 2 vtrnr RHS, LHS
  1518810169U,	// <0,u,2,7>: Cost 2 vext1 <7,0,u,2>, <7,0,u,2>
  835584U,	// <0,u,2,u>: Cost 0 copy LHS
  2618640534U,	// <0,u,3,0>: Cost 3 vext2 <0,2,0,u>, <3,0,1,2>
  2691880902U,	// <0,u,3,1>: Cost 3 vext3 <1,2,3,0>, <u,3,1,2>
  2636556597U,	// <0,u,3,2>: Cost 3 vext2 <3,2,0,u>, <3,2,0,u>
  2618640796U,	// <0,u,3,3>: Cost 3 vext2 <0,2,0,u>, <3,3,3,3>
  2618640898U,	// <0,u,3,4>: Cost 3 vext2 <0,2,0,u>, <3,4,5,6>
  2839560348U,	// <0,u,3,5>: Cost 3 vuzpr <3,4,5,6>, LHS
  2657733296U,	// <0,u,3,6>: Cost 3 vext2 <6,7,0,1>, <3,6,7,0>
  2734643194U,	// <0,u,3,7>: Cost 3 vext3 <u,3,7,0>, <u,3,7,0>
  2618641182U,	// <0,u,3,u>: Cost 3 vext2 <0,2,0,u>, <3,u,1,2>
  2618641298U,	// <0,u,4,0>: Cost 3 vext2 <0,2,0,u>, <4,0,5,1>
  2718717978U,	// <0,u,4,1>: Cost 3 vext3 <5,6,7,0>, <u,4,1,5>
  2562704894U,	// <0,u,4,2>: Cost 3 vext1 <2,0,u,4>, <2,0,u,4>
  2568677591U,	// <0,u,4,3>: Cost 3 vext1 <3,0,u,4>, <3,0,u,4>
  2562706742U,	// <0,u,4,4>: Cost 3 vext1 <2,0,u,4>, RHS
  1544899894U,	// <0,u,4,5>: Cost 2 vext2 <0,2,0,u>, RHS
  1772535964U,	// <0,u,4,6>: Cost 2 vuzpr RHS, LHS
  2718718033U,	// <0,u,4,7>: Cost 3 vext3 <5,6,7,0>, <u,4,7,6>
  1544900137U,	// <0,u,4,u>: Cost 2 vext2 <0,2,0,u>, RHS
  2568683622U,	// <0,u,5,0>: Cost 3 vext1 <3,0,u,5>, LHS
  2618642128U,	// <0,u,5,1>: Cost 3 vext2 <0,2,0,u>, <5,1,7,3>
  2618642214U,	// <0,u,5,2>: Cost 3 vext2 <0,2,0,u>, <5,2,7,u>
  2568685784U,	// <0,u,5,3>: Cost 3 vext1 <3,0,u,5>, <3,0,u,5>
  2568686902U,	// <0,u,5,4>: Cost 3 vext1 <3,0,u,5>, RHS
  2645184516U,	// <0,u,5,5>: Cost 3 vext2 <4,6,0,u>, <5,5,5,5>
  1618139290U,	// <0,u,5,6>: Cost 2 vext3 <1,2,3,0>, RHS
  2849636508U,	// <0,u,5,7>: Cost 3 vuzpr <5,1,7,3>, LHS
  1618139308U,	// <0,u,5,u>: Cost 2 vext3 <1,2,3,0>, RHS
  2691881136U,	// <0,u,6,0>: Cost 3 vext3 <1,2,3,0>, <u,6,0,2>
  2645184946U,	// <0,u,6,1>: Cost 3 vext2 <4,6,0,u>, <6,1,u,3>
  2618642938U,	// <0,u,6,2>: Cost 3 vext2 <0,2,0,u>, <6,2,7,3>
  2718718160U,	// <0,u,6,3>: Cost 3 vext3 <5,6,7,0>, <u,6,3,7>
  2718718168U,	// <0,u,6,4>: Cost 3 vext3 <5,6,7,0>, <u,6,4,6>
  2656465587U,	// <0,u,6,5>: Cost 3 vext2 <6,5,0,u>, <6,5,0,u>
  2645185336U,	// <0,u,6,6>: Cost 3 vext2 <4,6,0,u>, <6,6,6,6>
  1584051029U,	// <0,u,6,7>: Cost 2 vext2 <6,7,0,u>, <6,7,0,u>
  1584714662U,	// <0,u,6,u>: Cost 2 vext2 <6,u,0,u>, <6,u,0,u>
  2645185530U,	// <0,u,7,0>: Cost 3 vext2 <4,6,0,u>, <7,0,1,2>
  2860466332U,	// <0,u,7,1>: Cost 3 vuzpr <7,0,1,2>, LHS
  2631193772U,	// <0,u,7,2>: Cost 3 vext2 <2,3,0,1>, <7,2,3,0>
  2661111018U,	// <0,u,7,3>: Cost 3 vext2 <7,3,0,u>, <7,3,0,u>
  2645185894U,	// <0,u,7,4>: Cost 3 vext2 <4,6,0,u>, <7,4,5,6>
  2718718258U,	// <0,u,7,5>: Cost 3 vext3 <5,6,7,0>, <u,7,5,6>
  2663101917U,	// <0,u,7,6>: Cost 3 vext2 <7,6,0,u>, <7,6,0,u>
  2645186156U,	// <0,u,7,7>: Cost 3 vext2 <4,6,0,u>, <7,7,7,7>
  2645186178U,	// <0,u,7,u>: Cost 3 vext2 <4,6,0,u>, <7,u,1,2>
  135053414U,	// <0,u,u,0>: Cost 1 vdup0 LHS
  1544902446U,	// <0,u,u,1>: Cost 2 vext2 <0,2,0,u>, LHS
  1618139493U,	// <0,u,u,2>: Cost 2 vext3 <1,2,3,0>, LHS
  835584U,	// <0,u,u,3>: Cost 0 copy LHS
  1483025718U,	// <0,u,u,4>: Cost 2 vext1 <1,0,u,u>, RHS
  1544902810U,	// <0,u,u,5>: Cost 2 vext2 <0,2,0,u>, RHS
  1618139533U,	// <0,u,u,6>: Cost 2 vext3 <1,2,3,0>, RHS
  1518859327U,	// <0,u,u,7>: Cost 2 vext1 <7,0,u,u>, <7,0,u,u>
  835584U,	// <0,u,u,u>: Cost 0 copy LHS
  2691072000U,	// <1,0,0,0>: Cost 3 vext3 <1,1,1,1>, <0,0,0,0>
  1610694666U,	// <1,0,0,1>: Cost 2 vext3 <0,0,1,1>, <0,0,1,1>
  2691072020U,	// <1,0,0,2>: Cost 3 vext3 <1,1,1,1>, <0,0,2,2>
  3704996101U,	// <1,0,0,3>: Cost 4 vext2 <2,3,1,0>, <0,3,2,0>
  2556775734U,	// <1,0,0,4>: Cost 3 vext1 <1,1,0,0>, RHS
  2620637598U,	// <1,0,0,5>: Cost 3 vext2 <0,5,1,0>, <0,5,1,0>
  3289440391U,	// <1,0,0,6>: Cost 4 vrev <0,1,6,0>
  3666351168U,	// <1,0,0,7>: Cost 4 vext1 <7,1,0,0>, <7,1,0,0>
  1611210825U,	// <1,0,0,u>: Cost 2 vext3 <0,0,u,1>, <0,0,u,1>
  2698297426U,	// <1,0,1,0>: Cost 3 vext3 <2,3,0,1>, <0,1,0,1>
  2953626420U,	// <1,0,1,1>: Cost 3 vzipr LHS, <1,1,1,1>
  1617330278U,	// <1,0,1,2>: Cost 2 vext3 <1,1,1,1>, LHS
  3898524378U,	// <1,0,1,3>: Cost 4 vuzpr <1,0,3,2>, <1,0,0,1>
  2698297466U,	// <1,0,1,4>: Cost 3 vext3 <2,3,0,1>, <0,1,4,5>
  2580672143U,	// <1,0,1,5>: Cost 3 vext1 <5,1,0,1>, <5,1,0,1>
  2724839566U,	// <1,0,1,6>: Cost 3 vext3 <6,7,0,1>, <0,1,6,7>
  3654415354U,	// <1,0,1,7>: Cost 4 vext1 <5,1,0,1>, <7,0,1,2>
  1617330332U,	// <1,0,1,u>: Cost 2 vext3 <1,1,1,1>, LHS
  2686279844U,	// <1,0,2,0>: Cost 3 vext3 <0,2,u,1>, <0,2,0,2>
  2953626518U,	// <1,0,2,1>: Cost 3 vzipr LHS, <1,2,3,0>
  4161585900U,	// <1,0,2,2>: Cost 4 vtrnr LHS, <1,0,2,1>
  2631255726U,	// <1,0,2,3>: Cost 3 vext2 <2,3,1,0>, <2,3,1,0>
  2556792118U,	// <1,0,2,4>: Cost 3 vext1 <1,1,0,2>, RHS
  3759800528U,	// <1,0,2,5>: Cost 4 vext3 <0,2,5,1>, <0,2,5,1>
  3630535162U,	// <1,0,2,6>: Cost 4 vext1 <1,1,0,2>, <6,2,7,3>
  2686206178U,	// <1,0,2,7>: Cost 3 vext3 <0,2,7,1>, <0,2,7,1>
  2686279915U,	// <1,0,2,u>: Cost 3 vext3 <0,2,u,1>, <0,2,u,1>
  2562768998U,	// <1,0,3,0>: Cost 3 vext1 <2,1,0,3>, LHS
  2562769654U,	// <1,0,3,1>: Cost 3 vext1 <2,1,0,3>, <1,0,3,2>
  67944550U,	// <1,0,3,2>: Cost 1 vrev LHS
  2568743135U,	// <1,0,3,3>: Cost 3 vext1 <3,1,0,3>, <3,1,0,3>
  2562772278U,	// <1,0,3,4>: Cost 3 vext1 <2,1,0,3>, RHS
  3636514512U,	// <1,0,3,5>: Cost 4 vext1 <2,1,0,3>, <5,1,7,3>
  3636515322U,	// <1,0,3,6>: Cost 4 vext1 <2,1,0,3>, <6,2,7,3>
  2592633923U,	// <1,0,3,7>: Cost 3 vext1 <7,1,0,3>, <7,1,0,3>
  68386972U,	// <1,0,3,u>: Cost 1 vrev LHS
  2620640146U,	// <1,0,4,0>: Cost 3 vext2 <0,5,1,0>, <4,0,5,1>
  2708619602U,	// <1,0,4,1>: Cost 3 vext3 <4,0,5,1>, <0,4,1,5>
  2724839772U,	// <1,0,4,2>: Cost 3 vext3 <6,7,0,1>, <0,4,2,6>
  3642493152U,	// <1,0,4,3>: Cost 4 vext1 <3,1,0,4>, <3,1,0,4>
  3642494262U,	// <1,0,4,4>: Cost 4 vext1 <3,1,0,4>, RHS
  2631257398U,	// <1,0,4,5>: Cost 3 vext2 <2,3,1,0>, RHS
  3704999244U,	// <1,0,4,6>: Cost 4 vext2 <2,3,1,0>, <4,6,0,2>
  3666383940U,	// <1,0,4,7>: Cost 4 vext1 <7,1,0,4>, <7,1,0,4>
  2631257641U,	// <1,0,4,u>: Cost 3 vext2 <2,3,1,0>, RHS
  3782361494U,	// <1,0,5,0>: Cost 4 vext3 <4,0,5,1>, <0,5,0,1>
  2708619678U,	// <1,0,5,1>: Cost 3 vext3 <4,0,5,1>, <0,5,1,0>
  3987308882U,	// <1,0,5,2>: Cost 4 vzipl <4,6,0,2>, <0,4,1,5>
  3708981104U,	// <1,0,5,3>: Cost 4 vext2 <3,0,1,0>, <5,3,7,1>
  2215592058U,	// <1,0,5,4>: Cost 3 vrev <0,1,4,5>
  3654446739U,	// <1,0,5,5>: Cost 4 vext1 <5,1,0,5>, <5,1,0,5>
  3724906540U,	// <1,0,5,6>: Cost 4 vext2 <5,6,1,0>, <5,6,1,0>
  3782361560U,	// <1,0,5,7>: Cost 4 vext3 <4,0,5,1>, <0,5,7,4>
  2708619678U,	// <1,0,5,u>: Cost 3 vext3 <4,0,5,1>, <0,5,1,0>
  3708981590U,	// <1,0,6,0>: Cost 4 vext2 <3,0,1,0>, <6,0,7,1>
  2698297846U,	// <1,0,6,1>: Cost 3 vext3 <2,3,0,1>, <0,6,1,7>
  3705000442U,	// <1,0,6,2>: Cost 4 vext2 <2,3,1,0>, <6,2,7,3>
  3705000522U,	// <1,0,6,3>: Cost 4 vext2 <2,3,1,0>, <6,3,7,2>
  3666398518U,	// <1,0,6,4>: Cost 4 vext1 <7,1,0,6>, RHS
  3730215604U,	// <1,0,6,5>: Cost 4 vext2 <6,5,1,0>, <6,5,1,0>
  3731542840U,	// <1,0,6,6>: Cost 4 vext2 <6,7,1,0>, <6,6,6,6>
  2657801046U,	// <1,0,6,7>: Cost 3 vext2 <6,7,1,0>, <6,7,1,0>
  2658464679U,	// <1,0,6,u>: Cost 3 vext2 <6,u,1,0>, <6,u,1,0>
  2659128312U,	// <1,0,7,0>: Cost 3 vext2 <7,0,1,0>, <7,0,1,0>
  3788481088U,	// <1,0,7,1>: Cost 4 vext3 <5,0,7,1>, <0,7,1,0>
  2215460970U,	// <1,0,7,2>: Cost 3 vrev <0,1,2,7>
  3734861035U,	// <1,0,7,3>: Cost 4 vext2 <7,3,1,0>, <7,3,1,0>
  3731543398U,	// <1,0,7,4>: Cost 4 vext2 <6,7,1,0>, <7,4,5,6>
  3736188301U,	// <1,0,7,5>: Cost 4 vext2 <7,5,1,0>, <7,5,1,0>
  2663110110U,	// <1,0,7,6>: Cost 3 vext2 <7,6,1,0>, <7,6,1,0>
  3731543660U,	// <1,0,7,7>: Cost 4 vext2 <6,7,1,0>, <7,7,7,7>
  2664437376U,	// <1,0,7,u>: Cost 3 vext2 <7,u,1,0>, <7,u,1,0>
  2689671817U,	// <1,0,u,0>: Cost 3 vext3 <0,u,0,1>, <0,u,0,1>
  1616003730U,	// <1,0,u,1>: Cost 2 vext3 <0,u,1,1>, <0,u,1,1>
  67985515U,	// <1,0,u,2>: Cost 1 vrev LHS
  2568784100U,	// <1,0,u,3>: Cost 3 vext1 <3,1,0,u>, <3,1,0,u>
  2556841270U,	// <1,0,u,4>: Cost 3 vext1 <1,1,0,u>, RHS
  2631260314U,	// <1,0,u,5>: Cost 3 vext2 <2,3,1,0>, RHS
  2669082807U,	// <1,0,u,6>: Cost 3 vext2 <u,6,1,0>, <u,6,1,0>
  2592674888U,	// <1,0,u,7>: Cost 3 vext1 <7,1,0,u>, <7,1,0,u>
  68427937U,	// <1,0,u,u>: Cost 1 vrev LHS
  1543585802U,	// <1,1,0,0>: Cost 2 vext2 <0,0,1,1>, <0,0,1,1>
  1550221414U,	// <1,1,0,1>: Cost 2 vext2 <1,1,1,1>, LHS
  2819408692U,	// <1,1,0,2>: Cost 3 vuzpr LHS, <1,1,1,1>
  2690335478U,	// <1,1,0,3>: Cost 3 vext3 <1,0,0,1>, <1,0,3,2>
  2665103698U,	// <1,1,0,4>: Cost 3 vext2 <u,0,1,1>, <0,4,1,5>
  3782361863U,	// <1,1,0,5>: Cost 4 vext3 <4,0,5,1>, <1,0,5,1>
  3660452208U,	// <1,1,0,6>: Cost 4 vext1 <6,1,1,0>, <6,1,1,0>
  3666424905U,	// <1,1,0,7>: Cost 4 vext1 <7,1,1,0>, <7,1,1,0>
  1550221981U,	// <1,1,0,u>: Cost 2 vext2 <1,1,1,1>, LHS
  1483112550U,	// <1,1,1,0>: Cost 2 vext1 <1,1,1,1>, LHS
  202162278U,	// <1,1,1,1>: Cost 1 vdup1 LHS
  2556855912U,	// <1,1,1,2>: Cost 3 vext1 <1,1,1,1>, <2,2,2,2>
  3020735284U,	// <1,1,1,3>: Cost 3 vtrnl LHS, <1,1,1,1>
  1483115830U,	// <1,1,1,4>: Cost 2 vext1 <1,1,1,1>, RHS
  2556858064U,	// <1,1,1,5>: Cost 3 vext1 <1,1,1,1>, <5,1,7,3>
  2556858874U,	// <1,1,1,6>: Cost 3 vext1 <1,1,1,1>, <6,2,7,3>
  2592691274U,	// <1,1,1,7>: Cost 3 vext1 <7,1,1,1>, <7,1,1,1>
  202162278U,	// <1,1,1,u>: Cost 1 vdup1 LHS
  2598666342U,	// <1,1,2,0>: Cost 3 vext1 <u,1,1,2>, LHS
  2691072903U,	// <1,1,2,1>: Cost 3 vext3 <1,1,1,1>, <1,2,1,3>
  2623964776U,	// <1,1,2,2>: Cost 3 vext2 <1,1,1,1>, <2,2,2,2>
  2690483094U,	// <1,1,2,3>: Cost 3 vext3 <1,0,2,1>, <1,2,3,0>
  2598669622U,	// <1,1,2,4>: Cost 3 vext1 <u,1,1,2>, RHS
  3654495897U,	// <1,1,2,5>: Cost 4 vext1 <5,1,1,2>, <5,1,1,2>
  2665105338U,	// <1,1,2,6>: Cost 3 vext2 <u,0,1,1>, <2,6,3,7>
  3801088954U,	// <1,1,2,7>: Cost 4 vext3 <7,1,7,1>, <1,2,7,0>
  2623965243U,	// <1,1,2,u>: Cost 3 vext2 <1,1,1,1>, <2,u,0,1>
  2623965334U,	// <1,1,3,0>: Cost 3 vext2 <1,1,1,1>, <3,0,1,2>
  2623965414U,	// <1,1,3,1>: Cost 3 vext2 <1,1,1,1>, <3,1,1,1>
  4166878102U,	// <1,1,3,2>: Cost 4 vtrnr <1,0,2,1>, <1,2,3,0>
  1946992742U,	// <1,1,3,3>: Cost 2 vtrnl LHS, LHS
  2623965698U,	// <1,1,3,4>: Cost 3 vext2 <1,1,1,1>, <3,4,5,6>
  3697707554U,	// <1,1,3,5>: Cost 4 vext2 <1,1,1,1>, <3,5,0,2>
  3697707658U,	// <1,1,3,6>: Cost 4 vext2 <1,1,1,1>, <3,6,2,7>
  2592707660U,	// <1,1,3,7>: Cost 3 vext1 <7,1,1,3>, <7,1,1,3>
  1947033702U,	// <1,1,3,u>: Cost 2 vtrnl LHS, LHS
  2623966098U,	// <1,1,4,0>: Cost 3 vext2 <1,1,1,1>, <4,0,5,1>
  2221335351U,	// <1,1,4,1>: Cost 3 vrev <1,1,1,4>
  3697708086U,	// <1,1,4,2>: Cost 4 vext2 <1,1,1,1>, <4,2,5,3>
  3630622870U,	// <1,1,4,3>: Cost 4 vext1 <1,1,1,4>, <3,0,1,2>
  2556882230U,	// <1,1,4,4>: Cost 3 vext1 <1,1,1,4>, RHS
  1550224694U,	// <1,1,4,5>: Cost 2 vext2 <1,1,1,1>, RHS
  2623966540U,	// <1,1,4,6>: Cost 3 vext2 <1,1,1,1>, <4,6,0,2>
  3666457677U,	// <1,1,4,7>: Cost 4 vext1 <7,1,1,4>, <7,1,1,4>
  1550224937U,	// <1,1,4,u>: Cost 2 vext2 <1,1,1,1>, RHS
  2647191111U,	// <1,1,5,0>: Cost 3 vext2 <5,0,1,1>, <5,0,1,1>
  2623966928U,	// <1,1,5,1>: Cost 3 vext2 <1,1,1,1>, <5,1,7,3>
  3697708779U,	// <1,1,5,2>: Cost 4 vext2 <1,1,1,1>, <5,2,1,3>
  2724840592U,	// <1,1,5,3>: Cost 3 vext3 <6,7,0,1>, <1,5,3,7>
  2221564755U,	// <1,1,5,4>: Cost 3 vrev <1,1,4,5>
  2650509276U,	// <1,1,5,5>: Cost 3 vext2 <5,5,1,1>, <5,5,1,1>
  2665107554U,	// <1,1,5,6>: Cost 3 vext2 <u,0,1,1>, <5,6,7,0>
  3697709174U,	// <1,1,5,7>: Cost 4 vext2 <1,1,1,1>, <5,7,0,2>
  2623967495U,	// <1,1,5,u>: Cost 3 vext2 <1,1,1,1>, <5,u,7,3>
  3697709353U,	// <1,1,6,0>: Cost 4 vext2 <1,1,1,1>, <6,0,2,1>
  2684437711U,	// <1,1,6,1>: Cost 3 vext3 <0,0,1,1>, <1,6,1,7>
  2623967738U,	// <1,1,6,2>: Cost 3 vext2 <1,1,1,1>, <6,2,7,3>
  3697709642U,	// <1,1,6,3>: Cost 4 vext2 <1,1,1,1>, <6,3,7,2>
  3630640438U,	// <1,1,6,4>: Cost 4 vext1 <1,1,1,6>, RHS
  3724251883U,	// <1,1,6,5>: Cost 4 vext2 <5,5,1,1>, <6,5,7,1>
  2665108280U,	// <1,1,6,6>: Cost 3 vext2 <u,0,1,1>, <6,6,6,6>
  2724840702U,	// <1,1,6,7>: Cost 3 vext3 <6,7,0,1>, <1,6,7,0>
  2623968224U,	// <1,1,6,u>: Cost 3 vext2 <1,1,1,1>, <6,u,7,3>
  2665108474U,	// <1,1,7,0>: Cost 3 vext2 <u,0,1,1>, <7,0,1,2>
  2659800138U,	// <1,1,7,1>: Cost 3 vext2 <7,1,1,1>, <7,1,1,1>
  3697710255U,	// <1,1,7,2>: Cost 4 vext2 <1,1,1,1>, <7,2,3,3>
  3798582571U,	// <1,1,7,3>: Cost 4 vext3 <6,7,0,1>, <1,7,3,0>
  2665108838U,	// <1,1,7,4>: Cost 3 vext2 <u,0,1,1>, <7,4,5,6>
  3720934789U,	// <1,1,7,5>: Cost 4 vext2 <5,0,1,1>, <7,5,0,1>
  3803891014U,	// <1,1,7,6>: Cost 4 vext3 <7,6,0,1>, <1,7,6,0>
  2665109100U,	// <1,1,7,7>: Cost 3 vext2 <u,0,1,1>, <7,7,7,7>
  2665109112U,	// <1,1,7,u>: Cost 3 vext2 <u,0,1,1>, <7,u,0,1>
  1591367378U,	// <1,1,u,0>: Cost 2 vext2 <u,0,1,1>, <u,0,1,1>
  202162278U,	// <1,1,u,1>: Cost 1 vdup1 LHS
  2623969132U,	// <1,1,u,2>: Cost 3 vext2 <1,1,1,1>, <u,2,0,2>
  1946992747U,	// <1,1,u,3>: Cost 2 vtrnl LHS, LHS
  1483115830U,	// <1,1,u,4>: Cost 2 vext1 <1,1,1,1>, RHS
  1550227610U,	// <1,1,u,5>: Cost 2 vext2 <1,1,1,1>, RHS
  2623969456U,	// <1,1,u,6>: Cost 3 vext2 <1,1,1,1>, <u,6,0,2>
  2592748625U,	// <1,1,u,7>: Cost 3 vext1 <7,1,1,u>, <7,1,1,u>
  202162278U,	// <1,1,u,u>: Cost 1 vdup1 LHS
  2698298804U,	// <1,2,0,0>: Cost 3 vext3 <2,3,0,1>, <2,0,0,2>
  1561509990U,	// <1,2,0,1>: Cost 2 vext2 <3,0,1,2>, LHS
  2629279908U,	// <1,2,0,2>: Cost 3 vext2 <2,0,1,2>, <0,2,0,2>
  2696529358U,	// <1,2,0,3>: Cost 3 vext3 <2,0,3,1>, <2,0,3,1>
  2659139922U,	// <1,2,0,4>: Cost 3 vext2 <7,0,1,2>, <0,4,1,5>
  3775727073U,	// <1,2,0,5>: Cost 4 vext3 <2,u,5,1>, <2,0,5,2>
  2621317617U,	// <1,2,0,6>: Cost 3 vext2 <0,6,1,2>, <0,6,1,2>
  2659140170U,	// <1,2,0,7>: Cost 3 vext2 <7,0,1,2>, <0,7,2,1>
  1561510557U,	// <1,2,0,u>: Cost 2 vext2 <3,0,1,2>, LHS
  2623308516U,	// <1,2,1,0>: Cost 3 vext2 <1,0,1,2>, <1,0,1,2>
  2623308596U,	// <1,2,1,1>: Cost 3 vext2 <1,0,1,2>, <1,1,1,1>
  2631271318U,	// <1,2,1,2>: Cost 3 vext2 <2,3,1,2>, <1,2,3,0>
  2886517556U,	// <1,2,1,3>: Cost 3 vzipl LHS, <1,1,1,1>
  3764225580U,	// <1,2,1,4>: Cost 4 vext3 <1,0,2,1>, <2,1,4,5>
  2659140752U,	// <1,2,1,5>: Cost 3 vext2 <7,0,1,2>, <1,5,3,7>
  3794085433U,	// <1,2,1,6>: Cost 4 vext3 <6,0,2,1>, <2,1,6,0>
  3732882731U,	// <1,2,1,7>: Cost 4 vext2 <7,0,1,2>, <1,7,3,0>
  2886557706U,	// <1,2,1,u>: Cost 3 vzipl LHS, <0,0,1,1>
  2629281213U,	// <1,2,2,0>: Cost 3 vext2 <2,0,1,2>, <2,0,1,2>
  3630678846U,	// <1,2,2,1>: Cost 4 vext1 <1,1,2,2>, <1,1,2,2>
  2691073640U,	// <1,2,2,2>: Cost 3 vext3 <1,1,1,1>, <2,2,2,2>
  2886518934U,	// <1,2,2,3>: Cost 3 vzipl LHS, <3,0,1,2>
  3630681398U,	// <1,2,2,4>: Cost 4 vext1 <1,1,2,2>, RHS
  3771745922U,	// <1,2,2,5>: Cost 4 vext3 <2,2,5,1>, <2,2,5,1>
  2659141562U,	// <1,2,2,6>: Cost 3 vext2 <7,0,1,2>, <2,6,3,7>
  2659141610U,	// <1,2,2,7>: Cost 3 vext2 <7,0,1,2>, <2,7,0,1>
  2886559894U,	// <1,2,2,u>: Cost 3 vzipl LHS, <3,0,1,2>
  403488870U,	// <1,2,3,0>: Cost 1 vext1 LHS, LHS
  1477231350U,	// <1,2,3,1>: Cost 2 vext1 LHS, <1,0,3,2>
  1477232232U,	// <1,2,3,2>: Cost 2 vext1 LHS, <2,2,2,2>
  1477233052U,	// <1,2,3,3>: Cost 2 vext1 LHS, <3,3,3,3>
  403492150U,	// <1,2,3,4>: Cost 1 vext1 LHS, RHS
  1525010128U,	// <1,2,3,5>: Cost 2 vext1 LHS, <5,1,7,3>
  1525010938U,	// <1,2,3,6>: Cost 2 vext1 LHS, <6,2,7,3>
  1525011450U,	// <1,2,3,7>: Cost 2 vext1 LHS, <7,0,1,2>
  403494702U,	// <1,2,3,u>: Cost 1 vext1 LHS, LHS
  2635254674U,	// <1,2,4,0>: Cost 3 vext2 <3,0,1,2>, <4,0,5,1>
  3702361059U,	// <1,2,4,1>: Cost 4 vext2 <1,u,1,2>, <4,1,5,1>
  3772630796U,	// <1,2,4,2>: Cost 4 vext3 <2,3,u,1>, <2,4,2,4>
  2598759198U,	// <1,2,4,3>: Cost 3 vext1 <u,1,2,4>, <3,u,1,2>
  2659142864U,	// <1,2,4,4>: Cost 3 vext2 <7,0,1,2>, <4,4,4,4>
  1561513270U,	// <1,2,4,5>: Cost 2 vext2 <3,0,1,2>, RHS
  2635255116U,	// <1,2,4,6>: Cost 3 vext2 <3,0,1,2>, <4,6,0,2>
  3732884945U,	// <1,2,4,7>: Cost 4 vext2 <7,0,1,2>, <4,7,6,0>
  1561513513U,	// <1,2,4,u>: Cost 2 vext2 <3,0,1,2>, RHS
  2647199304U,	// <1,2,5,0>: Cost 3 vext2 <5,0,1,2>, <5,0,1,2>
  2635255504U,	// <1,2,5,1>: Cost 3 vext2 <3,0,1,2>, <5,1,7,3>
  3703025440U,	// <1,2,5,2>: Cost 4 vext2 <2,0,1,2>, <5,2,7,2>
  2934292818U,	// <1,2,5,3>: Cost 3 vzipl LHS, <0,4,1,5>
  2659143622U,	// <1,2,5,4>: Cost 3 vext2 <7,0,1,2>, <5,4,7,6>
  2659143684U,	// <1,2,5,5>: Cost 3 vext2 <7,0,1,2>, <5,5,5,5>
  2659143778U,	// <1,2,5,6>: Cost 3 vext2 <7,0,1,2>, <5,6,7,0>
  3708997750U,	// <1,2,5,7>: Cost 4 vext2 <3,0,1,2>, <5,7,0,2>
  2635256071U,	// <1,2,5,u>: Cost 3 vext2 <3,0,1,2>, <5,u,7,3>
  2653172001U,	// <1,2,6,0>: Cost 3 vext2 <6,0,1,2>, <6,0,1,2>
  2635256232U,	// <1,2,6,1>: Cost 3 vext2 <3,0,1,2>, <6,1,7,2>
  2635256314U,	// <1,2,6,2>: Cost 3 vext2 <3,0,1,2>, <6,2,7,3>
  2724841402U,	// <1,2,6,3>: Cost 3 vext3 <6,7,0,1>, <2,6,3,7>
  3708998302U,	// <1,2,6,4>: Cost 4 vext2 <3,0,1,2>, <6,4,7,5>
  3714306800U,	// <1,2,6,5>: Cost 4 vext2 <3,u,1,2>, <6,5,7,6>
  2659144504U,	// <1,2,6,6>: Cost 3 vext2 <7,0,1,2>, <6,6,6,6>
  2657817432U,	// <1,2,6,7>: Cost 3 vext2 <6,7,1,2>, <6,7,1,2>
  2635256800U,	// <1,2,6,u>: Cost 3 vext2 <3,0,1,2>, <6,u,7,3>
  1585402874U,	// <1,2,7,0>: Cost 2 vext2 <7,0,1,2>, <7,0,1,2>
  2659144810U,	// <1,2,7,1>: Cost 3 vext2 <7,0,1,2>, <7,1,4,6>
  3708998831U,	// <1,2,7,2>: Cost 4 vext2 <3,0,1,2>, <7,2,3,3>
  2635257059U,	// <1,2,7,3>: Cost 3 vext2 <3,0,1,2>, <7,3,0,1>
  2659145062U,	// <1,2,7,4>: Cost 3 vext2 <7,0,1,2>, <7,4,5,6>
  3726251469U,	// <1,2,7,5>: Cost 4 vext2 <5,u,1,2>, <7,5,u,1>
  3731559912U,	// <1,2,7,6>: Cost 4 vext2 <6,7,1,2>, <7,6,2,1>
  2659145255U,	// <1,2,7,7>: Cost 3 vext2 <7,0,1,2>, <7,7,0,1>
  1590711938U,	// <1,2,7,u>: Cost 2 vext2 <7,u,1,2>, <7,u,1,2>
  403529835U,	// <1,2,u,0>: Cost 1 vext1 LHS, LHS
  1477272310U,	// <1,2,u,1>: Cost 2 vext1 LHS, <1,0,3,2>
  1477273192U,	// <1,2,u,2>: Cost 2 vext1 LHS, <2,2,2,2>
  1477273750U,	// <1,2,u,3>: Cost 2 vext1 LHS, <3,0,1,2>
  403533110U,	// <1,2,u,4>: Cost 1 vext1 LHS, RHS
  1477275344U,	// <1,2,u,5>: Cost 2 vext1 LHS, <5,1,7,3>
  1477276154U,	// <1,2,u,6>: Cost 2 vext1 LHS, <6,2,7,3>
  1525052410U,	// <1,2,u,7>: Cost 2 vext1 LHS, <7,0,1,2>
  403535662U,	// <1,2,u,u>: Cost 1 vext1 LHS, LHS
  2628624394U,	// <1,3,0,0>: Cost 3 vext2 <1,u,1,3>, <0,0,1,1>
  2618671206U,	// <1,3,0,1>: Cost 3 vext2 <0,2,1,3>, LHS
  2819408630U,	// <1,3,0,2>: Cost 3 vuzpr LHS, <1,0,3,2>
  2702502055U,	// <1,3,0,3>: Cost 3 vext3 <3,0,3,1>, <3,0,3,1>
  2702575792U,	// <1,3,0,4>: Cost 3 vext3 <3,0,4,1>, <3,0,4,1>
  3764816058U,	// <1,3,0,5>: Cost 4 vext3 <1,1,1,1>, <3,0,5,2>
  3776465090U,	// <1,3,0,6>: Cost 4 vext3 <3,0,6,1>, <3,0,6,1>
  3666572379U,	// <1,3,0,7>: Cost 4 vext1 <7,1,3,0>, <7,1,3,0>
  2819850998U,	// <1,3,0,u>: Cost 3 vuzpr LHS, <1,0,3,2>
  2625307382U,	// <1,3,1,0>: Cost 3 vext2 <1,3,1,3>, <1,0,3,2>
  2691074278U,	// <1,3,1,1>: Cost 3 vext3 <1,1,1,1>, <3,1,1,1>
  2624643975U,	// <1,3,1,2>: Cost 3 vext2 <1,2,1,3>, <1,2,1,3>
  2824782582U,	// <1,3,1,3>: Cost 3 vuzpr <1,0,3,2>, <1,0,3,2>
  2562977078U,	// <1,3,1,4>: Cost 3 vext1 <2,1,3,1>, RHS
  3764816140U,	// <1,3,1,5>: Cost 4 vext3 <1,1,1,1>, <3,1,5,3>
  3636720039U,	// <1,3,1,6>: Cost 4 vext1 <2,1,3,1>, <6,1,7,1>
  3666580572U,	// <1,3,1,7>: Cost 4 vext1 <7,1,3,1>, <7,1,3,1>
  2628625773U,	// <1,3,1,u>: Cost 3 vext2 <1,u,1,3>, <1,u,1,3>
  2703608110U,	// <1,3,2,0>: Cost 3 vext3 <3,2,0,1>, <3,2,0,1>
  2698889534U,	// <1,3,2,1>: Cost 3 vext3 <2,3,u,1>, <3,2,1,u>
  3692414568U,	// <1,3,2,2>: Cost 4 vext2 <0,2,1,3>, <2,2,2,2>
  2618672806U,	// <1,3,2,3>: Cost 3 vext2 <0,2,1,3>, <2,3,0,1>
  3764816212U,	// <1,3,2,4>: Cost 4 vext3 <1,1,1,1>, <3,2,4,3>
  3772631390U,	// <1,3,2,5>: Cost 4 vext3 <2,3,u,1>, <3,2,5,4>
  3718956986U,	// <1,3,2,6>: Cost 4 vext2 <4,6,1,3>, <2,6,3,7>
  3666588765U,	// <1,3,2,7>: Cost 4 vext1 <7,1,3,2>, <7,1,3,2>
  2701617525U,	// <1,3,2,u>: Cost 3 vext3 <2,u,0,1>, <3,2,u,0>
  1483276390U,	// <1,3,3,0>: Cost 2 vext1 <1,1,3,3>, LHS
  1483277128U,	// <1,3,3,1>: Cost 2 vext1 <1,1,3,3>, <1,1,3,3>
  2557019752U,	// <1,3,3,2>: Cost 3 vext1 <1,1,3,3>, <2,2,2,2>
  2691074460U,	// <1,3,3,3>: Cost 3 vext3 <1,1,1,1>, <3,3,3,3>
  1483279670U,	// <1,3,3,4>: Cost 2 vext1 <1,1,3,3>, RHS
  2557021904U,	// <1,3,3,5>: Cost 3 vext1 <1,1,3,3>, <5,1,7,3>
  2557022714U,	// <1,3,3,6>: Cost 3 vext1 <1,1,3,3>, <6,2,7,3>
  2598827002U,	// <1,3,3,7>: Cost 3 vext1 <u,1,3,3>, <7,0,1,2>
  1483282222U,	// <1,3,3,u>: Cost 2 vext1 <1,1,3,3>, LHS
  2704935376U,	// <1,3,4,0>: Cost 3 vext3 <3,4,0,1>, <3,4,0,1>
  3697724387U,	// <1,3,4,1>: Cost 4 vext2 <1,1,1,3>, <4,1,5,1>
  3636741666U,	// <1,3,4,2>: Cost 4 vext1 <2,1,3,4>, <2,1,3,4>
  3630770690U,	// <1,3,4,3>: Cost 4 vext1 <1,1,3,4>, <3,4,5,6>
  3630771510U,	// <1,3,4,4>: Cost 4 vext1 <1,1,3,4>, RHS
  2618674486U,	// <1,3,4,5>: Cost 3 vext2 <0,2,1,3>, RHS
  2846278390U,	// <1,3,4,6>: Cost 3 vuzpr RHS, <1,0,3,2>
  3666605151U,	// <1,3,4,7>: Cost 4 vext1 <7,1,3,4>, <7,1,3,4>
  2618674729U,	// <1,3,4,u>: Cost 3 vext2 <0,2,1,3>, RHS
  3764816418U,	// <1,3,5,0>: Cost 4 vext3 <1,1,1,1>, <3,5,0,2>
  3692416720U,	// <1,3,5,1>: Cost 4 vext2 <0,2,1,3>, <5,1,7,3>
  2648534763U,	// <1,3,5,2>: Cost 3 vext2 <5,2,1,3>, <5,2,1,3>
  3782363712U,	// <1,3,5,3>: Cost 4 vext3 <4,0,5,1>, <3,5,3,5>
  3307251973U,	// <1,3,5,4>: Cost 4 vrev <3,1,4,5>
  3779709518U,	// <1,3,5,5>: Cost 4 vext3 <3,5,5,1>, <3,5,5,1>
  3718959202U,	// <1,3,5,6>: Cost 4 vext2 <4,6,1,3>, <5,6,7,0>
  3923378934U,	// <1,3,5,7>: Cost 4 vuzpr <5,1,7,3>, <1,0,3,2>
  2652516561U,	// <1,3,5,u>: Cost 3 vext2 <5,u,1,3>, <5,u,1,3>
  3780004466U,	// <1,3,6,0>: Cost 4 vext3 <3,6,0,1>, <3,6,0,1>
  3697725863U,	// <1,3,6,1>: Cost 4 vext2 <1,1,1,3>, <6,1,7,1>
  3692417530U,	// <1,3,6,2>: Cost 4 vext2 <0,2,1,3>, <6,2,7,3>
  3699053130U,	// <1,3,6,3>: Cost 4 vext2 <1,3,1,3>, <6,3,7,2>
  3798583964U,	// <1,3,6,4>: Cost 4 vext3 <6,7,0,1>, <3,6,4,7>
  3722277611U,	// <1,3,6,5>: Cost 4 vext2 <5,2,1,3>, <6,5,7,1>
  3718959928U,	// <1,3,6,6>: Cost 4 vext2 <4,6,1,3>, <6,6,6,6>
  2724842160U,	// <1,3,6,7>: Cost 3 vext3 <6,7,0,1>, <3,6,7,0>
  2725505721U,	// <1,3,6,u>: Cost 3 vext3 <6,u,0,1>, <3,6,u,0>
  2706926275U,	// <1,3,7,0>: Cost 3 vext3 <3,7,0,1>, <3,7,0,1>
  2659816524U,	// <1,3,7,1>: Cost 3 vext2 <7,1,1,3>, <7,1,1,3>
  3934954390U,	// <1,3,7,2>: Cost 4 vuzpr <7,1,2,3>, <1,2,3,0>
  3666627120U,	// <1,3,7,3>: Cost 4 vext1 <7,1,3,7>, <3,5,1,7>
  3718960486U,	// <1,3,7,4>: Cost 4 vext2 <4,6,1,3>, <7,4,5,6>
  3722278295U,	// <1,3,7,5>: Cost 4 vext2 <5,2,1,3>, <7,5,2,1>
  3307415833U,	// <1,3,7,6>: Cost 4 vrev <3,1,6,7>
  3718960748U,	// <1,3,7,7>: Cost 4 vext2 <4,6,1,3>, <7,7,7,7>
  2664461955U,	// <1,3,7,u>: Cost 3 vext2 <7,u,1,3>, <7,u,1,3>
  1483317350U,	// <1,3,u,0>: Cost 2 vext1 <1,1,3,u>, LHS
  1483318093U,	// <1,3,u,1>: Cost 2 vext1 <1,1,3,u>, <1,1,3,u>
  2557060712U,	// <1,3,u,2>: Cost 3 vext1 <1,1,3,u>, <2,2,2,2>
  2557061270U,	// <1,3,u,3>: Cost 3 vext1 <1,1,3,u>, <3,0,1,2>
  1483320630U,	// <1,3,u,4>: Cost 2 vext1 <1,1,3,u>, RHS
  2618677402U,	// <1,3,u,5>: Cost 3 vext2 <0,2,1,3>, RHS
  2557063674U,	// <1,3,u,6>: Cost 3 vext1 <1,1,3,u>, <6,2,7,3>
  2598867962U,	// <1,3,u,7>: Cost 3 vext1 <u,1,3,u>, <7,0,1,2>
  1483323182U,	// <1,3,u,u>: Cost 2 vext1 <1,1,3,u>, LHS
  2708253541U,	// <1,4,0,0>: Cost 3 vext3 <4,0,0,1>, <4,0,0,1>
  2623987814U,	// <1,4,0,1>: Cost 3 vext2 <1,1,1,4>, LHS
  3697729700U,	// <1,4,0,2>: Cost 4 vext2 <1,1,1,4>, <0,2,0,2>
  3709010200U,	// <1,4,0,3>: Cost 4 vext2 <3,0,1,4>, <0,3,4,1>
  2580958098U,	// <1,4,0,4>: Cost 3 vext1 <5,1,4,0>, <4,0,5,1>
  1634880402U,	// <1,4,0,5>: Cost 2 vext3 <4,0,5,1>, <4,0,5,1>
  2691074972U,	// <1,4,0,6>: Cost 3 vext3 <1,1,1,1>, <4,0,6,2>
  3654702074U,	// <1,4,0,7>: Cost 4 vext1 <5,1,4,0>, <7,0,1,2>
  1635101613U,	// <1,4,0,u>: Cost 2 vext3 <4,0,u,1>, <4,0,u,1>
  3697730275U,	// <1,4,1,0>: Cost 4 vext2 <1,1,1,4>, <1,0,1,1>
  2623988535U,	// <1,4,1,1>: Cost 3 vext2 <1,1,1,4>, <1,1,1,4>
  3697730439U,	// <1,4,1,2>: Cost 4 vext2 <1,1,1,4>, <1,2,1,3>
  3776318416U,	// <1,4,1,3>: Cost 4 vext3 <3,0,4,1>, <4,1,3,0>
  3697730590U,	// <1,4,1,4>: Cost 4 vext2 <1,1,1,4>, <1,4,0,1>
  2709285859U,	// <1,4,1,5>: Cost 3 vext3 <4,1,5,1>, <4,1,5,1>
  2709359596U,	// <1,4,1,6>: Cost 3 vext3 <4,1,6,1>, <4,1,6,1>
  3800206324U,	// <1,4,1,7>: Cost 4 vext3 <7,0,4,1>, <4,1,7,0>
  2709507070U,	// <1,4,1,u>: Cost 3 vext3 <4,1,u,1>, <4,1,u,1>
  3709011380U,	// <1,4,2,0>: Cost 4 vext2 <3,0,1,4>, <2,0,0,2>
  3697731103U,	// <1,4,2,1>: Cost 4 vext2 <1,1,1,4>, <2,1,3,1>
  3697731176U,	// <1,4,2,2>: Cost 4 vext2 <1,1,1,4>, <2,2,2,2>
  2635269798U,	// <1,4,2,3>: Cost 3 vext2 <3,0,1,4>, <2,3,0,1>
  3642772790U,	// <1,4,2,4>: Cost 4 vext1 <3,1,4,2>, RHS
  2980496278U,	// <1,4,2,5>: Cost 3 vzipr RHS, <1,2,3,0>
  3771968574U,	// <1,4,2,6>: Cost 4 vext3 <2,2,u,1>, <4,2,6,2>
  3666662502U,	// <1,4,2,7>: Cost 4 vext1 <7,1,4,2>, <7,1,4,2>
  2982486934U,	// <1,4,2,u>: Cost 3 vzipr RHS, <1,2,3,0>
  2563063910U,	// <1,4,3,0>: Cost 3 vext1 <2,1,4,3>, LHS
  2563064730U,	// <1,4,3,1>: Cost 3 vext1 <2,1,4,3>, <1,2,3,4>
  2563065386U,	// <1,4,3,2>: Cost 3 vext1 <2,1,4,3>, <2,1,4,3>
  3697731996U,	// <1,4,3,3>: Cost 4 vext2 <1,1,1,4>, <3,3,3,3>
  2563067190U,	// <1,4,3,4>: Cost 3 vext1 <2,1,4,3>, RHS
  3070443622U,	// <1,4,3,5>: Cost 3 vtrnl <u,4,1,5>, LHS
  3040886886U,	// <1,4,3,6>: Cost 3 vtrnl <3,4,5,6>, LHS
  3666670695U,	// <1,4,3,7>: Cost 4 vext1 <7,1,4,3>, <7,1,4,3>
  2563069742U,	// <1,4,3,u>: Cost 3 vext1 <2,1,4,3>, LHS
  2620672914U,	// <1,4,4,0>: Cost 3 vext2 <0,5,1,4>, <4,0,5,1>
  3697732579U,	// <1,4,4,1>: Cost 4 vext2 <1,1,1,4>, <4,1,5,1>
  3709013052U,	// <1,4,4,2>: Cost 4 vext2 <3,0,1,4>, <4,2,6,0>
  3313142740U,	// <1,4,4,3>: Cost 4 vrev <4,1,3,4>
  2724842704U,	// <1,4,4,4>: Cost 3 vext3 <6,7,0,1>, <4,4,4,4>
  2623991094U,	// <1,4,4,5>: Cost 3 vext2 <1,1,1,4>, RHS
  2724842724U,	// <1,4,4,6>: Cost 3 vext3 <6,7,0,1>, <4,4,6,6>
  3786640622U,	// <1,4,4,7>: Cost 5 vext3 <4,7,0,1>, <4,4,7,7>
  2623991337U,	// <1,4,4,u>: Cost 3 vext2 <1,1,1,4>, RHS
  2557108326U,	// <1,4,5,0>: Cost 3 vext1 <1,1,4,5>, LHS
  2557109075U,	// <1,4,5,1>: Cost 3 vext1 <1,1,4,5>, <1,1,4,5>
  2598913774U,	// <1,4,5,2>: Cost 3 vext1 <u,1,4,5>, <2,3,u,1>
  3630852246U,	// <1,4,5,3>: Cost 4 vext1 <1,1,4,5>, <3,0,1,2>
  2557111606U,	// <1,4,5,4>: Cost 3 vext1 <1,1,4,5>, RHS
  2980504720U,	// <1,4,5,5>: Cost 3 vzipr RHS, <1,5,3,7>
  1617333558U,	// <1,4,5,6>: Cost 2 vext3 <1,1,1,1>, RHS
  3654743034U,	// <1,4,5,7>: Cost 4 vext1 <5,1,4,5>, <7,0,1,2>
  1617333576U,	// <1,4,5,u>: Cost 2 vext3 <1,1,1,1>, RHS
  2691075404U,	// <1,4,6,0>: Cost 3 vext3 <1,1,1,1>, <4,6,0,2>
  2712309076U,	// <1,4,6,1>: Cost 3 vext3 <4,6,1,1>, <4,6,1,1>
  2698300764U,	// <1,4,6,2>: Cost 3 vext3 <2,3,0,1>, <4,6,2,0>
  2712456550U,	// <1,4,6,3>: Cost 3 vext3 <4,6,3,1>, <4,6,3,1>
  2712825204U,	// <1,4,6,4>: Cost 3 vext3 <4,6,u,1>, <4,6,4,6>
  4054238415U,	// <1,4,6,5>: Cost 4 vzipr RHS, <1,6,1,7>
  3660722577U,	// <1,4,6,6>: Cost 4 vext1 <6,1,4,6>, <6,1,4,6>
  2659160910U,	// <1,4,6,7>: Cost 3 vext2 <7,0,1,4>, <6,7,0,1>
  2712825235U,	// <1,4,6,u>: Cost 3 vext3 <4,6,u,1>, <4,6,u,1>
  2659161084U,	// <1,4,7,0>: Cost 3 vext2 <7,0,1,4>, <7,0,1,4>
  3733566541U,	// <1,4,7,1>: Cost 4 vext2 <7,1,1,4>, <7,1,1,4>
  3734230174U,	// <1,4,7,2>: Cost 4 vext2 <7,2,1,4>, <7,2,1,4>
  3734893807U,	// <1,4,7,3>: Cost 4 vext2 <7,3,1,4>, <7,3,1,4>
  3732903270U,	// <1,4,7,4>: Cost 4 vext2 <7,0,1,4>, <7,4,5,6>
  3736221073U,	// <1,4,7,5>: Cost 4 vext2 <7,5,1,4>, <7,5,1,4>
  3798584785U,	// <1,4,7,6>: Cost 4 vext3 <6,7,0,1>, <4,7,6,0>
  3732903532U,	// <1,4,7,7>: Cost 4 vext2 <7,0,1,4>, <7,7,7,7>
  2664470148U,	// <1,4,7,u>: Cost 3 vext2 <7,u,1,4>, <7,u,1,4>
  2691075566U,	// <1,4,u,0>: Cost 3 vext3 <1,1,1,1>, <4,u,0,2>
  2623993646U,	// <1,4,u,1>: Cost 3 vext2 <1,1,1,4>, LHS
  2563106351U,	// <1,4,u,2>: Cost 3 vext1 <2,1,4,u>, <2,1,4,u>
  2713783816U,	// <1,4,u,3>: Cost 3 vext3 <4,u,3,1>, <4,u,3,1>
  2557136182U,	// <1,4,u,4>: Cost 3 vext1 <1,1,4,u>, RHS
  1634880402U,	// <1,4,u,5>: Cost 2 vext3 <4,0,5,1>, <4,0,5,1>
  1617333801U,	// <1,4,u,6>: Cost 2 vext3 <1,1,1,1>, RHS
  2659160910U,	// <1,4,u,7>: Cost 3 vext2 <7,0,1,4>, <6,7,0,1>
  1617333819U,	// <1,4,u,u>: Cost 2 vext3 <1,1,1,1>, RHS
  2575056998U,	// <1,5,0,0>: Cost 3 vext1 <4,1,5,0>, LHS
  1594048614U,	// <1,5,0,1>: Cost 2 vext2 <u,4,1,5>, LHS
  2667790500U,	// <1,5,0,2>: Cost 3 vext2 <u,4,1,5>, <0,2,0,2>
  3648800918U,	// <1,5,0,3>: Cost 4 vext1 <4,1,5,0>, <3,0,1,2>
  1546273106U,	// <1,5,0,4>: Cost 2 vext2 <0,4,1,5>, <0,4,1,5>
  2714594923U,	// <1,5,0,5>: Cost 3 vext3 <5,0,5,1>, <5,0,5,1>
  2714668660U,	// <1,5,0,6>: Cost 3 vext3 <5,0,6,1>, <5,0,6,1>
  2714742397U,	// <1,5,0,7>: Cost 3 vext3 <5,0,7,1>, <5,0,7,1>
  1594049181U,	// <1,5,0,u>: Cost 2 vext2 <u,4,1,5>, LHS
  2708622991U,	// <1,5,1,0>: Cost 3 vext3 <4,0,5,1>, <5,1,0,1>
  2575065908U,	// <1,5,1,1>: Cost 3 vext1 <4,1,5,1>, <1,1,1,1>
  2667791254U,	// <1,5,1,2>: Cost 3 vext2 <u,4,1,5>, <1,2,3,0>
  3642837258U,	// <1,5,1,3>: Cost 4 vext1 <3,1,5,1>, <3,1,5,1>
  2708623026U,	// <1,5,1,4>: Cost 3 vext3 <4,0,5,1>, <5,1,4,0>
  2657838224U,	// <1,5,1,5>: Cost 3 vext2 <6,7,1,5>, <1,5,3,7>
  2620015859U,	// <1,5,1,6>: Cost 3 vext2 <0,4,1,5>, <1,6,5,7>
  2691075792U,	// <1,5,1,7>: Cost 3 vext3 <1,1,1,1>, <5,1,7,3>
  2691075801U,	// <1,5,1,u>: Cost 3 vext3 <1,1,1,1>, <5,1,u,3>
  2575073382U,	// <1,5,2,0>: Cost 3 vext1 <4,1,5,2>, LHS
  2708623083U,	// <1,5,2,1>: Cost 3 vext3 <4,0,5,1>, <5,2,1,3>
  2667791976U,	// <1,5,2,2>: Cost 3 vext2 <u,4,1,5>, <2,2,2,2>
  2667792038U,	// <1,5,2,3>: Cost 3 vext2 <u,4,1,5>, <2,3,0,1>
  2575076324U,	// <1,5,2,4>: Cost 3 vext1 <4,1,5,2>, <4,1,5,2>
  3648818896U,	// <1,5,2,5>: Cost 4 vext1 <4,1,5,2>, <5,1,7,3>
  2667792314U,	// <1,5,2,6>: Cost 3 vext2 <u,4,1,5>, <2,6,3,7>
  3760025376U,	// <1,5,2,7>: Cost 4 vext3 <0,2,u,1>, <5,2,7,2>
  2575079214U,	// <1,5,2,u>: Cost 3 vext1 <4,1,5,2>, LHS
  2569109606U,	// <1,5,3,0>: Cost 3 vext1 <3,1,5,3>, LHS
  2592998544U,	// <1,5,3,1>: Cost 3 vext1 <7,1,5,3>, <1,5,3,7>
  2569111246U,	// <1,5,3,2>: Cost 3 vext1 <3,1,5,3>, <2,3,4,5>
  2569111820U,	// <1,5,3,3>: Cost 3 vext1 <3,1,5,3>, <3,1,5,3>
  2569112886U,	// <1,5,3,4>: Cost 3 vext1 <3,1,5,3>, RHS
  3053486182U,	// <1,5,3,5>: Cost 3 vtrnl <5,5,5,5>, LHS
  3642855930U,	// <1,5,3,6>: Cost 4 vext1 <3,1,5,3>, <6,2,7,3>
  1973862502U,	// <1,5,3,7>: Cost 2 vtrnl RHS, LHS
  1973870694U,	// <1,5,3,u>: Cost 2 vtrnl RHS, LHS
  2667793298U,	// <1,5,4,0>: Cost 3 vext2 <u,4,1,5>, <4,0,5,1>
  2667793378U,	// <1,5,4,1>: Cost 3 vext2 <u,4,1,5>, <4,1,5,0>
  3741535277U,	// <1,5,4,2>: Cost 4 vext2 <u,4,1,5>, <4,2,4,3>
  3319115437U,	// <1,5,4,3>: Cost 4 vrev <5,1,3,4>
  2667793616U,	// <1,5,4,4>: Cost 3 vext2 <u,4,1,5>, <4,4,4,4>
  1594051894U,	// <1,5,4,5>: Cost 2 vext2 <u,4,1,5>, RHS
  2667793740U,	// <1,5,4,6>: Cost 3 vext2 <u,4,1,5>, <4,6,0,2>
  2724843462U,	// <1,5,4,7>: Cost 3 vext3 <6,7,0,1>, <5,4,7,6>
  1594052137U,	// <1,5,4,u>: Cost 2 vext2 <u,4,1,5>, RHS
  2717544403U,	// <1,5,5,0>: Cost 3 vext3 <5,5,0,1>, <5,5,0,1>
  2649878224U,	// <1,5,5,1>: Cost 3 vext2 <5,4,1,5>, <5,1,7,3>
  3741535979U,	// <1,5,5,2>: Cost 4 vext2 <u,4,1,5>, <5,2,1,3>
  3722956606U,	// <1,5,5,3>: Cost 4 vext2 <5,3,1,5>, <5,3,1,5>
  2245455543U,	// <1,5,5,4>: Cost 3 vrev <5,1,4,5>
  2718134276U,	// <1,5,5,5>: Cost 3 vext3 <5,5,u,1>, <5,5,5,5>
  2667794530U,	// <1,5,5,6>: Cost 3 vext2 <u,4,1,5>, <5,6,7,0>
  2724843544U,	// <1,5,5,7>: Cost 3 vext3 <6,7,0,1>, <5,5,7,7>
  2245750491U,	// <1,5,5,u>: Cost 3 vrev <5,1,u,5>
  2718208036U,	// <1,5,6,0>: Cost 3 vext3 <5,6,0,1>, <5,6,0,1>
  2708623411U,	// <1,5,6,1>: Cost 3 vext3 <4,0,5,1>, <5,6,1,7>
  2667794938U,	// <1,5,6,2>: Cost 3 vext2 <u,4,1,5>, <6,2,7,3>
  3782365250U,	// <1,5,6,3>: Cost 4 vext3 <4,0,5,1>, <5,6,3,4>
  3782365255U,	// <1,5,6,4>: Cost 4 vext3 <4,0,5,1>, <5,6,4,0>
  3791876183U,	// <1,5,6,5>: Cost 4 vext3 <5,5,u,1>, <5,6,5,7>
  2667795256U,	// <1,5,6,6>: Cost 3 vext2 <u,4,1,5>, <6,6,6,6>
  2718724195U,	// <1,5,6,7>: Cost 3 vext3 <5,6,7,1>, <5,6,7,1>
  2718797932U,	// <1,5,6,u>: Cost 3 vext3 <5,6,u,1>, <5,6,u,1>
  2667795450U,	// <1,5,7,0>: Cost 3 vext2 <u,4,1,5>, <7,0,1,2>
  4057597227U,	// <1,5,7,1>: Cost 4 vzipr <5,1,7,3>, <1,7,3,0>
  3741537445U,	// <1,5,7,2>: Cost 4 vext2 <u,4,1,5>, <7,2,2,2>
  3723621648U,	// <1,5,7,3>: Cost 4 vext2 <5,4,1,5>, <7,3,5,1>
  2667795814U,	// <1,5,7,4>: Cost 3 vext2 <u,4,1,5>, <7,4,5,6>
  3723621780U,	// <1,5,7,5>: Cost 4 vext2 <5,4,1,5>, <7,5,1,7>
  3736892899U,	// <1,5,7,6>: Cost 4 vext2 <7,6,1,5>, <7,6,1,5>
  2667796076U,	// <1,5,7,7>: Cost 3 vext2 <u,4,1,5>, <7,7,7,7>
  2667796098U,	// <1,5,7,u>: Cost 3 vext2 <u,4,1,5>, <7,u,1,2>
  2569150566U,	// <1,5,u,0>: Cost 3 vext1 <3,1,5,u>, LHS
  1594054446U,	// <1,5,u,1>: Cost 2 vext2 <u,4,1,5>, LHS
  2569152206U,	// <1,5,u,2>: Cost 3 vext1 <3,1,5,u>, <2,3,4,5>
  2569152785U,	// <1,5,u,3>: Cost 3 vext1 <3,1,5,u>, <3,1,5,u>
  1594054682U,	// <1,5,u,4>: Cost 2 vext2 <u,4,1,5>, <u,4,1,5>
  1594054810U,	// <1,5,u,5>: Cost 2 vext2 <u,4,1,5>, RHS
  2667796656U,	// <1,5,u,6>: Cost 3 vext2 <u,4,1,5>, <u,6,0,2>
  1973862507U,	// <1,5,u,7>: Cost 2 vtrnl RHS, LHS
  1973870699U,	// <1,5,u,u>: Cost 2 vtrnl RHS, LHS
  2620022794U,	// <1,6,0,0>: Cost 3 vext2 <0,4,1,6>, <0,0,1,1>
  2659172454U,	// <1,6,0,1>: Cost 3 vext2 <7,0,1,6>, LHS
  2720346409U,	// <1,6,0,2>: Cost 3 vext3 <6,0,2,1>, <6,0,2,1>
  3325055362U,	// <1,6,0,3>: Cost 4 vrev <6,1,3,0>
  2620023123U,	// <1,6,0,4>: Cost 3 vext2 <0,4,1,6>, <0,4,1,6>
  3798585674U,	// <1,6,0,5>: Cost 4 vext3 <6,7,0,1>, <6,0,5,7>
  2621350389U,	// <1,6,0,6>: Cost 3 vext2 <0,6,1,6>, <0,6,1,6>
  2720715094U,	// <1,6,0,7>: Cost 3 vext3 <6,0,7,1>, <6,0,7,1>
  2720788831U,	// <1,6,0,u>: Cost 3 vext3 <6,0,u,1>, <6,0,u,1>
  2575138918U,	// <1,6,1,0>: Cost 3 vext1 <4,1,6,1>, LHS
  2575139636U,	// <1,6,1,1>: Cost 3 vext1 <4,1,6,1>, <1,1,1,1>
  3764818300U,	// <1,6,1,2>: Cost 4 vext3 <1,1,1,1>, <6,1,2,3>
  3648882838U,	// <1,6,1,3>: Cost 4 vext1 <4,1,6,1>, <3,0,1,2>
  2575141868U,	// <1,6,1,4>: Cost 3 vext1 <4,1,6,1>, <4,1,6,1>
  3700401277U,	// <1,6,1,5>: Cost 4 vext2 <1,5,1,6>, <1,5,1,6>
  3648885159U,	// <1,6,1,6>: Cost 4 vext1 <4,1,6,1>, <6,1,7,1>
  2913386506U,	// <1,6,1,7>: Cost 3 vzipl RHS, <0,0,1,1>
  2575144750U,	// <1,6,1,u>: Cost 3 vext1 <4,1,6,1>, LHS
  2721526201U,	// <1,6,2,0>: Cost 3 vext3 <6,2,0,1>, <6,2,0,1>
  3630973794U,	// <1,6,2,1>: Cost 4 vext1 <1,1,6,2>, <1,1,6,2>
  3764818381U,	// <1,6,2,2>: Cost 4 vext3 <1,1,1,1>, <6,2,2,3>
  3709028006U,	// <1,6,2,3>: Cost 4 vext2 <3,0,1,6>, <2,3,0,1>
  3630976310U,	// <1,6,2,4>: Cost 4 vext1 <1,1,6,2>, RHS
  3654864582U,	// <1,6,2,5>: Cost 4 vext1 <5,1,6,2>, <5,1,6,2>
  3630977530U,	// <1,6,2,6>: Cost 4 vext1 <1,1,6,2>, <6,2,7,3>
  2691076602U,	// <1,6,2,7>: Cost 3 vext3 <1,1,1,1>, <6,2,7,3>
  2691076611U,	// <1,6,2,u>: Cost 3 vext3 <1,1,1,1>, <6,2,u,3>
  2575155302U,	// <1,6,3,0>: Cost 3 vext1 <4,1,6,3>, LHS
  3636954057U,	// <1,6,3,1>: Cost 4 vext1 <2,1,6,3>, <1,2,u,6>
  3047784550U,	// <1,6,3,2>: Cost 3 vtrnl <4,6,0,2>, LHS
  2575157762U,	// <1,6,3,3>: Cost 3 vext1 <4,1,6,3>, <3,4,5,6>
  2575158254U,	// <1,6,3,4>: Cost 3 vext1 <4,1,6,3>, <4,1,6,3>
  3648900816U,	// <1,6,3,5>: Cost 4 vext1 <4,1,6,3>, <5,1,7,3>
  3048112230U,	// <1,6,3,6>: Cost 3 vtrnl <4,6,4,6>, LHS
  3060285542U,	// <1,6,3,7>: Cost 3 vtrnl <6,6,7,7>, LHS
  2575161134U,	// <1,6,3,u>: Cost 3 vext1 <4,1,6,3>, LHS
  3782365791U,	// <1,6,4,0>: Cost 4 vext3 <4,0,5,1>, <6,4,0,5>
  3699739628U,	// <1,6,4,1>: Cost 4 vext2 <1,4,1,6>, <4,1,6,1>
  3794088561U,	// <1,6,4,2>: Cost 4 vext3 <6,0,2,1>, <6,4,2,5>
  3325088134U,	// <1,6,4,3>: Cost 4 vrev <6,1,3,4>
  3648908271U,	// <1,6,4,4>: Cost 4 vext1 <4,1,6,4>, <4,1,6,4>
  2659175734U,	// <1,6,4,5>: Cost 3 vext2 <7,0,1,6>, RHS
  3786568336U,	// <1,6,4,6>: Cost 4 vext3 <4,6,u,1>, <6,4,6,0>
  3772633758U,	// <1,6,4,7>: Cost 4 vext3 <2,3,u,1>, <6,4,7,5>
  2659175977U,	// <1,6,4,u>: Cost 3 vext2 <7,0,1,6>, RHS
  3648913510U,	// <1,6,5,0>: Cost 4 vext1 <4,1,6,5>, LHS
  3648914228U,	// <1,6,5,1>: Cost 4 vext1 <4,1,6,5>, <1,1,1,1>
  4064232592U,	// <1,6,5,2>: Cost 4 vzipr <6,2,7,3>, <1,5,3,7>
  3642943767U,	// <1,6,5,3>: Cost 4 vext1 <3,1,6,5>, <3,1,6,5>
  3648916464U,	// <1,6,5,4>: Cost 4 vext1 <4,1,6,5>, <4,1,6,5>
  3724292065U,	// <1,6,5,5>: Cost 4 vext2 <5,5,1,6>, <5,5,1,6>
  2668466274U,	// <1,6,5,6>: Cost 3 vext2 <u,5,1,6>, <5,6,7,0>
  2915377490U,	// <1,6,5,7>: Cost 3 vzipl RHS, <0,4,1,5>
  2913395026U,	// <1,6,5,u>: Cost 3 vzipl RHS, <0,4,1,5>
  2724180733U,	// <1,6,6,0>: Cost 3 vext3 <6,6,0,1>, <6,6,0,1>
  3742871965U,	// <1,6,6,1>: Cost 4 vext2 <u,6,1,6>, <6,1,6,0>
  3697750522U,	// <1,6,6,2>: Cost 4 vext2 <1,1,1,6>, <6,2,7,3>
  3782365979U,	// <1,6,6,3>: Cost 5 vext3 <4,0,5,1>, <6,6,3,4>
  3654896530U,	// <1,6,6,4>: Cost 4 vext1 <5,1,6,6>, <4,0,5,1>
  3654897354U,	// <1,6,6,5>: Cost 4 vext1 <5,1,6,6>, <5,1,6,6>
  2724770616U,	// <1,6,6,6>: Cost 3 vext3 <6,6,u,1>, <6,6,6,6>
  2724844354U,	// <1,6,6,7>: Cost 3 vext3 <6,7,0,1>, <6,6,7,7>
  2724770629U,	// <1,6,6,u>: Cost 3 vext3 <6,6,u,1>, <6,6,u,1>
  1651102542U,	// <1,6,7,0>: Cost 2 vext3 <6,7,0,1>, <6,7,0,1>
  2724918103U,	// <1,6,7,1>: Cost 3 vext3 <6,7,1,1>, <6,7,1,1>
  2698302306U,	// <1,6,7,2>: Cost 3 vext3 <2,3,0,1>, <6,7,2,3>
  3786199912U,	// <1,6,7,3>: Cost 4 vext3 <4,6,3,1>, <6,7,3,0>
  2724844406U,	// <1,6,7,4>: Cost 3 vext3 <6,7,0,1>, <6,7,4,5>
  2725213051U,	// <1,6,7,5>: Cost 3 vext3 <6,7,5,1>, <6,7,5,1>
  2724844426U,	// <1,6,7,6>: Cost 3 vext3 <6,7,0,1>, <6,7,6,7>
  3987129551U,	// <1,6,7,7>: Cost 4 vzipl RHS, <1,6,1,7>
  1651692438U,	// <1,6,7,u>: Cost 2 vext3 <6,7,u,1>, <6,7,u,1>
  1651766175U,	// <1,6,u,0>: Cost 2 vext3 <6,u,0,1>, <6,u,0,1>
  2725581736U,	// <1,6,u,1>: Cost 3 vext3 <6,u,1,1>, <6,u,1,1>
  3047784555U,	// <1,6,u,2>: Cost 3 vtrnl <4,6,0,2>, LHS
  2575198722U,	// <1,6,u,3>: Cost 3 vext1 <4,1,6,u>, <3,4,5,6>
  2575199219U,	// <1,6,u,4>: Cost 3 vext1 <4,1,6,u>, <4,1,6,u>
  2725876684U,	// <1,6,u,5>: Cost 3 vext3 <6,u,5,1>, <6,u,5,1>
  3048112235U,	// <1,6,u,6>: Cost 3 vtrnl <4,6,4,6>, LHS
  2691077088U,	// <1,6,u,7>: Cost 3 vext3 <1,1,1,1>, <6,u,7,3>
  1652356071U,	// <1,6,u,u>: Cost 2 vext3 <6,u,u,1>, <6,u,u,1>
  2726171632U,	// <1,7,0,0>: Cost 3 vext3 <7,0,0,1>, <7,0,0,1>
  2638610534U,	// <1,7,0,1>: Cost 3 vext2 <3,5,1,7>, LHS
  3706380452U,	// <1,7,0,2>: Cost 4 vext2 <2,5,1,7>, <0,2,0,2>
  3654920752U,	// <1,7,0,3>: Cost 4 vext1 <5,1,7,0>, <3,5,1,7>
  2726466580U,	// <1,7,0,4>: Cost 3 vext3 <7,0,4,1>, <7,0,4,1>
  3654921933U,	// <1,7,0,5>: Cost 4 vext1 <5,1,7,0>, <5,1,7,0>
  2621358582U,	// <1,7,0,6>: Cost 3 vext2 <0,6,1,7>, <0,6,1,7>
  2622022215U,	// <1,7,0,7>: Cost 3 vext2 <0,7,1,7>, <0,7,1,7>
  2638611101U,	// <1,7,0,u>: Cost 3 vext2 <3,5,1,7>, LHS
  2581184614U,	// <1,7,1,0>: Cost 3 vext1 <5,1,7,1>, LHS
  2581185332U,	// <1,7,1,1>: Cost 3 vext1 <5,1,7,1>, <1,1,1,1>
  3712353174U,	// <1,7,1,2>: Cost 4 vext2 <3,5,1,7>, <1,2,3,0>
  3654928534U,	// <1,7,1,3>: Cost 4 vext1 <5,1,7,1>, <3,0,1,2>
  2581187894U,	// <1,7,1,4>: Cost 3 vext1 <5,1,7,1>, RHS
  2581188302U,	// <1,7,1,5>: Cost 3 vext1 <5,1,7,1>, <5,1,7,1>
  2587160999U,	// <1,7,1,6>: Cost 3 vext1 <6,1,7,1>, <6,1,7,1>
  2593133562U,	// <1,7,1,7>: Cost 3 vext1 <7,1,7,1>, <7,0,1,2>
  2581190446U,	// <1,7,1,u>: Cost 3 vext1 <5,1,7,1>, LHS
  2587164774U,	// <1,7,2,0>: Cost 3 vext1 <6,1,7,2>, LHS
  3654935340U,	// <1,7,2,1>: Cost 4 vext1 <5,1,7,2>, <1,1,0,2>
  3712353896U,	// <1,7,2,2>: Cost 4 vext2 <3,5,1,7>, <2,2,2,2>
  2587166870U,	// <1,7,2,3>: Cost 3 vext1 <6,1,7,2>, <3,0,1,2>
  2587168054U,	// <1,7,2,4>: Cost 3 vext1 <6,1,7,2>, RHS
  3706382167U,	// <1,7,2,5>: Cost 4 vext2 <2,5,1,7>, <2,5,1,7>
  2587169192U,	// <1,7,2,6>: Cost 3 vext1 <6,1,7,2>, <6,1,7,2>
  3993176214U,	// <1,7,2,7>: Cost 4 vzipl <5,5,7,7>, <3,0,1,2>
  2587170606U,	// <1,7,2,u>: Cost 3 vext1 <6,1,7,2>, LHS
  1507459174U,	// <1,7,3,0>: Cost 2 vext1 <5,1,7,3>, LHS
  2581201654U,	// <1,7,3,1>: Cost 3 vext1 <5,1,7,3>, <1,0,3,2>
  2581202536U,	// <1,7,3,2>: Cost 3 vext1 <5,1,7,3>, <2,2,2,2>
  2581203094U,	// <1,7,3,3>: Cost 3 vext1 <5,1,7,3>, <3,0,1,2>
  1507462454U,	// <1,7,3,4>: Cost 2 vext1 <5,1,7,3>, RHS
  1507462864U,	// <1,7,3,5>: Cost 2 vext1 <5,1,7,3>, <5,1,7,3>
  2581205498U,	// <1,7,3,6>: Cost 3 vext1 <5,1,7,3>, <6,2,7,3>
  2581206010U,	// <1,7,3,7>: Cost 3 vext1 <5,1,7,3>, <7,0,1,2>
  1507465006U,	// <1,7,3,u>: Cost 2 vext1 <5,1,7,3>, LHS
  2651220882U,	// <1,7,4,0>: Cost 3 vext2 <5,6,1,7>, <4,0,5,1>
  3330913357U,	// <1,7,4,1>: Cost 4 vrev <7,1,1,4>
  3330987094U,	// <1,7,4,2>: Cost 4 vrev <7,1,2,4>
  3654953520U,	// <1,7,4,3>: Cost 4 vext1 <5,1,7,4>, <3,5,1,7>
  3654954294U,	// <1,7,4,4>: Cost 4 vext1 <5,1,7,4>, RHS
  2638613814U,	// <1,7,4,5>: Cost 3 vext2 <3,5,1,7>, RHS
  3712355660U,	// <1,7,4,6>: Cost 4 vext2 <3,5,1,7>, <4,6,0,2>
  3798586743U,	// <1,7,4,7>: Cost 4 vext3 <6,7,0,1>, <7,4,7,5>
  2638614057U,	// <1,7,4,u>: Cost 3 vext2 <3,5,1,7>, RHS
  2599133286U,	// <1,7,5,0>: Cost 3 vext1 <u,1,7,5>, LHS
  2638614224U,	// <1,7,5,1>: Cost 3 vext2 <3,5,1,7>, <5,1,7,3>
  3724963563U,	// <1,7,5,2>: Cost 4 vext2 <5,6,1,7>, <5,2,1,3>
  3990487378U,	// <1,7,5,3>: Cost 4 vzipl <5,1,7,3>, <0,4,1,5>
  2599136566U,	// <1,7,5,4>: Cost 3 vext1 <u,1,7,5>, RHS
  3654962898U,	// <1,7,5,5>: Cost 4 vext1 <5,1,7,5>, <5,1,7,5>
  2651222067U,	// <1,7,5,6>: Cost 3 vext2 <5,6,1,7>, <5,6,1,7>
  3712356470U,	// <1,7,5,7>: Cost 4 vext2 <3,5,1,7>, <5,7,0,2>
  2638614224U,	// <1,7,5,u>: Cost 3 vext2 <3,5,1,7>, <5,1,7,3>
  2730153430U,	// <1,7,6,0>: Cost 3 vext3 <7,6,0,1>, <7,6,0,1>
  2724845022U,	// <1,7,6,1>: Cost 3 vext3 <6,7,0,1>, <7,6,1,0>
  3712356858U,	// <1,7,6,2>: Cost 4 vext2 <3,5,1,7>, <6,2,7,3>
  3772044786U,	// <1,7,6,3>: Cost 4 vext3 <2,3,0,1>, <7,6,3,2>
  3798586878U,	// <1,7,6,4>: Cost 4 vext3 <6,7,0,1>, <7,6,4,5>
  3724964587U,	// <1,7,6,5>: Cost 4 vext2 <5,6,1,7>, <6,5,7,1>
  3724964664U,	// <1,7,6,6>: Cost 4 vext2 <5,6,1,7>, <6,6,6,6>
  2724845076U,	// <1,7,6,7>: Cost 3 vext3 <6,7,0,1>, <7,6,7,0>
  2725508637U,	// <1,7,6,u>: Cost 3 vext3 <6,u,0,1>, <7,6,u,0>
  2730817063U,	// <1,7,7,0>: Cost 3 vext3 <7,7,0,1>, <7,7,0,1>
  4134125710U,	// <1,7,7,1>: Cost 4 vtrnl <6,7,0,1>, <0,1,6,7>
  3712357556U,	// <1,7,7,2>: Cost 4 vext2 <3,5,1,7>, <7,2,3,u>
  3990489648U,	// <1,7,7,3>: Cost 4 vzipl <5,1,7,3>, <3,5,1,7>
  3724965176U,	// <1,7,7,4>: Cost 4 vext2 <5,6,1,7>, <7,4,0,5>
  2662503828U,	// <1,7,7,5>: Cost 3 vext2 <7,5,1,7>, <7,5,1,7>
  3660951981U,	// <1,7,7,6>: Cost 4 vext1 <6,1,7,7>, <6,1,7,7>
  2724845164U,	// <1,7,7,7>: Cost 3 vext3 <6,7,0,1>, <7,7,7,7>
  2731406959U,	// <1,7,7,u>: Cost 3 vext3 <7,7,u,1>, <7,7,u,1>
  1507500134U,	// <1,7,u,0>: Cost 2 vext1 <5,1,7,u>, LHS
  2638616366U,	// <1,7,u,1>: Cost 3 vext2 <3,5,1,7>, LHS
  2581243496U,	// <1,7,u,2>: Cost 3 vext1 <5,1,7,u>, <2,2,2,2>
  2581244054U,	// <1,7,u,3>: Cost 3 vext1 <5,1,7,u>, <3,0,1,2>
  1507503414U,	// <1,7,u,4>: Cost 2 vext1 <5,1,7,u>, RHS
  1507503829U,	// <1,7,u,5>: Cost 2 vext1 <5,1,7,u>, <5,1,7,u>
  2581246458U,	// <1,7,u,6>: Cost 3 vext1 <5,1,7,u>, <6,2,7,3>
  2581246970U,	// <1,7,u,7>: Cost 3 vext1 <5,1,7,u>, <7,0,1,2>
  1507505966U,	// <1,7,u,u>: Cost 2 vext1 <5,1,7,u>, LHS
  1543643153U,	// <1,u,0,0>: Cost 2 vext2 <0,0,1,u>, <0,0,1,u>
  1561559142U,	// <1,u,0,1>: Cost 2 vext2 <3,0,1,u>, LHS
  2819449635U,	// <1,u,0,2>: Cost 3 vuzpr LHS, <1,0,u,2>
  2691077861U,	// <1,u,0,3>: Cost 3 vext3 <1,1,1,1>, <u,0,3,2>
  1546297685U,	// <1,u,0,4>: Cost 2 vext2 <0,4,1,u>, <0,4,1,u>
  1658771190U,	// <1,u,0,5>: Cost 2 vext3 <u,0,5,1>, <u,0,5,1>
  2691077888U,	// <1,u,0,6>: Cost 3 vext3 <1,1,1,1>, <u,0,6,2>
  2659189376U,	// <1,u,0,7>: Cost 3 vext2 <7,0,1,u>, <0,7,u,1>
  1561559709U,	// <1,u,0,u>: Cost 2 vext2 <3,0,1,u>, LHS
  1483112550U,	// <1,u,1,0>: Cost 2 vext1 <1,1,1,1>, LHS
  202162278U,	// <1,u,1,1>: Cost 1 vdup1 LHS
  1617336110U,	// <1,u,1,2>: Cost 2 vext3 <1,1,1,1>, LHS
  2886959114U,	// <1,u,1,3>: Cost 3 vzipl LHS, <0,0,1,1>
  1483115830U,	// <1,u,1,4>: Cost 2 vext1 <1,1,1,1>, RHS
  2581262039U,	// <1,u,1,5>: Cost 3 vext1 <5,1,u,1>, <5,1,u,1>
  2587234736U,	// <1,u,1,6>: Cost 3 vext1 <6,1,u,1>, <6,1,u,1>
  2691077979U,	// <1,u,1,7>: Cost 3 vext3 <1,1,1,1>, <u,1,7,3>
  202162278U,	// <1,u,1,u>: Cost 1 vdup1 LHS
  2691077996U,	// <1,u,2,0>: Cost 3 vext3 <1,1,1,1>, <u,2,0,2>
  2698893174U,	// <1,u,2,1>: Cost 3 vext3 <2,3,u,1>, <u,2,1,3>
  2635302504U,	// <1,u,2,2>: Cost 3 vext2 <3,0,1,u>, <2,2,2,2>
  2886961302U,	// <1,u,2,3>: Cost 3 vzipl LHS, <3,0,1,2>
  2575297535U,	// <1,u,2,4>: Cost 3 vext1 <4,1,u,2>, <4,1,u,2>
  3004384150U,	// <1,u,2,5>: Cost 3 vzipr RHS, <1,2,3,0>
  2587242929U,	// <1,u,2,6>: Cost 3 vext1 <6,1,u,2>, <6,1,u,2>
  2691078060U,	// <1,u,2,7>: Cost 3 vext3 <1,1,1,1>, <u,2,7,3>
  2887002262U,	// <1,u,2,u>: Cost 3 vzipl LHS, <3,0,1,2>
  403931292U,	// <1,u,3,0>: Cost 1 vext1 LHS, LHS
  1477673718U,	// <1,u,3,1>: Cost 2 vext1 LHS, <1,0,3,2>
  115726126U,	// <1,u,3,2>: Cost 1 vrev LHS
  1477675158U,	// <1,u,3,3>: Cost 2 vext1 LHS, <3,0,1,2>
  403934518U,	// <1,u,3,4>: Cost 1 vext1 LHS, RHS
  1477676752U,	// <1,u,3,5>: Cost 2 vext1 LHS, <5,1,7,3>
  1477677562U,	// <1,u,3,6>: Cost 2 vext1 LHS, <6,2,7,3>
  1975853158U,	// <1,u,3,7>: Cost 2 vtrnl RHS, LHS
  403937070U,	// <1,u,3,u>: Cost 1 vext1 LHS, LHS
  2635303826U,	// <1,u,4,0>: Cost 3 vext2 <3,0,1,u>, <4,0,5,1>
  2724845594U,	// <1,u,4,1>: Cost 3 vext3 <6,7,0,1>, <u,4,1,5>
  2724845604U,	// <1,u,4,2>: Cost 3 vext3 <6,7,0,1>, <u,4,2,6>
  2599201572U,	// <1,u,4,3>: Cost 3 vext1 <u,1,u,4>, <3,u,1,u>
  2659192016U,	// <1,u,4,4>: Cost 3 vext2 <7,0,1,u>, <4,4,4,4>
  1561562422U,	// <1,u,4,5>: Cost 2 vext2 <3,0,1,u>, RHS
  2635304268U,	// <1,u,4,6>: Cost 3 vext2 <3,0,1,u>, <4,6,0,2>
  2724845649U,	// <1,u,4,7>: Cost 3 vext3 <6,7,0,1>, <u,4,7,6>
  1561562665U,	// <1,u,4,u>: Cost 2 vext2 <3,0,1,u>, RHS
  2557403238U,	// <1,u,5,0>: Cost 3 vext1 <1,1,u,5>, LHS
  2557404023U,	// <1,u,5,1>: Cost 3 vext1 <1,1,u,5>, <1,1,u,5>
  2648575728U,	// <1,u,5,2>: Cost 3 vext2 <5,2,1,u>, <5,2,1,u>
  2724845695U,	// <1,u,5,3>: Cost 3 vext3 <6,7,0,1>, <u,5,3,7>
  2557406518U,	// <1,u,5,4>: Cost 3 vext1 <1,1,u,5>, RHS
  2581294811U,	// <1,u,5,5>: Cost 3 vext1 <5,1,u,5>, <5,1,u,5>
  1617336474U,	// <1,u,5,6>: Cost 2 vext3 <1,1,1,1>, RHS
  2913534290U,	// <1,u,5,7>: Cost 3 vzipl RHS, <0,4,1,5>
  1617336492U,	// <1,u,5,u>: Cost 2 vext3 <1,1,1,1>, RHS
  2691078320U,	// <1,u,6,0>: Cost 3 vext3 <1,1,1,1>, <u,6,0,2>
  2725509303U,	// <1,u,6,1>: Cost 3 vext3 <6,u,0,1>, <u,6,1,0>
  2635305466U,	// <1,u,6,2>: Cost 3 vext2 <3,0,1,u>, <6,2,7,3>
  2724845776U,	// <1,u,6,3>: Cost 3 vext3 <6,7,0,1>, <u,6,3,7>
  2724845784U,	// <1,u,6,4>: Cost 3 vext3 <6,7,0,1>, <u,6,4,6>
  3714355952U,	// <1,u,6,5>: Cost 4 vext2 <3,u,1,u>, <6,5,7,6>
  2659193656U,	// <1,u,6,6>: Cost 3 vext2 <7,0,1,u>, <6,6,6,6>
  2724845805U,	// <1,u,6,7>: Cost 3 vext3 <6,7,0,1>, <u,6,7,0>
  2635305952U,	// <1,u,6,u>: Cost 3 vext2 <3,0,1,u>, <6,u,7,3>
  1585452032U,	// <1,u,7,0>: Cost 2 vext2 <7,0,1,u>, <7,0,1,u>
  2659857489U,	// <1,u,7,1>: Cost 3 vext2 <7,1,1,u>, <7,1,1,u>
  2263242546U,	// <1,u,7,2>: Cost 3 vrev <u,1,2,7>
  2635257059U,	// <1,u,7,3>: Cost 3 vext2 <3,0,1,2>, <7,3,0,1>
  2724845864U,	// <1,u,7,4>: Cost 3 vext3 <6,7,0,1>, <u,7,4,5>
  2662512021U,	// <1,u,7,5>: Cost 3 vext2 <7,5,1,u>, <7,5,1,u>
  2724845884U,	// <1,u,7,6>: Cost 3 vext3 <6,7,0,1>, <u,7,6,7>
  2659194476U,	// <1,u,7,7>: Cost 3 vext2 <7,0,1,u>, <7,7,7,7>
  1590761096U,	// <1,u,7,u>: Cost 2 vext2 <7,u,1,u>, <7,u,1,u>
  403972257U,	// <1,u,u,0>: Cost 1 vext1 LHS, LHS
  202162278U,	// <1,u,u,1>: Cost 1 vdup1 LHS
  115767091U,	// <1,u,u,2>: Cost 1 vrev LHS
  1477716118U,	// <1,u,u,3>: Cost 2 vext1 LHS, <3,0,1,2>
  403975478U,	// <1,u,u,4>: Cost 1 vext1 LHS, RHS
  1477717712U,	// <1,u,u,5>: Cost 2 vext1 LHS, <5,1,7,3>
  1477718522U,	// <1,u,u,6>: Cost 2 vext1 LHS, <6,2,7,3>
  1975853163U,	// <1,u,u,7>: Cost 2 vtrnl RHS, LHS
  403978030U,	// <1,u,u,u>: Cost 1 vext1 LHS, LHS
  2685698048U,	// <2,0,0,0>: Cost 3 vext3 <0,2,0,2>, <0,0,0,0>
  2685698058U,	// <2,0,0,1>: Cost 3 vext3 <0,2,0,2>, <0,0,1,1>
  1610776596U,	// <2,0,0,2>: Cost 2 vext3 <0,0,2,2>, <0,0,2,2>
  2619384069U,	// <2,0,0,3>: Cost 3 vext2 <0,3,2,0>, <0,3,2,0>
  2563411254U,	// <2,0,0,4>: Cost 3 vext1 <2,2,0,0>, RHS
  3637153488U,	// <2,0,0,5>: Cost 4 vext1 <2,2,0,0>, <5,1,7,3>
  2621374968U,	// <2,0,0,6>: Cost 3 vext2 <0,6,2,0>, <0,6,2,0>
  3732939321U,	// <2,0,0,7>: Cost 4 vext2 <7,0,2,0>, <0,7,0,2>
  1611219018U,	// <2,0,0,u>: Cost 2 vext3 <0,0,u,2>, <0,0,u,2>
  2569388134U,	// <2,0,1,0>: Cost 3 vext1 <3,2,0,1>, LHS
  2569388790U,	// <2,0,1,1>: Cost 3 vext1 <3,2,0,1>, <1,0,3,2>
  1611956326U,	// <2,0,1,2>: Cost 2 vext3 <0,2,0,2>, LHS
  2569390382U,	// <2,0,1,3>: Cost 3 vext1 <3,2,0,1>, <3,2,0,1>
  2569391414U,	// <2,0,1,4>: Cost 3 vext1 <3,2,0,1>, RHS
  3290038480U,	// <2,0,1,5>: Cost 4 vrev <0,2,5,1>
  2587308473U,	// <2,0,1,6>: Cost 3 vext1 <6,2,0,1>, <6,2,0,1>
  3661050874U,	// <2,0,1,7>: Cost 4 vext1 <6,2,0,1>, <7,0,1,2>
  1611956380U,	// <2,0,1,u>: Cost 2 vext3 <0,2,0,2>, LHS
  1477738598U,	// <2,0,2,0>: Cost 2 vext1 <0,2,0,2>, LHS
  2953627240U,	// <2,0,2,1>: Cost 3 vzipr LHS, <2,2,2,2>
  3087844968U,	// <2,0,2,2>: Cost 3 vtrnr LHS, <2,2,2,2>
  2551482518U,	// <2,0,2,3>: Cost 3 vext1 <0,2,0,2>, <3,0,1,2>
  1477741878U,	// <2,0,2,4>: Cost 2 vext1 <0,2,0,2>, RHS
  2551484112U,	// <2,0,2,5>: Cost 3 vext1 <0,2,0,2>, <5,1,7,3>
  2551484922U,	// <2,0,2,6>: Cost 3 vext1 <0,2,0,2>, <6,2,7,3>
  2599261178U,	// <2,0,2,7>: Cost 3 vext1 <u,2,0,2>, <7,0,1,2>
  1477744430U,	// <2,0,2,u>: Cost 2 vext1 <0,2,0,2>, LHS
  2551488512U,	// <2,0,3,0>: Cost 3 vext1 <0,2,0,3>, <0,0,0,0>
  2953627302U,	// <2,0,3,1>: Cost 3 vzipr LHS, <2,3,0,1>
  3087844978U,	// <2,0,3,2>: Cost 3 vtrnr LHS, <2,2,3,3>
  2569406768U,	// <2,0,3,3>: Cost 3 vext1 <3,2,0,3>, <3,2,0,3>
  2551491894U,	// <2,0,3,4>: Cost 3 vext1 <0,2,0,3>, RHS
  3625234128U,	// <2,0,3,5>: Cost 4 vext1 <0,2,0,3>, <5,1,7,3>
  3625234938U,	// <2,0,3,6>: Cost 4 vext1 <0,2,0,3>, <6,2,7,3>
  3998629990U,	// <2,0,3,7>: Cost 4 vzipl <6,5,0,7>, LHS
  3088287346U,	// <2,0,3,u>: Cost 3 vtrnr LHS, <2,2,3,3>
  2687025478U,	// <2,0,4,0>: Cost 3 vext3 <0,4,0,2>, <0,4,0,2>
  2712240466U,	// <2,0,4,1>: Cost 3 vext3 <4,6,0,2>, <0,4,1,5>
  3087845070U,	// <2,0,4,2>: Cost 3 vtrnr LHS, <2,3,4,5>
  3289915585U,	// <2,0,4,3>: Cost 4 vrev <0,2,3,4>
  3637185846U,	// <2,0,4,4>: Cost 4 vext1 <2,2,0,4>, RHS
  2629340470U,	// <2,0,4,5>: Cost 3 vext2 <2,0,2,0>, RHS
  2846279334U,	// <2,0,4,6>: Cost 3 vuzpr RHS, <2,3,0,1>
  3667047573U,	// <2,0,4,7>: Cost 4 vext1 <7,2,0,4>, <7,2,0,4>
  3088287438U,	// <2,0,4,u>: Cost 3 vtrnr LHS, <2,3,4,5>
  4162094889U,	// <2,0,5,0>: Cost 4 vtrnr <0,2,0,2>, <2,4,5,6>
  3703082704U,	// <2,0,5,1>: Cost 4 vext2 <2,0,2,0>, <5,1,7,3>
  2684518830U,	// <2,0,5,2>: Cost 3 vext3 <0,0,2,2>, <0,5,2,7>
  3719008112U,	// <2,0,5,3>: Cost 4 vext2 <4,6,2,0>, <5,3,7,1>
  2216255691U,	// <2,0,5,4>: Cost 3 vrev <0,2,4,5>
  3719008260U,	// <2,0,5,5>: Cost 4 vext2 <4,6,2,0>, <5,5,5,5>
  3719008354U,	// <2,0,5,6>: Cost 4 vext2 <4,6,2,0>, <5,6,7,0>
  3923379878U,	// <2,0,5,7>: Cost 4 vuzpr <5,1,7,3>, <2,3,0,1>
  2216550639U,	// <2,0,5,u>: Cost 3 vrev <0,2,u,5>
  2653229352U,	// <2,0,6,0>: Cost 3 vext2 <6,0,2,0>, <6,0,2,0>
  2953627578U,	// <2,0,6,1>: Cost 3 vzipr LHS, <2,6,3,7>
  2708701688U,	// <2,0,6,2>: Cost 3 vext3 <4,0,6,2>, <0,6,2,0>
  3782443525U,	// <2,0,6,3>: Cost 4 vext3 <4,0,6,2>, <0,6,3,4>
  2655883884U,	// <2,0,6,4>: Cost 3 vext2 <6,4,2,0>, <6,4,2,0>
  3726971588U,	// <2,0,6,5>: Cost 4 vext2 <6,0,2,0>, <6,5,2,7>
  3719009080U,	// <2,0,6,6>: Cost 4 vext2 <4,6,2,0>, <6,6,6,6>
  3719009102U,	// <2,0,6,7>: Cost 4 vext2 <4,6,2,0>, <6,7,0,1>
  2653229352U,	// <2,0,6,u>: Cost 3 vext2 <6,0,2,0>, <6,0,2,0>
  2659202049U,	// <2,0,7,0>: Cost 3 vext2 <7,0,2,0>, <7,0,2,0>
  3934209702U,	// <2,0,7,1>: Cost 4 vuzpr <7,0,1,2>, <2,3,0,1>
  2726249034U,	// <2,0,7,2>: Cost 3 vext3 <7,0,1,2>, <0,7,2,1>
  3935667878U,	// <2,0,7,3>: Cost 4 vuzpr <7,2,3,0>, <2,3,0,1>
  3719009638U,	// <2,0,7,4>: Cost 4 vext2 <4,6,2,0>, <7,4,5,6>
  3937191590U,	// <2,0,7,5>: Cost 4 vuzpr <7,4,5,6>, <2,3,0,1>
  3736925671U,	// <2,0,7,6>: Cost 4 vext2 <7,6,2,0>, <7,6,2,0>
  3719009900U,	// <2,0,7,7>: Cost 4 vext2 <4,6,2,0>, <7,7,7,7>
  2664511113U,	// <2,0,7,u>: Cost 3 vext2 <7,u,2,0>, <7,u,2,0>
  1477787750U,	// <2,0,u,0>: Cost 2 vext1 <0,2,0,u>, LHS
  2953668667U,	// <2,0,u,1>: Cost 3 vzipr LHS, <2,u,0,1>
  1611956893U,	// <2,0,u,2>: Cost 2 vext3 <0,2,0,2>, LHS
  2551531670U,	// <2,0,u,3>: Cost 3 vext1 <0,2,0,u>, <3,0,1,2>
  1477791030U,	// <2,0,u,4>: Cost 2 vext1 <0,2,0,u>, RHS
  2551533264U,	// <2,0,u,5>: Cost 3 vext1 <0,2,0,u>, <5,1,7,3>
  2551534074U,	// <2,0,u,6>: Cost 3 vext1 <0,2,0,u>, <6,2,7,3>
  2599310330U,	// <2,0,u,7>: Cost 3 vext1 <u,2,0,u>, <7,0,1,2>
  1611956947U,	// <2,0,u,u>: Cost 2 vext3 <0,2,0,2>, LHS
  2690564826U,	// <2,1,0,0>: Cost 3 vext3 <1,0,3,2>, <1,0,0,1>
  2690417380U,	// <2,1,0,1>: Cost 3 vext3 <1,0,1,2>, <1,0,1,2>
  2617401508U,	// <2,1,0,2>: Cost 3 vext2 <0,0,2,1>, <0,2,0,2>
  1616823030U,	// <2,1,0,3>: Cost 2 vext3 <1,0,3,2>, <1,0,3,2>
  2569456950U,	// <2,1,0,4>: Cost 3 vext1 <3,2,1,0>, RHS
  3643199184U,	// <2,1,0,5>: Cost 4 vext1 <3,2,1,0>, <5,1,7,3>
  3643199994U,	// <2,1,0,6>: Cost 4 vext1 <3,2,1,0>, <6,2,7,3>
  2622046794U,	// <2,1,0,7>: Cost 3 vext2 <0,7,2,1>, <0,7,2,1>
  1617191715U,	// <2,1,0,u>: Cost 2 vext3 <1,0,u,2>, <1,0,u,2>
  2623374060U,	// <2,1,1,0>: Cost 3 vext2 <1,0,2,1>, <1,0,2,1>
  2685698868U,	// <2,1,1,1>: Cost 3 vext3 <0,2,0,2>, <1,1,1,1>
  2623374230U,	// <2,1,1,2>: Cost 3 vext2 <1,0,2,1>, <1,2,3,0>
  2685698888U,	// <2,1,1,3>: Cost 3 vext3 <0,2,0,2>, <1,1,3,3>
  3625291062U,	// <2,1,1,4>: Cost 4 vext1 <0,2,1,1>, RHS
  3726976144U,	// <2,1,1,5>: Cost 4 vext2 <6,0,2,1>, <1,5,3,7>
  3765191522U,	// <2,1,1,6>: Cost 4 vext3 <1,1,6,2>, <1,1,6,2>
  3296158651U,	// <2,1,1,7>: Cost 4 vrev <1,2,7,1>
  2685698933U,	// <2,1,1,u>: Cost 3 vext3 <0,2,0,2>, <1,1,u,3>
  2629346757U,	// <2,1,2,0>: Cost 3 vext2 <2,0,2,1>, <2,0,2,1>
  3759440775U,	// <2,1,2,1>: Cost 4 vext3 <0,2,0,2>, <1,2,1,3>
  2629346920U,	// <2,1,2,2>: Cost 3 vext2 <2,0,2,1>, <2,2,2,2>
  3020734628U,	// <2,1,2,3>: Cost 3 vtrnl LHS, <0,2,0,2>
  2702361508U,	// <2,1,2,4>: Cost 3 vext3 <3,0,1,2>, <1,2,4,5>
  3776103337U,	// <2,1,2,5>: Cost 4 vext3 <3,0,1,2>, <1,2,5,1>
  3776103347U,	// <2,1,2,6>: Cost 4 vext3 <3,0,1,2>, <1,2,6,2>
  2726249402U,	// <2,1,2,7>: Cost 3 vext3 <7,0,1,2>, <1,2,7,0>
  3020775588U,	// <2,1,2,u>: Cost 3 vtrnl LHS, <0,2,0,2>
  2551562342U,	// <2,1,3,0>: Cost 3 vext1 <0,2,1,3>, LHS
  2892398694U,	// <2,1,3,1>: Cost 3 vzipl <1,1,1,1>, LHS
  2551563942U,	// <2,1,3,2>: Cost 3 vext1 <0,2,1,3>, <2,3,0,1>
  3020736114U,	// <2,1,3,3>: Cost 3 vtrnl LHS, <2,2,3,3>
  2551565622U,	// <2,1,3,4>: Cost 3 vext1 <0,2,1,3>, RHS
  2581425899U,	// <2,1,3,5>: Cost 3 vext1 <5,2,1,3>, <5,2,1,3>
  3625308666U,	// <2,1,3,6>: Cost 4 vext1 <0,2,1,3>, <6,2,7,3>
  3980787814U,	// <2,1,3,7>: Cost 4 vzipl <3,5,1,7>, LHS
  3020777074U,	// <2,1,3,u>: Cost 3 vtrnl LHS, <2,2,3,3>
  3697118098U,	// <2,1,4,0>: Cost 4 vext2 <1,0,2,1>, <4,0,5,1>
  4100359066U,	// <2,1,4,1>: Cost 4 vtrnl <1,1,1,1>, <1,2,3,4>
  3977429095U,	// <2,1,4,2>: Cost 4 vzipl <3,0,1,2>, <0,1,2,4>
  1148404634U,	// <2,1,4,3>: Cost 2 vrev <1,2,3,4>
  3643231542U,	// <2,1,4,4>: Cost 4 vext1 <3,2,1,4>, RHS
  2623376694U,	// <2,1,4,5>: Cost 3 vext2 <1,0,2,1>, RHS
  3697118540U,	// <2,1,4,6>: Cost 4 vext2 <1,0,2,1>, <4,6,0,2>
  3667121310U,	// <2,1,4,7>: Cost 4 vext1 <7,2,1,4>, <7,2,1,4>
  1148773319U,	// <2,1,4,u>: Cost 2 vrev <1,2,u,4>
  3643236454U,	// <2,1,5,0>: Cost 4 vext1 <3,2,1,5>, LHS
  3697118928U,	// <2,1,5,1>: Cost 4 vext2 <1,0,2,1>, <5,1,7,3>
  3643238099U,	// <2,1,5,2>: Cost 4 vext1 <3,2,1,5>, <2,3,5,1>
  2712241296U,	// <2,1,5,3>: Cost 3 vext3 <4,6,0,2>, <1,5,3,7>
  2222228388U,	// <2,1,5,4>: Cost 3 vrev <1,2,4,5>
  3643240144U,	// <2,1,5,5>: Cost 4 vext1 <3,2,1,5>, <5,1,7,3>
  3726979170U,	// <2,1,5,6>: Cost 4 vext2 <6,0,2,1>, <5,6,7,0>
  3631297530U,	// <2,1,5,7>: Cost 4 vext1 <1,2,1,5>, <7,0,1,2>
  2222523336U,	// <2,1,5,u>: Cost 3 vrev <1,2,u,5>
  2653237545U,	// <2,1,6,0>: Cost 3 vext2 <6,0,2,1>, <6,0,2,1>
  3785983183U,	// <2,1,6,1>: Cost 4 vext3 <4,6,0,2>, <1,6,1,7>
  2653237754U,	// <2,1,6,2>: Cost 3 vext2 <6,0,2,1>, <6,2,7,3>
  3068510412U,	// <2,1,6,3>: Cost 3 vtrnl LHS, <0,2,4,6>
  3726979697U,	// <2,1,6,4>: Cost 4 vext2 <6,0,2,1>, <6,4,2,5>
  3785983220U,	// <2,1,6,5>: Cost 4 vext3 <4,6,0,2>, <1,6,5,u>
  3726979896U,	// <2,1,6,6>: Cost 4 vext2 <6,0,2,1>, <6,6,6,6>
  3726979918U,	// <2,1,6,7>: Cost 4 vext2 <6,0,2,1>, <6,7,0,1>
  2222531529U,	// <2,1,6,u>: Cost 3 vrev <1,2,u,6>
  2622051322U,	// <2,1,7,0>: Cost 3 vext2 <0,7,2,1>, <7,0,1,2>
  3733615699U,	// <2,1,7,1>: Cost 4 vext2 <7,1,2,1>, <7,1,2,1>
  3726980271U,	// <2,1,7,2>: Cost 4 vext2 <6,0,2,1>, <7,2,3,3>
  2222171037U,	// <2,1,7,3>: Cost 3 vrev <1,2,3,7>
  3726980454U,	// <2,1,7,4>: Cost 4 vext2 <6,0,2,1>, <7,4,5,6>
  3736270231U,	// <2,1,7,5>: Cost 4 vext2 <7,5,2,1>, <7,5,2,1>
  3726980567U,	// <2,1,7,6>: Cost 4 vext2 <6,0,2,1>, <7,6,0,2>
  3726980716U,	// <2,1,7,7>: Cost 4 vext2 <6,0,2,1>, <7,7,7,7>
  2669827714U,	// <2,1,7,u>: Cost 3 vext2 <u,7,2,1>, <7,u,1,2>
  2551603302U,	// <2,1,u,0>: Cost 3 vext1 <0,2,1,u>, LHS
  2623379246U,	// <2,1,u,1>: Cost 3 vext2 <1,0,2,1>, LHS
  2551604902U,	// <2,1,u,2>: Cost 3 vext1 <0,2,1,u>, <2,3,0,1>
  1148437406U,	// <2,1,u,3>: Cost 2 vrev <1,2,3,u>
  2551606582U,	// <2,1,u,4>: Cost 3 vext1 <0,2,1,u>, RHS
  2623379610U,	// <2,1,u,5>: Cost 3 vext2 <1,0,2,1>, RHS
  3625349626U,	// <2,1,u,6>: Cost 4 vext1 <0,2,1,u>, <6,2,7,3>
  2669828370U,	// <2,1,u,7>: Cost 3 vext2 <u,7,2,1>, <u,7,2,1>
  1148806091U,	// <2,1,u,u>: Cost 2 vrev <1,2,u,u>
  1543667732U,	// <2,2,0,0>: Cost 2 vext2 <0,0,2,2>, <0,0,2,2>
  1556938854U,	// <2,2,0,1>: Cost 2 vext2 <2,2,2,2>, LHS
  2819409512U,	// <2,2,0,2>: Cost 3 vuzpr LHS, <2,2,2,2>
  2696537551U,	// <2,2,0,3>: Cost 3 vext3 <2,0,3,2>, <2,0,3,2>
  2696611288U,	// <2,2,0,4>: Cost 3 vext3 <2,0,4,2>, <2,0,4,2>
  2617409966U,	// <2,2,0,5>: Cost 3 vext2 <0,0,2,2>, <0,5,2,7>
  3770500586U,	// <2,2,0,6>: Cost 4 vext3 <2,0,6,2>, <2,0,6,2>
  3799991795U,	// <2,2,0,7>: Cost 4 vext3 <7,0,1,2>, <2,0,7,2>
  1556939421U,	// <2,2,0,u>: Cost 2 vext2 <2,2,2,2>, LHS
  2690565638U,	// <2,2,1,0>: Cost 3 vext3 <1,0,3,2>, <2,1,0,3>
  2630681396U,	// <2,2,1,1>: Cost 3 vext2 <2,2,2,2>, <1,1,1,1>
  2685699608U,	// <2,2,1,2>: Cost 3 vext3 <0,2,0,2>, <2,1,2,3>
  3759441441U,	// <2,2,1,3>: Cost 4 vext3 <0,2,0,2>, <2,1,3,3>
  3759441450U,	// <2,2,1,4>: Cost 4 vext3 <0,2,0,2>, <2,1,4,3>
  2665186448U,	// <2,2,1,5>: Cost 3 vext2 <u,0,2,2>, <1,5,3,7>
  3738928335U,	// <2,2,1,6>: Cost 4 vext2 <u,0,2,2>, <1,6,1,7>
  3738928427U,	// <2,2,1,7>: Cost 4 vext2 <u,0,2,2>, <1,7,3,0>
  2630681980U,	// <2,2,1,u>: Cost 3 vext2 <2,2,2,2>, <1,u,3,0>
  1489829990U,	// <2,2,2,0>: Cost 2 vext1 <2,2,2,2>, LHS
  2563572470U,	// <2,2,2,1>: Cost 3 vext1 <2,2,2,2>, <1,0,3,2>
  269271142U,	// <2,2,2,2>: Cost 1 vdup2 LHS
  2886518376U,	// <2,2,2,3>: Cost 3 vzipl LHS, <2,2,2,2>
  1489833270U,	// <2,2,2,4>: Cost 2 vext1 <2,2,2,2>, RHS
  2563575504U,	// <2,2,2,5>: Cost 3 vext1 <2,2,2,2>, <5,1,7,3>
  2563576314U,	// <2,2,2,6>: Cost 3 vext1 <2,2,2,2>, <6,2,7,3>
  2593436837U,	// <2,2,2,7>: Cost 3 vext1 <7,2,2,2>, <7,2,2,2>
  269271142U,	// <2,2,2,u>: Cost 1 vdup2 LHS
  2685699750U,	// <2,2,3,0>: Cost 3 vext3 <0,2,0,2>, <2,3,0,1>
  2690565806U,	// <2,2,3,1>: Cost 3 vext3 <1,0,3,2>, <2,3,1,0>
  2630682945U,	// <2,2,3,2>: Cost 3 vext2 <2,2,2,2>, <3,2,2,2>
  1812775014U,	// <2,2,3,3>: Cost 2 vzipl LHS, LHS
  2685699790U,	// <2,2,3,4>: Cost 3 vext3 <0,2,0,2>, <2,3,4,5>
  3625381584U,	// <2,2,3,5>: Cost 4 vext1 <0,2,2,3>, <5,1,7,3>
  2698749661U,	// <2,2,3,6>: Cost 3 vext3 <2,3,6,2>, <2,3,6,2>
  2593445030U,	// <2,2,3,7>: Cost 3 vext1 <7,2,2,3>, <7,2,2,3>
  1812815974U,	// <2,2,3,u>: Cost 2 vzipl LHS, LHS
  2630683538U,	// <2,2,4,0>: Cost 3 vext2 <2,2,2,2>, <4,0,5,1>
  3704425418U,	// <2,2,4,1>: Cost 4 vext2 <2,2,2,2>, <4,1,2,3>
  2228045418U,	// <2,2,4,2>: Cost 3 vrev <2,2,2,4>
  3964904904U,	// <2,2,4,3>: Cost 4 vzipl LHS, <2,0,2,4>
  3027452826U,	// <2,2,4,4>: Cost 3 vtrnl <1,2,3,4>, <1,2,3,4>
  1556942134U,	// <2,2,4,5>: Cost 2 vext2 <2,2,2,2>, RHS
  2630683980U,	// <2,2,4,6>: Cost 3 vext2 <2,2,2,2>, <4,6,0,2>
  3667195047U,	// <2,2,4,7>: Cost 4 vext1 <7,2,2,4>, <7,2,2,4>
  1556942377U,	// <2,2,4,u>: Cost 2 vext2 <2,2,2,2>, RHS
  3704426055U,	// <2,2,5,0>: Cost 4 vext2 <2,2,2,2>, <5,0,1,1>
  2630684368U,	// <2,2,5,1>: Cost 3 vext2 <2,2,2,2>, <5,1,7,3>
  2685699936U,	// <2,2,5,2>: Cost 3 vext3 <0,2,0,2>, <2,5,2,7>
  3779348328U,	// <2,2,5,3>: Cost 4 vext3 <3,5,0,2>, <2,5,3,6>
  2228201085U,	// <2,2,5,4>: Cost 3 vrev <2,2,4,5>
  2665189380U,	// <2,2,5,5>: Cost 3 vext2 <u,0,2,2>, <5,5,5,5>
  2665189474U,	// <2,2,5,6>: Cost 3 vext2 <u,0,2,2>, <5,6,7,0>
  3704426614U,	// <2,2,5,7>: Cost 4 vext2 <2,2,2,2>, <5,7,0,2>
  2630684935U,	// <2,2,5,u>: Cost 3 vext2 <2,2,2,2>, <5,u,7,3>
  3704426793U,	// <2,2,6,0>: Cost 4 vext2 <2,2,2,2>, <6,0,2,1>
  3704426876U,	// <2,2,6,1>: Cost 4 vext2 <2,2,2,2>, <6,1,2,3>
  2630685178U,	// <2,2,6,2>: Cost 3 vext2 <2,2,2,2>, <6,2,7,3>
  2712242106U,	// <2,2,6,3>: Cost 3 vext3 <4,6,0,2>, <2,6,3,7>
  3637349686U,	// <2,2,6,4>: Cost 4 vext1 <2,2,2,6>, RHS
  3738931890U,	// <2,2,6,5>: Cost 4 vext2 <u,0,2,2>, <6,5,0,7>
  2657227536U,	// <2,2,6,6>: Cost 3 vext2 <6,6,2,2>, <6,6,2,2>
  2657891169U,	// <2,2,6,7>: Cost 3 vext2 <6,7,2,2>, <6,7,2,2>
  2630685664U,	// <2,2,6,u>: Cost 3 vext2 <2,2,2,2>, <6,u,7,3>
  2726250474U,	// <2,2,7,0>: Cost 3 vext3 <7,0,1,2>, <2,7,0,1>
  3934209640U,	// <2,2,7,1>: Cost 4 vuzpr <7,0,1,2>, <2,2,2,2>
  2660545701U,	// <2,2,7,2>: Cost 3 vext2 <7,2,2,2>, <7,2,2,2>
  3964906122U,	// <2,2,7,3>: Cost 4 vzipl LHS, <3,6,2,7>
  2665190758U,	// <2,2,7,4>: Cost 3 vext2 <u,0,2,2>, <7,4,5,6>
  3937191528U,	// <2,2,7,5>: Cost 4 vuzpr <7,4,5,6>, <2,2,2,2>
  3730970125U,	// <2,2,7,6>: Cost 4 vext2 <6,6,2,2>, <7,6,6,2>
  2665191020U,	// <2,2,7,7>: Cost 3 vext2 <u,0,2,2>, <7,7,7,7>
  2731558962U,	// <2,2,7,u>: Cost 3 vext3 <7,u,1,2>, <2,7,u,1>
  1591449308U,	// <2,2,u,0>: Cost 2 vext2 <u,0,2,2>, <u,0,2,2>
  1556944686U,	// <2,2,u,1>: Cost 2 vext2 <2,2,2,2>, LHS
  269271142U,	// <2,2,u,2>: Cost 1 vdup2 LHS
  1812775019U,	// <2,2,u,3>: Cost 2 vzipl LHS, LHS
  1489833270U,	// <2,2,u,4>: Cost 2 vext1 <2,2,2,2>, RHS
  1556945050U,	// <2,2,u,5>: Cost 2 vext2 <2,2,2,2>, RHS
  2630686896U,	// <2,2,u,6>: Cost 3 vext2 <2,2,2,2>, <u,6,0,2>
  2593485995U,	// <2,2,u,7>: Cost 3 vext1 <7,2,2,u>, <7,2,2,u>
  269271142U,	// <2,2,u,u>: Cost 1 vdup2 LHS
  1544339456U,	// <2,3,0,0>: Cost 2 vext2 LHS, <0,0,0,0>
  470597734U,	// <2,3,0,1>: Cost 1 vext2 LHS, LHS
  1548984484U,	// <2,3,0,2>: Cost 2 vext2 LHS, <0,2,0,2>
  2557659286U,	// <2,3,0,3>: Cost 3 vext1 <1,2,3,0>, <3,0,1,2>
  1483918646U,	// <2,3,0,4>: Cost 2 vext1 <1,2,3,0>, RHS
  2557660880U,	// <2,3,0,5>: Cost 3 vext1 <1,2,3,0>, <5,1,7,3>
  2557661690U,	// <2,3,0,6>: Cost 3 vext1 <1,2,3,0>, <6,2,7,3>
  2593494188U,	// <2,3,0,7>: Cost 3 vext1 <7,2,3,0>, <7,2,3,0>
  470598301U,	// <2,3,0,u>: Cost 1 vext2 LHS, LHS
  1544340214U,	// <2,3,1,0>: Cost 2 vext2 LHS, <1,0,3,2>
  1544340276U,	// <2,3,1,1>: Cost 2 vext2 LHS, <1,1,1,1>
  1544340374U,	// <2,3,1,2>: Cost 2 vext2 LHS, <1,2,3,0>
  2622727118U,	// <2,3,1,3>: Cost 3 vext2 LHS, <1,3,0,2>
  2557668662U,	// <2,3,1,4>: Cost 3 vext1 <1,2,3,1>, RHS
  1592116368U,	// <2,3,1,5>: Cost 2 vext2 LHS, <1,5,3,7>
  2665858255U,	// <2,3,1,6>: Cost 3 vext2 LHS, <1,6,1,7>
  2665858347U,	// <2,3,1,7>: Cost 3 vext2 LHS, <1,7,3,0>
  1548985724U,	// <2,3,1,u>: Cost 2 vext2 LHS, <1,u,3,0>
  2622727604U,	// <2,3,2,0>: Cost 3 vext2 LHS, <2,0,0,2>
  2622727686U,	// <2,3,2,1>: Cost 3 vext2 LHS, <2,1,0,3>
  1544341096U,	// <2,3,2,2>: Cost 2 vext2 LHS, <2,2,2,2>
  1544341158U,	// <2,3,2,3>: Cost 2 vext2 LHS, <2,3,0,1>
  2622727928U,	// <2,3,2,4>: Cost 3 vext2 LHS, <2,4,0,2>
  2665858894U,	// <2,3,2,5>: Cost 3 vext2 LHS, <2,5,0,7>
  1592117178U,	// <2,3,2,6>: Cost 2 vext2 LHS, <2,6,3,7>
  2665859050U,	// <2,3,2,7>: Cost 3 vext2 LHS, <2,7,0,1>
  1548986427U,	// <2,3,2,u>: Cost 2 vext2 LHS, <2,u,0,1>
  1548986518U,	// <2,3,3,0>: Cost 2 vext2 LHS, <3,0,1,2>
  2622728414U,	// <2,3,3,1>: Cost 3 vext2 LHS, <3,1,0,2>
  1489913458U,	// <2,3,3,2>: Cost 2 vext1 <2,2,3,3>, <2,2,3,3>
  1544341916U,	// <2,3,3,3>: Cost 2 vext2 LHS, <3,3,3,3>
  1548986882U,	// <2,3,3,4>: Cost 2 vext2 LHS, <3,4,5,6>
  2622728738U,	// <2,3,3,5>: Cost 3 vext2 LHS, <3,5,0,2>
  2622728842U,	// <2,3,3,6>: Cost 3 vext2 LHS, <3,6,2,7>
  2593518767U,	// <2,3,3,7>: Cost 3 vext1 <7,2,3,3>, <7,2,3,3>
  1548987166U,	// <2,3,3,u>: Cost 2 vext2 LHS, <3,u,1,2>
  1548987282U,	// <2,3,4,0>: Cost 2 vext2 LHS, <4,0,5,1>
  1483948954U,	// <2,3,4,1>: Cost 2 vext1 <1,2,3,4>, <1,2,3,4>
  2622729270U,	// <2,3,4,2>: Cost 3 vext2 LHS, <4,2,5,3>
  2557692054U,	// <2,3,4,3>: Cost 3 vext1 <1,2,3,4>, <3,0,1,2>
  1483951414U,	// <2,3,4,4>: Cost 2 vext1 <1,2,3,4>, RHS
  470601014U,	// <2,3,4,5>: Cost 1 vext2 LHS, RHS
  1548987724U,	// <2,3,4,6>: Cost 2 vext2 LHS, <4,6,0,2>
  2593526960U,	// <2,3,4,7>: Cost 3 vext1 <7,2,3,4>, <7,2,3,4>
  470601257U,	// <2,3,4,u>: Cost 1 vext2 LHS, RHS
  2622729799U,	// <2,3,5,0>: Cost 3 vext2 LHS, <5,0,1,1>
  1548988112U,	// <2,3,5,1>: Cost 2 vext2 LHS, <5,1,7,3>
  2622729968U,	// <2,3,5,2>: Cost 3 vext2 LHS, <5,2,1,u>
  2665860976U,	// <2,3,5,3>: Cost 3 vext2 LHS, <5,3,7,1>
  1592119238U,	// <2,3,5,4>: Cost 2 vext2 LHS, <5,4,7,6>
  1592119300U,	// <2,3,5,5>: Cost 2 vext2 LHS, <5,5,5,5>
  1592119394U,	// <2,3,5,6>: Cost 2 vext2 LHS, <5,6,7,0>
  2622730358U,	// <2,3,5,7>: Cost 3 vext2 LHS, <5,7,0,2>
  1592119556U,	// <2,3,5,u>: Cost 2 vext2 LHS, <5,u,7,0>
  2622730537U,	// <2,3,6,0>: Cost 3 vext2 LHS, <6,0,2,1>
  2622730620U,	// <2,3,6,1>: Cost 3 vext2 LHS, <6,1,2,3>
  1548988922U,	// <2,3,6,2>: Cost 2 vext2 LHS, <6,2,7,3>
  2665861682U,	// <2,3,6,3>: Cost 3 vext2 LHS, <6,3,4,5>
  2665861740U,	// <2,3,6,4>: Cost 3 vext2 LHS, <6,4,2,0>
  2665861810U,	// <2,3,6,5>: Cost 3 vext2 LHS, <6,5,0,7>
  1592120120U,	// <2,3,6,6>: Cost 2 vext2 LHS, <6,6,6,6>
  1592120142U,	// <2,3,6,7>: Cost 2 vext2 LHS, <6,7,0,1>
  1548989408U,	// <2,3,6,u>: Cost 2 vext2 LHS, <6,u,7,3>
  1592120314U,	// <2,3,7,0>: Cost 2 vext2 LHS, <7,0,1,2>
  2659890261U,	// <2,3,7,1>: Cost 3 vext2 <7,1,2,3>, <7,1,2,3>
  2622731439U,	// <2,3,7,2>: Cost 3 vext2 LHS, <7,2,3,3>
  2665862371U,	// <2,3,7,3>: Cost 3 vext2 LHS, <7,3,0,1>
  1592120678U,	// <2,3,7,4>: Cost 2 vext2 LHS, <7,4,5,6>
  2665862548U,	// <2,3,7,5>: Cost 3 vext2 LHS, <7,5,1,7>
  2665862614U,	// <2,3,7,6>: Cost 3 vext2 LHS, <7,6,0,1>
  1592120940U,	// <2,3,7,7>: Cost 2 vext2 LHS, <7,7,7,7>
  1592120962U,	// <2,3,7,u>: Cost 2 vext2 LHS, <7,u,1,2>
  1548990162U,	// <2,3,u,0>: Cost 2 vext2 LHS, <u,0,1,1>
  470603566U,	// <2,3,u,1>: Cost 1 vext2 LHS, LHS
  1548990316U,	// <2,3,u,2>: Cost 2 vext2 LHS, <u,2,0,2>
  1548990396U,	// <2,3,u,3>: Cost 2 vext2 LHS, <u,3,0,1>
  1548990527U,	// <2,3,u,4>: Cost 2 vext2 LHS, <u,4,5,6>
  470603930U,	// <2,3,u,5>: Cost 1 vext2 LHS, RHS
  1548990640U,	// <2,3,u,6>: Cost 2 vext2 LHS, <u,6,0,2>
  1592121600U,	// <2,3,u,7>: Cost 2 vext2 LHS, <u,7,0,1>
  470604133U,	// <2,3,u,u>: Cost 1 vext2 LHS, LHS
  2708261734U,	// <2,4,0,0>: Cost 3 vext3 <4,0,0,2>, <4,0,0,2>
  2629369958U,	// <2,4,0,1>: Cost 3 vext2 <2,0,2,4>, LHS
  2819409614U,	// <2,4,0,2>: Cost 3 vuzpr LHS, <2,3,4,5>
  2619416841U,	// <2,4,0,3>: Cost 3 vext2 <0,3,2,4>, <0,3,2,4>
  2712243086U,	// <2,4,0,4>: Cost 3 vext3 <4,6,0,2>, <4,0,4,6>
  2685701010U,	// <2,4,0,5>: Cost 3 vext3 <0,2,0,2>, <4,0,5,1>
  1634962332U,	// <2,4,0,6>: Cost 2 vext3 <4,0,6,2>, <4,0,6,2>
  3661337594U,	// <2,4,0,7>: Cost 4 vext1 <6,2,4,0>, <7,0,1,2>
  1635109806U,	// <2,4,0,u>: Cost 2 vext3 <4,0,u,2>, <4,0,u,2>
  2619417334U,	// <2,4,1,0>: Cost 3 vext2 <0,3,2,4>, <1,0,3,2>
  3899033294U,	// <2,4,1,1>: Cost 4 vuzpr <1,1,1,1>, <2,3,4,5>
  3703112598U,	// <2,4,1,2>: Cost 4 vext2 <2,0,2,4>, <1,2,3,0>
  3898525390U,	// <2,4,1,3>: Cost 4 vuzpr <1,0,3,2>, <2,3,4,5>
  3643427810U,	// <2,4,1,4>: Cost 4 vext1 <3,2,4,1>, <4,1,5,0>
  2709294052U,	// <2,4,1,5>: Cost 3 vext3 <4,1,5,2>, <4,1,5,2>
  3759442926U,	// <2,4,1,6>: Cost 4 vext3 <0,2,0,2>, <4,1,6,3>
  3701785894U,	// <2,4,1,7>: Cost 4 vext2 <1,7,2,4>, <1,7,2,4>
  2709515263U,	// <2,4,1,u>: Cost 3 vext3 <4,1,u,2>, <4,1,u,2>
  2629371336U,	// <2,4,2,0>: Cost 3 vext2 <2,0,2,4>, <2,0,2,4>
  3703113240U,	// <2,4,2,1>: Cost 4 vext2 <2,0,2,4>, <2,1,2,3>
  2630698602U,	// <2,4,2,2>: Cost 3 vext2 <2,2,2,4>, <2,2,2,4>
  2632025806U,	// <2,4,2,3>: Cost 3 vext2 <2,4,2,4>, <2,3,4,5>
  2832844494U,	// <2,4,2,4>: Cost 3 vuzpr <2,3,4,5>, <2,3,4,5>
  2709957685U,	// <2,4,2,5>: Cost 3 vext3 <4,2,5,2>, <4,2,5,2>
  2710031422U,	// <2,4,2,6>: Cost 3 vext3 <4,2,6,2>, <4,2,6,2>
  3800214597U,	// <2,4,2,7>: Cost 4 vext3 <7,0,4,2>, <4,2,7,0>
  2710178896U,	// <2,4,2,u>: Cost 3 vext3 <4,2,u,2>, <4,2,u,2>
  2569699430U,	// <2,4,3,0>: Cost 3 vext1 <3,2,4,3>, LHS
  2569700250U,	// <2,4,3,1>: Cost 3 vext1 <3,2,4,3>, <1,2,3,4>
  3971678310U,	// <2,4,3,2>: Cost 4 vzipl <2,0,4,2>, LHS
  2569701716U,	// <2,4,3,3>: Cost 3 vext1 <3,2,4,3>, <3,2,4,3>
  2569702710U,	// <2,4,3,4>: Cost 3 vext1 <3,2,4,3>, RHS
  2899951718U,	// <2,4,3,5>: Cost 3 vzipl <2,3,4,5>, LHS
  3114714738U,	// <2,4,3,6>: Cost 3 vtrnr RHS, <2,2,3,3>
  3987644518U,	// <2,4,3,7>: Cost 4 vzipl <4,6,4,7>, LHS
  2899976294U,	// <2,4,3,u>: Cost 3 vzipl <2,3,4,u>, LHS
  2563735654U,	// <2,4,4,0>: Cost 3 vext1 <2,2,4,4>, LHS
  2563736474U,	// <2,4,4,1>: Cost 3 vext1 <2,2,4,4>, <1,2,3,4>
  2563737212U,	// <2,4,4,2>: Cost 3 vext1 <2,2,4,4>, <2,2,4,4>
  3637479574U,	// <2,4,4,3>: Cost 4 vext1 <2,2,4,4>, <3,0,1,2>
  2563738934U,	// <2,4,4,4>: Cost 3 vext1 <2,2,4,4>, RHS
  2629373238U,	// <2,4,4,5>: Cost 3 vext2 <2,0,2,4>, RHS
  2846279374U,	// <2,4,4,6>: Cost 3 vuzpr RHS, <2,3,4,5>
  3667342521U,	// <2,4,4,7>: Cost 4 vext1 <7,2,4,4>, <7,2,4,4>
  2629373481U,	// <2,4,4,u>: Cost 3 vext2 <2,0,2,4>, RHS
  2551800011U,	// <2,4,5,0>: Cost 3 vext1 <0,2,4,5>, <0,2,4,5>
  2569716470U,	// <2,4,5,1>: Cost 3 vext1 <3,2,4,5>, <1,0,3,2>
  2563745405U,	// <2,4,5,2>: Cost 3 vext1 <2,2,4,5>, <2,2,4,5>
  2569718102U,	// <2,4,5,3>: Cost 3 vext1 <3,2,4,5>, <3,2,4,5>
  2551803190U,	// <2,4,5,4>: Cost 3 vext1 <0,2,4,5>, RHS
  3625545424U,	// <2,4,5,5>: Cost 4 vext1 <0,2,4,5>, <5,1,7,3>
  1611959606U,	// <2,4,5,6>: Cost 2 vext3 <0,2,0,2>, RHS
  3923379918U,	// <2,4,5,7>: Cost 4 vuzpr <5,1,7,3>, <2,3,4,5>
  1611959624U,	// <2,4,5,u>: Cost 2 vext3 <0,2,0,2>, RHS
  1638501708U,	// <2,4,6,0>: Cost 2 vext3 <4,6,0,2>, <4,6,0,2>
  2599584502U,	// <2,4,6,1>: Cost 3 vext1 <u,2,4,6>, <1,0,3,2>
  2712391006U,	// <2,4,6,2>: Cost 3 vext3 <4,6,2,2>, <4,6,2,2>
  2599585942U,	// <2,4,6,3>: Cost 3 vext1 <u,2,4,6>, <3,0,1,2>
  1525845302U,	// <2,4,6,4>: Cost 2 vext1 <u,2,4,6>, RHS
  2980497338U,	// <2,4,6,5>: Cost 3 vzipr RHS, <2,6,3,7>
  2599588346U,	// <2,4,6,6>: Cost 3 vext1 <u,2,4,6>, <6,2,7,3>
  2599588858U,	// <2,4,6,7>: Cost 3 vext1 <u,2,4,6>, <7,0,1,2>
  1525847854U,	// <2,4,6,u>: Cost 2 vext1 <u,2,4,6>, LHS
  2659234821U,	// <2,4,7,0>: Cost 3 vext2 <7,0,2,4>, <7,0,2,4>
  3934209742U,	// <2,4,7,1>: Cost 4 vuzpr <7,0,1,2>, <2,3,4,5>
  3719042224U,	// <2,4,7,2>: Cost 4 vext2 <4,6,2,4>, <7,2,3,4>
  3935700686U,	// <2,4,7,3>: Cost 4 vuzpr <7,2,3,4>, <2,3,4,5>
  3719042406U,	// <2,4,7,4>: Cost 4 vext2 <4,6,2,4>, <7,4,5,6>
  3937191630U,	// <2,4,7,5>: Cost 4 vuzpr <7,4,5,6>, <2,3,4,5>
  3799993809U,	// <2,4,7,6>: Cost 4 vext3 <7,0,1,2>, <4,7,6,0>
  3719042668U,	// <2,4,7,7>: Cost 4 vext2 <4,6,2,4>, <7,7,7,7>
  2664543885U,	// <2,4,7,u>: Cost 3 vext2 <7,u,2,4>, <7,u,2,4>
  1639828974U,	// <2,4,u,0>: Cost 2 vext3 <4,u,0,2>, <4,u,0,2>
  2629375790U,	// <2,4,u,1>: Cost 3 vext2 <2,0,2,4>, LHS
  2563769984U,	// <2,4,u,2>: Cost 3 vext1 <2,2,4,u>, <2,2,4,u>
  2569742681U,	// <2,4,u,3>: Cost 3 vext1 <3,2,4,u>, <3,2,4,u>
  1525845302U,	// <2,4,u,4>: Cost 2 vext1 <u,2,4,6>, RHS
  2629376154U,	// <2,4,u,5>: Cost 3 vext2 <2,0,2,4>, RHS
  1611959849U,	// <2,4,u,6>: Cost 2 vext3 <0,2,0,2>, RHS
  2599588858U,	// <2,4,u,7>: Cost 3 vext1 <u,2,4,6>, <7,0,1,2>
  1611959867U,	// <2,4,u,u>: Cost 2 vext3 <0,2,0,2>, RHS
  3893659433U,	// <2,5,0,0>: Cost 4 vuzpr <0,2,0,2>, <2,4,5,6>
  2714308168U,	// <2,5,0,1>: Cost 3 vext3 <5,0,1,2>, <5,0,1,2>
  3893192808U,	// <2,5,0,2>: Cost 4 vuzpr LHS, <2,u,5,1>
  3319746298U,	// <2,5,0,3>: Cost 4 vrev <5,2,3,0>
  2620088667U,	// <2,5,0,4>: Cost 3 vext2 <0,4,2,5>, <0,4,2,5>
  2620752300U,	// <2,5,0,5>: Cost 3 vext2 <0,5,2,5>, <0,5,2,5>
  3788418677U,	// <2,5,0,6>: Cost 4 vext3 <5,0,6,2>, <5,0,6,2>
  3047605142U,	// <2,5,0,7>: Cost 3 vtrnl RHS, <1,2,3,0>
  3047613334U,	// <2,5,0,u>: Cost 3 vtrnl RHS, <1,2,3,0>
  3625582800U,	// <2,5,1,0>: Cost 4 vext1 <0,2,5,1>, <0,2,5,1>
  3643499254U,	// <2,5,1,1>: Cost 4 vext1 <3,2,5,1>, <1,0,3,2>
  2626061206U,	// <2,5,1,2>: Cost 3 vext2 <1,4,2,5>, <1,2,3,0>
  3643500891U,	// <2,5,1,3>: Cost 4 vext1 <3,2,5,1>, <3,2,5,1>
  2626061364U,	// <2,5,1,4>: Cost 3 vext2 <1,4,2,5>, <1,4,2,5>
  3625586384U,	// <2,5,1,5>: Cost 4 vext1 <0,2,5,1>, <5,1,7,3>
  3789082310U,	// <2,5,1,6>: Cost 4 vext3 <5,1,6,2>, <5,1,6,2>
  2685701840U,	// <2,5,1,7>: Cost 3 vext3 <0,2,0,2>, <5,1,7,3>
  2685701849U,	// <2,5,1,u>: Cost 3 vext3 <0,2,0,2>, <5,1,u,3>
  2575736934U,	// <2,5,2,0>: Cost 3 vext1 <4,2,5,2>, LHS
  3759443696U,	// <2,5,2,1>: Cost 4 vext3 <0,2,0,2>, <5,2,1,u>
  2575738472U,	// <2,5,2,2>: Cost 3 vext1 <4,2,5,2>, <2,2,2,2>
  3772714750U,	// <2,5,2,3>: Cost 4 vext3 <2,4,0,2>, <5,2,3,4>
  2575739957U,	// <2,5,2,4>: Cost 3 vext1 <4,2,5,2>, <4,2,5,2>
  3906627283U,	// <2,5,2,5>: Cost 4 vuzpr <2,3,5,1>, <2,3,5,1>
  3759443736U,	// <2,5,2,6>: Cost 4 vext3 <0,2,0,2>, <5,2,6,3>
  3047604388U,	// <2,5,2,7>: Cost 3 vtrnl RHS, <0,2,0,2>
  2575742766U,	// <2,5,2,u>: Cost 3 vext1 <4,2,5,2>, LHS
  2575745126U,	// <2,5,3,0>: Cost 3 vext1 <4,2,5,3>, LHS
  2909945958U,	// <2,5,3,1>: Cost 3 vzipl <4,0,5,1>, LHS
  2575746766U,	// <2,5,3,2>: Cost 3 vext1 <4,2,5,3>, <2,3,4,5>
  3978395750U,	// <2,5,3,3>: Cost 4 vzipl <3,1,5,3>, LHS
  2575748150U,	// <2,5,3,4>: Cost 3 vext1 <4,2,5,3>, <4,2,5,3>
  2919268454U,	// <2,5,3,5>: Cost 3 vzipl <5,5,5,5>, LHS
  2906669158U,	// <2,5,3,6>: Cost 3 vzipl <3,4,5,6>, LHS
  3047605874U,	// <2,5,3,7>: Cost 3 vtrnl RHS, <2,2,3,3>
  2906685542U,	// <2,5,3,u>: Cost 3 vzipl <3,4,5,u>, LHS
  2569781350U,	// <2,5,4,0>: Cost 3 vext1 <3,2,5,4>, LHS
  3643523830U,	// <2,5,4,1>: Cost 4 vext1 <3,2,5,4>, <1,0,3,2>
  2569782990U,	// <2,5,4,2>: Cost 3 vext1 <3,2,5,4>, <2,3,4,5>
  2569783646U,	// <2,5,4,3>: Cost 3 vext1 <3,2,5,4>, <3,2,5,4>
  2569784630U,	// <2,5,4,4>: Cost 3 vext1 <3,2,5,4>, RHS
  2655923510U,	// <2,5,4,5>: Cost 3 vext2 <6,4,2,5>, RHS
  3643527674U,	// <2,5,4,6>: Cost 4 vext1 <3,2,5,4>, <6,2,7,3>
  3047605146U,	// <2,5,4,7>: Cost 3 vtrnl RHS, <1,2,3,4>
  2569787182U,	// <2,5,4,u>: Cost 3 vext1 <3,2,5,4>, LHS
  2599649382U,	// <2,5,5,0>: Cost 3 vext1 <u,2,5,5>, LHS
  3703123664U,	// <2,5,5,1>: Cost 4 vext2 <2,0,2,5>, <5,1,7,3>
  3637560966U,	// <2,5,5,2>: Cost 4 vext1 <2,2,5,5>, <2,2,5,5>
  3723030343U,	// <2,5,5,3>: Cost 4 vext2 <5,3,2,5>, <5,3,2,5>
  2599652662U,	// <2,5,5,4>: Cost 3 vext1 <u,2,5,5>, RHS
  2712244228U,	// <2,5,5,5>: Cost 3 vext3 <4,6,0,2>, <5,5,5,5>
  3779350542U,	// <2,5,5,6>: Cost 4 vext3 <3,5,0,2>, <5,5,6,6>
  2712244248U,	// <2,5,5,7>: Cost 3 vext3 <4,6,0,2>, <5,5,7,7>
  2712244257U,	// <2,5,5,u>: Cost 3 vext3 <4,6,0,2>, <5,5,u,7>
  3779350564U,	// <2,5,6,0>: Cost 4 vext3 <3,5,0,2>, <5,6,0,1>
  3785986099U,	// <2,5,6,1>: Cost 4 vext3 <4,6,0,2>, <5,6,1,7>
  2655924730U,	// <2,5,6,2>: Cost 3 vext2 <6,4,2,5>, <6,2,7,3>
  3779350594U,	// <2,5,6,3>: Cost 4 vext3 <3,5,0,2>, <5,6,3,4>
  2655924849U,	// <2,5,6,4>: Cost 3 vext2 <6,4,2,5>, <6,4,2,5>
  3785986135U,	// <2,5,6,5>: Cost 4 vext3 <4,6,0,2>, <5,6,5,7>
  3785986144U,	// <2,5,6,6>: Cost 4 vext3 <4,6,0,2>, <5,6,6,7>
  3047604428U,	// <2,5,6,7>: Cost 3 vtrnl RHS, <0,2,4,6>
  3047612620U,	// <2,5,6,u>: Cost 3 vtrnl RHS, <0,2,4,6>
  2718879862U,	// <2,5,7,0>: Cost 3 vext3 <5,7,0,2>, <5,7,0,2>
  4057597959U,	// <2,5,7,1>: Cost 4 vzipr <5,1,7,3>, <2,7,3,3>
  3792769160U,	// <2,5,7,2>: Cost 4 vext3 <5,7,2,2>, <5,7,2,2>
  3729667354U,	// <2,5,7,3>: Cost 4 vext2 <6,4,2,5>, <7,3,6,2>
  2599669046U,	// <2,5,7,4>: Cost 3 vext1 <u,2,5,7>, RHS
  2599669456U,	// <2,5,7,5>: Cost 3 vext1 <u,2,5,7>, <5,1,7,3>
  3729667566U,	// <2,5,7,6>: Cost 4 vext2 <6,4,2,5>, <7,6,2,7>
  3793137845U,	// <2,5,7,7>: Cost 4 vext3 <5,7,7,2>, <5,7,7,2>
  2599671598U,	// <2,5,7,u>: Cost 3 vext1 <u,2,5,7>, LHS
  2569814118U,	// <2,5,u,0>: Cost 3 vext1 <3,2,5,u>, LHS
  2909945963U,	// <2,5,u,1>: Cost 3 vzipl <4,0,5,1>, LHS
  2569815794U,	// <2,5,u,2>: Cost 3 vext1 <3,2,5,u>, <2,3,u,5>
  2569816418U,	// <2,5,u,3>: Cost 3 vext1 <3,2,5,u>, <3,2,5,u>
  2569817398U,	// <2,5,u,4>: Cost 3 vext1 <3,2,5,u>, RHS
  2919268459U,	// <2,5,u,5>: Cost 3 vzipl <5,5,5,5>, LHS
  2906669163U,	// <2,5,u,6>: Cost 3 vzipl <3,4,5,6>, LHS
  2690568455U,	// <2,5,u,7>: Cost 3 vext3 <1,0,3,2>, <5,u,7,3>
  2690568464U,	// <2,5,u,u>: Cost 3 vext3 <1,0,3,2>, <5,u,u,3>
  2575794278U,	// <2,6,0,0>: Cost 3 vext1 <4,2,6,0>, LHS
  1594130534U,	// <2,6,0,1>: Cost 2 vext2 <u,4,2,6>, LHS
  2575795878U,	// <2,6,0,2>: Cost 3 vext1 <4,2,6,0>, <2,3,0,1>
  3649538196U,	// <2,6,0,3>: Cost 4 vext1 <4,2,6,0>, <3,0,1,0>
  1546355036U,	// <2,6,0,4>: Cost 2 vext2 <0,4,2,6>, <0,4,2,6>
  3649539792U,	// <2,6,0,5>: Cost 4 vext1 <4,2,6,0>, <5,1,7,3>
  2720649550U,	// <2,6,0,6>: Cost 3 vext3 <6,0,6,2>, <6,0,6,2>
  2720723287U,	// <2,6,0,7>: Cost 3 vext3 <6,0,7,2>, <6,0,7,2>
  1594131101U,	// <2,6,0,u>: Cost 2 vext2 <u,4,2,6>, LHS
  2251764153U,	// <2,6,1,0>: Cost 3 vrev <6,2,0,1>
  2667873076U,	// <2,6,1,1>: Cost 3 vext2 <u,4,2,6>, <1,1,1,1>
  2712244604U,	// <2,6,1,2>: Cost 3 vext3 <4,6,0,2>, <6,1,2,3>
  3794022791U,	// <2,6,1,3>: Cost 4 vext3 <6,0,1,2>, <6,1,3,5>
  3649547325U,	// <2,6,1,4>: Cost 4 vext1 <4,2,6,1>, <4,2,6,1>
  2667873424U,	// <2,6,1,5>: Cost 3 vext2 <u,4,2,6>, <1,5,3,7>
  3667464616U,	// <2,6,1,6>: Cost 4 vext1 <7,2,6,1>, <6,1,7,2>
  2721386920U,	// <2,6,1,7>: Cost 3 vext3 <6,1,7,2>, <6,1,7,2>
  2721460657U,	// <2,6,1,u>: Cost 3 vext3 <6,1,u,2>, <6,1,u,2>
  2708705721U,	// <2,6,2,0>: Cost 3 vext3 <4,0,6,2>, <6,2,0,1>
  3643581174U,	// <2,6,2,1>: Cost 4 vext1 <3,2,6,2>, <1,0,3,2>
  2708705741U,	// <2,6,2,2>: Cost 3 vext3 <4,0,6,2>, <6,2,2,3>
  2667873958U,	// <2,6,2,3>: Cost 3 vext2 <u,4,2,6>, <2,3,0,1>
  2708705756U,	// <2,6,2,4>: Cost 3 vext3 <4,0,6,2>, <6,2,4,0>
  3782447590U,	// <2,6,2,5>: Cost 4 vext3 <4,0,6,2>, <6,2,5,1>
  2657920954U,	// <2,6,2,6>: Cost 3 vext2 <6,7,2,6>, <2,6,3,7>
  2685702650U,	// <2,6,2,7>: Cost 3 vext3 <0,2,0,2>, <6,2,7,3>
  2685702659U,	// <2,6,2,u>: Cost 3 vext3 <0,2,0,2>, <6,2,u,3>
  2575818854U,	// <2,6,3,0>: Cost 3 vext1 <4,2,6,3>, LHS
  3643590018U,	// <2,6,3,1>: Cost 4 vext1 <3,2,6,3>, <1,u,3,6>
  2910027878U,	// <2,6,3,2>: Cost 3 vzipl <4,0,6,2>, LHS
  2581793282U,	// <2,6,3,3>: Cost 3 vext1 <5,2,6,3>, <3,4,5,6>
  2575821887U,	// <2,6,3,4>: Cost 3 vext1 <4,2,6,3>, <4,2,6,3>
  2581794584U,	// <2,6,3,5>: Cost 3 vext1 <5,2,6,3>, <5,2,6,3>
  2925985894U,	// <2,6,3,6>: Cost 3 vzipl <6,6,6,6>, LHS
  1839644774U,	// <2,6,3,7>: Cost 2 vzipl RHS, LHS
  1839652966U,	// <2,6,3,u>: Cost 2 vzipl RHS, LHS
  2575827046U,	// <2,6,4,0>: Cost 3 vext1 <4,2,6,4>, LHS
  3649569526U,	// <2,6,4,1>: Cost 4 vext1 <4,2,6,4>, <1,0,3,2>
  2575828686U,	// <2,6,4,2>: Cost 3 vext1 <4,2,6,4>, <2,3,4,5>
  3643599207U,	// <2,6,4,3>: Cost 4 vext1 <3,2,6,4>, <3,2,6,4>
  2575830080U,	// <2,6,4,4>: Cost 3 vext1 <4,2,6,4>, <4,2,6,4>
  1594133814U,	// <2,6,4,5>: Cost 2 vext2 <u,4,2,6>, RHS
  2667875660U,	// <2,6,4,6>: Cost 3 vext2 <u,4,2,6>, <4,6,0,2>
  3772715678U,	// <2,6,4,7>: Cost 4 vext3 <2,4,0,2>, <6,4,7,5>
  1594134057U,	// <2,6,4,u>: Cost 2 vext2 <u,4,2,6>, RHS
  3649577062U,	// <2,6,5,0>: Cost 4 vext1 <4,2,6,5>, LHS
  2667876048U,	// <2,6,5,1>: Cost 3 vext2 <u,4,2,6>, <5,1,7,3>
  2712244932U,	// <2,6,5,2>: Cost 3 vext3 <4,6,0,2>, <6,5,2,7>
  3741618032U,	// <2,6,5,3>: Cost 4 vext2 <u,4,2,6>, <5,3,7,1>
  2252091873U,	// <2,6,5,4>: Cost 3 vrev <6,2,4,5>
  2667876356U,	// <2,6,5,5>: Cost 3 vext2 <u,4,2,6>, <5,5,5,5>
  2667876450U,	// <2,6,5,6>: Cost 3 vext2 <u,4,2,6>, <5,6,7,0>
  3779351280U,	// <2,6,5,7>: Cost 4 vext3 <3,5,0,2>, <6,5,7,6>
  2252386821U,	// <2,6,5,u>: Cost 3 vrev <6,2,u,5>
  2620100924U,	// <2,6,6,0>: Cost 3 vext2 <0,4,2,6>, <6,0,4,2>
  3637642185U,	// <2,6,6,1>: Cost 4 vext1 <2,2,6,6>, <1,2,u,6>
  2724336400U,	// <2,6,6,2>: Cost 3 vext3 <6,6,2,2>, <6,6,2,2>
  3741618738U,	// <2,6,6,3>: Cost 4 vext2 <u,4,2,6>, <6,3,4,5>
  3637644598U,	// <2,6,6,4>: Cost 4 vext1 <2,2,6,6>, RHS
  3730338499U,	// <2,6,6,5>: Cost 4 vext2 <6,5,2,6>, <6,5,2,6>
  2712245048U,	// <2,6,6,6>: Cost 3 vext3 <4,6,0,2>, <6,6,6,6>
  2712245058U,	// <2,6,6,7>: Cost 3 vext3 <4,6,0,2>, <6,6,7,7>
  2913395036U,	// <2,6,6,u>: Cost 3 vzipl RHS, <0,4,2,6>
  2712245070U,	// <2,6,7,0>: Cost 3 vext3 <4,6,0,2>, <6,7,0,1>
  2724926296U,	// <2,6,7,1>: Cost 3 vext3 <6,7,1,2>, <6,7,1,2>
  2725000033U,	// <2,6,7,2>: Cost 3 vext3 <6,7,2,2>, <6,7,2,2>
  2702365544U,	// <2,6,7,3>: Cost 3 vext3 <3,0,1,2>, <6,7,3,0>
  2712245110U,	// <2,6,7,4>: Cost 3 vext3 <4,6,0,2>, <6,7,4,5>
  3785986939U,	// <2,6,7,5>: Cost 4 vext3 <4,6,0,2>, <6,7,5,1>
  2725294981U,	// <2,6,7,6>: Cost 3 vext3 <6,7,6,2>, <6,7,6,2>
  2726253452U,	// <2,6,7,7>: Cost 3 vext3 <7,0,1,2>, <6,7,7,0>
  2712245142U,	// <2,6,7,u>: Cost 3 vext3 <4,6,0,2>, <6,7,u,1>
  2575859814U,	// <2,6,u,0>: Cost 3 vext1 <4,2,6,u>, LHS
  1594136366U,	// <2,6,u,1>: Cost 2 vext2 <u,4,2,6>, LHS
  2708706227U,	// <2,6,u,2>: Cost 3 vext3 <4,0,6,2>, <6,u,2,3>
  2581834242U,	// <2,6,u,3>: Cost 3 vext1 <5,2,6,u>, <3,4,5,6>
  1594136612U,	// <2,6,u,4>: Cost 2 vext2 <u,4,2,6>, <u,4,2,6>
  1594136730U,	// <2,6,u,5>: Cost 2 vext2 <u,4,2,6>, RHS
  2925985899U,	// <2,6,u,6>: Cost 3 vzipl <6,6,6,6>, LHS
  1839644779U,	// <2,6,u,7>: Cost 2 vzipl RHS, LHS
  1839652971U,	// <2,6,u,u>: Cost 2 vzipl RHS, LHS
  2581839974U,	// <2,7,0,0>: Cost 3 vext1 <5,2,7,0>, LHS
  1652511738U,	// <2,7,0,1>: Cost 2 vext3 <7,0,1,2>, <7,0,1,2>
  2685703169U,	// <2,7,0,2>: Cost 3 vext3 <0,2,0,2>, <7,0,2,0>
  2257949868U,	// <2,7,0,3>: Cost 3 vrev <7,2,3,0>
  2581843254U,	// <2,7,0,4>: Cost 3 vext1 <5,2,7,0>, RHS
  2581843742U,	// <2,7,0,5>: Cost 3 vext1 <5,2,7,0>, <5,2,7,0>
  3655586298U,	// <2,7,0,6>: Cost 4 vext1 <5,2,7,0>, <6,2,7,3>
  2599760953U,	// <2,7,0,7>: Cost 3 vext1 <u,2,7,0>, <7,0,u,2>
  1653027897U,	// <2,7,0,u>: Cost 2 vext3 <7,0,u,2>, <7,0,u,2>
  2599764070U,	// <2,7,1,0>: Cost 3 vext1 <u,2,7,1>, LHS
  3701146420U,	// <2,7,1,1>: Cost 4 vext2 <1,6,2,7>, <1,1,1,1>
  3713090454U,	// <2,7,1,2>: Cost 4 vext2 <3,6,2,7>, <1,2,3,0>
  3997126953U,	// <2,7,1,3>: Cost 4 vzipl <6,2,7,3>, <6,0,2,1>
  2726253674U,	// <2,7,1,4>: Cost 3 vext3 <7,0,1,2>, <7,1,4,6>
  3785987184U,	// <2,7,1,5>: Cost 4 vext3 <4,6,0,2>, <7,1,5,3>
  3701146840U,	// <2,7,1,6>: Cost 4 vext2 <1,6,2,7>, <1,6,2,7>
  2599769082U,	// <2,7,1,7>: Cost 3 vext1 <u,2,7,1>, <7,0,1,2>
  2599769902U,	// <2,7,1,u>: Cost 3 vext1 <u,2,7,1>, LHS
  2581856358U,	// <2,7,2,0>: Cost 3 vext1 <5,2,7,2>, LHS
  3655598838U,	// <2,7,2,1>: Cost 4 vext1 <5,2,7,2>, <1,0,3,2>
  2587829864U,	// <2,7,2,2>: Cost 3 vext1 <6,2,7,2>, <2,2,2,2>
  3759445167U,	// <2,7,2,3>: Cost 4 vext3 <0,2,0,2>, <7,2,3,3>
  2581859638U,	// <2,7,2,4>: Cost 3 vext1 <5,2,7,2>, RHS
  2581860128U,	// <2,7,2,5>: Cost 3 vext1 <5,2,7,2>, <5,2,7,2>
  2587832825U,	// <2,7,2,6>: Cost 3 vext1 <6,2,7,2>, <6,2,7,2>
  3713091562U,	// <2,7,2,7>: Cost 4 vext2 <3,6,2,7>, <2,7,0,1>
  2581862190U,	// <2,7,2,u>: Cost 3 vext1 <5,2,7,2>, LHS
  1514094694U,	// <2,7,3,0>: Cost 2 vext1 <6,2,7,3>, LHS
  2587837174U,	// <2,7,3,1>: Cost 3 vext1 <6,2,7,3>, <1,0,3,2>
  2581866098U,	// <2,7,3,2>: Cost 3 vext1 <5,2,7,3>, <2,2,3,3>
  2916745318U,	// <2,7,3,3>: Cost 3 vzipl <5,1,7,3>, LHS
  1514097974U,	// <2,7,3,4>: Cost 2 vext1 <6,2,7,3>, RHS
  2581868321U,	// <2,7,3,5>: Cost 3 vext1 <5,2,7,3>, <5,2,7,3>
  1514099194U,	// <2,7,3,6>: Cost 2 vext1 <6,2,7,3>, <6,2,7,3>
  2919432294U,	// <2,7,3,7>: Cost 3 vzipl <5,5,7,7>, LHS
  1514100526U,	// <2,7,3,u>: Cost 2 vext1 <6,2,7,3>, LHS
  2581872742U,	// <2,7,4,0>: Cost 3 vext1 <5,2,7,4>, LHS
  2581873562U,	// <2,7,4,1>: Cost 3 vext1 <5,2,7,4>, <1,2,3,4>
  3655616042U,	// <2,7,4,2>: Cost 4 vext1 <5,2,7,4>, <2,1,4,3>
  2257982640U,	// <2,7,4,3>: Cost 3 vrev <7,2,3,4>
  2581876022U,	// <2,7,4,4>: Cost 3 vext1 <5,2,7,4>, RHS
  2639351094U,	// <2,7,4,5>: Cost 3 vext2 <3,6,2,7>, RHS
  2712245609U,	// <2,7,4,6>: Cost 3 vext3 <4,6,0,2>, <7,4,6,0>
  3785987447U,	// <2,7,4,7>: Cost 4 vext3 <4,6,0,2>, <7,4,7,5>
  2639351337U,	// <2,7,4,u>: Cost 3 vext2 <3,6,2,7>, RHS
  2599796838U,	// <2,7,5,0>: Cost 3 vext1 <u,2,7,5>, LHS
  3713093328U,	// <2,7,5,1>: Cost 4 vext2 <3,6,2,7>, <5,1,7,3>
  3712429856U,	// <2,7,5,2>: Cost 4 vext2 <3,5,2,7>, <5,2,7,2>
  3997127281U,	// <2,7,5,3>: Cost 4 vzipl <6,2,7,3>, <6,4,2,5>
  2599800118U,	// <2,7,5,4>: Cost 3 vext1 <u,2,7,5>, RHS
  3785987510U,	// <2,7,5,5>: Cost 4 vext3 <4,6,0,2>, <7,5,5,5>
  3785987521U,	// <2,7,5,6>: Cost 4 vext3 <4,6,0,2>, <7,5,6,7>
  2599802214U,	// <2,7,5,7>: Cost 3 vext1 <u,2,7,5>, <7,4,5,6>
  2599802670U,	// <2,7,5,u>: Cost 3 vext1 <u,2,7,5>, LHS
  2599805030U,	// <2,7,6,0>: Cost 3 vext1 <u,2,7,6>, LHS
  3713094057U,	// <2,7,6,1>: Cost 4 vext2 <3,6,2,7>, <6,1,7,3>
  2639352314U,	// <2,7,6,2>: Cost 3 vext2 <3,6,2,7>, <6,2,7,3>
  3990487388U,	// <2,7,6,3>: Cost 4 vzipl <5,1,7,3>, <0,4,2,6>
  2599808310U,	// <2,7,6,4>: Cost 3 vext1 <u,2,7,6>, RHS
  2656604868U,	// <2,7,6,5>: Cost 3 vext2 <6,5,2,7>, <6,5,2,7>
  3785987601U,	// <2,7,6,6>: Cost 4 vext3 <4,6,0,2>, <7,6,6,6>
  3713094479U,	// <2,7,6,7>: Cost 4 vext2 <3,6,2,7>, <6,7,0,2>
  2599810862U,	// <2,7,6,u>: Cost 3 vext1 <u,2,7,6>, LHS
  2726254119U,	// <2,7,7,0>: Cost 3 vext3 <7,0,1,2>, <7,7,0,1>
  3799995955U,	// <2,7,7,1>: Cost 4 vext3 <7,0,1,2>, <7,7,1,4>
  3713094831U,	// <2,7,7,2>: Cost 4 vext2 <3,6,2,7>, <7,2,3,3>
  3997125258U,	// <2,7,7,3>: Cost 4 vzipl <6,2,7,3>, <3,6,2,7>
  3785987663U,	// <2,7,7,4>: Cost 4 vext3 <4,6,0,2>, <7,7,4,5>
  3799995992U,	// <2,7,7,5>: Cost 4 vext3 <7,0,1,2>, <7,7,5,5>
  2663241198U,	// <2,7,7,6>: Cost 3 vext2 <7,6,2,7>, <7,6,2,7>
  2712245868U,	// <2,7,7,7>: Cost 3 vext3 <4,6,0,2>, <7,7,7,7>
  2731562607U,	// <2,7,7,u>: Cost 3 vext3 <7,u,1,2>, <7,7,u,1>
  1514135654U,	// <2,7,u,0>: Cost 2 vext1 <6,2,7,u>, LHS
  1657820802U,	// <2,7,u,1>: Cost 2 vext3 <7,u,1,2>, <7,u,1,2>
  2640680876U,	// <2,7,u,2>: Cost 3 vext2 <3,u,2,7>, <u,2,7,3>
  2916745323U,	// <2,7,u,3>: Cost 3 vzipl <5,1,7,3>, LHS
  1514138934U,	// <2,7,u,4>: Cost 2 vext1 <6,2,7,u>, RHS
  2639354010U,	// <2,7,u,5>: Cost 3 vext2 <3,6,2,7>, RHS
  1514140159U,	// <2,7,u,6>: Cost 2 vext1 <6,2,7,u>, <6,2,7,u>
  2919432299U,	// <2,7,u,7>: Cost 3 vzipl <5,5,7,7>, LHS
  1514141486U,	// <2,7,u,u>: Cost 2 vext1 <6,2,7,u>, LHS
  1544380416U,	// <2,u,0,0>: Cost 2 vext2 LHS, <0,0,0,0>
  470638699U,	// <2,u,0,1>: Cost 1 vext2 LHS, LHS
  1544380580U,	// <2,u,0,2>: Cost 2 vext2 LHS, <0,2,0,2>
  1658631909U,	// <2,u,0,3>: Cost 2 vext3 <u,0,3,2>, <u,0,3,2>
  1484287286U,	// <2,u,0,4>: Cost 2 vext1 <1,2,u,0>, RHS
  2685703926U,	// <2,u,0,5>: Cost 3 vext3 <0,2,0,2>, <u,0,5,1>
  1658853120U,	// <2,u,0,6>: Cost 2 vext3 <u,0,6,2>, <u,0,6,2>
  3049595798U,	// <2,u,0,7>: Cost 3 vtrnl RHS, <1,2,3,0>
  470639261U,	// <2,u,0,u>: Cost 1 vext2 LHS, LHS
  1544381174U,	// <2,u,1,0>: Cost 2 vext2 LHS, <1,0,3,2>
  1544381236U,	// <2,u,1,1>: Cost 2 vext2 LHS, <1,1,1,1>
  1544381334U,	// <2,u,1,2>: Cost 2 vext2 LHS, <1,2,3,0>
  2618123214U,	// <2,u,1,3>: Cost 3 vext2 LHS, <1,3,0,2>
  2552065334U,	// <2,u,1,4>: Cost 3 vext1 <0,2,u,1>, RHS
  1592157328U,	// <2,u,1,5>: Cost 2 vext2 LHS, <1,5,3,7>
  2587898369U,	// <2,u,1,6>: Cost 3 vext1 <6,2,u,1>, <6,2,u,1>
  2685704027U,	// <2,u,1,7>: Cost 3 vext3 <0,2,0,2>, <u,1,7,3>
  1611962212U,	// <2,u,1,u>: Cost 2 vext3 <0,2,0,2>, LHS
  1659737964U,	// <2,u,2,0>: Cost 2 vext3 <u,2,0,2>, <u,2,0,2>
  2618123782U,	// <2,u,2,1>: Cost 3 vext2 LHS, <2,1,0,3>
  269271142U,	// <2,u,2,2>: Cost 1 vdup2 LHS
  1544382118U,	// <2,u,2,3>: Cost 2 vext2 LHS, <2,3,0,1>
  1477741878U,	// <2,u,2,4>: Cost 2 vext1 <0,2,0,2>, RHS
  2581933865U,	// <2,u,2,5>: Cost 3 vext1 <5,2,u,2>, <5,2,u,2>
  1592158138U,	// <2,u,2,6>: Cost 2 vext2 LHS, <2,6,3,7>
  2685704108U,	// <2,u,2,7>: Cost 3 vext3 <0,2,0,2>, <u,2,7,3>
  269271142U,	// <2,u,2,u>: Cost 1 vdup2 LHS
  1544382614U,	// <2,u,3,0>: Cost 2 vext2 LHS, <3,0,1,2>
  2618124510U,	// <2,u,3,1>: Cost 3 vext2 LHS, <3,1,0,2>
  1490282143U,	// <2,u,3,2>: Cost 2 vext1 <2,2,u,3>, <2,2,u,3>
  1544382876U,	// <2,u,3,3>: Cost 2 vext2 LHS, <3,3,3,3>
  1544382978U,	// <2,u,3,4>: Cost 2 vext2 LHS, <3,4,5,6>
  2618124834U,	// <2,u,3,5>: Cost 3 vext2 LHS, <3,5,0,2>
  1514172931U,	// <2,u,3,6>: Cost 2 vext1 <6,2,u,3>, <6,2,u,3>
  1839792230U,	// <2,u,3,7>: Cost 2 vzipl RHS, LHS
  1544383262U,	// <2,u,3,u>: Cost 2 vext2 LHS, <3,u,1,2>
  1544383378U,	// <2,u,4,0>: Cost 2 vext2 LHS, <4,0,5,1>
  1484317639U,	// <2,u,4,1>: Cost 2 vext1 <1,2,u,4>, <1,2,u,4>
  2618125366U,	// <2,u,4,2>: Cost 3 vext2 LHS, <4,2,5,3>
  1190213513U,	// <2,u,4,3>: Cost 2 vrev <u,2,3,4>
  1484320054U,	// <2,u,4,4>: Cost 2 vext1 <1,2,u,4>, RHS
  470641974U,	// <2,u,4,5>: Cost 1 vext2 LHS, RHS
  1544383820U,	// <2,u,4,6>: Cost 2 vext2 LHS, <4,6,0,2>
  3049595802U,	// <2,u,4,7>: Cost 3 vtrnl RHS, <1,2,3,4>
  470642217U,	// <2,u,4,u>: Cost 1 vext2 LHS, RHS
  2618125950U,	// <2,u,5,0>: Cost 3 vext2 LHS, <5,0,7,2>
  1544384208U,	// <2,u,5,1>: Cost 2 vext2 LHS, <5,1,7,3>
  2618126104U,	// <2,u,5,2>: Cost 3 vext2 LHS, <5,2,6,3>
  2570013050U,	// <2,u,5,3>: Cost 3 vext1 <3,2,u,5>, <3,2,u,5>
  1592160198U,	// <2,u,5,4>: Cost 2 vext2 LHS, <5,4,7,6>
  1592160260U,	// <2,u,5,5>: Cost 2 vext2 LHS, <5,5,5,5>
  1611962522U,	// <2,u,5,6>: Cost 2 vext3 <0,2,0,2>, RHS
  2622771318U,	// <2,u,5,7>: Cost 3 vext2 LHS, <5,7,0,2>
  1611962540U,	// <2,u,5,u>: Cost 2 vext3 <0,2,0,2>, RHS
  1662392496U,	// <2,u,6,0>: Cost 2 vext3 <u,6,0,2>, <u,6,0,2>
  2618126716U,	// <2,u,6,1>: Cost 3 vext2 LHS, <6,1,2,3>
  1544385018U,	// <2,u,6,2>: Cost 2 vext2 LHS, <6,2,7,3>
  2712246480U,	// <2,u,6,3>: Cost 3 vext3 <4,6,0,2>, <u,6,3,7>
  1525845302U,	// <2,u,6,4>: Cost 2 vext1 <u,2,4,6>, RHS
  2656613061U,	// <2,u,6,5>: Cost 3 vext2 <6,5,2,u>, <6,5,2,u>
  1592161080U,	// <2,u,6,6>: Cost 2 vext2 LHS, <6,6,6,6>
  1592161102U,	// <2,u,6,7>: Cost 2 vext2 LHS, <6,7,0,1>
  1549030368U,	// <2,u,6,u>: Cost 2 vext2 LHS, <6,u,7,3>
  1592161274U,	// <2,u,7,0>: Cost 2 vext2 LHS, <7,0,1,2>
  2659931226U,	// <2,u,7,1>: Cost 3 vext2 <7,1,2,u>, <7,1,2,u>
  2618127535U,	// <2,u,7,2>: Cost 3 vext2 LHS, <7,2,3,3>
  2665903331U,	// <2,u,7,3>: Cost 3 vext2 LHS, <7,3,0,1>
  1592161638U,	// <2,u,7,4>: Cost 2 vext2 LHS, <7,4,5,6>
  2665903508U,	// <2,u,7,5>: Cost 3 vext2 LHS, <7,5,1,7>
  2663249391U,	// <2,u,7,6>: Cost 3 vext2 <7,6,2,u>, <7,6,2,u>
  1592161900U,	// <2,u,7,7>: Cost 2 vext2 LHS, <7,7,7,7>
  1592161922U,	// <2,u,7,u>: Cost 2 vext2 LHS, <7,u,1,2>
  1544386258U,	// <2,u,u,0>: Cost 2 vext2 LHS, <u,0,1,1>
  470644526U,	// <2,u,u,1>: Cost 1 vext2 LHS, LHS
  269271142U,	// <2,u,u,2>: Cost 1 vdup2 LHS
  1813217387U,	// <2,u,u,3>: Cost 2 vzipl LHS, LHS
  1549031487U,	// <2,u,u,4>: Cost 2 vext2 LHS, <u,4,5,6>
  470644890U,	// <2,u,u,5>: Cost 1 vext2 LHS, RHS
  1544386736U,	// <2,u,u,6>: Cost 2 vext2 LHS, <u,6,0,2>
  1839792235U,	// <2,u,u,7>: Cost 2 vzipl RHS, LHS
  470645093U,	// <2,u,u,u>: Cost 1 vext2 LHS, LHS
  1611448320U,	// <3,0,0,0>: Cost 2 vext3 LHS, <0,0,0,0>
  1611890698U,	// <3,0,0,1>: Cost 2 vext3 LHS, <0,0,1,1>
  1611890708U,	// <3,0,0,2>: Cost 2 vext3 LHS, <0,0,2,2>
  3763576862U,	// <3,0,0,3>: Cost 4 vext3 LHS, <0,0,3,3>
  2564074806U,	// <3,0,0,4>: Cost 3 vext1 <2,3,0,0>, RHS
  3637817040U,	// <3,0,0,5>: Cost 4 vext1 <2,3,0,0>, <5,1,7,3>
  3637817850U,	// <3,0,0,6>: Cost 4 vext1 <2,3,0,0>, <6,2,7,3>
  3667678434U,	// <3,0,0,7>: Cost 4 vext1 <7,3,0,0>, <7,3,0,0>
  1611890761U,	// <3,0,0,u>: Cost 2 vext3 LHS, <0,0,u,1>
  1490337894U,	// <3,0,1,0>: Cost 2 vext1 <2,3,0,1>, LHS
  2685632605U,	// <3,0,1,1>: Cost 3 vext3 LHS, <0,1,1,3>
  537706598U,	// <3,0,1,2>: Cost 1 vext3 LHS, LHS
  2625430503U,	// <3,0,1,3>: Cost 3 vext2 <1,3,3,0>, <1,3,3,0>
  1490341174U,	// <3,0,1,4>: Cost 2 vext1 <2,3,0,1>, RHS
  2564083408U,	// <3,0,1,5>: Cost 3 vext1 <2,3,0,1>, <5,1,7,3>
  2564084218U,	// <3,0,1,6>: Cost 3 vext1 <2,3,0,1>, <6,2,7,3>
  2593944803U,	// <3,0,1,7>: Cost 3 vext1 <7,3,0,1>, <7,3,0,1>
  537706652U,	// <3,0,1,u>: Cost 1 vext3 LHS, LHS
  1611890852U,	// <3,0,2,0>: Cost 2 vext3 LHS, <0,2,0,2>
  2685632686U,	// <3,0,2,1>: Cost 3 vext3 LHS, <0,2,1,3>
  2685632695U,	// <3,0,2,2>: Cost 3 vext3 LHS, <0,2,2,3>
  2624767654U,	// <3,0,2,3>: Cost 3 vext2 <1,2,3,0>, <2,3,0,1>
  1659224268U,	// <3,0,2,4>: Cost 2 vext3 LHS, <0,2,4,6>
  2732966102U,	// <3,0,2,5>: Cost 3 vext3 LHS, <0,2,5,7>
  2666571706U,	// <3,0,2,6>: Cost 3 vext2 <u,2,3,0>, <2,6,3,7>
  2732966114U,	// <3,0,2,7>: Cost 3 vext3 LHS, <0,2,7,1>
  1659666668U,	// <3,0,2,u>: Cost 2 vext3 LHS, <0,2,u,2>
  2624768150U,	// <3,0,3,0>: Cost 3 vext2 <1,2,3,0>, <3,0,1,2>
  2953628060U,	// <3,0,3,1>: Cost 3 vzipr LHS, <3,3,3,3>
  3087845788U,	// <3,0,3,2>: Cost 3 vtrnr LHS, <3,3,3,3>
  2624768412U,	// <3,0,3,3>: Cost 3 vext2 <1,2,3,0>, <3,3,3,3>
  2624768514U,	// <3,0,3,4>: Cost 3 vext2 <1,2,3,0>, <3,4,5,6>
  3698510370U,	// <3,0,3,5>: Cost 4 vext2 <1,2,3,0>, <3,5,0,2>
  3698510474U,	// <3,0,3,6>: Cost 4 vext2 <1,2,3,0>, <3,6,2,7>
  3800588595U,	// <3,0,3,7>: Cost 4 vext3 <7,1,0,3>, <0,3,7,1>
  3088288156U,	// <3,0,3,u>: Cost 3 vtrnr LHS, <3,3,3,3>
  2624768914U,	// <3,0,4,0>: Cost 3 vext2 <1,2,3,0>, <4,0,5,1>
  1659224402U,	// <3,0,4,1>: Cost 2 vext3 LHS, <0,4,1,5>
  1659224412U,	// <3,0,4,2>: Cost 2 vext3 LHS, <0,4,2,6>
  3637848214U,	// <3,0,4,3>: Cost 4 vext1 <2,3,0,4>, <3,0,1,2>
  2564107574U,	// <3,0,4,4>: Cost 3 vext1 <2,3,0,4>, RHS
  1551027510U,	// <3,0,4,5>: Cost 2 vext2 <1,2,3,0>, RHS
  2624769356U,	// <3,0,4,6>: Cost 3 vext2 <1,2,3,0>, <4,6,0,2>
  3667711206U,	// <3,0,4,7>: Cost 4 vext1 <7,3,0,4>, <7,3,0,4>
  1551027753U,	// <3,0,4,u>: Cost 2 vext2 <1,2,3,0>, RHS
  2732966300U,	// <3,0,5,0>: Cost 3 vext3 LHS, <0,5,0,7>
  2624769744U,	// <3,0,5,1>: Cost 3 vext2 <1,2,3,0>, <5,1,7,3>
  3087845890U,	// <3,0,5,2>: Cost 3 vtrnr LHS, <3,4,5,6>
  3710455664U,	// <3,0,5,3>: Cost 4 vext2 <3,2,3,0>, <5,3,7,1>
  2666573766U,	// <3,0,5,4>: Cost 3 vext2 <u,2,3,0>, <5,4,7,6>
  2666573828U,	// <3,0,5,5>: Cost 3 vext2 <u,2,3,0>, <5,5,5,5>
  2732966354U,	// <3,0,5,6>: Cost 3 vext3 LHS, <0,5,6,7>
  3698511990U,	// <3,0,5,7>: Cost 4 vext2 <1,2,3,0>, <5,7,0,2>
  3088288258U,	// <3,0,5,u>: Cost 3 vtrnr LHS, <3,4,5,6>
  2732966381U,	// <3,0,6,0>: Cost 3 vext3 LHS, <0,6,0,7>
  2732966385U,	// <3,0,6,1>: Cost 3 vext3 LHS, <0,6,1,2>
  2624770554U,	// <3,0,6,2>: Cost 3 vext2 <1,2,3,0>, <6,2,7,3>
  3698512458U,	// <3,0,6,3>: Cost 4 vext2 <1,2,3,0>, <6,3,7,2>
  3637865782U,	// <3,0,6,4>: Cost 4 vext1 <2,3,0,6>, RHS
  3806708243U,	// <3,0,6,5>: Cost 4 vext3 LHS, <0,6,5,0>
  2666574648U,	// <3,0,6,6>: Cost 3 vext2 <u,2,3,0>, <6,6,6,6>
  2657948520U,	// <3,0,6,7>: Cost 3 vext2 <6,7,3,0>, <6,7,3,0>
  2624771040U,	// <3,0,6,u>: Cost 3 vext2 <1,2,3,0>, <6,u,7,3>
  2666574842U,	// <3,0,7,0>: Cost 3 vext2 <u,2,3,0>, <7,0,1,2>
  2732966471U,	// <3,0,7,1>: Cost 3 vext3 LHS, <0,7,1,7>
  2660603052U,	// <3,0,7,2>: Cost 3 vext2 <7,2,3,0>, <7,2,3,0>
  3731690723U,	// <3,0,7,3>: Cost 4 vext2 <6,7,3,0>, <7,3,0,1>
  2666575206U,	// <3,0,7,4>: Cost 3 vext2 <u,2,3,0>, <7,4,5,6>
  3806708328U,	// <3,0,7,5>: Cost 4 vext3 LHS, <0,7,5,4>
  3731690968U,	// <3,0,7,6>: Cost 4 vext2 <6,7,3,0>, <7,6,0,3>
  2666575468U,	// <3,0,7,7>: Cost 3 vext2 <u,2,3,0>, <7,7,7,7>
  2664584850U,	// <3,0,7,u>: Cost 3 vext2 <7,u,3,0>, <7,u,3,0>
  1611891338U,	// <3,0,u,0>: Cost 2 vext3 LHS, <0,u,0,2>
  1551030062U,	// <3,0,u,1>: Cost 2 vext2 <1,2,3,0>, LHS
  537707165U,	// <3,0,u,2>: Cost 1 vext3 LHS, LHS
  2624772028U,	// <3,0,u,3>: Cost 3 vext2 <1,2,3,0>, <u,3,0,1>
  1490398518U,	// <3,0,u,4>: Cost 2 vext1 <2,3,0,u>, RHS
  1551030426U,	// <3,0,u,5>: Cost 2 vext2 <1,2,3,0>, RHS
  2624772272U,	// <3,0,u,6>: Cost 3 vext2 <1,2,3,0>, <u,6,0,2>
  2594002154U,	// <3,0,u,7>: Cost 3 vext1 <7,3,0,u>, <7,3,0,u>
  537707219U,	// <3,0,u,u>: Cost 1 vext3 LHS, LHS
  2685633242U,	// <3,1,0,0>: Cost 3 vext3 LHS, <1,0,0,1>
  2685633251U,	// <3,1,0,1>: Cost 3 vext3 LHS, <1,0,1,1>
  2819410070U,	// <3,1,0,2>: Cost 3 vuzpr LHS, <3,0,1,2>
  1611449078U,	// <3,1,0,3>: Cost 2 vext3 LHS, <1,0,3,2>
  2564148534U,	// <3,1,0,4>: Cost 3 vext1 <2,3,1,0>, RHS
  3637890768U,	// <3,1,0,5>: Cost 4 vext1 <2,3,1,0>, <5,1,7,3>
  3637891578U,	// <3,1,0,6>: Cost 4 vext1 <2,3,1,0>, <6,2,7,3>
  3667752171U,	// <3,1,0,7>: Cost 4 vext1 <7,3,1,0>, <7,3,1,0>
  1611891491U,	// <3,1,0,u>: Cost 2 vext3 LHS, <1,0,u,2>
  2685633324U,	// <3,1,1,0>: Cost 3 vext3 LHS, <1,1,0,2>
  1611449140U,	// <3,1,1,1>: Cost 2 vext3 LHS, <1,1,1,1>
  2624775063U,	// <3,1,1,2>: Cost 3 vext2 <1,2,3,1>, <1,2,3,1>
  1611891528U,	// <3,1,1,3>: Cost 2 vext3 LHS, <1,1,3,3>
  2564156726U,	// <3,1,1,4>: Cost 3 vext1 <2,3,1,1>, RHS
  3637898958U,	// <3,1,1,5>: Cost 4 vext1 <2,3,1,1>, <5,1,7,1>
  3637899687U,	// <3,1,1,6>: Cost 4 vext1 <2,3,1,1>, <6,1,7,1>
  3789161328U,	// <3,1,1,7>: Cost 4 vext3 <5,1,7,3>, <1,1,7,7>
  1611891573U,	// <3,1,1,u>: Cost 2 vext3 LHS, <1,1,u,3>
  2629420494U,	// <3,1,2,0>: Cost 3 vext2 <2,0,3,1>, <2,0,3,1>
  2685633415U,	// <3,1,2,1>: Cost 3 vext3 LHS, <1,2,1,3>
  2685633424U,	// <3,1,2,2>: Cost 3 vext3 LHS, <1,2,2,3>
  1611449238U,	// <3,1,2,3>: Cost 2 vext3 LHS, <1,2,3,0>
  2564164918U,	// <3,1,2,4>: Cost 3 vext1 <2,3,1,2>, RHS
  2733409195U,	// <3,1,2,5>: Cost 3 vext3 LHS, <1,2,5,3>
  3637907962U,	// <3,1,2,6>: Cost 4 vext1 <2,3,1,2>, <6,2,7,3>
  2732966842U,	// <3,1,2,7>: Cost 3 vext3 LHS, <1,2,7,0>
  1611891651U,	// <3,1,2,u>: Cost 2 vext3 LHS, <1,2,u,0>
  2685633486U,	// <3,1,3,0>: Cost 3 vext3 LHS, <1,3,0,2>
  2558198518U,	// <3,1,3,1>: Cost 3 vext1 <1,3,1,3>, <1,0,3,2>
  3759522785U,	// <3,1,3,2>: Cost 4 vext3 <0,2,1,3>, <1,3,2,3>
  3020736924U,	// <3,1,3,3>: Cost 3 vtrnl LHS, <3,3,3,3>
  2558201142U,	// <3,1,3,4>: Cost 3 vext1 <1,3,1,3>, RHS
  3631943376U,	// <3,1,3,5>: Cost 4 vext1 <1,3,1,3>, <5,1,7,3>
  3631944186U,	// <3,1,3,6>: Cost 4 vext1 <1,3,1,3>, <6,2,7,3>
  3800663052U,	// <3,1,3,7>: Cost 4 vext3 <7,1,1,3>, <1,3,7,1>
  3020777884U,	// <3,1,3,u>: Cost 3 vtrnl LHS, <3,3,3,3>
  2732966946U,	// <3,1,4,0>: Cost 3 vext3 LHS, <1,4,0,5>
  3966141338U,	// <3,1,4,1>: Cost 4 vzipl <1,1,1,1>, <1,2,3,4>
  2732966964U,	// <3,1,4,2>: Cost 3 vext3 LHS, <1,4,2,5>
  2222810091U,	// <3,1,4,3>: Cost 3 vrev <1,3,3,4>
  3637923126U,	// <3,1,4,4>: Cost 4 vext1 <2,3,1,4>, RHS
  2624777526U,	// <3,1,4,5>: Cost 3 vext2 <1,2,3,1>, RHS
  2846279830U,	// <3,1,4,6>: Cost 3 vuzpr RHS, <3,0,1,2>
  3667784943U,	// <3,1,4,7>: Cost 4 vext1 <7,3,1,4>, <7,3,1,4>
  2624777769U,	// <3,1,4,u>: Cost 3 vext2 <1,2,3,1>, RHS
  2600018022U,	// <3,1,5,0>: Cost 3 vext1 <u,3,1,5>, LHS
  2600019088U,	// <3,1,5,1>: Cost 3 vext1 <u,3,1,5>, <1,5,3,7>
  2564187827U,	// <3,1,5,2>: Cost 3 vext1 <2,3,1,5>, <2,3,1,5>
  1659225232U,	// <3,1,5,3>: Cost 2 vext3 LHS, <1,5,3,7>
  2600021302U,	// <3,1,5,4>: Cost 3 vext1 <u,3,1,5>, RHS
  3719090180U,	// <3,1,5,5>: Cost 4 vext2 <4,6,3,1>, <5,5,5,5>
  3719090274U,	// <3,1,5,6>: Cost 4 vext2 <4,6,3,1>, <5,6,7,0>
  3923380374U,	// <3,1,5,7>: Cost 4 vuzpr <5,1,7,3>, <3,0,1,2>
  1659225277U,	// <3,1,5,u>: Cost 2 vext3 LHS, <1,5,u,7>
  3795797185U,	// <3,1,6,0>: Cost 4 vext3 <6,2,7,3>, <1,6,0,2>
  2732967119U,	// <3,1,6,1>: Cost 3 vext3 LHS, <1,6,1,7>
  3698520570U,	// <3,1,6,2>: Cost 4 vext2 <1,2,3,1>, <6,2,7,3>
  2732967132U,	// <3,1,6,3>: Cost 3 vext3 LHS, <1,6,3,2>
  3933128854U,	// <3,1,6,4>: Cost 4 vuzpr <6,7,4,5>, <3,0,1,2>
  2732967155U,	// <3,1,6,5>: Cost 3 vext3 LHS, <1,6,5,7>
  3719091000U,	// <3,1,6,6>: Cost 4 vext2 <4,6,3,1>, <6,6,6,6>
  2732967166U,	// <3,1,6,7>: Cost 3 vext3 LHS, <1,6,7,0>
  2732967175U,	// <3,1,6,u>: Cost 3 vext3 LHS, <1,6,u,0>
  3719091194U,	// <3,1,7,0>: Cost 4 vext2 <4,6,3,1>, <7,0,1,2>
  3934210198U,	// <3,1,7,1>: Cost 4 vuzpr <7,0,1,2>, <3,0,1,2>
  4001318032U,	// <3,1,7,2>: Cost 4 vzipl <7,0,1,2>, <1,5,3,7>
  2715419947U,	// <3,1,7,3>: Cost 3 vext3 <5,1,7,3>, <1,7,3,0>
  3719091558U,	// <3,1,7,4>: Cost 4 vext2 <4,6,3,1>, <7,4,5,6>
  3789161790U,	// <3,1,7,5>: Cost 4 vext3 <5,1,7,3>, <1,7,5,1>
  3806709062U,	// <3,1,7,6>: Cost 4 vext3 LHS, <1,7,6,0>
  3719091820U,	// <3,1,7,7>: Cost 4 vext2 <4,6,3,1>, <7,7,7,7>
  2732967256U,	// <3,1,7,u>: Cost 3 vext3 LHS, <1,7,u,0>
  2685633891U,	// <3,1,u,0>: Cost 3 vext3 LHS, <1,u,0,2>
  1611449140U,	// <3,1,u,1>: Cost 2 vext3 LHS, <1,1,1,1>
  2689836406U,	// <3,1,u,2>: Cost 3 vext3 LHS, <1,u,2,3>
  1611892092U,	// <3,1,u,3>: Cost 2 vext3 LHS, <1,u,3,0>
  2564214070U,	// <3,1,u,4>: Cost 3 vext1 <2,3,1,u>, RHS
  2624780442U,	// <3,1,u,5>: Cost 3 vext2 <1,2,3,1>, RHS
  2870167702U,	// <3,1,u,6>: Cost 3 vuzpr RHS, <3,0,1,2>
  2732967328U,	// <3,1,u,7>: Cost 3 vext3 LHS, <1,u,7,0>
  1616094633U,	// <3,1,u,u>: Cost 2 vext3 LHS, <1,u,u,0>
  2685633972U,	// <3,2,0,0>: Cost 3 vext3 LHS, <2,0,0,2>
  1549713510U,	// <3,2,0,1>: Cost 2 vext2 <1,0,3,2>, LHS
  2685633989U,	// <3,2,0,2>: Cost 3 vext3 LHS, <2,0,2,1>
  2886517654U,	// <3,2,0,3>: Cost 3 vzipl LHS, <1,2,3,0>
  2685634008U,	// <3,2,0,4>: Cost 3 vext3 LHS, <2,0,4,2>
  3759375841U,	// <3,2,0,5>: Cost 4 vext3 LHS, <2,0,5,2>
  2685634025U,	// <3,2,0,6>: Cost 3 vext3 LHS, <2,0,6,1>
  2229044964U,	// <3,2,0,7>: Cost 3 vrev <2,3,7,0>
  1549714077U,	// <3,2,0,u>: Cost 2 vext2 <1,0,3,2>, LHS
  1549714166U,	// <3,2,1,0>: Cost 2 vext2 <1,0,3,2>, <1,0,3,2>
  2623456052U,	// <3,2,1,1>: Cost 3 vext2 <1,0,3,2>, <1,1,1,1>
  2685634072U,	// <3,2,1,2>: Cost 3 vext3 LHS, <2,1,2,3>
  2685634081U,	// <3,2,1,3>: Cost 3 vext3 LHS, <2,1,3,3>
  2685634090U,	// <3,2,1,4>: Cost 3 vext3 LHS, <2,1,4,3>
  2228905683U,	// <3,2,1,5>: Cost 3 vrev <2,3,5,1>
  2733409852U,	// <3,2,1,6>: Cost 3 vext3 LHS, <2,1,6,3>
  3667834101U,	// <3,2,1,7>: Cost 4 vext1 <7,3,2,1>, <7,3,2,1>
  1155385070U,	// <3,2,1,u>: Cost 2 vrev <2,3,u,1>
  2685634134U,	// <3,2,2,0>: Cost 3 vext3 LHS, <2,2,0,2>
  2228618928U,	// <3,2,2,1>: Cost 3 vrev <2,3,1,2>
  1611449960U,	// <3,2,2,2>: Cost 2 vext3 LHS, <2,2,2,2>
  1611892338U,	// <3,2,2,3>: Cost 2 vext3 LHS, <2,2,3,3>
  2564238646U,	// <3,2,2,4>: Cost 3 vext1 <2,3,2,2>, RHS
  3763578499U,	// <3,2,2,5>: Cost 4 vext3 LHS, <2,2,5,2>
  2228987613U,	// <3,2,2,6>: Cost 3 vrev <2,3,6,2>
  3759376027U,	// <3,2,2,7>: Cost 4 vext3 LHS, <2,2,7,u>
  1611892383U,	// <3,2,2,u>: Cost 2 vext3 LHS, <2,2,u,3>
  1611450022U,	// <3,2,3,0>: Cost 2 vext3 LHS, <2,3,0,1>
  2685191854U,	// <3,2,3,1>: Cost 3 vext3 LHS, <2,3,1,0>
  2685191865U,	// <3,2,3,2>: Cost 3 vext3 LHS, <2,3,2,2>
  2685191875U,	// <3,2,3,3>: Cost 3 vext3 LHS, <2,3,3,3>
  1611450062U,	// <3,2,3,4>: Cost 2 vext3 LHS, <2,3,4,5>
  2689836755U,	// <3,2,3,5>: Cost 3 vext3 LHS, <2,3,5,1>
  2689836765U,	// <3,2,3,6>: Cost 3 vext3 LHS, <2,3,6,2>
  2732967652U,	// <3,2,3,7>: Cost 3 vext3 LHS, <2,3,7,0>
  1611450094U,	// <3,2,3,u>: Cost 2 vext3 LHS, <2,3,u,1>
  2685634296U,	// <3,2,4,0>: Cost 3 vext3 LHS, <2,4,0,2>
  2552308470U,	// <3,2,4,1>: Cost 3 vext1 <0,3,2,4>, <1,0,3,2>
  2732967692U,	// <3,2,4,2>: Cost 3 vext3 LHS, <2,4,2,4>
  2886517658U,	// <3,2,4,3>: Cost 3 vzipl LHS, <1,2,3,4>
  2228856525U,	// <3,2,4,4>: Cost 3 vrev <2,3,4,4>
  1549716790U,	// <3,2,4,5>: Cost 2 vext2 <1,0,3,2>, RHS
  2623458636U,	// <3,2,4,6>: Cost 3 vext2 <1,0,3,2>, <4,6,0,2>
  2229077736U,	// <3,2,4,7>: Cost 3 vrev <2,3,7,4>
  1549717033U,	// <3,2,4,u>: Cost 2 vext2 <1,0,3,2>, RHS
  2732967758U,	// <3,2,5,0>: Cost 3 vext3 LHS, <2,5,0,7>
  2623459024U,	// <3,2,5,1>: Cost 3 vext2 <1,0,3,2>, <5,1,7,3>
  2732967776U,	// <3,2,5,2>: Cost 3 vext3 LHS, <2,5,2,7>
  2732967779U,	// <3,2,5,3>: Cost 3 vext3 LHS, <2,5,3,1>
  1155122894U,	// <3,2,5,4>: Cost 2 vrev <2,3,4,5>
  2665263108U,	// <3,2,5,5>: Cost 3 vext2 <u,0,3,2>, <5,5,5,5>
  2665263202U,	// <3,2,5,6>: Cost 3 vext2 <u,0,3,2>, <5,6,7,0>
  3697201270U,	// <3,2,5,7>: Cost 4 vext2 <1,0,3,2>, <5,7,0,2>
  1155417842U,	// <3,2,5,u>: Cost 2 vrev <2,3,u,5>
  2600099942U,	// <3,2,6,0>: Cost 3 vext1 <u,3,2,6>, LHS
  3697201532U,	// <3,2,6,1>: Cost 4 vext2 <1,0,3,2>, <6,1,2,3>
  2623459834U,	// <3,2,6,2>: Cost 3 vext2 <1,0,3,2>, <6,2,7,3>
  1659226042U,	// <3,2,6,3>: Cost 2 vext3 LHS, <2,6,3,7>
  2228872911U,	// <3,2,6,4>: Cost 3 vrev <2,3,4,6>
  2228946648U,	// <3,2,6,5>: Cost 3 vrev <2,3,5,6>
  2665263928U,	// <3,2,6,6>: Cost 3 vext2 <u,0,3,2>, <6,6,6,6>
  2665263950U,	// <3,2,6,7>: Cost 3 vext2 <u,0,3,2>, <6,7,0,1>
  1659226087U,	// <3,2,6,u>: Cost 2 vext3 LHS, <2,6,u,7>
  2665264122U,	// <3,2,7,0>: Cost 3 vext2 <u,0,3,2>, <7,0,1,2>
  2623460419U,	// <3,2,7,1>: Cost 3 vext2 <1,0,3,2>, <7,1,0,3>
  3697202351U,	// <3,2,7,2>: Cost 4 vext2 <1,0,3,2>, <7,2,3,3>
  2722056196U,	// <3,2,7,3>: Cost 3 vext3 <6,2,7,3>, <2,7,3,0>
  2665264486U,	// <3,2,7,4>: Cost 3 vext2 <u,0,3,2>, <7,4,5,6>
  3302696665U,	// <3,2,7,5>: Cost 4 vrev <2,3,5,7>
  2229028578U,	// <3,2,7,6>: Cost 3 vrev <2,3,6,7>
  2665264748U,	// <3,2,7,7>: Cost 3 vext2 <u,0,3,2>, <7,7,7,7>
  2665264762U,	// <3,2,7,u>: Cost 3 vext2 <u,0,3,2>, <7,u,0,3>
  1611892795U,	// <3,2,u,0>: Cost 2 vext3 LHS, <2,u,0,1>
  1549719342U,	// <3,2,u,1>: Cost 2 vext2 <1,0,3,2>, LHS
  1611449960U,	// <3,2,u,2>: Cost 2 vext3 LHS, <2,2,2,2>
  1659226204U,	// <3,2,u,3>: Cost 2 vext3 LHS, <2,u,3,7>
  1611892835U,	// <3,2,u,4>: Cost 2 vext3 LHS, <2,u,4,5>
  1549719706U,	// <3,2,u,5>: Cost 2 vext2 <1,0,3,2>, RHS
  2685634674U,	// <3,2,u,6>: Cost 3 vext3 LHS, <2,u,6,2>
  2665265408U,	// <3,2,u,7>: Cost 3 vext2 <u,0,3,2>, <u,7,0,1>
  1611892867U,	// <3,2,u,u>: Cost 2 vext3 LHS, <2,u,u,1>
  2685192331U,	// <3,3,0,0>: Cost 3 vext3 LHS, <3,0,0,0>
  1611450518U,	// <3,3,0,1>: Cost 2 vext3 LHS, <3,0,1,2>
  2819410332U,	// <3,3,0,2>: Cost 3 vuzpr LHS, <3,3,3,3>
  2685634727U,	// <3,3,0,3>: Cost 3 vext3 LHS, <3,0,3,1>
  2685634736U,	// <3,3,0,4>: Cost 3 vext3 LHS, <3,0,4,1>
  2685634746U,	// <3,3,0,5>: Cost 3 vext3 LHS, <3,0,5,2>
  3763579074U,	// <3,3,0,6>: Cost 4 vext3 LHS, <3,0,6,1>
  3667899645U,	// <3,3,0,7>: Cost 4 vext1 <7,3,3,0>, <7,3,3,0>
  1611450581U,	// <3,3,0,u>: Cost 2 vext3 LHS, <3,0,u,2>
  2685192415U,	// <3,3,1,0>: Cost 3 vext3 LHS, <3,1,0,3>
  1550385992U,	// <3,3,1,1>: Cost 2 vext2 <1,1,3,3>, <1,1,3,3>
  2685192433U,	// <3,3,1,2>: Cost 3 vext3 LHS, <3,1,2,3>
  2685634810U,	// <3,3,1,3>: Cost 3 vext3 LHS, <3,1,3,3>
  2558332214U,	// <3,3,1,4>: Cost 3 vext1 <1,3,3,1>, RHS
  2685634828U,	// <3,3,1,5>: Cost 3 vext3 LHS, <3,1,5,3>
  3763579157U,	// <3,3,1,6>: Cost 4 vext3 LHS, <3,1,6,3>
  3789162782U,	// <3,3,1,7>: Cost 4 vext3 <5,1,7,3>, <3,1,7,3>
  1550385992U,	// <3,3,1,u>: Cost 2 vext2 <1,1,3,3>, <1,1,3,3>
  2685634864U,	// <3,3,2,0>: Cost 3 vext3 LHS, <3,2,0,3>
  2630100513U,	// <3,3,2,1>: Cost 3 vext2 <2,1,3,3>, <2,1,3,3>
  1557022322U,	// <3,3,2,2>: Cost 2 vext2 <2,2,3,3>, <2,2,3,3>
  2685192520U,	// <3,3,2,3>: Cost 3 vext3 LHS, <3,2,3,0>
  2685634900U,	// <3,3,2,4>: Cost 3 vext3 LHS, <3,2,4,3>
  2732968286U,	// <3,3,2,5>: Cost 3 vext3 LHS, <3,2,5,4>
  2732968294U,	// <3,3,2,6>: Cost 3 vext3 LHS, <3,2,6,3>
  2634082311U,	// <3,3,2,7>: Cost 3 vext2 <2,7,3,3>, <2,7,3,3>
  1557022322U,	// <3,3,2,u>: Cost 2 vext2 <2,2,3,3>, <2,2,3,3>
  1496547430U,	// <3,3,3,0>: Cost 2 vext1 <3,3,3,3>, LHS
  2624129256U,	// <3,3,3,1>: Cost 3 vext2 <1,1,3,3>, <3,1,1,3>
  2630764866U,	// <3,3,3,2>: Cost 3 vext2 <2,2,3,3>, <3,2,2,3>
  336380006U,	// <3,3,3,3>: Cost 1 vdup3 LHS
  1496550710U,	// <3,3,3,4>: Cost 2 vext1 <3,3,3,3>, RHS
  2570292944U,	// <3,3,3,5>: Cost 3 vext1 <3,3,3,3>, <5,1,7,3>
  2570293754U,	// <3,3,3,6>: Cost 3 vext1 <3,3,3,3>, <6,2,7,3>
  2594182400U,	// <3,3,3,7>: Cost 3 vext1 <7,3,3,3>, <7,3,3,3>
  336380006U,	// <3,3,3,u>: Cost 1 vdup3 LHS
  2689837524U,	// <3,3,4,0>: Cost 3 vext3 LHS, <3,4,0,5>
  2558354411U,	// <3,3,4,1>: Cost 3 vext1 <1,3,3,4>, <1,3,3,4>
  2564327108U,	// <3,3,4,2>: Cost 3 vext1 <2,3,3,4>, <2,3,3,4>
  2564327938U,	// <3,3,4,3>: Cost 3 vext1 <2,3,3,4>, <3,4,5,6>
  2893235098U,	// <3,3,4,4>: Cost 3 vzipl <1,2,3,4>, <1,2,3,4>
  1611893250U,	// <3,3,4,5>: Cost 2 vext3 LHS, <3,4,5,6>
  2689837573U,	// <3,3,4,6>: Cost 3 vext3 LHS, <3,4,6,0>
  3667932417U,	// <3,3,4,7>: Cost 4 vext1 <7,3,3,4>, <7,3,3,4>
  1611893277U,	// <3,3,4,u>: Cost 2 vext3 LHS, <3,4,u,6>
  2685635106U,	// <3,3,5,0>: Cost 3 vext3 LHS, <3,5,0,2>
  2689837616U,	// <3,3,5,1>: Cost 3 vext3 LHS, <3,5,1,7>
  2630766369U,	// <3,3,5,2>: Cost 3 vext2 <2,2,3,3>, <5,2,7,3>
  2732968512U,	// <3,3,5,3>: Cost 3 vext3 LHS, <3,5,3,5>
  2234837415U,	// <3,3,5,4>: Cost 3 vrev <3,3,4,5>
  3034171086U,	// <3,3,5,5>: Cost 3 vtrnl <2,3,4,5>, <2,3,4,5>
  2665934946U,	// <3,3,5,6>: Cost 3 vext2 <u,1,3,3>, <5,6,7,0>
  3763579487U,	// <3,3,5,7>: Cost 4 vext3 LHS, <3,5,7,0>
  2690280048U,	// <3,3,5,u>: Cost 3 vext3 LHS, <3,5,u,u>
  3763579507U,	// <3,3,6,0>: Cost 4 vext3 LHS, <3,6,0,2>
  3763579516U,	// <3,3,6,1>: Cost 4 vext3 LHS, <3,6,1,2>
  2689837706U,	// <3,3,6,2>: Cost 3 vext3 LHS, <3,6,2,7>
  2732968595U,	// <3,3,6,3>: Cost 3 vext3 LHS, <3,6,3,7>
  2732968604U,	// <3,3,6,4>: Cost 3 vext3 LHS, <3,6,4,7>
  3806710430U,	// <3,3,6,5>: Cost 4 vext3 LHS, <3,6,5,0>
  2665935672U,	// <3,3,6,6>: Cost 3 vext2 <u,1,3,3>, <6,6,6,6>
  2657973099U,	// <3,3,6,7>: Cost 3 vext2 <6,7,3,3>, <6,7,3,3>
  2690280128U,	// <3,3,6,u>: Cost 3 vext3 LHS, <3,6,u,7>
  2665935866U,	// <3,3,7,0>: Cost 3 vext2 <u,1,3,3>, <7,0,1,2>
  2624132172U,	// <3,3,7,1>: Cost 3 vext2 <1,1,3,3>, <7,1,1,3>
  2660627631U,	// <3,3,7,2>: Cost 3 vext2 <7,2,3,3>, <7,2,3,3>
  2661291264U,	// <3,3,7,3>: Cost 3 vext2 <7,3,3,3>, <7,3,3,3>
  2665936230U,	// <3,3,7,4>: Cost 3 vext2 <u,1,3,3>, <7,4,5,6>
  3937192348U,	// <3,3,7,5>: Cost 4 vuzpr <7,4,5,6>, <3,3,3,3>
  3795798778U,	// <3,3,7,6>: Cost 4 vext3 <6,2,7,3>, <3,7,6,2>
  2665936492U,	// <3,3,7,7>: Cost 3 vext2 <u,1,3,3>, <7,7,7,7>
  2664609429U,	// <3,3,7,u>: Cost 3 vext2 <7,u,3,3>, <7,u,3,3>
  1496547430U,	// <3,3,u,0>: Cost 2 vext1 <3,3,3,3>, LHS
  1611893534U,	// <3,3,u,1>: Cost 2 vext3 LHS, <3,u,1,2>
  1592858504U,	// <3,3,u,2>: Cost 2 vext2 <u,2,3,3>, <u,2,3,3>
  336380006U,	// <3,3,u,3>: Cost 1 vdup3 LHS
  1496550710U,	// <3,3,u,4>: Cost 2 vext1 <3,3,3,3>, RHS
  1611893574U,	// <3,3,u,5>: Cost 2 vext3 LHS, <3,u,5,6>
  2689837897U,	// <3,3,u,6>: Cost 3 vext3 LHS, <3,u,6,0>
  2732968793U,	// <3,3,u,7>: Cost 3 vext3 LHS, <3,u,7,7>
  336380006U,	// <3,3,u,u>: Cost 1 vdup3 LHS
  2685635429U,	// <3,4,0,0>: Cost 3 vext3 LHS, <4,0,0,1>
  1551056998U,	// <3,4,0,1>: Cost 2 vext2 <1,2,3,4>, LHS
  2624798884U,	// <3,4,0,2>: Cost 3 vext2 <1,2,3,4>, <0,2,0,2>
  3698540805U,	// <3,4,0,3>: Cost 4 vext2 <1,2,3,4>, <0,3,2,0>
  2564369298U,	// <3,4,0,4>: Cost 3 vext1 <2,3,4,0>, <4,0,5,1>
  1611893650U,	// <3,4,0,5>: Cost 2 vext3 LHS, <4,0,5,1>
  1611893660U,	// <3,4,0,6>: Cost 2 vext3 LHS, <4,0,6,2>
  3667973382U,	// <3,4,0,7>: Cost 4 vext1 <7,3,4,0>, <7,3,4,0>
  1611893677U,	// <3,4,0,u>: Cost 2 vext3 LHS, <4,0,u,1>
  2624799478U,	// <3,4,1,0>: Cost 3 vext2 <1,2,3,4>, <1,0,3,2>
  2624799540U,	// <3,4,1,1>: Cost 3 vext2 <1,2,3,4>, <1,1,1,1>
  1551057818U,	// <3,4,1,2>: Cost 2 vext2 <1,2,3,4>, <1,2,3,4>
  2625463275U,	// <3,4,1,3>: Cost 3 vext2 <1,3,3,4>, <1,3,3,4>
  2564377910U,	// <3,4,1,4>: Cost 3 vext1 <2,3,4,1>, RHS
  2732968930U,	// <3,4,1,5>: Cost 3 vext3 LHS, <4,1,5,0>
  2685635566U,	// <3,4,1,6>: Cost 3 vext3 LHS, <4,1,6,3>
  2628117807U,	// <3,4,1,7>: Cost 3 vext2 <1,7,3,4>, <1,7,3,4>
  1555039616U,	// <3,4,1,u>: Cost 2 vext2 <1,u,3,4>, <1,u,3,4>
  3759377422U,	// <3,4,2,0>: Cost 4 vext3 LHS, <4,2,0,u>
  2624800298U,	// <3,4,2,1>: Cost 3 vext2 <1,2,3,4>, <2,1,4,3>
  2624800360U,	// <3,4,2,2>: Cost 3 vext2 <1,2,3,4>, <2,2,2,2>
  2624800422U,	// <3,4,2,3>: Cost 3 vext2 <1,2,3,4>, <2,3,0,1>
  2733411373U,	// <3,4,2,4>: Cost 3 vext3 LHS, <4,2,4,3>
  2685635638U,	// <3,4,2,5>: Cost 3 vext3 LHS, <4,2,5,3>
  2710039615U,	// <3,4,2,6>: Cost 3 vext3 <4,2,6,3>, <4,2,6,3>
  2634090504U,	// <3,4,2,7>: Cost 3 vext2 <2,7,3,4>, <2,7,3,4>
  2685635665U,	// <3,4,2,u>: Cost 3 vext3 LHS, <4,2,u,3>
  2624800918U,	// <3,4,3,0>: Cost 3 vext2 <1,2,3,4>, <3,0,1,2>
  3698542814U,	// <3,4,3,1>: Cost 4 vext2 <1,2,3,4>, <3,1,0,2>
  2624801108U,	// <3,4,3,2>: Cost 3 vext2 <1,2,3,4>, <3,2,4,3>
  2624801180U,	// <3,4,3,3>: Cost 3 vext2 <1,2,3,4>, <3,3,3,3>
  2624801232U,	// <3,4,3,4>: Cost 3 vext2 <1,2,3,4>, <3,4,0,1>
  2710629511U,	// <3,4,3,5>: Cost 3 vext3 <4,3,5,3>, <4,3,5,3>
  2710703248U,	// <3,4,3,6>: Cost 3 vext3 <4,3,6,3>, <4,3,6,3>
  3667997961U,	// <3,4,3,7>: Cost 4 vext1 <7,3,4,3>, <7,3,4,3>
  2624801566U,	// <3,4,3,u>: Cost 3 vext2 <1,2,3,4>, <3,u,1,2>
  2624801682U,	// <3,4,4,0>: Cost 3 vext2 <1,2,3,4>, <4,0,5,1>
  2564400026U,	// <3,4,4,1>: Cost 3 vext1 <2,3,4,4>, <1,2,3,4>
  2564400845U,	// <3,4,4,2>: Cost 3 vext1 <2,3,4,4>, <2,3,4,4>
  2570373542U,	// <3,4,4,3>: Cost 3 vext1 <3,3,4,4>, <3,3,4,4>
  1659227344U,	// <3,4,4,4>: Cost 2 vext3 LHS, <4,4,4,4>
  1551060278U,	// <3,4,4,5>: Cost 2 vext2 <1,2,3,4>, RHS
  1659227364U,	// <3,4,4,6>: Cost 2 vext3 LHS, <4,4,6,6>
  3668006154U,	// <3,4,4,7>: Cost 4 vext1 <7,3,4,4>, <7,3,4,4>
  1551060521U,	// <3,4,4,u>: Cost 2 vext2 <1,2,3,4>, RHS
  1490665574U,	// <3,4,5,0>: Cost 2 vext1 <2,3,4,5>, LHS
  2624802512U,	// <3,4,5,1>: Cost 3 vext2 <1,2,3,4>, <5,1,7,3>
  1490667214U,	// <3,4,5,2>: Cost 2 vext1 <2,3,4,5>, <2,3,4,5>
  2564409494U,	// <3,4,5,3>: Cost 3 vext1 <2,3,4,5>, <3,0,1,2>
  1490668854U,	// <3,4,5,4>: Cost 2 vext1 <2,3,4,5>, RHS
  2564411088U,	// <3,4,5,5>: Cost 3 vext1 <2,3,4,5>, <5,1,7,3>
  537709878U,	// <3,4,5,6>: Cost 1 vext3 LHS, RHS
  2594272523U,	// <3,4,5,7>: Cost 3 vext1 <7,3,4,5>, <7,3,4,5>
  537709896U,	// <3,4,5,u>: Cost 1 vext3 LHS, RHS
  1611894092U,	// <3,4,6,0>: Cost 2 vext3 LHS, <4,6,0,2>
  2712325462U,	// <3,4,6,1>: Cost 3 vext3 <4,6,1,3>, <4,6,1,3>
  2624803322U,	// <3,4,6,2>: Cost 3 vext2 <1,2,3,4>, <6,2,7,3>
  2712472936U,	// <3,4,6,3>: Cost 3 vext3 <4,6,3,3>, <4,6,3,3>
  1659227508U,	// <3,4,6,4>: Cost 2 vext3 LHS, <4,6,4,6>
  2732969337U,	// <3,4,6,5>: Cost 3 vext3 LHS, <4,6,5,2>
  2732969344U,	// <3,4,6,6>: Cost 3 vext3 LHS, <4,6,6,0>
  2657981292U,	// <3,4,6,7>: Cost 3 vext2 <6,7,3,4>, <6,7,3,4>
  1659669908U,	// <3,4,6,u>: Cost 2 vext3 LHS, <4,6,u,2>
  2666607610U,	// <3,4,7,0>: Cost 3 vext2 <u,2,3,4>, <7,0,1,2>
  3733714015U,	// <3,4,7,1>: Cost 4 vext2 <7,1,3,4>, <7,1,3,4>
  2660635824U,	// <3,4,7,2>: Cost 3 vext2 <7,2,3,4>, <7,2,3,4>
  3725088011U,	// <3,4,7,3>: Cost 4 vext2 <5,6,3,4>, <7,3,4,5>
  2666607974U,	// <3,4,7,4>: Cost 3 vext2 <u,2,3,4>, <7,4,5,6>
  4054239946U,	// <3,4,7,5>: Cost 4 vzipr RHS, <3,7,0,u>
  2732969425U,	// <3,4,7,6>: Cost 3 vext3 LHS, <4,7,6,0>
  2666608236U,	// <3,4,7,7>: Cost 3 vext2 <u,2,3,4>, <7,7,7,7>
  2664617622U,	// <3,4,7,u>: Cost 3 vext2 <7,u,3,4>, <7,u,3,4>
  1611894254U,	// <3,4,u,0>: Cost 2 vext3 LHS, <4,u,0,2>
  1551062830U,	// <3,4,u,1>: Cost 2 vext2 <1,2,3,4>, LHS
  1490691793U,	// <3,4,u,2>: Cost 2 vext1 <2,3,4,u>, <2,3,4,u>
  2624804796U,	// <3,4,u,3>: Cost 3 vext2 <1,2,3,4>, <u,3,0,1>
  1490693430U,	// <3,4,u,4>: Cost 2 vext1 <2,3,4,u>, RHS
  1551063194U,	// <3,4,u,5>: Cost 2 vext2 <1,2,3,4>, RHS
  537710121U,	// <3,4,u,6>: Cost 1 vext3 LHS, RHS
  2594297102U,	// <3,4,u,7>: Cost 3 vext1 <7,3,4,u>, <7,3,4,u>
  537710139U,	// <3,4,u,u>: Cost 1 vext3 LHS, RHS
  3759377982U,	// <3,5,0,0>: Cost 4 vext3 LHS, <5,0,0,1>
  2685636167U,	// <3,5,0,1>: Cost 3 vext3 LHS, <5,0,1,1>
  2819410434U,	// <3,5,0,2>: Cost 3 vuzpr LHS, <3,4,5,6>
  3644156331U,	// <3,5,0,3>: Cost 4 vext1 <3,3,5,0>, <3,3,5,0>
  2689838690U,	// <3,5,0,4>: Cost 3 vext3 LHS, <5,0,4,1>
  2685636203U,	// <3,5,0,5>: Cost 3 vext3 LHS, <5,0,5,1>
  2685636212U,	// <3,5,0,6>: Cost 3 vext3 LHS, <5,0,6,1>
  2685636222U,	// <3,5,0,7>: Cost 3 vext3 LHS, <5,0,7,2>
  2685636231U,	// <3,5,0,u>: Cost 3 vext3 LHS, <5,0,u,2>
  2564448358U,	// <3,5,1,0>: Cost 3 vext1 <2,3,5,1>, LHS
  3899034114U,	// <3,5,1,1>: Cost 4 vuzpr <1,1,1,1>, <3,4,5,6>
  2564450003U,	// <3,5,1,2>: Cost 3 vext1 <2,3,5,1>, <2,3,5,1>
  3898526210U,	// <3,5,1,3>: Cost 4 vuzpr <1,0,3,2>, <3,4,5,6>
  2564451638U,	// <3,5,1,4>: Cost 3 vext1 <2,3,5,1>, RHS
  2564452048U,	// <3,5,1,5>: Cost 3 vext1 <2,3,5,1>, <5,1,7,3>
  3638194682U,	// <3,5,1,6>: Cost 4 vext1 <2,3,5,1>, <6,2,7,3>
  1611894480U,	// <3,5,1,7>: Cost 2 vext3 LHS, <5,1,7,3>
  1611894489U,	// <3,5,1,u>: Cost 2 vext3 LHS, <5,1,u,3>
  3906259458U,	// <3,5,2,0>: Cost 4 vuzpr <2,3,0,1>, <3,4,5,6>
  2685636336U,	// <3,5,2,1>: Cost 3 vext3 LHS, <5,2,1,u>
  3759378169U,	// <3,5,2,2>: Cost 4 vext3 LHS, <5,2,2,u>
  2632107726U,	// <3,5,2,3>: Cost 3 vext2 <2,4,3,5>, <2,3,4,5>
  2632107798U,	// <3,5,2,4>: Cost 3 vext2 <2,4,3,5>, <2,4,3,5>
  2733412111U,	// <3,5,2,5>: Cost 3 vext3 LHS, <5,2,5,3>
  2685636376U,	// <3,5,2,6>: Cost 3 vext3 LHS, <5,2,6,3>
  2689838880U,	// <3,5,2,7>: Cost 3 vext3 LHS, <5,2,7,2>
  2685636394U,	// <3,5,2,u>: Cost 3 vext3 LHS, <5,2,u,3>
  2576408678U,	// <3,5,3,0>: Cost 3 vext1 <4,3,5,3>, LHS
  3705850124U,	// <3,5,3,1>: Cost 4 vext2 <2,4,3,5>, <3,1,5,3>
  3702532445U,	// <3,5,3,2>: Cost 4 vext2 <1,u,3,5>, <3,2,5,3>
  2576411036U,	// <3,5,3,3>: Cost 3 vext1 <4,3,5,3>, <3,3,3,3>
  2638744066U,	// <3,5,3,4>: Cost 3 vext2 <3,5,3,5>, <3,4,5,6>
  2839562754U,	// <3,5,3,5>: Cost 3 vuzpr <3,4,5,6>, <3,4,5,6>
  3980411720U,	// <3,5,3,6>: Cost 4 vzipl <3,4,5,6>, <1,1,3,3>
  3047606684U,	// <3,5,3,7>: Cost 3 vtrnl RHS, <3,3,3,3>
  2576414510U,	// <3,5,3,u>: Cost 3 vext1 <4,3,5,3>, LHS
  2600304742U,	// <3,5,4,0>: Cost 3 vext1 <u,3,5,4>, LHS
  2715422607U,	// <3,5,4,1>: Cost 3 vext3 <5,1,7,3>, <5,4,1,5>
  2564474582U,	// <3,5,4,2>: Cost 3 vext1 <2,3,5,4>, <2,3,5,4>
  3705851012U,	// <3,5,4,3>: Cost 4 vext2 <2,4,3,5>, <4,3,5,0>
  2600308022U,	// <3,5,4,4>: Cost 3 vext1 <u,3,5,4>, RHS
  2628791606U,	// <3,5,4,5>: Cost 3 vext2 <1,u,3,5>, RHS
  2846280194U,	// <3,5,4,6>: Cost 3 vuzpr RHS, <3,4,5,6>
  1659228102U,	// <3,5,4,7>: Cost 2 vext3 LHS, <5,4,7,6>
  1659228111U,	// <3,5,4,u>: Cost 2 vext3 LHS, <5,4,u,6>
  2570453094U,	// <3,5,5,0>: Cost 3 vext1 <3,3,5,5>, LHS
  2628792016U,	// <3,5,5,1>: Cost 3 vext2 <1,u,3,5>, <5,1,7,3>
  2570454734U,	// <3,5,5,2>: Cost 3 vext1 <3,3,5,5>, <2,3,4,5>
  2570455472U,	// <3,5,5,3>: Cost 3 vext1 <3,3,5,5>, <3,3,5,5>
  2570456374U,	// <3,5,5,4>: Cost 3 vext1 <3,3,5,5>, RHS
  1659228164U,	// <3,5,5,5>: Cost 2 vext3 LHS, <5,5,5,5>
  2732969998U,	// <3,5,5,6>: Cost 3 vext3 LHS, <5,5,6,6>
  1659228184U,	// <3,5,5,7>: Cost 2 vext3 LHS, <5,5,7,7>
  1659228193U,	// <3,5,5,u>: Cost 2 vext3 LHS, <5,5,u,7>
  2732970020U,	// <3,5,6,0>: Cost 3 vext3 LHS, <5,6,0,1>
  2732970035U,	// <3,5,6,1>: Cost 3 vext3 LHS, <5,6,1,7>
  2564490968U,	// <3,5,6,2>: Cost 3 vext1 <2,3,5,6>, <2,3,5,6>
  2732970050U,	// <3,5,6,3>: Cost 3 vext3 LHS, <5,6,3,4>
  2732970060U,	// <3,5,6,4>: Cost 3 vext3 LHS, <5,6,4,5>
  2732970071U,	// <3,5,6,5>: Cost 3 vext3 LHS, <5,6,5,7>
  2732970080U,	// <3,5,6,6>: Cost 3 vext3 LHS, <5,6,6,7>
  1659228258U,	// <3,5,6,7>: Cost 2 vext3 LHS, <5,6,7,0>
  1659228267U,	// <3,5,6,u>: Cost 2 vext3 LHS, <5,6,u,0>
  2685636726U,	// <3,5,7,0>: Cost 3 vext3 LHS, <5,7,0,2>
  3789164670U,	// <3,5,7,1>: Cost 4 vext3 <5,1,7,3>, <5,7,1,1>
  3702535348U,	// <3,5,7,2>: Cost 4 vext2 <1,u,3,5>, <7,2,3,u>
  3719124235U,	// <3,5,7,3>: Cost 4 vext2 <4,6,3,5>, <7,3,4,5>
  2715422878U,	// <3,5,7,4>: Cost 3 vext3 <5,1,7,3>, <5,7,4,6>
  2732970152U,	// <3,5,7,5>: Cost 3 vext3 LHS, <5,7,5,7>
  3793072301U,	// <3,5,7,6>: Cost 4 vext3 <5,7,6,3>, <5,7,6,3>
  2732970163U,	// <3,5,7,7>: Cost 3 vext3 LHS, <5,7,7,0>
  2732970172U,	// <3,5,7,u>: Cost 3 vext3 LHS, <5,7,u,0>
  2685636807U,	// <3,5,u,0>: Cost 3 vext3 LHS, <5,u,0,2>
  2689839313U,	// <3,5,u,1>: Cost 3 vext3 LHS, <5,u,1,3>
  2867186178U,	// <3,5,u,2>: Cost 3 vuzpr LHS, <3,4,5,6>
  2732970212U,	// <3,5,u,3>: Cost 3 vext3 LHS, <5,u,3,4>
  2594368822U,	// <3,5,u,4>: Cost 3 vext1 <7,3,5,u>, RHS
  1659228164U,	// <3,5,u,5>: Cost 2 vext3 LHS, <5,5,5,5>
  2689839358U,	// <3,5,u,6>: Cost 3 vext3 LHS, <5,u,6,3>
  1616539911U,	// <3,5,u,7>: Cost 2 vext3 LHS, <5,u,7,3>
  1616539920U,	// <3,5,u,u>: Cost 2 vext3 LHS, <5,u,u,3>
  3759378711U,	// <3,6,0,0>: Cost 4 vext3 LHS, <6,0,0,1>
  2628796518U,	// <3,6,0,1>: Cost 3 vext2 <1,u,3,6>, LHS
  2685636905U,	// <3,6,0,2>: Cost 3 vext3 LHS, <6,0,2,1>
  3650202069U,	// <3,6,0,3>: Cost 4 vext1 <4,3,6,0>, <3,4,0,6>
  2689839420U,	// <3,6,0,4>: Cost 3 vext3 LHS, <6,0,4,2>
  3656175462U,	// <3,6,0,5>: Cost 4 vext1 <5,3,6,0>, <5,3,6,0>
  2732970316U,	// <3,6,0,6>: Cost 3 vext3 LHS, <6,0,6,0>
  2685636951U,	// <3,6,0,7>: Cost 3 vext3 LHS, <6,0,7,2>
  2685636960U,	// <3,6,0,u>: Cost 3 vext3 LHS, <6,0,u,2>
  2576466022U,	// <3,6,1,0>: Cost 3 vext1 <4,3,6,1>, LHS
  3699221320U,	// <3,6,1,1>: Cost 4 vext2 <1,3,3,6>, <1,1,3,3>
  2685636988U,	// <3,6,1,2>: Cost 3 vext3 LHS, <6,1,2,3>
  2576468118U,	// <3,6,1,3>: Cost 3 vext1 <4,3,6,1>, <3,0,1,2>
  2576469134U,	// <3,6,1,4>: Cost 3 vext1 <4,3,6,1>, <4,3,6,1>
  3650211536U,	// <3,6,1,5>: Cost 4 vext1 <4,3,6,1>, <5,1,7,3>
  2733412768U,	// <3,6,1,6>: Cost 3 vext3 LHS, <6,1,6,3>
  2732970407U,	// <3,6,1,7>: Cost 3 vext3 LHS, <6,1,7,1>
  2689839538U,	// <3,6,1,u>: Cost 3 vext3 LHS, <6,1,u,3>
  2564530278U,	// <3,6,2,0>: Cost 3 vext1 <2,3,6,2>, LHS
  3759378889U,	// <3,6,2,1>: Cost 4 vext3 LHS, <6,2,1,u>
  2685637074U,	// <3,6,2,2>: Cost 3 vext3 LHS, <6,2,2,u>
  3759378902U,	// <3,6,2,3>: Cost 4 vext3 LHS, <6,2,3,3>
  2564533558U,	// <3,6,2,4>: Cost 3 vext1 <2,3,6,2>, RHS
  2632779624U,	// <3,6,2,5>: Cost 3 vext2 <2,5,3,6>, <2,5,3,6>
  2564534778U,	// <3,6,2,6>: Cost 3 vext1 <2,3,6,2>, <6,2,7,3>
  1611895290U,	// <3,6,2,7>: Cost 2 vext3 LHS, <6,2,7,3>
  1611895299U,	// <3,6,2,u>: Cost 2 vext3 LHS, <6,2,u,3>
  2576482406U,	// <3,6,3,0>: Cost 3 vext1 <4,3,6,3>, LHS
  3650224886U,	// <3,6,3,1>: Cost 4 vext1 <4,3,6,3>, <1,0,3,2>
  3702540646U,	// <3,6,3,2>: Cost 4 vext2 <1,u,3,6>, <3,2,6,3>
  2576484764U,	// <3,6,3,3>: Cost 3 vext1 <4,3,6,3>, <3,3,3,3>
  2576485520U,	// <3,6,3,4>: Cost 3 vext1 <4,3,6,3>, <4,3,6,3>
  3712494145U,	// <3,6,3,5>: Cost 4 vext2 <3,5,3,6>, <3,5,3,6>
  3702540914U,	// <3,6,3,6>: Cost 4 vext2 <1,u,3,6>, <3,6,0,1>
  2913387336U,	// <3,6,3,7>: Cost 3 vzipl RHS, <1,1,3,3>
  2576488238U,	// <3,6,3,u>: Cost 3 vext1 <4,3,6,3>, LHS
  2685637212U,	// <3,6,4,0>: Cost 3 vext3 LHS, <6,4,0,2>
  3783119465U,	// <3,6,4,1>: Cost 4 vext3 <4,1,6,3>, <6,4,1,6>
  2722058865U,	// <3,6,4,2>: Cost 3 vext3 <6,2,7,3>, <6,4,2,5>
  3650234882U,	// <3,6,4,3>: Cost 4 vext1 <4,3,6,4>, <3,4,5,6>
  2732970628U,	// <3,6,4,4>: Cost 3 vext3 LHS, <6,4,4,6>
  2628799798U,	// <3,6,4,5>: Cost 3 vext2 <1,u,3,6>, RHS
  2732970640U,	// <3,6,4,6>: Cost 3 vext3 LHS, <6,4,6,0>
  2913387418U,	// <3,6,4,7>: Cost 3 vzipl RHS, <1,2,3,4>
  2628800041U,	// <3,6,4,u>: Cost 3 vext2 <1,u,3,6>, RHS
  2576498790U,	// <3,6,5,0>: Cost 3 vext1 <4,3,6,5>, LHS
  3702542032U,	// <3,6,5,1>: Cost 4 vext2 <1,u,3,6>, <5,1,7,3>
  2732970692U,	// <3,6,5,2>: Cost 3 vext3 LHS, <6,5,2,7>
  2576501250U,	// <3,6,5,3>: Cost 3 vext1 <4,3,6,5>, <3,4,5,6>
  2576501906U,	// <3,6,5,4>: Cost 3 vext1 <4,3,6,5>, <4,3,6,5>
  3650244304U,	// <3,6,5,5>: Cost 4 vext1 <4,3,6,5>, <5,1,7,3>
  2732970728U,	// <3,6,5,6>: Cost 3 vext3 LHS, <6,5,6,7>
  2732970731U,	// <3,6,5,7>: Cost 3 vext3 LHS, <6,5,7,1>
  2576504622U,	// <3,6,5,u>: Cost 3 vext1 <4,3,6,5>, LHS
  2732970749U,	// <3,6,6,0>: Cost 3 vext3 LHS, <6,6,0,1>
  3806712581U,	// <3,6,6,1>: Cost 4 vext3 LHS, <6,6,1,0>
  2628801018U,	// <3,6,6,2>: Cost 3 vext2 <1,u,3,6>, <6,2,7,3>
  3650251269U,	// <3,6,6,3>: Cost 4 vext1 <4,3,6,6>, <3,4,6,0>
  2732970788U,	// <3,6,6,4>: Cost 3 vext3 LHS, <6,6,4,4>
  3668168400U,	// <3,6,6,5>: Cost 4 vext1 <7,3,6,6>, <5,1,7,3>
  1659228984U,	// <3,6,6,6>: Cost 2 vext3 LHS, <6,6,6,6>
  1659228994U,	// <3,6,6,7>: Cost 2 vext3 LHS, <6,6,7,7>
  1659229003U,	// <3,6,6,u>: Cost 2 vext3 LHS, <6,6,u,7>
  1659229006U,	// <3,6,7,0>: Cost 2 vext3 LHS, <6,7,0,1>
  2732970838U,	// <3,6,7,1>: Cost 3 vext3 LHS, <6,7,1,0>
  2725008226U,	// <3,6,7,2>: Cost 3 vext3 <6,7,2,3>, <6,7,2,3>
  2725081963U,	// <3,6,7,3>: Cost 3 vext3 <6,7,3,3>, <6,7,3,3>
  1659229046U,	// <3,6,7,4>: Cost 2 vext3 LHS, <6,7,4,5>
  2715423611U,	// <3,6,7,5>: Cost 3 vext3 <5,1,7,3>, <6,7,5,1>
  2722059141U,	// <3,6,7,6>: Cost 3 vext3 <6,2,7,3>, <6,7,6,2>
  2913388474U,	// <3,6,7,7>: Cost 3 vzipl RHS, <2,6,3,7>
  1659229078U,	// <3,6,7,u>: Cost 2 vext3 LHS, <6,7,u,1>
  1659229087U,	// <3,6,u,0>: Cost 2 vext3 LHS, <6,u,0,1>
  2628802350U,	// <3,6,u,1>: Cost 3 vext2 <1,u,3,6>, LHS
  2689840051U,	// <3,6,u,2>: Cost 3 vext3 LHS, <6,u,2,3>
  2576525853U,	// <3,6,u,3>: Cost 3 vext1 <4,3,6,u>, <3,4,u,6>
  1659229127U,	// <3,6,u,4>: Cost 2 vext3 LHS, <6,u,4,5>
  2628802714U,	// <3,6,u,5>: Cost 3 vext2 <1,u,3,6>, RHS
  1659228984U,	// <3,6,u,6>: Cost 2 vext3 LHS, <6,6,6,6>
  1616098272U,	// <3,6,u,7>: Cost 2 vext3 LHS, <6,u,7,3>
  1616098281U,	// <3,6,u,u>: Cost 2 vext3 LHS, <6,u,u,3>
  2588475494U,	// <3,7,0,0>: Cost 3 vext1 <6,3,7,0>, LHS
  1659229178U,	// <3,7,0,1>: Cost 2 vext3 LHS, <7,0,1,2>
  2732971009U,	// <3,7,0,2>: Cost 3 vext3 LHS, <7,0,2,0>
  3759379468U,	// <3,7,0,3>: Cost 4 vext3 LHS, <7,0,3,2>
  2588478774U,	// <3,7,0,4>: Cost 3 vext1 <6,3,7,0>, RHS
  2732971042U,	// <3,7,0,5>: Cost 3 vext3 LHS, <7,0,5,6>
  2588480072U,	// <3,7,0,6>: Cost 3 vext1 <6,3,7,0>, <6,3,7,0>
  2600424442U,	// <3,7,0,7>: Cost 3 vext1 <u,3,7,0>, <7,0,1,2>
  1659229241U,	// <3,7,0,u>: Cost 2 vext3 LHS, <7,0,u,2>
  2582511718U,	// <3,7,1,0>: Cost 3 vext1 <5,3,7,1>, LHS
  2726925388U,	// <3,7,1,1>: Cost 3 vext3 <7,1,1,3>, <7,1,1,3>
  2582513318U,	// <3,7,1,2>: Cost 3 vext1 <5,3,7,1>, <2,3,0,1>
  3789165661U,	// <3,7,1,3>: Cost 4 vext3 <5,1,7,3>, <7,1,3,2>
  2582514998U,	// <3,7,1,4>: Cost 3 vext1 <5,3,7,1>, RHS
  1553073296U,	// <3,7,1,5>: Cost 2 vext2 <1,5,3,7>, <1,5,3,7>
  2627478753U,	// <3,7,1,6>: Cost 3 vext2 <1,6,3,7>, <1,6,3,7>
  2732971136U,	// <3,7,1,7>: Cost 3 vext3 LHS, <7,1,7,1>
  1555064195U,	// <3,7,1,u>: Cost 2 vext2 <1,u,3,7>, <1,u,3,7>
  2588491878U,	// <3,7,2,0>: Cost 3 vext1 <6,3,7,2>, LHS
  2588492534U,	// <3,7,2,1>: Cost 3 vext1 <6,3,7,2>, <1,0,3,2>
  2727662758U,	// <3,7,2,2>: Cost 3 vext3 <7,2,2,3>, <7,2,2,3>
  2685637807U,	// <3,7,2,3>: Cost 3 vext3 LHS, <7,2,3,3>
  2588495158U,	// <3,7,2,4>: Cost 3 vext1 <6,3,7,2>, RHS
  2632787817U,	// <3,7,2,5>: Cost 3 vext2 <2,5,3,7>, <2,5,3,7>
  1559709626U,	// <3,7,2,6>: Cost 2 vext2 <2,6,3,7>, <2,6,3,7>
  2733413587U,	// <3,7,2,7>: Cost 3 vext3 LHS, <7,2,7,3>
  1561036892U,	// <3,7,2,u>: Cost 2 vext2 <2,u,3,7>, <2,u,3,7>
  2582528102U,	// <3,7,3,0>: Cost 3 vext1 <5,3,7,3>, LHS
  2588500808U,	// <3,7,3,1>: Cost 3 vext1 <6,3,7,3>, <1,1,3,3>
  2633451878U,	// <3,7,3,2>: Cost 3 vext2 <2,6,3,7>, <3,2,6,3>
  2582530460U,	// <3,7,3,3>: Cost 3 vext1 <5,3,7,3>, <3,3,3,3>
  2582531382U,	// <3,7,3,4>: Cost 3 vext1 <5,3,7,3>, RHS
  2715424016U,	// <3,7,3,5>: Cost 3 vext3 <5,1,7,3>, <7,3,5,1>
  2722059546U,	// <3,7,3,6>: Cost 3 vext3 <6,2,7,3>, <7,3,6,2>
  2626816720U,	// <3,7,3,7>: Cost 3 vext2 <1,5,3,7>, <3,7,1,5>
  2582533934U,	// <3,7,3,u>: Cost 3 vext1 <5,3,7,3>, LHS
  2588508262U,	// <3,7,4,0>: Cost 3 vext1 <6,3,7,4>, LHS
  2588509082U,	// <3,7,4,1>: Cost 3 vext1 <6,3,7,4>, <1,2,3,4>
  2564622056U,	// <3,7,4,2>: Cost 3 vext1 <2,3,7,4>, <2,3,7,4>
  3990487962U,	// <3,7,4,3>: Cost 4 vzipl <5,1,7,3>, <1,2,3,4>
  2588511542U,	// <3,7,4,4>: Cost 3 vext1 <6,3,7,4>, RHS
  1659229542U,	// <3,7,4,5>: Cost 2 vext3 LHS, <7,4,5,6>
  2588512844U,	// <3,7,4,6>: Cost 3 vext1 <6,3,7,4>, <6,3,7,4>
  2732971383U,	// <3,7,4,7>: Cost 3 vext3 LHS, <7,4,7,5>
  1659229569U,	// <3,7,4,u>: Cost 2 vext3 LHS, <7,4,u,6>
  2582544486U,	// <3,7,5,0>: Cost 3 vext1 <5,3,7,5>, LHS
  2715424148U,	// <3,7,5,1>: Cost 3 vext3 <5,1,7,3>, <7,5,1,7>
  2582546126U,	// <3,7,5,2>: Cost 3 vext1 <5,3,7,5>, <2,3,4,5>
  2668621679U,	// <3,7,5,3>: Cost 3 vext2 <u,5,3,7>, <5,3,7,0>
  2582547766U,	// <3,7,5,4>: Cost 3 vext1 <5,3,7,5>, RHS
  2582548340U,	// <3,7,5,5>: Cost 3 vext1 <5,3,7,5>, <5,3,7,5>
  2732971457U,	// <3,7,5,6>: Cost 3 vext3 LHS, <7,5,6,7>
  2732971466U,	// <3,7,5,7>: Cost 3 vext3 LHS, <7,5,7,7>
  2582550318U,	// <3,7,5,u>: Cost 3 vext1 <5,3,7,5>, LHS
  2732971478U,	// <3,7,6,0>: Cost 3 vext3 LHS, <7,6,0,1>
  2732971486U,	// <3,7,6,1>: Cost 3 vext3 LHS, <7,6,1,0>
  2722059758U,	// <3,7,6,2>: Cost 3 vext3 <6,2,7,3>, <7,6,2,7>
  2669285960U,	// <3,7,6,3>: Cost 3 vext2 <u,6,3,7>, <6,3,7,0>
  2732971518U,	// <3,7,6,4>: Cost 3 vext3 LHS, <7,6,4,5>
  2732971526U,	// <3,7,6,5>: Cost 3 vext3 LHS, <7,6,5,4>
  2732971537U,	// <3,7,6,6>: Cost 3 vext3 LHS, <7,6,6,6>
  2732971540U,	// <3,7,6,7>: Cost 3 vext3 LHS, <7,6,7,0>
  2726041124U,	// <3,7,6,u>: Cost 3 vext3 <6,u,7,3>, <7,6,u,7>
  2732971559U,	// <3,7,7,0>: Cost 3 vext3 LHS, <7,7,0,1>
  2626819184U,	// <3,7,7,1>: Cost 3 vext2 <1,5,3,7>, <7,1,5,3>
  2564646635U,	// <3,7,7,2>: Cost 3 vext1 <2,3,7,7>, <2,3,7,7>
  3990488208U,	// <3,7,7,3>: Cost 4 vzipl <5,1,7,3>, <1,5,3,7>
  2732971599U,	// <3,7,7,4>: Cost 3 vext3 LHS, <7,7,4,5>
  2732971608U,	// <3,7,7,5>: Cost 3 vext3 LHS, <7,7,5,5>
  2732971618U,	// <3,7,7,6>: Cost 3 vext3 LHS, <7,7,6,6>
  1659229804U,	// <3,7,7,7>: Cost 2 vext3 LHS, <7,7,7,7>
  1659229804U,	// <3,7,7,u>: Cost 2 vext3 LHS, <7,7,7,7>
  2582569062U,	// <3,7,u,0>: Cost 3 vext1 <5,3,7,u>, LHS
  1659229826U,	// <3,7,u,1>: Cost 2 vext3 LHS, <7,u,1,2>
  2582570669U,	// <3,7,u,2>: Cost 3 vext1 <5,3,7,u>, <2,3,0,u>
  2689840789U,	// <3,7,u,3>: Cost 3 vext3 LHS, <7,u,3,3>
  2582572342U,	// <3,7,u,4>: Cost 3 vext1 <5,3,7,u>, RHS
  1659229866U,	// <3,7,u,5>: Cost 2 vext3 LHS, <7,u,5,6>
  1595545808U,	// <3,7,u,6>: Cost 2 vext2 <u,6,3,7>, <u,6,3,7>
  1659229804U,	// <3,7,u,7>: Cost 2 vext3 LHS, <7,7,7,7>
  1659229889U,	// <3,7,u,u>: Cost 2 vext3 LHS, <7,u,u,2>
  1611448320U,	// <3,u,0,0>: Cost 2 vext3 LHS, <0,0,0,0>
  1611896530U,	// <3,u,0,1>: Cost 2 vext3 LHS, <u,0,1,1>
  1611896540U,	// <3,u,0,2>: Cost 2 vext3 LHS, <u,0,2,2>
  1616099045U,	// <3,u,0,3>: Cost 2 vext3 LHS, <u,0,3,2>
  2685638381U,	// <3,u,0,4>: Cost 3 vext3 LHS, <u,0,4,1>
  1611896566U,	// <3,u,0,5>: Cost 2 vext3 LHS, <u,0,5,1>
  1611896576U,	// <3,u,0,6>: Cost 2 vext3 LHS, <u,0,6,2>
  2685638409U,	// <3,u,0,7>: Cost 3 vext3 LHS, <u,0,7,2>
  1611896593U,	// <3,u,0,u>: Cost 2 vext3 LHS, <u,0,u,1>
  1549763324U,	// <3,u,1,0>: Cost 2 vext2 <1,0,3,u>, <1,0,3,u>
  1550426957U,	// <3,u,1,1>: Cost 2 vext2 <1,1,3,u>, <1,1,3,u>
  537712430U,	// <3,u,1,2>: Cost 1 vext3 LHS, LHS
  1611896631U,	// <3,u,1,3>: Cost 2 vext3 LHS, <u,1,3,3>
  1490930998U,	// <3,u,1,4>: Cost 2 vext1 <2,3,u,1>, RHS
  1553081489U,	// <3,u,1,5>: Cost 2 vext2 <1,5,3,u>, <1,5,3,u>
  2685638482U,	// <3,u,1,6>: Cost 3 vext3 LHS, <u,1,6,3>
  1611896667U,	// <3,u,1,7>: Cost 2 vext3 LHS, <u,1,7,3>
  537712484U,	// <3,u,1,u>: Cost 1 vext3 LHS, LHS
  1611896684U,	// <3,u,2,0>: Cost 2 vext3 LHS, <u,2,0,2>
  2685638518U,	// <3,u,2,1>: Cost 3 vext3 LHS, <u,2,1,3>
  1557063287U,	// <3,u,2,2>: Cost 2 vext2 <2,2,3,u>, <2,2,3,u>
  1611896712U,	// <3,u,2,3>: Cost 2 vext3 LHS, <u,2,3,3>
  1659230100U,	// <3,u,2,4>: Cost 2 vext3 LHS, <u,2,4,6>
  2685638554U,	// <3,u,2,5>: Cost 3 vext3 LHS, <u,2,5,3>
  1559717819U,	// <3,u,2,6>: Cost 2 vext2 <2,6,3,u>, <2,6,3,u>
  1611896748U,	// <3,u,2,7>: Cost 2 vext3 LHS, <u,2,7,3>
  1611896757U,	// <3,u,2,u>: Cost 2 vext3 LHS, <u,2,u,3>
  1611896764U,	// <3,u,3,0>: Cost 2 vext3 LHS, <u,3,0,1>
  2685638596U,	// <3,u,3,1>: Cost 3 vext3 LHS, <u,3,1,0>
  2685638607U,	// <3,u,3,2>: Cost 3 vext3 LHS, <u,3,2,2>
  336380006U,	// <3,u,3,3>: Cost 1 vdup3 LHS
  1611896804U,	// <3,u,3,4>: Cost 2 vext3 LHS, <u,3,4,5>
  2685638633U,	// <3,u,3,5>: Cost 3 vext3 LHS, <u,3,5,1>
  2685638643U,	// <3,u,3,6>: Cost 3 vext3 LHS, <u,3,6,2>
  2913534792U,	// <3,u,3,7>: Cost 3 vzipl RHS, <1,1,3,3>
  336380006U,	// <3,u,3,u>: Cost 1 vdup3 LHS
  2685638673U,	// <3,u,4,0>: Cost 3 vext3 LHS, <u,4,0,5>
  1659230234U,	// <3,u,4,1>: Cost 2 vext3 LHS, <u,4,1,5>
  1659230244U,	// <3,u,4,2>: Cost 2 vext3 LHS, <u,4,2,6>
  2886960026U,	// <3,u,4,3>: Cost 3 vzipl LHS, <1,2,3,4>
  1659227344U,	// <3,u,4,4>: Cost 2 vext3 LHS, <4,4,4,4>
  1611896895U,	// <3,u,4,5>: Cost 2 vext3 LHS, <u,4,5,6>
  1659230280U,	// <3,u,4,6>: Cost 2 vext3 LHS, <u,4,6,6>
  1659230289U,	// <3,u,4,7>: Cost 2 vext3 LHS, <u,4,7,6>
  1611896922U,	// <3,u,4,u>: Cost 2 vext3 LHS, <u,4,u,6>
  1490960486U,	// <3,u,5,0>: Cost 2 vext1 <2,3,u,5>, LHS
  2685638765U,	// <3,u,5,1>: Cost 3 vext3 LHS, <u,5,1,7>
  1490962162U,	// <3,u,5,2>: Cost 2 vext1 <2,3,u,5>, <2,3,u,5>
  1659230335U,	// <3,u,5,3>: Cost 2 vext3 LHS, <u,5,3,7>
  1490963766U,	// <3,u,5,4>: Cost 2 vext1 <2,3,u,5>, RHS
  1659228164U,	// <3,u,5,5>: Cost 2 vext3 LHS, <5,5,5,5>
  537712794U,	// <3,u,5,6>: Cost 1 vext3 LHS, RHS
  1659230371U,	// <3,u,5,7>: Cost 2 vext3 LHS, <u,5,7,7>
  537712812U,	// <3,u,5,u>: Cost 1 vext3 LHS, RHS
  1611897008U,	// <3,u,6,0>: Cost 2 vext3 LHS, <u,6,0,2>
  2732972215U,	// <3,u,6,1>: Cost 3 vext3 LHS, <u,6,1,0>
  2685638855U,	// <3,u,6,2>: Cost 3 vext3 LHS, <u,6,2,7>
  1659230416U,	// <3,u,6,3>: Cost 2 vext3 LHS, <u,6,3,7>
  1659230424U,	// <3,u,6,4>: Cost 2 vext3 LHS, <u,6,4,6>
  2732972255U,	// <3,u,6,5>: Cost 3 vext3 LHS, <u,6,5,4>
  1659228984U,	// <3,u,6,6>: Cost 2 vext3 LHS, <6,6,6,6>
  1659230445U,	// <3,u,6,7>: Cost 2 vext3 LHS, <u,6,7,0>
  1659230454U,	// <3,u,6,u>: Cost 2 vext3 LHS, <u,6,u,0>
  1659230464U,	// <3,u,7,0>: Cost 2 vext3 LHS, <u,7,0,1>
  2732972296U,	// <3,u,7,1>: Cost 3 vext3 LHS, <u,7,1,0>
  2660668596U,	// <3,u,7,2>: Cost 3 vext2 <7,2,3,u>, <7,2,3,u>
  2720069919U,	// <3,u,7,3>: Cost 3 vext3 <5,u,7,3>, <u,7,3,5>
  1659230504U,	// <3,u,7,4>: Cost 2 vext3 LHS, <u,7,4,5>
  2715425069U,	// <3,u,7,5>: Cost 3 vext3 <5,1,7,3>, <u,7,5,1>
  2722060599U,	// <3,u,7,6>: Cost 3 vext3 <6,2,7,3>, <u,7,6,2>
  1659229804U,	// <3,u,7,7>: Cost 2 vext3 LHS, <7,7,7,7>
  1659230536U,	// <3,u,7,u>: Cost 2 vext3 LHS, <u,7,u,1>
  1611897170U,	// <3,u,u,0>: Cost 2 vext3 LHS, <u,u,0,2>
  1611897179U,	// <3,u,u,1>: Cost 2 vext3 LHS, <u,u,1,2>
  537712997U,	// <3,u,u,2>: Cost 1 vext3 LHS, LHS
  336380006U,	// <3,u,u,3>: Cost 1 vdup3 LHS
  1616099705U,	// <3,u,u,4>: Cost 2 vext3 LHS, <u,u,4,5>
  1611897219U,	// <3,u,u,5>: Cost 2 vext3 LHS, <u,u,5,6>
  537713037U,	// <3,u,u,6>: Cost 1 vext3 LHS, RHS
  1616099730U,	// <3,u,u,7>: Cost 2 vext3 LHS, <u,u,7,3>
  537713051U,	// <3,u,u,u>: Cost 1 vext3 LHS, LHS
  2691907584U,	// <4,0,0,0>: Cost 3 vext3 <1,2,3,4>, <0,0,0,0>
  2953669522U,	// <4,0,0,1>: Cost 3 vzipr LHS, <4,0,5,1>
  2819411276U,	// <4,0,0,2>: Cost 3 vuzpr LHS, <4,6,0,2>
  3644451279U,	// <4,0,0,3>: Cost 4 vext1 <3,4,0,0>, <3,4,0,0>
  2576681874U,	// <4,0,0,4>: Cost 3 vext1 <4,4,0,0>, <4,0,5,1>
  3650424445U,	// <4,0,0,5>: Cost 4 vext1 <4,4,0,0>, <5,0,7,1>
  3650425338U,	// <4,0,0,6>: Cost 4 vext1 <4,4,0,0>, <6,2,7,3>
  3668342067U,	// <4,0,0,7>: Cost 4 vext1 <7,4,0,0>, <7,4,0,0>
  2819853644U,	// <4,0,0,u>: Cost 3 vuzpr LHS, <4,6,0,2>
  2570715238U,	// <4,0,1,0>: Cost 3 vext1 <3,4,0,1>, LHS
  2570716058U,	// <4,0,1,1>: Cost 3 vext1 <3,4,0,1>, <1,2,3,4>
  1618165862U,	// <4,0,1,2>: Cost 2 vext3 <1,2,3,4>, LHS
  2570717648U,	// <4,0,1,3>: Cost 3 vext1 <3,4,0,1>, <3,4,0,1>
  2570718518U,	// <4,0,1,4>: Cost 3 vext1 <3,4,0,1>, RHS
  2594607206U,	// <4,0,1,5>: Cost 3 vext1 <7,4,0,1>, <5,6,7,4>
  3644461562U,	// <4,0,1,6>: Cost 4 vext1 <3,4,0,1>, <6,2,7,3>
  2594608436U,	// <4,0,1,7>: Cost 3 vext1 <7,4,0,1>, <7,4,0,1>
  1618165916U,	// <4,0,1,u>: Cost 2 vext3 <1,2,3,4>, LHS
  2691907748U,	// <4,0,2,0>: Cost 3 vext3 <1,2,3,4>, <0,2,0,2>
  4027370550U,	// <4,0,2,1>: Cost 4 vzipr LHS, <4,2,5,3>
  2564753102U,	// <4,0,2,2>: Cost 3 vext1 <2,4,0,2>, <2,3,4,5>
  2631476937U,	// <4,0,2,3>: Cost 3 vext2 <2,3,4,0>, <2,3,4,0>
  2564754742U,	// <4,0,2,4>: Cost 3 vext1 <2,4,0,2>, RHS
  3638496840U,	// <4,0,2,5>: Cost 4 vext1 <2,4,0,2>, <5,0,1,2>
  2588643932U,	// <4,0,2,6>: Cost 3 vext1 <6,4,0,2>, <6,4,0,2>
  3668358453U,	// <4,0,2,7>: Cost 4 vext1 <7,4,0,2>, <7,4,0,2>
  2564757294U,	// <4,0,2,u>: Cost 3 vext1 <2,4,0,2>, LHS
  3705219222U,	// <4,0,3,0>: Cost 4 vext2 <2,3,4,0>, <3,0,1,2>
  3910323532U,	// <4,0,3,1>: Cost 4 vuzpr <3,0,1,2>, <4,6,0,2>
  2686525705U,	// <4,0,3,2>: Cost 3 vext3 <0,3,2,4>, <0,3,2,4>
  3705219484U,	// <4,0,3,3>: Cost 4 vext2 <2,3,4,0>, <3,3,3,3>
  3705219539U,	// <4,0,3,4>: Cost 4 vext2 <2,3,4,0>, <3,4,0,4>
  3913305420U,	// <4,0,3,5>: Cost 4 vuzpr <3,4,5,6>, <4,6,0,2>
  3913329996U,	// <4,0,3,6>: Cost 4 vuzpr <3,4,6,0>, <4,6,0,2>
  3713845990U,	// <4,0,3,7>: Cost 4 vext2 <3,7,4,0>, <3,7,4,0>
  2686968127U,	// <4,0,3,u>: Cost 3 vext3 <0,3,u,4>, <0,3,u,4>
  2631478162U,	// <4,0,4,0>: Cost 3 vext2 <2,3,4,0>, <4,0,5,1>
  2718744914U,	// <4,0,4,1>: Cost 3 vext3 <5,6,7,4>, <0,4,1,5>
  2718744924U,	// <4,0,4,2>: Cost 3 vext3 <5,6,7,4>, <0,4,2,6>
  3644484051U,	// <4,0,4,3>: Cost 4 vext1 <3,4,0,4>, <3,4,0,4>
  2644085964U,	// <4,0,4,4>: Cost 3 vext2 <4,4,4,0>, <4,4,4,0>
  2631478582U,	// <4,0,4,5>: Cost 3 vext2 <2,3,4,0>, RHS
  2846281036U,	// <4,0,4,6>: Cost 3 vuzpr RHS, <4,6,0,2>
  3668374839U,	// <4,0,4,7>: Cost 4 vext1 <7,4,0,4>, <7,4,0,4>
  2631478825U,	// <4,0,4,u>: Cost 3 vext2 <2,3,4,0>, RHS
  2570748006U,	// <4,0,5,0>: Cost 3 vext1 <3,4,0,5>, LHS
  1879887158U,	// <4,0,5,1>: Cost 2 vzipr LHS, RHS
  3087846290U,	// <4,0,5,2>: Cost 3 vtrnr LHS, <4,0,5,1>
  2570750420U,	// <4,0,5,3>: Cost 3 vext1 <3,4,0,5>, <3,4,0,5>
  2570750866U,	// <4,0,5,4>: Cost 3 vext1 <3,4,0,5>, <4,0,5,1>
  3644493520U,	// <4,0,5,5>: Cost 4 vext1 <3,4,0,5>, <5,1,7,3>
  3644494330U,	// <4,0,5,6>: Cost 4 vext1 <3,4,0,5>, <6,2,7,3>
  2594641208U,	// <4,0,5,7>: Cost 3 vext1 <7,4,0,5>, <7,4,0,5>
  1884532022U,	// <4,0,5,u>: Cost 2 vzipr LHS, RHS
  3088354614U,	// <4,0,6,0>: Cost 3 vtrnr <0,2,0,2>, RHS
  2953629004U,	// <4,0,6,1>: Cost 3 vzipr LHS, <4,6,0,2>
  2014104886U,	// <4,0,6,2>: Cost 2 vtrnr LHS, RHS
  2570758613U,	// <4,0,6,3>: Cost 3 vext1 <3,4,0,6>, <3,4,0,6>
  2570759068U,	// <4,0,6,4>: Cost 3 vext1 <3,4,0,6>, <4,0,6,2>
  2217664887U,	// <4,0,6,5>: Cost 3 vrev <0,4,5,6>
  3644502477U,	// <4,0,6,6>: Cost 4 vext1 <3,4,0,6>, <6,2,2,3>
  2658022257U,	// <4,0,6,7>: Cost 3 vext2 <6,7,4,0>, <6,7,4,0>
  2014547254U,	// <4,0,6,u>: Cost 2 vtrnr LHS, RHS
  3719156730U,	// <4,0,7,0>: Cost 4 vext2 <4,6,4,0>, <7,0,1,2>
  3934211404U,	// <4,0,7,1>: Cost 4 vuzpr <7,0,1,2>, <4,6,0,2>
  3734418613U,	// <4,0,7,2>: Cost 4 vext2 <7,2,4,0>, <7,2,4,0>
  3735082246U,	// <4,0,7,3>: Cost 4 vext2 <7,3,4,0>, <7,3,4,0>
  3719157094U,	// <4,0,7,4>: Cost 4 vext2 <4,6,4,0>, <7,4,5,6>
  3721811345U,	// <4,0,7,5>: Cost 4 vext2 <5,1,4,0>, <7,5,1,4>
  3728446955U,	// <4,0,7,6>: Cost 4 vext2 <6,2,4,0>, <7,6,2,4>
  3719157356U,	// <4,0,7,7>: Cost 4 vext2 <4,6,4,0>, <7,7,7,7>
  3719157378U,	// <4,0,7,u>: Cost 4 vext2 <4,6,4,0>, <7,u,1,2>
  3088354632U,	// <4,0,u,0>: Cost 3 vtrnr <0,2,0,2>, RHS
  1879887401U,	// <4,0,u,1>: Cost 2 vzipr LHS, RHS
  2014104904U,	// <4,0,u,2>: Cost 2 vtrnr LHS, RHS
  2570774999U,	// <4,0,u,3>: Cost 3 vext1 <3,4,0,u>, <3,4,0,u>
  2564803894U,	// <4,0,u,4>: Cost 3 vext1 <2,4,0,u>, RHS
  2631481498U,	// <4,0,u,5>: Cost 3 vext2 <2,3,4,0>, RHS
  2870168908U,	// <4,0,u,6>: Cost 3 vuzpr RHS, <4,6,0,2>
  2594665787U,	// <4,0,u,7>: Cost 3 vext1 <7,4,0,u>, <7,4,0,u>
  2014547272U,	// <4,0,u,u>: Cost 2 vtrnr LHS, RHS
  4032744338U,	// <4,1,0,0>: Cost 4 vzipr <1,0,3,2>, <4,0,5,1>
  2631483494U,	// <4,1,0,1>: Cost 3 vext2 <2,3,4,1>, LHS
  4034055058U,	// <4,1,0,2>: Cost 4 vzipr <1,2,3,0>, <4,0,5,1>
  2691908342U,	// <4,1,0,3>: Cost 3 vext3 <1,2,3,4>, <1,0,3,2>
  2659352914U,	// <4,1,0,4>: Cost 3 vext2 <7,0,4,1>, <0,4,1,5>
  3297330250U,	// <4,1,0,5>: Cost 4 vrev <1,4,5,0>
  3297403987U,	// <4,1,0,6>: Cost 4 vrev <1,4,6,0>
  3668415804U,	// <4,1,0,7>: Cost 4 vext1 <7,4,1,0>, <7,4,1,0>
  2691908387U,	// <4,1,0,u>: Cost 3 vext3 <1,2,3,4>, <1,0,u,2>
  3764839211U,	// <4,1,1,0>: Cost 4 vext3 <1,1,1,4>, <1,1,0,1>
  2691097399U,	// <4,1,1,1>: Cost 3 vext3 <1,1,1,4>, <1,1,1,4>
  2631484314U,	// <4,1,1,2>: Cost 3 vext2 <2,3,4,1>, <1,2,3,4>
  2691908424U,	// <4,1,1,3>: Cost 3 vext3 <1,2,3,4>, <1,1,3,3>
  3764839247U,	// <4,1,1,4>: Cost 4 vext3 <1,1,1,4>, <1,1,4,1>
  3765134171U,	// <4,1,1,5>: Cost 4 vext3 <1,1,5,4>, <1,1,5,4>
  3733095667U,	// <4,1,1,6>: Cost 4 vext2 <7,0,4,1>, <1,6,5,7>
  3668423997U,	// <4,1,1,7>: Cost 4 vext1 <7,4,1,1>, <7,4,1,1>
  2691908469U,	// <4,1,1,u>: Cost 3 vext3 <1,2,3,4>, <1,1,u,3>
  2570797158U,	// <4,1,2,0>: Cost 3 vext1 <3,4,1,2>, LHS
  2570797978U,	// <4,1,2,1>: Cost 3 vext1 <3,4,1,2>, <1,2,3,4>
  3765650320U,	// <4,1,2,2>: Cost 4 vext3 <1,2,3,4>, <1,2,2,3>
  1618166682U,	// <4,1,2,3>: Cost 2 vext3 <1,2,3,4>, <1,2,3,4>
  2570800438U,	// <4,1,2,4>: Cost 3 vext1 <3,4,1,2>, RHS
  3644542672U,	// <4,1,2,5>: Cost 4 vext1 <3,4,1,2>, <5,1,7,3>
  3644543482U,	// <4,1,2,6>: Cost 4 vext1 <3,4,1,2>, <6,2,7,3>
  3668432190U,	// <4,1,2,7>: Cost 4 vext1 <7,4,1,2>, <7,4,1,2>
  1618535367U,	// <4,1,2,u>: Cost 2 vext3 <1,2,u,4>, <1,2,u,4>
  2635466928U,	// <4,1,3,0>: Cost 3 vext2 <3,0,4,1>, <3,0,4,1>
  3765650392U,	// <4,1,3,1>: Cost 4 vext3 <1,2,3,4>, <1,3,1,3>
  3705227604U,	// <4,1,3,2>: Cost 4 vext2 <2,3,4,1>, <3,2,4,3>
  2692572139U,	// <4,1,3,3>: Cost 3 vext3 <1,3,3,4>, <1,3,3,4>
  2635467266U,	// <4,1,3,4>: Cost 3 vext2 <3,0,4,1>, <3,4,5,6>
  3709209122U,	// <4,1,3,5>: Cost 4 vext2 <3,0,4,1>, <3,5,0,2>
  3297428566U,	// <4,1,3,6>: Cost 4 vrev <1,4,6,3>
  3713854183U,	// <4,1,3,7>: Cost 4 vext2 <3,7,4,1>, <3,7,4,1>
  2692940824U,	// <4,1,3,u>: Cost 3 vext3 <1,3,u,4>, <1,3,u,4>
  3764839454U,	// <4,1,4,0>: Cost 4 vext3 <1,1,1,4>, <1,4,0,1>
  3764839463U,	// <4,1,4,1>: Cost 4 vext3 <1,1,1,4>, <1,4,1,1>
  4034088144U,	// <4,1,4,2>: Cost 4 vzipr <1,2,3,4>, <4,4,4,4>
  3068513488U,	// <4,1,4,3>: Cost 3 vtrnl LHS, <4,4,4,4>
  3764839494U,	// <4,1,4,4>: Cost 4 vext3 <1,1,1,4>, <1,4,4,5>
  2631486774U,	// <4,1,4,5>: Cost 3 vext2 <2,3,4,1>, RHS
  3705228620U,	// <4,1,4,6>: Cost 4 vext2 <2,3,4,1>, <4,6,0,2>
  3800007772U,	// <4,1,4,7>: Cost 4 vext3 <7,0,1,4>, <1,4,7,0>
  2631487017U,	// <4,1,4,u>: Cost 3 vext2 <2,3,4,1>, RHS
  1526939750U,	// <4,1,5,0>: Cost 2 vext1 <u,4,1,5>, LHS
  2959510838U,	// <4,1,5,1>: Cost 3 vzipr <1,1,1,1>, RHS
  2960313654U,	// <4,1,5,2>: Cost 3 vzipr <1,2,3,0>, RHS
  2718745744U,	// <4,1,5,3>: Cost 3 vext3 <5,6,7,4>, <1,5,3,7>
  1526943030U,	// <4,1,5,4>: Cost 2 vext1 <u,4,1,5>, RHS
  2582769360U,	// <4,1,5,5>: Cost 3 vext1 <5,4,1,5>, <5,1,7,3>
  2600686074U,	// <4,1,5,6>: Cost 3 vext1 <u,4,1,5>, <6,2,7,3>
  2600686586U,	// <4,1,5,7>: Cost 3 vext1 <u,4,1,5>, <7,0,1,2>
  1526945582U,	// <4,1,5,u>: Cost 2 vext1 <u,4,1,5>, LHS
  2552913930U,	// <4,1,6,0>: Cost 3 vext1 <0,4,1,6>, <0,0,1,1>
  3093728566U,	// <4,1,6,1>: Cost 3 vtrnr <1,1,1,1>, RHS
  4166880566U,	// <4,1,6,2>: Cost 4 vtrnr <1,0,2,1>, RHS
  3020737026U,	// <4,1,6,3>: Cost 3 vtrnl LHS, <3,4,5,6>
  2552917302U,	// <4,1,6,4>: Cost 3 vext1 <0,4,1,6>, RHS
  2223637584U,	// <4,1,6,5>: Cost 3 vrev <1,4,5,6>
  3662492265U,	// <4,1,6,6>: Cost 4 vext1 <6,4,1,6>, <6,4,1,6>
  3731772274U,	// <4,1,6,7>: Cost 4 vext2 <6,7,4,1>, <6,7,4,1>
  3020777986U,	// <4,1,6,u>: Cost 3 vtrnl LHS, <3,4,5,6>
  2659357716U,	// <4,1,7,0>: Cost 3 vext2 <7,0,4,1>, <7,0,4,1>
  3768821021U,	// <4,1,7,1>: Cost 4 vext3 <1,7,1,4>, <1,7,1,4>
  3768894758U,	// <4,1,7,2>: Cost 4 vext3 <1,7,2,4>, <1,7,2,4>
  2695226671U,	// <4,1,7,3>: Cost 3 vext3 <1,7,3,4>, <1,7,3,4>
  3733099878U,	// <4,1,7,4>: Cost 4 vext2 <7,0,4,1>, <7,4,5,6>
  3736417705U,	// <4,1,7,5>: Cost 4 vext2 <7,5,4,1>, <7,5,4,1>
  3297461338U,	// <4,1,7,6>: Cost 4 vrev <1,4,6,7>
  3733100074U,	// <4,1,7,7>: Cost 4 vext2 <7,0,4,1>, <7,7,0,4>
  2664666780U,	// <4,1,7,u>: Cost 3 vext2 <7,u,4,1>, <7,u,4,1>
  1526939750U,	// <4,1,u,0>: Cost 2 vext1 <u,4,1,5>, LHS
  2959511081U,	// <4,1,u,1>: Cost 3 vzipr <1,1,1,1>, RHS
  2960313897U,	// <4,1,u,2>: Cost 3 vzipr <1,2,3,0>, RHS
  1622148480U,	// <4,1,u,3>: Cost 2 vext3 <1,u,3,4>, <1,u,3,4>
  1526943030U,	// <4,1,u,4>: Cost 2 vext1 <u,4,1,5>, RHS
  2223653970U,	// <4,1,u,5>: Cost 3 vrev <1,4,5,u>
  2600686074U,	// <4,1,u,6>: Cost 3 vext1 <u,4,1,5>, <6,2,7,3>
  2600686586U,	// <4,1,u,7>: Cost 3 vext1 <u,4,1,5>, <7,0,1,2>
  1622517165U,	// <4,1,u,u>: Cost 2 vext3 <1,u,u,4>, <1,u,u,4>
  2588770406U,	// <4,2,0,0>: Cost 3 vext1 <6,4,2,0>, LHS
  2629501030U,	// <4,2,0,1>: Cost 3 vext2 <2,0,4,2>, LHS
  2696480200U,	// <4,2,0,2>: Cost 3 vext3 <2,0,2,4>, <2,0,2,4>
  3964905161U,	// <4,2,0,3>: Cost 4 vzipl LHS, <2,3,4,0>
  2588773686U,	// <4,2,0,4>: Cost 3 vext1 <6,4,2,0>, RHS
  3770443235U,	// <4,2,0,5>: Cost 4 vext3 <2,0,5,4>, <2,0,5,4>
  2588775020U,	// <4,2,0,6>: Cost 3 vext1 <6,4,2,0>, <6,4,2,0>
  3662517242U,	// <4,2,0,7>: Cost 4 vext1 <6,4,2,0>, <7,0,1,2>
  2629501597U,	// <4,2,0,u>: Cost 3 vext2 <2,0,4,2>, LHS
  3765650950U,	// <4,2,1,0>: Cost 4 vext3 <1,2,3,4>, <2,1,0,3>
  3703243572U,	// <4,2,1,1>: Cost 4 vext2 <2,0,4,2>, <1,1,1,1>
  3765650968U,	// <4,2,1,2>: Cost 4 vext3 <1,2,3,4>, <2,1,2,3>
  3964905648U,	// <4,2,1,3>: Cost 4 vzipl LHS, <3,0,4,1>
  2691909162U,	// <4,2,1,4>: Cost 3 vext3 <1,2,3,4>, <2,1,4,3>
  3733103760U,	// <4,2,1,5>: Cost 4 vext2 <7,0,4,2>, <1,5,3,7>
  3807454780U,	// <4,2,1,6>: Cost 4 vext3 <u,2,3,4>, <2,1,6,3>
  3792488005U,	// <4,2,1,7>: Cost 5 vext3 <5,6,7,4>, <2,1,7,3>
  2691909162U,	// <4,2,1,u>: Cost 3 vext3 <1,2,3,4>, <2,1,4,3>
  2629502424U,	// <4,2,2,0>: Cost 3 vext2 <2,0,4,2>, <2,0,4,2>
  3644613530U,	// <4,2,2,1>: Cost 4 vext1 <3,4,2,2>, <1,2,3,4>
  2691909224U,	// <4,2,2,2>: Cost 3 vext3 <1,2,3,4>, <2,2,2,2>
  2691909234U,	// <4,2,2,3>: Cost 3 vext3 <1,2,3,4>, <2,2,3,3>
  2697954940U,	// <4,2,2,4>: Cost 3 vext3 <2,2,4,4>, <2,2,4,4>
  3771770501U,	// <4,2,2,5>: Cost 4 vext3 <2,2,5,4>, <2,2,5,4>
  3733104570U,	// <4,2,2,6>: Cost 4 vext2 <7,0,4,2>, <2,6,3,7>
  3668505927U,	// <4,2,2,7>: Cost 4 vext1 <7,4,2,2>, <7,4,2,2>
  2691909279U,	// <4,2,2,u>: Cost 3 vext3 <1,2,3,4>, <2,2,u,3>
  2691909286U,	// <4,2,3,0>: Cost 3 vext3 <1,2,3,4>, <2,3,0,1>
  3764840111U,	// <4,2,3,1>: Cost 4 vext3 <1,1,1,4>, <2,3,1,1>
  3765651129U,	// <4,2,3,2>: Cost 4 vext3 <1,2,3,4>, <2,3,2,2>
  2698544836U,	// <4,2,3,3>: Cost 3 vext3 <2,3,3,4>, <2,3,3,4>
  2691909322U,	// <4,2,3,4>: Cost 3 vext3 <1,2,3,4>, <2,3,4,1>
  2698692310U,	// <4,2,3,5>: Cost 3 vext3 <2,3,5,4>, <2,3,5,4>
  3765651165U,	// <4,2,3,6>: Cost 4 vext3 <1,2,3,4>, <2,3,6,2>
  2698839784U,	// <4,2,3,7>: Cost 3 vext3 <2,3,7,4>, <2,3,7,4>
  2691909358U,	// <4,2,3,u>: Cost 3 vext3 <1,2,3,4>, <2,3,u,1>
  2564915302U,	// <4,2,4,0>: Cost 3 vext1 <2,4,2,4>, LHS
  3638657782U,	// <4,2,4,1>: Cost 4 vext1 <2,4,2,4>, <1,0,3,2>
  2564916942U,	// <4,2,4,2>: Cost 3 vext1 <2,4,2,4>, <2,3,4,5>
  2934295760U,	// <4,2,4,3>: Cost 3 vzipl LHS, <4,4,4,4>
  2564918582U,	// <4,2,4,4>: Cost 3 vext1 <2,4,2,4>, RHS
  2629504310U,	// <4,2,4,5>: Cost 3 vext2 <2,0,4,2>, RHS
  2229667632U,	// <4,2,4,6>: Cost 3 vrev <2,4,6,4>
  3800082229U,	// <4,2,4,7>: Cost 4 vext3 <7,0,2,4>, <2,4,7,0>
  2629504553U,	// <4,2,4,u>: Cost 3 vext2 <2,0,4,2>, RHS
  2588811366U,	// <4,2,5,0>: Cost 3 vext1 <6,4,2,5>, LHS
  2558952342U,	// <4,2,5,1>: Cost 3 vext1 <1,4,2,5>, <1,2,3,0>
  2966228278U,	// <4,2,5,2>: Cost 3 vzipr <2,2,2,2>, RHS
  2886518478U,	// <4,2,5,3>: Cost 3 vzipl LHS, <2,3,4,5>
  2588814646U,	// <4,2,5,4>: Cost 3 vext1 <6,4,2,5>, RHS
  3656585112U,	// <4,2,5,5>: Cost 4 vext1 <5,4,2,5>, <5,4,2,5>
  2588815866U,	// <4,2,5,6>: Cost 3 vext1 <6,4,2,5>, <6,2,7,3>
  3662558202U,	// <4,2,5,7>: Cost 4 vext1 <6,4,2,5>, <7,0,1,2>
  2886559438U,	// <4,2,5,u>: Cost 3 vzipl LHS, <2,3,4,5>
  1527021670U,	// <4,2,6,0>: Cost 2 vext1 <u,4,2,6>, LHS
  2600764150U,	// <4,2,6,1>: Cost 3 vext1 <u,4,2,6>, <1,0,3,2>
  3100446006U,	// <4,2,6,2>: Cost 3 vtrnr <2,2,2,2>, RHS
  3100527926U,	// <4,2,6,3>: Cost 3 vtrnr <2,2,3,3>, RHS
  1527024950U,	// <4,2,6,4>: Cost 2 vext1 <u,4,2,6>, RHS
  2229610281U,	// <4,2,6,5>: Cost 3 vrev <2,4,5,6>
  2600767994U,	// <4,2,6,6>: Cost 3 vext1 <u,4,2,6>, <6,2,7,3>
  2600768506U,	// <4,2,6,7>: Cost 3 vext1 <u,4,2,6>, <7,0,1,2>
  1527027502U,	// <4,2,6,u>: Cost 2 vext1 <u,4,2,6>, LHS
  2659365909U,	// <4,2,7,0>: Cost 3 vext2 <7,0,4,2>, <7,0,4,2>
  3733771366U,	// <4,2,7,1>: Cost 4 vext2 <7,1,4,2>, <7,1,4,2>
  3734434999U,	// <4,2,7,2>: Cost 4 vext2 <7,2,4,2>, <7,2,4,2>
  2701199368U,	// <4,2,7,3>: Cost 3 vext3 <2,7,3,4>, <2,7,3,4>
  3789834253U,	// <4,2,7,4>: Cost 4 vext3 <5,2,7,4>, <2,7,4,0>
  3775088666U,	// <4,2,7,5>: Cost 4 vext3 <2,7,5,4>, <2,7,5,4>
  3737089531U,	// <4,2,7,6>: Cost 4 vext2 <7,6,4,2>, <7,6,4,2>
  3733108332U,	// <4,2,7,7>: Cost 4 vext2 <7,0,4,2>, <7,7,7,7>
  2664674973U,	// <4,2,7,u>: Cost 3 vext2 <7,u,4,2>, <7,u,4,2>
  1527038054U,	// <4,2,u,0>: Cost 2 vext1 <u,4,2,u>, LHS
  2629506862U,	// <4,2,u,1>: Cost 3 vext2 <2,0,4,2>, LHS
  2966228521U,	// <4,2,u,2>: Cost 3 vzipr <2,2,2,2>, RHS
  2886518481U,	// <4,2,u,3>: Cost 3 vzipl LHS, <2,3,4,u>
  1527041334U,	// <4,2,u,4>: Cost 2 vext1 <u,4,2,u>, RHS
  2629507226U,	// <4,2,u,5>: Cost 3 vext2 <2,0,4,2>, RHS
  2588840442U,	// <4,2,u,6>: Cost 3 vext1 <6,4,2,u>, <6,2,7,3>
  2600784890U,	// <4,2,u,7>: Cost 3 vext1 <u,4,2,u>, <7,0,1,2>
  1527043886U,	// <4,2,u,u>: Cost 2 vext1 <u,4,2,u>, LHS
  3765651595U,	// <4,3,0,0>: Cost 4 vext3 <1,2,3,4>, <3,0,0,0>
  2691909782U,	// <4,3,0,1>: Cost 3 vext3 <1,2,3,4>, <3,0,1,2>
  2702452897U,	// <4,3,0,2>: Cost 3 vext3 <3,0,2,4>, <3,0,2,4>
  3765651623U,	// <4,3,0,3>: Cost 4 vext3 <1,2,3,4>, <3,0,3,1>
  3765651632U,	// <4,3,0,4>: Cost 4 vext3 <1,2,3,4>, <3,0,4,1>
  2235533820U,	// <4,3,0,5>: Cost 3 vrev <3,4,5,0>
  2235607557U,	// <4,3,0,6>: Cost 3 vrev <3,4,6,0>
  3668563278U,	// <4,3,0,7>: Cost 4 vext1 <7,4,3,0>, <7,4,3,0>
  2691909845U,	// <4,3,0,u>: Cost 3 vext3 <1,2,3,4>, <3,0,u,2>
  2235173328U,	// <4,3,1,0>: Cost 3 vrev <3,4,0,1>
  3764840678U,	// <4,3,1,1>: Cost 4 vext3 <1,1,1,4>, <3,1,1,1>
  2630173594U,	// <4,3,1,2>: Cost 3 vext2 <2,1,4,3>, <1,2,3,4>
  3765651706U,	// <4,3,1,3>: Cost 4 vext3 <1,2,3,4>, <3,1,3,3>
  3765651713U,	// <4,3,1,4>: Cost 4 vext3 <1,2,3,4>, <3,1,4,1>
  3765651724U,	// <4,3,1,5>: Cost 4 vext3 <1,2,3,4>, <3,1,5,3>
  3309357574U,	// <4,3,1,6>: Cost 4 vrev <3,4,6,1>
  3792488734U,	// <4,3,1,7>: Cost 5 vext3 <5,6,7,4>, <3,1,7,3>
  2235763224U,	// <4,3,1,u>: Cost 3 vrev <3,4,u,1>
  3696616904U,	// <4,3,2,0>: Cost 4 vext2 <0,u,4,3>, <2,0,2,4>
  2630174250U,	// <4,3,2,1>: Cost 3 vext2 <2,1,4,3>, <2,1,4,3>
  3765651777U,	// <4,3,2,2>: Cost 4 vext3 <1,2,3,4>, <3,2,2,2>
  2703853900U,	// <4,3,2,3>: Cost 3 vext3 <3,2,3,4>, <3,2,3,4>
  2691909972U,	// <4,3,2,4>: Cost 3 vext3 <1,2,3,4>, <3,2,4,3>
  2704001374U,	// <4,3,2,5>: Cost 3 vext3 <3,2,5,4>, <3,2,5,4>
  3777816935U,	// <4,3,2,6>: Cost 4 vext3 <3,2,6,4>, <3,2,6,4>
  3707897872U,	// <4,3,2,7>: Cost 4 vext2 <2,7,4,3>, <2,7,4,3>
  2634819681U,	// <4,3,2,u>: Cost 3 vext2 <2,u,4,3>, <2,u,4,3>
  3765651839U,	// <4,3,3,0>: Cost 4 vext3 <1,2,3,4>, <3,3,0,1>
  3765651848U,	// <4,3,3,1>: Cost 4 vext3 <1,2,3,4>, <3,3,1,1>
  2636810580U,	// <4,3,3,2>: Cost 3 vext2 <3,2,4,3>, <3,2,4,3>
  2691910044U,	// <4,3,3,3>: Cost 3 vext3 <1,2,3,4>, <3,3,3,3>
  2704591270U,	// <4,3,3,4>: Cost 3 vext3 <3,3,4,4>, <3,3,4,4>
  3772877232U,	// <4,3,3,5>: Cost 4 vext3 <2,4,2,4>, <3,3,5,5>
  3765651896U,	// <4,3,3,6>: Cost 4 vext3 <1,2,3,4>, <3,3,6,4>
  3668587857U,	// <4,3,3,7>: Cost 4 vext1 <7,4,3,3>, <7,4,3,3>
  2640792378U,	// <4,3,3,u>: Cost 3 vext2 <3,u,4,3>, <3,u,4,3>
  2691910096U,	// <4,3,4,0>: Cost 3 vext3 <1,2,3,4>, <3,4,0,1>
  2691910106U,	// <4,3,4,1>: Cost 3 vext3 <1,2,3,4>, <3,4,1,2>
  2642783277U,	// <4,3,4,2>: Cost 3 vext2 <4,2,4,3>, <4,2,4,3>
  3765651946U,	// <4,3,4,3>: Cost 4 vext3 <1,2,3,4>, <3,4,3,0>
  2691910136U,	// <4,3,4,4>: Cost 3 vext3 <1,2,3,4>, <3,4,4,5>
  2691910146U,	// <4,3,4,5>: Cost 3 vext3 <1,2,3,4>, <3,4,5,6>
  2235640329U,	// <4,3,4,6>: Cost 3 vrev <3,4,6,4>
  3801483792U,	// <4,3,4,7>: Cost 4 vext3 <7,2,3,4>, <3,4,7,2>
  2691910168U,	// <4,3,4,u>: Cost 3 vext3 <1,2,3,4>, <3,4,u,1>
  2564997222U,	// <4,3,5,0>: Cost 3 vext1 <2,4,3,5>, LHS
  2559026237U,	// <4,3,5,1>: Cost 3 vext1 <1,4,3,5>, <1,4,3,5>
  2564998862U,	// <4,3,5,2>: Cost 3 vext1 <2,4,3,5>, <2,3,4,5>
  2972945718U,	// <4,3,5,3>: Cost 3 vzipr <3,3,3,3>, RHS
  2565000502U,	// <4,3,5,4>: Cost 3 vext1 <2,4,3,5>, RHS
  4107912982U,	// <4,3,5,5>: Cost 4 vtrnl <2,3,4,5>, <2,4,3,5>
  3638743546U,	// <4,3,5,6>: Cost 4 vext1 <2,4,3,5>, <6,2,7,3>
  3668604243U,	// <4,3,5,7>: Cost 4 vext1 <7,4,3,5>, <7,4,3,5>
  2565003054U,	// <4,3,5,u>: Cost 3 vext1 <2,4,3,5>, LHS
  2235214293U,	// <4,3,6,0>: Cost 3 vrev <3,4,0,6>
  3105017142U,	// <4,3,6,1>: Cost 3 vtrnr <3,0,1,2>, RHS
  2565006962U,	// <4,3,6,2>: Cost 3 vext1 <2,4,3,6>, <2,2,3,3>
  3107163446U,	// <4,3,6,3>: Cost 3 vtrnr <3,3,3,3>, RHS
  2600840502U,	// <4,3,6,4>: Cost 3 vext1 <u,4,3,6>, RHS
  1161841154U,	// <4,3,6,5>: Cost 2 vrev <3,4,5,6>
  4181765430U,	// <4,3,6,6>: Cost 4 vtrnr <3,4,6,0>, RHS
  2706803380U,	// <4,3,6,7>: Cost 3 vext3 <3,6,7,4>, <3,6,7,4>
  1162062365U,	// <4,3,6,u>: Cost 2 vrev <3,4,u,6>
  3739751418U,	// <4,3,7,0>: Cost 4 vext2 <u,1,4,3>, <7,0,1,2>
  3733779559U,	// <4,3,7,1>: Cost 4 vext2 <7,1,4,3>, <7,1,4,3>
  3734443192U,	// <4,3,7,2>: Cost 4 vext2 <7,2,4,3>, <7,2,4,3>
  3735106825U,	// <4,3,7,3>: Cost 4 vext2 <7,3,4,3>, <7,3,4,3>
  3796470502U,	// <4,3,7,4>: Cost 4 vext3 <6,3,7,4>, <3,7,4,0>
  3309332995U,	// <4,3,7,5>: Cost 4 vrev <3,4,5,7>
  3737097724U,	// <4,3,7,6>: Cost 4 vext2 <7,6,4,3>, <7,6,4,3>
  3739752044U,	// <4,3,7,7>: Cost 4 vext2 <u,1,4,3>, <7,7,7,7>
  3738424990U,	// <4,3,7,u>: Cost 4 vext2 <7,u,4,3>, <7,u,4,3>
  2565021798U,	// <4,3,u,0>: Cost 3 vext1 <2,4,3,u>, LHS
  2691910430U,	// <4,3,u,1>: Cost 3 vext3 <1,2,3,4>, <3,u,1,2>
  2565023441U,	// <4,3,u,2>: Cost 3 vext1 <2,4,3,u>, <2,3,4,u>
  2972945961U,	// <4,3,u,3>: Cost 3 vzipr <3,3,3,3>, RHS
  2691910458U,	// <4,3,u,4>: Cost 3 vext3 <1,2,3,4>, <3,u,4,3>
  1161857540U,	// <4,3,u,5>: Cost 2 vrev <3,4,5,u>
  2235607557U,	// <4,3,u,6>: Cost 3 vrev <3,4,6,0>
  2708130646U,	// <4,3,u,7>: Cost 3 vext3 <3,u,7,4>, <3,u,7,4>
  1162078751U,	// <4,3,u,u>: Cost 2 vrev <3,4,u,u>
  2977057682U,	// <4,4,0,0>: Cost 3 vzipr <4,0,5,1>, <4,0,5,1>
  1570373734U,	// <4,4,0,1>: Cost 2 vext2 <4,4,4,4>, LHS
  2819411152U,	// <4,4,0,2>: Cost 3 vuzpr LHS, <4,4,4,4>
  3644746227U,	// <4,4,0,3>: Cost 4 vext1 <3,4,4,0>, <3,4,4,0>
  2576977100U,	// <4,4,0,4>: Cost 3 vext1 <4,4,4,0>, <4,4,4,0>
  2691910546U,	// <4,4,0,5>: Cost 3 vext3 <1,2,3,4>, <4,0,5,1>
  2691910556U,	// <4,4,0,6>: Cost 3 vext3 <1,2,3,4>, <4,0,6,2>
  3668637015U,	// <4,4,0,7>: Cost 4 vext1 <7,4,4,0>, <7,4,4,0>
  1570374301U,	// <4,4,0,u>: Cost 2 vext2 <4,4,4,4>, LHS
  2644116214U,	// <4,4,1,0>: Cost 3 vext2 <4,4,4,4>, <1,0,3,2>
  2644116276U,	// <4,4,1,1>: Cost 3 vext2 <4,4,4,4>, <1,1,1,1>
  2691910602U,	// <4,4,1,2>: Cost 3 vext3 <1,2,3,4>, <4,1,2,3>
  3899870416U,	// <4,4,1,3>: Cost 4 vuzpr <1,2,3,4>, <4,4,4,4>
  2711227356U,	// <4,4,1,4>: Cost 3 vext3 <4,4,4,4>, <4,1,4,3>
  2709310438U,	// <4,4,1,5>: Cost 3 vext3 <4,1,5,4>, <4,1,5,4>
  3764841452U,	// <4,4,1,6>: Cost 4 vext3 <1,1,1,4>, <4,1,6,1>
  3768970231U,	// <4,4,1,7>: Cost 4 vext3 <1,7,3,4>, <4,1,7,3>
  2695891968U,	// <4,4,1,u>: Cost 3 vext3 <1,u,3,4>, <4,1,u,3>
  3770223624U,	// <4,4,2,0>: Cost 4 vext3 <2,0,2,4>, <4,2,0,2>
  3765652499U,	// <4,4,2,1>: Cost 4 vext3 <1,2,3,4>, <4,2,1,4>
  2630846076U,	// <4,4,2,2>: Cost 3 vext2 <2,2,4,4>, <2,2,4,4>
  2631509709U,	// <4,4,2,3>: Cost 3 vext2 <2,3,4,4>, <2,3,4,4>
  2711227437U,	// <4,4,2,4>: Cost 3 vext3 <4,4,4,4>, <4,2,4,3>
  3765652534U,	// <4,4,2,5>: Cost 4 vext3 <1,2,3,4>, <4,2,5,3>
  2710047808U,	// <4,4,2,6>: Cost 3 vext3 <4,2,6,4>, <4,2,6,4>
  3774942280U,	// <4,4,2,7>: Cost 4 vext3 <2,7,3,4>, <4,2,7,3>
  2634827874U,	// <4,4,2,u>: Cost 3 vext2 <2,u,4,4>, <2,u,4,4>
  2644117654U,	// <4,4,3,0>: Cost 3 vext2 <4,4,4,4>, <3,0,1,2>
  3644769178U,	// <4,4,3,1>: Cost 4 vext1 <3,4,4,3>, <1,2,3,4>
  3765652589U,	// <4,4,3,2>: Cost 4 vext3 <1,2,3,4>, <4,3,2,4>
  2637482406U,	// <4,4,3,3>: Cost 3 vext2 <3,3,4,4>, <3,3,4,4>
  2638146039U,	// <4,4,3,4>: Cost 3 vext2 <3,4,4,4>, <3,4,4,4>
  3778260103U,	// <4,4,3,5>: Cost 4 vext3 <3,3,3,4>, <4,3,5,3>
  3778260112U,	// <4,4,3,6>: Cost 4 vext3 <3,3,3,4>, <4,3,6,3>
  3713878762U,	// <4,4,3,7>: Cost 4 vext2 <3,7,4,4>, <3,7,4,4>
  2637482406U,	// <4,4,3,u>: Cost 3 vext2 <3,3,4,4>, <3,3,4,4>
  1503264870U,	// <4,4,4,0>: Cost 2 vext1 <4,4,4,4>, LHS
  2577007514U,	// <4,4,4,1>: Cost 3 vext1 <4,4,4,4>, <1,2,3,4>
  2577008232U,	// <4,4,4,2>: Cost 3 vext1 <4,4,4,4>, <2,2,2,2>
  2571037175U,	// <4,4,4,3>: Cost 3 vext1 <3,4,4,4>, <3,4,4,4>
  161926454U,	// <4,4,4,4>: Cost 1 vdup0 RHS
  1570377014U,	// <4,4,4,5>: Cost 2 vext2 <4,4,4,4>, RHS
  2846280912U,	// <4,4,4,6>: Cost 3 vuzpr RHS, <4,4,4,4>
  2594927963U,	// <4,4,4,7>: Cost 3 vext1 <7,4,4,4>, <7,4,4,4>
  161926454U,	// <4,4,4,u>: Cost 1 vdup0 RHS
  2571042918U,	// <4,4,5,0>: Cost 3 vext1 <3,4,4,5>, LHS
  2571043738U,	// <4,4,5,1>: Cost 3 vext1 <3,4,4,5>, <1,2,3,4>
  3971679950U,	// <4,4,5,2>: Cost 4 vzipl <2,0,4,2>, <2,3,4,5>
  2571045368U,	// <4,4,5,3>: Cost 3 vext1 <3,4,4,5>, <3,4,4,5>
  2571046198U,	// <4,4,5,4>: Cost 3 vext1 <3,4,4,5>, RHS
  1906756918U,	// <4,4,5,5>: Cost 2 vzipr RHS, RHS
  1618169142U,	// <4,4,5,6>: Cost 2 vext3 <1,2,3,4>, RHS
  2594936156U,	// <4,4,5,7>: Cost 3 vext1 <7,4,4,5>, <7,4,4,5>
  1618169160U,	// <4,4,5,u>: Cost 2 vext3 <1,2,3,4>, RHS
  2691910988U,	// <4,4,6,0>: Cost 3 vext3 <1,2,3,4>, <4,6,0,2>
  3764841812U,	// <4,4,6,1>: Cost 4 vext3 <1,1,1,4>, <4,6,1,1>
  2712407392U,	// <4,4,6,2>: Cost 3 vext3 <4,6,2,4>, <4,6,2,4>
  2571053561U,	// <4,4,6,3>: Cost 3 vext1 <3,4,4,6>, <3,4,4,6>
  3115224374U,	// <4,4,6,4>: Cost 3 vtrnr <4,6,4,6>, RHS
  3111275830U,	// <4,4,6,5>: Cost 3 vtrnr <4,0,5,1>, RHS
  2040974646U,	// <4,4,6,6>: Cost 2 vtrnr RHS, RHS
  2658055029U,	// <4,4,6,7>: Cost 3 vext2 <6,7,4,4>, <6,7,4,4>
  2041122102U,	// <4,4,6,u>: Cost 2 vtrnr RHS, RHS
  2644120570U,	// <4,4,7,0>: Cost 3 vext2 <4,4,4,4>, <7,0,1,2>
  3934211280U,	// <4,4,7,1>: Cost 4 vuzpr <7,0,1,2>, <4,4,4,4>
  3801484720U,	// <4,4,7,2>: Cost 4 vext3 <7,2,3,4>, <4,7,2,3>
  3735115018U,	// <4,4,7,3>: Cost 4 vext2 <7,3,4,4>, <7,3,4,4>
  2662036827U,	// <4,4,7,4>: Cost 3 vext2 <7,4,4,4>, <7,4,4,4>
  3724498357U,	// <4,4,7,5>: Cost 4 vext2 <5,5,4,4>, <7,5,5,4>
  2713365973U,	// <4,4,7,6>: Cost 3 vext3 <4,7,6,4>, <4,7,6,4>
  2644121196U,	// <4,4,7,7>: Cost 3 vext2 <4,4,4,4>, <7,7,7,7>
  2662036827U,	// <4,4,7,u>: Cost 3 vext2 <7,4,4,4>, <7,4,4,4>
  1503297638U,	// <4,4,u,0>: Cost 2 vext1 <4,4,4,u>, LHS
  1570379566U,	// <4,4,u,1>: Cost 2 vext2 <4,4,4,4>, LHS
  2867186896U,	// <4,4,u,2>: Cost 3 vuzpr LHS, <4,4,4,4>
  2571069947U,	// <4,4,u,3>: Cost 3 vext1 <3,4,4,u>, <3,4,4,u>
  161926454U,	// <4,4,u,4>: Cost 1 vdup0 RHS
  1906757161U,	// <4,4,u,5>: Cost 2 vzipr RHS, RHS
  1618169385U,	// <4,4,u,6>: Cost 2 vext3 <1,2,3,4>, RHS
  2594960735U,	// <4,4,u,7>: Cost 3 vext1 <7,4,4,u>, <7,4,4,u>
  161926454U,	// <4,4,u,u>: Cost 1 vdup0 RHS
  2631516160U,	// <4,5,0,0>: Cost 3 vext2 <2,3,4,5>, <0,0,0,0>
  1557774438U,	// <4,5,0,1>: Cost 2 vext2 <2,3,4,5>, LHS
  2819451794U,	// <4,5,0,2>: Cost 3 vuzpr LHS, <4,0,5,1>
  2571078140U,	// <4,5,0,3>: Cost 3 vext1 <3,4,5,0>, <3,4,5,0>
  2571078966U,	// <4,5,0,4>: Cost 3 vext1 <3,4,5,0>, RHS
  3644821064U,	// <4,5,0,5>: Cost 4 vext1 <3,4,5,0>, <5,0,1,2>
  2594968438U,	// <4,5,0,6>: Cost 3 vext1 <7,4,5,0>, <6,7,4,5>
  2594968928U,	// <4,5,0,7>: Cost 3 vext1 <7,4,5,0>, <7,4,5,0>
  1557775005U,	// <4,5,0,u>: Cost 2 vext2 <2,3,4,5>, LHS
  2631516918U,	// <4,5,1,0>: Cost 3 vext2 <2,3,4,5>, <1,0,3,2>
  2624217939U,	// <4,5,1,1>: Cost 3 vext2 <1,1,4,5>, <1,1,4,5>
  2631517078U,	// <4,5,1,2>: Cost 3 vext2 <2,3,4,5>, <1,2,3,0>
  3898526610U,	// <4,5,1,3>: Cost 4 vuzpr <1,0,3,2>, <4,0,5,1>
  3697960010U,	// <4,5,1,4>: Cost 4 vext2 <1,1,4,5>, <1,4,5,0>
  2658059408U,	// <4,5,1,5>: Cost 3 vext2 <6,7,4,5>, <1,5,3,7>
  3980413104U,	// <4,5,1,6>: Cost 4 vzipl <3,4,5,6>, <3,0,4,1>
  2691911376U,	// <4,5,1,7>: Cost 3 vext3 <1,2,3,4>, <5,1,7,3>
  2691911385U,	// <4,5,1,u>: Cost 3 vext3 <1,2,3,4>, <5,1,u,3>
  2631517656U,	// <4,5,2,0>: Cost 3 vext2 <2,3,4,5>, <2,0,4,2>
  3692652056U,	// <4,5,2,1>: Cost 4 vext2 <0,2,4,5>, <2,1,2,3>
  2630854269U,	// <4,5,2,2>: Cost 3 vext2 <2,2,4,5>, <2,2,4,5>
  1557776078U,	// <4,5,2,3>: Cost 2 vext2 <2,3,4,5>, <2,3,4,5>
  2631517944U,	// <4,5,2,4>: Cost 3 vext2 <2,3,4,5>, <2,4,0,2>
  3644837448U,	// <4,5,2,5>: Cost 4 vext1 <3,4,5,2>, <5,0,1,2>
  2658060218U,	// <4,5,2,6>: Cost 3 vext2 <6,7,4,5>, <2,6,3,7>
  2716094242U,	// <4,5,2,7>: Cost 3 vext3 <5,2,7,4>, <5,2,7,4>
  1561094243U,	// <4,5,2,u>: Cost 2 vext2 <2,u,4,5>, <2,u,4,5>
  2631518358U,	// <4,5,3,0>: Cost 3 vext2 <2,3,4,5>, <3,0,1,2>
  2631518476U,	// <4,5,3,1>: Cost 3 vext2 <2,3,4,5>, <3,1,5,3>
  2631518540U,	// <4,5,3,2>: Cost 3 vext2 <2,3,4,5>, <3,2,3,4>
  2631518620U,	// <4,5,3,3>: Cost 3 vext2 <2,3,4,5>, <3,3,3,3>
  2631518716U,	// <4,5,3,4>: Cost 3 vext2 <2,3,4,5>, <3,4,5,0>
  3705260578U,	// <4,5,3,5>: Cost 4 vext2 <2,3,4,5>, <3,5,0,2>
  2658060980U,	// <4,5,3,6>: Cost 3 vext2 <6,7,4,5>, <3,6,7,4>
  2640145131U,	// <4,5,3,7>: Cost 3 vext2 <3,7,4,5>, <3,7,4,5>
  2631519006U,	// <4,5,3,u>: Cost 3 vext2 <2,3,4,5>, <3,u,1,2>
  2631519122U,	// <4,5,4,0>: Cost 3 vext2 <2,3,4,5>, <4,0,5,1>
  3697961955U,	// <4,5,4,1>: Cost 4 vext2 <1,1,4,5>, <4,1,5,1>
  2631519286U,	// <4,5,4,2>: Cost 3 vext2 <2,3,4,5>, <4,2,5,3>
  2571110912U,	// <4,5,4,3>: Cost 3 vext1 <3,4,5,4>, <3,4,5,4>
  2571111734U,	// <4,5,4,4>: Cost 3 vext1 <3,4,5,4>, RHS
  1557777718U,	// <4,5,4,5>: Cost 2 vext2 <2,3,4,5>, RHS
  2631519564U,	// <4,5,4,6>: Cost 3 vext2 <2,3,4,5>, <4,6,0,2>
  3047607504U,	// <4,5,4,7>: Cost 3 vtrnl RHS, <4,4,4,4>
  1557777961U,	// <4,5,4,u>: Cost 2 vext2 <2,3,4,5>, RHS
  1527234662U,	// <4,5,5,0>: Cost 2 vext1 <u,4,5,5>, LHS
  2631519952U,	// <4,5,5,1>: Cost 3 vext2 <2,3,4,5>, <5,1,7,3>
  2577090254U,	// <4,5,5,2>: Cost 3 vext1 <4,4,5,5>, <2,3,4,5>
  2600978582U,	// <4,5,5,3>: Cost 3 vext1 <u,4,5,5>, <3,0,1,2>
  1527237942U,	// <4,5,5,4>: Cost 2 vext1 <u,4,5,5>, RHS
  2631520260U,	// <4,5,5,5>: Cost 3 vext2 <2,3,4,5>, <5,5,5,5>
  2651426892U,	// <4,5,5,6>: Cost 3 vext2 <5,6,4,5>, <5,6,4,5>
  3047604562U,	// <4,5,5,7>: Cost 3 vtrnl RHS, <0,4,1,5>
  1527240494U,	// <4,5,5,u>: Cost 2 vext1 <u,4,5,5>, LHS
  1497383014U,	// <4,5,6,0>: Cost 2 vext1 <3,4,5,6>, LHS
  2559181904U,	// <4,5,6,1>: Cost 3 vext1 <1,4,5,6>, <1,4,5,6>
  2631520762U,	// <4,5,6,2>: Cost 3 vext2 <2,3,4,5>, <6,2,7,3>
  1497385474U,	// <4,5,6,3>: Cost 2 vext1 <3,4,5,6>, <3,4,5,6>
  1497386294U,	// <4,5,6,4>: Cost 2 vext1 <3,4,5,6>, RHS
  2571128528U,	// <4,5,6,5>: Cost 3 vext1 <3,4,5,6>, <5,1,7,3>
  2571129338U,	// <4,5,6,6>: Cost 3 vext1 <3,4,5,6>, <6,2,7,3>
  27705344U,	// <4,5,6,7>: Cost 0 copy RHS
  27705344U,	// <4,5,6,u>: Cost 0 copy RHS
  2658063354U,	// <4,5,7,0>: Cost 3 vext2 <6,7,4,5>, <7,0,1,2>
  3731805251U,	// <4,5,7,1>: Cost 4 vext2 <6,7,4,5>, <7,1,0,3>
  2631521456U,	// <4,5,7,2>: Cost 3 vext2 <2,3,4,5>, <7,2,3,4>
  2661381387U,	// <4,5,7,3>: Cost 3 vext2 <7,3,4,5>, <7,3,4,5>
  2658063712U,	// <4,5,7,4>: Cost 3 vext2 <6,7,4,5>, <7,4,5,0>
  3656822480U,	// <4,5,7,5>: Cost 4 vext1 <5,4,5,7>, <5,1,7,3>
  2658063896U,	// <4,5,7,6>: Cost 3 vext2 <6,7,4,5>, <7,6,7,4>
  2719412407U,	// <4,5,7,7>: Cost 3 vext3 <5,7,7,4>, <5,7,7,4>
  2719486144U,	// <4,5,7,u>: Cost 3 vext3 <5,7,u,4>, <5,7,u,4>
  1497399398U,	// <4,5,u,0>: Cost 2 vext1 <3,4,5,u>, LHS
  1557780270U,	// <4,5,u,1>: Cost 2 vext2 <2,3,4,5>, LHS
  2631522156U,	// <4,5,u,2>: Cost 3 vext2 <2,3,4,5>, <u,2,0,2>
  1497401860U,	// <4,5,u,3>: Cost 2 vext1 <3,4,5,u>, <3,4,5,u>
  1497402678U,	// <4,5,u,4>: Cost 2 vext1 <3,4,5,u>, RHS
  1557780634U,	// <4,5,u,5>: Cost 2 vext2 <2,3,4,5>, RHS
  2631522480U,	// <4,5,u,6>: Cost 3 vext2 <2,3,4,5>, <u,6,0,2>
  27705344U,	// <4,5,u,7>: Cost 0 copy RHS
  27705344U,	// <4,5,u,u>: Cost 0 copy RHS
  2819919158U,	// <4,6,0,0>: Cost 3 vuzpr <0,2,0,2>, RHS
  1571717222U,	// <4,6,0,1>: Cost 2 vext2 <4,6,4,6>, LHS
  1745669430U,	// <4,6,0,2>: Cost 2 vuzpr LHS, RHS
  2571151877U,	// <4,6,0,3>: Cost 3 vext1 <3,4,6,0>, <3,4,6,0>
  2571152694U,	// <4,6,0,4>: Cost 3 vext1 <3,4,6,0>, RHS
  3644894928U,	// <4,6,0,5>: Cost 4 vext1 <3,4,6,0>, <5,1,7,3>
  2253525648U,	// <4,6,0,6>: Cost 3 vrev <6,4,6,0>
  2595042665U,	// <4,6,0,7>: Cost 3 vext1 <7,4,6,0>, <7,4,6,0>
  1746111798U,	// <4,6,0,u>: Cost 2 vuzpr LHS, RHS
  2645459702U,	// <4,6,1,0>: Cost 3 vext2 <4,6,4,6>, <1,0,3,2>
  2825293110U,	// <4,6,1,1>: Cost 3 vuzpr <1,1,1,1>, RHS
  2645459862U,	// <4,6,1,2>: Cost 3 vext2 <4,6,4,6>, <1,2,3,0>
  2824785206U,	// <4,6,1,3>: Cost 3 vuzpr <1,0,3,2>, RHS
  3899288886U,	// <4,6,1,4>: Cost 4 vuzpr <1,1,4,5>, RHS
  2645460112U,	// <4,6,1,5>: Cost 3 vext2 <4,6,4,6>, <1,5,3,7>
  2645460192U,	// <4,6,1,6>: Cost 3 vext2 <4,6,4,6>, <1,6,3,6>
  3764842919U,	// <4,6,1,7>: Cost 4 vext3 <1,1,1,4>, <6,1,7,1>
  2825153846U,	// <4,6,1,u>: Cost 3 vuzpr <1,0,u,2>, RHS
  2832518454U,	// <4,6,2,0>: Cost 3 vuzpr <2,3,0,1>, RHS
  2618918460U,	// <4,6,2,1>: Cost 3 vext2 <0,2,4,6>, <2,1,6,3>
  2832010550U,	// <4,6,2,2>: Cost 3 vuzpr <2,2,2,2>, RHS
  2832092470U,	// <4,6,2,3>: Cost 3 vuzpr <2,2,3,3>, RHS
  2832846134U,	// <4,6,2,4>: Cost 3 vuzpr <2,3,4,5>, RHS
  2618918788U,	// <4,6,2,5>: Cost 3 vext2 <0,2,4,6>, <2,5,6,7>
  2645460922U,	// <4,6,2,6>: Cost 3 vext2 <4,6,4,6>, <2,6,3,7>
  2691912186U,	// <4,6,2,7>: Cost 3 vext3 <1,2,3,4>, <6,2,7,3>
  2691912195U,	// <4,6,2,u>: Cost 3 vext3 <1,2,3,4>, <6,2,u,3>
  2645461142U,	// <4,6,3,0>: Cost 3 vext2 <4,6,4,6>, <3,0,1,2>
  2836581686U,	// <4,6,3,1>: Cost 3 vuzpr <3,0,1,2>, RHS
  3705268583U,	// <4,6,3,2>: Cost 4 vext2 <2,3,4,6>, <3,2,6,4>
  2838727990U,	// <4,6,3,3>: Cost 3 vuzpr <3,3,3,3>, RHS
  2645461506U,	// <4,6,3,4>: Cost 3 vext2 <4,6,4,6>, <3,4,5,6>
  2839563574U,	// <4,6,3,5>: Cost 3 vuzpr <3,4,5,6>, RHS
  3913329974U,	// <4,6,3,6>: Cost 4 vuzpr <3,4,6,0>, RHS
  2722730572U,	// <4,6,3,7>: Cost 3 vext3 <6,3,7,4>, <6,3,7,4>
  2837097782U,	// <4,6,3,u>: Cost 3 vuzpr <3,0,u,2>, RHS
  2846461238U,	// <4,6,4,0>: Cost 3 vuzpr <4,6,0,2>, RHS
  3916295478U,	// <4,6,4,1>: Cost 4 vuzpr <4,0,1,2>, RHS
  2565211952U,	// <4,6,4,2>: Cost 3 vext1 <2,4,6,4>, <2,4,6,4>
  2571184649U,	// <4,6,4,3>: Cost 3 vext1 <3,4,6,4>, <3,4,6,4>
  2645462224U,	// <4,6,4,4>: Cost 3 vext2 <4,6,4,6>, <4,4,4,4>
  1571720502U,	// <4,6,4,5>: Cost 2 vext2 <4,6,4,6>, RHS
  1772539190U,	// <4,6,4,6>: Cost 2 vuzpr RHS, RHS
  2913389776U,	// <4,6,4,7>: Cost 3 vzipl RHS, <4,4,4,4>
  1772686646U,	// <4,6,4,u>: Cost 2 vuzpr RHS, RHS
  2577162342U,	// <4,6,5,0>: Cost 3 vext1 <4,4,6,5>, LHS
  2645462736U,	// <4,6,5,1>: Cost 3 vext2 <4,6,4,6>, <5,1,7,3>
  2990492982U,	// <4,6,5,2>: Cost 3 vzipr <6,2,7,3>, RHS
  3650906262U,	// <4,6,5,3>: Cost 4 vext1 <4,4,6,5>, <3,0,1,2>
  2577165202U,	// <4,6,5,4>: Cost 3 vext1 <4,4,6,5>, <4,0,5,1>
  2645463044U,	// <4,6,5,5>: Cost 3 vext2 <4,6,4,6>, <5,5,5,5>
  2645463138U,	// <4,6,5,6>: Cost 3 vext2 <4,6,4,6>, <5,6,7,0>
  2913388238U,	// <4,6,5,7>: Cost 3 vzipl RHS, <2,3,4,5>
  2577168174U,	// <4,6,5,u>: Cost 3 vext1 <4,4,6,5>, LHS
  1527316582U,	// <4,6,6,0>: Cost 2 vext1 <u,4,6,6>, LHS
  2601059062U,	// <4,6,6,1>: Cost 3 vext1 <u,4,6,6>, <1,0,3,2>
  2645463546U,	// <4,6,6,2>: Cost 3 vext2 <4,6,4,6>, <6,2,7,3>
  2577172994U,	// <4,6,6,3>: Cost 3 vext1 <4,4,6,6>, <3,4,5,6>
  1527319862U,	// <4,6,6,4>: Cost 2 vext1 <u,4,6,6>, RHS
  2645463784U,	// <4,6,6,5>: Cost 3 vext2 <4,6,4,6>, <6,5,6,7>
  2645463864U,	// <4,6,6,6>: Cost 3 vext2 <4,6,4,6>, <6,6,6,6>
  2913386700U,	// <4,6,6,7>: Cost 3 vzipl RHS, <0,2,4,6>
  1527322414U,	// <4,6,6,u>: Cost 2 vext1 <u,4,6,6>, LHS
  2645464058U,	// <4,6,7,0>: Cost 3 vext2 <4,6,4,6>, <7,0,1,2>
  2860469558U,	// <4,6,7,1>: Cost 3 vuzpr <7,0,1,2>, RHS
  3719206053U,	// <4,6,7,2>: Cost 4 vext2 <4,6,4,6>, <7,2,2,2>
  2725090156U,	// <4,6,7,3>: Cost 3 vext3 <6,7,3,4>, <6,7,3,4>
  2645464422U,	// <4,6,7,4>: Cost 3 vext2 <4,6,4,6>, <7,4,5,6>
  2725237630U,	// <4,6,7,5>: Cost 3 vext3 <6,7,5,4>, <6,7,5,4>
  3719206382U,	// <4,6,7,6>: Cost 4 vext2 <4,6,4,6>, <7,6,2,7>
  2645464684U,	// <4,6,7,7>: Cost 3 vext2 <4,6,4,6>, <7,7,7,7>
  2645464706U,	// <4,6,7,u>: Cost 3 vext2 <4,6,4,6>, <7,u,1,2>
  1527332966U,	// <4,6,u,0>: Cost 2 vext1 <u,4,6,u>, LHS
  1571723054U,	// <4,6,u,1>: Cost 2 vext2 <4,6,4,6>, LHS
  1793445174U,	// <4,6,u,2>: Cost 2 vuzpr LHS, RHS
  2645465020U,	// <4,6,u,3>: Cost 3 vext2 <4,6,4,6>, <u,3,0,1>
  1527336246U,	// <4,6,u,4>: Cost 2 vext1 <u,4,6,u>, RHS
  1571723418U,	// <4,6,u,5>: Cost 2 vext2 <4,6,4,6>, RHS
  1796427062U,	// <4,6,u,6>: Cost 2 vuzpr RHS, RHS
  2691912672U,	// <4,6,u,7>: Cost 3 vext3 <1,2,3,4>, <6,u,7,3>
  1571723621U,	// <4,6,u,u>: Cost 2 vext2 <4,6,4,6>, LHS
  3719208960U,	// <4,7,0,0>: Cost 4 vext2 <4,6,4,7>, <0,0,0,0>
  2645467238U,	// <4,7,0,1>: Cost 3 vext2 <4,6,4,7>, LHS
  2726343685U,	// <4,7,0,2>: Cost 3 vext3 <7,0,2,4>, <7,0,2,4>
  3656911356U,	// <4,7,0,3>: Cost 4 vext1 <5,4,7,0>, <3,4,5,0>
  3719209298U,	// <4,7,0,4>: Cost 4 vext2 <4,6,4,7>, <0,4,1,5>
  2259424608U,	// <4,7,0,5>: Cost 3 vrev <7,4,5,0>
  2259498345U,	// <4,7,0,6>: Cost 3 vrev <7,4,6,0>
  3800454194U,	// <4,7,0,7>: Cost 4 vext3 <7,0,7,4>, <7,0,7,4>
  2645467805U,	// <4,7,0,u>: Cost 3 vext2 <4,6,4,7>, LHS
  2259064116U,	// <4,7,1,0>: Cost 3 vrev <7,4,0,1>
  3719209780U,	// <4,7,1,1>: Cost 4 vext2 <4,6,4,7>, <1,1,1,1>
  2669355975U,	// <4,7,1,2>: Cost 3 vext2 <u,6,4,7>, <1,2,u,4>
  3656919504U,	// <4,7,1,3>: Cost 4 vext1 <5,4,7,1>, <3,4,0,1>
  3656920374U,	// <4,7,1,4>: Cost 4 vext1 <5,4,7,1>, RHS
  3719210128U,	// <4,7,1,5>: Cost 4 vext2 <4,6,4,7>, <1,5,3,7>
  3662893722U,	// <4,7,1,6>: Cost 4 vext1 <6,4,7,1>, <6,4,7,1>
  3807458432U,	// <4,7,1,7>: Cost 4 vext3 <u,2,3,4>, <7,1,7,1>
  2259654012U,	// <4,7,1,u>: Cost 3 vrev <7,4,u,1>
  3656925286U,	// <4,7,2,0>: Cost 4 vext1 <5,4,7,2>, LHS
  3801339038U,	// <4,7,2,1>: Cost 4 vext3 <7,2,1,4>, <7,2,1,4>
  3719210600U,	// <4,7,2,2>: Cost 4 vext2 <4,6,4,7>, <2,2,2,2>
  2727744688U,	// <4,7,2,3>: Cost 3 vext3 <7,2,3,4>, <7,2,3,4>
  3656928566U,	// <4,7,2,4>: Cost 4 vext1 <5,4,7,2>, RHS
  2632861554U,	// <4,7,2,5>: Cost 3 vext2 <2,5,4,7>, <2,5,4,7>
  3719210938U,	// <4,7,2,6>: Cost 4 vext2 <4,6,4,7>, <2,6,3,7>
  3807458515U,	// <4,7,2,7>: Cost 4 vext3 <u,2,3,4>, <7,2,7,3>
  2728113373U,	// <4,7,2,u>: Cost 3 vext3 <7,2,u,4>, <7,2,u,4>
  3719211158U,	// <4,7,3,0>: Cost 4 vext2 <4,6,4,7>, <3,0,1,2>
  3662906266U,	// <4,7,3,1>: Cost 4 vext1 <6,4,7,3>, <1,2,3,4>
  3662906922U,	// <4,7,3,2>: Cost 4 vext1 <6,4,7,3>, <2,1,4,3>
  3719211420U,	// <4,7,3,3>: Cost 4 vext2 <4,6,4,7>, <3,3,3,3>
  3719211522U,	// <4,7,3,4>: Cost 4 vext2 <4,6,4,7>, <3,4,5,6>
  2638834251U,	// <4,7,3,5>: Cost 3 vext2 <3,5,4,7>, <3,5,4,7>
  2639497884U,	// <4,7,3,6>: Cost 3 vext2 <3,6,4,7>, <3,6,4,7>
  3802445093U,	// <4,7,3,7>: Cost 4 vext3 <7,3,7,4>, <7,3,7,4>
  2640825150U,	// <4,7,3,u>: Cost 3 vext2 <3,u,4,7>, <3,u,4,7>
  2718750004U,	// <4,7,4,0>: Cost 3 vext3 <5,6,7,4>, <7,4,0,1>
  3792491836U,	// <4,7,4,1>: Cost 4 vext3 <5,6,7,4>, <7,4,1,0>
  3656943310U,	// <4,7,4,2>: Cost 4 vext1 <5,4,7,4>, <2,3,4,5>
  3990490320U,	// <4,7,4,3>: Cost 4 vzipl <5,1,7,3>, <4,4,4,4>
  2645470416U,	// <4,7,4,4>: Cost 3 vext2 <4,6,4,7>, <4,4,4,4>
  2645470518U,	// <4,7,4,5>: Cost 3 vext2 <4,6,4,7>, RHS
  2645470581U,	// <4,7,4,6>: Cost 3 vext2 <4,6,4,7>, <4,6,4,7>
  3719212444U,	// <4,7,4,7>: Cost 4 vext2 <4,6,4,7>, <4,7,0,1>
  2645470761U,	// <4,7,4,u>: Cost 3 vext2 <4,6,4,7>, RHS
  2589180006U,	// <4,7,5,0>: Cost 3 vext1 <6,4,7,5>, LHS
  3719212752U,	// <4,7,5,1>: Cost 4 vext2 <4,6,4,7>, <5,1,7,3>
  2589181646U,	// <4,7,5,2>: Cost 3 vext1 <6,4,7,5>, <2,3,4,5>
  3990488782U,	// <4,7,5,3>: Cost 4 vzipl <5,1,7,3>, <2,3,4,5>
  2589183286U,	// <4,7,5,4>: Cost 3 vext1 <6,4,7,5>, RHS
  3719213060U,	// <4,7,5,5>: Cost 4 vext2 <4,6,4,7>, <5,5,5,5>
  2589184670U,	// <4,7,5,6>: Cost 3 vext1 <6,4,7,5>, <6,4,7,5>
  2595157367U,	// <4,7,5,7>: Cost 3 vext1 <7,4,7,5>, <7,4,7,5>
  2589185838U,	// <4,7,5,u>: Cost 3 vext1 <6,4,7,5>, LHS
  1509474406U,	// <4,7,6,0>: Cost 2 vext1 <5,4,7,6>, LHS
  2583216886U,	// <4,7,6,1>: Cost 3 vext1 <5,4,7,6>, <1,0,3,2>
  2583217768U,	// <4,7,6,2>: Cost 3 vext1 <5,4,7,6>, <2,2,2,2>
  2583218326U,	// <4,7,6,3>: Cost 3 vext1 <5,4,7,6>, <3,0,1,2>
  1509477686U,	// <4,7,6,4>: Cost 2 vext1 <5,4,7,6>, RHS
  1509478342U,	// <4,7,6,5>: Cost 2 vext1 <5,4,7,6>, <5,4,7,6>
  2583220730U,	// <4,7,6,6>: Cost 3 vext1 <5,4,7,6>, <6,2,7,3>
  2583221242U,	// <4,7,6,7>: Cost 3 vext1 <5,4,7,6>, <7,0,1,2>
  1509480238U,	// <4,7,6,u>: Cost 2 vext1 <5,4,7,6>, LHS
  3719214074U,	// <4,7,7,0>: Cost 4 vext2 <4,6,4,7>, <7,0,1,2>
  3934211466U,	// <4,7,7,1>: Cost 4 vuzpr <7,0,1,2>, <4,6,7,1>
  3705279664U,	// <4,7,7,2>: Cost 4 vext2 <2,3,4,7>, <7,2,3,4>
  3804804677U,	// <4,7,7,3>: Cost 4 vext3 <7,7,3,4>, <7,7,3,4>
  3719214427U,	// <4,7,7,4>: Cost 4 vext2 <4,6,4,7>, <7,4,4,4>
  2662725039U,	// <4,7,7,5>: Cost 3 vext2 <7,5,4,7>, <7,5,4,7>
  3992507094U,	// <4,7,7,6>: Cost 4 vzipl <5,4,7,6>, <6,5,4,7>
  2718750316U,	// <4,7,7,7>: Cost 3 vext3 <5,6,7,4>, <7,7,7,7>
  2664715938U,	// <4,7,7,u>: Cost 3 vext2 <7,u,4,7>, <7,u,4,7>
  1509490790U,	// <4,7,u,0>: Cost 2 vext1 <5,4,7,u>, LHS
  2645473070U,	// <4,7,u,1>: Cost 3 vext2 <4,6,4,7>, LHS
  2583234152U,	// <4,7,u,2>: Cost 3 vext1 <5,4,7,u>, <2,2,2,2>
  2583234710U,	// <4,7,u,3>: Cost 3 vext1 <5,4,7,u>, <3,0,1,2>
  1509494070U,	// <4,7,u,4>: Cost 2 vext1 <5,4,7,u>, RHS
  1509494728U,	// <4,7,u,5>: Cost 2 vext1 <5,4,7,u>, <5,4,7,u>
  2583237114U,	// <4,7,u,6>: Cost 3 vext1 <5,4,7,u>, <6,2,7,3>
  2583237626U,	// <4,7,u,7>: Cost 3 vext1 <5,4,7,u>, <7,0,1,2>
  1509496622U,	// <4,7,u,u>: Cost 2 vext1 <5,4,7,u>, LHS
  2819919176U,	// <4,u,0,0>: Cost 3 vuzpr <0,2,0,2>, RHS
  1557799014U,	// <4,u,0,1>: Cost 2 vext2 <2,3,4,u>, LHS
  1745669448U,	// <4,u,0,2>: Cost 2 vuzpr LHS, RHS
  2691913445U,	// <4,u,0,3>: Cost 3 vext3 <1,2,3,4>, <u,0,3,2>
  2571300150U,	// <4,u,0,4>: Cost 3 vext1 <3,4,u,0>, RHS
  2691913462U,	// <4,u,0,5>: Cost 3 vext3 <1,2,3,4>, <u,0,5,1>
  2691913472U,	// <4,u,0,6>: Cost 3 vext3 <1,2,3,4>, <u,0,6,2>
  2595190139U,	// <4,u,0,7>: Cost 3 vext1 <7,4,u,0>, <7,4,u,0>
  1746111816U,	// <4,u,0,u>: Cost 2 vuzpr LHS, RHS
  2631541494U,	// <4,u,1,0>: Cost 3 vext2 <2,3,4,u>, <1,0,3,2>
  2825293128U,	// <4,u,1,1>: Cost 3 vuzpr <1,1,1,1>, RHS
  1618171694U,	// <4,u,1,2>: Cost 2 vext3 <1,2,3,4>, LHS
  2824785224U,	// <4,u,1,3>: Cost 3 vuzpr <1,0,3,2>, RHS
  2695894848U,	// <4,u,1,4>: Cost 3 vext3 <1,u,3,4>, <u,1,4,3>
  2645476496U,	// <4,u,1,5>: Cost 3 vext2 <4,6,4,u>, <1,5,3,7>
  2645460192U,	// <4,u,1,6>: Cost 3 vext2 <4,6,4,6>, <1,6,3,6>
  2691913563U,	// <4,u,1,7>: Cost 3 vext3 <1,2,3,4>, <u,1,7,3>
  1618171748U,	// <4,u,1,u>: Cost 2 vext3 <1,2,3,4>, LHS
  2691913580U,	// <4,u,2,0>: Cost 3 vext3 <1,2,3,4>, <u,2,0,2>
  2630215215U,	// <4,u,2,1>: Cost 3 vext2 <2,1,4,u>, <2,1,4,u>
  2832010568U,	// <4,u,2,2>: Cost 3 vuzpr <2,2,2,2>, RHS
  1557800657U,	// <4,u,2,3>: Cost 2 vext2 <2,3,4,u>, <2,3,4,u>
  2692282257U,	// <4,u,2,4>: Cost 3 vext3 <1,2,u,4>, <u,2,4,3>
  2733864859U,	// <4,u,2,5>: Cost 3 vext3 <u,2,5,4>, <u,2,5,4>
  2645477306U,	// <4,u,2,6>: Cost 3 vext2 <4,6,4,u>, <2,6,3,7>
  2691913644U,	// <4,u,2,7>: Cost 3 vext3 <1,2,3,4>, <u,2,7,3>
  1561118822U,	// <4,u,2,u>: Cost 2 vext2 <2,u,4,u>, <2,u,4,u>
  2691913660U,	// <4,u,3,0>: Cost 3 vext3 <1,2,3,4>, <u,3,0,1>
  2836581704U,	// <4,u,3,1>: Cost 3 vuzpr <3,0,1,2>, RHS
  2636851545U,	// <4,u,3,2>: Cost 3 vext2 <3,2,4,u>, <3,2,4,u>
  2631543196U,	// <4,u,3,3>: Cost 3 vext2 <2,3,4,u>, <3,3,3,3>
  2691913700U,	// <4,u,3,4>: Cost 3 vext3 <1,2,3,4>, <u,3,4,5>
  2839563592U,	// <4,u,3,5>: Cost 3 vuzpr <3,4,5,6>, RHS
  2658060980U,	// <4,u,3,6>: Cost 3 vext2 <6,7,4,5>, <3,6,7,4>
  2734675966U,	// <4,u,3,7>: Cost 3 vext3 <u,3,7,4>, <u,3,7,4>
  2691913732U,	// <4,u,3,u>: Cost 3 vext3 <1,2,3,4>, <u,3,u,1>
  1503559782U,	// <4,u,4,0>: Cost 2 vext1 <4,4,u,4>, LHS
  2692282391U,	// <4,u,4,1>: Cost 3 vext3 <1,2,u,4>, <u,4,1,2>
  2631543889U,	// <4,u,4,2>: Cost 3 vext2 <2,3,4,u>, <4,2,u,3>
  2571332123U,	// <4,u,4,3>: Cost 3 vext1 <3,4,u,4>, <3,4,u,4>
  161926454U,	// <4,u,4,4>: Cost 1 vdup0 RHS
  1557802294U,	// <4,u,4,5>: Cost 2 vext2 <2,3,4,u>, RHS
  1772539208U,	// <4,u,4,6>: Cost 2 vuzpr RHS, RHS
  2913537232U,	// <4,u,4,7>: Cost 3 vzipl RHS, <4,4,4,4>
  161926454U,	// <4,u,4,u>: Cost 1 vdup0 RHS
  1526939750U,	// <4,u,5,0>: Cost 2 vext1 <u,4,1,5>, LHS
  1927662902U,	// <4,u,5,1>: Cost 2 vzipr LHS, RHS
  2589255374U,	// <4,u,5,2>: Cost 3 vext1 <6,4,u,5>, <2,3,4,5>
  2886960846U,	// <4,u,5,3>: Cost 3 vzipl LHS, <2,3,4,5>
  1526943030U,	// <4,u,5,4>: Cost 2 vext1 <u,4,1,5>, RHS
  1930644790U,	// <4,u,5,5>: Cost 2 vzipr RHS, RHS
  1618172058U,	// <4,u,5,6>: Cost 2 vext3 <1,2,3,4>, RHS
  2913535694U,	// <4,u,5,7>: Cost 3 vzipl RHS, <2,3,4,5>
  1618172076U,	// <4,u,5,u>: Cost 2 vext3 <1,2,3,4>, RHS
  1497604198U,	// <4,u,6,0>: Cost 2 vext1 <3,4,u,6>, LHS
  2559403115U,	// <4,u,6,1>: Cost 3 vext1 <1,4,u,6>, <1,4,u,6>
  2061880630U,	// <4,u,6,2>: Cost 2 vtrnr LHS, RHS
  1497606685U,	// <4,u,6,3>: Cost 2 vext1 <3,4,u,6>, <3,4,u,6>
  1497607478U,	// <4,u,6,4>: Cost 2 vext1 <3,4,u,6>, RHS
  1509552079U,	// <4,u,6,5>: Cost 2 vext1 <5,4,u,6>, <5,4,u,6>
  2064862518U,	// <4,u,6,6>: Cost 2 vtrnr RHS, RHS
  27705344U,	// <4,u,6,7>: Cost 0 copy RHS
  27705344U,	// <4,u,6,u>: Cost 0 copy RHS
  2645480442U,	// <4,u,7,0>: Cost 3 vext2 <4,6,4,u>, <7,0,1,2>
  2860469576U,	// <4,u,7,1>: Cost 3 vuzpr <7,0,1,2>, RHS
  2631521456U,	// <4,u,7,2>: Cost 3 vext2 <2,3,4,5>, <7,2,3,4>
  2661405966U,	// <4,u,7,3>: Cost 3 vext2 <7,3,4,u>, <7,3,4,u>
  2645480806U,	// <4,u,7,4>: Cost 3 vext2 <4,6,4,u>, <7,4,5,6>
  2863451464U,	// <4,u,7,5>: Cost 3 vuzpr <7,4,5,6>, RHS
  2663396865U,	// <4,u,7,6>: Cost 3 vext2 <7,6,4,u>, <7,6,4,u>
  2645481068U,	// <4,u,7,7>: Cost 3 vext2 <4,6,4,u>, <7,7,7,7>
  2645481090U,	// <4,u,7,u>: Cost 3 vext2 <4,6,4,u>, <7,u,1,2>
  1497620582U,	// <4,u,u,0>: Cost 2 vext1 <3,4,u,u>, LHS
  1557804846U,	// <4,u,u,1>: Cost 2 vext2 <2,3,4,u>, LHS
  1618172261U,	// <4,u,u,2>: Cost 2 vext3 <1,2,3,4>, LHS
  1497623071U,	// <4,u,u,3>: Cost 2 vext1 <3,4,u,u>, <3,4,u,u>
  161926454U,	// <4,u,u,4>: Cost 1 vdup0 RHS
  1557805210U,	// <4,u,u,5>: Cost 2 vext2 <2,3,4,u>, RHS
  1618172301U,	// <4,u,u,6>: Cost 2 vext3 <1,2,3,4>, RHS
  27705344U,	// <4,u,u,7>: Cost 0 copy RHS
  27705344U,	// <4,u,u,u>: Cost 0 copy RHS
  2698625024U,	// <5,0,0,0>: Cost 3 vext3 <2,3,4,5>, <0,0,0,0>
  2698625034U,	// <5,0,0,1>: Cost 3 vext3 <2,3,4,5>, <0,0,1,1>
  2698625044U,	// <5,0,0,2>: Cost 3 vext3 <2,3,4,5>, <0,0,2,2>
  3715907845U,	// <5,0,0,3>: Cost 4 vext2 <4,1,5,0>, <0,3,2,0>
  2684690473U,	// <5,0,0,4>: Cost 3 vext3 <0,0,4,5>, <0,0,4,5>
  3733160348U,	// <5,0,0,5>: Cost 4 vext2 <7,0,5,0>, <0,5,0,7>
  3292094923U,	// <5,0,0,6>: Cost 4 vrev <0,5,6,0>
  3998630419U,	// <5,0,0,7>: Cost 5 vzipl <6,5,0,7>, <0,6,5,0>
  2698625097U,	// <5,0,0,u>: Cost 3 vext3 <2,3,4,5>, <0,0,u,1>
  2642166518U,	// <5,0,1,0>: Cost 3 vext2 <4,1,5,0>, <1,0,3,2>
  2953670352U,	// <5,0,1,1>: Cost 3 vzipr LHS, <5,1,7,3>
  1624883302U,	// <5,0,1,2>: Cost 2 vext3 <2,3,4,5>, LHS
  3645123105U,	// <5,0,1,3>: Cost 4 vext1 <3,5,0,1>, <3,5,0,1>
  2577353978U,	// <5,0,1,4>: Cost 3 vext1 <4,5,0,1>, <4,5,0,1>
  2583326675U,	// <5,0,1,5>: Cost 3 vext1 <5,5,0,1>, <5,5,0,1>
  3651097082U,	// <5,0,1,6>: Cost 4 vext1 <4,5,0,1>, <6,2,7,3>
  3669013893U,	// <5,0,1,7>: Cost 4 vext1 <7,5,0,1>, <7,5,0,1>
  1624883356U,	// <5,0,1,u>: Cost 2 vext3 <2,3,4,5>, LHS
  2686017700U,	// <5,0,2,0>: Cost 3 vext3 <0,2,4,5>, <0,2,0,2>
  4027371288U,	// <5,0,2,1>: Cost 4 vzipr LHS, <5,2,6,3>
  3759759543U,	// <5,0,2,2>: Cost 4 vext3 <0,2,4,5>, <0,2,2,3>
  2638186190U,	// <5,0,2,3>: Cost 3 vext2 <3,4,5,0>, <2,3,4,5>
  2686017739U,	// <5,0,2,4>: Cost 3 vext3 <0,2,4,5>, <0,2,4,5>
  3639160528U,	// <5,0,2,5>: Cost 4 vext1 <2,5,0,2>, <5,1,7,3>
  3645133089U,	// <5,0,2,6>: Cost 4 vext1 <3,5,0,2>, <6,0,1,2>
  2686238950U,	// <5,0,2,7>: Cost 3 vext3 <0,2,7,5>, <0,2,7,5>
  2686312687U,	// <5,0,2,u>: Cost 3 vext3 <0,2,u,5>, <0,2,u,5>
  3776348407U,	// <5,0,3,0>: Cost 4 vext3 <3,0,4,5>, <0,3,0,4>
  3711928588U,	// <5,0,3,1>: Cost 4 vext2 <3,4,5,0>, <3,1,5,3>
  3772367109U,	// <5,0,3,2>: Cost 4 vext3 <2,3,4,5>, <0,3,2,0>
  3711265195U,	// <5,0,3,3>: Cost 4 vext2 <3,3,5,0>, <3,3,5,0>
  2638187004U,	// <5,0,3,4>: Cost 3 vext2 <3,4,5,0>, <3,4,5,0>
  3776348452U,	// <5,0,3,5>: Cost 4 vext3 <3,0,4,5>, <0,3,5,4>
  3713256094U,	// <5,0,3,6>: Cost 4 vext2 <3,6,5,0>, <3,6,5,0>
  3713919727U,	// <5,0,3,7>: Cost 4 vext2 <3,7,5,0>, <3,7,5,0>
  2640841536U,	// <5,0,3,u>: Cost 3 vext2 <3,u,5,0>, <3,u,5,0>
  2559459430U,	// <5,0,4,0>: Cost 3 vext1 <1,5,0,4>, LHS
  1613381970U,	// <5,0,4,1>: Cost 2 vext3 <0,4,1,5>, <0,4,1,5>
  2717942108U,	// <5,0,4,2>: Cost 3 vext3 <5,5,5,5>, <0,4,2,6>
  3711929436U,	// <5,0,4,3>: Cost 4 vext2 <3,4,5,0>, <4,3,0,5>
  2559462710U,	// <5,0,4,4>: Cost 3 vext1 <1,5,0,4>, RHS
  2638187830U,	// <5,0,4,5>: Cost 3 vext2 <3,4,5,0>, RHS
  3711929676U,	// <5,0,4,6>: Cost 4 vext2 <3,4,5,0>, <4,6,0,2>
  3735817632U,	// <5,0,4,7>: Cost 4 vext2 <7,4,5,0>, <4,7,0,5>
  1613898129U,	// <5,0,4,u>: Cost 2 vext3 <0,4,u,5>, <0,4,u,5>
  3705294407U,	// <5,0,5,0>: Cost 4 vext2 <2,3,5,0>, <5,0,1,1>
  2953629700U,	// <5,0,5,1>: Cost 3 vzipr LHS, <5,5,5,5>
  3087847428U,	// <5,0,5,2>: Cost 3 vtrnr LHS, <5,5,5,5>
  3778707892U,	// <5,0,5,3>: Cost 4 vext3 <3,4,0,5>, <0,5,3,4>
  3778707897U,	// <5,0,5,4>: Cost 4 vext3 <3,4,0,5>, <0,5,4,0>
  2650796031U,	// <5,0,5,5>: Cost 3 vext2 <5,5,5,0>, <5,5,5,0>
  3729846348U,	// <5,0,5,6>: Cost 4 vext2 <6,4,5,0>, <5,6,4,5>
  3923382390U,	// <5,0,5,7>: Cost 4 vuzpr <5,1,7,3>, <5,7,0,2>
  3088289796U,	// <5,0,5,u>: Cost 3 vtrnr LHS, <5,5,5,5>
  3791684077U,	// <5,0,6,0>: Cost 4 vext3 <5,5,5,5>, <0,6,0,7>
  2953629794U,	// <5,0,6,1>: Cost 3 vzipr LHS, <5,6,7,0>
  4161589016U,	// <5,0,6,2>: Cost 4 vtrnr LHS, <5,2,6,3>
  3715912266U,	// <5,0,6,3>: Cost 4 vext2 <4,1,5,0>, <6,3,7,2>
  3711931038U,	// <5,0,6,4>: Cost 4 vext2 <3,4,5,0>, <6,4,7,5>
  3737146034U,	// <5,0,6,5>: Cost 4 vext2 <7,6,5,0>, <6,5,0,7>
  3735819064U,	// <5,0,6,6>: Cost 4 vext2 <7,4,5,0>, <6,6,6,6>
  2662077302U,	// <5,0,6,7>: Cost 3 vext2 <7,4,5,0>, <6,7,4,5>
  2662077302U,	// <5,0,6,u>: Cost 3 vext2 <7,4,5,0>, <6,7,4,5>
  2589343846U,	// <5,0,7,0>: Cost 3 vext1 <6,5,0,7>, LHS
  3044166966U,	// <5,0,7,1>: Cost 3 vtrnl <4,0,5,1>, RHS
  3087847120U,	// <5,0,7,2>: Cost 3 vtrnr LHS, <5,1,7,3>
  3645172263U,	// <5,0,7,3>: Cost 4 vext1 <3,5,0,7>, <3,5,0,7>
  2589347126U,	// <5,0,7,4>: Cost 3 vext1 <6,5,0,7>, RHS
  2589347938U,	// <5,0,7,5>: Cost 3 vext1 <6,5,0,7>, <5,6,7,0>
  2589348530U,	// <5,0,7,6>: Cost 3 vext1 <6,5,0,7>, <6,5,0,7>
  3663090682U,	// <5,0,7,7>: Cost 4 vext1 <6,5,0,7>, <7,0,1,2>
  3088289488U,	// <5,0,7,u>: Cost 3 vtrnr LHS, <5,1,7,3>
  2698625674U,	// <5,0,u,0>: Cost 3 vext3 <2,3,4,5>, <0,u,0,2>
  1616036502U,	// <5,0,u,1>: Cost 2 vext3 <0,u,1,5>, <0,u,1,5>
  1624883869U,	// <5,0,u,2>: Cost 2 vext3 <2,3,4,5>, LHS
  2638186190U,	// <5,0,u,3>: Cost 3 vext2 <3,4,5,0>, <2,3,4,5>
  2689999537U,	// <5,0,u,4>: Cost 3 vext3 <0,u,4,5>, <0,u,4,5>
  2638190746U,	// <5,0,u,5>: Cost 3 vext2 <3,4,5,0>, RHS
  2589356723U,	// <5,0,u,6>: Cost 3 vext1 <6,5,0,u>, <6,5,0,u>
  2662077302U,	// <5,0,u,7>: Cost 3 vext2 <7,4,5,0>, <6,7,4,5>
  1624883923U,	// <5,0,u,u>: Cost 2 vext3 <2,3,4,5>, LHS
  2641510400U,	// <5,1,0,0>: Cost 3 vext2 <4,0,5,1>, <0,0,0,0>
  1567768678U,	// <5,1,0,1>: Cost 2 vext2 <4,0,5,1>, LHS
  2641510564U,	// <5,1,0,2>: Cost 3 vext2 <4,0,5,1>, <0,2,0,2>
  2698625782U,	// <5,1,0,3>: Cost 3 vext3 <2,3,4,5>, <1,0,3,2>
  2641510738U,	// <5,1,0,4>: Cost 3 vext2 <4,0,5,1>, <0,4,1,5>
  2641510814U,	// <5,1,0,5>: Cost 3 vext2 <4,0,5,1>, <0,5,1,0>
  3663106740U,	// <5,1,0,6>: Cost 4 vext1 <6,5,1,0>, <6,5,1,0>
  3669079437U,	// <5,1,0,7>: Cost 4 vext1 <7,5,1,0>, <7,5,1,0>
  1567769245U,	// <5,1,0,u>: Cost 2 vext2 <4,0,5,1>, LHS
  2641511158U,	// <5,1,1,0>: Cost 3 vext2 <4,0,5,1>, <1,0,3,2>
  2691326772U,	// <5,1,1,1>: Cost 3 vext3 <1,1,4,5>, <1,1,1,1>
  2641511318U,	// <5,1,1,2>: Cost 3 vext2 <4,0,5,1>, <1,2,3,0>
  2698625864U,	// <5,1,1,3>: Cost 3 vext3 <2,3,4,5>, <1,1,3,3>
  2691326803U,	// <5,1,1,4>: Cost 3 vext3 <1,1,4,5>, <1,1,4,5>
  2583400412U,	// <5,1,1,5>: Cost 3 vext1 <5,5,1,1>, <5,5,1,1>
  3657142778U,	// <5,1,1,6>: Cost 4 vext1 <5,5,1,1>, <6,2,7,3>
  3657143290U,	// <5,1,1,7>: Cost 4 vext1 <5,5,1,1>, <7,0,1,2>
  2691621751U,	// <5,1,1,u>: Cost 3 vext3 <1,1,u,5>, <1,1,u,5>
  3708618209U,	// <5,1,2,0>: Cost 4 vext2 <2,u,5,1>, <2,0,5,2>
  3765068679U,	// <5,1,2,1>: Cost 4 vext3 <1,1,4,5>, <1,2,1,3>
  2641512040U,	// <5,1,2,2>: Cost 3 vext2 <4,0,5,1>, <2,2,2,2>
  2698625942U,	// <5,1,2,3>: Cost 3 vext3 <2,3,4,5>, <1,2,3,0>
  2691990436U,	// <5,1,2,4>: Cost 3 vext3 <1,2,4,5>, <1,2,4,5>
  2687124395U,	// <5,1,2,5>: Cost 3 vext3 <0,4,1,5>, <1,2,5,3>
  2665400250U,	// <5,1,2,6>: Cost 3 vext2 <u,0,5,1>, <2,6,3,7>
  3731843079U,	// <5,1,2,7>: Cost 4 vext2 <6,7,5,1>, <2,7,3,3>
  2692285384U,	// <5,1,2,u>: Cost 3 vext3 <1,2,u,5>, <1,2,u,5>
  2641512598U,	// <5,1,3,0>: Cost 3 vext2 <4,0,5,1>, <3,0,1,2>
  3772367832U,	// <5,1,3,1>: Cost 4 vext3 <2,3,4,5>, <1,3,1,3>
  3705301307U,	// <5,1,3,2>: Cost 4 vext2 <2,3,5,1>, <3,2,1,5>
  2641512860U,	// <5,1,3,3>: Cost 3 vext2 <4,0,5,1>, <3,3,3,3>
  2641512916U,	// <5,1,3,4>: Cost 3 vext2 <4,0,5,1>, <3,4,0,5>
  3705301545U,	// <5,1,3,5>: Cost 4 vext2 <2,3,5,1>, <3,5,1,0>
  3715254922U,	// <5,1,3,6>: Cost 4 vext2 <4,0,5,1>, <3,6,2,7>
  3735161570U,	// <5,1,3,7>: Cost 4 vext2 <7,3,5,1>, <3,7,3,5>
  2641513246U,	// <5,1,3,u>: Cost 3 vext2 <4,0,5,1>, <3,u,1,2>
  1567771538U,	// <5,1,4,0>: Cost 2 vext2 <4,0,5,1>, <4,0,5,1>
  2642176995U,	// <5,1,4,1>: Cost 3 vext2 <4,1,5,1>, <4,1,5,1>
  2693170228U,	// <5,1,4,2>: Cost 3 vext3 <1,4,2,5>, <1,4,2,5>
  2693243965U,	// <5,1,4,3>: Cost 3 vext3 <1,4,3,5>, <1,4,3,5>
  2665401552U,	// <5,1,4,4>: Cost 3 vext2 <u,0,5,1>, <4,4,4,4>
  1567771958U,	// <5,1,4,5>: Cost 2 vext2 <4,0,5,1>, RHS
  2641513804U,	// <5,1,4,6>: Cost 3 vext2 <4,0,5,1>, <4,6,0,2>
  3669112209U,	// <5,1,4,7>: Cost 4 vext1 <7,5,1,4>, <7,5,1,4>
  1567772201U,	// <5,1,4,u>: Cost 2 vext2 <4,0,5,1>, RHS
  2734900335U,	// <5,1,5,0>: Cost 3 vext3 <u,4,1,5>, <1,5,0,1>
  2631560912U,	// <5,1,5,1>: Cost 3 vext2 <2,3,5,1>, <5,1,7,3>
  2641514219U,	// <5,1,5,2>: Cost 3 vext2 <4,0,5,1>, <5,2,1,3>
  2717942928U,	// <5,1,5,3>: Cost 3 vext3 <5,5,5,5>, <1,5,3,7>
  2665402310U,	// <5,1,5,4>: Cost 3 vext2 <u,0,5,1>, <5,4,7,6>
  2665402372U,	// <5,1,5,5>: Cost 3 vext2 <u,0,5,1>, <5,5,5,5>
  2665402466U,	// <5,1,5,6>: Cost 3 vext2 <u,0,5,1>, <5,6,7,0>
  3705303158U,	// <5,1,5,7>: Cost 4 vext2 <2,3,5,1>, <5,7,0,2>
  2641514705U,	// <5,1,5,u>: Cost 3 vext2 <4,0,5,1>, <5,u,1,3>
  2601353318U,	// <5,1,6,0>: Cost 3 vext1 <u,5,1,6>, LHS
  3966141520U,	// <5,1,6,1>: Cost 4 vzipl <1,1,1,1>, <1,4,5,6>
  2641515002U,	// <5,1,6,2>: Cost 3 vext2 <4,0,5,1>, <6,2,7,3>
  3715256882U,	// <5,1,6,3>: Cost 4 vext2 <4,0,5,1>, <6,3,4,5>
  2601356598U,	// <5,1,6,4>: Cost 3 vext1 <u,5,1,6>, RHS
  2601357410U,	// <5,1,6,5>: Cost 3 vext1 <u,5,1,6>, <5,6,7,0>
  2665403192U,	// <5,1,6,6>: Cost 3 vext2 <u,0,5,1>, <6,6,6,6>
  2658104187U,	// <5,1,6,7>: Cost 3 vext2 <6,7,5,1>, <6,7,5,1>
  2641515488U,	// <5,1,6,u>: Cost 3 vext2 <4,0,5,1>, <6,u,7,3>
  2571501670U,	// <5,1,7,0>: Cost 3 vext1 <3,5,1,7>, LHS
  3026619702U,	// <5,1,7,1>: Cost 3 vtrnl <1,1,1,1>, RHS
  4100295990U,	// <5,1,7,2>: Cost 4 vtrnl <1,1,0,2>, RHS
  1946996022U,	// <5,1,7,3>: Cost 2 vtrnl LHS, RHS
  2571504950U,	// <5,1,7,4>: Cost 3 vext1 <3,5,1,7>, RHS
  2571505360U,	// <5,1,7,5>: Cost 3 vext1 <3,5,1,7>, <5,1,7,3>
  3645247994U,	// <5,1,7,6>: Cost 4 vext1 <3,5,1,7>, <6,2,7,3>
  2595394964U,	// <5,1,7,7>: Cost 3 vext1 <7,5,1,7>, <7,5,1,7>
  1947036982U,	// <5,1,7,u>: Cost 2 vtrnl LHS, RHS
  1591662326U,	// <5,1,u,0>: Cost 2 vext2 <u,0,5,1>, <u,0,5,1>
  1567774510U,	// <5,1,u,1>: Cost 2 vext2 <4,0,5,1>, LHS
  2641516396U,	// <5,1,u,2>: Cost 3 vext2 <4,0,5,1>, <u,2,0,2>
  1946996023U,	// <5,1,u,3>: Cost 2 vtrnl LHS, RHS
  2571513142U,	// <5,1,u,4>: Cost 3 vext1 <3,5,1,u>, RHS
  1567774874U,	// <5,1,u,5>: Cost 2 vext2 <4,0,5,1>, RHS
  2641516720U,	// <5,1,u,6>: Cost 3 vext2 <4,0,5,1>, <u,6,0,2>
  2595403157U,	// <5,1,u,7>: Cost 3 vext1 <7,5,1,u>, <7,5,1,u>
  1947036983U,	// <5,1,u,u>: Cost 2 vtrnl LHS, RHS
  3772368308U,	// <5,2,0,0>: Cost 4 vext3 <2,3,4,5>, <2,0,0,2>
  2635546726U,	// <5,2,0,1>: Cost 3 vext2 <3,0,5,2>, LHS
  3759760836U,	// <5,2,0,2>: Cost 4 vext3 <0,2,4,5>, <2,0,2,0>
  3772368334U,	// <5,2,0,3>: Cost 4 vext3 <2,3,4,5>, <2,0,3,1>
  2698626520U,	// <5,2,0,4>: Cost 3 vext3 <2,3,4,5>, <2,0,4,2>
  3759760867U,	// <5,2,0,5>: Cost 4 vext3 <0,2,4,5>, <2,0,5,4>
  3791685100U,	// <5,2,0,6>: Cost 4 vext3 <5,5,5,5>, <2,0,6,4>
  3304114054U,	// <5,2,0,7>: Cost 4 vrev <2,5,7,0>
  2635547293U,	// <5,2,0,u>: Cost 3 vext2 <3,0,5,2>, LHS
  3772368390U,	// <5,2,1,0>: Cost 4 vext3 <2,3,4,5>, <2,1,0,3>
  3709289268U,	// <5,2,1,1>: Cost 4 vext2 <3,0,5,2>, <1,1,1,1>
  2642183062U,	// <5,2,1,2>: Cost 3 vext2 <4,1,5,2>, <1,2,3,0>
  2891164562U,	// <5,2,1,3>: Cost 3 vzipl LHS, <4,0,5,1>
  3771041324U,	// <5,2,1,4>: Cost 4 vext3 <2,1,4,5>, <2,1,4,5>
  3766027827U,	// <5,2,1,5>: Cost 4 vext3 <1,2,u,5>, <2,1,5,3>
  3808200252U,	// <5,2,1,6>: Cost 4 vext3 <u,3,4,5>, <2,1,6,3>
  3669161367U,	// <5,2,1,7>: Cost 4 vext1 <7,5,2,1>, <7,5,2,1>
  2886560658U,	// <5,2,1,u>: Cost 3 vzipl LHS, <4,0,5,1>
  3703317985U,	// <5,2,2,0>: Cost 4 vext2 <2,0,5,2>, <2,0,5,2>
  3633333378U,	// <5,2,2,1>: Cost 4 vext1 <1,5,2,2>, <1,5,2,2>
  2697963112U,	// <5,2,2,2>: Cost 3 vext3 <2,2,4,5>, <2,2,2,2>
  2698626674U,	// <5,2,2,3>: Cost 3 vext3 <2,3,4,5>, <2,2,3,3>
  2697963133U,	// <5,2,2,4>: Cost 3 vext3 <2,2,4,5>, <2,2,4,5>
  3759761027U,	// <5,2,2,5>: Cost 4 vext3 <0,2,4,5>, <2,2,5,2>
  3739150266U,	// <5,2,2,6>: Cost 4 vext2 <u,0,5,2>, <2,6,3,7>
  3719243780U,	// <5,2,2,7>: Cost 4 vext2 <4,6,5,2>, <2,7,3,0>
  2698258081U,	// <5,2,2,u>: Cost 3 vext3 <2,2,u,5>, <2,2,u,5>
  2698626726U,	// <5,2,3,0>: Cost 3 vext3 <2,3,4,5>, <2,3,0,1>
  2698405555U,	// <5,2,3,1>: Cost 3 vext3 <2,3,1,5>, <2,3,1,5>
  2577516238U,	// <5,2,3,2>: Cost 3 vext1 <4,5,2,3>, <2,3,4,5>
  3960261686U,	// <5,2,3,3>: Cost 4 vzipl LHS, <4,2,5,3>
  1624884942U,	// <5,2,3,4>: Cost 2 vext3 <2,3,4,5>, <2,3,4,5>
  2698700503U,	// <5,2,3,5>: Cost 3 vext3 <2,3,5,5>, <2,3,5,5>
  3772368605U,	// <5,2,3,6>: Cost 4 vext3 <2,3,4,5>, <2,3,6,2>
  3669177753U,	// <5,2,3,7>: Cost 4 vext1 <7,5,2,3>, <7,5,2,3>
  1625179890U,	// <5,2,3,u>: Cost 2 vext3 <2,3,u,5>, <2,3,u,5>
  2698626808U,	// <5,2,4,0>: Cost 3 vext3 <2,3,4,5>, <2,4,0,2>
  2642185188U,	// <5,2,4,1>: Cost 3 vext2 <4,1,5,2>, <4,1,5,2>
  2642848821U,	// <5,2,4,2>: Cost 3 vext2 <4,2,5,2>, <4,2,5,2>
  2699216662U,	// <5,2,4,3>: Cost 3 vext3 <2,4,3,5>, <2,4,3,5>
  2698626848U,	// <5,2,4,4>: Cost 3 vext3 <2,3,4,5>, <2,4,4,6>
  2635550006U,	// <5,2,4,5>: Cost 3 vext2 <3,0,5,2>, RHS
  2699437873U,	// <5,2,4,6>: Cost 3 vext3 <2,4,6,5>, <2,4,6,5>
  3304146826U,	// <5,2,4,7>: Cost 4 vrev <2,5,7,4>
  2635550249U,	// <5,2,4,u>: Cost 3 vext2 <3,0,5,2>, RHS
  2601418854U,	// <5,2,5,0>: Cost 3 vext1 <u,5,2,5>, LHS
  3703320272U,	// <5,2,5,1>: Cost 4 vext2 <2,0,5,2>, <5,1,7,3>
  3705310960U,	// <5,2,5,2>: Cost 4 vext2 <2,3,5,2>, <5,2,1,u>
  2934295770U,	// <5,2,5,3>: Cost 3 vzipl LHS, <4,4,5,5>
  2601422134U,	// <5,2,5,4>: Cost 3 vext1 <u,5,2,5>, RHS
  2601422852U,	// <5,2,5,5>: Cost 3 vext1 <u,5,2,5>, <5,5,5,5>
  3791685508U,	// <5,2,5,6>: Cost 4 vext3 <5,5,5,5>, <2,5,6,7>
  3675165690U,	// <5,2,5,7>: Cost 4 vext1 <u,5,2,5>, <7,0,1,2>
  2934336730U,	// <5,2,5,u>: Cost 3 vzipl LHS, <4,4,5,5>
  3645309030U,	// <5,2,6,0>: Cost 4 vext1 <3,5,2,6>, LHS
  3633366150U,	// <5,2,6,1>: Cost 4 vext1 <1,5,2,6>, <1,5,2,6>
  2645504506U,	// <5,2,6,2>: Cost 3 vext2 <4,6,5,2>, <6,2,7,3>
  2886519298U,	// <5,2,6,3>: Cost 3 vzipl LHS, <3,4,5,6>
  2700617665U,	// <5,2,6,4>: Cost 3 vext3 <2,6,4,5>, <2,6,4,5>
  3645312792U,	// <5,2,6,5>: Cost 4 vext1 <3,5,2,6>, <5,2,6,3>
  3791685590U,	// <5,2,6,6>: Cost 4 vext3 <5,5,5,5>, <2,6,6,u>
  3798910939U,	// <5,2,6,7>: Cost 4 vext3 <6,7,4,5>, <2,6,7,4>
  2886560258U,	// <5,2,6,u>: Cost 3 vzipl LHS, <3,4,5,6>
  3027422518U,	// <5,2,7,0>: Cost 3 vtrnl <1,2,3,0>, RHS
  4095569206U,	// <5,2,7,1>: Cost 4 vtrnl <0,2,u,1>, RHS
  3021245750U,	// <5,2,7,2>: Cost 3 vtrnl <0,2,0,2>, RHS
  3033419062U,	// <5,2,7,3>: Cost 3 vtrnl <2,2,3,3>, RHS
  3027455286U,	// <5,2,7,4>: Cost 3 vtrnl <1,2,3,4>, RHS
  4095307062U,	// <5,2,7,5>: Cost 4 vtrnl <0,2,4,5>, RHS
  2589496004U,	// <5,2,7,6>: Cost 3 vext1 <6,5,2,7>, <6,5,2,7>
  3663238138U,	// <5,2,7,7>: Cost 4 vext1 <6,5,2,7>, <7,0,1,2>
  3021294902U,	// <5,2,7,u>: Cost 3 vtrnl <0,2,0,u>, RHS
  3027422519U,	// <5,2,u,0>: Cost 3 vtrnl <1,2,3,0>, RHS
  2635552558U,	// <5,2,u,1>: Cost 3 vext2 <3,0,5,2>, LHS
  3021245751U,	// <5,2,u,2>: Cost 3 vtrnl <0,2,0,2>, RHS
  2886519300U,	// <5,2,u,3>: Cost 3 vzipl LHS, <3,4,5,u>
  1628203107U,	// <5,2,u,4>: Cost 2 vext3 <2,u,4,5>, <2,u,4,5>
  2635552922U,	// <5,2,u,5>: Cost 3 vext2 <3,0,5,2>, RHS
  2589504197U,	// <5,2,u,6>: Cost 3 vext1 <6,5,2,u>, <6,5,2,u>
  3663246330U,	// <5,2,u,7>: Cost 4 vext1 <6,5,2,u>, <7,0,1,2>
  1628498055U,	// <5,2,u,u>: Cost 2 vext3 <2,u,u,5>, <2,u,u,5>
  3772369035U,	// <5,3,0,0>: Cost 4 vext3 <2,3,4,5>, <3,0,0,0>
  2698627222U,	// <5,3,0,1>: Cost 3 vext3 <2,3,4,5>, <3,0,1,2>
  3759761565U,	// <5,3,0,2>: Cost 4 vext3 <0,2,4,5>, <3,0,2,0>
  3772369063U,	// <5,3,0,3>: Cost 4 vext3 <2,3,4,5>, <3,0,3,1>
  2702608564U,	// <5,3,0,4>: Cost 3 vext3 <3,0,4,5>, <3,0,4,5>
  3772369082U,	// <5,3,0,5>: Cost 4 vext3 <2,3,4,5>, <3,0,5,2>
  3310013014U,	// <5,3,0,6>: Cost 4 vrev <3,5,6,0>
  3310086751U,	// <5,3,0,7>: Cost 4 vrev <3,5,7,0>
  2698627285U,	// <5,3,0,u>: Cost 3 vext3 <2,3,4,5>, <3,0,u,2>
  2601459814U,	// <5,3,1,0>: Cost 3 vext1 <u,5,3,1>, LHS
  3765070054U,	// <5,3,1,1>: Cost 4 vext3 <1,1,4,5>, <3,1,1,1>
  2624938923U,	// <5,3,1,2>: Cost 3 vext2 <1,2,5,3>, <1,2,5,3>
  3966307218U,	// <5,3,1,3>: Cost 4 vzipl <1,1,3,3>, <4,0,5,1>
  2601462674U,	// <5,3,1,4>: Cost 3 vext1 <u,5,3,1>, <4,0,5,1>
  2698627340U,	// <5,3,1,5>: Cost 3 vext3 <2,3,4,5>, <3,1,5,3>
  3675206138U,	// <5,3,1,6>: Cost 4 vext1 <u,5,3,1>, <6,2,7,3>
  3669235104U,	// <5,3,1,7>: Cost 4 vext1 <7,5,3,1>, <7,5,3,1>
  2601465646U,	// <5,3,1,u>: Cost 3 vext1 <u,5,3,1>, LHS
  3772369198U,	// <5,3,2,0>: Cost 4 vext3 <2,3,4,5>, <3,2,0,1>
  3703989811U,	// <5,3,2,1>: Cost 4 vext2 <2,1,5,3>, <2,1,5,3>
  3771705665U,	// <5,3,2,2>: Cost 4 vext3 <2,2,4,5>, <3,2,2,2>
  2698627404U,	// <5,3,2,3>: Cost 3 vext3 <2,3,4,5>, <3,2,3,4>
  2703935830U,	// <5,3,2,4>: Cost 3 vext3 <3,2,4,5>, <3,2,4,5>
  2698627422U,	// <5,3,2,5>: Cost 3 vext3 <2,3,4,5>, <3,2,5,4>
  3720579002U,	// <5,3,2,6>: Cost 4 vext2 <4,u,5,3>, <2,6,3,7>
  3777898865U,	// <5,3,2,7>: Cost 5 vext3 <3,2,7,5>, <3,2,7,5>
  2701945209U,	// <5,3,2,u>: Cost 3 vext3 <2,u,4,5>, <3,2,u,4>
  3772369279U,	// <5,3,3,0>: Cost 4 vext3 <2,3,4,5>, <3,3,0,1>
  2636220684U,	// <5,3,3,1>: Cost 3 vext2 <3,1,5,3>, <3,1,5,3>
  3772369298U,	// <5,3,3,2>: Cost 4 vext3 <2,3,4,5>, <3,3,2,2>
  2698627484U,	// <5,3,3,3>: Cost 3 vext3 <2,3,4,5>, <3,3,3,3>
  2704599463U,	// <5,3,3,4>: Cost 3 vext3 <3,3,4,5>, <3,3,4,5>
  2704673200U,	// <5,3,3,5>: Cost 3 vext3 <3,3,5,5>, <3,3,5,5>
  3733850808U,	// <5,3,3,6>: Cost 4 vext2 <7,1,5,3>, <3,6,7,u>
  4010797891U,	// <5,3,3,7>: Cost 4 vzipl <u,5,3,7>, <3,u,5,3>
  2704894411U,	// <5,3,3,u>: Cost 3 vext3 <3,3,u,5>, <3,3,u,5>
  2704968148U,	// <5,3,4,0>: Cost 3 vext3 <3,4,0,5>, <3,4,0,5>
  3772369370U,	// <5,3,4,1>: Cost 4 vext3 <2,3,4,5>, <3,4,1,2>
  2642857014U,	// <5,3,4,2>: Cost 3 vext2 <4,2,5,3>, <4,2,5,3>
  2643520647U,	// <5,3,4,3>: Cost 3 vext2 <4,3,5,3>, <4,3,5,3>
  2705263096U,	// <5,3,4,4>: Cost 3 vext3 <3,4,4,5>, <3,4,4,5>
  2698627580U,	// <5,3,4,5>: Cost 3 vext3 <2,3,4,5>, <3,4,5,0>
  3772369413U,	// <5,3,4,6>: Cost 4 vext3 <2,3,4,5>, <3,4,6,0>
  3808201238U,	// <5,3,4,7>: Cost 4 vext3 <u,3,4,5>, <3,4,7,u>
  2698627613U,	// <5,3,4,u>: Cost 3 vext3 <2,3,4,5>, <3,4,u,6>
  2571632742U,	// <5,3,5,0>: Cost 3 vext1 <3,5,3,5>, LHS
  2559689870U,	// <5,3,5,1>: Cost 3 vext1 <1,5,3,5>, <1,5,3,5>
  2565662567U,	// <5,3,5,2>: Cost 3 vext1 <2,5,3,5>, <2,5,3,5>
  2571635202U,	// <5,3,5,3>: Cost 3 vext1 <3,5,3,5>, <3,4,5,6>
  2571636022U,	// <5,3,5,4>: Cost 3 vext1 <3,5,3,5>, RHS
  2601496580U,	// <5,3,5,5>: Cost 3 vext1 <u,5,3,5>, <5,5,5,5>
  3645378849U,	// <5,3,5,6>: Cost 4 vext1 <3,5,3,5>, <6,0,1,2>
  3675239418U,	// <5,3,5,7>: Cost 4 vext1 <u,5,3,5>, <7,0,1,2>
  2571638574U,	// <5,3,5,u>: Cost 3 vext1 <3,5,3,5>, LHS
  2601500774U,	// <5,3,6,0>: Cost 3 vext1 <u,5,3,6>, LHS
  3639411508U,	// <5,3,6,1>: Cost 4 vext1 <2,5,3,6>, <1,1,1,1>
  2565670760U,	// <5,3,6,2>: Cost 3 vext1 <2,5,3,6>, <2,5,3,6>
  2601503234U,	// <5,3,6,3>: Cost 3 vext1 <u,5,3,6>, <3,4,5,6>
  2601504054U,	// <5,3,6,4>: Cost 3 vext1 <u,5,3,6>, RHS
  4181741336U,	// <5,3,6,5>: Cost 4 vtrnr <3,4,5,6>, <5,2,6,3>
  3720581944U,	// <5,3,6,6>: Cost 4 vext2 <4,u,5,3>, <6,6,6,6>
  2725169844U,	// <5,3,6,7>: Cost 3 vext3 <6,7,4,5>, <3,6,7,4>
  2601506606U,	// <5,3,6,u>: Cost 3 vext1 <u,5,3,6>, LHS
  1527767142U,	// <5,3,7,0>: Cost 2 vext1 <u,5,3,7>, LHS
  1485964432U,	// <5,3,7,1>: Cost 2 vext1 <1,5,3,7>, <1,5,3,7>
  2601510504U,	// <5,3,7,2>: Cost 3 vext1 <u,5,3,7>, <2,2,2,2>
  3040054582U,	// <5,3,7,3>: Cost 3 vtrnl <3,3,3,3>, RHS
  1527770422U,	// <5,3,7,4>: Cost 2 vext1 <u,5,3,7>, RHS
  3034172726U,	// <5,3,7,5>: Cost 3 vtrnl <2,3,4,5>, RHS
  2601513466U,	// <5,3,7,6>: Cost 3 vext1 <u,5,3,7>, <6,2,7,3>
  2601513978U,	// <5,3,7,7>: Cost 3 vext1 <u,5,3,7>, <7,0,1,2>
  1527772974U,	// <5,3,7,u>: Cost 2 vext1 <u,5,3,7>, LHS
  1527775334U,	// <5,3,u,0>: Cost 2 vext1 <u,5,3,u>, LHS
  1485972625U,	// <5,3,u,1>: Cost 2 vext1 <1,5,3,u>, <1,5,3,u>
  2666747802U,	// <5,3,u,2>: Cost 3 vext2 <u,2,5,3>, <u,2,5,3>
  3040054583U,	// <5,3,u,3>: Cost 3 vtrnl <3,3,3,3>, RHS
  1527778614U,	// <5,3,u,4>: Cost 2 vext1 <u,5,3,u>, RHS
  2698627907U,	// <5,3,u,5>: Cost 3 vext3 <2,3,4,5>, <3,u,5,3>
  2601521658U,	// <5,3,u,6>: Cost 3 vext1 <u,5,3,u>, <6,2,7,3>
  2601522170U,	// <5,3,u,7>: Cost 3 vext1 <u,5,3,u>, <7,0,1,2>
  1527781166U,	// <5,3,u,u>: Cost 2 vext1 <u,5,3,u>, LHS
  3772369765U,	// <5,4,0,0>: Cost 4 vext3 <2,3,4,5>, <4,0,0,1>
  2636890214U,	// <5,4,0,1>: Cost 3 vext2 <3,2,5,4>, LHS
  3703333028U,	// <5,4,0,2>: Cost 4 vext2 <2,0,5,4>, <0,2,0,2>
  3782249348U,	// <5,4,0,3>: Cost 4 vext3 <4,0,3,5>, <4,0,3,5>
  3782323085U,	// <5,4,0,4>: Cost 4 vext3 <4,0,4,5>, <4,0,4,5>
  2698627986U,	// <5,4,0,5>: Cost 3 vext3 <2,3,4,5>, <4,0,5,1>
  2698627996U,	// <5,4,0,6>: Cost 3 vext3 <2,3,4,5>, <4,0,6,2>
  3669300648U,	// <5,4,0,7>: Cost 4 vext1 <7,5,4,0>, <7,5,4,0>
  2698628013U,	// <5,4,0,u>: Cost 3 vext3 <2,3,4,5>, <4,0,u,1>
  2241809658U,	// <5,4,1,0>: Cost 3 vrev <4,5,0,1>
  3698025307U,	// <5,4,1,1>: Cost 4 vext2 <1,1,5,4>, <1,1,5,4>
  3772369866U,	// <5,4,1,2>: Cost 4 vext3 <2,3,4,5>, <4,1,2,3>
  3315772693U,	// <5,4,1,3>: Cost 4 vrev <4,5,3,1>
  3700016206U,	// <5,4,1,4>: Cost 4 vext2 <1,4,5,4>, <1,4,5,4>
  2980499152U,	// <5,4,1,5>: Cost 3 vzipr RHS, <5,1,7,3>
  3765070828U,	// <5,4,1,6>: Cost 4 vext3 <1,1,4,5>, <4,1,6,1>
  3669308841U,	// <5,4,1,7>: Cost 4 vext1 <7,5,4,1>, <7,5,4,1>
  2242399554U,	// <5,4,1,u>: Cost 3 vrev <4,5,u,1>
  3703334371U,	// <5,4,2,0>: Cost 4 vext2 <2,0,5,4>, <2,0,5,4>
  3315633412U,	// <5,4,2,1>: Cost 4 vrev <4,5,1,2>
  3704661637U,	// <5,4,2,2>: Cost 4 vext2 <2,2,5,4>, <2,2,5,4>
  2636891854U,	// <5,4,2,3>: Cost 3 vext2 <3,2,5,4>, <2,3,4,5>
  3772369967U,	// <5,4,2,4>: Cost 4 vext3 <2,3,4,5>, <4,2,4,5>
  2698628150U,	// <5,4,2,5>: Cost 3 vext3 <2,3,4,5>, <4,2,5,3>
  3771706430U,	// <5,4,2,6>: Cost 4 vext3 <2,2,4,5>, <4,2,6,2>
  3707979802U,	// <5,4,2,7>: Cost 4 vext2 <2,7,5,4>, <2,7,5,4>
  2666752099U,	// <5,4,2,u>: Cost 3 vext2 <u,2,5,4>, <2,u,4,5>
  3710634134U,	// <5,4,3,0>: Cost 4 vext2 <3,2,5,4>, <3,0,1,2>
  3710634252U,	// <5,4,3,1>: Cost 4 vext2 <3,2,5,4>, <3,1,5,3>
  2636892510U,	// <5,4,3,2>: Cost 3 vext2 <3,2,5,4>, <3,2,5,4>
  3710634396U,	// <5,4,3,3>: Cost 4 vext2 <3,2,5,4>, <3,3,3,3>
  2638219776U,	// <5,4,3,4>: Cost 3 vext2 <3,4,5,4>, <3,4,5,4>
  3772370052U,	// <5,4,3,5>: Cost 4 vext3 <2,3,4,5>, <4,3,5,0>
  2710719634U,	// <5,4,3,6>: Cost 3 vext3 <4,3,6,5>, <4,3,6,5>
  3713952499U,	// <5,4,3,7>: Cost 4 vext2 <3,7,5,4>, <3,7,5,4>
  2640874308U,	// <5,4,3,u>: Cost 3 vext2 <3,u,5,4>, <3,u,5,4>
  2583642214U,	// <5,4,4,0>: Cost 3 vext1 <5,5,4,4>, LHS
  2642201574U,	// <5,4,4,1>: Cost 3 vext2 <4,1,5,4>, <4,1,5,4>
  3710635062U,	// <5,4,4,2>: Cost 4 vext2 <3,2,5,4>, <4,2,5,3>
  3717270664U,	// <5,4,4,3>: Cost 4 vext2 <4,3,5,4>, <4,3,5,4>
  2583645402U,	// <5,4,4,4>: Cost 3 vext1 <5,5,4,4>, <4,4,5,5>
  1637567706U,	// <5,4,4,5>: Cost 2 vext3 <4,4,5,5>, <4,4,5,5>
  2711383267U,	// <5,4,4,6>: Cost 3 vext3 <4,4,6,5>, <4,4,6,5>
  3657389050U,	// <5,4,4,7>: Cost 4 vext1 <5,5,4,4>, <7,0,1,2>
  1637788917U,	// <5,4,4,u>: Cost 2 vext3 <4,4,u,5>, <4,4,u,5>
  2698628346U,	// <5,4,5,0>: Cost 3 vext3 <2,3,4,5>, <4,5,0,1>
  2559763607U,	// <5,4,5,1>: Cost 3 vext1 <1,5,4,5>, <1,5,4,5>
  2698628366U,	// <5,4,5,2>: Cost 3 vext3 <2,3,4,5>, <4,5,2,3>
  3772370196U,	// <5,4,5,3>: Cost 4 vext3 <2,3,4,5>, <4,5,3,0>
  2698628386U,	// <5,4,5,4>: Cost 3 vext3 <2,3,4,5>, <4,5,4,5>
  2980499460U,	// <5,4,5,5>: Cost 3 vzipr RHS, <5,5,5,5>
  1624886582U,	// <5,4,5,6>: Cost 2 vext3 <2,3,4,5>, RHS
  3923382430U,	// <5,4,5,7>: Cost 4 vuzpr <5,1,7,3>, <5,7,4,6>
  1624886600U,	// <5,4,5,u>: Cost 2 vext3 <2,3,4,5>, RHS
  2698628428U,	// <5,4,6,0>: Cost 3 vext3 <2,3,4,5>, <4,6,0,2>
  3765071188U,	// <5,4,6,1>: Cost 4 vext3 <1,1,4,5>, <4,6,1,1>
  2698628448U,	// <5,4,6,2>: Cost 3 vext3 <2,3,4,5>, <4,6,2,4>
  2712489322U,	// <5,4,6,3>: Cost 3 vext3 <4,6,3,5>, <4,6,3,5>
  2712857972U,	// <5,4,6,4>: Cost 3 vext3 <4,6,u,5>, <4,6,4,6>
  2980499554U,	// <5,4,6,5>: Cost 3 vzipr RHS, <5,6,7,0>
  4114630504U,	// <5,4,6,6>: Cost 4 vtrnl <3,4,5,6>, <2,5,3,6>
  2658128766U,	// <5,4,6,7>: Cost 3 vext2 <6,7,5,4>, <6,7,5,4>
  2712858007U,	// <5,4,6,u>: Cost 3 vext3 <4,6,u,5>, <4,6,u,5>
  2589638758U,	// <5,4,7,0>: Cost 3 vext1 <6,5,4,7>, LHS
  2565751706U,	// <5,4,7,1>: Cost 3 vext1 <2,5,4,7>, <1,2,3,4>
  2565752690U,	// <5,4,7,2>: Cost 3 vext1 <2,5,4,7>, <2,5,4,7>
  2571725387U,	// <5,4,7,3>: Cost 3 vext1 <3,5,4,7>, <3,5,4,7>
  2589642038U,	// <5,4,7,4>: Cost 3 vext1 <6,5,4,7>, RHS
  2589642694U,	// <5,4,7,5>: Cost 3 vext1 <6,5,4,7>, <5,4,7,6>
  94817590U,	// <5,4,7,6>: Cost 1 vrev RHS
  2595616175U,	// <5,4,7,7>: Cost 3 vext1 <7,5,4,7>, <7,5,4,7>
  94965064U,	// <5,4,7,u>: Cost 1 vrev RHS
  2698628590U,	// <5,4,u,0>: Cost 3 vext3 <2,3,4,5>, <4,u,0,2>
  2636896046U,	// <5,4,u,1>: Cost 3 vext2 <3,2,5,4>, LHS
  2242014483U,	// <5,4,u,2>: Cost 3 vrev <4,5,2,u>
  2713816588U,	// <5,4,u,3>: Cost 3 vext3 <4,u,3,5>, <4,u,3,5>
  2242161957U,	// <5,4,u,4>: Cost 3 vrev <4,5,4,u>
  1640222238U,	// <5,4,u,5>: Cost 2 vext3 <4,u,5,5>, <4,u,5,5>
  94825783U,	// <5,4,u,6>: Cost 1 vrev RHS
  2595624368U,	// <5,4,u,7>: Cost 3 vext1 <7,5,4,u>, <7,5,4,u>
  94973257U,	// <5,4,u,u>: Cost 1 vrev RHS
  2650832896U,	// <5,5,0,0>: Cost 3 vext2 <5,5,5,5>, <0,0,0,0>
  1577091174U,	// <5,5,0,1>: Cost 2 vext2 <5,5,5,5>, LHS
  2650833060U,	// <5,5,0,2>: Cost 3 vext2 <5,5,5,5>, <0,2,0,2>
  3645483597U,	// <5,5,0,3>: Cost 4 vext1 <3,5,5,0>, <3,5,5,0>
  2650833234U,	// <5,5,0,4>: Cost 3 vext2 <5,5,5,5>, <0,4,1,5>
  2248142847U,	// <5,5,0,5>: Cost 3 vrev <5,5,5,0>
  3724575213U,	// <5,5,0,6>: Cost 4 vext2 <5,5,5,5>, <0,6,0,7>
  3766029950U,	// <5,5,0,7>: Cost 4 vext3 <1,2,u,5>, <5,0,7,2>
  1577091741U,	// <5,5,0,u>: Cost 2 vext2 <5,5,5,5>, LHS
  2650833654U,	// <5,5,1,0>: Cost 3 vext2 <5,5,5,5>, <1,0,3,2>
  2909948818U,	// <5,5,1,1>: Cost 3 vzipl <4,0,5,1>, <4,0,5,1>
  2650833814U,	// <5,5,1,2>: Cost 3 vext2 <5,5,5,5>, <1,2,3,0>
  3645491790U,	// <5,5,1,3>: Cost 4 vext1 <3,5,5,1>, <3,5,5,1>
  2715217591U,	// <5,5,1,4>: Cost 3 vext3 <5,1,4,5>, <5,1,4,5>
  2650834064U,	// <5,5,1,5>: Cost 3 vext2 <5,5,5,5>, <1,5,3,7>
  3980413842U,	// <5,5,1,6>: Cost 4 vzipl <3,4,5,6>, <4,0,5,1>
  2692288208U,	// <5,5,1,7>: Cost 3 vext3 <1,2,u,5>, <5,1,7,3>
  2698628825U,	// <5,5,1,u>: Cost 3 vext3 <2,3,4,5>, <5,1,u,3>
  3772370659U,	// <5,5,2,0>: Cost 4 vext3 <2,3,4,5>, <5,2,0,4>
  3772370667U,	// <5,5,2,1>: Cost 4 vext3 <2,3,4,5>, <5,2,1,3>
  2650834536U,	// <5,5,2,2>: Cost 3 vext2 <5,5,5,5>, <2,2,2,2>
  2698628862U,	// <5,5,2,3>: Cost 3 vext3 <2,3,4,5>, <5,2,3,4>
  3772370691U,	// <5,5,2,4>: Cost 4 vext3 <2,3,4,5>, <5,2,4,0>
  2711310095U,	// <5,5,2,5>: Cost 3 vext3 <4,4,5,5>, <5,2,5,3>
  2650834874U,	// <5,5,2,6>: Cost 3 vext2 <5,5,5,5>, <2,6,3,7>
  3759763232U,	// <5,5,2,7>: Cost 4 vext3 <0,2,4,5>, <5,2,7,2>
  2701946667U,	// <5,5,2,u>: Cost 3 vext3 <2,u,4,5>, <5,2,u,4>
  2650835094U,	// <5,5,3,0>: Cost 3 vext2 <5,5,5,5>, <3,0,1,2>
  3772370750U,	// <5,5,3,1>: Cost 4 vext3 <2,3,4,5>, <5,3,1,5>
  3772370757U,	// <5,5,3,2>: Cost 4 vext3 <2,3,4,5>, <5,3,2,3>
  2637564336U,	// <5,5,3,3>: Cost 3 vext2 <3,3,5,5>, <3,3,5,5>
  2650835458U,	// <5,5,3,4>: Cost 3 vext2 <5,5,5,5>, <3,4,5,6>
  2638891602U,	// <5,5,3,5>: Cost 3 vext2 <3,5,5,5>, <3,5,5,5>
  3790434155U,	// <5,5,3,6>: Cost 4 vext3 <5,3,6,5>, <5,3,6,5>
  2716766068U,	// <5,5,3,7>: Cost 3 vext3 <5,3,7,5>, <5,3,7,5>
  2650835742U,	// <5,5,3,u>: Cost 3 vext2 <5,5,5,5>, <3,u,1,2>
  2650835858U,	// <5,5,4,0>: Cost 3 vext2 <5,5,5,5>, <4,0,5,1>
  2716987279U,	// <5,5,4,1>: Cost 3 vext3 <5,4,1,5>, <5,4,1,5>
  3772370840U,	// <5,5,4,2>: Cost 4 vext3 <2,3,4,5>, <5,4,2,5>
  3645516369U,	// <5,5,4,3>: Cost 4 vext1 <3,5,5,4>, <3,5,5,4>
  1570458842U,	// <5,5,4,4>: Cost 2 vext2 <4,4,5,5>, <4,4,5,5>
  1577094454U,	// <5,5,4,5>: Cost 2 vext2 <5,5,5,5>, RHS
  2846281732U,	// <5,5,4,6>: Cost 3 vuzpr RHS, <5,5,5,5>
  2717945798U,	// <5,5,4,7>: Cost 3 vext3 <5,5,5,5>, <5,4,7,6>
  1577094697U,	// <5,5,4,u>: Cost 2 vext2 <5,5,5,5>, RHS
  1509982310U,	// <5,5,5,0>: Cost 2 vext1 <5,5,5,5>, LHS
  2583724790U,	// <5,5,5,1>: Cost 3 vext1 <5,5,5,5>, <1,0,3,2>
  2583725672U,	// <5,5,5,2>: Cost 3 vext1 <5,5,5,5>, <2,2,2,2>
  2583726230U,	// <5,5,5,3>: Cost 3 vext1 <5,5,5,5>, <3,0,1,2>
  1509985590U,	// <5,5,5,4>: Cost 2 vext1 <5,5,5,5>, RHS
  229035318U,	// <5,5,5,5>: Cost 1 vdup1 RHS
  2583728634U,	// <5,5,5,6>: Cost 3 vext1 <5,5,5,5>, <6,2,7,3>
  3047608324U,	// <5,5,5,7>: Cost 3 vtrnl RHS, <5,5,5,5>
  229035318U,	// <5,5,5,u>: Cost 1 vdup1 RHS
  3779596324U,	// <5,5,6,0>: Cost 4 vext3 <3,5,3,5>, <5,6,0,1>
  3983690242U,	// <5,5,6,1>: Cost 4 vzipl <4,0,5,1>, <3,4,5,6>
  2650837498U,	// <5,5,6,2>: Cost 3 vext2 <5,5,5,5>, <6,2,7,3>
  3779596354U,	// <5,5,6,3>: Cost 4 vext3 <3,5,3,5>, <5,6,3,4>
  2718535756U,	// <5,5,6,4>: Cost 3 vext3 <5,6,4,5>, <5,6,4,5>
  2717945943U,	// <5,5,6,5>: Cost 3 vext3 <5,5,5,5>, <5,6,5,7>
  2906671618U,	// <5,5,6,6>: Cost 3 vzipl <3,4,5,6>, <3,4,5,6>
  2717356130U,	// <5,5,6,7>: Cost 3 vext3 <5,4,6,5>, <5,6,7,0>
  2650837919U,	// <5,5,6,u>: Cost 3 vext2 <5,5,5,5>, <6,u,0,1>
  2650838010U,	// <5,5,7,0>: Cost 3 vext2 <5,5,5,5>, <7,0,1,2>
  4120857910U,	// <5,5,7,1>: Cost 4 vtrnl <4,5,0,1>, RHS
  4114894134U,	// <5,5,7,2>: Cost 4 vtrnl <3,5,0,2>, RHS
  2571799124U,	// <5,5,7,3>: Cost 3 vext1 <3,5,5,7>, <3,5,5,7>
  2650838374U,	// <5,5,7,4>: Cost 3 vext2 <5,5,5,5>, <7,4,5,6>
  2650838454U,	// <5,5,7,5>: Cost 3 vext2 <5,5,5,5>, <7,5,5,5>
  4193751138U,	// <5,5,7,6>: Cost 4 vtrnr <5,4,6,5>, <5,6,7,0>
  1973865782U,	// <5,5,7,7>: Cost 2 vtrnl RHS, RHS
  1973873974U,	// <5,5,7,u>: Cost 2 vtrnl RHS, RHS
  1509982310U,	// <5,5,u,0>: Cost 2 vext1 <5,5,5,5>, LHS
  1577097006U,	// <5,5,u,1>: Cost 2 vext2 <5,5,5,5>, LHS
  2650838892U,	// <5,5,u,2>: Cost 3 vext2 <5,5,5,5>, <u,2,0,2>
  2650838972U,	// <5,5,u,3>: Cost 3 vext2 <5,5,5,5>, <u,3,0,1>
  1594349630U,	// <5,5,u,4>: Cost 2 vext2 <u,4,5,5>, <u,4,5,5>
  229035318U,	// <5,5,u,5>: Cost 1 vdup1 RHS
  2650839216U,	// <5,5,u,6>: Cost 3 vext2 <5,5,5,5>, <u,6,0,2>
  1973865783U,	// <5,5,u,7>: Cost 2 vtrnl RHS, RHS
  229035318U,	// <5,5,u,u>: Cost 1 vdup1 RHS
  2638233600U,	// <5,6,0,0>: Cost 3 vext2 <3,4,5,6>, <0,0,0,0>
  1564491878U,	// <5,6,0,1>: Cost 2 vext2 <3,4,5,6>, LHS
  2632261796U,	// <5,6,0,2>: Cost 3 vext2 <2,4,5,6>, <0,2,0,2>
  2577787394U,	// <5,6,0,3>: Cost 3 vext1 <4,5,6,0>, <3,4,5,6>
  2577788207U,	// <5,6,0,4>: Cost 3 vext1 <4,5,6,0>, <4,5,6,0>
  3711975847U,	// <5,6,0,5>: Cost 4 vext2 <3,4,5,6>, <0,5,2,0>
  3651531041U,	// <5,6,0,6>: Cost 4 vext1 <4,5,6,0>, <6,0,1,2>
  3772371286U,	// <5,6,0,7>: Cost 4 vext3 <2,3,4,5>, <6,0,7,1>
  1564492445U,	// <5,6,0,u>: Cost 2 vext2 <3,4,5,6>, LHS
  2638234358U,	// <5,6,1,0>: Cost 3 vext2 <3,4,5,6>, <1,0,3,2>
  2626290484U,	// <5,6,1,1>: Cost 3 vext2 <1,4,5,6>, <1,1,1,1>
  2638234518U,	// <5,6,1,2>: Cost 3 vext2 <3,4,5,6>, <1,2,3,0>
  3711976398U,	// <5,6,1,3>: Cost 4 vext2 <3,4,5,6>, <1,3,0,2>
  2626290768U,	// <5,6,1,4>: Cost 3 vext2 <1,4,5,6>, <1,4,5,6>
  2662122640U,	// <5,6,1,5>: Cost 3 vext2 <7,4,5,6>, <1,5,3,7>
  3999730578U,	// <5,6,1,6>: Cost 4 vzipl <6,6,6,6>, <4,0,5,1>
  2913389458U,	// <5,6,1,7>: Cost 3 vzipl RHS, <4,0,5,1>
  2628945300U,	// <5,6,1,u>: Cost 3 vext2 <1,u,5,6>, <1,u,5,6>
  3706004925U,	// <5,6,2,0>: Cost 4 vext2 <2,4,5,6>, <2,0,1,2>
  3700033055U,	// <5,6,2,1>: Cost 4 vext2 <1,4,5,6>, <2,1,3,1>
  2638235240U,	// <5,6,2,2>: Cost 3 vext2 <3,4,5,6>, <2,2,2,2>
  2638235302U,	// <5,6,2,3>: Cost 3 vext2 <3,4,5,6>, <2,3,0,1>
  2632263465U,	// <5,6,2,4>: Cost 3 vext2 <2,4,5,6>, <2,4,5,6>
  2638235496U,	// <5,6,2,5>: Cost 3 vext2 <3,4,5,6>, <2,5,3,6>
  2662123450U,	// <5,6,2,6>: Cost 3 vext2 <7,4,5,6>, <2,6,3,7>
  2698629626U,	// <5,6,2,7>: Cost 3 vext3 <2,3,4,5>, <6,2,7,3>
  2698629635U,	// <5,6,2,u>: Cost 3 vext3 <2,3,4,5>, <6,2,u,3>
  2638235798U,	// <5,6,3,0>: Cost 3 vext2 <3,4,5,6>, <3,0,1,2>
  3700033766U,	// <5,6,3,1>: Cost 4 vext2 <1,4,5,6>, <3,1,1,1>
  3711977774U,	// <5,6,3,2>: Cost 4 vext2 <3,4,5,6>, <3,2,0,1>
  2638236060U,	// <5,6,3,3>: Cost 3 vext2 <3,4,5,6>, <3,3,3,3>
  1564494338U,	// <5,6,3,4>: Cost 2 vext2 <3,4,5,6>, <3,4,5,6>
  2638236194U,	// <5,6,3,5>: Cost 3 vext2 <3,4,5,6>, <3,5,0,2>
  3711978122U,	// <5,6,3,6>: Cost 4 vext2 <3,4,5,6>, <3,6,2,7>
  2662124267U,	// <5,6,3,7>: Cost 3 vext2 <7,4,5,6>, <3,7,4,5>
  1567148870U,	// <5,6,3,u>: Cost 2 vext2 <3,u,5,6>, <3,u,5,6>
  2638236562U,	// <5,6,4,0>: Cost 3 vext2 <3,4,5,6>, <4,0,5,1>
  2638236654U,	// <5,6,4,1>: Cost 3 vext2 <3,4,5,6>, <4,1,6,3>
  2723033713U,	// <5,6,4,2>: Cost 3 vext3 <6,4,2,5>, <6,4,2,5>
  2638236818U,	// <5,6,4,3>: Cost 3 vext2 <3,4,5,6>, <4,3,6,5>
  2644208859U,	// <5,6,4,4>: Cost 3 vext2 <4,4,5,6>, <4,4,5,6>
  1564495158U,	// <5,6,4,5>: Cost 2 vext2 <3,4,5,6>, RHS
  2638237004U,	// <5,6,4,6>: Cost 3 vext2 <3,4,5,6>, <4,6,0,2>
  2723402398U,	// <5,6,4,7>: Cost 3 vext3 <6,4,7,5>, <6,4,7,5>
  1564495401U,	// <5,6,4,u>: Cost 2 vext2 <3,4,5,6>, RHS
  3711979079U,	// <5,6,5,0>: Cost 4 vext2 <3,4,5,6>, <5,0,1,1>
  2638237392U,	// <5,6,5,1>: Cost 3 vext2 <3,4,5,6>, <5,1,7,3>
  2638237464U,	// <5,6,5,2>: Cost 3 vext2 <3,4,5,6>, <5,2,6,3>
  3711979343U,	// <5,6,5,3>: Cost 4 vext2 <3,4,5,6>, <5,3,3,4>
  2650181556U,	// <5,6,5,4>: Cost 3 vext2 <5,4,5,6>, <5,4,5,6>
  2662125572U,	// <5,6,5,5>: Cost 3 vext2 <7,4,5,6>, <5,5,5,5>
  2638237732U,	// <5,6,5,6>: Cost 3 vext2 <3,4,5,6>, <5,6,0,1>
  2913390596U,	// <5,6,5,7>: Cost 3 vzipl RHS, <5,5,5,5>
  2638237950U,	// <5,6,5,u>: Cost 3 vext2 <3,4,5,6>, <5,u,6,3>
  2583806054U,	// <5,6,6,0>: Cost 3 vext1 <5,5,6,6>, LHS
  3700036007U,	// <5,6,6,1>: Cost 4 vext2 <1,4,5,6>, <6,1,7,1>
  2638238202U,	// <5,6,6,2>: Cost 3 vext2 <3,4,5,6>, <6,2,7,3>
  2583808514U,	// <5,6,6,3>: Cost 3 vext1 <5,5,6,6>, <3,4,5,6>
  2583809334U,	// <5,6,6,4>: Cost 3 vext1 <5,5,6,6>, RHS
  2583810062U,	// <5,6,6,5>: Cost 3 vext1 <5,5,6,6>, <5,5,6,6>
  2638238520U,	// <5,6,6,6>: Cost 3 vext2 <3,4,5,6>, <6,6,6,6>
  2913389058U,	// <5,6,6,7>: Cost 3 vzipl RHS, <3,4,5,6>
  2638238688U,	// <5,6,6,u>: Cost 3 vext2 <3,4,5,6>, <6,u,7,3>
  430358630U,	// <5,6,7,0>: Cost 1 vext1 RHS, LHS
  1504101110U,	// <5,6,7,1>: Cost 2 vext1 RHS, <1,0,3,2>
  1504101992U,	// <5,6,7,2>: Cost 2 vext1 RHS, <2,2,2,2>
  1504102550U,	// <5,6,7,3>: Cost 2 vext1 RHS, <3,0,1,2>
  430361910U,	// <5,6,7,4>: Cost 1 vext1 RHS, RHS
  1504104144U,	// <5,6,7,5>: Cost 2 vext1 RHS, <5,1,7,3>
  1504104954U,	// <5,6,7,6>: Cost 2 vext1 RHS, <6,2,7,3>
  1504106092U,	// <5,6,7,7>: Cost 2 vext1 RHS, <7,7,7,7>
  430364462U,	// <5,6,7,u>: Cost 1 vext1 RHS, LHS
  430366822U,	// <5,6,u,0>: Cost 1 vext1 RHS, LHS
  1564497710U,	// <5,6,u,1>: Cost 2 vext2 <3,4,5,6>, LHS
  1504110184U,	// <5,6,u,2>: Cost 2 vext1 RHS, <2,2,2,2>
  1504110742U,	// <5,6,u,3>: Cost 2 vext1 RHS, <3,0,1,2>
  430370103U,	// <5,6,u,4>: Cost 1 vext1 RHS, RHS
  1564498074U,	// <5,6,u,5>: Cost 2 vext2 <3,4,5,6>, RHS
  1504113146U,	// <5,6,u,6>: Cost 2 vext1 RHS, <6,2,7,3>
  1504113658U,	// <5,6,u,7>: Cost 2 vext1 RHS, <7,0,1,2>
  430372654U,	// <5,6,u,u>: Cost 1 vext1 RHS, LHS
  3893661392U,	// <5,7,0,0>: Cost 4 vuzpr <0,2,0,2>, <5,1,7,3>
  2645540966U,	// <5,7,0,1>: Cost 3 vext2 <4,6,5,7>, LHS
  2819452624U,	// <5,7,0,2>: Cost 3 vuzpr LHS, <5,1,7,3>
  3645631071U,	// <5,7,0,3>: Cost 4 vext1 <3,5,7,0>, <3,5,7,0>
  2726499352U,	// <5,7,0,4>: Cost 3 vext3 <7,0,4,5>, <7,0,4,5>
  3645632208U,	// <5,7,0,5>: Cost 4 vext1 <3,5,7,0>, <5,1,7,3>
  3663549162U,	// <5,7,0,6>: Cost 4 vext1 <6,5,7,0>, <6,5,7,0>
  3657577466U,	// <5,7,0,7>: Cost 4 vext1 <5,5,7,0>, <7,0,1,2>
  2819854032U,	// <5,7,0,u>: Cost 3 vuzpr LHS, <5,1,7,3>
  2589810790U,	// <5,7,1,0>: Cost 3 vext1 <6,5,7,1>, LHS
  3899035344U,	// <5,7,1,1>: Cost 4 vuzpr <1,1,1,1>, <5,1,7,3>
  3719283606U,	// <5,7,1,2>: Cost 4 vext2 <4,6,5,7>, <1,2,3,0>
  3898527440U,	// <5,7,1,3>: Cost 4 vuzpr <1,0,3,2>, <5,1,7,3>
  2589813650U,	// <5,7,1,4>: Cost 3 vext1 <6,5,7,1>, <4,0,5,1>
  3719283856U,	// <5,7,1,5>: Cost 4 vext2 <4,6,5,7>, <1,5,3,7>
  2589815531U,	// <5,7,1,6>: Cost 3 vext1 <6,5,7,1>, <6,5,7,1>
  3993176978U,	// <5,7,1,7>: Cost 4 vzipl <5,5,7,7>, <4,0,5,1>
  2589816622U,	// <5,7,1,u>: Cost 3 vext1 <6,5,7,1>, LHS
  3906260688U,	// <5,7,2,0>: Cost 4 vuzpr <2,3,0,1>, <5,1,7,3>
  3904351952U,	// <5,7,2,1>: Cost 5 vuzpr <2,0,1,2>, <5,1,7,3>
  3905752784U,	// <5,7,2,2>: Cost 4 vuzpr <2,2,2,2>, <5,1,7,3>
  2645542606U,	// <5,7,2,3>: Cost 3 vext2 <4,6,5,7>, <2,3,4,5>
  3906588368U,	// <5,7,2,4>: Cost 4 vuzpr <2,3,4,5>, <5,1,7,3>
  3906629328U,	// <5,7,2,5>: Cost 4 vuzpr <2,3,5,1>, <5,1,7,3>
  3719284666U,	// <5,7,2,6>: Cost 4 vext2 <4,6,5,7>, <2,6,3,7>
  3725920263U,	// <5,7,2,7>: Cost 4 vext2 <5,7,5,7>, <2,7,3,3>
  2645542606U,	// <5,7,2,u>: Cost 3 vext2 <4,6,5,7>, <2,3,4,5>
  3719284886U,	// <5,7,3,0>: Cost 4 vext2 <4,6,5,7>, <3,0,1,2>
  3910323920U,	// <5,7,3,1>: Cost 4 vuzpr <3,0,1,2>, <5,1,7,3>
  3719285068U,	// <5,7,3,2>: Cost 4 vext2 <4,6,5,7>, <3,2,3,4>
  3912470224U,	// <5,7,3,3>: Cost 4 vuzpr <3,3,3,3>, <5,1,7,3>
  2728490251U,	// <5,7,3,4>: Cost 3 vext3 <7,3,4,5>, <7,3,4,5>
  2638907988U,	// <5,7,3,5>: Cost 3 vext2 <3,5,5,7>, <3,5,5,7>
  3796776218U,	// <5,7,3,6>: Cost 4 vext3 <6,4,2,5>, <7,3,6,2>
  3802453286U,	// <5,7,3,7>: Cost 4 vext3 <7,3,7,5>, <7,3,7,5>
  2728785199U,	// <5,7,3,u>: Cost 3 vext3 <7,3,u,5>, <7,3,u,5>
  2728858936U,	// <5,7,4,0>: Cost 3 vext3 <7,4,0,5>, <7,4,0,5>
  3802674497U,	// <5,7,4,1>: Cost 4 vext3 <7,4,1,5>, <7,4,1,5>
  3719285814U,	// <5,7,4,2>: Cost 4 vext2 <4,6,5,7>, <4,2,5,3>
  3802821971U,	// <5,7,4,3>: Cost 4 vext3 <7,4,3,5>, <7,4,3,5>
  2652843226U,	// <5,7,4,4>: Cost 3 vext2 <5,u,5,7>, <4,4,5,5>
  2645544246U,	// <5,7,4,5>: Cost 3 vext2 <4,6,5,7>, RHS
  2846281424U,	// <5,7,4,6>: Cost 3 vuzpr RHS, <5,1,7,3>
  2729375095U,	// <5,7,4,7>: Cost 3 vext3 <7,4,7,5>, <7,4,7,5>
  2846428880U,	// <5,7,4,u>: Cost 3 vuzpr RHS, <5,1,7,3>
  2589843558U,	// <5,7,5,0>: Cost 3 vext1 <6,5,7,5>, LHS
  2652180176U,	// <5,7,5,1>: Cost 3 vext2 <5,7,5,7>, <5,1,7,3>
  3719286526U,	// <5,7,5,2>: Cost 4 vext2 <4,6,5,7>, <5,2,3,4>
  3719286644U,	// <5,7,5,3>: Cost 4 vext2 <4,6,5,7>, <5,3,7,5>
  2589846838U,	// <5,7,5,4>: Cost 3 vext1 <6,5,7,5>, RHS
  2717947318U,	// <5,7,5,5>: Cost 3 vext3 <5,5,5,5>, <7,5,5,5>
  2651517015U,	// <5,7,5,6>: Cost 3 vext2 <5,6,5,7>, <5,6,5,7>
  2849640144U,	// <5,7,5,7>: Cost 3 vuzpr <5,1,7,3>, <5,1,7,3>
  2652844281U,	// <5,7,5,u>: Cost 3 vext2 <5,u,5,7>, <5,u,5,7>
  2589851750U,	// <5,7,6,0>: Cost 3 vext1 <6,5,7,6>, LHS
  3663594230U,	// <5,7,6,1>: Cost 4 vext1 <6,5,7,6>, <1,0,3,2>
  3719287290U,	// <5,7,6,2>: Cost 4 vext2 <4,6,5,7>, <6,2,7,3>
  2589854210U,	// <5,7,6,3>: Cost 3 vext1 <6,5,7,6>, <3,4,5,6>
  2589855030U,	// <5,7,6,4>: Cost 3 vext1 <6,5,7,6>, RHS
  2725467658U,	// <5,7,6,5>: Cost 3 vext3 <6,7,u,5>, <7,6,5,u>
  2589856496U,	// <5,7,6,6>: Cost 3 vext1 <6,5,7,6>, <6,5,7,6>
  2725172760U,	// <5,7,6,7>: Cost 3 vext3 <6,7,4,5>, <7,6,7,4>
  2589857582U,	// <5,7,6,u>: Cost 3 vext1 <6,5,7,6>, LHS
  1510146150U,	// <5,7,7,0>: Cost 2 vext1 <5,5,7,7>, LHS
  2583888630U,	// <5,7,7,1>: Cost 3 vext1 <5,5,7,7>, <1,0,3,2>
  2583889512U,	// <5,7,7,2>: Cost 3 vext1 <5,5,7,7>, <2,2,2,2>
  2583890070U,	// <5,7,7,3>: Cost 3 vext1 <5,5,7,7>, <3,0,1,2>
  1510149430U,	// <5,7,7,4>: Cost 2 vext1 <5,5,7,7>, RHS
  1510150168U,	// <5,7,7,5>: Cost 2 vext1 <5,5,7,7>, <5,5,7,7>
  2583892474U,	// <5,7,7,6>: Cost 3 vext1 <5,5,7,7>, <6,2,7,3>
  2717947500U,	// <5,7,7,7>: Cost 3 vext3 <5,5,5,5>, <7,7,7,7>
  1510151982U,	// <5,7,7,u>: Cost 2 vext1 <5,5,7,7>, LHS
  1510154342U,	// <5,7,u,0>: Cost 2 vext1 <5,5,7,u>, LHS
  2645546798U,	// <5,7,u,1>: Cost 3 vext2 <4,6,5,7>, LHS
  2583897704U,	// <5,7,u,2>: Cost 3 vext1 <5,5,7,u>, <2,2,2,2>
  2583898262U,	// <5,7,u,3>: Cost 3 vext1 <5,5,7,u>, <3,0,1,2>
  1510157622U,	// <5,7,u,4>: Cost 2 vext1 <5,5,7,u>, RHS
  1510158361U,	// <5,7,u,5>: Cost 2 vext1 <5,5,7,u>, <5,5,7,u>
  2583900666U,	// <5,7,u,6>: Cost 3 vext1 <5,5,7,u>, <6,2,7,3>
  2583901178U,	// <5,7,u,7>: Cost 3 vext1 <5,5,7,u>, <7,0,1,2>
  1510160174U,	// <5,7,u,u>: Cost 2 vext1 <5,5,7,u>, LHS
  2638249984U,	// <5,u,0,0>: Cost 3 vext2 <3,4,5,u>, <0,0,0,0>
  1564508262U,	// <5,u,0,1>: Cost 2 vext2 <3,4,5,u>, LHS
  2819452633U,	// <5,u,0,2>: Cost 3 vuzpr LHS, <5,1,u,3>
  2698630885U,	// <5,u,0,3>: Cost 3 vext3 <2,3,4,5>, <u,0,3,2>
  2577935681U,	// <5,u,0,4>: Cost 3 vext1 <4,5,u,0>, <4,5,u,0>
  2698630902U,	// <5,u,0,5>: Cost 3 vext3 <2,3,4,5>, <u,0,5,1>
  2698630912U,	// <5,u,0,6>: Cost 3 vext3 <2,3,4,5>, <u,0,6,2>
  3772372744U,	// <5,u,0,7>: Cost 4 vext3 <2,3,4,5>, <u,0,7,1>
  1564508829U,	// <5,u,0,u>: Cost 2 vext2 <3,4,5,u>, LHS
  2638250742U,	// <5,u,1,0>: Cost 3 vext2 <3,4,5,u>, <1,0,3,2>
  2626306868U,	// <5,u,1,1>: Cost 3 vext2 <1,4,5,u>, <1,1,1,1>
  1624889134U,	// <5,u,1,2>: Cost 2 vext3 <2,3,4,5>, LHS
  2886962066U,	// <5,u,1,3>: Cost 3 vzipl LHS, <4,0,5,1>
  2626307154U,	// <5,u,1,4>: Cost 3 vext2 <1,4,5,u>, <1,4,5,u>
  2701948745U,	// <5,u,1,5>: Cost 3 vext3 <2,u,4,5>, <u,1,5,3>
  2589889268U,	// <5,u,1,6>: Cost 3 vext1 <6,5,u,1>, <6,5,u,1>
  2698631003U,	// <5,u,1,7>: Cost 3 vext3 <2,3,4,5>, <u,1,7,3>
  1624889188U,	// <5,u,1,u>: Cost 2 vext3 <2,3,4,5>, LHS
  2698631020U,	// <5,u,2,0>: Cost 3 vext3 <2,3,4,5>, <u,2,0,2>
  3700049439U,	// <5,u,2,1>: Cost 4 vext2 <1,4,5,u>, <2,1,3,1>
  2638251624U,	// <5,u,2,2>: Cost 3 vext2 <3,4,5,u>, <2,2,2,2>
  2698631045U,	// <5,u,2,3>: Cost 3 vext3 <2,3,4,5>, <u,2,3,0>
  2632279851U,	// <5,u,2,4>: Cost 3 vext2 <2,4,5,u>, <2,4,5,u>
  2698925978U,	// <5,u,2,5>: Cost 3 vext3 <2,3,u,5>, <u,2,5,3>
  2662139834U,	// <5,u,2,6>: Cost 3 vext2 <7,4,5,u>, <2,6,3,7>
  2698631084U,	// <5,u,2,7>: Cost 3 vext3 <2,3,4,5>, <u,2,7,3>
  2698631090U,	// <5,u,2,u>: Cost 3 vext3 <2,3,4,5>, <u,2,u,0>
  2698631100U,	// <5,u,3,0>: Cost 3 vext3 <2,3,4,5>, <u,3,0,1>
  2636261649U,	// <5,u,3,1>: Cost 3 vext2 <3,1,5,u>, <3,1,5,u>
  2636925282U,	// <5,u,3,2>: Cost 3 vext2 <3,2,5,u>, <3,2,5,u>
  2638252444U,	// <5,u,3,3>: Cost 3 vext2 <3,4,5,u>, <3,3,3,3>
  1564510724U,	// <5,u,3,4>: Cost 2 vext2 <3,4,5,u>, <3,4,5,u>
  2734536685U,	// <5,u,3,5>: Cost 3 vext3 <u,3,5,5>, <u,3,5,5>
  2734610422U,	// <5,u,3,6>: Cost 3 vext3 <u,3,6,5>, <u,3,6,5>
  2734684159U,	// <5,u,3,7>: Cost 3 vext3 <u,3,7,5>, <u,3,7,5>
  1567165256U,	// <5,u,3,u>: Cost 2 vext2 <3,u,5,u>, <3,u,5,u>
  1567828889U,	// <5,u,4,0>: Cost 2 vext2 <4,0,5,u>, <4,0,5,u>
  1661163546U,	// <5,u,4,1>: Cost 2 vext3 <u,4,1,5>, <u,4,1,5>
  2642897979U,	// <5,u,4,2>: Cost 3 vext2 <4,2,5,u>, <4,2,5,u>
  2638253220U,	// <5,u,4,3>: Cost 3 vext2 <3,4,5,u>, <4,3,u,5>
  1570458842U,	// <5,u,4,4>: Cost 2 vext2 <4,4,5,5>, <4,4,5,5>
  1564511542U,	// <5,u,4,5>: Cost 2 vext2 <3,4,5,u>, RHS
  2638253388U,	// <5,u,4,6>: Cost 3 vext2 <3,4,5,u>, <4,6,0,2>
  2717947985U,	// <5,u,4,7>: Cost 3 vext3 <5,5,5,5>, <u,4,7,6>
  1564511785U,	// <5,u,4,u>: Cost 2 vext2 <3,4,5,u>, RHS
  1509982310U,	// <5,u,5,0>: Cost 2 vext1 <5,5,5,5>, LHS
  2638253776U,	// <5,u,5,1>: Cost 3 vext2 <3,4,5,u>, <5,1,7,3>
  2698926194U,	// <5,u,5,2>: Cost 3 vext3 <2,3,u,5>, <u,5,2,3>
  2717948031U,	// <5,u,5,3>: Cost 3 vext3 <5,5,5,5>, <u,5,3,7>
  1509985590U,	// <5,u,5,4>: Cost 2 vext1 <5,5,5,5>, RHS
  229035318U,	// <5,u,5,5>: Cost 1 vdup1 RHS
  1624889498U,	// <5,u,5,6>: Cost 2 vext3 <2,3,4,5>, RHS
  2913537242U,	// <5,u,5,7>: Cost 3 vzipl RHS, <4,4,5,5>
  229035318U,	// <5,u,5,u>: Cost 1 vdup1 RHS
  2698631344U,	// <5,u,6,0>: Cost 3 vext3 <2,3,4,5>, <u,6,0,2>
  3001405538U,	// <5,u,6,1>: Cost 3 vzipr LHS, <5,6,7,0>
  2638254586U,	// <5,u,6,2>: Cost 3 vext2 <3,4,5,u>, <6,2,7,3>
  2886961666U,	// <5,u,6,3>: Cost 3 vzipl LHS, <3,4,5,6>
  2717948120U,	// <5,u,6,4>: Cost 3 vext3 <5,5,5,5>, <u,6,4,6>
  2726131939U,	// <5,u,6,5>: Cost 3 vext3 <6,u,u,5>, <u,6,5,u>
  2662142776U,	// <5,u,6,6>: Cost 3 vext2 <7,4,5,u>, <6,6,6,6>
  2913536514U,	// <5,u,6,7>: Cost 3 vzipl RHS, <3,4,5,6>
  2887002626U,	// <5,u,6,u>: Cost 3 vzipl LHS, <3,4,5,6>
  430506086U,	// <5,u,7,0>: Cost 1 vext1 RHS, LHS
  1504248566U,	// <5,u,7,1>: Cost 2 vext1 RHS, <1,0,3,2>
  1504249448U,	// <5,u,7,2>: Cost 2 vext1 RHS, <2,2,2,2>
  1951640886U,	// <5,u,7,3>: Cost 2 vtrnl LHS, RHS
  430509384U,	// <5,u,7,4>: Cost 1 vext1 RHS, RHS
  1504251600U,	// <5,u,7,5>: Cost 2 vext1 RHS, <5,1,7,3>
  118708378U,	// <5,u,7,6>: Cost 1 vrev RHS
  1504252922U,	// <5,u,7,7>: Cost 2 vext1 RHS, <7,0,1,2>
  430511918U,	// <5,u,7,u>: Cost 1 vext1 RHS, LHS
  430514278U,	// <5,u,u,0>: Cost 1 vext1 RHS, LHS
  1564514094U,	// <5,u,u,1>: Cost 2 vext2 <3,4,5,u>, LHS
  1624889701U,	// <5,u,u,2>: Cost 2 vext3 <2,3,4,5>, LHS
  1951640887U,	// <5,u,u,3>: Cost 2 vtrnl LHS, RHS
  430517577U,	// <5,u,u,4>: Cost 1 vext1 RHS, RHS
  229035318U,	// <5,u,u,5>: Cost 1 vdup1 RHS
  118716571U,	// <5,u,u,6>: Cost 1 vrev RHS
  1504261114U,	// <5,u,u,7>: Cost 2 vext1 RHS, <7,0,1,2>
  430520110U,	// <5,u,u,u>: Cost 1 vext1 RHS, LHS
  2705342464U,	// <6,0,0,0>: Cost 3 vext3 <3,4,5,6>, <0,0,0,0>
  2705342474U,	// <6,0,0,1>: Cost 3 vext3 <3,4,5,6>, <0,0,1,1>
  2705342484U,	// <6,0,0,2>: Cost 3 vext3 <3,4,5,6>, <0,0,2,2>
  3651750038U,	// <6,0,0,3>: Cost 4 vext1 <4,6,0,0>, <3,0,1,2>
  2578009398U,	// <6,0,0,4>: Cost 3 vext1 <4,6,0,0>, RHS
  3651751632U,	// <6,0,0,5>: Cost 4 vext1 <4,6,0,0>, <5,1,7,3>
  3715318246U,	// <6,0,0,6>: Cost 4 vext2 <4,0,6,0>, <0,6,0,0>
  3651752954U,	// <6,0,0,7>: Cost 4 vext1 <4,6,0,0>, <7,0,1,2>
  2705342537U,	// <6,0,0,u>: Cost 3 vext3 <3,4,5,6>, <0,0,u,1>
  2583986278U,	// <6,0,1,0>: Cost 3 vext1 <5,6,0,1>, LHS
  4027412860U,	// <6,0,1,1>: Cost 4 vzipr LHS, <6,1,2,3>
  1631600742U,	// <6,0,1,2>: Cost 2 vext3 <3,4,5,6>, LHS
  2583988738U,	// <6,0,1,3>: Cost 3 vext1 <5,6,0,1>, <3,4,5,6>
  2583989558U,	// <6,0,1,4>: Cost 3 vext1 <5,6,0,1>, RHS
  2583990308U,	// <6,0,1,5>: Cost 3 vext1 <5,6,0,1>, <5,6,0,1>
  2589963005U,	// <6,0,1,6>: Cost 3 vext1 <6,6,0,1>, <6,6,0,1>
  2595935702U,	// <6,0,1,7>: Cost 3 vext1 <7,6,0,1>, <7,6,0,1>
  1631600796U,	// <6,0,1,u>: Cost 2 vext3 <3,4,5,6>, LHS
  1504280678U,	// <6,0,2,0>: Cost 2 vext1 <4,6,0,2>, LHS
  2953630202U,	// <6,0,2,1>: Cost 3 vzipr LHS, <6,2,7,3>
  2578024040U,	// <6,0,2,2>: Cost 3 vext1 <4,6,0,2>, <2,2,2,2>
  2642904742U,	// <6,0,2,3>: Cost 3 vext2 <4,2,6,0>, <2,3,0,1>
  1504283958U,	// <6,0,2,4>: Cost 2 vext1 <4,6,0,2>, RHS
  2578026192U,	// <6,0,2,5>: Cost 3 vext1 <4,6,0,2>, <5,1,7,3>
  2578026792U,	// <6,0,2,6>: Cost 3 vext1 <4,6,0,2>, <6,0,2,0>
  2578027514U,	// <6,0,2,7>: Cost 3 vext1 <4,6,0,2>, <7,0,1,2>
  1504286510U,	// <6,0,2,u>: Cost 2 vext1 <4,6,0,2>, LHS
  3712002198U,	// <6,0,3,0>: Cost 4 vext2 <3,4,6,0>, <3,0,1,2>
  4027372082U,	// <6,0,3,1>: Cost 4 vzipr LHS, <6,3,4,5>
  4099853654U,	// <6,0,3,2>: Cost 4 vtrnl <1,0,3,2>, <4,6,1,3>
  3712002460U,	// <6,0,3,3>: Cost 4 vext2 <3,4,6,0>, <3,3,3,3>
  2638260741U,	// <6,0,3,4>: Cost 3 vext2 <3,4,6,0>, <3,4,6,0>
  3718638114U,	// <6,0,3,5>: Cost 4 vext2 <4,5,6,0>, <3,5,0,2>
  3669693288U,	// <6,0,3,6>: Cost 4 vext1 <7,6,0,3>, <6,7,3,0>
  3669693912U,	// <6,0,3,7>: Cost 4 vext1 <7,6,0,3>, <7,6,0,3>
  2640915273U,	// <6,0,3,u>: Cost 3 vext2 <3,u,6,0>, <3,u,6,0>
  2641578906U,	// <6,0,4,0>: Cost 3 vext2 <4,0,6,0>, <4,0,6,0>
  2712568146U,	// <6,0,4,1>: Cost 3 vext3 <4,6,4,6>, <0,4,1,5>
  1613463900U,	// <6,0,4,2>: Cost 2 vext3 <0,4,2,6>, <0,4,2,6>
  3712003165U,	// <6,0,4,3>: Cost 4 vext2 <3,4,6,0>, <4,3,0,6>
  2645560548U,	// <6,0,4,4>: Cost 3 vext2 <4,6,6,0>, <4,4,6,6>
  2638261558U,	// <6,0,4,5>: Cost 3 vext2 <3,4,6,0>, RHS
  2638261580U,	// <6,0,4,6>: Cost 3 vext2 <3,4,6,0>, <4,6,0,2>
  2646224337U,	// <6,0,4,7>: Cost 3 vext2 <4,7,6,0>, <4,7,6,0>
  1613463900U,	// <6,0,4,u>: Cost 2 vext3 <0,4,2,6>, <0,4,2,6>
  3786310044U,	// <6,0,5,0>: Cost 4 vext3 <4,6,4,6>, <0,5,0,7>
  3712003792U,	// <6,0,5,1>: Cost 4 vext2 <3,4,6,0>, <5,1,7,3>
  3779084711U,	// <6,0,5,2>: Cost 4 vext3 <3,4,5,6>, <0,5,2,0>
  3716648816U,	// <6,0,5,3>: Cost 4 vext2 <4,2,6,0>, <5,3,7,1>
  2646224838U,	// <6,0,5,4>: Cost 3 vext2 <4,7,6,0>, <5,4,7,6>
  3718639630U,	// <6,0,5,5>: Cost 4 vext2 <4,5,6,0>, <5,5,6,6>
  3718639652U,	// <6,0,5,6>: Cost 4 vext2 <4,5,6,0>, <5,6,0,1>
  3923383118U,	// <6,0,5,7>: Cost 4 vuzpr <5,1,7,3>, <6,7,0,1>
  2646224838U,	// <6,0,5,u>: Cost 3 vext2 <4,7,6,0>, <5,4,7,6>
  2859062094U,	// <6,0,6,0>: Cost 3 vuzpr <6,7,0,1>, <6,7,0,1>
  2953630520U,	// <6,0,6,1>: Cost 3 vzipr LHS, <6,6,6,6>
  3087848248U,	// <6,0,6,2>: Cost 3 vtrnr LHS, <6,6,6,6>
  3778716165U,	// <6,0,6,3>: Cost 4 vext3 <3,4,0,6>, <0,6,3,4>
  2656178832U,	// <6,0,6,4>: Cost 3 vext2 <6,4,6,0>, <6,4,6,0>
  3718640368U,	// <6,0,6,5>: Cost 4 vext2 <4,5,6,0>, <6,5,7,6>
  2657506098U,	// <6,0,6,6>: Cost 3 vext2 <6,6,6,0>, <6,6,6,0>
  2669450062U,	// <6,0,6,7>: Cost 3 vext2 <u,6,6,0>, <6,7,0,1>
  2859062094U,	// <6,0,6,u>: Cost 3 vuzpr <6,7,0,1>, <6,7,0,1>
  2885684534U,	// <6,0,7,0>: Cost 3 vzipl <0,0,0,0>, RHS
  2899627318U,	// <6,0,7,1>: Cost 3 vzipl <2,3,0,1>, RHS
  3087847930U,	// <6,0,7,2>: Cost 3 vtrnr LHS, <6,2,7,3>
  3960778038U,	// <6,0,7,3>: Cost 4 vzipl <0,2,0,3>, RHS
  2662151529U,	// <6,0,7,4>: Cost 3 vext2 <7,4,6,0>, <7,4,6,0>
  3980037430U,	// <6,0,7,5>: Cost 4 vzipl <3,4,0,5>, RHS
  3980045622U,	// <6,0,7,6>: Cost 4 vzipl <3,4,0,6>, RHS
  3719304812U,	// <6,0,7,7>: Cost 4 vext2 <4,6,6,0>, <7,7,7,7>
  3088290298U,	// <6,0,7,u>: Cost 3 vtrnr LHS, <6,2,7,3>
  1504329830U,	// <6,0,u,0>: Cost 2 vext1 <4,6,0,u>, LHS
  2954073056U,	// <6,0,u,1>: Cost 3 vzipr LHS, <6,u,7,3>
  1631601309U,	// <6,0,u,2>: Cost 2 vext3 <3,4,5,6>, LHS
  2578073750U,	// <6,0,u,3>: Cost 3 vext1 <4,6,0,u>, <3,0,1,2>
  1504333110U,	// <6,0,u,4>: Cost 2 vext1 <4,6,0,u>, RHS
  2638264474U,	// <6,0,u,5>: Cost 3 vext2 <3,4,6,0>, RHS
  2640918704U,	// <6,0,u,6>: Cost 3 vext2 <3,u,6,0>, <u,6,0,2>
  2578076666U,	// <6,0,u,7>: Cost 3 vext1 <4,6,0,u>, <7,0,1,2>
  1631601363U,	// <6,0,u,u>: Cost 2 vext3 <3,4,5,6>, LHS
  2595995750U,	// <6,1,0,0>: Cost 3 vext1 <7,6,1,0>, LHS
  2641584230U,	// <6,1,0,1>: Cost 3 vext2 <4,0,6,1>, LHS
  3779085036U,	// <6,1,0,2>: Cost 4 vext3 <3,4,5,6>, <1,0,2,1>
  2705343222U,	// <6,1,0,3>: Cost 3 vext3 <3,4,5,6>, <1,0,3,2>
  2595999030U,	// <6,1,0,4>: Cost 3 vext1 <7,6,1,0>, RHS
  3657797676U,	// <6,1,0,5>: Cost 4 vext1 <5,6,1,0>, <5,6,1,0>
  2596000590U,	// <6,1,0,6>: Cost 3 vext1 <7,6,1,0>, <6,7,0,1>
  2596001246U,	// <6,1,0,7>: Cost 3 vext1 <7,6,1,0>, <7,6,1,0>
  2705343267U,	// <6,1,0,u>: Cost 3 vext3 <3,4,5,6>, <1,0,u,2>
  2578088038U,	// <6,1,1,0>: Cost 3 vext1 <4,6,1,1>, LHS
  2693399348U,	// <6,1,1,1>: Cost 3 vext3 <1,4,5,6>, <1,1,1,1>
  3715326870U,	// <6,1,1,2>: Cost 4 vext2 <4,0,6,1>, <1,2,3,0>
  2705343304U,	// <6,1,1,3>: Cost 3 vext3 <3,4,5,6>, <1,1,3,3>
  2578091318U,	// <6,1,1,4>: Cost 3 vext1 <4,6,1,1>, RHS
  3651833550U,	// <6,1,1,5>: Cost 4 vext1 <4,6,1,1>, <5,1,7,1>
  3715990728U,	// <6,1,1,6>: Cost 4 vext2 <4,1,6,1>, <1,6,1,0>
  3651834874U,	// <6,1,1,7>: Cost 4 vext1 <4,6,1,1>, <7,0,1,2>
  2705343349U,	// <6,1,1,u>: Cost 3 vext3 <3,4,5,6>, <1,1,u,3>
  2554208358U,	// <6,1,2,0>: Cost 3 vext1 <0,6,1,2>, LHS
  3966143388U,	// <6,1,2,1>: Cost 4 vzipl <1,1,1,1>, <4,0,6,2>
  4034056698U,	// <6,1,2,2>: Cost 4 vzipr <1,2,3,0>, <6,2,7,3>
  3020737868U,	// <6,1,2,3>: Cost 3 vtrnl LHS, <4,6,0,2>
  2554211638U,	// <6,1,2,4>: Cost 3 vext1 <0,6,1,2>, RHS
  3657814062U,	// <6,1,2,5>: Cost 4 vext1 <5,6,1,2>, <5,6,1,2>
  2554212858U,	// <6,1,2,6>: Cost 3 vext1 <0,6,1,2>, <6,2,7,3>
  3800908730U,	// <6,1,2,7>: Cost 4 vext3 <7,1,4,6>, <1,2,7,0>
  3020778828U,	// <6,1,2,u>: Cost 3 vtrnl LHS, <4,6,0,2>
  2643576982U,	// <6,1,3,0>: Cost 3 vext2 <4,3,6,1>, <3,0,1,2>
  2578105078U,	// <6,1,3,1>: Cost 3 vext1 <4,6,1,3>, <1,0,3,2>
  4034056776U,	// <6,1,3,2>: Cost 4 vzipr <1,2,3,0>, <6,3,7,0>
  3766330349U,	// <6,1,3,3>: Cost 4 vext3 <1,3,3,6>, <1,3,3,6>
  2578107702U,	// <6,1,3,4>: Cost 3 vext1 <4,6,1,3>, RHS
  3913306401U,	// <6,1,3,5>: Cost 4 vuzpr <3,4,5,6>, <6,0,1,2>
  3709356682U,	// <6,1,3,6>: Cost 4 vext2 <3,0,6,1>, <3,6,2,7>
  3651851258U,	// <6,1,3,7>: Cost 4 vext1 <4,6,1,3>, <7,0,1,2>
  2578110254U,	// <6,1,3,u>: Cost 3 vext1 <4,6,1,3>, LHS
  2641587099U,	// <6,1,4,0>: Cost 3 vext2 <4,0,6,1>, <4,0,6,1>
  2642250732U,	// <6,1,4,1>: Cost 3 vext2 <4,1,6,1>, <4,1,6,1>
  3716656189U,	// <6,1,4,2>: Cost 4 vext2 <4,2,6,1>, <4,2,6,1>
  2643577998U,	// <6,1,4,3>: Cost 3 vext2 <4,3,6,1>, <4,3,6,1>
  3651857718U,	// <6,1,4,4>: Cost 4 vext1 <4,6,1,4>, RHS
  2693399632U,	// <6,1,4,5>: Cost 3 vext3 <1,4,5,6>, <1,4,5,6>
  2641587532U,	// <6,1,4,6>: Cost 3 vext2 <4,0,6,1>, <4,6,0,2>
  3298837762U,	// <6,1,4,7>: Cost 4 vrev <1,6,7,4>
  2693620843U,	// <6,1,4,u>: Cost 3 vext3 <1,4,u,6>, <1,4,u,6>
  2647559796U,	// <6,1,5,0>: Cost 3 vext2 <5,0,6,1>, <5,0,6,1>
  3767141496U,	// <6,1,5,1>: Cost 4 vext3 <1,4,5,6>, <1,5,1,1>
  3767583878U,	// <6,1,5,2>: Cost 4 vext3 <1,5,2,6>, <1,5,2,6>
  2712568976U,	// <6,1,5,3>: Cost 3 vext3 <4,6,4,6>, <1,5,3,7>
  3651865910U,	// <6,1,5,4>: Cost 4 vext1 <4,6,1,5>, RHS
  3724619785U,	// <6,1,5,5>: Cost 4 vext2 <5,5,6,1>, <5,5,6,1>
  2647560290U,	// <6,1,5,6>: Cost 3 vext2 <5,0,6,1>, <5,6,7,0>
  3669784035U,	// <6,1,5,7>: Cost 4 vext1 <7,6,1,5>, <7,6,1,5>
  2712569021U,	// <6,1,5,u>: Cost 3 vext3 <4,6,4,6>, <1,5,u,7>
  2602016870U,	// <6,1,6,0>: Cost 3 vext1 <u,6,1,6>, LHS
  3705377148U,	// <6,1,6,1>: Cost 4 vext2 <2,3,6,1>, <6,1,2,3>
  3709358586U,	// <6,1,6,2>: Cost 4 vext2 <3,0,6,1>, <6,2,7,3>
  3068513652U,	// <6,1,6,3>: Cost 3 vtrnl LHS, <4,6,4,6>
  2602020150U,	// <6,1,6,4>: Cost 3 vext1 <u,6,1,6>, RHS
  3786310900U,	// <6,1,6,5>: Cost 4 vext3 <4,6,4,6>, <1,6,5,u>
  2602021688U,	// <6,1,6,6>: Cost 3 vext1 <u,6,1,6>, <6,6,6,6>
  3731919748U,	// <6,1,6,7>: Cost 4 vext2 <6,7,6,1>, <6,7,6,1>
  3068554612U,	// <6,1,6,u>: Cost 3 vtrnl LHS, <4,6,4,6>
  2584109158U,	// <6,1,7,0>: Cost 3 vext1 <5,6,1,7>, LHS
  2892401974U,	// <6,1,7,1>: Cost 3 vzipl <1,1,1,1>, RHS
  2903690550U,	// <6,1,7,2>: Cost 3 vzipl <3,0,1,2>, RHS
  3068512186U,	// <6,1,7,3>: Cost 3 vtrnl LHS, <2,6,3,7>
  2584112018U,	// <6,1,7,4>: Cost 3 vext1 <5,6,1,7>, <4,0,5,1>
  2584113203U,	// <6,1,7,5>: Cost 3 vext1 <5,6,1,7>, <5,6,1,7>
  3633967527U,	// <6,1,7,6>: Cost 4 vext1 <1,6,1,7>, <6,1,7,1>
  3980791094U,	// <6,1,7,7>: Cost 4 vzipl <3,5,1,7>, RHS
  2903739702U,	// <6,1,7,u>: Cost 3 vzipl <3,0,1,u>, RHS
  2578145382U,	// <6,1,u,0>: Cost 3 vext1 <4,6,1,u>, LHS
  2892401975U,	// <6,1,u,1>: Cost 3 vzipl <1,1,1,1>, RHS
  2903690551U,	// <6,1,u,2>: Cost 3 vzipl <3,0,1,2>, RHS
  3021180242U,	// <6,1,u,3>: Cost 3 vtrnl LHS, <4,6,0,u>
  2578148662U,	// <6,1,u,4>: Cost 3 vext1 <4,6,1,u>, RHS
  2696054164U,	// <6,1,u,5>: Cost 3 vext3 <1,u,5,6>, <1,u,5,6>
  2596066198U,	// <6,1,u,6>: Cost 3 vext1 <7,6,1,u>, <6,7,u,1>
  2596066790U,	// <6,1,u,7>: Cost 3 vext1 <7,6,1,u>, <7,6,1,u>
  3021221202U,	// <6,1,u,u>: Cost 3 vtrnl LHS, <4,6,0,u>
  2641592320U,	// <6,2,0,0>: Cost 3 vext2 <4,0,6,2>, <0,0,0,0>
  1567850598U,	// <6,2,0,1>: Cost 2 vext2 <4,0,6,2>, LHS
  2641592484U,	// <6,2,0,2>: Cost 3 vext2 <4,0,6,2>, <0,2,0,2>
  3964905989U,	// <6,2,0,3>: Cost 4 vzipl LHS, <3,4,6,0>
  2641592668U,	// <6,2,0,4>: Cost 3 vext2 <4,0,6,2>, <0,4,2,6>
  3773113823U,	// <6,2,0,5>: Cost 4 vext3 <2,4,5,6>, <2,0,5,0>
  2641592824U,	// <6,2,0,6>: Cost 3 vext2 <4,0,6,2>, <0,6,2,0>
  3651900410U,	// <6,2,0,7>: Cost 4 vext1 <4,6,2,0>, <7,0,1,2>
  1567851165U,	// <6,2,0,u>: Cost 2 vext2 <4,0,6,2>, LHS
  2641593078U,	// <6,2,1,0>: Cost 3 vext2 <4,0,6,2>, <1,0,3,2>
  2641593140U,	// <6,2,1,1>: Cost 3 vext2 <4,0,6,2>, <1,1,1,1>
  2641593238U,	// <6,2,1,2>: Cost 3 vext2 <4,0,6,2>, <1,2,3,0>
  3964906395U,	// <6,2,1,3>: Cost 4 vzipl LHS, <4,0,6,1>
  3779085866U,	// <6,2,1,4>: Cost 4 vext3 <3,4,5,6>, <2,1,4,3>
  2665481360U,	// <6,2,1,5>: Cost 3 vext2 <u,0,6,2>, <1,5,3,7>
  2686027324U,	// <6,2,1,6>: Cost 3 vext3 <0,2,4,6>, <2,1,6,3>
  3669825000U,	// <6,2,1,7>: Cost 4 vext1 <7,6,2,1>, <7,6,2,1>
  2641593724U,	// <6,2,1,u>: Cost 3 vext2 <4,0,6,2>, <1,u,3,0>
  2578169958U,	// <6,2,2,0>: Cost 3 vext1 <4,6,2,2>, LHS
  3715335686U,	// <6,2,2,1>: Cost 4 vext2 <4,0,6,2>, <2,1,0,3>
  2705344104U,	// <6,2,2,2>: Cost 3 vext3 <3,4,5,6>, <2,2,2,2>
  2891164572U,	// <6,2,2,3>: Cost 3 vzipl LHS, <4,0,6,2>
  2578173238U,	// <6,2,2,4>: Cost 3 vext1 <4,6,2,2>, RHS
  3715336035U,	// <6,2,2,5>: Cost 4 vext2 <4,0,6,2>, <2,5,3,1>
  2590118672U,	// <6,2,2,6>: Cost 3 vext1 <6,6,2,2>, <6,6,2,2>
  3651916794U,	// <6,2,2,7>: Cost 4 vext1 <4,6,2,2>, <7,0,1,2>
  2886560668U,	// <6,2,2,u>: Cost 3 vzipl LHS, <4,0,6,2>
  2705344166U,	// <6,2,3,0>: Cost 3 vext3 <3,4,5,6>, <2,3,0,1>
  3767142063U,	// <6,2,3,1>: Cost 4 vext3 <1,4,5,6>, <2,3,1,1>
  2578179698U,	// <6,2,3,2>: Cost 3 vext1 <4,6,2,3>, <2,2,3,3>
  2705344196U,	// <6,2,3,3>: Cost 3 vext3 <3,4,5,6>, <2,3,3,4>
  2698634959U,	// <6,2,3,4>: Cost 3 vext3 <2,3,4,6>, <2,3,4,6>
  2698708696U,	// <6,2,3,5>: Cost 3 vext3 <2,3,5,6>, <2,3,5,6>
  2698782433U,	// <6,2,3,6>: Cost 3 vext3 <2,3,6,6>, <2,3,6,6>
  2729232104U,	// <6,2,3,7>: Cost 3 vext3 <7,4,5,6>, <2,3,7,4>
  2698929907U,	// <6,2,3,u>: Cost 3 vext3 <2,3,u,6>, <2,3,u,6>
  1567853468U,	// <6,2,4,0>: Cost 2 vext2 <4,0,6,2>, <4,0,6,2>
  3715337162U,	// <6,2,4,1>: Cost 4 vext2 <4,0,6,2>, <4,1,2,3>
  2642922558U,	// <6,2,4,2>: Cost 3 vext2 <4,2,6,2>, <4,2,6,2>
  2699224855U,	// <6,2,4,3>: Cost 3 vext3 <2,4,3,6>, <2,4,3,6>
  2578189622U,	// <6,2,4,4>: Cost 3 vext1 <4,6,2,4>, RHS
  1567853878U,	// <6,2,4,5>: Cost 2 vext2 <4,0,6,2>, RHS
  2641595724U,	// <6,2,4,6>: Cost 3 vext2 <4,0,6,2>, <4,6,0,2>
  3651933178U,	// <6,2,4,7>: Cost 4 vext1 <4,6,2,4>, <7,0,1,2>
  1567854121U,	// <6,2,4,u>: Cost 2 vext2 <4,0,6,2>, RHS
  3773114183U,	// <6,2,5,0>: Cost 4 vext3 <2,4,5,6>, <2,5,0,0>
  2641596112U,	// <6,2,5,1>: Cost 3 vext2 <4,0,6,2>, <5,1,7,3>
  3715337963U,	// <6,2,5,2>: Cost 4 vext2 <4,0,6,2>, <5,2,1,3>
  2699888488U,	// <6,2,5,3>: Cost 3 vext3 <2,5,3,6>, <2,5,3,6>
  2665484230U,	// <6,2,5,4>: Cost 3 vext2 <u,0,6,2>, <5,4,7,6>
  2665484292U,	// <6,2,5,5>: Cost 3 vext2 <u,0,6,2>, <5,5,5,5>
  2665484386U,	// <6,2,5,6>: Cost 3 vext2 <u,0,6,2>, <5,6,7,0>
  3715338358U,	// <6,2,5,7>: Cost 4 vext2 <4,0,6,2>, <5,7,0,2>
  2641596679U,	// <6,2,5,u>: Cost 3 vext2 <4,0,6,2>, <5,u,7,3>
  2734983065U,	// <6,2,6,0>: Cost 3 vext3 <u,4,2,6>, <2,6,0,1>
  3715338618U,	// <6,2,6,1>: Cost 4 vext2 <4,0,6,2>, <6,1,2,1>
  2631643642U,	// <6,2,6,2>: Cost 3 vext2 <2,3,6,2>, <6,2,7,3>
  2712569786U,	// <6,2,6,3>: Cost 3 vext3 <4,6,4,6>, <2,6,3,7>
  2734983105U,	// <6,2,6,4>: Cost 3 vext3 <u,4,2,6>, <2,6,4,5>
  3715338987U,	// <6,2,6,5>: Cost 4 vext2 <4,0,6,2>, <6,5,7,1>
  2665485112U,	// <6,2,6,6>: Cost 3 vext2 <u,0,6,2>, <6,6,6,6>
  2658186117U,	// <6,2,6,7>: Cost 3 vext2 <6,7,6,2>, <6,7,6,2>
  2641597363U,	// <6,2,6,u>: Cost 3 vext2 <4,0,6,2>, <6,u,2,3>
  2572238950U,	// <6,2,7,0>: Cost 3 vext1 <3,6,2,7>, LHS
  3965553974U,	// <6,2,7,1>: Cost 4 vzipl <1,0,2,1>, RHS
  2899119414U,	// <6,2,7,2>: Cost 3 vzipl <2,2,2,2>, RHS
  1812778294U,	// <6,2,7,3>: Cost 2 vzipl LHS, RHS
  2572242230U,	// <6,2,7,4>: Cost 3 vext1 <3,6,2,7>, RHS
  3645984464U,	// <6,2,7,5>: Cost 4 vext1 <3,6,2,7>, <5,1,7,3>
  2572243450U,	// <6,2,7,6>: Cost 3 vext1 <3,6,2,7>, <6,2,7,3>
  2596132334U,	// <6,2,7,7>: Cost 3 vext1 <7,6,2,7>, <7,6,2,7>
  1812819254U,	// <6,2,7,u>: Cost 2 vzipl LHS, RHS
  1591744256U,	// <6,2,u,0>: Cost 2 vext2 <u,0,6,2>, <u,0,6,2>
  1567856430U,	// <6,2,u,1>: Cost 2 vext2 <4,0,6,2>, LHS
  2899119415U,	// <6,2,u,2>: Cost 3 vzipl <2,2,2,2>, RHS
  1812778295U,	// <6,2,u,3>: Cost 2 vzipl LHS, RHS
  2701953124U,	// <6,2,u,4>: Cost 3 vext3 <2,u,4,6>, <2,u,4,6>
  1567856794U,	// <6,2,u,5>: Cost 2 vext2 <4,0,6,2>, RHS
  2572251651U,	// <6,2,u,6>: Cost 3 vext1 <3,6,2,u>, <6,2,u,3>
  2596140527U,	// <6,2,u,7>: Cost 3 vext1 <7,6,2,u>, <7,6,2,u>
  1812819255U,	// <6,2,u,u>: Cost 2 vzipl LHS, RHS
  3779086475U,	// <6,3,0,0>: Cost 4 vext3 <3,4,5,6>, <3,0,0,0>
  2705344662U,	// <6,3,0,1>: Cost 3 vext3 <3,4,5,6>, <3,0,1,2>
  2686027937U,	// <6,3,0,2>: Cost 3 vext3 <0,2,4,6>, <3,0,2,4>
  3779086503U,	// <6,3,0,3>: Cost 4 vext3 <3,4,5,6>, <3,0,3,1>
  2705344688U,	// <6,3,0,4>: Cost 3 vext3 <3,4,5,6>, <3,0,4,1>
  2705344698U,	// <6,3,0,5>: Cost 3 vext3 <3,4,5,6>, <3,0,5,2>
  4143829090U,	// <6,3,0,6>: Cost 4 vtrnl <u,3,5,6>, <5,6,7,0>
  2237008560U,	// <6,3,0,7>: Cost 3 vrev <3,6,7,0>
  2705344725U,	// <6,3,0,u>: Cost 3 vext3 <3,4,5,6>, <3,0,u,2>
  2578235494U,	// <6,3,1,0>: Cost 3 vext1 <4,6,3,1>, LHS
  3767142630U,	// <6,3,1,1>: Cost 4 vext3 <1,4,5,6>, <3,1,1,1>
  3704062921U,	// <6,3,1,2>: Cost 4 vext2 <2,1,6,3>, <1,2,u,6>
  2578237590U,	// <6,3,1,3>: Cost 3 vext1 <4,6,3,1>, <3,0,1,2>
  2578238774U,	// <6,3,1,4>: Cost 3 vext1 <4,6,3,1>, RHS
  3779086604U,	// <6,3,1,5>: Cost 4 vext3 <3,4,5,6>, <3,1,5,3>
  3716007130U,	// <6,3,1,6>: Cost 4 vext2 <4,1,6,3>, <1,6,3,0>
  3651982330U,	// <6,3,1,7>: Cost 4 vext1 <4,6,3,1>, <7,0,1,2>
  2578241326U,	// <6,3,1,u>: Cost 3 vext1 <4,6,3,1>, LHS
  2602131558U,	// <6,3,2,0>: Cost 3 vext1 <u,6,3,2>, LHS
  2560328924U,	// <6,3,2,1>: Cost 3 vext1 <1,6,3,2>, <1,6,3,2>
  2642929266U,	// <6,3,2,2>: Cost 3 vext2 <4,2,6,3>, <2,2,3,3>
  3966307228U,	// <6,3,2,3>: Cost 4 vzipl <1,1,3,3>, <4,0,6,2>
  2602134428U,	// <6,3,2,4>: Cost 3 vext1 <u,6,3,2>, <4,0,6,2>
  4107914572U,	// <6,3,2,5>: Cost 4 vtrnl <2,3,4,5>, <4,6,0,2>
  2660845498U,	// <6,3,2,6>: Cost 3 vext2 <7,2,6,3>, <2,6,3,7>
  3669906930U,	// <6,3,2,7>: Cost 4 vext1 <7,6,3,2>, <7,6,3,2>
  2602137390U,	// <6,3,2,u>: Cost 3 vext1 <u,6,3,2>, LHS
  2578251878U,	// <6,3,3,0>: Cost 3 vext1 <4,6,3,3>, LHS
  3710036245U,	// <6,3,3,1>: Cost 4 vext2 <3,1,6,3>, <3,1,6,3>
  2636958054U,	// <6,3,3,2>: Cost 3 vext2 <3,2,6,3>, <3,2,6,3>
  2705344924U,	// <6,3,3,3>: Cost 3 vext3 <3,4,5,6>, <3,3,3,3>
  2705344935U,	// <6,3,3,4>: Cost 3 vext3 <3,4,5,6>, <3,3,4,5>
  3779086763U,	// <6,3,3,5>: Cost 4 vext3 <3,4,5,6>, <3,3,5,0>
  3717335692U,	// <6,3,3,6>: Cost 4 vext2 <4,3,6,3>, <3,6,3,0>
  3651998714U,	// <6,3,3,7>: Cost 4 vext1 <4,6,3,3>, <7,0,1,2>
  2707999179U,	// <6,3,3,u>: Cost 3 vext3 <3,u,5,6>, <3,3,u,5>
  2704976341U,	// <6,3,4,0>: Cost 3 vext3 <3,4,0,6>, <3,4,0,6>
  2642267118U,	// <6,3,4,1>: Cost 3 vext2 <4,1,6,3>, <4,1,6,3>
  2642930751U,	// <6,3,4,2>: Cost 3 vext2 <4,2,6,3>, <4,2,6,3>
  2643594384U,	// <6,3,4,3>: Cost 3 vext2 <4,3,6,3>, <4,3,6,3>
  2584235318U,	// <6,3,4,4>: Cost 3 vext1 <5,6,3,4>, RHS
  1631603202U,	// <6,3,4,5>: Cost 2 vext3 <3,4,5,6>, <3,4,5,6>
  2712570377U,	// <6,3,4,6>: Cost 3 vext3 <4,6,4,6>, <3,4,6,4>
  2237041332U,	// <6,3,4,7>: Cost 3 vrev <3,6,7,4>
  1631824413U,	// <6,3,4,u>: Cost 2 vext3 <3,4,u,6>, <3,4,u,6>
  2705345058U,	// <6,3,5,0>: Cost 3 vext3 <3,4,5,6>, <3,5,0,2>
  3779086890U,	// <6,3,5,1>: Cost 4 vext3 <3,4,5,6>, <3,5,1,1>
  2648903448U,	// <6,3,5,2>: Cost 3 vext2 <5,2,6,3>, <5,2,6,3>
  2578270722U,	// <6,3,5,3>: Cost 3 vext1 <4,6,3,5>, <3,4,5,6>
  2578271542U,	// <6,3,5,4>: Cost 3 vext1 <4,6,3,5>, RHS
  4181742221U,	// <6,3,5,5>: Cost 4 vtrnr <3,4,5,6>, <6,4,5,6>
  3779824220U,	// <6,3,5,6>: Cost 4 vext3 <3,5,6,6>, <3,5,6,6>
  3652015098U,	// <6,3,5,7>: Cost 4 vext1 <4,6,3,5>, <7,0,1,2>
  2578274094U,	// <6,3,5,u>: Cost 3 vext1 <4,6,3,5>, LHS
  2602164326U,	// <6,3,6,0>: Cost 3 vext1 <u,6,3,6>, LHS
  2560361696U,	// <6,3,6,1>: Cost 3 vext1 <1,6,3,6>, <1,6,3,6>
  2566334393U,	// <6,3,6,2>: Cost 3 vext1 <2,6,3,6>, <2,6,3,6>
  3716010542U,	// <6,3,6,3>: Cost 4 vext2 <4,1,6,3>, <6,3,4,1>
  2602167606U,	// <6,3,6,4>: Cost 3 vext1 <u,6,3,6>, RHS
  4181742392U,	// <6,3,6,5>: Cost 4 vtrnr <3,4,5,6>, <6,6,6,6>
  2566337336U,	// <6,3,6,6>: Cost 3 vext1 <2,6,3,6>, <6,6,6,6>
  3786312375U,	// <6,3,6,7>: Cost 4 vext3 <4,6,4,6>, <3,6,7,7>
  2602170158U,	// <6,3,6,u>: Cost 3 vext1 <u,6,3,6>, LHS
  1528430694U,	// <6,3,7,0>: Cost 2 vext1 <u,6,3,7>, LHS
  2602173174U,	// <6,3,7,1>: Cost 3 vext1 <u,6,3,7>, <1,0,3,2>
  1492600762U,	// <6,3,7,2>: Cost 2 vext1 <2,6,3,7>, <2,6,3,7>
  2892565814U,	// <6,3,7,3>: Cost 3 vzipl <1,1,3,3>, RHS
  1528433974U,	// <6,3,7,4>: Cost 2 vext1 <u,6,3,7>, RHS
  2602176208U,	// <6,3,7,5>: Cost 3 vext1 <u,6,3,7>, <5,1,7,3>
  2602177018U,	// <6,3,7,6>: Cost 3 vext1 <u,6,3,7>, <6,2,7,3>
  2937056566U,	// <6,3,7,7>: Cost 3 vzipl <u,5,3,7>, RHS
  1528436526U,	// <6,3,7,u>: Cost 2 vext1 <u,6,3,7>, LHS
  1528430694U,	// <6,3,u,0>: Cost 2 vext1 <u,6,3,7>, LHS
  2705345310U,	// <6,3,u,1>: Cost 3 vext3 <3,4,5,6>, <3,u,1,2>
  1492608955U,	// <6,3,u,2>: Cost 2 vext1 <2,6,3,u>, <2,6,3,u>
  2892565815U,	// <6,3,u,3>: Cost 3 vzipl <1,1,3,3>, RHS
  1528433974U,	// <6,3,u,4>: Cost 2 vext1 <u,6,3,7>, RHS
  1634257734U,	// <6,3,u,5>: Cost 2 vext3 <3,u,5,6>, <3,u,5,6>
  2664831184U,	// <6,3,u,6>: Cost 3 vext2 <7,u,6,3>, <u,6,3,7>
  2937056567U,	// <6,3,u,7>: Cost 3 vzipl <u,5,3,7>, RHS
  1634478945U,	// <6,3,u,u>: Cost 2 vext3 <3,u,u,6>, <3,u,u,6>
  2578301030U,	// <6,4,0,0>: Cost 3 vext1 <4,6,4,0>, LHS
  2642935910U,	// <6,4,0,1>: Cost 3 vext2 <4,2,6,4>, LHS
  2819412854U,	// <6,4,0,2>: Cost 3 vuzpr LHS, <6,7,4,5>
  3782257541U,	// <6,4,0,3>: Cost 4 vext3 <4,0,3,6>, <4,0,3,6>
  2578304310U,	// <6,4,0,4>: Cost 3 vext1 <4,6,4,0>, RHS
  2705345426U,	// <6,4,0,5>: Cost 3 vext3 <3,4,5,6>, <4,0,5,1>
  2704976796U,	// <6,4,0,6>: Cost 3 vext3 <3,4,0,6>, <4,0,6,2>
  3652047866U,	// <6,4,0,7>: Cost 4 vext1 <4,6,4,0>, <7,0,1,2>
  2705345453U,	// <6,4,0,u>: Cost 3 vext3 <3,4,5,6>, <4,0,u,1>
  2242473291U,	// <6,4,1,0>: Cost 3 vrev <4,6,0,1>
  3716014900U,	// <6,4,1,1>: Cost 4 vext2 <4,1,6,4>, <1,1,1,1>
  3708715977U,	// <6,4,1,2>: Cost 4 vext2 <2,u,6,4>, <1,2,u,6>
  3779087312U,	// <6,4,1,3>: Cost 4 vext3 <3,4,5,6>, <4,1,3,0>
  3718669374U,	// <6,4,1,4>: Cost 4 vext2 <4,5,6,4>, <1,4,3,6>
  3767143395U,	// <6,4,1,5>: Cost 4 vext3 <1,4,5,6>, <4,1,5,1>
  2705345518U,	// <6,4,1,6>: Cost 3 vext3 <3,4,5,6>, <4,1,6,3>
  3316731274U,	// <6,4,1,7>: Cost 4 vrev <4,6,7,1>
  2243063187U,	// <6,4,1,u>: Cost 3 vrev <4,6,u,1>
  2242481484U,	// <6,4,2,0>: Cost 3 vrev <4,6,0,2>
  3779087378U,	// <6,4,2,1>: Cost 4 vext3 <3,4,5,6>, <4,2,1,3>
  3716679272U,	// <6,4,2,2>: Cost 4 vext2 <4,2,6,4>, <2,2,2,2>
  2642937550U,	// <6,4,2,3>: Cost 3 vext2 <4,2,6,4>, <2,3,4,5>
  2632320816U,	// <6,4,2,4>: Cost 3 vext2 <2,4,6,4>, <2,4,6,4>
  2980499962U,	// <6,4,2,5>: Cost 3 vzipr RHS, <6,2,7,3>
  2734984252U,	// <6,4,2,6>: Cost 3 vext3 <u,4,2,6>, <4,2,6,0>
  3669980667U,	// <6,4,2,7>: Cost 4 vext1 <7,6,4,2>, <7,6,4,2>
  2982490618U,	// <6,4,2,u>: Cost 3 vzipr RHS, <6,2,7,3>
  3716679830U,	// <6,4,3,0>: Cost 4 vext2 <4,2,6,4>, <3,0,1,2>
  3716679948U,	// <6,4,3,1>: Cost 4 vext2 <4,2,6,4>, <3,1,5,3>
  3710708071U,	// <6,4,3,2>: Cost 4 vext2 <3,2,6,4>, <3,2,6,4>
  3716680092U,	// <6,4,3,3>: Cost 4 vext2 <4,2,6,4>, <3,3,3,3>
  2644929026U,	// <6,4,3,4>: Cost 3 vext2 <4,5,6,4>, <3,4,5,6>
  3779087495U,	// <6,4,3,5>: Cost 4 vext3 <3,4,5,6>, <4,3,5,3>
  2705345682U,	// <6,4,3,6>: Cost 3 vext3 <3,4,5,6>, <4,3,6,5>
  3669988860U,	// <6,4,3,7>: Cost 4 vext1 <7,6,4,3>, <7,6,4,3>
  2668817222U,	// <6,4,3,u>: Cost 3 vext2 <u,5,6,4>, <3,u,5,6>
  2590277734U,	// <6,4,4,0>: Cost 3 vext1 <6,6,4,4>, LHS
  3716017135U,	// <6,4,4,1>: Cost 4 vext2 <4,1,6,4>, <4,1,6,4>
  2642938944U,	// <6,4,4,2>: Cost 3 vext2 <4,2,6,4>, <4,2,6,4>
  3717344401U,	// <6,4,4,3>: Cost 4 vext2 <4,3,6,4>, <4,3,6,4>
  2712571088U,	// <6,4,4,4>: Cost 3 vext3 <4,6,4,6>, <4,4,4,4>
  2642939190U,	// <6,4,4,5>: Cost 3 vext2 <4,2,6,4>, RHS
  1637649636U,	// <6,4,4,6>: Cost 2 vext3 <4,4,6,6>, <4,4,6,6>
  2646257109U,	// <6,4,4,7>: Cost 3 vext2 <4,7,6,4>, <4,7,6,4>
  1637649636U,	// <6,4,4,u>: Cost 2 vext3 <4,4,6,6>, <4,4,6,6>
  2584313958U,	// <6,4,5,0>: Cost 3 vext1 <5,6,4,5>, LHS
  3646113154U,	// <6,4,5,1>: Cost 4 vext1 <3,6,4,5>, <1,u,3,6>
  2566399937U,	// <6,4,5,2>: Cost 3 vext1 <2,6,4,5>, <2,6,4,5>
  2584316418U,	// <6,4,5,3>: Cost 3 vext1 <5,6,4,5>, <3,4,5,6>
  2584317238U,	// <6,4,5,4>: Cost 3 vext1 <5,6,4,5>, RHS
  2584318028U,	// <6,4,5,5>: Cost 3 vext1 <5,6,4,5>, <5,6,4,5>
  1631604022U,	// <6,4,5,6>: Cost 2 vext3 <3,4,5,6>, RHS
  2596263422U,	// <6,4,5,7>: Cost 3 vext1 <7,6,4,5>, <7,6,4,5>
  1631604040U,	// <6,4,5,u>: Cost 2 vext3 <3,4,5,6>, RHS
  1504608358U,	// <6,4,6,0>: Cost 2 vext1 <4,6,4,6>, LHS
  2578350838U,	// <6,4,6,1>: Cost 3 vext1 <4,6,4,6>, <1,0,3,2>
  2578351720U,	// <6,4,6,2>: Cost 3 vext1 <4,6,4,6>, <2,2,2,2>
  2578352278U,	// <6,4,6,3>: Cost 3 vext1 <4,6,4,6>, <3,0,1,2>
  1504611638U,	// <6,4,6,4>: Cost 2 vext1 <4,6,4,6>, RHS
  2980500280U,	// <6,4,6,5>: Cost 3 vzipr RHS, <6,6,6,6>
  3114718008U,	// <6,4,6,6>: Cost 3 vtrnr RHS, <6,6,6,6>
  2578355194U,	// <6,4,6,7>: Cost 3 vext1 <4,6,4,6>, <7,0,1,2>
  1504614190U,	// <6,4,6,u>: Cost 2 vext1 <4,6,4,6>, LHS
  2578358374U,	// <6,4,7,0>: Cost 3 vext1 <4,6,4,7>, LHS
  2602247111U,	// <6,4,7,1>: Cost 3 vext1 <u,6,4,7>, <1,2,u,4>
  3971681590U,	// <6,4,7,2>: Cost 4 vzipl <2,0,4,2>, RHS
  2572389020U,	// <6,4,7,3>: Cost 3 vext1 <3,6,4,7>, <3,6,4,7>
  2578361552U,	// <6,4,7,4>: Cost 3 vext1 <4,6,4,7>, <4,4,4,4>
  2899954998U,	// <6,4,7,5>: Cost 3 vzipl <2,3,4,5>, RHS
  3114717690U,	// <6,4,7,6>: Cost 3 vtrnr RHS, <6,2,7,3>
  3652105210U,	// <6,4,7,7>: Cost 4 vext1 <4,6,4,7>, <7,0,1,2>
  2899979574U,	// <6,4,7,u>: Cost 3 vzipl <2,3,4,u>, RHS
  1504624742U,	// <6,4,u,0>: Cost 2 vext1 <4,6,4,u>, LHS
  2642941742U,	// <6,4,u,1>: Cost 3 vext2 <4,2,6,4>, LHS
  2578368104U,	// <6,4,u,2>: Cost 3 vext1 <4,6,4,u>, <2,2,2,2>
  2578368662U,	// <6,4,u,3>: Cost 3 vext1 <4,6,4,u>, <3,0,1,2>
  1504628022U,	// <6,4,u,4>: Cost 2 vext1 <4,6,4,u>, RHS
  2899954999U,	// <6,4,u,5>: Cost 3 vzipl <2,3,4,5>, RHS
  1631604265U,	// <6,4,u,6>: Cost 2 vext3 <3,4,5,6>, RHS
  2578371578U,	// <6,4,u,7>: Cost 3 vext1 <4,6,4,u>, <7,0,1,2>
  1631604283U,	// <6,4,u,u>: Cost 2 vext3 <3,4,5,6>, RHS
  3717349376U,	// <6,5,0,0>: Cost 4 vext2 <4,3,6,5>, <0,0,0,0>
  2643607654U,	// <6,5,0,1>: Cost 3 vext2 <4,3,6,5>, LHS
  3779087952U,	// <6,5,0,2>: Cost 4 vext3 <3,4,5,6>, <5,0,2,1>
  3322400830U,	// <6,5,0,3>: Cost 4 vrev <5,6,3,0>
  3718013266U,	// <6,5,0,4>: Cost 4 vext2 <4,4,6,5>, <0,4,1,5>
  3718013342U,	// <6,5,0,5>: Cost 4 vext2 <4,4,6,5>, <0,5,1,0>
  3779087988U,	// <6,5,0,6>: Cost 4 vext3 <3,4,5,6>, <5,0,6,1>
  1175212130U,	// <6,5,0,7>: Cost 2 vrev <5,6,7,0>
  1175285867U,	// <6,5,0,u>: Cost 2 vrev <5,6,u,0>
  2248445988U,	// <6,5,1,0>: Cost 3 vrev <5,6,0,1>
  3716023092U,	// <6,5,1,1>: Cost 4 vext2 <4,1,6,5>, <1,1,1,1>
  3717350294U,	// <6,5,1,2>: Cost 4 vext2 <4,3,6,5>, <1,2,3,0>
  3658099202U,	// <6,5,1,3>: Cost 4 vext1 <5,6,5,1>, <3,4,5,6>
  3716023376U,	// <6,5,1,4>: Cost 4 vext2 <4,1,6,5>, <1,4,5,6>
  3652128464U,	// <6,5,1,5>: Cost 4 vext1 <4,6,5,1>, <5,1,7,3>
  3767144133U,	// <6,5,1,6>: Cost 4 vext3 <1,4,5,6>, <5,1,6,1>
  2705346256U,	// <6,5,1,7>: Cost 3 vext3 <3,4,5,6>, <5,1,7,3>
  2705346265U,	// <6,5,1,u>: Cost 3 vext3 <3,4,5,6>, <5,1,u,3>
  2578391142U,	// <6,5,2,0>: Cost 3 vext1 <4,6,5,2>, LHS
  3779088107U,	// <6,5,2,1>: Cost 4 vext3 <3,4,5,6>, <5,2,1,3>
  3717351016U,	// <6,5,2,2>: Cost 4 vext2 <4,3,6,5>, <2,2,2,2>
  3779088126U,	// <6,5,2,3>: Cost 4 vext3 <3,4,5,6>, <5,2,3,4>
  2632329009U,	// <6,5,2,4>: Cost 3 vext2 <2,4,6,5>, <2,4,6,5>
  3717351272U,	// <6,5,2,5>: Cost 4 vext2 <4,3,6,5>, <2,5,3,6>
  2705346328U,	// <6,5,2,6>: Cost 3 vext3 <3,4,5,6>, <5,2,6,3>
  3047607628U,	// <6,5,2,7>: Cost 3 vtrnl RHS, <4,6,0,2>
  3047615820U,	// <6,5,2,u>: Cost 3 vtrnl RHS, <4,6,0,2>
  3717351574U,	// <6,5,3,0>: Cost 4 vext2 <4,3,6,5>, <3,0,1,2>
  3710052631U,	// <6,5,3,1>: Cost 4 vext2 <3,1,6,5>, <3,1,6,5>
  3322351672U,	// <6,5,3,2>: Cost 4 vrev <5,6,2,3>
  3779088207U,	// <6,5,3,3>: Cost 4 vext3 <3,4,5,6>, <5,3,3,4>
  2643610114U,	// <6,5,3,4>: Cost 3 vext2 <4,3,6,5>, <3,4,5,6>
  3913306765U,	// <6,5,3,5>: Cost 4 vuzpr <3,4,5,6>, <6,4,5,6>
  3779088232U,	// <6,5,3,6>: Cost 4 vext3 <3,4,5,6>, <5,3,6,2>
  2248978533U,	// <6,5,3,7>: Cost 3 vrev <5,6,7,3>
  2249052270U,	// <6,5,3,u>: Cost 3 vrev <5,6,u,3>
  2644274066U,	// <6,5,4,0>: Cost 3 vext2 <4,4,6,5>, <4,0,5,1>
  3716025328U,	// <6,5,4,1>: Cost 4 vext2 <4,1,6,5>, <4,1,6,5>
  3716688961U,	// <6,5,4,2>: Cost 4 vext2 <4,2,6,5>, <4,2,6,5>
  2643610770U,	// <6,5,4,3>: Cost 3 vext2 <4,3,6,5>, <4,3,6,5>
  2644274403U,	// <6,5,4,4>: Cost 3 vext2 <4,4,6,5>, <4,4,6,5>
  2643610934U,	// <6,5,4,5>: Cost 3 vext2 <4,3,6,5>, RHS
  3779088316U,	// <6,5,4,6>: Cost 4 vext3 <3,4,5,6>, <5,4,6,5>
  1643696070U,	// <6,5,4,7>: Cost 2 vext3 <5,4,7,6>, <5,4,7,6>
  1643769807U,	// <6,5,4,u>: Cost 2 vext3 <5,4,u,6>, <5,4,u,6>
  3718016637U,	// <6,5,5,0>: Cost 4 vext2 <4,4,6,5>, <5,0,7,1>
  3717353168U,	// <6,5,5,1>: Cost 4 vext2 <4,3,6,5>, <5,1,7,3>
  3717353240U,	// <6,5,5,2>: Cost 4 vext2 <4,3,6,5>, <5,2,6,3>
  3723325291U,	// <6,5,5,3>: Cost 4 vext2 <5,3,6,5>, <5,3,6,5>
  2650247100U,	// <6,5,5,4>: Cost 3 vext2 <5,4,6,5>, <5,4,6,5>
  2712571908U,	// <6,5,5,5>: Cost 3 vext3 <4,6,4,6>, <5,5,5,5>
  2650247266U,	// <6,5,5,6>: Cost 3 vext2 <5,4,6,5>, <5,6,7,0>
  2712571928U,	// <6,5,5,7>: Cost 3 vext3 <4,6,4,6>, <5,5,7,7>
  2712571937U,	// <6,5,5,u>: Cost 3 vext3 <4,6,4,6>, <5,5,u,7>
  2705346596U,	// <6,5,6,0>: Cost 3 vext3 <3,4,5,6>, <5,6,0,1>
  3767144493U,	// <6,5,6,1>: Cost 4 vext3 <1,4,5,6>, <5,6,1,1>
  3773116473U,	// <6,5,6,2>: Cost 4 vext3 <2,4,5,6>, <5,6,2,4>
  2705346626U,	// <6,5,6,3>: Cost 3 vext3 <3,4,5,6>, <5,6,3,4>
  2705346636U,	// <6,5,6,4>: Cost 3 vext3 <3,4,5,6>, <5,6,4,5>
  3779088465U,	// <6,5,6,5>: Cost 4 vext3 <3,4,5,6>, <5,6,5,1>
  2656219960U,	// <6,5,6,6>: Cost 3 vext2 <6,4,6,5>, <6,6,6,6>
  3047607668U,	// <6,5,6,7>: Cost 3 vtrnl RHS, <4,6,4,6>
  2705346668U,	// <6,5,6,u>: Cost 3 vext3 <3,4,5,6>, <5,6,u,1>
  2578432102U,	// <6,5,7,0>: Cost 3 vext1 <4,6,5,7>, LHS
  2909949238U,	// <6,5,7,1>: Cost 3 vzipl <4,0,5,1>, RHS
  2578433742U,	// <6,5,7,2>: Cost 3 vext1 <4,6,5,7>, <2,3,4,5>
  3978399030U,	// <6,5,7,3>: Cost 4 vzipl <3,1,5,3>, RHS
  2578435382U,	// <6,5,7,4>: Cost 3 vext1 <4,6,5,7>, RHS
  2919271734U,	// <6,5,7,5>: Cost 3 vzipl <5,5,5,5>, RHS
  2906672438U,	// <6,5,7,6>: Cost 3 vzipl <3,4,5,6>, RHS
  3047606202U,	// <6,5,7,7>: Cost 3 vtrnl RHS, <2,6,3,7>
  2906688822U,	// <6,5,7,u>: Cost 3 vzipl <3,4,5,u>, RHS
  2248503339U,	// <6,5,u,0>: Cost 3 vrev <5,6,0,u>
  2909949239U,	// <6,5,u,1>: Cost 3 vzipl <4,0,5,1>, RHS
  2578433742U,	// <6,5,u,2>: Cost 3 vext1 <4,6,5,7>, <2,3,4,5>
  2248724550U,	// <6,5,u,3>: Cost 3 vrev <5,6,3,u>
  2248798287U,	// <6,5,u,4>: Cost 3 vrev <5,6,4,u>
  2643613850U,	// <6,5,u,5>: Cost 3 vext2 <4,3,6,5>, RHS
  2705346814U,	// <6,5,u,6>: Cost 3 vext3 <3,4,5,6>, <5,u,6,3>
  1175277674U,	// <6,5,u,7>: Cost 2 vrev <5,6,7,u>
  1175351411U,	// <6,5,u,u>: Cost 2 vrev <5,6,u,u>
  2578448486U,	// <6,6,0,0>: Cost 3 vext1 <4,6,6,0>, LHS
  1583808614U,	// <6,6,0,1>: Cost 2 vext2 <6,6,6,6>, LHS
  2657550500U,	// <6,6,0,2>: Cost 3 vext2 <6,6,6,6>, <0,2,0,2>
  3652192406U,	// <6,6,0,3>: Cost 4 vext1 <4,6,6,0>, <3,0,1,2>
  2578451684U,	// <6,6,0,4>: Cost 3 vext1 <4,6,6,0>, <4,4,6,6>
  3652194000U,	// <6,6,0,5>: Cost 4 vext1 <4,6,6,0>, <5,1,7,3>
  2602341198U,	// <6,6,0,6>: Cost 3 vext1 <u,6,6,0>, <6,7,0,1>
  3766038871U,	// <6,6,0,7>: Cost 4 vext3 <1,2,u,6>, <6,0,7,2>
  1583809181U,	// <6,6,0,u>: Cost 2 vext2 <6,6,6,6>, LHS
  2657551094U,	// <6,6,1,0>: Cost 3 vext2 <6,6,6,6>, <1,0,3,2>
  2657551156U,	// <6,6,1,1>: Cost 3 vext2 <6,6,6,6>, <1,1,1,1>
  2657551254U,	// <6,6,1,2>: Cost 3 vext2 <6,6,6,6>, <1,2,3,0>
  3731293134U,	// <6,6,1,3>: Cost 4 vext2 <6,6,6,6>, <1,3,0,2>
  3767144848U,	// <6,6,1,4>: Cost 4 vext3 <1,4,5,6>, <6,1,4,5>
  2657551504U,	// <6,6,1,5>: Cost 3 vext2 <6,6,6,6>, <1,5,3,7>
  2712572320U,	// <6,6,1,6>: Cost 3 vext3 <4,6,4,6>, <6,1,6,3>
  3767144871U,	// <6,6,1,7>: Cost 4 vext3 <1,4,5,6>, <6,1,7,1>
  2657551740U,	// <6,6,1,u>: Cost 3 vext2 <6,6,6,6>, <1,u,3,0>
  3646234726U,	// <6,6,2,0>: Cost 4 vext1 <3,6,6,2>, LHS
  3646236034U,	// <6,6,2,1>: Cost 4 vext1 <3,6,6,2>, <1,u,3,6>
  2910030748U,	// <6,6,2,2>: Cost 3 vzipl <4,0,6,2>, <4,0,6,2>
  2657552038U,	// <6,6,2,3>: Cost 3 vext2 <6,6,6,6>, <2,3,0,1>
  3646238006U,	// <6,6,2,4>: Cost 4 vext1 <3,6,6,2>, RHS
  3712714600U,	// <6,6,2,5>: Cost 4 vext2 <3,5,6,6>, <2,5,3,6>
  2657552314U,	// <6,6,2,6>: Cost 3 vext2 <6,6,6,6>, <2,6,3,7>
  2692297210U,	// <6,6,2,7>: Cost 3 vext3 <1,2,u,6>, <6,2,7,3>
  2705347075U,	// <6,6,2,u>: Cost 3 vext3 <3,4,5,6>, <6,2,u,3>
  2657552534U,	// <6,6,3,0>: Cost 3 vext2 <6,6,6,6>, <3,0,1,2>
  3731294430U,	// <6,6,3,1>: Cost 4 vext2 <6,6,6,6>, <3,1,0,2>
  3731294510U,	// <6,6,3,2>: Cost 4 vext2 <6,6,6,6>, <3,2,0,1>
  2657552796U,	// <6,6,3,3>: Cost 3 vext2 <6,6,6,6>, <3,3,3,3>
  2705347122U,	// <6,6,3,4>: Cost 3 vext3 <3,4,5,6>, <6,3,4,5>
  3779088950U,	// <6,6,3,5>: Cost 4 vext3 <3,4,5,6>, <6,3,5,0>
  2639637165U,	// <6,6,3,6>: Cost 3 vext2 <3,6,6,6>, <3,6,6,6>
  3779088968U,	// <6,6,3,7>: Cost 4 vext3 <3,4,5,6>, <6,3,7,0>
  2708001366U,	// <6,6,3,u>: Cost 3 vext3 <3,u,5,6>, <6,3,u,5>
  2578481254U,	// <6,6,4,0>: Cost 3 vext1 <4,6,6,4>, LHS
  3779089001U,	// <6,6,4,1>: Cost 4 vext3 <3,4,5,6>, <6,4,1,6>
  3716697154U,	// <6,6,4,2>: Cost 4 vext2 <4,2,6,6>, <4,2,6,6>
  3779089019U,	// <6,6,4,3>: Cost 4 vext3 <3,4,5,6>, <6,4,3,6>
  1570540772U,	// <6,6,4,4>: Cost 2 vext2 <4,4,6,6>, <4,4,6,6>
  1583811894U,	// <6,6,4,5>: Cost 2 vext2 <6,6,6,6>, RHS
  2846282552U,	// <6,6,4,6>: Cost 3 vuzpr RHS, <6,6,6,6>
  2723410591U,	// <6,6,4,7>: Cost 3 vext3 <6,4,7,6>, <6,4,7,6>
  1583812137U,	// <6,6,4,u>: Cost 2 vext2 <6,6,6,6>, RHS
  3786314418U,	// <6,6,5,0>: Cost 4 vext3 <4,6,4,6>, <6,5,0,7>
  2657554128U,	// <6,6,5,1>: Cost 3 vext2 <6,6,6,6>, <5,1,7,3>
  3779089091U,	// <6,6,5,2>: Cost 4 vext3 <3,4,5,6>, <6,5,2,6>
  3658205698U,	// <6,6,5,3>: Cost 4 vext1 <5,6,6,5>, <3,4,5,6>
  2717438678U,	// <6,6,5,4>: Cost 3 vext3 <5,4,7,6>, <6,5,4,7>
  2650918926U,	// <6,6,5,5>: Cost 3 vext2 <5,5,6,6>, <5,5,6,6>
  2712572648U,	// <6,6,5,6>: Cost 3 vext3 <4,6,4,6>, <6,5,6,7>
  2724074224U,	// <6,6,5,7>: Cost 3 vext3 <6,5,7,6>, <6,5,7,6>
  2657554692U,	// <6,6,5,u>: Cost 3 vext2 <6,6,6,6>, <5,u,7,0>
  1516699750U,	// <6,6,6,0>: Cost 2 vext1 <6,6,6,6>, LHS
  2590442230U,	// <6,6,6,1>: Cost 3 vext1 <6,6,6,6>, <1,0,3,2>
  2590443112U,	// <6,6,6,2>: Cost 3 vext1 <6,6,6,6>, <2,2,2,2>
  2590443670U,	// <6,6,6,3>: Cost 3 vext1 <6,6,6,6>, <3,0,1,2>
  1516703030U,	// <6,6,6,4>: Cost 2 vext1 <6,6,6,6>, RHS
  2590445264U,	// <6,6,6,5>: Cost 3 vext1 <6,6,6,6>, <5,1,7,3>
  296144182U,	// <6,6,6,6>: Cost 1 vdup2 RHS
  2913391416U,	// <6,6,6,7>: Cost 3 vzipl RHS, <6,6,6,6>
  296144182U,	// <6,6,6,u>: Cost 1 vdup2 RHS
  2712572750U,	// <6,6,7,0>: Cost 3 vext3 <4,6,4,6>, <6,7,0,1>
  3983764790U,	// <6,6,7,1>: Cost 4 vzipl <4,0,6,1>, RHS
  2910031158U,	// <6,6,7,2>: Cost 3 vzipl <4,0,6,2>, RHS
  2584480258U,	// <6,6,7,3>: Cost 3 vext1 <5,6,6,7>, <3,4,5,6>
  2712572790U,	// <6,6,7,4>: Cost 3 vext3 <4,6,4,6>, <6,7,4,5>
  2717438846U,	// <6,6,7,5>: Cost 3 vext3 <5,4,7,6>, <6,7,5,4>
  2657555985U,	// <6,6,7,6>: Cost 3 vext2 <6,6,6,6>, <7,6,6,6>
  1839648054U,	// <6,6,7,7>: Cost 2 vzipl RHS, RHS
  1839656246U,	// <6,6,7,u>: Cost 2 vzipl RHS, RHS
  1516699750U,	// <6,6,u,0>: Cost 2 vext1 <6,6,6,6>, LHS
  1583814446U,	// <6,6,u,1>: Cost 2 vext2 <6,6,6,6>, LHS
  2910031159U,	// <6,6,u,2>: Cost 3 vzipl <4,0,6,2>, RHS
  2657556412U,	// <6,6,u,3>: Cost 3 vext2 <6,6,6,6>, <u,3,0,1>
  1594431560U,	// <6,6,u,4>: Cost 2 vext2 <u,4,6,6>, <u,4,6,6>
  1583814810U,	// <6,6,u,5>: Cost 2 vext2 <6,6,6,6>, RHS
  296144182U,	// <6,6,u,6>: Cost 1 vdup2 RHS
  1839648055U,	// <6,6,u,7>: Cost 2 vzipl RHS, RHS
  296144182U,	// <6,6,u,u>: Cost 1 vdup2 RHS
  1571209216U,	// <6,7,0,0>: Cost 2 vext2 RHS, <0,0,0,0>
  497467494U,	// <6,7,0,1>: Cost 1 vext2 RHS, LHS
  1571209380U,	// <6,7,0,2>: Cost 2 vext2 RHS, <0,2,0,2>
  2644951301U,	// <6,7,0,3>: Cost 3 vext2 RHS, <0,3,2,0>
  1573200210U,	// <6,7,0,4>: Cost 2 vext2 RHS, <0,4,1,5>
  1510756450U,	// <6,7,0,5>: Cost 2 vext1 <5,6,7,0>, <5,6,7,0>
  2644951544U,	// <6,7,0,6>: Cost 3 vext2 RHS, <0,6,2,0>
  2584499194U,	// <6,7,0,7>: Cost 3 vext1 <5,6,7,0>, <7,0,1,2>
  497468061U,	// <6,7,0,u>: Cost 1 vext2 RHS, LHS
  1571209974U,	// <6,7,1,0>: Cost 2 vext2 RHS, <1,0,3,2>
  1571210036U,	// <6,7,1,1>: Cost 2 vext2 RHS, <1,1,1,1>
  1571210134U,	// <6,7,1,2>: Cost 2 vext2 RHS, <1,2,3,0>
  2644952014U,	// <6,7,1,3>: Cost 3 vext2 RHS, <1,3,0,2>
  2644952098U,	// <6,7,1,4>: Cost 3 vext2 RHS, <1,4,0,5>
  1573201040U,	// <6,7,1,5>: Cost 2 vext2 RHS, <1,5,3,7>
  2646942927U,	// <6,7,1,6>: Cost 3 vext2 RHS, <1,6,1,7>
  2668840235U,	// <6,7,1,7>: Cost 3 vext2 RHS, <1,7,3,0>
  1571210620U,	// <6,7,1,u>: Cost 2 vext2 RHS, <1,u,3,0>
  2644952500U,	// <6,7,2,0>: Cost 3 vext2 RHS, <2,0,0,2>
  2644952582U,	// <6,7,2,1>: Cost 3 vext2 RHS, <2,1,0,3>
  1571210856U,	// <6,7,2,2>: Cost 2 vext2 RHS, <2,2,2,2>
  1571210918U,	// <6,7,2,3>: Cost 2 vext2 RHS, <2,3,0,1>
  2644952824U,	// <6,7,2,4>: Cost 3 vext2 RHS, <2,4,0,2>
  2644952931U,	// <6,7,2,5>: Cost 3 vext2 RHS, <2,5,3,1>
  1573201850U,	// <6,7,2,6>: Cost 2 vext2 RHS, <2,6,3,7>
  2668840938U,	// <6,7,2,7>: Cost 3 vext2 RHS, <2,7,0,1>
  1571211323U,	// <6,7,2,u>: Cost 2 vext2 RHS, <2,u,0,1>
  1571211414U,	// <6,7,3,0>: Cost 2 vext2 RHS, <3,0,1,2>
  2644953310U,	// <6,7,3,1>: Cost 3 vext2 RHS, <3,1,0,2>
  2644953390U,	// <6,7,3,2>: Cost 3 vext2 RHS, <3,2,0,1>
  1571211676U,	// <6,7,3,3>: Cost 2 vext2 RHS, <3,3,3,3>
  1571211778U,	// <6,7,3,4>: Cost 2 vext2 RHS, <3,4,5,6>
  2644953634U,	// <6,7,3,5>: Cost 3 vext2 RHS, <3,5,0,2>
  2644953738U,	// <6,7,3,6>: Cost 3 vext2 RHS, <3,6,2,7>
  2668841667U,	// <6,7,3,7>: Cost 3 vext2 RHS, <3,7,0,1>
  1571212062U,	// <6,7,3,u>: Cost 2 vext2 RHS, <3,u,1,2>
  1571212178U,	// <6,7,4,0>: Cost 2 vext2 RHS, <4,0,5,1>
  2644954058U,	// <6,7,4,1>: Cost 3 vext2 RHS, <4,1,2,3>
  2644954165U,	// <6,7,4,2>: Cost 3 vext2 RHS, <4,2,5,2>
  2644954247U,	// <6,7,4,3>: Cost 3 vext2 RHS, <4,3,5,3>
  1571212496U,	// <6,7,4,4>: Cost 2 vext2 RHS, <4,4,4,4>
  497470774U,	// <6,7,4,5>: Cost 1 vext2 RHS, RHS
  1571212620U,	// <6,7,4,6>: Cost 2 vext2 RHS, <4,6,0,2>
  2584531962U,	// <6,7,4,7>: Cost 3 vext1 <5,6,7,4>, <7,0,1,2>
  497471017U,	// <6,7,4,u>: Cost 1 vext2 RHS, RHS
  2644954695U,	// <6,7,5,0>: Cost 3 vext2 RHS, <5,0,1,1>
  1571213008U,	// <6,7,5,1>: Cost 2 vext2 RHS, <5,1,7,3>
  2644954859U,	// <6,7,5,2>: Cost 3 vext2 RHS, <5,2,1,3>
  2644954992U,	// <6,7,5,3>: Cost 3 vext2 RHS, <5,3,7,1>
  1571213254U,	// <6,7,5,4>: Cost 2 vext2 RHS, <5,4,7,6>
  1571213316U,	// <6,7,5,5>: Cost 2 vext2 RHS, <5,5,5,5>
  1571213410U,	// <6,7,5,6>: Cost 2 vext2 RHS, <5,6,7,0>
  2644955254U,	// <6,7,5,7>: Cost 3 vext2 RHS, <5,7,0,2>
  1571213575U,	// <6,7,5,u>: Cost 2 vext2 RHS, <5,u,7,3>
  2644955425U,	// <6,7,6,0>: Cost 3 vext2 RHS, <6,0,1,2>
  2644955516U,	// <6,7,6,1>: Cost 3 vext2 RHS, <6,1,2,3>
  1571213818U,	// <6,7,6,2>: Cost 2 vext2 RHS, <6,2,7,3>
  2644955698U,	// <6,7,6,3>: Cost 3 vext2 RHS, <6,3,4,5>
  2644955789U,	// <6,7,6,4>: Cost 3 vext2 RHS, <6,4,5,6>
  2644955883U,	// <6,7,6,5>: Cost 3 vext2 RHS, <6,5,7,1>
  1571214136U,	// <6,7,6,6>: Cost 2 vext2 RHS, <6,6,6,6>
  1571214158U,	// <6,7,6,7>: Cost 2 vext2 RHS, <6,7,0,1>
  1571214304U,	// <6,7,6,u>: Cost 2 vext2 RHS, <6,u,7,3>
  1573204986U,	// <6,7,7,0>: Cost 2 vext2 RHS, <7,0,1,2>
  2646946883U,	// <6,7,7,1>: Cost 3 vext2 RHS, <7,1,0,3>
  2644956335U,	// <6,7,7,2>: Cost 3 vext2 RHS, <7,2,3,3>
  2646947043U,	// <6,7,7,3>: Cost 3 vext2 RHS, <7,3,0,1>
  1573205350U,	// <6,7,7,4>: Cost 2 vext2 RHS, <7,4,5,6>
  2646947220U,	// <6,7,7,5>: Cost 3 vext2 RHS, <7,5,1,7>
  1516786498U,	// <6,7,7,6>: Cost 2 vext1 <6,6,7,7>, <6,6,7,7>
  1571214956U,	// <6,7,7,7>: Cost 2 vext2 RHS, <7,7,7,7>
  1573205634U,	// <6,7,7,u>: Cost 2 vext2 RHS, <7,u,1,2>
  1571215058U,	// <6,7,u,0>: Cost 2 vext2 RHS, <u,0,1,1>
  497473326U,	// <6,7,u,1>: Cost 1 vext2 RHS, LHS
  1571215212U,	// <6,7,u,2>: Cost 2 vext2 RHS, <u,2,0,2>
  1571215292U,	// <6,7,u,3>: Cost 2 vext2 RHS, <u,3,0,1>
  1571215423U,	// <6,7,u,4>: Cost 2 vext2 RHS, <u,4,5,6>
  497473690U,	// <6,7,u,5>: Cost 1 vext2 RHS, RHS
  1571215536U,	// <6,7,u,6>: Cost 2 vext2 RHS, <u,6,0,2>
  1573206272U,	// <6,7,u,7>: Cost 2 vext2 RHS, <u,7,0,1>
  497473893U,	// <6,7,u,u>: Cost 1 vext2 RHS, LHS
  1571217408U,	// <6,u,0,0>: Cost 2 vext2 RHS, <0,0,0,0>
  497475686U,	// <6,u,0,1>: Cost 1 vext2 RHS, LHS
  1571217572U,	// <6,u,0,2>: Cost 2 vext2 RHS, <0,2,0,2>
  2705348325U,	// <6,u,0,3>: Cost 3 vext3 <3,4,5,6>, <u,0,3,2>
  1571217746U,	// <6,u,0,4>: Cost 2 vext2 RHS, <0,4,1,5>
  1510830187U,	// <6,u,0,5>: Cost 2 vext1 <5,6,u,0>, <5,6,u,0>
  2705348352U,	// <6,u,0,6>: Cost 3 vext3 <3,4,5,6>, <u,0,6,2>
  1193130221U,	// <6,u,0,7>: Cost 2 vrev <u,6,7,0>
  497476253U,	// <6,u,0,u>: Cost 1 vext2 RHS, LHS
  1571218166U,	// <6,u,1,0>: Cost 2 vext2 RHS, <1,0,3,2>
  1571218228U,	// <6,u,1,1>: Cost 2 vext2 RHS, <1,1,1,1>
  1631606574U,	// <6,u,1,2>: Cost 2 vext3 <3,4,5,6>, LHS
  2705348407U,	// <6,u,1,3>: Cost 3 vext3 <3,4,5,6>, <u,1,3,3>
  2644960290U,	// <6,u,1,4>: Cost 3 vext2 RHS, <1,4,0,5>
  1571218576U,	// <6,u,1,5>: Cost 2 vext2 RHS, <1,5,3,7>
  2708002642U,	// <6,u,1,6>: Cost 3 vext3 <3,u,5,6>, <u,1,6,3>
  2705348443U,	// <6,u,1,7>: Cost 3 vext3 <3,4,5,6>, <u,1,7,3>
  1631606628U,	// <6,u,1,u>: Cost 2 vext3 <3,4,5,6>, LHS
  1504280678U,	// <6,u,2,0>: Cost 2 vext1 <4,6,0,2>, LHS
  2644960774U,	// <6,u,2,1>: Cost 3 vext2 RHS, <2,1,0,3>
  1571219048U,	// <6,u,2,2>: Cost 2 vext2 RHS, <2,2,2,2>
  1571219110U,	// <6,u,2,3>: Cost 2 vext2 RHS, <2,3,0,1>
  1660065684U,	// <6,u,2,4>: Cost 2 vext3 <u,2,4,6>, <u,2,4,6>
  2644961102U,	// <6,u,2,5>: Cost 3 vext2 RHS, <2,5,0,7>
  1571219386U,	// <6,u,2,6>: Cost 2 vext2 RHS, <2,6,3,7>
  2705348524U,	// <6,u,2,7>: Cost 3 vext3 <3,4,5,6>, <u,2,7,3>
  1571219515U,	// <6,u,2,u>: Cost 2 vext2 RHS, <2,u,0,1>
  1571219606U,	// <6,u,3,0>: Cost 2 vext2 RHS, <3,0,1,2>
  2644961502U,	// <6,u,3,1>: Cost 3 vext2 RHS, <3,1,0,2>
  2644961582U,	// <6,u,3,2>: Cost 3 vext2 RHS, <3,2,0,1>
  1571219868U,	// <6,u,3,3>: Cost 2 vext2 RHS, <3,3,3,3>
  1571219970U,	// <6,u,3,4>: Cost 2 vext2 RHS, <3,4,5,6>
  2644961826U,	// <6,u,3,5>: Cost 3 vext2 RHS, <3,5,0,2>
  2708002806U,	// <6,u,3,6>: Cost 3 vext3 <3,u,5,6>, <u,3,6,5>
  2668849859U,	// <6,u,3,7>: Cost 3 vext2 RHS, <3,7,0,1>
  1571220254U,	// <6,u,3,u>: Cost 2 vext2 RHS, <3,u,1,2>
  1567902626U,	// <6,u,4,0>: Cost 2 vext2 <4,0,6,u>, <4,0,6,u>
  2642308083U,	// <6,u,4,1>: Cost 3 vext2 <4,1,6,u>, <4,1,6,u>
  1661245476U,	// <6,u,4,2>: Cost 2 vext3 <u,4,2,6>, <u,4,2,6>
  2643635349U,	// <6,u,4,3>: Cost 3 vext2 <4,3,6,u>, <4,3,6,u>
  1571220688U,	// <6,u,4,4>: Cost 2 vext2 RHS, <4,4,4,4>
  497478967U,	// <6,u,4,5>: Cost 1 vext2 RHS, RHS
  1571220812U,	// <6,u,4,6>: Cost 2 vext2 RHS, <4,6,0,2>
  1661614161U,	// <6,u,4,7>: Cost 2 vext3 <u,4,7,6>, <u,4,7,6>
  497479209U,	// <6,u,4,u>: Cost 1 vext2 RHS, RHS
  2644962887U,	// <6,u,5,0>: Cost 3 vext2 RHS, <5,0,1,1>
  1571221200U,	// <6,u,5,1>: Cost 2 vext2 RHS, <5,1,7,3>
  2644963051U,	// <6,u,5,2>: Cost 3 vext2 RHS, <5,2,1,3>
  2644963184U,	// <6,u,5,3>: Cost 3 vext2 RHS, <5,3,7,1>
  1571221446U,	// <6,u,5,4>: Cost 2 vext2 RHS, <5,4,7,6>
  1571221508U,	// <6,u,5,5>: Cost 2 vext2 RHS, <5,5,5,5>
  1631606938U,	// <6,u,5,6>: Cost 2 vext3 <3,4,5,6>, RHS
  2644963446U,	// <6,u,5,7>: Cost 3 vext2 RHS, <5,7,0,2>
  1631606956U,	// <6,u,5,u>: Cost 2 vext3 <3,4,5,6>, RHS
  1504608358U,	// <6,u,6,0>: Cost 2 vext1 <4,6,4,6>, LHS
  2644963708U,	// <6,u,6,1>: Cost 3 vext2 RHS, <6,1,2,3>
  1571222010U,	// <6,u,6,2>: Cost 2 vext2 RHS, <6,2,7,3>
  2705569997U,	// <6,u,6,3>: Cost 3 vext3 <3,4,u,6>, <u,6,3,4>
  1662720216U,	// <6,u,6,4>: Cost 2 vext3 <u,6,4,6>, <u,6,4,6>
  2644964018U,	// <6,u,6,5>: Cost 3 vext2 RHS, <6,5,0,7>
  296144182U,	// <6,u,6,6>: Cost 1 vdup2 RHS
  1571222350U,	// <6,u,6,7>: Cost 2 vext2 RHS, <6,7,0,1>
  296144182U,	// <6,u,6,u>: Cost 1 vdup2 RHS
  1571222522U,	// <6,u,7,0>: Cost 2 vext2 RHS, <7,0,1,2>
  2900217142U,	// <6,u,7,1>: Cost 3 vzipl <2,3,u,1>, RHS
  1492969447U,	// <6,u,7,2>: Cost 2 vext1 <2,6,u,7>, <2,6,u,7>
  1813220662U,	// <6,u,7,3>: Cost 2 vzipl LHS, RHS
  1571222886U,	// <6,u,7,4>: Cost 2 vext2 RHS, <7,4,5,6>
  2900249910U,	// <6,u,7,5>: Cost 3 vzipl <2,3,u,5>, RHS
  1516860235U,	// <6,u,7,6>: Cost 2 vext1 <6,6,u,7>, <6,6,u,7>
  1571223148U,	// <6,u,7,7>: Cost 2 vext2 RHS, <7,7,7,7>
  1813261622U,	// <6,u,7,u>: Cost 2 vzipl LHS, RHS
  1571223250U,	// <6,u,u,0>: Cost 2 vext2 RHS, <u,0,1,1>
  497481518U,	// <6,u,u,1>: Cost 1 vext2 RHS, LHS
  1631607141U,	// <6,u,u,2>: Cost 2 vext3 <3,4,5,6>, LHS
  1813220663U,	// <6,u,u,3>: Cost 2 vzipl LHS, RHS
  1571223578U,	// <6,u,u,4>: Cost 2 vext2 RHS, <u,4,1,5>
  497481882U,	// <6,u,u,5>: Cost 1 vext2 RHS, RHS
  296144182U,	// <6,u,u,6>: Cost 1 vdup2 RHS
  1839795511U,	// <6,u,u,7>: Cost 2 vzipl RHS, RHS
  497482085U,	// <6,u,u,u>: Cost 1 vext2 RHS, LHS
  1638318080U,	// <7,0,0,0>: Cost 2 vext3 RHS, <0,0,0,0>
  1638318090U,	// <7,0,0,1>: Cost 2 vext3 RHS, <0,0,1,1>
  1638318100U,	// <7,0,0,2>: Cost 2 vext3 RHS, <0,0,2,2>
  3785801755U,	// <7,0,0,3>: Cost 4 vext3 RHS, <0,0,3,0>
  2712207402U,	// <7,0,0,4>: Cost 3 vext3 RHS, <0,0,4,6>
  2651603410U,	// <7,0,0,5>: Cost 3 vext2 <5,6,7,0>, <0,5,6,7>
  2590618445U,	// <7,0,0,6>: Cost 3 vext1 <6,7,0,0>, <6,7,0,0>
  3998634082U,	// <7,0,0,7>: Cost 4 vzipl <6,5,0,7>, <5,6,7,0>
  1638318153U,	// <7,0,0,u>: Cost 2 vext3 RHS, <0,0,u,1>
  1516879974U,	// <7,0,1,0>: Cost 2 vext1 <6,7,0,1>, LHS
  2712059996U,	// <7,0,1,1>: Cost 3 vext3 RHS, <0,1,1,2>
  564576358U,	// <7,0,1,2>: Cost 1 vext3 RHS, LHS
  2590623894U,	// <7,0,1,3>: Cost 3 vext1 <6,7,0,1>, <3,0,1,2>
  1516883254U,	// <7,0,1,4>: Cost 2 vext1 <6,7,0,1>, RHS
  2651604112U,	// <7,0,1,5>: Cost 3 vext2 <5,6,7,0>, <1,5,3,7>
  1516884814U,	// <7,0,1,6>: Cost 2 vext1 <6,7,0,1>, <6,7,0,1>
  2590626808U,	// <7,0,1,7>: Cost 3 vext1 <6,7,0,1>, <7,0,1,0>
  564576412U,	// <7,0,1,u>: Cost 1 vext3 RHS, LHS
  1638318244U,	// <7,0,2,0>: Cost 2 vext3 RHS, <0,2,0,2>
  2712060078U,	// <7,0,2,1>: Cost 3 vext3 RHS, <0,2,1,3>
  2712060087U,	// <7,0,2,2>: Cost 3 vext3 RHS, <0,2,2,3>
  2712060098U,	// <7,0,2,3>: Cost 3 vext3 RHS, <0,2,3,5>
  1638465740U,	// <7,0,2,4>: Cost 2 vext3 RHS, <0,2,4,6>
  2584661712U,	// <7,0,2,5>: Cost 3 vext1 <5,7,0,2>, <5,1,7,3>
  2651604922U,	// <7,0,2,6>: Cost 3 vext2 <5,6,7,0>, <2,6,3,7>
  2735948002U,	// <7,0,2,7>: Cost 3 vext3 RHS, <0,2,7,1>
  1662206188U,	// <7,0,2,u>: Cost 2 vext3 RHS, <0,2,u,2>
  2651605142U,	// <7,0,3,0>: Cost 3 vext2 <5,6,7,0>, <3,0,1,2>
  3973369552U,	// <7,0,3,1>: Cost 4 vzipl <2,3,0,1>, <5,1,7,3>
  2712060165U,	// <7,0,3,2>: Cost 3 vext3 RHS, <0,3,2,0>
  2651605404U,	// <7,0,3,3>: Cost 3 vext2 <5,6,7,0>, <3,3,3,3>
  2651605506U,	// <7,0,3,4>: Cost 3 vext2 <5,6,7,0>, <3,4,5,6>
  2651605597U,	// <7,0,3,5>: Cost 3 vext2 <5,6,7,0>, <3,5,6,7>
  2639661744U,	// <7,0,3,6>: Cost 3 vext2 <3,6,7,0>, <3,6,7,0>
  3729328834U,	// <7,0,3,7>: Cost 4 vext2 <6,3,7,0>, <3,7,0,0>
  2712060219U,	// <7,0,3,u>: Cost 3 vext3 RHS, <0,3,u,0>
  2651605906U,	// <7,0,4,0>: Cost 3 vext2 <5,6,7,0>, <4,0,5,1>
  1638465874U,	// <7,0,4,1>: Cost 2 vext3 RHS, <0,4,1,5>
  1638465884U,	// <7,0,4,2>: Cost 2 vext3 RHS, <0,4,2,6>
  3725347975U,	// <7,0,4,3>: Cost 4 vext2 <5,6,7,0>, <4,3,5,3>
  2712207726U,	// <7,0,4,4>: Cost 3 vext3 RHS, <0,4,4,6>
  1577864502U,	// <7,0,4,5>: Cost 2 vext2 <5,6,7,0>, RHS
  2651606348U,	// <7,0,4,6>: Cost 3 vext2 <5,6,7,0>, <4,6,0,2>
  3725348305U,	// <7,0,4,7>: Cost 4 vext2 <5,6,7,0>, <4,7,6,0>
  1638465937U,	// <7,0,4,u>: Cost 2 vext3 RHS, <0,4,u,5>
  2712207772U,	// <7,0,5,0>: Cost 3 vext3 RHS, <0,5,0,7>
  2712060318U,	// <7,0,5,1>: Cost 3 vext3 RHS, <0,5,1,0>
  2712207790U,	// <7,0,5,2>: Cost 3 vext3 RHS, <0,5,2,7>
  2649616239U,	// <7,0,5,3>: Cost 3 vext2 <5,3,7,0>, <5,3,7,0>
  2651606972U,	// <7,0,5,4>: Cost 3 vext2 <5,6,7,0>, <5,4,6,5>
  2651607044U,	// <7,0,5,5>: Cost 3 vext2 <5,6,7,0>, <5,5,5,5>
  1577865314U,	// <7,0,5,6>: Cost 2 vext2 <5,6,7,0>, <5,6,7,0>
  2652270771U,	// <7,0,5,7>: Cost 3 vext2 <5,7,7,0>, <5,7,7,0>
  1579192580U,	// <7,0,5,u>: Cost 2 vext2 <5,u,7,0>, <5,u,7,0>
  2712207853U,	// <7,0,6,0>: Cost 3 vext3 RHS, <0,6,0,7>
  2712207862U,	// <7,0,6,1>: Cost 3 vext3 RHS, <0,6,1,7>
  2712060408U,	// <7,0,6,2>: Cost 3 vext3 RHS, <0,6,2,0>
  2655588936U,	// <7,0,6,3>: Cost 3 vext2 <6,3,7,0>, <6,3,7,0>
  3785802250U,	// <7,0,6,4>: Cost 4 vext3 RHS, <0,6,4,0>
  2651607730U,	// <7,0,6,5>: Cost 3 vext2 <5,6,7,0>, <6,5,0,7>
  2651607864U,	// <7,0,6,6>: Cost 3 vext2 <5,6,7,0>, <6,6,6,6>
  2651607886U,	// <7,0,6,7>: Cost 3 vext2 <5,6,7,0>, <6,7,0,1>
  2712060462U,	// <7,0,6,u>: Cost 3 vext3 RHS, <0,6,u,0>
  2651608058U,	// <7,0,7,0>: Cost 3 vext2 <5,6,7,0>, <7,0,1,2>
  2735948359U,	// <7,0,7,1>: Cost 3 vext3 RHS, <0,7,1,7>
  2735948362U,	// <7,0,7,2>: Cost 3 vext3 RHS, <0,7,2,1>
  3725350115U,	// <7,0,7,3>: Cost 4 vext2 <5,6,7,0>, <7,3,0,1>
  2651608422U,	// <7,0,7,4>: Cost 3 vext2 <5,6,7,0>, <7,4,5,6>
  2651608513U,	// <7,0,7,5>: Cost 3 vext2 <5,6,7,0>, <7,5,6,7>
  2663552532U,	// <7,0,7,6>: Cost 3 vext2 <7,6,7,0>, <7,6,7,0>
  2651608684U,	// <7,0,7,7>: Cost 3 vext2 <5,6,7,0>, <7,7,7,7>
  2651608706U,	// <7,0,7,u>: Cost 3 vext2 <5,6,7,0>, <7,u,1,2>
  1638318730U,	// <7,0,u,0>: Cost 2 vext3 RHS, <0,u,0,2>
  1577867054U,	// <7,0,u,1>: Cost 2 vext2 <5,6,7,0>, LHS
  564576925U,	// <7,0,u,2>: Cost 1 vext3 RHS, LHS
  2712060584U,	// <7,0,u,3>: Cost 3 vext3 RHS, <0,u,3,5>
  1638466226U,	// <7,0,u,4>: Cost 2 vext3 RHS, <0,u,4,6>
  1577867418U,	// <7,0,u,5>: Cost 2 vext2 <5,6,7,0>, RHS
  1516942165U,	// <7,0,u,6>: Cost 2 vext1 <6,7,0,u>, <6,7,0,u>
  2651609344U,	// <7,0,u,7>: Cost 3 vext2 <5,6,7,0>, <u,7,0,1>
  564576979U,	// <7,0,u,u>: Cost 1 vext3 RHS, LHS
  2712060634U,	// <7,1,0,0>: Cost 3 vext3 RHS, <1,0,0,1>
  2712060643U,	// <7,1,0,1>: Cost 3 vext3 RHS, <1,0,1,1>
  2712060652U,	// <7,1,0,2>: Cost 3 vext3 RHS, <1,0,2,1>
  1638318838U,	// <7,1,0,3>: Cost 2 vext3 RHS, <1,0,3,2>
  2590690614U,	// <7,1,0,4>: Cost 3 vext1 <6,7,1,0>, RHS
  3785802503U,	// <7,1,0,5>: Cost 4 vext3 RHS, <1,0,5,1>
  2590692182U,	// <7,1,0,6>: Cost 3 vext1 <6,7,1,0>, <6,7,1,0>
  3721372224U,	// <7,1,0,7>: Cost 4 vext2 <5,0,7,1>, <0,7,1,0>
  1638318883U,	// <7,1,0,u>: Cost 2 vext3 RHS, <1,0,u,2>
  2712060715U,	// <7,1,1,0>: Cost 3 vext3 RHS, <1,1,0,1>
  1638318900U,	// <7,1,1,1>: Cost 2 vext3 RHS, <1,1,1,1>
  3785802557U,	// <7,1,1,2>: Cost 4 vext3 RHS, <1,1,2,1>
  1638318920U,	// <7,1,1,3>: Cost 2 vext3 RHS, <1,1,3,3>
  2712060755U,	// <7,1,1,4>: Cost 3 vext3 RHS, <1,1,4,5>
  2649621648U,	// <7,1,1,5>: Cost 3 vext2 <5,3,7,1>, <1,5,3,7>
  2590700375U,	// <7,1,1,6>: Cost 3 vext1 <6,7,1,1>, <6,7,1,1>
  3785802608U,	// <7,1,1,7>: Cost 4 vext3 RHS, <1,1,7,7>
  1638318965U,	// <7,1,1,u>: Cost 2 vext3 RHS, <1,1,u,3>
  2712060796U,	// <7,1,2,0>: Cost 3 vext3 RHS, <1,2,0,1>
  2712060807U,	// <7,1,2,1>: Cost 3 vext3 RHS, <1,2,1,3>
  2712060816U,	// <7,1,2,2>: Cost 3 vext3 RHS, <1,2,2,3>
  1638318998U,	// <7,1,2,3>: Cost 2 vext3 RHS, <1,2,3,0>
  2712060836U,	// <7,1,2,4>: Cost 3 vext3 RHS, <1,2,4,5>
  2735948715U,	// <7,1,2,5>: Cost 3 vext3 RHS, <1,2,5,3>
  2590708568U,	// <7,1,2,6>: Cost 3 vext1 <6,7,1,2>, <6,7,1,2>
  2735948730U,	// <7,1,2,7>: Cost 3 vext3 RHS, <1,2,7,0>
  1638319043U,	// <7,1,2,u>: Cost 2 vext3 RHS, <1,2,u,0>
  2712060878U,	// <7,1,3,0>: Cost 3 vext3 RHS, <1,3,0,2>
  2712060888U,	// <7,1,3,1>: Cost 3 vext3 RHS, <1,3,1,3>
  3977432784U,	// <7,1,3,2>: Cost 4 vzipl <3,0,1,2>, <5,1,7,3>
  2712060903U,	// <7,1,3,3>: Cost 3 vext3 RHS, <1,3,3,0>
  2712208374U,	// <7,1,3,4>: Cost 3 vext3 RHS, <1,3,4,6>
  3992055504U,	// <7,1,3,5>: Cost 4 vzipl <5,4,1,5>, <5,1,7,3>
  3664458585U,	// <7,1,3,6>: Cost 4 vext1 <6,7,1,3>, <6,7,1,3>
  3980791504U,	// <7,1,3,7>: Cost 4 vzipl <3,5,1,7>, <5,1,7,3>
  2712060948U,	// <7,1,3,u>: Cost 3 vext3 RHS, <1,3,u,0>
  2712060962U,	// <7,1,4,0>: Cost 3 vext3 RHS, <1,4,0,5>
  3785802791U,	// <7,1,4,1>: Cost 4 vext3 RHS, <1,4,1,1>
  2712208436U,	// <7,1,4,2>: Cost 3 vext3 RHS, <1,4,2,5>
  2712060990U,	// <7,1,4,3>: Cost 3 vext3 RHS, <1,4,3,6>
  3785802822U,	// <7,1,4,4>: Cost 4 vext3 RHS, <1,4,4,5>
  2712061008U,	// <7,1,4,5>: Cost 3 vext3 RHS, <1,4,5,6>
  2846282746U,	// <7,1,4,6>: Cost 3 vuzpr RHS, <7,0,1,2>
  3670439475U,	// <7,1,4,7>: Cost 4 vext1 <7,7,1,4>, <7,7,1,4>
  2712061035U,	// <7,1,4,u>: Cost 3 vext3 RHS, <1,4,u,6>
  2647633533U,	// <7,1,5,0>: Cost 3 vext2 <5,0,7,1>, <5,0,7,1>
  2648297166U,	// <7,1,5,1>: Cost 3 vext2 <5,1,7,1>, <5,1,7,1>
  3785802880U,	// <7,1,5,2>: Cost 4 vext3 RHS, <1,5,2,0>
  1638466704U,	// <7,1,5,3>: Cost 2 vext3 RHS, <1,5,3,7>
  2590731574U,	// <7,1,5,4>: Cost 3 vext1 <6,7,1,5>, RHS
  3785802912U,	// <7,1,5,5>: Cost 4 vext3 RHS, <1,5,5,5>
  2651615331U,	// <7,1,5,6>: Cost 3 vext2 <5,6,7,1>, <5,6,7,1>
  3923383290U,	// <7,1,5,7>: Cost 4 vuzpr <5,1,7,3>, <7,0,1,2>
  1638466749U,	// <7,1,5,u>: Cost 2 vext3 RHS, <1,5,u,7>
  2653606230U,	// <7,1,6,0>: Cost 3 vext2 <6,0,7,1>, <6,0,7,1>
  2712208591U,	// <7,1,6,1>: Cost 3 vext3 RHS, <1,6,1,7>
  3768255704U,	// <7,1,6,2>: Cost 4 vext3 <1,6,2,7>, <1,6,2,7>
  2714051804U,	// <7,1,6,3>: Cost 3 vext3 RHS, <1,6,3,2>
  3658509202U,	// <7,1,6,4>: Cost 4 vext1 <5,7,1,6>, <4,0,5,1>
  2712208628U,	// <7,1,6,5>: Cost 3 vext3 RHS, <1,6,5,u>
  3785803003U,	// <7,1,6,6>: Cost 4 vext3 RHS, <1,6,6,6>
  2735949054U,	// <7,1,6,7>: Cost 3 vext3 RHS, <1,6,7,0>
  2714051849U,	// <7,1,6,u>: Cost 3 vext3 RHS, <1,6,u,2>
  2660242426U,	// <7,1,7,0>: Cost 3 vext2 <7,1,7,1>, <7,0,1,2>
  2860471290U,	// <7,1,7,1>: Cost 3 vuzpr <7,0,1,2>, <7,0,1,2>
  3723367596U,	// <7,1,7,2>: Cost 4 vext2 <5,3,7,1>, <7,2,3,0>
  3068515948U,	// <7,1,7,3>: Cost 3 vtrnl LHS, <7,7,7,7>
  2602691894U,	// <7,1,7,4>: Cost 3 vext1 <u,7,1,7>, RHS
  3779462462U,	// <7,1,7,5>: Cost 4 vext3 <3,5,1,7>, <1,7,5,1>
  3727349212U,	// <7,1,7,6>: Cost 4 vext2 <6,0,7,1>, <7,6,0,7>
  2602694252U,	// <7,1,7,7>: Cost 3 vext1 <u,7,1,7>, <7,7,7,7>
  3068556908U,	// <7,1,7,u>: Cost 3 vtrnl LHS, <7,7,7,7>
  2712061282U,	// <7,1,u,0>: Cost 3 vext3 RHS, <1,u,0,1>
  1638318900U,	// <7,1,u,1>: Cost 2 vext3 RHS, <1,1,1,1>
  2712061302U,	// <7,1,u,2>: Cost 3 vext3 RHS, <1,u,2,3>
  1638319484U,	// <7,1,u,3>: Cost 2 vext3 RHS, <1,u,3,0>
  2712061322U,	// <7,1,u,4>: Cost 3 vext3 RHS, <1,u,4,5>
  2712061332U,	// <7,1,u,5>: Cost 3 vext3 RHS, <1,u,5,6>
  2590757726U,	// <7,1,u,6>: Cost 3 vext1 <6,7,1,u>, <6,7,1,u>
  2735949216U,	// <7,1,u,7>: Cost 3 vext3 RHS, <1,u,7,0>
  1638319529U,	// <7,1,u,u>: Cost 2 vext3 RHS, <1,u,u,0>
  2712061364U,	// <7,2,0,0>: Cost 3 vext3 RHS, <2,0,0,2>
  2712061373U,	// <7,2,0,1>: Cost 3 vext3 RHS, <2,0,1,2>
  2712061380U,	// <7,2,0,2>: Cost 3 vext3 RHS, <2,0,2,0>
  2712061390U,	// <7,2,0,3>: Cost 3 vext3 RHS, <2,0,3,1>
  2712061400U,	// <7,2,0,4>: Cost 3 vext3 RHS, <2,0,4,2>
  3785803231U,	// <7,2,0,5>: Cost 4 vext3 RHS, <2,0,5,0>
  2700559849U,	// <7,2,0,6>: Cost 3 vext3 <2,6,3,7>, <2,0,6,1>
  3787793907U,	// <7,2,0,7>: Cost 4 vext3 RHS, <2,0,7,2>
  2712061434U,	// <7,2,0,u>: Cost 3 vext3 RHS, <2,0,u,0>
  2712061446U,	// <7,2,1,0>: Cost 3 vext3 RHS, <2,1,0,3>
  3785803276U,	// <7,2,1,1>: Cost 4 vext3 RHS, <2,1,1,0>
  2712061464U,	// <7,2,1,2>: Cost 3 vext3 RHS, <2,1,2,3>
  2712061471U,	// <7,2,1,3>: Cost 3 vext3 RHS, <2,1,3,1>
  2712061482U,	// <7,2,1,4>: Cost 3 vext3 RHS, <2,1,4,3>
  3785803315U,	// <7,2,1,5>: Cost 4 vext3 RHS, <2,1,5,3>
  2735949372U,	// <7,2,1,6>: Cost 3 vext3 RHS, <2,1,6,3>
  2602718850U,	// <7,2,1,7>: Cost 3 vext1 <u,7,2,1>, <7,u,1,2>
  2712061518U,	// <7,2,1,u>: Cost 3 vext3 RHS, <2,1,u,3>
  2712061524U,	// <7,2,2,0>: Cost 3 vext3 RHS, <2,2,0,0>
  3785803357U,	// <7,2,2,1>: Cost 4 vext3 RHS, <2,2,1,0>
  1638319720U,	// <7,2,2,2>: Cost 2 vext3 RHS, <2,2,2,2>
  1638319730U,	// <7,2,2,3>: Cost 2 vext3 RHS, <2,2,3,3>
  2712061564U,	// <7,2,2,4>: Cost 3 vext3 RHS, <2,2,4,4>
  3785803394U,	// <7,2,2,5>: Cost 4 vext3 RHS, <2,2,5,1>
  2590782305U,	// <7,2,2,6>: Cost 3 vext1 <6,7,2,2>, <6,7,2,2>
  3780200086U,	// <7,2,2,7>: Cost 4 vext3 <3,6,2,7>, <2,2,7,3>
  1638319775U,	// <7,2,2,u>: Cost 2 vext3 RHS, <2,2,u,3>
  1638319782U,	// <7,2,3,0>: Cost 2 vext3 RHS, <2,3,0,1>
  2712061614U,	// <7,2,3,1>: Cost 3 vext3 RHS, <2,3,1,0>
  2712061625U,	// <7,2,3,2>: Cost 3 vext3 RHS, <2,3,2,2>
  2886521338U,	// <7,2,3,3>: Cost 3 vzipl LHS, <6,2,7,3>
  1638319822U,	// <7,2,3,4>: Cost 2 vext3 RHS, <2,3,4,5>
  2712061651U,	// <7,2,3,5>: Cost 3 vext3 RHS, <2,3,5,1>
  2712061661U,	// <7,2,3,6>: Cost 3 vext3 RHS, <2,3,6,2>
  2735949540U,	// <7,2,3,7>: Cost 3 vext3 RHS, <2,3,7,0>
  1638319854U,	// <7,2,3,u>: Cost 2 vext3 RHS, <2,3,u,1>
  2712061688U,	// <7,2,4,0>: Cost 3 vext3 RHS, <2,4,0,2>
  3785803520U,	// <7,2,4,1>: Cost 4 vext3 RHS, <2,4,1,1>
  2712061708U,	// <7,2,4,2>: Cost 3 vext3 RHS, <2,4,2,4>
  2712061718U,	// <7,2,4,3>: Cost 3 vext3 RHS, <2,4,3,5>
  2712209184U,	// <7,2,4,4>: Cost 3 vext3 RHS, <2,4,4,6>
  2712061737U,	// <7,2,4,5>: Cost 3 vext3 RHS, <2,4,5,6>
  2712209201U,	// <7,2,4,6>: Cost 3 vext3 RHS, <2,4,6,5>
  3809691445U,	// <7,2,4,7>: Cost 4 vext3 RHS, <2,4,7,0>
  2712061764U,	// <7,2,4,u>: Cost 3 vext3 RHS, <2,4,u,6>
  2712209230U,	// <7,2,5,0>: Cost 3 vext3 RHS, <2,5,0,7>
  2647641808U,	// <7,2,5,1>: Cost 3 vext2 <5,0,7,2>, <5,1,7,3>
  2712209248U,	// <7,2,5,2>: Cost 3 vext3 RHS, <2,5,2,7>
  2712061795U,	// <7,2,5,3>: Cost 3 vext3 RHS, <2,5,3,1>
  2712209266U,	// <7,2,5,4>: Cost 3 vext3 RHS, <2,5,4,7>
  3785951099U,	// <7,2,5,5>: Cost 4 vext3 RHS, <2,5,5,7>
  2712209284U,	// <7,2,5,6>: Cost 3 vext3 RHS, <2,5,6,7>
  3721384054U,	// <7,2,5,7>: Cost 4 vext2 <5,0,7,2>, <5,7,0,2>
  2712061840U,	// <7,2,5,u>: Cost 3 vext3 RHS, <2,5,u,1>
  2653614423U,	// <7,2,6,0>: Cost 3 vext2 <6,0,7,2>, <6,0,7,2>
  2654278056U,	// <7,2,6,1>: Cost 3 vext2 <6,1,7,2>, <6,1,7,2>
  2653614586U,	// <7,2,6,2>: Cost 3 vext2 <6,0,7,2>, <6,2,7,3>
  1638467514U,	// <7,2,6,3>: Cost 2 vext3 RHS, <2,6,3,7>
  2590813494U,	// <7,2,6,4>: Cost 3 vext1 <6,7,2,6>, RHS
  3787794375U,	// <7,2,6,5>: Cost 4 vext3 RHS, <2,6,5,2>
  2712209366U,	// <7,2,6,6>: Cost 3 vext3 RHS, <2,6,6,u>
  3785803735U,	// <7,2,6,7>: Cost 4 vext3 RHS, <2,6,7,0>
  1638467559U,	// <7,2,6,u>: Cost 2 vext3 RHS, <2,6,u,7>
  2735949802U,	// <7,2,7,0>: Cost 3 vext3 RHS, <2,7,0,1>
  3729347651U,	// <7,2,7,1>: Cost 4 vext2 <6,3,7,2>, <7,1,0,3>
  3705459887U,	// <7,2,7,2>: Cost 4 vext2 <2,3,7,2>, <7,2,3,3>
  2934296600U,	// <7,2,7,3>: Cost 3 vzipl LHS, <5,5,7,7>
  2602765622U,	// <7,2,7,4>: Cost 3 vext1 <u,7,2,7>, RHS
  3721385364U,	// <7,2,7,5>: Cost 4 vext2 <5,0,7,2>, <7,5,1,7>
  3780200481U,	// <7,2,7,6>: Cost 4 vext3 <3,6,2,7>, <2,7,6,2>
  2602767980U,	// <7,2,7,7>: Cost 3 vext1 <u,7,2,7>, <7,7,7,7>
  2934337560U,	// <7,2,7,u>: Cost 3 vzipl LHS, <5,5,7,7>
  1638320187U,	// <7,2,u,0>: Cost 2 vext3 RHS, <2,u,0,1>
  2712062019U,	// <7,2,u,1>: Cost 3 vext3 RHS, <2,u,1,0>
  1638319720U,	// <7,2,u,2>: Cost 2 vext3 RHS, <2,2,2,2>
  1640310876U,	// <7,2,u,3>: Cost 2 vext3 RHS, <2,u,3,7>
  1638320227U,	// <7,2,u,4>: Cost 2 vext3 RHS, <2,u,4,5>
  2712062056U,	// <7,2,u,5>: Cost 3 vext3 RHS, <2,u,5,1>
  2712062066U,	// <7,2,u,6>: Cost 3 vext3 RHS, <2,u,6,2>
  2735949945U,	// <7,2,u,7>: Cost 3 vext3 RHS, <2,u,7,0>
  1638320259U,	// <7,2,u,u>: Cost 2 vext3 RHS, <2,u,u,1>
  2712062091U,	// <7,3,0,0>: Cost 3 vext3 RHS, <3,0,0,0>
  1638320278U,	// <7,3,0,1>: Cost 2 vext3 RHS, <3,0,1,2>
  2712062109U,	// <7,3,0,2>: Cost 3 vext3 RHS, <3,0,2,0>
  2712062119U,	// <7,3,0,3>: Cost 3 vext3 RHS, <3,0,3,1>
  2712062128U,	// <7,3,0,4>: Cost 3 vext3 RHS, <3,0,4,1>
  2712062138U,	// <7,3,0,5>: Cost 3 vext3 RHS, <3,0,5,2>
  2590839656U,	// <7,3,0,6>: Cost 3 vext1 <6,7,3,0>, <6,7,3,0>
  3722052169U,	// <7,3,0,7>: Cost 4 vext2 <5,1,7,3>, <0,7,2,0>
  1638320341U,	// <7,3,0,u>: Cost 2 vext3 RHS, <3,0,u,2>
  2712062174U,	// <7,3,1,0>: Cost 3 vext3 RHS, <3,1,0,2>
  2712062182U,	// <7,3,1,1>: Cost 3 vext3 RHS, <3,1,1,1>
  2712062193U,	// <7,3,1,2>: Cost 3 vext3 RHS, <3,1,2,3>
  2712062202U,	// <7,3,1,3>: Cost 3 vext3 RHS, <3,1,3,3>
  2712209670U,	// <7,3,1,4>: Cost 3 vext3 RHS, <3,1,4,6>
  2712062220U,	// <7,3,1,5>: Cost 3 vext3 RHS, <3,1,5,3>
  3785804053U,	// <7,3,1,6>: Cost 4 vext3 RHS, <3,1,6,3>
  2648311083U,	// <7,3,1,7>: Cost 3 vext2 <5,1,7,3>, <1,7,3,0>
  2712062247U,	// <7,3,1,u>: Cost 3 vext3 RHS, <3,1,u,3>
  2712062254U,	// <7,3,2,0>: Cost 3 vext3 RHS, <3,2,0,1>
  2712062262U,	// <7,3,2,1>: Cost 3 vext3 RHS, <3,2,1,0>
  2712062273U,	// <7,3,2,2>: Cost 3 vext3 RHS, <3,2,2,2>
  2712062280U,	// <7,3,2,3>: Cost 3 vext3 RHS, <3,2,3,0>
  2712062292U,	// <7,3,2,4>: Cost 3 vext3 RHS, <3,2,4,3>
  2712062302U,	// <7,3,2,5>: Cost 3 vext3 RHS, <3,2,5,4>
  2648311738U,	// <7,3,2,6>: Cost 3 vext2 <5,1,7,3>, <2,6,3,7>
  2654947332U,	// <7,3,2,7>: Cost 3 vext2 <6,2,7,3>, <2,7,3,0>
  2712062325U,	// <7,3,2,u>: Cost 3 vext3 RHS, <3,2,u,0>
  2712062335U,	// <7,3,3,0>: Cost 3 vext3 RHS, <3,3,0,1>
  2712062344U,	// <7,3,3,1>: Cost 3 vext3 RHS, <3,3,1,1>
  2712062354U,	// <7,3,3,2>: Cost 3 vext3 RHS, <3,3,2,2>
  1638320540U,	// <7,3,3,3>: Cost 2 vext3 RHS, <3,3,3,3>
  2712062374U,	// <7,3,3,4>: Cost 3 vext3 RHS, <3,3,4,4>
  2712062384U,	// <7,3,3,5>: Cost 3 vext3 RHS, <3,3,5,5>
  2654947978U,	// <7,3,3,6>: Cost 3 vext2 <6,2,7,3>, <3,6,2,7>
  3722054339U,	// <7,3,3,7>: Cost 4 vext2 <5,1,7,3>, <3,7,0,1>
  1638320540U,	// <7,3,3,u>: Cost 2 vext3 RHS, <3,3,3,3>
  2712062416U,	// <7,3,4,0>: Cost 3 vext3 RHS, <3,4,0,1>
  2712062426U,	// <7,3,4,1>: Cost 3 vext3 RHS, <3,4,1,2>
  2566981640U,	// <7,3,4,2>: Cost 3 vext1 <2,7,3,4>, <2,7,3,4>
  2590870018U,	// <7,3,4,3>: Cost 3 vext1 <6,7,3,4>, <3,4,5,6>
  2712062456U,	// <7,3,4,4>: Cost 3 vext3 RHS, <3,4,4,5>
  1638320642U,	// <7,3,4,5>: Cost 2 vext3 RHS, <3,4,5,6>
  2712062469U,	// <7,3,4,6>: Cost 3 vext3 RHS, <3,4,6,0>
  3785951763U,	// <7,3,4,7>: Cost 4 vext3 RHS, <3,4,7,5>
  1638320669U,	// <7,3,4,u>: Cost 2 vext3 RHS, <3,4,u,6>
  2712062498U,	// <7,3,5,0>: Cost 3 vext3 RHS, <3,5,0,2>
  1574571728U,	// <7,3,5,1>: Cost 2 vext2 <5,1,7,3>, <5,1,7,3>
  2648977185U,	// <7,3,5,2>: Cost 3 vext2 <5,2,7,3>, <5,2,7,3>
  2712062528U,	// <7,3,5,3>: Cost 3 vext3 RHS, <3,5,3,5>
  2712209994U,	// <7,3,5,4>: Cost 3 vext3 RHS, <3,5,4,6>
  2712210004U,	// <7,3,5,5>: Cost 3 vext3 RHS, <3,5,5,7>
  2648313954U,	// <7,3,5,6>: Cost 3 vext2 <5,1,7,3>, <5,6,7,0>
  2648313974U,	// <7,3,5,7>: Cost 3 vext2 <5,1,7,3>, <5,7,0,2>
  1579217159U,	// <7,3,5,u>: Cost 2 vext2 <5,u,7,3>, <5,u,7,3>
  2654949673U,	// <7,3,6,0>: Cost 3 vext2 <6,2,7,3>, <6,0,2,1>
  2654286249U,	// <7,3,6,1>: Cost 3 vext2 <6,1,7,3>, <6,1,7,3>
  1581208058U,	// <7,3,6,2>: Cost 2 vext2 <6,2,7,3>, <6,2,7,3>
  2712210067U,	// <7,3,6,3>: Cost 3 vext3 RHS, <3,6,3,7>
  2712210076U,	// <7,3,6,4>: Cost 3 vext3 RHS, <3,6,4,7>
  3785804446U,	// <7,3,6,5>: Cost 4 vext3 RHS, <3,6,5,0>
  2648314680U,	// <7,3,6,6>: Cost 3 vext2 <5,1,7,3>, <6,6,6,6>
  2712210103U,	// <7,3,6,7>: Cost 3 vext3 RHS, <3,6,7,7>
  1585189856U,	// <7,3,6,u>: Cost 2 vext2 <6,u,7,3>, <6,u,7,3>
  2712062666U,	// <7,3,7,0>: Cost 3 vext3 RHS, <3,7,0,u>
  2693925584U,	// <7,3,7,1>: Cost 3 vext3 <1,5,3,7>, <3,7,1,5>
  2654950575U,	// <7,3,7,2>: Cost 3 vext2 <6,2,7,3>, <7,2,3,3>
  2648315152U,	// <7,3,7,3>: Cost 3 vext2 <5,1,7,3>, <7,3,5,1>
  2648315238U,	// <7,3,7,4>: Cost 3 vext2 <5,1,7,3>, <7,4,5,6>
  2648315284U,	// <7,3,7,5>: Cost 3 vext2 <5,1,7,3>, <7,5,1,7>
  2654950894U,	// <7,3,7,6>: Cost 3 vext2 <6,2,7,3>, <7,6,2,7>
  2648315500U,	// <7,3,7,7>: Cost 3 vext2 <5,1,7,3>, <7,7,7,7>
  2648315522U,	// <7,3,7,u>: Cost 3 vext2 <5,1,7,3>, <7,u,1,2>
  2712062740U,	// <7,3,u,0>: Cost 3 vext3 RHS, <3,u,0,1>
  1638320926U,	// <7,3,u,1>: Cost 2 vext3 RHS, <3,u,1,2>
  1593153452U,	// <7,3,u,2>: Cost 2 vext2 <u,2,7,3>, <u,2,7,3>
  1638320540U,	// <7,3,u,3>: Cost 2 vext3 RHS, <3,3,3,3>
  2712062778U,	// <7,3,u,4>: Cost 3 vext3 RHS, <3,u,4,3>
  1638320966U,	// <7,3,u,5>: Cost 2 vext3 RHS, <3,u,5,6>
  2712062793U,	// <7,3,u,6>: Cost 3 vext3 RHS, <3,u,6,0>
  2714053465U,	// <7,3,u,7>: Cost 3 vext3 RHS, <3,u,7,7>
  1638320989U,	// <7,3,u,u>: Cost 2 vext3 RHS, <3,u,u,2>
  2712062821U,	// <7,4,0,0>: Cost 3 vext3 RHS, <4,0,0,1>
  1577893990U,	// <7,4,0,1>: Cost 2 vext2 <5,6,7,4>, LHS
  2651635876U,	// <7,4,0,2>: Cost 3 vext2 <5,6,7,4>, <0,2,0,2>
  3785804672U,	// <7,4,0,3>: Cost 4 vext3 RHS, <4,0,3,1>
  2712210318U,	// <7,4,0,4>: Cost 3 vext3 RHS, <4,0,4,6>
  1638321042U,	// <7,4,0,5>: Cost 2 vext3 RHS, <4,0,5,1>
  1638321052U,	// <7,4,0,6>: Cost 2 vext3 RHS, <4,0,6,2>
  3664655354U,	// <7,4,0,7>: Cost 4 vext1 <6,7,4,0>, <7,0,1,2>
  1638321069U,	// <7,4,0,u>: Cost 2 vext3 RHS, <4,0,u,1>
  2651636470U,	// <7,4,1,0>: Cost 3 vext2 <5,6,7,4>, <1,0,3,2>
  2651636532U,	// <7,4,1,1>: Cost 3 vext2 <5,6,7,4>, <1,1,1,1>
  2712062922U,	// <7,4,1,2>: Cost 3 vext3 RHS, <4,1,2,3>
  3785804752U,	// <7,4,1,3>: Cost 4 vext3 RHS, <4,1,3,0>
  2735950812U,	// <7,4,1,4>: Cost 3 vext3 RHS, <4,1,4,3>
  2712062946U,	// <7,4,1,5>: Cost 3 vext3 RHS, <4,1,5,0>
  2712062956U,	// <7,4,1,6>: Cost 3 vext3 RHS, <4,1,6,1>
  3725378859U,	// <7,4,1,7>: Cost 4 vext2 <5,6,7,4>, <1,7,3,0>
  2712062973U,	// <7,4,1,u>: Cost 3 vext3 RHS, <4,1,u,0>
  3785804807U,	// <7,4,2,0>: Cost 4 vext3 RHS, <4,2,0,1>
  3785804818U,	// <7,4,2,1>: Cost 4 vext3 RHS, <4,2,1,3>
  2651637352U,	// <7,4,2,2>: Cost 3 vext2 <5,6,7,4>, <2,2,2,2>
  2651637414U,	// <7,4,2,3>: Cost 3 vext2 <5,6,7,4>, <2,3,0,1>
  2735950893U,	// <7,4,2,4>: Cost 3 vext3 RHS, <4,2,4,3>
  2712063029U,	// <7,4,2,5>: Cost 3 vext3 RHS, <4,2,5,2>
  2712063036U,	// <7,4,2,6>: Cost 3 vext3 RHS, <4,2,6,0>
  3722725389U,	// <7,4,2,7>: Cost 4 vext2 <5,2,7,4>, <2,7,4,0>
  2712063056U,	// <7,4,2,u>: Cost 3 vext3 RHS, <4,2,u,2>
  2651637910U,	// <7,4,3,0>: Cost 3 vext2 <5,6,7,4>, <3,0,1,2>
  3785804896U,	// <7,4,3,1>: Cost 4 vext3 RHS, <4,3,1,0>
  3785804906U,	// <7,4,3,2>: Cost 4 vext3 RHS, <4,3,2,1>
  2651638172U,	// <7,4,3,3>: Cost 3 vext2 <5,6,7,4>, <3,3,3,3>
  2651638274U,	// <7,4,3,4>: Cost 3 vext2 <5,6,7,4>, <3,4,5,6>
  2712063111U,	// <7,4,3,5>: Cost 3 vext3 RHS, <4,3,5,3>
  2712063118U,	// <7,4,3,6>: Cost 3 vext3 RHS, <4,3,6,1>
  3729361638U,	// <7,4,3,7>: Cost 4 vext2 <6,3,7,4>, <3,7,4,0>
  2712063138U,	// <7,4,3,u>: Cost 3 vext3 RHS, <4,3,u,3>
  2712063144U,	// <7,4,4,0>: Cost 3 vext3 RHS, <4,4,0,0>
  3785804979U,	// <7,4,4,1>: Cost 4 vext3 RHS, <4,4,1,2>
  3785804988U,	// <7,4,4,2>: Cost 4 vext3 RHS, <4,4,2,2>
  3785804998U,	// <7,4,4,3>: Cost 4 vext3 RHS, <4,4,3,3>
  1638321360U,	// <7,4,4,4>: Cost 2 vext3 RHS, <4,4,4,4>
  1638468826U,	// <7,4,4,5>: Cost 2 vext3 RHS, <4,4,5,5>
  1638468836U,	// <7,4,4,6>: Cost 2 vext3 RHS, <4,4,6,6>
  3787795694U,	// <7,4,4,7>: Cost 4 vext3 RHS, <4,4,7,7>
  1638468853U,	// <7,4,4,u>: Cost 2 vext3 RHS, <4,4,u,5>
  1517207654U,	// <7,4,5,0>: Cost 2 vext1 <6,7,4,5>, LHS
  2651639504U,	// <7,4,5,1>: Cost 3 vext2 <5,6,7,4>, <5,1,7,3>
  2712063246U,	// <7,4,5,2>: Cost 3 vext3 RHS, <4,5,2,3>
  2590951574U,	// <7,4,5,3>: Cost 3 vext1 <6,7,4,5>, <3,0,1,2>
  1517210934U,	// <7,4,5,4>: Cost 2 vext1 <6,7,4,5>, RHS
  2712210726U,	// <7,4,5,5>: Cost 3 vext3 RHS, <4,5,5,0>
  564579638U,	// <7,4,5,6>: Cost 1 vext3 RHS, RHS
  2652303543U,	// <7,4,5,7>: Cost 3 vext2 <5,7,7,4>, <5,7,7,4>
  564579656U,	// <7,4,5,u>: Cost 1 vext3 RHS, RHS
  1638321484U,	// <7,4,6,0>: Cost 2 vext3 RHS, <4,6,0,2>
  2712063316U,	// <7,4,6,1>: Cost 3 vext3 RHS, <4,6,1,1>
  2712063324U,	// <7,4,6,2>: Cost 3 vext3 RHS, <4,6,2,0>
  2712063334U,	// <7,4,6,3>: Cost 3 vext3 RHS, <4,6,3,1>
  1638468980U,	// <7,4,6,4>: Cost 2 vext3 RHS, <4,6,4,6>
  2712210814U,	// <7,4,6,5>: Cost 3 vext3 RHS, <4,6,5,7>
  2712210816U,	// <7,4,6,6>: Cost 3 vext3 RHS, <4,6,6,0>
  2651640654U,	// <7,4,6,7>: Cost 3 vext2 <5,6,7,4>, <6,7,0,1>
  1662209428U,	// <7,4,6,u>: Cost 2 vext3 RHS, <4,6,u,2>
  2651640826U,	// <7,4,7,0>: Cost 3 vext2 <5,6,7,4>, <7,0,1,2>
  3725382723U,	// <7,4,7,1>: Cost 4 vext2 <5,6,7,4>, <7,1,0,3>
  3725382821U,	// <7,4,7,2>: Cost 4 vext2 <5,6,7,4>, <7,2,2,2>
  3785952700U,	// <7,4,7,3>: Cost 4 vext3 RHS, <4,7,3,6>
  2651641140U,	// <7,4,7,4>: Cost 3 vext2 <5,6,7,4>, <7,4,0,1>
  2980501100U,	// <7,4,7,5>: Cost 3 vzipr RHS, <7,7,7,7>
  3114718828U,	// <7,4,7,6>: Cost 3 vtrnr RHS, <7,7,7,7>
  2651641452U,	// <7,4,7,7>: Cost 3 vext2 <5,6,7,4>, <7,7,7,7>
  3114866284U,	// <7,4,7,u>: Cost 3 vtrnr RHS, <7,7,7,7>
  1638321646U,	// <7,4,u,0>: Cost 2 vext3 RHS, <4,u,0,2>
  1577899822U,	// <7,4,u,1>: Cost 2 vext2 <5,6,7,4>, LHS
  2712063488U,	// <7,4,u,2>: Cost 3 vext3 RHS, <4,u,2,2>
  2712063496U,	// <7,4,u,3>: Cost 3 vext3 RHS, <4,u,3,1>
  1638469142U,	// <7,4,u,4>: Cost 2 vext3 RHS, <4,u,4,6>
  1577900186U,	// <7,4,u,5>: Cost 2 vext2 <5,6,7,4>, RHS
  564579881U,	// <7,4,u,6>: Cost 1 vext3 RHS, RHS
  2651642112U,	// <7,4,u,7>: Cost 3 vext2 <5,6,7,4>, <u,7,0,1>
  564579899U,	// <7,4,u,u>: Cost 1 vext3 RHS, RHS
  3785805373U,	// <7,5,0,0>: Cost 4 vext3 RHS, <5,0,0,0>
  2712063559U,	// <7,5,0,1>: Cost 3 vext3 RHS, <5,0,1,1>
  2819413350U,	// <7,5,0,2>: Cost 3 vuzpr LHS, <7,4,5,6>
  3785805404U,	// <7,5,0,3>: Cost 4 vext3 RHS, <5,0,3,4>
  2712063586U,	// <7,5,0,4>: Cost 3 vext3 RHS, <5,0,4,1>
  2712063595U,	// <7,5,0,5>: Cost 3 vext3 RHS, <5,0,5,1>
  2712063604U,	// <7,5,0,6>: Cost 3 vext3 RHS, <5,0,6,1>
  2712063613U,	// <7,5,0,7>: Cost 3 vext3 RHS, <5,0,7,1>
  2712063623U,	// <7,5,0,u>: Cost 3 vext3 RHS, <5,0,u,2>
  2712063631U,	// <7,5,1,0>: Cost 3 vext3 RHS, <5,1,0,1>
  3983692523U,	// <7,5,1,1>: Cost 4 vzipl <4,0,5,1>, <6,5,7,1>
  3785805474U,	// <7,5,1,2>: Cost 4 vext3 RHS, <5,1,2,2>
  3785805481U,	// <7,5,1,3>: Cost 4 vext3 RHS, <5,1,3,0>
  2712063666U,	// <7,5,1,4>: Cost 3 vext3 RHS, <5,1,4,0>
  2590994128U,	// <7,5,1,5>: Cost 3 vext1 <6,7,5,1>, <5,1,7,3>
  2590995323U,	// <7,5,1,6>: Cost 3 vext1 <6,7,5,1>, <6,7,5,1>
  1638321872U,	// <7,5,1,7>: Cost 2 vext3 RHS, <5,1,7,3>
  1638321881U,	// <7,5,1,u>: Cost 2 vext3 RHS, <5,1,u,3>
  3785805536U,	// <7,5,2,0>: Cost 4 vext3 RHS, <5,2,0,1>
  2712063723U,	// <7,5,2,1>: Cost 3 vext3 RHS, <5,2,1,3>
  3785805555U,	// <7,5,2,2>: Cost 4 vext3 RHS, <5,2,2,2>
  2712063742U,	// <7,5,2,3>: Cost 3 vext3 RHS, <5,2,3,4>
  3785805571U,	// <7,5,2,4>: Cost 4 vext3 RHS, <5,2,4,0>
  2735951631U,	// <7,5,2,5>: Cost 3 vext3 RHS, <5,2,5,3>
  2712063768U,	// <7,5,2,6>: Cost 3 vext3 RHS, <5,2,6,3>
  2712063774U,	// <7,5,2,7>: Cost 3 vext3 RHS, <5,2,7,0>
  2712063783U,	// <7,5,2,u>: Cost 3 vext3 RHS, <5,2,u,0>
  3785805617U,	// <7,5,3,0>: Cost 4 vext3 RHS, <5,3,0,1>
  3973738192U,	// <7,5,3,1>: Cost 4 vzipl <2,3,5,1>, <5,1,7,3>
  3785805637U,	// <7,5,3,2>: Cost 4 vext3 RHS, <5,3,2,3>
  3785805644U,	// <7,5,3,3>: Cost 4 vext3 RHS, <5,3,3,1>
  3785805652U,	// <7,5,3,4>: Cost 4 vext3 RHS, <5,3,4,0>
  3785805661U,	// <7,5,3,5>: Cost 4 vext3 RHS, <5,3,5,0>
  3980414672U,	// <7,5,3,6>: Cost 4 vzipl <3,4,5,6>, <5,1,7,3>
  2712063856U,	// <7,5,3,7>: Cost 3 vext3 RHS, <5,3,7,1>
  2712063865U,	// <7,5,3,u>: Cost 3 vext3 RHS, <5,3,u,1>
  2591015014U,	// <7,5,4,0>: Cost 3 vext1 <6,7,5,4>, LHS
  2712211343U,	// <7,5,4,1>: Cost 3 vext3 RHS, <5,4,1,5>
  3785805718U,	// <7,5,4,2>: Cost 4 vext3 RHS, <5,4,2,3>
  3785805726U,	// <7,5,4,3>: Cost 4 vext3 RHS, <5,4,3,2>
  2591018294U,	// <7,5,4,4>: Cost 3 vext1 <6,7,5,4>, RHS
  2712063924U,	// <7,5,4,5>: Cost 3 vext3 RHS, <5,4,5,6>
  2846283110U,	// <7,5,4,6>: Cost 3 vuzpr RHS, <7,4,5,6>
  1638322118U,	// <7,5,4,7>: Cost 2 vext3 RHS, <5,4,7,6>
  1638469583U,	// <7,5,4,u>: Cost 2 vext3 RHS, <5,4,u,6>
  2591023206U,	// <7,5,5,0>: Cost 3 vext1 <6,7,5,5>, LHS
  2712063964U,	// <7,5,5,1>: Cost 3 vext3 RHS, <5,5,1,1>
  3785805799U,	// <7,5,5,2>: Cost 4 vext3 RHS, <5,5,2,3>
  2649657204U,	// <7,5,5,3>: Cost 3 vext2 <5,3,7,5>, <5,3,7,5>
  2712211450U,	// <7,5,5,4>: Cost 3 vext3 RHS, <5,5,4,4>
  1638322180U,	// <7,5,5,5>: Cost 2 vext3 RHS, <5,5,5,5>
  2712064014U,	// <7,5,5,6>: Cost 3 vext3 RHS, <5,5,6,6>
  1638469656U,	// <7,5,5,7>: Cost 2 vext3 RHS, <5,5,7,7>
  1638469665U,	// <7,5,5,u>: Cost 2 vext3 RHS, <5,5,u,7>
  2712064036U,	// <7,5,6,0>: Cost 3 vext3 RHS, <5,6,0,1>
  2712211507U,	// <7,5,6,1>: Cost 3 vext3 RHS, <5,6,1,7>
  3785805879U,	// <7,5,6,2>: Cost 4 vext3 RHS, <5,6,2,2>
  2712064066U,	// <7,5,6,3>: Cost 3 vext3 RHS, <5,6,3,4>
  2712064076U,	// <7,5,6,4>: Cost 3 vext3 RHS, <5,6,4,5>
  2712211543U,	// <7,5,6,5>: Cost 3 vext3 RHS, <5,6,5,7>
  2712211552U,	// <7,5,6,6>: Cost 3 vext3 RHS, <5,6,6,7>
  1638322274U,	// <7,5,6,7>: Cost 2 vext3 RHS, <5,6,7,0>
  1638469739U,	// <7,5,6,u>: Cost 2 vext3 RHS, <5,6,u,0>
  2712064118U,	// <7,5,7,0>: Cost 3 vext3 RHS, <5,7,0,2>
  3785805950U,	// <7,5,7,1>: Cost 4 vext3 RHS, <5,7,1,1>
  3785805958U,	// <7,5,7,2>: Cost 4 vext3 RHS, <5,7,2,0>
  3785805968U,	// <7,5,7,3>: Cost 4 vext3 RHS, <5,7,3,1>
  2712211614U,	// <7,5,7,4>: Cost 3 vext3 RHS, <5,7,4,6>
  2585071312U,	// <7,5,7,5>: Cost 3 vext1 <5,7,5,7>, <5,1,7,3>
  4060894828U,	// <7,5,7,6>: Cost 4 vzipr <5,6,7,0>, <7,7,7,7>
  3047609964U,	// <7,5,7,7>: Cost 3 vtrnl RHS, <7,7,7,7>
  3047618156U,	// <7,5,7,u>: Cost 3 vtrnl RHS, <7,7,7,7>
  2712064198U,	// <7,5,u,0>: Cost 3 vext3 RHS, <5,u,0,1>
  2712064208U,	// <7,5,u,1>: Cost 3 vext3 RHS, <5,u,1,2>
  2867189094U,	// <7,5,u,2>: Cost 3 vuzpr LHS, <7,4,5,6>
  2712064228U,	// <7,5,u,3>: Cost 3 vext3 RHS, <5,u,3,4>
  2712064233U,	// <7,5,u,4>: Cost 3 vext3 RHS, <5,u,4,0>
  1638322180U,	// <7,5,u,5>: Cost 2 vext3 RHS, <5,5,5,5>
  2712064254U,	// <7,5,u,6>: Cost 3 vext3 RHS, <5,u,6,3>
  1638322439U,	// <7,5,u,7>: Cost 2 vext3 RHS, <5,u,7,3>
  1638322448U,	// <7,5,u,u>: Cost 2 vext3 RHS, <5,u,u,3>
  2650324992U,	// <7,6,0,0>: Cost 3 vext2 <5,4,7,6>, <0,0,0,0>
  1576583270U,	// <7,6,0,1>: Cost 2 vext2 <5,4,7,6>, LHS
  2712064297U,	// <7,6,0,2>: Cost 3 vext3 RHS, <6,0,2,1>
  2255295336U,	// <7,6,0,3>: Cost 3 vrev <6,7,3,0>
  2650325330U,	// <7,6,0,4>: Cost 3 vext2 <5,4,7,6>, <0,4,1,5>
  2579115974U,	// <7,6,0,5>: Cost 3 vext1 <4,7,6,0>, <5,4,7,6>
  2735952204U,	// <7,6,0,6>: Cost 3 vext3 RHS, <6,0,6,0>
  2712064342U,	// <7,6,0,7>: Cost 3 vext3 RHS, <6,0,7,1>
  1576583837U,	// <7,6,0,u>: Cost 2 vext2 <5,4,7,6>, LHS
  1181340494U,	// <7,6,1,0>: Cost 2 vrev <6,7,0,1>
  2650325812U,	// <7,6,1,1>: Cost 3 vext2 <5,4,7,6>, <1,1,1,1>
  2712064380U,	// <7,6,1,2>: Cost 3 vext3 RHS, <6,1,2,3>
  3785806210U,	// <7,6,1,3>: Cost 4 vext3 RHS, <6,1,3,0>
  3785806219U,	// <7,6,1,4>: Cost 4 vext3 RHS, <6,1,4,0>
  2650326160U,	// <7,6,1,5>: Cost 3 vext2 <5,4,7,6>, <1,5,3,7>
  2735952288U,	// <7,6,1,6>: Cost 3 vext3 RHS, <6,1,6,3>
  2712064423U,	// <7,6,1,7>: Cost 3 vext3 RHS, <6,1,7,1>
  1181930390U,	// <7,6,1,u>: Cost 2 vrev <6,7,u,1>
  2712064441U,	// <7,6,2,0>: Cost 3 vext3 RHS, <6,2,0,1>
  2255164248U,	// <7,6,2,1>: Cost 3 vrev <6,7,1,2>
  2712064461U,	// <7,6,2,2>: Cost 3 vext3 RHS, <6,2,2,3>
  2650326694U,	// <7,6,2,3>: Cost 3 vext2 <5,4,7,6>, <2,3,0,1>
  2712064476U,	// <7,6,2,4>: Cost 3 vext3 RHS, <6,2,4,0>
  3785806310U,	// <7,6,2,5>: Cost 4 vext3 RHS, <6,2,5,1>
  2650326970U,	// <7,6,2,6>: Cost 3 vext2 <5,4,7,6>, <2,6,3,7>
  1638322682U,	// <7,6,2,7>: Cost 2 vext3 RHS, <6,2,7,3>
  1638322691U,	// <7,6,2,u>: Cost 2 vext3 RHS, <6,2,u,3>
  2650327190U,	// <7,6,3,0>: Cost 3 vext2 <5,4,7,6>, <3,0,1,2>
  3785806354U,	// <7,6,3,1>: Cost 4 vext3 RHS, <6,3,1,0>
  2255246178U,	// <7,6,3,2>: Cost 3 vrev <6,7,2,3>
  2650327452U,	// <7,6,3,3>: Cost 3 vext2 <5,4,7,6>, <3,3,3,3>
  2712064562U,	// <7,6,3,4>: Cost 3 vext3 RHS, <6,3,4,5>
  2650327627U,	// <7,6,3,5>: Cost 3 vext2 <5,4,7,6>, <3,5,4,7>
  3785806404U,	// <7,6,3,6>: Cost 4 vext3 RHS, <6,3,6,5>
  2712064584U,	// <7,6,3,7>: Cost 3 vext3 RHS, <6,3,7,0>
  2712064593U,	// <7,6,3,u>: Cost 3 vext3 RHS, <6,3,u,0>
  2650327954U,	// <7,6,4,0>: Cost 3 vext2 <5,4,7,6>, <4,0,5,1>
  3785806441U,	// <7,6,4,1>: Cost 4 vext3 RHS, <6,4,1,6>
  2712212081U,	// <7,6,4,2>: Cost 3 vext3 RHS, <6,4,2,5>
  2255328108U,	// <7,6,4,3>: Cost 3 vrev <6,7,3,4>
  2712212100U,	// <7,6,4,4>: Cost 3 vext3 RHS, <6,4,4,6>
  1576586550U,	// <7,6,4,5>: Cost 2 vext2 <5,4,7,6>, RHS
  2712212117U,	// <7,6,4,6>: Cost 3 vext3 RHS, <6,4,6,5>
  2712064670U,	// <7,6,4,7>: Cost 3 vext3 RHS, <6,4,7,5>
  1576586793U,	// <7,6,4,u>: Cost 2 vext2 <5,4,7,6>, RHS
  2712212146U,	// <7,6,5,0>: Cost 3 vext3 RHS, <6,5,0,7>
  2650328784U,	// <7,6,5,1>: Cost 3 vext2 <5,4,7,6>, <5,1,7,3>
  2712212164U,	// <7,6,5,2>: Cost 3 vext3 RHS, <6,5,2,7>
  3785806538U,	// <7,6,5,3>: Cost 4 vext3 RHS, <6,5,3,4>
  1576587206U,	// <7,6,5,4>: Cost 2 vext2 <5,4,7,6>, <5,4,7,6>
  2650329092U,	// <7,6,5,5>: Cost 3 vext2 <5,4,7,6>, <5,5,5,5>
  2712212200U,	// <7,6,5,6>: Cost 3 vext3 RHS, <6,5,6,7>
  2712064747U,	// <7,6,5,7>: Cost 3 vext3 RHS, <6,5,7,1>
  1181963162U,	// <7,6,5,u>: Cost 2 vrev <6,7,u,5>
  2591105126U,	// <7,6,6,0>: Cost 3 vext1 <6,7,6,6>, LHS
  3787797259U,	// <7,6,6,1>: Cost 4 vext3 RHS, <6,6,1,6>
  2712064784U,	// <7,6,6,2>: Cost 3 vext3 RHS, <6,6,2,2>
  3785806619U,	// <7,6,6,3>: Cost 4 vext3 RHS, <6,6,3,4>
  2712212260U,	// <7,6,6,4>: Cost 3 vext3 RHS, <6,6,4,4>
  2656965360U,	// <7,6,6,5>: Cost 3 vext2 <6,5,7,6>, <6,5,7,6>
  1638323000U,	// <7,6,6,6>: Cost 2 vext3 RHS, <6,6,6,6>
  1638470466U,	// <7,6,6,7>: Cost 2 vext3 RHS, <6,6,7,7>
  1638470475U,	// <7,6,6,u>: Cost 2 vext3 RHS, <6,6,u,7>
  1638323022U,	// <7,6,7,0>: Cost 2 vext3 RHS, <6,7,0,1>
  2712064854U,	// <7,6,7,1>: Cost 3 vext3 RHS, <6,7,1,0>
  2712064865U,	// <7,6,7,2>: Cost 3 vext3 RHS, <6,7,2,2>
  2712064872U,	// <7,6,7,3>: Cost 3 vext3 RHS, <6,7,3,0>
  1638323062U,	// <7,6,7,4>: Cost 2 vext3 RHS, <6,7,4,5>
  2712064891U,	// <7,6,7,5>: Cost 3 vext3 RHS, <6,7,5,1>
  2712064901U,	// <7,6,7,6>: Cost 3 vext3 RHS, <6,7,6,2>
  2712064915U,	// <7,6,7,7>: Cost 3 vext3 RHS, <6,7,7,7>
  1638323094U,	// <7,6,7,u>: Cost 2 vext3 RHS, <6,7,u,1>
  1638470559U,	// <7,6,u,0>: Cost 2 vext3 RHS, <6,u,0,1>
  1576589102U,	// <7,6,u,1>: Cost 2 vext2 <5,4,7,6>, LHS
  2712064947U,	// <7,6,u,2>: Cost 3 vext3 RHS, <6,u,2,3>
  2712212409U,	// <7,6,u,3>: Cost 3 vext3 RHS, <6,u,3,0>
  1638470599U,	// <7,6,u,4>: Cost 2 vext3 RHS, <6,u,4,5>
  1576589466U,	// <7,6,u,5>: Cost 2 vext2 <5,4,7,6>, RHS
  1638323000U,	// <7,6,u,6>: Cost 2 vext3 RHS, <6,6,6,6>
  1638323168U,	// <7,6,u,7>: Cost 2 vext3 RHS, <6,u,7,3>
  1638323177U,	// <7,6,u,u>: Cost 2 vext3 RHS, <6,u,u,3>
  2712065007U,	// <7,7,0,0>: Cost 3 vext3 RHS, <7,0,0,0>
  1638323194U,	// <7,7,0,1>: Cost 2 vext3 RHS, <7,0,1,2>
  2712065025U,	// <7,7,0,2>: Cost 3 vext3 RHS, <7,0,2,0>
  3785806859U,	// <7,7,0,3>: Cost 4 vext3 RHS, <7,0,3,1>
  2712212500U,	// <7,7,0,4>: Cost 3 vext3 RHS, <7,0,4,1>
  2585161907U,	// <7,7,0,5>: Cost 3 vext1 <5,7,7,0>, <5,7,7,0>
  2591134604U,	// <7,7,0,6>: Cost 3 vext1 <6,7,7,0>, <6,7,7,0>
  2591134714U,	// <7,7,0,7>: Cost 3 vext1 <6,7,7,0>, <7,0,1,2>
  1638323257U,	// <7,7,0,u>: Cost 2 vext3 RHS, <7,0,u,2>
  2712065091U,	// <7,7,1,0>: Cost 3 vext3 RHS, <7,1,0,3>
  2712065098U,	// <7,7,1,1>: Cost 3 vext3 RHS, <7,1,1,1>
  2712065109U,	// <7,7,1,2>: Cost 3 vext3 RHS, <7,1,2,3>
  3785806939U,	// <7,7,1,3>: Cost 4 vext3 RHS, <7,1,3,0>
  2712212586U,	// <7,7,1,4>: Cost 3 vext3 RHS, <7,1,4,6>
  2712212592U,	// <7,7,1,5>: Cost 3 vext3 RHS, <7,1,5,3>
  2657633505U,	// <7,7,1,6>: Cost 3 vext2 <6,6,7,7>, <1,6,3,7>
  2735953024U,	// <7,7,1,7>: Cost 3 vext3 RHS, <7,1,7,1>
  2712065163U,	// <7,7,1,u>: Cost 3 vext3 RHS, <7,1,u,3>
  3785806993U,	// <7,7,2,0>: Cost 4 vext3 RHS, <7,2,0,0>
  3785807002U,	// <7,7,2,1>: Cost 4 vext3 RHS, <7,2,1,0>
  2712065189U,	// <7,7,2,2>: Cost 3 vext3 RHS, <7,2,2,2>
  2712065196U,	// <7,7,2,3>: Cost 3 vext3 RHS, <7,2,3,0>
  3785807029U,	// <7,7,2,4>: Cost 4 vext3 RHS, <7,2,4,0>
  3785807041U,	// <7,7,2,5>: Cost 4 vext3 RHS, <7,2,5,3>
  2712212682U,	// <7,7,2,6>: Cost 3 vext3 RHS, <7,2,6,3>
  2735953107U,	// <7,7,2,7>: Cost 3 vext3 RHS, <7,2,7,3>
  2712065241U,	// <7,7,2,u>: Cost 3 vext3 RHS, <7,2,u,0>
  2712065251U,	// <7,7,3,0>: Cost 3 vext3 RHS, <7,3,0,1>
  3785807083U,	// <7,7,3,1>: Cost 4 vext3 RHS, <7,3,1,0>
  3785807092U,	// <7,7,3,2>: Cost 4 vext3 RHS, <7,3,2,0>
  2712065280U,	// <7,7,3,3>: Cost 3 vext3 RHS, <7,3,3,3>
  2712065291U,	// <7,7,3,4>: Cost 3 vext3 RHS, <7,3,4,5>
  2735953168U,	// <7,7,3,5>: Cost 3 vext3 RHS, <7,3,5,1>
  2735953178U,	// <7,7,3,6>: Cost 3 vext3 RHS, <7,3,6,2>
  2640382728U,	// <7,7,3,7>: Cost 3 vext2 <3,7,7,7>, <3,7,7,7>
  2712065323U,	// <7,7,3,u>: Cost 3 vext3 RHS, <7,3,u,1>
  2712065336U,	// <7,7,4,0>: Cost 3 vext3 RHS, <7,4,0,5>
  3785807166U,	// <7,7,4,1>: Cost 4 vext3 RHS, <7,4,1,2>
  3785807178U,	// <7,7,4,2>: Cost 4 vext3 RHS, <7,4,2,5>
  3785807187U,	// <7,7,4,3>: Cost 4 vext3 RHS, <7,4,3,5>
  2712065371U,	// <7,7,4,4>: Cost 3 vext3 RHS, <7,4,4,4>
  1638323558U,	// <7,7,4,5>: Cost 2 vext3 RHS, <7,4,5,6>
  2712065385U,	// <7,7,4,6>: Cost 3 vext3 RHS, <7,4,6,0>
  2712212855U,	// <7,7,4,7>: Cost 3 vext3 RHS, <7,4,7,5>
  1638323585U,	// <7,7,4,u>: Cost 2 vext3 RHS, <7,4,u,6>
  2585198694U,	// <7,7,5,0>: Cost 3 vext1 <5,7,7,5>, LHS
  2712065428U,	// <7,7,5,1>: Cost 3 vext3 RHS, <7,5,1,7>
  3785807255U,	// <7,7,5,2>: Cost 4 vext3 RHS, <7,5,2,1>
  3785807264U,	// <7,7,5,3>: Cost 4 vext3 RHS, <7,5,3,1>
  2712065455U,	// <7,7,5,4>: Cost 3 vext3 RHS, <7,5,4,7>
  1577259032U,	// <7,7,5,5>: Cost 2 vext2 <5,5,7,7>, <5,5,7,7>
  2712065473U,	// <7,7,5,6>: Cost 3 vext3 RHS, <7,5,6,7>
  2712212938U,	// <7,7,5,7>: Cost 3 vext3 RHS, <7,5,7,7>
  1577259032U,	// <7,7,5,u>: Cost 2 vext2 <5,5,7,7>, <5,5,7,7>
  2591178854U,	// <7,7,6,0>: Cost 3 vext1 <6,7,7,6>, LHS
  2735953374U,	// <7,7,6,1>: Cost 3 vext3 RHS, <7,6,1,0>
  2712065518U,	// <7,7,6,2>: Cost 3 vext3 RHS, <7,6,2,7>
  2655646287U,	// <7,7,6,3>: Cost 3 vext2 <6,3,7,7>, <6,3,7,7>
  2591182134U,	// <7,7,6,4>: Cost 3 vext1 <6,7,7,6>, RHS
  2656973553U,	// <7,7,6,5>: Cost 3 vext2 <6,5,7,7>, <6,5,7,7>
  1583895362U,	// <7,7,6,6>: Cost 2 vext2 <6,6,7,7>, <6,6,7,7>
  2712065556U,	// <7,7,6,7>: Cost 3 vext3 RHS, <7,6,7,0>
  1583895362U,	// <7,7,6,u>: Cost 2 vext2 <6,6,7,7>, <6,6,7,7>
  1523417190U,	// <7,7,7,0>: Cost 2 vext1 <7,7,7,7>, LHS
  2597159670U,	// <7,7,7,1>: Cost 3 vext1 <7,7,7,7>, <1,0,3,2>
  2597160552U,	// <7,7,7,2>: Cost 3 vext1 <7,7,7,7>, <2,2,2,2>
  2597161110U,	// <7,7,7,3>: Cost 3 vext1 <7,7,7,7>, <3,0,1,2>
  1523420470U,	// <7,7,7,4>: Cost 2 vext1 <7,7,7,7>, RHS
  2651002296U,	// <7,7,7,5>: Cost 3 vext2 <5,5,7,7>, <7,5,5,7>
  2657637906U,	// <7,7,7,6>: Cost 3 vext2 <6,6,7,7>, <7,6,6,7>
  363253046U,	// <7,7,7,7>: Cost 1 vdup3 RHS
  363253046U,	// <7,7,7,u>: Cost 1 vdup3 RHS
  1523417190U,	// <7,7,u,0>: Cost 2 vext1 <7,7,7,7>, LHS
  1638471298U,	// <7,7,u,1>: Cost 2 vext3 RHS, <7,u,1,2>
  2712213129U,	// <7,7,u,2>: Cost 3 vext3 RHS, <7,u,2,0>
  2712065685U,	// <7,7,u,3>: Cost 3 vext3 RHS, <7,u,3,3>
  1523420470U,	// <7,7,u,4>: Cost 2 vext1 <7,7,7,7>, RHS
  1638471338U,	// <7,7,u,5>: Cost 2 vext3 RHS, <7,u,5,6>
  1595840756U,	// <7,7,u,6>: Cost 2 vext2 <u,6,7,7>, <u,6,7,7>
  363253046U,	// <7,7,u,7>: Cost 1 vdup3 RHS
  363253046U,	// <7,7,u,u>: Cost 1 vdup3 RHS
  1638318080U,	// <7,u,0,0>: Cost 2 vext3 RHS, <0,0,0,0>
  1638323922U,	// <7,u,0,1>: Cost 2 vext3 RHS, <u,0,1,1>
  1638323932U,	// <7,u,0,2>: Cost 2 vext3 RHS, <u,0,2,2>
  1638323941U,	// <7,u,0,3>: Cost 2 vext3 RHS, <u,0,3,2>
  2712065773U,	// <7,u,0,4>: Cost 3 vext3 RHS, <u,0,4,1>
  1638323958U,	// <7,u,0,5>: Cost 2 vext3 RHS, <u,0,5,1>
  1638323968U,	// <7,u,0,6>: Cost 2 vext3 RHS, <u,0,6,2>
  2712065800U,	// <7,u,0,7>: Cost 3 vext3 RHS, <u,0,7,1>
  1638323985U,	// <7,u,0,u>: Cost 2 vext3 RHS, <u,0,u,1>
  1517469798U,	// <7,u,1,0>: Cost 2 vext1 <6,7,u,1>, LHS
  1638318900U,	// <7,u,1,1>: Cost 2 vext3 RHS, <1,1,1,1>
  564582190U,	// <7,u,1,2>: Cost 1 vext3 RHS, LHS
  1638324023U,	// <7,u,1,3>: Cost 2 vext3 RHS, <u,1,3,3>
  1517473078U,	// <7,u,1,4>: Cost 2 vext1 <6,7,u,1>, RHS
  2712065862U,	// <7,u,1,5>: Cost 3 vext3 RHS, <u,1,5,0>
  1517474710U,	// <7,u,1,6>: Cost 2 vext1 <6,7,u,1>, <6,7,u,1>
  1638324059U,	// <7,u,1,7>: Cost 2 vext3 RHS, <u,1,7,3>
  564582244U,	// <7,u,1,u>: Cost 1 vext3 RHS, LHS
  1638324076U,	// <7,u,2,0>: Cost 2 vext3 RHS, <u,2,0,2>
  2712065907U,	// <7,u,2,1>: Cost 3 vext3 RHS, <u,2,1,0>
  1638319720U,	// <7,u,2,2>: Cost 2 vext3 RHS, <2,2,2,2>
  1638324101U,	// <7,u,2,3>: Cost 2 vext3 RHS, <u,2,3,0>
  1638471572U,	// <7,u,2,4>: Cost 2 vext3 RHS, <u,2,4,6>
  2712065945U,	// <7,u,2,5>: Cost 3 vext3 RHS, <u,2,5,2>
  2712065952U,	// <7,u,2,6>: Cost 3 vext3 RHS, <u,2,6,0>
  1638324140U,	// <7,u,2,7>: Cost 2 vext3 RHS, <u,2,7,3>
  1638324146U,	// <7,u,2,u>: Cost 2 vext3 RHS, <u,2,u,0>
  1638324156U,	// <7,u,3,0>: Cost 2 vext3 RHS, <u,3,0,1>
  2712065988U,	// <7,u,3,1>: Cost 3 vext3 RHS, <u,3,1,0>
  2712065998U,	// <7,u,3,2>: Cost 3 vext3 RHS, <u,3,2,1>
  1638320540U,	// <7,u,3,3>: Cost 2 vext3 RHS, <3,3,3,3>
  1638324196U,	// <7,u,3,4>: Cost 2 vext3 RHS, <u,3,4,5>
  2712066025U,	// <7,u,3,5>: Cost 3 vext3 RHS, <u,3,5,1>
  2712066035U,	// <7,u,3,6>: Cost 3 vext3 RHS, <u,3,6,2>
  2712066042U,	// <7,u,3,7>: Cost 3 vext3 RHS, <u,3,7,0>
  1638324228U,	// <7,u,3,u>: Cost 2 vext3 RHS, <u,3,u,1>
  2712066061U,	// <7,u,4,0>: Cost 3 vext3 RHS, <u,4,0,1>
  1638471706U,	// <7,u,4,1>: Cost 2 vext3 RHS, <u,4,1,5>
  1638471716U,	// <7,u,4,2>: Cost 2 vext3 RHS, <u,4,2,6>
  2712066092U,	// <7,u,4,3>: Cost 3 vext3 RHS, <u,4,3,5>
  1638321360U,	// <7,u,4,4>: Cost 2 vext3 RHS, <4,4,4,4>
  1638324287U,	// <7,u,4,5>: Cost 2 vext3 RHS, <u,4,5,6>
  1638471752U,	// <7,u,4,6>: Cost 2 vext3 RHS, <u,4,6,6>
  1640314961U,	// <7,u,4,7>: Cost 2 vext3 RHS, <u,4,7,6>
  1638324314U,	// <7,u,4,u>: Cost 2 vext3 RHS, <u,4,u,6>
  1517502566U,	// <7,u,5,0>: Cost 2 vext1 <6,7,u,5>, LHS
  1574612693U,	// <7,u,5,1>: Cost 2 vext2 <5,1,7,u>, <5,1,7,u>
  2712066162U,	// <7,u,5,2>: Cost 3 vext3 RHS, <u,5,2,3>
  1638471807U,	// <7,u,5,3>: Cost 2 vext3 RHS, <u,5,3,7>
  1576603592U,	// <7,u,5,4>: Cost 2 vext2 <5,4,7,u>, <5,4,7,u>
  1577267225U,	// <7,u,5,5>: Cost 2 vext2 <5,5,7,u>, <5,5,7,u>
  564582554U,	// <7,u,5,6>: Cost 1 vext3 RHS, RHS
  1638471843U,	// <7,u,5,7>: Cost 2 vext3 RHS, <u,5,7,7>
  564582572U,	// <7,u,5,u>: Cost 1 vext3 RHS, RHS
  1638324400U,	// <7,u,6,0>: Cost 2 vext3 RHS, <u,6,0,2>
  2712066232U,	// <7,u,6,1>: Cost 3 vext3 RHS, <u,6,1,1>
  1581249023U,	// <7,u,6,2>: Cost 2 vext2 <6,2,7,u>, <6,2,7,u>
  1638471888U,	// <7,u,6,3>: Cost 2 vext3 RHS, <u,6,3,7>
  1638471896U,	// <7,u,6,4>: Cost 2 vext3 RHS, <u,6,4,6>
  2712213730U,	// <7,u,6,5>: Cost 3 vext3 RHS, <u,6,5,7>
  1583903555U,	// <7,u,6,6>: Cost 2 vext2 <6,6,7,u>, <6,6,7,u>
  1638471924U,	// <7,u,6,7>: Cost 2 vext3 RHS, <u,6,7,7>
  1640462582U,	// <7,u,6,u>: Cost 2 vext3 RHS, <u,6,u,0>
  1638471936U,	// <7,u,7,0>: Cost 2 vext3 RHS, <u,7,0,1>
  2712213768U,	// <7,u,7,1>: Cost 3 vext3 RHS, <u,7,1,0>
  2712213779U,	// <7,u,7,2>: Cost 3 vext3 RHS, <u,7,2,2>
  2712213786U,	// <7,u,7,3>: Cost 3 vext3 RHS, <u,7,3,0>
  1638471976U,	// <7,u,7,4>: Cost 2 vext3 RHS, <u,7,4,5>
  2712213805U,	// <7,u,7,5>: Cost 3 vext3 RHS, <u,7,5,1>
  2712213815U,	// <7,u,7,6>: Cost 3 vext3 RHS, <u,7,6,2>
  363253046U,	// <7,u,7,7>: Cost 1 vdup3 RHS
  363253046U,	// <7,u,7,u>: Cost 1 vdup3 RHS
  1638324561U,	// <7,u,u,0>: Cost 2 vext3 RHS, <u,u,0,1>
  1638324571U,	// <7,u,u,1>: Cost 2 vext3 RHS, <u,u,1,2>
  564582757U,	// <7,u,u,2>: Cost 1 vext3 RHS, LHS
  1638324587U,	// <7,u,u,3>: Cost 2 vext3 RHS, <u,u,3,0>
  1638324601U,	// <7,u,u,4>: Cost 2 vext3 RHS, <u,u,4,5>
  1638324611U,	// <7,u,u,5>: Cost 2 vext3 RHS, <u,u,5,6>
  564582797U,	// <7,u,u,6>: Cost 1 vext3 RHS, RHS
  363253046U,	// <7,u,u,7>: Cost 1 vdup3 RHS
  564582811U,	// <7,u,u,u>: Cost 1 vext3 RHS, LHS
  135053414U,	// <u,0,0,0>: Cost 1 vdup0 LHS
  1611489290U,	// <u,0,0,1>: Cost 2 vext3 LHS, <0,0,1,1>
  1611489300U,	// <u,0,0,2>: Cost 2 vext3 LHS, <0,0,2,2>
  2568054923U,	// <u,0,0,3>: Cost 3 vext1 <3,0,0,0>, <3,0,0,0>
  1481706806U,	// <u,0,0,4>: Cost 2 vext1 <0,u,0,0>, RHS
  2621153757U,	// <u,0,0,5>: Cost 3 vext2 <0,5,u,0>, <0,5,u,0>
  2591282078U,	// <u,0,0,6>: Cost 3 vext1 <6,u,0,0>, <6,u,0,0>
  2591945711U,	// <u,0,0,7>: Cost 3 vext1 <7,0,0,0>, <7,0,0,0>
  135053414U,	// <u,0,0,u>: Cost 1 vdup0 LHS
  1493655654U,	// <u,0,1,0>: Cost 2 vext1 <2,u,0,1>, LHS
  1879889710U,	// <u,0,1,1>: Cost 2 vzipr LHS, LHS
  537747563U,	// <u,0,1,2>: Cost 1 vext3 LHS, LHS
  2625799188U,	// <u,0,1,3>: Cost 3 vext2 <1,3,u,0>, <1,3,u,0>
  1493658934U,	// <u,0,1,4>: Cost 2 vext1 <2,u,0,1>, RHS
  2567401168U,	// <u,0,1,5>: Cost 3 vext1 <2,u,0,1>, <5,1,7,3>
  1517548447U,	// <u,0,1,6>: Cost 2 vext1 <6,u,0,1>, <6,u,0,1>
  2591290362U,	// <u,0,1,7>: Cost 3 vext1 <6,u,0,1>, <7,0,1,2>
  537747612U,	// <u,0,1,u>: Cost 1 vext3 LHS, LHS
  1611489444U,	// <u,0,2,0>: Cost 2 vext3 LHS, <0,2,0,2>
  2953631596U,	// <u,0,2,1>: Cost 3 vzipr LHS, <u,2,0,2>
  2014107438U,	// <u,0,2,2>: Cost 2 vtrnr LHS, LHS
  2555463830U,	// <u,0,2,3>: Cost 3 vext1 <0,u,0,2>, <3,0,1,2>
  1481723190U,	// <u,0,2,4>: Cost 2 vext1 <0,u,0,2>, RHS
  2555465424U,	// <u,0,2,5>: Cost 3 vext1 <0,u,0,2>, <5,1,7,3>
  2555466234U,	// <u,0,2,6>: Cost 3 vext1 <0,u,0,2>, <6,2,7,3>
  2579354618U,	// <u,0,2,7>: Cost 3 vext1 <4,u,0,2>, <7,0,1,2>
  2014549806U,	// <u,0,2,u>: Cost 2 vtrnr LHS, LHS
  2555469824U,	// <u,0,3,0>: Cost 3 vext1 <0,u,0,3>, <0,0,0,0>
  2954074044U,	// <u,0,3,1>: Cost 3 vzipr LHS, <u,3,0,1>
  72589981U,	// <u,0,3,2>: Cost 1 vrev LHS
  2625137052U,	// <u,0,3,3>: Cost 3 vext2 <1,2,u,0>, <3,3,3,3>
  2555473206U,	// <u,0,3,4>: Cost 3 vext1 <0,u,0,3>, RHS
  2651679326U,	// <u,0,3,5>: Cost 3 vext2 <5,6,u,0>, <3,5,6,u>
  2639735481U,	// <u,0,3,6>: Cost 3 vext2 <3,6,u,0>, <3,6,u,0>
  2597279354U,	// <u,0,3,7>: Cost 3 vext1 <7,u,0,3>, <7,u,0,3>
  73032403U,	// <u,0,3,u>: Cost 1 vrev LHS
  2625137554U,	// <u,0,4,0>: Cost 3 vext2 <1,2,u,0>, <4,0,5,1>
  1638326610U,	// <u,0,4,1>: Cost 2 vext3 RHS, <0,4,1,5>
  1638326620U,	// <u,0,4,2>: Cost 2 vext3 RHS, <0,4,2,6>
  3293897383U,	// <u,0,4,3>: Cost 4 vrev <0,u,3,4>
  2567425334U,	// <u,0,4,4>: Cost 3 vext1 <2,u,0,4>, RHS
  1551396150U,	// <u,0,4,5>: Cost 2 vext2 <1,2,u,0>, RHS
  2625137996U,	// <u,0,4,6>: Cost 3 vext2 <1,2,u,0>, <4,6,0,2>
  2646371811U,	// <u,0,4,7>: Cost 3 vext2 <4,7,u,0>, <4,7,u,0>
  1551396393U,	// <u,0,4,u>: Cost 2 vext2 <1,2,u,0>, RHS
  2573402214U,	// <u,0,5,0>: Cost 3 vext1 <3,u,0,5>, LHS
  1879890074U,	// <u,0,5,1>: Cost 2 vzipr LHS, RHS
  3087849206U,	// <u,0,5,2>: Cost 3 vtrnr LHS, <u,0,5,1>
  2573404952U,	// <u,0,5,3>: Cost 3 vext1 <3,u,0,5>, <3,u,0,5>
  2220237489U,	// <u,0,5,4>: Cost 3 vrev <0,u,4,5>
  2651680772U,	// <u,0,5,5>: Cost 3 vext2 <5,6,u,0>, <5,5,5,5>
  1577939051U,	// <u,0,5,6>: Cost 2 vext2 <5,6,u,0>, <5,6,u,0>
  2652344508U,	// <u,0,5,7>: Cost 3 vext2 <5,7,u,0>, <5,7,u,0>
  1884534938U,	// <u,0,5,u>: Cost 2 vzipr LHS, RHS
  3088357530U,	// <u,0,6,0>: Cost 3 vtrnr <0,2,0,2>, RHS
  2953631920U,	// <u,0,6,1>: Cost 3 vzipr LHS, <u,6,0,2>
  2014107802U,	// <u,0,6,2>: Cost 2 vtrnr LHS, RHS
  2573413145U,	// <u,0,6,3>: Cost 3 vext1 <3,u,0,6>, <3,u,0,6>
  2573413686U,	// <u,0,6,4>: Cost 3 vext1 <3,u,0,6>, RHS
  2651681459U,	// <u,0,6,5>: Cost 3 vext2 <5,6,u,0>, <6,5,0,u>
  2651681592U,	// <u,0,6,6>: Cost 3 vext2 <5,6,u,0>, <6,6,6,6>
  2651681614U,	// <u,0,6,7>: Cost 3 vext2 <5,6,u,0>, <6,7,0,1>
  2014550170U,	// <u,0,6,u>: Cost 2 vtrnr LHS, RHS
  2651681786U,	// <u,0,7,0>: Cost 3 vext2 <5,6,u,0>, <7,0,1,2>
  2899627336U,	// <u,0,7,1>: Cost 3 vzipl <2,3,0,1>, RHS
  3087849307U,	// <u,0,7,2>: Cost 3 vtrnr LHS, <u,1,7,3>
  3960778056U,	// <u,0,7,3>: Cost 4 vzipl <0,2,0,3>, RHS
  2651682150U,	// <u,0,7,4>: Cost 3 vext2 <5,6,u,0>, <7,4,5,6>
  2651682242U,	// <u,0,7,5>: Cost 3 vext2 <5,6,u,0>, <7,5,6,u>
  2591339429U,	// <u,0,7,6>: Cost 3 vext1 <6,u,0,7>, <6,u,0,7>
  2651682412U,	// <u,0,7,7>: Cost 3 vext2 <5,6,u,0>, <7,7,7,7>
  3088291675U,	// <u,0,7,u>: Cost 3 vtrnr LHS, <u,1,7,3>
  135053414U,	// <u,0,u,0>: Cost 1 vdup0 LHS
  1879890277U,	// <u,0,u,1>: Cost 2 vzipr LHS, LHS
  537748125U,	// <u,0,u,2>: Cost 1 vext3 LHS, LHS
  2555512982U,	// <u,0,u,3>: Cost 3 vext1 <0,u,0,u>, <3,0,1,2>
  1481772342U,	// <u,0,u,4>: Cost 2 vext1 <0,u,0,u>, RHS
  1551399066U,	// <u,0,u,5>: Cost 2 vext2 <1,2,u,0>, RHS
  1517605798U,	// <u,0,u,6>: Cost 2 vext1 <6,u,0,u>, <6,u,0,u>
  2579403770U,	// <u,0,u,7>: Cost 3 vext1 <4,u,0,u>, <7,0,1,2>
  537748179U,	// <u,0,u,u>: Cost 1 vext3 LHS, LHS
  1544101961U,	// <u,1,0,0>: Cost 2 vext2 <0,0,u,1>, <0,0,u,1>
  1558036582U,	// <u,1,0,1>: Cost 2 vext2 <2,3,u,1>, LHS
  2685231852U,	// <u,1,0,2>: Cost 3 vext3 LHS, <1,0,2,1>
  1611490038U,	// <u,1,0,3>: Cost 2 vext3 LHS, <1,0,3,2>
  2567466294U,	// <u,1,0,4>: Cost 3 vext1 <2,u,1,0>, RHS
  2641510814U,	// <u,1,0,5>: Cost 3 vext2 <4,0,5,1>, <0,5,1,0>
  2591355815U,	// <u,1,0,6>: Cost 3 vext1 <6,u,1,0>, <6,u,1,0>
  2597328512U,	// <u,1,0,7>: Cost 3 vext1 <7,u,1,0>, <7,u,1,0>
  1611490083U,	// <u,1,0,u>: Cost 2 vext3 LHS, <1,0,u,2>
  1524252774U,	// <u,1,1,0>: Cost 2 vext1 <u,0,1,1>, LHS
  202162278U,	// <u,1,1,1>: Cost 1 vdup1 LHS
  2960316206U,	// <u,1,1,2>: Cost 3 vzipr <1,2,3,0>, LHS
  1611490120U,	// <u,1,1,3>: Cost 2 vext3 LHS, <1,1,3,3>
  1524256054U,	// <u,1,1,4>: Cost 2 vext1 <u,0,1,1>, RHS
  2658321552U,	// <u,1,1,5>: Cost 3 vext2 <6,7,u,1>, <1,5,3,7>
  2591364008U,	// <u,1,1,6>: Cost 3 vext1 <6,u,1,1>, <6,u,1,1>
  2597999610U,	// <u,1,1,7>: Cost 3 vext1 <u,0,1,1>, <7,0,1,2>
  202162278U,	// <u,1,1,u>: Cost 1 vdup1 LHS
  1499709542U,	// <u,1,2,0>: Cost 2 vext1 <3,u,1,2>, LHS
  2685232007U,	// <u,1,2,1>: Cost 3 vext3 LHS, <1,2,1,3>
  2685232016U,	// <u,1,2,2>: Cost 3 vext3 LHS, <1,2,2,3>
  835584U,	// <u,1,2,3>: Cost 0 copy LHS
  1499712822U,	// <u,1,2,4>: Cost 2 vext1 <3,u,1,2>, RHS
  2573455056U,	// <u,1,2,5>: Cost 3 vext1 <3,u,1,2>, <5,1,7,3>
  2573455866U,	// <u,1,2,6>: Cost 3 vext1 <3,u,1,2>, <6,2,7,3>
  1523603074U,	// <u,1,2,7>: Cost 2 vext1 <7,u,1,2>, <7,u,1,2>
  835584U,	// <u,1,2,u>: Cost 0 copy LHS
  2685232078U,	// <u,1,3,0>: Cost 3 vext3 LHS, <1,3,0,2>
  2892398748U,	// <u,1,3,1>: Cost 3 vzipl <1,1,1,1>, LHS
  2555545254U,	// <u,1,3,2>: Cost 3 vext1 <0,u,1,3>, <2,3,0,1>
  1946993309U,	// <u,1,3,3>: Cost 2 vtrnl LHS, LHS
  2555546934U,	// <u,1,3,4>: Cost 3 vext1 <0,u,1,3>, RHS
  2585407697U,	// <u,1,3,5>: Cost 3 vext1 <5,u,1,3>, <5,u,1,3>
  2658323128U,	// <u,1,3,6>: Cost 3 vext2 <6,7,u,1>, <3,6,7,u>
  2597353091U,	// <u,1,3,7>: Cost 3 vext1 <7,u,1,3>, <7,u,1,3>
  1947034269U,	// <u,1,3,u>: Cost 2 vtrnl LHS, LHS
  1567992749U,	// <u,1,4,0>: Cost 2 vext2 <4,0,u,1>, <4,0,u,1>
  2642398206U,	// <u,1,4,1>: Cost 3 vext2 <4,1,u,1>, <4,1,u,1>
  2573469422U,	// <u,1,4,2>: Cost 3 vext1 <3,u,1,4>, <2,3,u,1>
  1152386432U,	// <u,1,4,3>: Cost 2 vrev <1,u,3,4>
  2573471030U,	// <u,1,4,4>: Cost 3 vext1 <3,u,1,4>, RHS
  1558039862U,	// <u,1,4,5>: Cost 2 vext2 <2,3,u,1>, RHS
  2631781708U,	// <u,1,4,6>: Cost 3 vext2 <2,3,u,1>, <4,6,0,2>
  2597361284U,	// <u,1,4,7>: Cost 3 vext1 <7,u,1,4>, <7,u,1,4>
  1152755117U,	// <u,1,4,u>: Cost 2 vrev <1,u,u,4>
  1526939750U,	// <u,1,5,0>: Cost 2 vext1 <u,4,1,5>, LHS
  2959513754U,	// <u,1,5,1>: Cost 3 vzipr <1,1,1,1>, RHS
  2960316570U,	// <u,1,5,2>: Cost 3 vzipr <1,2,3,0>, RHS
  1638327440U,	// <u,1,5,3>: Cost 2 vext3 RHS, <1,5,3,7>
  1526943030U,	// <u,1,5,4>: Cost 2 vext1 <u,4,1,5>, RHS
  2651025435U,	// <u,1,5,5>: Cost 3 vext2 <5,5,u,1>, <5,5,u,1>
  2651689068U,	// <u,1,5,6>: Cost 3 vext2 <5,6,u,1>, <5,6,u,1>
  2600686586U,	// <u,1,5,7>: Cost 3 vext1 <u,4,1,5>, <7,0,1,2>
  1638327485U,	// <u,1,5,u>: Cost 2 vext3 RHS, <1,5,u,7>
  2653679967U,	// <u,1,6,0>: Cost 3 vext2 <6,0,u,1>, <6,0,u,1>
  3093731482U,	// <u,1,6,1>: Cost 3 vtrnr <1,1,1,1>, RHS
  2631782906U,	// <u,1,6,2>: Cost 3 vext2 <2,3,u,1>, <6,2,7,3>
  3020737350U,	// <u,1,6,3>: Cost 3 vtrnl LHS, <3,u,5,6>
  2597375286U,	// <u,1,6,4>: Cost 3 vext1 <7,u,1,6>, RHS
  2226292116U,	// <u,1,6,5>: Cost 3 vrev <1,u,5,6>
  2657661765U,	// <u,1,6,6>: Cost 3 vext2 <6,6,u,1>, <6,6,u,1>
  1584583574U,	// <u,1,6,7>: Cost 2 vext2 <6,7,u,1>, <6,7,u,1>
  1585247207U,	// <u,1,6,u>: Cost 2 vext2 <6,u,u,1>, <6,u,u,1>
  2573492326U,	// <u,1,7,0>: Cost 3 vext1 <3,u,1,7>, LHS
  2892401992U,	// <u,1,7,1>: Cost 3 vzipl <1,1,1,1>, RHS
  2903690568U,	// <u,1,7,2>: Cost 3 vzipl <3,0,1,2>, RHS
  1946996265U,	// <u,1,7,3>: Cost 2 vtrnl LHS, RHS
  2573495606U,	// <u,1,7,4>: Cost 3 vext1 <3,u,1,7>, RHS
  2936229192U,	// <u,1,7,5>: Cost 3 vzipl <u,4,1,5>, RHS
  2658325990U,	// <u,1,7,6>: Cost 3 vext2 <6,7,u,1>, <7,6,1,u>
  2658326124U,	// <u,1,7,7>: Cost 3 vext2 <6,7,u,1>, <7,7,7,7>
  1947037225U,	// <u,1,7,u>: Cost 2 vtrnl LHS, RHS
  1499758694U,	// <u,1,u,0>: Cost 2 vext1 <3,u,1,u>, LHS
  202162278U,	// <u,1,u,1>: Cost 1 vdup1 LHS
  2685674870U,	// <u,1,u,2>: Cost 3 vext3 LHS, <1,u,2,3>
  835584U,	// <u,1,u,3>: Cost 0 copy LHS
  1499761974U,	// <u,1,u,4>: Cost 2 vext1 <3,u,1,u>, RHS
  1558042778U,	// <u,1,u,5>: Cost 2 vext2 <2,3,u,1>, RHS
  2631784624U,	// <u,1,u,6>: Cost 3 vext2 <2,3,u,1>, <u,6,0,2>
  1523652232U,	// <u,1,u,7>: Cost 2 vext1 <7,u,1,u>, <7,u,1,u>
  835584U,	// <u,1,u,u>: Cost 0 copy LHS
  1544110154U,	// <u,2,0,0>: Cost 2 vext2 <0,0,u,2>, <0,0,u,2>
  1550082150U,	// <u,2,0,1>: Cost 2 vext2 <1,0,u,2>, LHS
  1745671982U,	// <u,2,0,2>: Cost 2 vuzpr LHS, LHS
  2685232590U,	// <u,2,0,3>: Cost 3 vext3 LHS, <2,0,3,1>
  2685232600U,	// <u,2,0,4>: Cost 3 vext3 LHS, <2,0,4,2>
  2617409966U,	// <u,2,0,5>: Cost 3 vext2 <0,0,2,2>, <0,5,2,7>
  2586120488U,	// <u,2,0,6>: Cost 3 vext1 <6,0,2,0>, <6,0,2,0>
  2659656273U,	// <u,2,0,7>: Cost 3 vext2 <7,0,u,2>, <0,7,2,u>
  1746114350U,	// <u,2,0,u>: Cost 2 vuzpr LHS, LHS
  1550082851U,	// <u,2,1,0>: Cost 2 vext2 <1,0,u,2>, <1,0,u,2>
  2623824692U,	// <u,2,1,1>: Cost 3 vext2 <1,0,u,2>, <1,1,1,1>
  2685232664U,	// <u,2,1,2>: Cost 3 vext3 LHS, <2,1,2,3>
  2886518510U,	// <u,2,1,3>: Cost 3 vzipl LHS, <2,3,u,1>
  2685232682U,	// <u,2,1,4>: Cost 3 vext3 LHS, <2,1,4,3>
  2232223848U,	// <u,2,1,5>: Cost 3 vrev <2,u,5,1>
  2733008444U,	// <u,2,1,6>: Cost 3 vext3 LHS, <2,1,6,3>
  2602718850U,	// <u,2,1,7>: Cost 3 vext1 <u,7,2,1>, <7,u,1,2>
  1158703235U,	// <u,2,1,u>: Cost 2 vrev <2,u,u,1>
  1524334694U,	// <u,2,2,0>: Cost 2 vext1 <u,0,2,2>, LHS
  2231937093U,	// <u,2,2,1>: Cost 3 vrev <2,u,1,2>
  269271142U,	// <u,2,2,2>: Cost 1 vdup2 LHS
  1611490930U,	// <u,2,2,3>: Cost 2 vext3 LHS, <2,2,3,3>
  1524337974U,	// <u,2,2,4>: Cost 2 vext1 <u,0,2,2>, RHS
  2598080208U,	// <u,2,2,5>: Cost 3 vext1 <u,0,2,2>, <5,1,7,3>
  2232305778U,	// <u,2,2,6>: Cost 3 vrev <2,u,6,2>
  2598081530U,	// <u,2,2,7>: Cost 3 vext1 <u,0,2,2>, <7,0,1,2>
  269271142U,	// <u,2,2,u>: Cost 1 vdup2 LHS
  408134301U,	// <u,2,3,0>: Cost 1 vext1 LHS, LHS
  1481876214U,	// <u,2,3,1>: Cost 2 vext1 LHS, <1,0,3,2>
  1481877096U,	// <u,2,3,2>: Cost 2 vext1 LHS, <2,2,2,2>
  1812775068U,	// <u,2,3,3>: Cost 2 vzipl LHS, LHS
  408137014U,	// <u,2,3,4>: Cost 1 vext1 LHS, RHS
  1481879248U,	// <u,2,3,5>: Cost 2 vext1 LHS, <5,1,7,3>
  1481880058U,	// <u,2,3,6>: Cost 2 vext1 LHS, <6,2,7,3>
  1529656314U,	// <u,2,3,7>: Cost 2 vext1 LHS, <7,0,1,2>
  408139566U,	// <u,2,3,u>: Cost 1 vext1 LHS, LHS
  1568000942U,	// <u,2,4,0>: Cost 2 vext2 <4,0,u,2>, <4,0,u,2>
  2642406399U,	// <u,2,4,1>: Cost 3 vext2 <4,1,u,2>, <4,1,u,2>
  2643070032U,	// <u,2,4,2>: Cost 3 vext2 <4,2,u,2>, <4,2,u,2>
  2891162567U,	// <u,2,4,3>: Cost 3 vzipl LHS, <1,2,u,4>
  2232174690U,	// <u,2,4,4>: Cost 3 vrev <2,u,4,4>
  1550085430U,	// <u,2,4,5>: Cost 2 vext2 <1,0,u,2>, RHS
  1772541742U,	// <u,2,4,6>: Cost 2 vuzpr RHS, LHS
  2597435021U,	// <u,2,4,7>: Cost 3 vext1 <7,u,2,4>, <7,u,2,4>
  1550085673U,	// <u,2,4,u>: Cost 2 vext2 <1,0,u,2>, RHS
  2712069966U,	// <u,2,5,0>: Cost 3 vext3 RHS, <2,5,0,7>
  2623827664U,	// <u,2,5,1>: Cost 3 vext2 <1,0,u,2>, <5,1,7,3>
  2966231194U,	// <u,2,5,2>: Cost 3 vzipr <2,2,2,2>, RHS
  2886518514U,	// <u,2,5,3>: Cost 3 vzipl LHS, <2,3,u,5>
  1158441059U,	// <u,2,5,4>: Cost 2 vrev <2,u,4,5>
  2852165422U,	// <u,2,5,5>: Cost 3 vuzpr <5,5,5,5>, LHS
  2712070020U,	// <u,2,5,6>: Cost 3 vext3 RHS, <2,5,6,7>
  2849642286U,	// <u,2,5,7>: Cost 3 vuzpr <5,1,7,3>, LHS
  1158736007U,	// <u,2,5,u>: Cost 2 vrev <2,u,u,5>
  1527021670U,	// <u,2,6,0>: Cost 2 vext1 <u,4,2,6>, LHS
  2654351793U,	// <u,2,6,1>: Cost 3 vext2 <6,1,u,2>, <6,1,u,2>
  2623828474U,	// <u,2,6,2>: Cost 3 vext2 <1,0,u,2>, <6,2,7,3>
  1638328250U,	// <u,2,6,3>: Cost 2 vext3 RHS, <2,6,3,7>
  1527024950U,	// <u,2,6,4>: Cost 2 vext1 <u,4,2,6>, RHS
  2232264813U,	// <u,2,6,5>: Cost 3 vrev <2,u,5,6>
  2712217558U,	// <u,2,6,6>: Cost 3 vext3 RHS, <2,6,6,u>
  2856277806U,	// <u,2,6,7>: Cost 3 vuzpr <6,2,7,3>, LHS
  1638328295U,	// <u,2,6,u>: Cost 2 vext3 RHS, <2,6,u,7>
  1585919033U,	// <u,2,7,0>: Cost 2 vext2 <7,0,u,2>, <7,0,u,2>
  2860472110U,	// <u,2,7,1>: Cost 3 vuzpr <7,0,1,2>, LHS
  3021245993U,	// <u,2,7,2>: Cost 3 vtrnl <0,2,0,2>, RHS
  1812778312U,	// <u,2,7,3>: Cost 2 vzipl LHS, RHS
  3027455529U,	// <u,2,7,4>: Cost 3 vtrnl <1,2,3,4>, RHS
  2863453998U,	// <u,2,7,5>: Cost 3 vuzpr <7,4,5,6>, LHS
  3069349417U,	// <u,2,7,6>: Cost 3 vtrnl <u,2,4,6>, RHS
  2659661358U,	// <u,2,7,7>: Cost 3 vext2 <7,0,u,2>, <7,7,0,u>
  1812819272U,	// <u,2,7,u>: Cost 2 vzipl LHS, RHS
  408175266U,	// <u,2,u,0>: Cost 1 vext1 LHS, LHS
  1481917174U,	// <u,2,u,1>: Cost 2 vext1 LHS, <1,0,3,2>
  269271142U,	// <u,2,u,2>: Cost 1 vdup2 LHS
  1812775073U,	// <u,2,u,3>: Cost 2 vzipl LHS, LHS
  408177974U,	// <u,2,u,4>: Cost 1 vext1 LHS, RHS
  1481920208U,	// <u,2,u,5>: Cost 2 vext1 LHS, <5,1,7,3>
  1481921018U,	// <u,2,u,6>: Cost 2 vext1 LHS, <6,2,7,3>
  1529697274U,	// <u,2,u,7>: Cost 2 vext1 LHS, <7,0,1,2>
  408180526U,	// <u,2,u,u>: Cost 1 vext1 LHS, LHS
  1544781824U,	// <u,3,0,0>: Cost 2 vext2 LHS, <0,0,0,0>
  471040156U,	// <u,3,0,1>: Cost 1 vext2 LHS, LHS
  1544781988U,	// <u,3,0,2>: Cost 2 vext2 LHS, <0,2,0,2>
  2685233319U,	// <u,3,0,3>: Cost 3 vext3 LHS, <3,0,3,1>
  1487899958U,	// <u,3,0,4>: Cost 2 vext1 <1,u,3,0>, RHS
  2685233338U,	// <u,3,0,5>: Cost 3 vext3 LHS, <3,0,5,2>
  2561643002U,	// <u,3,0,6>: Cost 3 vext1 <1,u,3,0>, <6,2,7,3>
  2597475986U,	// <u,3,0,7>: Cost 3 vext1 <7,u,3,0>, <7,u,3,0>
  471040669U,	// <u,3,0,u>: Cost 1 vext2 LHS, LHS
  1544782582U,	// <u,3,1,0>: Cost 2 vext2 LHS, <1,0,3,2>
  1544782644U,	// <u,3,1,1>: Cost 2 vext2 LHS, <1,1,1,1>
  1544782742U,	// <u,3,1,2>: Cost 2 vext2 LHS, <1,2,3,0>
  2685233402U,	// <u,3,1,3>: Cost 3 vext3 LHS, <3,1,3,3>
  2561649974U,	// <u,3,1,4>: Cost 3 vext1 <1,u,3,1>, RHS
  1592558736U,	// <u,3,1,5>: Cost 2 vext2 LHS, <1,5,3,7>
  2666300623U,	// <u,3,1,6>: Cost 3 vext2 LHS, <1,6,1,7>
  2666300715U,	// <u,3,1,7>: Cost 3 vext2 LHS, <1,7,3,0>
  1544783228U,	// <u,3,1,u>: Cost 2 vext2 LHS, <1,u,3,0>
  1529716838U,	// <u,3,2,0>: Cost 2 vext1 <u,u,3,2>, LHS
  1164167966U,	// <u,3,2,1>: Cost 2 vrev <3,u,1,2>
  1544783464U,	// <u,3,2,2>: Cost 2 vext2 LHS, <2,2,2,2>
  1544783526U,	// <u,3,2,3>: Cost 2 vext2 LHS, <2,3,0,1>
  1529720118U,	// <u,3,2,4>: Cost 2 vext1 <u,u,3,2>, RHS
  2704034146U,	// <u,3,2,5>: Cost 3 vext3 <3,2,5,u>, <3,2,5,u>
  1592559546U,	// <u,3,2,6>: Cost 2 vext2 LHS, <2,6,3,7>
  2666301418U,	// <u,3,2,7>: Cost 3 vext2 LHS, <2,7,0,1>
  1544783931U,	// <u,3,2,u>: Cost 2 vext2 LHS, <2,u,0,1>
  1544784022U,	// <u,3,3,0>: Cost 2 vext2 LHS, <3,0,1,2>
  1483277128U,	// <u,3,3,1>: Cost 2 vext1 <1,1,3,3>, <1,1,3,3>
  1489913458U,	// <u,3,3,2>: Cost 2 vext1 <2,2,3,3>, <2,2,3,3>
  336380006U,	// <u,3,3,3>: Cost 1 vdup3 LHS
  1544784386U,	// <u,3,3,4>: Cost 2 vext2 LHS, <3,4,5,6>
  2618526242U,	// <u,3,3,5>: Cost 3 vext2 LHS, <3,5,0,2>
  2623171210U,	// <u,3,3,6>: Cost 3 vext2 LHS, <3,6,2,7>
  2597500565U,	// <u,3,3,7>: Cost 3 vext1 <7,u,3,3>, <7,u,3,3>
  336380006U,	// <u,3,3,u>: Cost 1 vdup3 LHS
  1544784786U,	// <u,3,4,0>: Cost 2 vext2 LHS, <4,0,5,1>
  1487930752U,	// <u,3,4,1>: Cost 2 vext1 <1,u,3,4>, <1,u,3,4>
  2618526774U,	// <u,3,4,2>: Cost 3 vext2 LHS, <4,2,5,3>
  2561673366U,	// <u,3,4,3>: Cost 3 vext1 <1,u,3,4>, <3,0,1,2>
  1487932726U,	// <u,3,4,4>: Cost 2 vext1 <1,u,3,4>, RHS
  471043382U,	// <u,3,4,5>: Cost 1 vext2 LHS, RHS
  1544785228U,	// <u,3,4,6>: Cost 2 vext2 LHS, <4,6,0,2>
  2597508758U,	// <u,3,4,7>: Cost 3 vext1 <7,u,3,4>, <7,u,3,4>
  471043625U,	// <u,3,4,u>: Cost 1 vext2 LHS, RHS
  2685233698U,	// <u,3,5,0>: Cost 3 vext3 LHS, <3,5,0,2>
  1544785616U,	// <u,3,5,1>: Cost 2 vext2 LHS, <5,1,7,3>
  2618527472U,	// <u,3,5,2>: Cost 3 vext2 LHS, <5,2,1,u>
  2972948634U,	// <u,3,5,3>: Cost 3 vzipr <3,3,3,3>, RHS
  1592561606U,	// <u,3,5,4>: Cost 2 vext2 LHS, <5,4,7,6>
  1592561668U,	// <u,3,5,5>: Cost 2 vext2 LHS, <5,5,5,5>
  1592561762U,	// <u,3,5,6>: Cost 2 vext2 LHS, <5,6,7,0>
  2618527862U,	// <u,3,5,7>: Cost 3 vext2 LHS, <5,7,0,2>
  1549431047U,	// <u,3,5,u>: Cost 2 vext2 LHS, <5,u,7,3>
  2618528041U,	// <u,3,6,0>: Cost 3 vext2 LHS, <6,0,2,1>
  2618528124U,	// <u,3,6,1>: Cost 3 vext2 LHS, <6,1,2,3>
  1544786426U,	// <u,3,6,2>: Cost 2 vext2 LHS, <6,2,7,3>
  3107166362U,	// <u,3,6,3>: Cost 3 vtrnr <3,3,3,3>, RHS
  2561690934U,	// <u,3,6,4>: Cost 3 vext1 <1,u,3,6>, RHS
  1164495686U,	// <u,3,6,5>: Cost 2 vrev <3,u,5,6>
  1592562488U,	// <u,3,6,6>: Cost 2 vext2 LHS, <6,6,6,6>
  1592562510U,	// <u,3,6,7>: Cost 2 vext2 LHS, <6,7,0,1>
  1549431776U,	// <u,3,6,u>: Cost 2 vext2 LHS, <6,u,7,3>
  1592562682U,	// <u,3,7,0>: Cost 2 vext2 LHS, <7,0,1,2>
  1487955331U,	// <u,3,7,1>: Cost 2 vext1 <1,u,3,7>, <1,u,3,7>
  1493928028U,	// <u,3,7,2>: Cost 2 vext1 <2,u,3,7>, <2,u,3,7>
  2892565832U,	// <u,3,7,3>: Cost 3 vzipl <1,1,3,3>, RHS
  1592563046U,	// <u,3,7,4>: Cost 2 vext2 LHS, <7,4,5,6>
  3034172969U,	// <u,3,7,5>: Cost 3 vtrnl <2,3,4,5>, RHS
  2655024623U,	// <u,3,7,6>: Cost 3 vext2 <6,2,u,3>, <7,6,2,u>
  1592563308U,	// <u,3,7,7>: Cost 2 vext2 LHS, <7,7,7,7>
  1592563330U,	// <u,3,7,u>: Cost 2 vext2 LHS, <7,u,1,2>
  1544787666U,	// <u,3,u,0>: Cost 2 vext2 LHS, <u,0,1,1>
  471045934U,	// <u,3,u,1>: Cost 1 vext2 LHS, LHS
  1544787820U,	// <u,3,u,2>: Cost 2 vext2 LHS, <u,2,0,2>
  336380006U,	// <u,3,u,3>: Cost 1 vdup3 LHS
  1544788031U,	// <u,3,u,4>: Cost 2 vext2 LHS, <u,4,5,6>
  471046298U,	// <u,3,u,5>: Cost 1 vext2 LHS, RHS
  1544788144U,	// <u,3,u,6>: Cost 2 vext2 LHS, <u,6,0,2>
  1592563968U,	// <u,3,u,7>: Cost 2 vext2 LHS, <u,7,0,1>
  471046501U,	// <u,3,u,u>: Cost 1 vext2 LHS, LHS
  2685234022U,	// <u,4,0,0>: Cost 3 vext3 LHS, <4,0,0,2>
  1551425638U,	// <u,4,0,1>: Cost 2 vext2 <1,2,u,4>, LHS
  2824058852U,	// <u,4,0,2>: Cost 3 vuzpr LHS, <u,3,4,5>
  2619859263U,	// <u,4,0,3>: Cost 3 vext2 <0,3,u,4>, <0,3,u,4>
  2567687058U,	// <u,4,0,4>: Cost 3 vext1 <2,u,4,0>, <4,0,5,1>
  1611492242U,	// <u,4,0,5>: Cost 2 vext3 LHS, <4,0,5,1>
  1611492252U,	// <u,4,0,6>: Cost 2 vext3 LHS, <4,0,6,2>
  3318050347U,	// <u,4,0,7>: Cost 4 vrev <4,u,7,0>
  1611492269U,	// <u,4,0,u>: Cost 2 vext3 LHS, <4,0,u,1>
  2625168118U,	// <u,4,1,0>: Cost 3 vext2 <1,2,u,4>, <1,0,3,2>
  2625168180U,	// <u,4,1,1>: Cost 3 vext2 <1,2,u,4>, <1,1,1,1>
  1551426503U,	// <u,4,1,2>: Cost 2 vext2 <1,2,u,4>, <1,2,u,4>
  2625831960U,	// <u,4,1,3>: Cost 3 vext2 <1,3,u,4>, <1,3,u,4>
  2567695670U,	// <u,4,1,4>: Cost 3 vext1 <2,u,4,1>, RHS
  1906759470U,	// <u,4,1,5>: Cost 2 vzipr RHS, LHS
  2685234158U,	// <u,4,1,6>: Cost 3 vext3 LHS, <4,1,6,3>
  2597557916U,	// <u,4,1,7>: Cost 3 vext1 <7,u,4,1>, <7,u,4,1>
  1555408301U,	// <u,4,1,u>: Cost 2 vext2 <1,u,u,4>, <1,u,u,4>
  2629813758U,	// <u,4,2,0>: Cost 3 vext2 <2,0,u,4>, <2,0,u,4>
  2625168943U,	// <u,4,2,1>: Cost 3 vext2 <1,2,u,4>, <2,1,4,u>
  2625169000U,	// <u,4,2,2>: Cost 3 vext2 <1,2,u,4>, <2,2,2,2>
  2625169062U,	// <u,4,2,3>: Cost 3 vext2 <1,2,u,4>, <2,3,0,1>
  3115226926U,	// <u,4,2,4>: Cost 3 vtrnr <4,6,4,6>, LHS
  2685234230U,	// <u,4,2,5>: Cost 3 vext3 LHS, <4,2,5,3>
  2040977198U,	// <u,4,2,6>: Cost 2 vtrnr RHS, LHS
  2597566109U,	// <u,4,2,7>: Cost 3 vext1 <7,u,4,2>, <7,u,4,2>
  2041124654U,	// <u,4,2,u>: Cost 2 vtrnr RHS, LHS
  2625169558U,	// <u,4,3,0>: Cost 3 vext2 <1,2,u,4>, <3,0,1,2>
  2567709594U,	// <u,4,3,1>: Cost 3 vext1 <2,u,4,3>, <1,2,3,4>
  2567710817U,	// <u,4,3,2>: Cost 3 vext1 <2,u,4,3>, <2,u,4,3>
  2625169820U,	// <u,4,3,3>: Cost 3 vext2 <1,2,u,4>, <3,3,3,3>
  2625169922U,	// <u,4,3,4>: Cost 3 vext2 <1,2,u,4>, <3,4,5,6>
  2899951772U,	// <u,4,3,5>: Cost 3 vzipl <2,3,4,5>, LHS
  3040887453U,	// <u,4,3,6>: Cost 3 vtrnl <3,4,5,6>, LHS
  3987644572U,	// <u,4,3,7>: Cost 4 vzipl <4,6,4,7>, LHS
  2625170206U,	// <u,4,3,u>: Cost 3 vext2 <1,2,u,4>, <3,u,1,2>
  1505919078U,	// <u,4,4,0>: Cost 2 vext1 <4,u,4,4>, LHS
  2567717831U,	// <u,4,4,1>: Cost 3 vext1 <2,u,4,4>, <1,2,u,4>
  2567719010U,	// <u,4,4,2>: Cost 3 vext1 <2,u,4,4>, <2,u,4,4>
  2570373542U,	// <u,4,4,3>: Cost 3 vext1 <3,3,4,4>, <3,3,4,4>
  161926454U,	// <u,4,4,4>: Cost 1 vdup0 RHS
  1551428918U,	// <u,4,4,5>: Cost 2 vext2 <1,2,u,4>, RHS
  1638329572U,	// <u,4,4,6>: Cost 2 vext3 RHS, <4,4,6,6>
  2594927963U,	// <u,4,4,7>: Cost 3 vext1 <7,4,4,4>, <7,4,4,4>
  161926454U,	// <u,4,4,u>: Cost 1 vdup0 RHS
  1493983334U,	// <u,4,5,0>: Cost 2 vext1 <2,u,4,5>, LHS
  2625171152U,	// <u,4,5,1>: Cost 3 vext2 <1,2,u,4>, <5,1,7,3>
  1493985379U,	// <u,4,5,2>: Cost 2 vext1 <2,u,4,5>, <2,u,4,5>
  2567727254U,	// <u,4,5,3>: Cost 3 vext1 <2,u,4,5>, <3,0,1,2>
  1493986614U,	// <u,4,5,4>: Cost 2 vext1 <2,u,4,5>, RHS
  1906759834U,	// <u,4,5,5>: Cost 2 vzipr RHS, RHS
  537750838U,	// <u,4,5,6>: Cost 1 vext3 LHS, RHS
  2652377280U,	// <u,4,5,7>: Cost 3 vext2 <5,7,u,4>, <5,7,u,4>
  537750856U,	// <u,4,5,u>: Cost 1 vext3 LHS, RHS
  1611492684U,	// <u,4,6,0>: Cost 2 vext3 LHS, <4,6,0,2>
  2712071508U,	// <u,4,6,1>: Cost 3 vext3 RHS, <4,6,1,1>
  2625171962U,	// <u,4,6,2>: Cost 3 vext2 <1,2,u,4>, <6,2,7,3>
  2712071526U,	// <u,4,6,3>: Cost 3 vext3 RHS, <4,6,3,1>
  1638329716U,	// <u,4,6,4>: Cost 2 vext3 RHS, <4,6,4,6>
  3111278746U,	// <u,4,6,5>: Cost 3 vtrnr <4,0,5,1>, RHS
  2040977562U,	// <u,4,6,6>: Cost 2 vtrnr RHS, RHS
  2579682298U,	// <u,4,6,7>: Cost 3 vext1 <4,u,4,6>, <7,0,1,2>
  2041125018U,	// <u,4,6,u>: Cost 2 vtrnr RHS, RHS
  2579685478U,	// <u,4,7,0>: Cost 3 vext1 <4,u,4,7>, LHS
  2602247111U,	// <u,4,7,1>: Cost 3 vext1 <u,6,4,7>, <1,2,u,4>
  2661004509U,	// <u,4,7,2>: Cost 3 vext2 <7,2,u,4>, <7,2,u,4>
  2573716286U,	// <u,4,7,3>: Cost 3 vext1 <3,u,4,7>, <3,u,4,7>
  2579688656U,	// <u,4,7,4>: Cost 3 vext1 <4,u,4,7>, <4,4,4,4>
  2899955016U,	// <u,4,7,5>: Cost 3 vzipl <2,3,4,5>, RHS
  96808489U,	// <u,4,7,6>: Cost 1 vrev RHS
  2651715180U,	// <u,4,7,7>: Cost 3 vext2 <5,6,u,4>, <7,7,7,7>
  96955963U,	// <u,4,7,u>: Cost 1 vrev RHS
  1611492846U,	// <u,4,u,0>: Cost 2 vext3 LHS, <4,u,0,2>
  1551431470U,	// <u,4,u,1>: Cost 2 vext2 <1,2,u,4>, LHS
  1494009958U,	// <u,4,u,2>: Cost 2 vext1 <2,u,4,u>, <2,u,4,u>
  2625173436U,	// <u,4,u,3>: Cost 3 vext2 <1,2,u,4>, <u,3,0,1>
  161926454U,	// <u,4,u,4>: Cost 1 vdup0 RHS
  1551431834U,	// <u,4,u,5>: Cost 2 vext2 <1,2,u,4>, RHS
  537751081U,	// <u,4,u,6>: Cost 1 vext3 LHS, RHS
  2651715840U,	// <u,4,u,7>: Cost 3 vext2 <5,6,u,4>, <u,7,0,1>
  537751099U,	// <u,4,u,u>: Cost 1 vext3 LHS, RHS
  2631811072U,	// <u,5,0,0>: Cost 3 vext2 <2,3,u,5>, <0,0,0,0>
  1558069350U,	// <u,5,0,1>: Cost 2 vext2 <2,3,u,5>, LHS
  2819454710U,	// <u,5,0,2>: Cost 3 vuzpr LHS, <u,0,5,1>
  2573732672U,	// <u,5,0,3>: Cost 3 vext1 <3,u,5,0>, <3,u,5,0>
  1546789265U,	// <u,5,0,4>: Cost 2 vext2 <0,4,u,5>, <0,4,u,5>
  2685234795U,	// <u,5,0,5>: Cost 3 vext3 LHS, <5,0,5,1>
  2597622682U,	// <u,5,0,6>: Cost 3 vext1 <7,u,5,0>, <6,7,u,5>
  1176539396U,	// <u,5,0,7>: Cost 2 vrev <5,u,7,0>
  1558069917U,	// <u,5,0,u>: Cost 2 vext2 <2,3,u,5>, LHS
  1500659814U,	// <u,5,1,0>: Cost 2 vext1 <4,0,5,1>, LHS
  2624512887U,	// <u,5,1,1>: Cost 3 vext2 <1,1,u,5>, <1,1,u,5>
  2625176520U,	// <u,5,1,2>: Cost 3 vext2 <1,2,u,5>, <1,2,u,5>
  2574403734U,	// <u,5,1,3>: Cost 3 vext1 <4,0,5,1>, <3,0,1,2>
  1500662674U,	// <u,5,1,4>: Cost 2 vext1 <4,0,5,1>, <4,0,5,1>
  2567769808U,	// <u,5,1,5>: Cost 3 vext1 <2,u,5,1>, <5,1,7,3>
  2987153198U,	// <u,5,1,6>: Cost 3 vzipr <5,6,7,0>, LHS
  1611493072U,	// <u,5,1,7>: Cost 2 vext3 LHS, <5,1,7,3>
  1611493081U,	// <u,5,1,u>: Cost 2 vext3 LHS, <5,1,u,3>
  2573746278U,	// <u,5,2,0>: Cost 3 vext1 <3,u,5,2>, LHS
  2685677296U,	// <u,5,2,1>: Cost 3 vext3 LHS, <5,2,1,u>
  2631149217U,	// <u,5,2,2>: Cost 3 vext2 <2,2,u,5>, <2,2,u,5>
  1558071026U,	// <u,5,2,3>: Cost 2 vext2 <2,3,u,5>, <2,3,u,5>
  2573749558U,	// <u,5,2,4>: Cost 3 vext1 <3,u,5,2>, RHS
  3120600878U,	// <u,5,2,5>: Cost 3 vtrnr <5,5,5,5>, LHS
  2685234968U,	// <u,5,2,6>: Cost 3 vext3 LHS, <5,2,6,3>
  2689879840U,	// <u,5,2,7>: Cost 3 vext3 LHS, <5,2,7,2>
  1561389191U,	// <u,5,2,u>: Cost 2 vext2 <2,u,u,5>, <2,u,u,5>
  2631813270U,	// <u,5,3,0>: Cost 3 vext2 <2,3,u,5>, <3,0,1,2>
  2909946012U,	// <u,5,3,1>: Cost 3 vzipl <4,0,5,1>, LHS
  2631813474U,	// <u,5,3,2>: Cost 3 vext2 <2,3,u,5>, <3,2,5,u>
  2631813532U,	// <u,5,3,3>: Cost 3 vext2 <2,3,u,5>, <3,3,3,3>
  2631813634U,	// <u,5,3,4>: Cost 3 vext2 <2,3,u,5>, <3,4,5,6>
  2919268508U,	// <u,5,3,5>: Cost 3 vzipl <5,5,5,5>, LHS
  2906669212U,	// <u,5,3,6>: Cost 3 vzipl <3,4,5,6>, LHS
  1973863069U,	// <u,5,3,7>: Cost 2 vtrnl RHS, LHS
  1973871261U,	// <u,5,3,u>: Cost 2 vtrnl RHS, LHS
  2631814034U,	// <u,5,4,0>: Cost 3 vext2 <2,3,u,5>, <4,0,5,1>
  2712072079U,	// <u,5,4,1>: Cost 3 vext3 RHS, <5,4,1,5>
  2573764338U,	// <u,5,4,2>: Cost 3 vext1 <3,u,5,4>, <2,3,u,5>
  2573765444U,	// <u,5,4,3>: Cost 3 vext1 <3,u,5,4>, <3,u,5,4>
  1570680053U,	// <u,5,4,4>: Cost 2 vext2 <4,4,u,5>, <4,4,u,5>
  1558072630U,	// <u,5,4,5>: Cost 2 vext2 <2,3,u,5>, RHS
  2631814476U,	// <u,5,4,6>: Cost 3 vext2 <2,3,u,5>, <4,6,0,2>
  1638330310U,	// <u,5,4,7>: Cost 2 vext3 RHS, <5,4,7,6>
  1558072873U,	// <u,5,4,u>: Cost 2 vext2 <2,3,u,5>, RHS
  1527234662U,	// <u,5,5,0>: Cost 2 vext1 <u,4,5,5>, LHS
  2625179344U,	// <u,5,5,1>: Cost 3 vext2 <1,2,u,5>, <5,1,7,3>
  2570454734U,	// <u,5,5,2>: Cost 3 vext1 <3,3,5,5>, <2,3,4,5>
  2570455472U,	// <u,5,5,3>: Cost 3 vext1 <3,3,5,5>, <3,3,5,5>
  1527237942U,	// <u,5,5,4>: Cost 2 vext1 <u,4,5,5>, RHS
  229035318U,	// <u,5,5,5>: Cost 1 vdup1 RHS
  2712072206U,	// <u,5,5,6>: Cost 3 vext3 RHS, <5,5,6,6>
  1638330392U,	// <u,5,5,7>: Cost 2 vext3 RHS, <5,5,7,7>
  229035318U,	// <u,5,5,u>: Cost 1 vdup1 RHS
  1500037222U,	// <u,5,6,0>: Cost 2 vext1 <3,u,5,6>, LHS
  2561836436U,	// <u,5,6,1>: Cost 3 vext1 <1,u,5,6>, <1,u,5,6>
  2631815674U,	// <u,5,6,2>: Cost 3 vext2 <2,3,u,5>, <6,2,7,3>
  1500040006U,	// <u,5,6,3>: Cost 2 vext1 <3,u,5,6>, <3,u,5,6>
  1500040502U,	// <u,5,6,4>: Cost 2 vext1 <3,u,5,6>, RHS
  2573782736U,	// <u,5,6,5>: Cost 3 vext1 <3,u,5,6>, <5,1,7,3>
  2573783546U,	// <u,5,6,6>: Cost 3 vext1 <3,u,5,6>, <6,2,7,3>
  27705344U,	// <u,5,6,7>: Cost 0 copy RHS
  27705344U,	// <u,5,6,u>: Cost 0 copy RHS
  2685677686U,	// <u,5,7,0>: Cost 3 vext3 LHS, <5,7,0,2>
  2909949256U,	// <u,5,7,1>: Cost 3 vzipl <4,0,5,1>, RHS
  2579760846U,	// <u,5,7,2>: Cost 3 vext1 <4,u,5,7>, <2,3,4,5>
  2661676335U,	// <u,5,7,3>: Cost 3 vext2 <7,3,u,5>, <7,3,u,5>
  2712072350U,	// <u,5,7,4>: Cost 3 vext3 RHS, <5,7,4,6>
  2919271752U,	// <u,5,7,5>: Cost 3 vzipl <5,5,5,5>, RHS
  2906672456U,	// <u,5,7,6>: Cost 3 vzipl <3,4,5,6>, RHS
  1973866025U,	// <u,5,7,7>: Cost 2 vtrnl RHS, RHS
  1973874217U,	// <u,5,7,u>: Cost 2 vtrnl RHS, RHS
  1500053606U,	// <u,5,u,0>: Cost 2 vext1 <3,u,5,u>, LHS
  1558075182U,	// <u,5,u,1>: Cost 2 vext2 <2,3,u,5>, LHS
  2631817068U,	// <u,5,u,2>: Cost 3 vext2 <2,3,u,5>, <u,2,0,2>
  1500056392U,	// <u,5,u,3>: Cost 2 vext1 <3,u,5,u>, <3,u,5,u>
  1500056886U,	// <u,5,u,4>: Cost 2 vext1 <3,u,5,u>, RHS
  229035318U,	// <u,5,u,5>: Cost 1 vdup1 RHS
  2685677822U,	// <u,5,u,6>: Cost 3 vext3 LHS, <5,u,6,3>
  27705344U,	// <u,5,u,7>: Cost 0 copy RHS
  27705344U,	// <u,5,u,u>: Cost 0 copy RHS
  2819922074U,	// <u,6,0,0>: Cost 3 vuzpr <0,2,0,2>, RHS
  1564713062U,	// <u,6,0,1>: Cost 2 vext2 <3,4,u,6>, LHS
  1745672346U,	// <u,6,0,2>: Cost 2 vuzpr LHS, RHS
  2573806409U,	// <u,6,0,3>: Cost 3 vext1 <3,u,6,0>, <3,u,6,0>
  1546355036U,	// <u,6,0,4>: Cost 2 vext2 <0,4,2,6>, <0,4,2,6>
  2579115974U,	// <u,6,0,5>: Cost 3 vext1 <4,7,6,0>, <5,4,7,6>
  2733011276U,	// <u,6,0,6>: Cost 3 vext3 LHS, <6,0,6,0>
  2685235543U,	// <u,6,0,7>: Cost 3 vext3 LHS, <6,0,7,2>
  1746114714U,	// <u,6,0,u>: Cost 2 vuzpr LHS, RHS
  1182004127U,	// <u,6,1,0>: Cost 2 vrev <6,u,0,1>
  2825296026U,	// <u,6,1,1>: Cost 3 vuzpr <1,1,1,1>, RHS
  2685235580U,	// <u,6,1,2>: Cost 3 vext3 LHS, <6,1,2,3>
  2824788122U,	// <u,6,1,3>: Cost 3 vuzpr <1,0,3,2>, RHS
  2626511979U,	// <u,6,1,4>: Cost 3 vext2 <1,4,u,6>, <1,4,u,6>
  2650399888U,	// <u,6,1,5>: Cost 3 vext2 <5,4,u,6>, <1,5,3,7>
  2993100590U,	// <u,6,1,6>: Cost 3 vzipr <6,6,6,6>, LHS
  2913386569U,	// <u,6,1,7>: Cost 3 vzipl RHS, <0,0,u,1>
  1182594023U,	// <u,6,1,u>: Cost 2 vrev <6,u,u,1>
  1500741734U,	// <u,6,2,0>: Cost 2 vext1 <4,0,6,2>, LHS
  2255827881U,	// <u,6,2,1>: Cost 3 vrev <6,u,1,2>
  2685678034U,	// <u,6,2,2>: Cost 3 vext3 LHS, <6,2,2,u>
  2832095386U,	// <u,6,2,3>: Cost 3 vuzpr <2,2,3,3>, RHS
  1500744604U,	// <u,6,2,4>: Cost 2 vext1 <4,0,6,2>, <4,0,6,2>
  2574487248U,	// <u,6,2,5>: Cost 3 vext1 <4,0,6,2>, <5,1,7,3>
  2567852538U,	// <u,6,2,6>: Cost 3 vext1 <2,u,6,2>, <6,2,7,3>
  1611493882U,	// <u,6,2,7>: Cost 2 vext3 LHS, <6,2,7,3>
  1611493891U,	// <u,6,2,u>: Cost 2 vext3 LHS, <6,2,u,3>
  2638456982U,	// <u,6,3,0>: Cost 3 vext2 <3,4,u,6>, <3,0,1,2>
  2836584602U,	// <u,6,3,1>: Cost 3 vuzpr <3,0,1,2>, RHS
  2910027932U,	// <u,6,3,2>: Cost 3 vzipl <4,0,6,2>, LHS
  2838730906U,	// <u,6,3,3>: Cost 3 vuzpr <3,3,3,3>, RHS
  1564715549U,	// <u,6,3,4>: Cost 2 vext2 <3,4,u,6>, <3,4,u,6>
  2839566490U,	// <u,6,3,5>: Cost 3 vuzpr <3,4,5,6>, RHS
  3048112797U,	// <u,6,3,6>: Cost 3 vtrnl <4,6,4,6>, LHS
  1839644828U,	// <u,6,3,7>: Cost 2 vzipl RHS, LHS
  1567370081U,	// <u,6,3,u>: Cost 2 vext2 <3,u,u,6>, <3,u,u,6>
  2638457746U,	// <u,6,4,0>: Cost 3 vext2 <3,4,u,6>, <4,0,5,1>
  2638236654U,	// <u,6,4,1>: Cost 3 vext2 <3,4,5,6>, <4,1,6,3>
  2712072817U,	// <u,6,4,2>: Cost 3 vext3 RHS, <6,4,2,5>
  2638458005U,	// <u,6,4,3>: Cost 3 vext2 <3,4,u,6>, <4,3,6,u>
  1570540772U,	// <u,6,4,4>: Cost 2 vext2 <4,4,6,6>, <4,4,6,6>
  1564716342U,	// <u,6,4,5>: Cost 2 vext2 <3,4,u,6>, RHS
  1772542106U,	// <u,6,4,6>: Cost 2 vuzpr RHS, RHS
  2913387463U,	// <u,6,4,7>: Cost 3 vzipl RHS, <1,2,u,4>
  1564716585U,	// <u,6,4,u>: Cost 2 vext2 <3,4,u,6>, RHS
  2712072882U,	// <u,6,5,0>: Cost 3 vext3 RHS, <6,5,0,7>
  2638458576U,	// <u,6,5,1>: Cost 3 vext2 <3,4,u,6>, <5,1,7,3>
  2712072900U,	// <u,6,5,2>: Cost 3 vext3 RHS, <6,5,2,7>
  2576501250U,	// <u,6,5,3>: Cost 3 vext1 <4,3,6,5>, <3,4,5,6>
  1576660943U,	// <u,6,5,4>: Cost 2 vext2 <5,4,u,6>, <5,4,u,6>
  2650402820U,	// <u,6,5,5>: Cost 3 vext2 <5,4,u,6>, <5,5,5,5>
  2712072936U,	// <u,6,5,6>: Cost 3 vext3 RHS, <6,5,6,7>
  2913388274U,	// <u,6,5,7>: Cost 3 vzipl RHS, <2,3,u,5>
  1182626795U,	// <u,6,5,u>: Cost 2 vrev <6,u,u,5>
  1527316582U,	// <u,6,6,0>: Cost 2 vext1 <u,4,6,6>, LHS
  2601059062U,	// <u,6,6,1>: Cost 3 vext1 <u,4,6,6>, <1,0,3,2>
  2625188346U,	// <u,6,6,2>: Cost 3 vext2 <1,2,u,6>, <6,2,7,3>
  2577172994U,	// <u,6,6,3>: Cost 3 vext1 <4,4,6,6>, <3,4,5,6>
  1527319862U,	// <u,6,6,4>: Cost 2 vext1 <u,4,6,6>, RHS
  2256155601U,	// <u,6,6,5>: Cost 3 vrev <6,u,5,6>
  296144182U,	// <u,6,6,6>: Cost 1 vdup2 RHS
  1638331202U,	// <u,6,6,7>: Cost 2 vext3 RHS, <6,6,7,7>
  296144182U,	// <u,6,6,u>: Cost 1 vdup2 RHS
  432349286U,	// <u,6,7,0>: Cost 1 vext1 RHS, LHS
  1506091766U,	// <u,6,7,1>: Cost 2 vext1 RHS, <1,0,3,2>
  1506092648U,	// <u,6,7,2>: Cost 2 vext1 RHS, <2,2,2,2>
  1506093206U,	// <u,6,7,3>: Cost 2 vext1 RHS, <3,0,1,2>
  432352809U,	// <u,6,7,4>: Cost 1 vext1 RHS, RHS
  1506094800U,	// <u,6,7,5>: Cost 2 vext1 RHS, <5,1,7,3>
  1506095610U,	// <u,6,7,6>: Cost 2 vext1 RHS, <6,2,7,3>
  1839648072U,	// <u,6,7,7>: Cost 2 vzipl RHS, RHS
  432355118U,	// <u,6,7,u>: Cost 1 vext1 RHS, LHS
  432357478U,	// <u,6,u,0>: Cost 1 vext1 RHS, LHS
  1564718894U,	// <u,6,u,1>: Cost 2 vext2 <3,4,u,6>, LHS
  1506100840U,	// <u,6,u,2>: Cost 2 vext1 RHS, <2,2,2,2>
  1506101398U,	// <u,6,u,3>: Cost 2 vext1 RHS, <3,0,1,2>
  432361002U,	// <u,6,u,4>: Cost 1 vext1 RHS, RHS
  1564719258U,	// <u,6,u,5>: Cost 2 vext2 <3,4,u,6>, RHS
  296144182U,	// <u,6,u,6>: Cost 1 vdup2 RHS
  1611936736U,	// <u,6,u,7>: Cost 2 vext3 LHS, <6,u,7,3>
  432363310U,	// <u,6,u,u>: Cost 1 vext1 RHS, LHS
  1571356672U,	// <u,7,0,0>: Cost 2 vext2 RHS, <0,0,0,0>
  497614950U,	// <u,7,0,1>: Cost 1 vext2 RHS, LHS
  1571356836U,	// <u,7,0,2>: Cost 2 vext2 RHS, <0,2,0,2>
  2645098757U,	// <u,7,0,3>: Cost 3 vext2 RHS, <0,3,2,0>
  1571357010U,	// <u,7,0,4>: Cost 2 vext2 RHS, <0,4,1,5>
  1512083716U,	// <u,7,0,5>: Cost 2 vext1 <5,u,7,0>, <5,u,7,0>
  2645098989U,	// <u,7,0,6>: Cost 3 vext2 RHS, <0,6,0,7>
  2585826298U,	// <u,7,0,7>: Cost 3 vext1 <5,u,7,0>, <7,0,1,2>
  497615517U,	// <u,7,0,u>: Cost 1 vext2 RHS, LHS
  1571357430U,	// <u,7,1,0>: Cost 2 vext2 RHS, <1,0,3,2>
  1571357492U,	// <u,7,1,1>: Cost 2 vext2 RHS, <1,1,1,1>
  1571357590U,	// <u,7,1,2>: Cost 2 vext2 RHS, <1,2,3,0>
  2645099470U,	// <u,7,1,3>: Cost 3 vext2 RHS, <1,3,0,2>
  2712073322U,	// <u,7,1,4>: Cost 3 vext3 RHS, <7,1,4,6>
  1571357840U,	// <u,7,1,5>: Cost 2 vext2 RHS, <1,5,3,7>
  2645099727U,	// <u,7,1,6>: Cost 3 vext2 RHS, <1,6,1,7>
  2999818030U,	// <u,7,1,7>: Cost 3 vzipr <7,7,7,7>, LHS
  1571358076U,	// <u,7,1,u>: Cost 2 vext2 RHS, <1,u,3,0>
  2645099956U,	// <u,7,2,0>: Cost 3 vext2 RHS, <2,0,0,2>
  1188058754U,	// <u,7,2,1>: Cost 2 vrev <7,u,1,2>
  1571358312U,	// <u,7,2,2>: Cost 2 vext2 RHS, <2,2,2,2>
  1571358374U,	// <u,7,2,3>: Cost 2 vext2 RHS, <2,3,0,1>
  2645100280U,	// <u,7,2,4>: Cost 3 vext2 RHS, <2,4,0,2>
  2645100366U,	// <u,7,2,5>: Cost 3 vext2 RHS, <2,5,0,7>
  1571358650U,	// <u,7,2,6>: Cost 2 vext2 RHS, <2,6,3,7>
  3134035758U,	// <u,7,2,7>: Cost 3 vtrnr <7,7,7,7>, LHS
  1571358779U,	// <u,7,2,u>: Cost 2 vext2 RHS, <2,u,0,1>
  1571358870U,	// <u,7,3,0>: Cost 2 vext2 RHS, <3,0,1,2>
  2645100766U,	// <u,7,3,1>: Cost 3 vext2 RHS, <3,1,0,2>
  2645100846U,	// <u,7,3,2>: Cost 3 vext2 RHS, <3,2,0,1>
  1571359132U,	// <u,7,3,3>: Cost 2 vext2 RHS, <3,3,3,3>
  1571359234U,	// <u,7,3,4>: Cost 2 vext2 RHS, <3,4,5,6>
  1512108295U,	// <u,7,3,5>: Cost 2 vext1 <5,u,7,3>, <5,u,7,3>
  1518080992U,	// <u,7,3,6>: Cost 2 vext1 <6,u,7,3>, <6,u,7,3>
  2919432348U,	// <u,7,3,7>: Cost 3 vzipl <5,5,7,7>, LHS
  1571359518U,	// <u,7,3,u>: Cost 2 vext2 RHS, <3,u,1,2>
  1571359634U,	// <u,7,4,0>: Cost 2 vext2 RHS, <4,0,5,1>
  2645101514U,	// <u,7,4,1>: Cost 3 vext2 RHS, <4,1,2,3>
  2645101621U,	// <u,7,4,2>: Cost 3 vext2 RHS, <4,2,5,2>
  2645101703U,	// <u,7,4,3>: Cost 3 vext2 RHS, <4,3,5,3>
  1571359952U,	// <u,7,4,4>: Cost 2 vext2 RHS, <4,4,4,4>
  497618248U,	// <u,7,4,5>: Cost 1 vext2 RHS, RHS
  1571360076U,	// <u,7,4,6>: Cost 2 vext2 RHS, <4,6,0,2>
  2712073591U,	// <u,7,4,7>: Cost 3 vext3 RHS, <7,4,7,5>
  497618473U,	// <u,7,4,u>: Cost 1 vext2 RHS, RHS
  2645102151U,	// <u,7,5,0>: Cost 3 vext2 RHS, <5,0,1,1>
  1571360464U,	// <u,7,5,1>: Cost 2 vext2 RHS, <5,1,7,3>
  2645102315U,	// <u,7,5,2>: Cost 3 vext2 RHS, <5,2,1,3>
  2645102448U,	// <u,7,5,3>: Cost 3 vext2 RHS, <5,3,7,1>
  1571360710U,	// <u,7,5,4>: Cost 2 vext2 RHS, <5,4,7,6>
  1571360772U,	// <u,7,5,5>: Cost 2 vext2 RHS, <5,5,5,5>
  1571360866U,	// <u,7,5,6>: Cost 2 vext2 RHS, <5,6,7,0>
  2712073674U,	// <u,7,5,7>: Cost 3 vext3 RHS, <7,5,7,7>
  1571361028U,	// <u,7,5,u>: Cost 2 vext2 RHS, <5,u,7,0>
  1530044518U,	// <u,7,6,0>: Cost 2 vext1 <u,u,7,6>, LHS
  2645102972U,	// <u,7,6,1>: Cost 3 vext2 RHS, <6,1,2,3>
  1571361274U,	// <u,7,6,2>: Cost 2 vext2 RHS, <6,2,7,3>
  2645103154U,	// <u,7,6,3>: Cost 3 vext2 RHS, <6,3,4,5>
  1530047798U,	// <u,7,6,4>: Cost 2 vext1 <u,u,7,6>, RHS
  1188386474U,	// <u,7,6,5>: Cost 2 vrev <7,u,5,6>
  1571361592U,	// <u,7,6,6>: Cost 2 vext2 RHS, <6,6,6,6>
  1571361614U,	// <u,7,6,7>: Cost 2 vext2 RHS, <6,7,0,1>
  1571361695U,	// <u,7,6,u>: Cost 2 vext2 RHS, <6,u,0,1>
  1571361786U,	// <u,7,7,0>: Cost 2 vext2 RHS, <7,0,1,2>
  2645103683U,	// <u,7,7,1>: Cost 3 vext2 RHS, <7,1,0,3>
  2645103781U,	// <u,7,7,2>: Cost 3 vext2 RHS, <7,2,2,2>
  2645103843U,	// <u,7,7,3>: Cost 3 vext2 RHS, <7,3,0,1>
  1571362150U,	// <u,7,7,4>: Cost 2 vext2 RHS, <7,4,5,6>
  1510150168U,	// <u,7,7,5>: Cost 2 vext1 <5,5,7,7>, <5,5,7,7>
  1516786498U,	// <u,7,7,6>: Cost 2 vext1 <6,6,7,7>, <6,6,7,7>
  363253046U,	// <u,7,7,7>: Cost 1 vdup3 RHS
  363253046U,	// <u,7,7,u>: Cost 1 vdup3 RHS
  1571362514U,	// <u,7,u,0>: Cost 2 vext2 RHS, <u,0,1,1>
  497620782U,	// <u,7,u,1>: Cost 1 vext2 RHS, LHS
  1571362668U,	// <u,7,u,2>: Cost 2 vext2 RHS, <u,2,0,2>
  1571362748U,	// <u,7,u,3>: Cost 2 vext2 RHS, <u,3,0,1>
  1571362842U,	// <u,7,u,4>: Cost 2 vext2 RHS, <u,4,1,5>
  497621146U,	// <u,7,u,5>: Cost 1 vext2 RHS, RHS
  1571362992U,	// <u,7,u,6>: Cost 2 vext2 RHS, <u,6,0,2>
  363253046U,	// <u,7,u,7>: Cost 1 vdup3 RHS
  497621349U,	// <u,7,u,u>: Cost 1 vext2 RHS, LHS
  135053414U,	// <u,u,0,0>: Cost 1 vdup0 LHS
  471081121U,	// <u,u,0,1>: Cost 1 vext2 LHS, LHS
  1745672036U,	// <u,u,0,2>: Cost 2 vuzpr LHS, LHS
  1616140005U,	// <u,u,0,3>: Cost 2 vext3 LHS, <u,0,3,2>
  1488268598U,	// <u,u,0,4>: Cost 2 vext1 <1,u,u,0>, RHS
  1611495158U,	// <u,u,0,5>: Cost 2 vext3 LHS, <u,0,5,1>
  1611495168U,	// <u,u,0,6>: Cost 2 vext3 LHS, <u,0,6,2>
  1194457487U,	// <u,u,0,7>: Cost 2 vrev <u,u,7,0>
  471081629U,	// <u,u,0,u>: Cost 1 vext2 LHS, LHS
  1544823542U,	// <u,u,1,0>: Cost 2 vext2 LHS, <1,0,3,2>
  202162278U,	// <u,u,1,1>: Cost 1 vdup1 LHS
  537753390U,	// <u,u,1,2>: Cost 1 vext3 LHS, LHS
  1611495223U,	// <u,u,1,3>: Cost 2 vext3 LHS, <u,1,3,3>
  1494248758U,	// <u,u,1,4>: Cost 2 vext1 <2,u,u,1>, RHS
  1571366032U,	// <u,u,1,5>: Cost 2 vext2 RHS, <1,5,3,7>
  1518138343U,	// <u,u,1,6>: Cost 2 vext1 <6,u,u,1>, <6,u,u,1>
  1611495259U,	// <u,u,1,7>: Cost 2 vext3 LHS, <u,1,7,3>
  537753444U,	// <u,u,1,u>: Cost 1 vext3 LHS, LHS
  1611495276U,	// <u,u,2,0>: Cost 2 vext3 LHS, <u,2,0,2>
  1194031451U,	// <u,u,2,1>: Cost 2 vrev <u,u,1,2>
  269271142U,	// <u,u,2,2>: Cost 1 vdup2 LHS
  835584U,	// <u,u,2,3>: Cost 0 copy LHS
  1500228918U,	// <u,u,2,4>: Cost 2 vext1 <3,u,u,2>, RHS
  2685237146U,	// <u,u,2,5>: Cost 3 vext3 LHS, <u,2,5,3>
  1571366842U,	// <u,u,2,6>: Cost 2 vext2 RHS, <2,6,3,7>
  1611495340U,	// <u,u,2,7>: Cost 2 vext3 LHS, <u,2,7,3>
  835584U,	// <u,u,2,u>: Cost 0 copy LHS
  408576723U,	// <u,u,3,0>: Cost 1 vext1 LHS, LHS
  1482318582U,	// <u,u,3,1>: Cost 2 vext1 LHS, <1,0,3,2>
  120371557U,	// <u,u,3,2>: Cost 1 vrev LHS
  336380006U,	// <u,u,3,3>: Cost 1 vdup3 LHS
  408579382U,	// <u,u,3,4>: Cost 1 vext1 LHS, RHS
  1482321616U,	// <u,u,3,5>: Cost 2 vext1 LHS, <5,1,7,3>
  1482322426U,	// <u,u,3,6>: Cost 2 vext1 LHS, <6,2,7,3>
  1839792284U,	// <u,u,3,7>: Cost 2 vzipl RHS, LHS
  408581934U,	// <u,u,3,u>: Cost 1 vext1 LHS, LHS
  1544825746U,	// <u,u,4,0>: Cost 2 vext2 LHS, <4,0,5,1>
  1488299437U,	// <u,u,4,1>: Cost 2 vext1 <1,u,u,4>, <1,u,u,4>
  1638332452U,	// <u,u,4,2>: Cost 2 vext3 RHS, <u,4,2,6>
  1194195311U,	// <u,u,4,3>: Cost 2 vrev <u,u,3,4>
  161926454U,	// <u,u,4,4>: Cost 1 vdup0 RHS
  471084342U,	// <u,u,4,5>: Cost 1 vext2 LHS, RHS
  1544826188U,	// <u,u,4,6>: Cost 2 vext2 LHS, <4,6,0,2>
  1640323153U,	// <u,u,4,7>: Cost 2 vext3 RHS, <u,4,7,6>
  471084585U,	// <u,u,4,u>: Cost 1 vext2 LHS, RHS
  1494278246U,	// <u,u,5,0>: Cost 2 vext1 <2,u,u,5>, LHS
  1544826576U,	// <u,u,5,1>: Cost 2 vext2 LHS, <5,1,7,3>
  1494280327U,	// <u,u,5,2>: Cost 2 vext1 <2,u,u,5>, <2,u,u,5>
  1638332543U,	// <u,u,5,3>: Cost 2 vext3 RHS, <u,5,3,7>
  1494281526U,	// <u,u,5,4>: Cost 2 vext1 <2,u,u,5>, RHS
  229035318U,	// <u,u,5,5>: Cost 1 vdup1 RHS
  537753754U,	// <u,u,5,6>: Cost 1 vext3 LHS, RHS
  1638332579U,	// <u,u,5,7>: Cost 2 vext3 RHS, <u,5,7,7>
  537753772U,	// <u,u,5,u>: Cost 1 vext3 LHS, RHS
  1611495600U,	// <u,u,6,0>: Cost 2 vext3 LHS, <u,6,0,2>
  2618569084U,	// <u,u,6,1>: Cost 3 vext2 LHS, <6,1,2,3>
  1544827386U,	// <u,u,6,2>: Cost 2 vext2 LHS, <6,2,7,3>
  1500261217U,	// <u,u,6,3>: Cost 2 vext1 <3,u,u,6>, <3,u,u,6>
  1500261686U,	// <u,u,6,4>: Cost 2 vext1 <3,u,u,6>, RHS
  1194359171U,	// <u,u,6,5>: Cost 2 vrev <u,u,5,6>
  296144182U,	// <u,u,6,6>: Cost 1 vdup2 RHS
  27705344U,	// <u,u,6,7>: Cost 0 copy RHS
  27705344U,	// <u,u,6,u>: Cost 0 copy RHS
  432496742U,	// <u,u,7,0>: Cost 1 vext1 RHS, LHS
  1506239222U,	// <u,u,7,1>: Cost 2 vext1 RHS, <1,0,3,2>
  1506240104U,	// <u,u,7,2>: Cost 2 vext1 RHS, <2,2,2,2>
  1813220680U,	// <u,u,7,3>: Cost 2 vzipl LHS, RHS
  432500283U,	// <u,u,7,4>: Cost 1 vext1 RHS, RHS
  1506242256U,	// <u,u,7,5>: Cost 2 vext1 RHS, <5,1,7,3>
  120699277U,	// <u,u,7,6>: Cost 1 vrev RHS
  363253046U,	// <u,u,7,7>: Cost 1 vdup3 RHS
  432502574U,	// <u,u,7,u>: Cost 1 vext1 RHS, LHS
  408617688U,	// <u,u,u,0>: Cost 1 vext1 LHS, LHS
  471086894U,	// <u,u,u,1>: Cost 1 vext2 LHS, LHS
  537753957U,	// <u,u,u,2>: Cost 1 vext3 LHS, LHS
  835584U,	// <u,u,u,3>: Cost 0 copy LHS
  408620342U,	// <u,u,u,4>: Cost 1 vext1 LHS, RHS
  471087258U,	// <u,u,u,5>: Cost 1 vext2 LHS, RHS
  537753997U,	// <u,u,u,6>: Cost 1 vext3 LHS, RHS
  27705344U,	// <u,u,u,7>: Cost 0 copy RHS
  835584U,	// <u,u,u,u>: Cost 0 copy LHS
  0
};
