/* (C) Marcin Kwadrans <quar@vitea.pl> */

/*! \file message.h 
	\brief Plik zawiera deklarację klasy komunikatów
*/

#ifndef __LW_MESSAGE_H
#define __LW_MESSAGE_H

#include "piece.h"

enum LWMsg {
	LW_INFO_ProgramInterrupted=0,
	LW_ERROR_WrongNumberOfArguments=1,
	LW_ERROR_LValueIsNotVariable=2,
	LW_ERROR_UnmatchedBrace=3,
	LW_ERROR_EmptyBrace=4,
	LW_ERROR_BadString=5,
	LW_ERROR_DivisionByZero=6,
	LW_ERROR_BadIndexOfArray=7,
	LW_ERROR_ForButWhereIsToOrDownto=8,
	LW_ERROR_ToButWhereIsFor=9,
	LW_ERROR_DowntoButWhereIsFor=10,
	LW_ERROR_RepeatButWhereIsUntil=11,
	LW_ERROR_UntilButWhereIsRepeat=12,
	LW_ERROR_NeedVariableAsArgument=13,
	LW_ERROR_IsNotArray=14,
	LW_ERROR_IndexOutOfRange=15
};

class LWProgram;

/*! \class LWMessage
	\brief Klasa komunikatu

	Obiekty tej klasy są rzucane jako wyjątki podczas analizy i interpretacji kodu
*/

class LWMessage {
private:
LWMsg message;
LWPiece *piece;
LWProgram *program;
public:
LWMessage (LWMsg a_message);
void setPiece (LWPiece *a_piece);
void setProgram (LWProgram *a_program);
void show ();
};

#include "program.h"

#endif
