# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import os
from subprocess import Popen,PIPE
from xdg.BaseDirectory import load_data_paths, xdg_cache_home, save_config_path

from logger import newLogger

logger = newLogger("xdg_support")

global already_warn
already_warn = False

#Started from source directory
workdatadir = None
issourceconfig = os.path.exists(os.path.join(os.getcwd(),"start_listen"))
if issourceconfig:
    workdatadir = os.path.join(os.getcwd(),"..","data")

def get_xdg_data_file(filename):
    global already_warn
    if workdatadir: 
        path = os.path.join(workdatadir,filename)
        if os.path.exists(path): 
            return path
        else:
            logger.error("Failed find %s",path)
            return ""
    for path in load_data_paths("listen/%s"%filename):
        return path
    if not already_warn: 
        logger.warn("No xdg data found, fallback to classic data path")
        already_warn = True
    path = os.environ.get("LISTEN_DATA_PATH","/usr/share/listen")
    path = os.path.join(path,filename)
    return path

def get_xdg_pixmap_file(filename):
    return get_xdg_data_file(os.path.join("img",filename))

def get_xdg_config_file(filename):
    return os.path.join(save_config_path("listen"),filename)

def get_xdg_config_dir(filename):
    dir = save_config_path("listen/%s"%filename)
    if not os.path.isdir(dir):
        os.makedirs(dir)
    return dir

def get_xdg_cache_file(path):
    file = os.path.join(xdg_cache_home,"listen",path)
    dir = os.path.dirname(file)
    if not os.path.isdir(dir):
        os.makedirs(dir)
    return file

def get_xdg_cache_dir(path):
    dir = os.path.join(xdg_cache_home,"listen",path)
    if not os.path.isdir(dir):
        os.makedirs(dir)
    return dir

# Not really xdg

def get_xdg_lib_dirs(filename):
    dir = os.environ.get("LISTEN_LIBRARY_PATH","/usr/lib/listen")
    dir = os.path.join(dir,filename)
    return [ dir, get_xdg_config_dir(filename) ]

def get_xdg_tmp_file(filename):
    return os.path.join(os.environ.get("TMPDIR","/tmp"), filename)

def get_xdg_music_dir():
    defmusicpath = os.path.expanduser("~/Music")
    try:
        p = Popen(["xdg-user-dir","MUSIC"], stdout=PIPE)
    except OSError:
        return defmusicpath
    else:
        musicpath = p.communicate()[0].strip()
        if p.returncode == 0 and \
                musicpath and \
                musicpath != os.path.expanduser("~"):
            return musicpath
        else:
            return defmusicpath

