# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import os

import gtk
import gobject

from config import config
import vfs

from source import Source,SourceItem


from widget.song_view import SortableSongView
from widget.song_menu import SongMenu
from widget.misc import ScrolledWindow

from library import ListenDB

from song import file_is_supported

class FileBrowser(gtk.VPaned):
    def __init__(self):
        super(FileBrowser,self).__init__()
        
        
        self.view = FileSystemSongView()        
        self.chooser = gtk.FileChooserWidget(gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER)
        
        uri = config.get("filebrowser","uri")
        self.chooser.set_uri(uri)
        filter = gtk.FileFilter()
        filter.add_mime_type("x-directory/normal")
        filter.add_mime_type("inode/directory")
        #self.chooser.set_filter(filter)
        self.chooser.connect("current-folder-changed",self.on_selection)
        
        self.pack1(self.chooser)
        self.pack2(ScrolledWindow(self.view,False,gtk.SHADOW_IN,gtk.POLICY_AUTOMATIC,gtk.POLICY_ALWAYS))
        self.set_position(int(config.get("filebrowser","pane_pos")))
        #self.connect("event",lambda pane,ev:config.set("filebrowser","pane_pos","%d"%self.get_position()))
        
    def save(self):
        if self.view:
            self.view.save_config()
        config.set("filebrowser","pane_pos","%d"%self.get_position())
        
    def on_selection(self,filechooser):
        uri  = self.chooser.get_uri()
        config.set("filebrowser","uri",uri)
        path = self.chooser.get_filename()

        added = [ vfs.make_uri_from_shell_arg(path+os.sep+file) \
                for file in os.listdir(path) \
                if file[0] != "." and os.path.isfile(os.path.join(path,file)) and 
                 file_is_supported(os.path.join(path,file)) ]

        songs = [ ListenDB.get_or_create_song({"uri":uri},"unknown_local",hidden=True,read_from_file=True) for uri in added ]
        gobject.idle_add(self.view.get_model().fill,songs)
        
class FileSystemSongView(SortableSongView):
    def __init__(self):
        super(FileSystemSongView,self).__init__("filesystem")
        menu = SongMenu()
        menu.disable(["delete","deletedisk"])
        self.set_menu(menu)
        
class FileSystemSourceItem(SourceItem):
    has_top_separateur = True
    has_bottom_separateur = False

    label = _("Filesystem")
    config_code = "filebrowser"
    stock = gtk.STOCK_HARDDISK
    widget_klass = FileBrowser
        
class FileSystemSource(Source):
    PLUGIN_NAME = "Filesystem Browser"
    PLUGIN_DESC = _("Browse your filesystem directly in Listen")

    display_index = 70    
    def __init__(self):
        Source.__init__(self)
        self.items = [FileSystemSourceItem()]

    def save(self):
        self.items[0].widget.save()
        
