
import gobject, gtk

import dbus #@UnusedImport
import dbus.glib #@UnusedImport


from player import Player
from plugins.generic import GenericPlugin

OBJ_PATH = '/org/gajim/dbus/RemoteObject'
INTERFACE = 'org.gajim.dbus.RemoteInterface'
SERVICE = 'org.gajim.dbus'

class GajimStatusPlugin(GenericPlugin):
    PLUGIN_NAME = "GajimStatus"
    PLUGIN_DESC = "Plugin to show Current player track in gajim"
    PLUGIN_VERSION = "0.1"
    PLUGIN_AUTHOR = "Unknown"
    PLUGIN_WEBSITE = "http://www.listen-project.org/ticket/700"

    def __init__(self):
        GenericPlugin.__init__(self)
        self.__lastsong = None
        self.sbus = dbus.SessionBus()
        self.autoconnect(Player, "new-song", self.on_new_song)
        
        self.__connected_to_gajim = False
        self.__check_gajim_presence()
        self.on_new_song(Player, Player.song)
        gobject.timeout_add(10000, self.__check_gajim_presence)

        gtk.quit_add(0,self.reset_status)

    def reset_status(self):
        if not self.__connected_to_gajim: return
        try: self.change_meth("")
        except: pass

    def __check_gajim_presence(self):
        try: 
            obj = self.sbus.get_object(SERVICE, OBJ_PATH)
        except:
            if self.__connected_to_gajim:
                self.__connected_to_gajim = False
                self.loginfo("disconnect from gajim")
        else:
            interface = dbus.Interface(obj, INTERFACE)
            self.__change_meth = interface.__getattr__("change_status")
            self.get_meth = interface.__getattr__("get_status")
            self.list_accounts = interface.__getattr__("list_accounts")
            if not self.__connected_to_gajim:
                self.__connected_to_gajim = True
                self.loginfo("connect to gajim")
                if self.__lastsong:
                    self.on_new_song(None, self.__lastsong)
        return False

    # Changes the status message for each account separately, avoiding changing
    # status of accounts. Therefore, it avoids Gajim of trying to connect not
    # connected accounts.
    # This should probably be fixed in Gajim's code by adding something like
    # change_status_message() rather than here. See the following bug report for
    # followups: http://trac.gajim.org/ticket/5039
    def change_meth(self, status_msg):
        for account in self.list_accounts():
            self.__change_meth(self.get_meth(account), status_msg, account)

    def on_new_song(self, player, song):
        self.__lastsong = song
        if not song or not self.__connected_to_gajim: return

        title = ""
        artist = ""
        album = ""
        
        if song.get_str("title"):
            title = song.get_str("title")
        if song.get_str("artist"):
            artist = song.get_str("artist")
        if song.get_str("album"):
            album = song.get_str("album")

        status_msg = "\xe2\x99\xaa %s: %s (%s) \xe2\x99\xaa" %(artist, title, album)
        self.loginfo("Change gajim status to \"%s\"",status_msg)
        try:
            self.change_meth(status_msg)
        except Exception, ex:
            self.loginfo("Status update failed: %s", str(ex))
            self.__check_gajim_presence()
            self.on_new_song(player,song)

