# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import gtk,gobject

import stock
import config
import const

from dbus_manager import ListenDBus
from hal import hal

from player import Player

from widget.player_ui import PlayerUI
from widget.tray import TrayIcon
from widget.source_ui import SourceUI
from widget.dialog import *
from widget.preference import PreferenceDialog,SourceDialog,ViewDialog
from library import library_wrapper
from audioscrobbler_manager import AudioScrobblerManager
import mmkeys_wrap

from widget.notify import Notify
from widget.osd import Osd

class Listen(gtk.Window):
    __obscured = False
    __gsignals__ = {
        "ready" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                ())}
    def __init__(self):
        
        #Start Audioscrobbler Session
        
        AudioScrobblerManager()
        gtk.Window.__init__(self,gtk.WINDOW_TOPLEVEL)
        gtk.window_set_default_icon_from_file(const.PIXMAP_DIR+"listen.png")
        
        self.set_title("Listen")
        
        if config.get("window","x")=="-1":
            self.set_position(gtk.WIN_POS_CENTER)
        else:
            self.move(int(config.get("window","x")),int(config.get("window","y")))

        try: self.resize(int(config.get("window","width")),int(config.get("window","height")))
        except:pass
        #self.resize(800,600)
        
                
        window_state = config.get("window","state")
        if window_state == "maximized" :
            self.maximize()
        if window_state == "normal":
            self.unmaximize()
        


        self.global_box = gtk.HPaned()
        #self.global_box.set_spacing(18)
        self.global_box.set_border_width(6)
        self.global_box.compute_position(-1,300,True)
        
        player = Player()
        
        self.source_ui = SourceUI(player)
        self.player_ui = PlayerUI(player)
        
        #self.global_box.pack_start(self.player_ui,False,False)
        #self.global_box.pack_start(self.source_ui,True,True)
        
        self.global_box.pack1(self.player_ui,False,False)
        self.global_box.pack2(self.source_ui,True,True)

        self.global_box.set_position(int(config.get("window","pos_global_pane")))
        
        #Attach accel from playlist
        self.add_accel_group(self.player_ui.playlist.ui.get_accel_group())
        
        vbox = gtk.VBox()
        vbox.pack_start(self.get_main_menu(),False,False)
        vbox.pack_start(self.global_box,True,True)
        self.add(vbox)

        self.connect("delete-event",self.quit)
        self.connect("configure-event",self.on_configure_event)
        
        player.connect("instant-new-song",self.update_title)
        helper.connect("changed",self.update_title)
        
        player.connect("played",self.swap_menu_play,player,_("Pause"),gtk.STOCK_MEDIA_PAUSE,"listen_tray_play.png")
        player.connect("paused",self.swap_menu_play,player,("Play"),gtk.STOCK_MEDIA_PLAY,"listen_tray_pause.png")
        
        self.tray = TrayIcon(self,player)
        self.tray.connect("control-action",self.player_ui.control,player)
        self.tray.connect("control-action",self.tray_control)

        self.osd = Osd(player,self.tray)
        self.notify = Notify(player,self.tray)
        self.dbus_service = ListenDBus(self,player)

        helper.connect("control-action",self.player_ui.control,player)
        helper.connect("control-action",self.tray_control)
        
        self.pos = None
        if config.get("window","view")=="3":
            config.set("window","view","2")
        self.change_view(int(config.get("window","view")))
        
        if config.get("window","view")=="2":
            width = config.get("window","width")
        else:
            width = config.get("window","pos_global_pane")
        try: self.resize(int(width),int(config.get("window","height")))
        except:pass
        
        if config.get("setting","start_trayicon")!="true" or config.get("setting","use_trayicon")!="true":
            gobject.idle_add(self.ready)
            gobject.timeout_add(1000, hal.load)
        if config.get("setting","use_trayicon")=="true" and self.tray.tray!=None:
            self.tray.tray.show_all()
            
    def ready(self):
        self.show_all()
        self.emit("ready")
        
        
    def tray_control(self, w, action):
        if action=="quit":
            self.force_quit()
        
    def quit(self,*param):
        self.tray.cacher()
        if config.get("setting","fermer_trayicon")=="false" or self.tray.tray==None:
            self.force_quit()
        return True
    
    def force_quit(self,*param):
        self.tray.cacher()
        self.tray.tray_image.set_from_file(const.PIXMAP_DIR+"/listen_tray_save.png")
        gobject.idle_add(self.__idle_quit)
            
    def __idle_quit(self,*param):
        self.tray.cacher()
        config.set("window","pos_global_pane","%d"%self.global_box.get_position())
        
        self.source_ui.save()
        self.player_ui.playlist.save()
        from library import library_wrapper
        library_wrapper.save()
        
        config.write(const.CONFIG_FILE)
        gtk.main_quit()
        print "Exit successful"
        
        
    def update_title(self,player_or_helper,song):
        #Don't song because she can be provide by 2 different source
        song =  self.player_ui.player.song
        if not song: return
        title = ""
        sep = ""
        if song.get_str("title"):
            title += sep+song.get_str("title")+" "
            sep=" - "
        if song.get_str("artist"):
            title += sep+song.get_str("artist")+" "
            sep=" - "
        if song.get_str("album"):
            title += song.get_str("album")
        self.set_title("Listen  "+"\xe2\x99\xaa "+title+" "+"\xe2\x99\xaa ")
        
    def on_configure_event(self,widget=None,event=None):
        #windows property
        if widget.get_property("visible") and config.get("window","view")!="3":
            if self.get_resizable():
                if config.get("window","view")=="2":
                    config.set("window","width","%d"%event.width)
                else :
                    config.set("window","pos_global_pane","%d"%event.width)
                config.set("window","height","%d"%event.height)
            config.set("window","x","%d"%event.x)
            config.set("window","y","%d"%event.y)

    def change_view(self,num_view):
        self.source_ui.show_all()    
        self.player_ui.box_playlist.show_all()  
        self.source_ui.set_no_show_all(True)  
        self.player_ui.box_playlist.set_no_show_all(True)
        if self.pos:
            self.set_keep_above(False)
            self.unfullscreen()
            gobject.idle_add(self.move,*self.pos)
            self.pos = None
            
        if num_view == 3: #Party mode
            self.pos = self.get_position()
            
            self.source_ui.show()
            self.player_ui.box_playlist.show()
            self.set_resizable(True)
            self.resize(int(config.get("window","width")),int(config.get("window","height")))
            self.global_box.set_position(int(config.get("window","pos_global_pane")))
            monitor = gtk.gdk.Screen.get_monitor_geometry(gtk.gdk.screen_get_default(), 0)
            
            
            self.set_keep_above(True)
            gobject.idle_add(self.fullscreen)
            
            
        elif num_view == 2 :#FULL VIEW  
            self.source_ui.show()
            self.player_ui.box_playlist.show()
            self.set_resizable(True)
            self.resize(int(config.get("window","width")),int(config.get("window","height")))
            self.global_box.set_position(int(config.get("window","pos_global_pane")))

            
        elif num_view == 1 :#NORMAL VIEW
            self.source_ui.hide()
            self.player_ui.box_playlist.show()
            self.set_resizable(True)
            self.resize(int(config.get("window","pos_global_pane")),int(config.get("window","height")))
            
        elif num_view == 0:#PLAYER  VIEW
            self.source_ui.hide()
            self.player_ui.box_playlist.hide()
            self.resize(int(config.get("window","pos_global_pane")),int(config.get("window","height")))
            self.set_resizable(False)
            self.set_size_request(300,-1)

        config.set("window","view","%d"%num_view)
        
    def open_file_win(self,w):
        l = library_wrapper.get_library("local")
        l.import_file()
        
    def open_folder_win(self,w):
        l = library_wrapper.get_library("local")
        l.import_folder()
        
    def reload_local_db(self,s):
        l = library_wrapper.get_library("local")
        l.reload_db()
        
        
    def open_podcast_win(self,w):
        WindowNewPodcast()
    
    def open_radio_win(self,w):
        WindowNewRadio()
    
    def open_about_dialog(self,w):
        ListenAbout()
    
    def open_pref_dialog(self,w):
        PreferenceDialog(self,self.osd)
    
    def control(self,action):
        name = action.get_name()
        self.player_ui.control(action,name)
        pass
              
    def new_playlist(self,s):
        from library.local import LocalPlaylist
        l = library_wrapper.get_library("local")
        pl = LocalPlaylist(l,_("New Playlist"))
        l.add_playlist(pl)
        gobject.idle_add(helper.edit_playlist,pl)
        
        
    def new_playlist_smart(self,s):
        from library import PL_SMART
        from library.local import LocalPlaylist
        from widget.smart_playlist import SmartPlaylistWindow
        l = library_wrapper.get_library("local")
        pl = LocalPlaylist(l,_("New Automatic Playlist"),PL_SMART)   
        win = SmartPlaylistWindow(pl,True)
        pl = win.run()
        if pl:
            l.add_playlist(pl)
            gobject.idle_add(helper.edit_playlist,pl)
    
        
    def download_cover(self,w):
        library_wrapper.get_library("local").download_all_cover()
    
    def load_playlist(self,s):
        WindowLoadPlaylist().run()
    
    def save_playlist(self,s):
        self.player_ui.playlist.save_to_library()
    
    
    def edit_source(self,s):
        SourceDialog(self)
        
    def edit_column(self,s):
        ViewDialog(self)
        
    def swap_menu_play(self,w,player,name,stock,image):
        action = self.ui.get_action("/MenuBar/Control/play")   
        action.set_property("stock-id",stock)
        action.set_property("label",name)
        self.tray.tray_image.set_from_file(const.PIXMAP_DIR+"/"+image)
        
    def get_main_menu(self):
        menu = """
        <ui>
          <menubar name="MenuBar">
            <menu action="Music">
              <menuitem action="AddFile"/>
              <menuitem action="AddPath"/>
              <separator />
              <menuitem action="ReloadDB"/>
              <menuitem action="DownloadCover"/>
              <separator />
              <menu action="Playlist">
                  <menuitem action="NewPlaylist"/>
                  <menuitem action="NewPlaylistSmart"/>
                  <menuitem action="LoadPlaylist"/>
                  <separator />
                  <menuitem action="SavePlaylist"/>
              </menu>
              <menuitem action="AddRadio"/>
              <menuitem action="AddPodcast"/>
              <separator />
              <menuitem action="Config"/>
              <menuitem action="OfflineMode"/>
              <separator />
              <menuitem action="Quit"/>
            </menu>
            <menu action="View">
              <menuitem action="Player"/>
              <menuitem action="PlayerPlaylist"/>   
              <menuitem action="Full"/>   
              <menuitem action="Party"/>
              <separator />
              <menu action="BrowserView">
                  <menuitem action="browserview0"/>
                  <menuitem action="browserview1"/>
                  <menuitem action="browserview2"/>
              </menu>
              <separator />
              <menuitem action="EditSource"/>
              <menuitem action="EditColumn"/>
            </menu>
            <menu action="Control">
              <menuitem action="play"/>
              <separator />
              <menuitem action="previous"/>
              <menuitem action="next"/>
              <separator />
              <menuitem action="shuffle"/>
              <menuitem action="repeat"/>
            </menu>
            %s
            <menu action="Help">
              <menuitem action="About"/>
            </menu>
          </menubar>
        </ui>
        """
        
        ag = gtk.ActionGroup('Listen')
        
        ag.add_actions([('Music', None, _('_Music')),
                      ('View', None, _('_View')),
                      ('Help', None, _('_Help')),
                      ('BrowserView', None, _('_Browser view')),
                      ('SongView', None, _('_Song view')),
                      ('Control', None, _('_Control')),
                      ('Playlist', None, _('_Playlist')),
                      ('MediaSource', None, _('Middle pane')),
                      ('AddFile', stock.IMPORT_FILE,None,None,"", self.open_file_win),
                      ('AddPath', stock.IMPORT_FOLDER, None, "<control>o","", self.open_folder_win),
                      ('ReloadDB',gtk.STOCK_REFRESH,_("Reload Library"),"","",self.reload_local_db),
                        
                      ('AddRadio', gtk.STOCK_NEW, _('New Internet Radio Station'), "<control>i","", self.open_radio_win),
                      ('AddPodcast', gtk.STOCK_NEW, _('_New Podcast feed'), "<control>p","", self.open_podcast_win),
                      
                      ('NewPlaylist', stock.SRC_PLAYLIST, _('_New Playlist'), "<control>n","", self.new_playlist),
                      ('NewPlaylistSmart', stock.SRC_PLAYLIST_SMART, _('New _Automatic Playlist...'), None,"", self.new_playlist_smart),
                      ('LoadPlaylist', None, _('Load from file...'), None,"", self.load_playlist),
                      ('SavePlaylist', gtk.STOCK_SAVE , _('Save Current Playlist'), "<control>s","", self.save_playlist),

                      ('About', gtk.STOCK_ABOUT, _('_About'), None,"", self.open_about_dialog),

                      ('Config', gtk.STOCK_PREFERENCES, _('P_references'), None,"", self.open_pref_dialog),
                      ('Quit', gtk.STOCK_QUIT, _('_Quit'), "<control>q","", self.force_quit),
                      ('play', gtk.STOCK_MEDIA_PLAY, _('_Play'), "<control>space","", self.control),
                      ('previous', gtk.STOCK_MEDIA_PREVIOUS, _('_Previous'), "<alt>Left","", self.control),
                      ('next', gtk.STOCK_MEDIA_NEXT, _('_Next'), "<alt>Right","", self.control),
                      ('shuffle', stock.SHUFFLE, _('_Shuffle'), "<control>u","", self.control),
                      ('EditSource',None,_('Source...'),None,"",self.edit_source),
                      ('EditColumn',None,_('Column...'),None,"",self.edit_column),
                      ("DownloadCover",None,_("Download missing cover"),None,"",self.download_cover)
                      
                     ])
                     
        browser_value = int(config.get("browser","view"))
        
        def on_change_browser(widget,radiobtn):
            config.set("browser","view","%d"%radiobtn.get_current_value())
                    
        ag.add_radio_actions([('browserview0', None, _('Artist and album'), None,None,0),
                                       ('browserview1', None, _('Genre and artist'), None,None,1),
                                       ('browserview2', None, _('Genre, artist and album'), None,None,2)],browser_value, on_change_browser)
                     
        def on_change_view(widget,radiobtn):
            self.change_view(radiobtn.get_current_value())
            

        ag.add_radio_actions([('Player', None, _('_Small Display'), "<control>d",None,0),
                              ('PlayerPlaylist', None, _('_Normal Display'), "<control>g",None,1),
                              ('Full', None, _('Full Display'), "<control>f",None,2),
                              ('Party', None, _('Party mode'), "<control>h",None,3)],int(config.get("window","view")), on_change_view)
                                                     
                           
        ag.add_toggle_actions([
           ('repeat', None, _('_Repeat'), "<control>r",None,None,config.getboolean("setting","repeat_mode")),
           ('OfflineMode',None,_('Offline Mode'),None,None,None,config.getboolean("setting","offline"))
                      ])
        b1 = ag.get_action("repeat")
        b1.connect_proxy(self.player_ui.playlist_control.btn_repeat)
        if config.getboolean("setting","repeat_mode"): b1.activate()

        b2 = ag.get_action("OfflineMode")
        def toggle_offline(w): 
            if w.get_active(): config.set("setting","offline","true")
            else: config.set("setting","offline","false") 
        b2.connect("toggled",toggle_offline)
        if config.getboolean("setting","offline"): b2.activate()

        def change(action,*pazoram):
            name = action.get_property("name")
            section = name[:name.index("_")]
            option = name[name.index("_")+1:]
            if action.get_active():
                config.set(section,option,"true")
            else:
                config.set(section,option,"false")

        
        self.ui = gtk.UIManager()
        self.ui.add_ui_from_string(menu%"")
        self.ui.insert_action_group(ag, -1)
        self.add_accel_group(self.ui.get_accel_group())
        
        return self.ui.get_widget("/MenuBar")


