# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import gobject
import gtk
import gnomevfs

import const
import utils
from song import Song   ,sType
from library import library_wrapper
from widget.misc import ScrolledWindow

from helper import helper
               
class WinDir(gtk.FileChooserDialog):
    def __init__(self,title=_("Import a folder in the library")):
        gtk.FileChooserDialog.__init__(self,title, None,
             gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER,
             (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))
             
        self.set_modal(True)
        import os
        self.set_current_folder(os.path.expanduser("~/"))

    def run(self):
        response = gtk.FileChooserDialog.run(self)
        folder = None
        if response == gtk.RESPONSE_OK:
             folder = self.get_filename()
             folder = self.get_uri()
        self.destroy()
        return folder

class WinFile(gtk.FileChooserDialog):
    def __init__(self,title=_("Import a file in the library")):    
        gtk.FileChooserDialog.__init__(self,title, None,
             gtk.FILE_CHOOSER_ACTION_OPEN,
             (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))
             
        self.set_modal(True)
        import os
        self.set_current_folder(os.path.expanduser("~/"))

    def run(self):
        response = gtk.FileChooserDialog.run(self)
        folder = None
        self.set_modal(True)
        if response == gtk.RESPONSE_OK:
             folder = self.get_filename()
             folder = self.get_uri()
        self.destroy()
        return folder
            
class WindowBase(gtk.Dialog):
    def __init__(self,title="",image=None,bouton = (
                        gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                        gtk.STOCK_OK, gtk.RESPONSE_ACCEPT) ):
        gtk.Dialog.__init__(self,title,None,
                 gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                     bouton
                 )

        self.set_position(gtk.WIN_POS_CENTER_ON_PARENT)
        self.set_resize_mode(False)
        self.set_border_width(6)
        self.set_modal(True)
        self.set_property("skip-taskbar-hint",True)
        self.set_has_separator(False)

        self.label_heading = gtk.Label("<span size=\"larger\"><b>"+title+"</b></span>")
        self.label_heading.set_alignment(0,0.5)
        self.label_heading.set_use_markup(True)

        self.box_contenu = gtk.VBox(False,6)
        self.box_contenu.pack_start(self.label_heading,False,False)
        #self.box_contenu.set_border_width(12)

        hbox = gtk.HBox(False,12)

        if image:
            if isinstance(image,str):
                wimage = gtk.Image()
                wimage.set_from_file(image)
                wimage.set_alignment(0,0)
            else:
                wimage = image
            a = gtk.Alignment(xalign=0.0)
            a.add(wimage)
            hbox.pack_start(a,False,False)

        hbox.pack_start(self.box_contenu,True,True)
        hbox.set_border_width(6)

        self.vbox.pack_start(hbox,False,False)
        self.vbox.set_spacing(6)
        self.set_resizable(False)

    def add_widget(self,widget,x=False,y=False):
        self.box_contenu.pack_start(widget,x,y)


class WindowMessage(WindowBase):
    def __init__(self,title,msg=None,image=None):
        if image == None:
            image = gtk.image_new_from_stock(gtk.STOCK_DIALOG_INFO,gtk.ICON_SIZE_DIALOG)
        WindowBase.__init__(self,title,image,(gtk.STOCK_CLOSE, gtk.RESPONSE_CANCEL) )

        self.set_property("skip-taskbar-hint",True)
        self.set_property('has-separator',False)
        if msg==None:msg=""
        if isinstance(msg,str) or isinstance(msg,unicode):
            label = gtk.Label(msg)
            label.set_alignment(0,0)
            self.add_widget(label)
        else:
            self.add_widget(msg)
        self.show_all()
        self.run()
        self.destroy()
        
class WindowError(WindowBase):
    def __init__(self,title,msg=None,image=None):
        if image == None:
            image = gtk.image_new_from_stock(gtk.STOCK_DIALOG_INFO,gtk.ICON_SIZE_DIALOG)
        WindowBase.__init__(self,title,image,(gtk.STOCK_CLOSE, gtk.RESPONSE_CANCEL) )

        self.set_property("skip-taskbar-hint",True)
        self.set_property('has-separator',False)
        if msg==None:msg=""
        if isinstance(msg,str) or isinstance(msg,unicode):
            wtext = gtk.TextView(gtk.TextBuffer())
            wtext.get_buffer().set_text(msg)
            wtext.set_editable(False)
            padding = 5
            wtext.set_property("pixels-above-lines",padding)
            wtext.set_property("pixels-below-lines",padding)
            wtext.set_property("right_margin",padding)
            wtext.set_property("left_margin",padding)
            self.add_widget(ScrolledWindow(wtext))
        else:
            self.add_widget(msg)
        self.show_all()
        self.run()
        self.destroy()
        
class WindowNewPodcast(WindowBase):
    def __init__(self):
        WindowBase.__init__(self,
                         _("New podcast feed"),
                         const.PIXMAP_DIR+"podcast_big.png"
                    )
        self.set_property("skip-taskbar-hint",True)
        self.set_property('has-separator',True)
        self.entry_uri = gtk.Entry()
        self.entry_uri.set_size_request(300,-1)
        self.label_heading.set_markup("<span size=\"larger\"><b>"+_("Podcast feed url :")+"</b></span>")

        self.add_widget(self.entry_uri)
        self.show_all()

        response = self.run()
        if response == gtk.RESPONSE_ACCEPT and self.entry_uri.get_text().strip() != "":
              uri = self.entry_uri.get_text().strip()
              if uri:
                  library_wrapper.get_library("local").download_podcast_feed(uri)
        self.destroy()
        
class WindowNewRadio(WindowBase):
    def __init__(self,song=None):
        if song:
            title = _("Edit web radio")            
        else:
            title = _("New web radio")
        WindowBase.__init__(self,title,const.PIXMAP_DIR+"playlist_radio_big.png")
        self.set_property("skip-taskbar-hint",True)
        self.set_property('has-separator',True)
        self.label_heading.set_markup("<span size=\"larger\"><b>"+_("Web radio name and url :")+"</b></span>")

        self.entry_name = gtk.Entry()
        self.entry_name.set_size_request(300,-1)
        self.entry_uri = gtk.Entry()
        self.entry_uri.set_size_request(300,-1)
        if song:
            self.entry_uri.set_text(song.get("uri"))
            self.entry_name.set_text(song.get("title"))
            
        self.add_widget(self.entry_name)
        self.add_widget(self.entry_uri)
        self.show_all()

        response = self.run()
        if response == gtk.RESPONSE_ACCEPT and self.entry_uri.get_text().strip() != "":
            uri = self.entry_uri.get_text().strip()
            name = self.entry_name.get_text().strip()
            l = library_wrapper.get_library("local")
            pl = l.get_pl_iradio()
              
            ext = utils.get_ext(uri)
            try:
                file_info = gnomevfs.get_file_info(uri,options=gnomevfs.FILE_INFO_FORCE_SLOW_MIME_TYPE)
            except:pass
            try: 
                print file_info.mime_type
                is_pls = (info.mime_type == "audio/x-scpls")
                is_m3u = (info.mime_type == "audio/x-mpegurl")
            except:
                is_pls = (ext == ".pls")
                is_m3u = (ext == ".m3u")
            if song:
                s = song
            else:
                s = Song()
            s.set_type(sType.LOCAL_WEBRADIO)
            s["title"] = name
            if is_pls:
                s["radiopls"] = uri
                s["is_pls"] = True
            if is_m3u:
                s["radiom3u"] = uri
                s["is_m3u"] = True
            s["uri"] = uri
            if song:
                helper.change_songs([s])
            else:
                pl.append([s])  
        self.destroy()
        
class WindowExportPlaylist(gtk.FileChooserDialog):
    def __init__(self,songs):
        self.songs = songs
        gtk.FileChooserDialog.__init__(self,_("Export playlist"), None,
             gtk.FILE_CHOOSER_ACTION_SAVE,
             (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_SAVE, gtk.RESPONSE_OK))
             
        self.set_modal(True)
        
        """f1 = gtk.FileFilter()
        f1.set_name(_("M3U files"))
        f1.add_mime_type("audio/mpegurl")
        f1.add_mime_type("audio/x-mpegurl")
        f1.add_mime_type("audio/m3u")
        f1.add_pattern("*.m3u")
        
        f2 = gtk.FileFilter()
        f2.set_name(_("PLS files"))
        f2.add_mime_type("audio/x-scpls")
        f2.add_pattern("*.pls")
        
        self.add_filter(f1)
        self.add_filter(f2)"""
        self.set_current_name("playlist.m3u")
        
        import os
        self.set_current_folder(os.path.expanduser("~/"))

    def run(self):
        response = gtk.FileChooserDialog.run(self)
        self.set_modal(True)
        if response == gtk.RESPONSE_OK:
             filename = self.get_filename()
             if utils.get_ext(filename) in [".m3u",".pls"]:
                 utils.export_playlist(self.songs,filename,utils.get_ext(filename,False))
             else:
                 pl_type = ".m3u"
                 filename = filename+"."+pl_type
                 utils.export_playlist(self.songs,filename,pl_type)
        
        self.destroy()
        
class WindowLoadPlaylist(gtk.FileChooserDialog):
    def __init__(self):
        
        gtk.FileChooserDialog.__init__(self,_("Load playlist"), None,
             gtk.FILE_CHOOSER_ACTION_OPEN,
             (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))
             
        self.set_modal(True)
        ffilter = gtk.FileFilter()
        ffilter.set_name(_("Playlist files"))
        ffilter.add_mime_type("audio/mpegurl")
        ffilter.add_mime_type("audio/x-mpegurl")
        ffilter.add_mime_type("audio/m3u")
        ffilter.add_mime_type("audio/x-scpls")
        ffilter.add_pattern("*.m3u")
        ffilter.add_pattern("*.pls")
        self.add_filter(ffilter)
        
        import os
        self.set_current_folder(os.path.expanduser("~/"))

    def run(self):
        response = gtk.FileChooserDialog.run(self)
        self.set_modal(True)
        if response == gtk.RESPONSE_OK:
            uri = self.get_uri()
            print uri
            name = utils.fsdecode(gnomevfs.get_file_info(str(uri)).name)
            name = name[:len(name)-len(utils.get_ext(name))]
            name = name[0].upper()+name[1:]
            uris = utils.parse_uris([uri])
            from song import Song, sType
            
            songs = [library_wrapper.get_song(uri) for uri in uris]
                    
            from library.local import LocalPlaylist
            l = library_wrapper.get_library("local")
            pl = LocalPlaylist(l,name)
            l.add_playlist(pl)
            pl.append(songs)
            gobject.idle_add(helper.edit_playlist,pl)
        
        self.destroy()
    
class ListenAbout(gtk.AboutDialog):
    def __init__(self):
        super(ListenAbout,self).__init__()
    
        self.set_modal(True)
        self.set_comments("""A music player for GNOME
        Copyright 2006 Mehdi Abaakouk <theli48@gmail.com>""")
        self.set_website("http://www.listen-project.org/")
        self.set_name("Listen Music Player")
        self.set_authors(const.AUTHORS.split("\n"))
        self.set_translator_credits(const.TRANSLATORS)
        self.set_version(const.VERSION)
        self.set_logo(gtk.gdk.pixbuf_new_from_file(const.PIXMAP_DIR+"listen_big.png"))
        self.show_all()
        self.run()
        self.destroy()
