# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###





import gtk
import gnomevfs
import gobject

try: 
    import dbus
    if getattr(dbus, 'version', (0,0,0)) >= (0,41,0):
        import dbus.glib
except: dbus_imported = False
else: dbus_imported=True

import utils

class Hal:
    def __init__(self):
        self.vol_monitor =  gnomevfs.VolumeMonitor()
        
        self.registered_volume = []
        if dbus_imported:
            try:self.bus = dbus.SystemBus()
            except:self.bus=None
            
        if dbus_imported and self.bus and utils.dbus_service_available(self.bus,'org.freedesktop.Hal'):
            self.dbus_hal = True
            self.vol_monitor.connect("volume-mounted",self.__volume_mounted_cb)
            self.vol_monitor.connect("volume-pre-unmount",self.__volume_pre_unmounted_cb)
            self.vol_monitor.connect("volume-unmounted",self.__volume_unmounted_cb)
        else:
            self.dbus_hal = False
            print "No Hal support"
                
    def load(self):
        pass
        
    
    def register_volume(self,check_func,mount_func,pre_umount_func,umount_func):
        self.registered_volume.append({
                                       "check":check_func,
                                       "mount":mount_func,
                                       "pre_umount":pre_umount_func,
                                       "umount":umount_func,
                                       "udis":[]
                                       })
                                       
        if self.dbus_hal:
            rv = self.registered_volume[-1:][0]    
            for volume in self.vol_monitor.get_mounted_volumes():
                device_udi = volume.get_hal_udi()
                if device_udi :
                    if rv["check"](self,volume,device_udi):
                        rv["udis"].append(device_udi)
                        rv["mount"](self,volume,device_udi)
        
        

    def __volume_mounted_cb(self,monitor,volume):
        device_udi = volume.get_hal_udi()
        if device_udi :
            for rv in self.registered_volume:
                if rv["check"](self,volume,device_udi):
                    rv["udis"].append(device_udi)
                    rv["mount"](self,volume,device_udi)
        return True
                
    def __volume_pre_unmounted_cb(self,monitor,volume):
        print "Pre umount"
        device_udi = volume.get_hal_udi()
        if device_udi :
            for rv in self.registered_volume:
                if device_udi in rv["udis"]:
                    rv["pre_umount"](self,volume,device_udi)
        return False
                
    def __volume_unmounted_cb(self,monitor,volume):
        print "Umount"
        device_udi = volume.get_hal_udi()
        if device_udi :
            for rv in self.registered_volume:
                if device_udi in rv["udis"]:
                    rv["umount"](self,volume,device_udi)
                    rv["udis"].remove(device_udi)
        return False
        
    def get_mount_point(self,udi):  
        prop = self.get_property(udi)
        if prop.has_key("volume.mount_point"):
            return prop["volume.mount_point"]
        else:
            return None
    
    def get_device_path(self,udi):  
        prop = self.get_property(device_udi)
        if prop.has_key("block.device"):
            return prop["block.device"]
        else:
            return None
        
    def get_property(self,device_udi):
        try:
            device_dbus_obj = self.bus.get_object("org.freedesktop.Hal" ,device_udi)
            return device_dbus_obj.GetAllProperties(dbus_interface="org.freedesktop.Hal.Device")
        except:
            return {}
      
hal = Hal()
                
        
        