###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###
import gtk
import gobject
import pango
import urllib
import xml.sax.saxutils
import random

import utils
import config
from db_manager import DBManager
from misc_widget import WindowBase
from misc_widget import MultiDragTreeview
from song import *



class Playlist(MultiDragTreeview):

    __gsignals__ = {
        "playlist-changed" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,)),
        "media-organizer-changed" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,))
    }
    def __init__(self,player):
        MultiDragTreeview.__init__(self)
        self.player = player



        self.model = gtk.ListStore(object,bool)
        self.set_model(self.model)
        self.renderer = gtk.CellRendererText()
        self.renderer.set_property("background-gdk",gtk.gdk.color_parse("#000000"))
        self.renderer.set_property("foreground-gdk",gtk.gdk.color_parse("#FFFFFF"))
        #self.renderer.set_fixed_size(250,-1)
        self.renderer.set_property("ellipsize",pango.ELLIPSIZE_END)
        self.renderer2 = gtk.CellRendererText()
        self.renderer2.set_property("background-gdk",gtk.gdk.color_parse("#000000"))
        self.renderer2.set_property("foreground-gdk",gtk.gdk.color_parse("#FFFFFF"))

        colonne = gtk.TreeViewColumn()
        colonne.pack_end(self.renderer2,False)
        colonne.pack_start(self.renderer,True)
        colonne.set_cell_data_func(self.renderer, self.__cell_data_func)
        colonne.set_cell_data_func(self.renderer2, self.__cell_data_func_duration)
        colonne.add_attribute(self.renderer, "background-set",1)
        colonne.add_attribute(self.renderer, "foreground-set",1 )
        colonne.add_attribute(self.renderer2, "background-set",1)
        colonne.add_attribute(self.renderer2, "foreground-set",1 )
        colonne.set_expand(True)


        self.append_column(colonne)
        self.set_headers_visible(False)
        self.get_selection().set_mode(gtk.SELECTION_MULTIPLE)

        self.set_enable_search(True)
        self.set_rules_hint(True)

        self.enable_model_drag_dest([("text/uri-list", 0, 0)], gtk.gdk.ACTION_COPY)
        """self.enable_model_drag_source(
            gtk.gdk.BUTTON1_MASK|gtk.gdk.SHIFT_MASK|gtk.gdk.CONTROL_MASK, [("text/uri-list", 0, 0)],
            gtk.gdk.ACTION_COPY)"""
        targets = [("text/uri-list", 0, 0)]
        self.drag_source_set(
            gtk.gdk.BUTTON1_MASK, targets,
            gtk.gdk.ACTION_COPY)

        self.connect("drag-data-received", self.on_drag_data_received)
        self.connect('drag-data-get', self.on_drag_data_get)
        self.connect("key-press-event", self.on_key_press)
        self.connect("row-activated",self.on_playlist_item_activated)
        self.connect("popup-menu",self.__popup_menu)
        self.set_search_equal_func(self.on_song_search)

        if config.get("setting","repeat_mode")=="true":
            self.__repeat = True
        else:
            self.__repeat = False

        self.current_item = -1
        self.total_duration = 0

        self.menu = self.get_menu()
        self.populate()

    def __popup_menu(self,widget):
        self.menu.popup(None,None,None,0,gtk.get_current_event_time())


    def get_menu(self):
        menu_ui = """
        <ui>
            <popup name="PlaylistMenu">
              <menuitem action="Play"/>
              <menuitem action="Delete"/>
              <menuitem action="Crop"/>
              <separator/>
              <menuitem action="Random"/>
              <menuitem action="Clear"/>
            </popup>
        </ui>
        """

        """

              <menu action="Sort">
                  <menuitem action="Title"/>
                  <menuitem action="Artist"/>
                  <menuitem action="Album"/>
                  <menuitem action="Tracknr"/>
              </menu>

        """
        self.uimanager = gtk.UIManager()
        self.uimanager.add_ui_from_string(menu_ui)
        accelgroup = self.uimanager.get_accel_group()

        actiongroup = gtk.ActionGroup('Listen')
        actiongroup.add_actions([('Play', gtk.STOCK_MEDIA_PLAY, _('_Play'), None,
                                         _('Play this song'), self.play_selected)])
        actiongroup.add_actions([('Delete', gtk.STOCK_DELETE, _('_Delete'), None,
                          _('Delete this song'), self.remove_selected)])
        actiongroup.add_actions([('Crop', gtk.STOCK_DELETE, _('C_rop'), None,
                          _('Crop'), self.crop_selected)])
        actiongroup.add_actions([('Random', gtk.STOCK_CONVERT, _('_Shuffle'), None,
                          _('Shuffle'), self.shuffle)])
        actiongroup.add_actions([('Clear', gtk.STOCK_CLEAR, _('_Clear'), None,
                          _('Clear'), self.clear)])
        actiongroup.add_actions([('Sort', gtk.STOCK_SORT_ASCENDING, _('_Sort'), None,
                          _('Sort'), None)])

        self.uimanager.insert_action_group(actiongroup, 1)
        #gobject.idle_add(self.get_toplevel().add_accel_group,accelgroup)

        return self.uimanager.get_widget("/PlaylistMenu")



    def save_to_db(self,id=0):
        DBManager.clear_playlist(id)
        songs = list([self.model[i][0] for i in range(0,len(self.model))])
        for song in songs:
            #Check song is in DB
            if song.get_property("id")!=None:
                DBManager.add_song_to_playlist(song,id)

    def populate(self):
        self.model.clear()
        songs = DBManager.get_songs_from_playlist(0)
        for song in songs:
            self.total_duration += song.get_int("duration")
            self.model.append((song,0))
            if config.get("player","last_played")!="" and int(config.get("player","last_played"))==song.get_property("id"):
                self.set_current_item(len(self.model)-1)

        self.update_total_duration()


    def on_key_press(self, widget, event):
        if event.keyval == gtk.gdk.keyval_from_name("m") and event.state & gtk.gdk.CONTROL_MASK == gtk.gdk.CONTROL_MASK:
            #self.center()
            return True
        elif event.keyval == gtk.gdk.keyval_from_name("Delete"):
            self.remove_selected()
            return True

    def on_playlist_item_activated(self, treeview, path, view_column):
        self.play_selected()

    def play_selected(self,btn=None):
        model, rows = self.get_selection().get_selected_rows()
        #print rows[0][0]
        self.player.play(self.model.get_value(self.model.get_iter(rows[0]),0))
        self.set_current_item(rows[0][0])


    """""""""""""""""""""""
    FUNC DEFINITION BOUTON
    """""""""""""""""""""""
    def save_current_playlist(self,btn):
        if len(self.model)>0:
            dialog_save = WindowBase(_("Save current playlist"),config.PIXMAP_DIR+"/playlist_save.png")
            hbox = gtk.HBox(0,6)
            hbox.pack_start(gtk.Label(_("Name")+" :"))
            self.entry= gtk.Entry()
            self.entry.set_activates_default(True)

            hbox.pack_start(self.entry)
            dialog_save.add_widget(hbox)
            dialog_save.show_all()
            result = dialog_save.run()
            if result == gtk.RESPONSE_ACCEPT:
                id = DBManager.add_playlist(self.entry.get_text())
                self.save_to_db(id)
                self.emit("media-organizer-changed",None)

            dialog_save.destroy()
        else:
            dailog = WindowBase(_("Save current playlist"),config.PIXMAP_DIR+"/playlist_save.png",(gtk.STOCK_CLOSE, gtk.RESPONSE_CANCEL))
            label = gtk.Label(_("Playlist is empty, you must fill it to save it."))
            label.set_alignment(0,0.5)
            dailog.add_widget(label)
            dailog.show_all()
            result = dailog.run()
            dailog.destroy()

    def shuffle(self,btn):

        if self.current_item!=-1:
            self.model.swap(self.model.get_iter(self.current_item),self.model.get_iter(0))
            self.current_item = 0

        list_index = range(0,len(self.model))
        random.shuffle(list_index)

        for index in list_index:
            if self.current_item==-1 or (list_index[index]!=0 and index!=0):
                self.model.swap(self.model.get_iter(list_index[index]),self.model.get_iter(index))



    def repeat(self,btn):
        self.__repeat = not  self.__repeat
        if self.__repeat:
            config.set("setting","repeat_mode","true")
        else:
            config.set("setting","repeat_mode","false")

    def clear(self,btn):
        self.current_item = -1
        self.model.clear()
        self.total_duration = 0
        self.update_total_duration()

    def add(self,uri,pos=False,play=False):
        song = DBManager.get_song_by_uri(uri)
        return self.add_song(song,pos,play)


    def add_song(self,song,pos=False,play=False):

        #Clear playlist if no enqueue when play a new file
        if config.get("player","enqueue")!="true" and play:
            self.model.clear()
            self.current_item = -1

        if song == None:
            return False;
        self.total_duration += song.get_int("duration")
        if pos is False:
            self.model.append((song, False))
        else:
            self.model.insert(pos,(song, False))
            if self.current_item >= pos:
                self.current_item += 1
        self.update_total_duration()
        if play:
            self.player.play(song)
            if pos is False:
                self.set_current_item(len(self.player.playlist.model)-1)
            else:
                self.set_current_item(pos)
        return True

    def remove_selected(self,btn=None):
            model, rows = self.get_selection().get_selected_rows()
            rows.reverse()
            for row in rows:
                self.remove(row)
            return True

    def crop_selected(self,btn=None):
            model, rows = self.get_selection().get_selected_rows()
            list_rows_to_delete = []
            for i in range(0,len(self.model)):
                if (i,) not in rows:
                    list_rows_to_delete.append(i)
            list_rows_to_delete.reverse()
            for row in list_rows_to_delete:
                self.remove((row,))
            return

    def remove(self,pos):
        if pos[0]>=len(self.model): return
        iter = self.model.get_iter(pos)
        song = self.model[iter][0]
        self.total_duration -= song.get_int("duration")
        self.model.remove(iter)

        if self.current_item == pos[0]:
            self.current_item = -1
        elif self.current_item > pos[0]:
            self.current_item -= 1
        else:
            pass

        self.update_total_duration()

    def update_total_duration(self):
        self.player.playlist_total_time.set_markup("<b>"+_("Playlist")+"</b>"+" <span><i>("+_("Total time")+" : "+utils.duration_to_string(self.total_duration)+")</i></span>")

    """
      FUNC GESTION NAVIGATION
    """
    def get_next_song(self):
        if len(self.model)<=0:
            if config.get("setting","empty_random")=="true":
                song = DBManager.get_random_song()
                self.emit("playlist-changed",song)
                return song
            else:
                return None
        if not self.__repeat and self.current_item==len(self.model)-1:
            return None
        if self.current_item >= 0:
            self.model.set_value(self.model.get_iter(self.current_item),1,False)
        if self.current_item < len(self.model)-1:
            self.current_item +=1
        else:
            self.current_item = 0
        self.model.set_value(self.model.get_iter(self.current_item),1,True)
        self.emit("playlist-changed",self.model.get_value(self.model.get_iter(self.current_item),0))
        self.scroll_to_cell(self.current_item)
        return self.model.get_value(self.model.get_iter(self.current_item),0)


    def get_previous_song(self):
        if len(self.model)<=0:
            if config.get("setting","empty_random")=="true":
                song = DBManager.get_random_song()
                self.emit("playlist-changed",song)
                return song
            else:
                return None
        if not self.__repeat and self.current_item==0:
            return None
        if self.current_item >= 0:
            self.model.set_value(self.model.get_iter(self.current_item),1,False)
        if self.current_item > 0 :
            self.current_item -=1
        else:
            self.current_item = len(self.model)-1
        self.model.set_value(self.model.get_iter(self.current_item),1,True)
        self.emit("playlist-changed",self.model.get_value(self.model.get_iter(self.current_item),0))
        self.scroll_to_cell(self.current_item)
        return self.model.get_value(self.model.get_iter(self.current_item),0)

    def set_current_item(self,item):
        if self.current_item >= 0 :
            self.model.set_value(self.model.get_iter(self.current_item),1,False)
        self.current_item = item
        self.model.set_value(self.model.get_iter(self.current_item),1,True)
        self.emit("playlist-changed",self.model.get_value(self.model.get_iter(self.current_item),0))
        self.scroll_to_cell(self.current_item)


    def on_song_search(self,model, column, key, iterator):
        title = model.get_value(iterator, 0).sprint("title")
        if title.lower().find(key.lower()) == 0:
          return False
        return True

    """""""""""""""""""""""
        CELL RENDER FUNC
    """""""""""""""""""""""
    def __cell_data_func(self, column, cell, model, iter):
        song = model.get_value(iter, 0)

        text  = "<span size=\"small\"><b>"
        text +=  utils.xmlescape(song.sprint("title"))
        text += "</b></span><span size=\"small\">"
        sep = "\n"
        if not song.get_property("podcast"):
            if song.sprint("artist")!="":
                text += sep+"<i>"+utils.xmlescape(song.sprint("artist"))+"</i>"
                sep = " - "
            if song.sprint("album")!="":
                text += sep+utils.xmlescape(song.sprint("album"))
        else:
            """ Podcast """
            if song.sprint("podcast_feed_title")!="":
                text += sep+"<i>"+utils.xmlescape(song.sprint("podcast_feed_title"))+"</i>"
                sep = " - "
            if song.sprint("date")!="":
                text += sep+utils.xmlescape(song.sprint("date"))

        text += "</span>"
        cell.set_property("markup", text)

    def __cell_data_func_duration(self, column, cell, model, iter):
        song = model.get_value(iter, 0)
        text = "<span size=\"small\">%2d:%02d</span>" % (song.get_int("duration")/60000, (song.get_int("duration")/1000)%60)  +"\n "
        cell.set_property("markup", text)

    """""""""""""""""""""""""""
        FUNC DRAG DROP
    """""""""""""""""""""""""""
    def on_drag_data_get(self,treeview, context, selection, info, timestamp):
        model, rows = self.get_selection().get_selected_rows()
        list_uri = []
        list_song = []
        for row in rows:
            song = model.get_value(model.get_iter(row[0]),0)
            list_song.append(song)
            uri = song.get_property("uri")
            uri = utils.convert_to_uri(uri)
            list_uri.append(uri)

        self.get_toplevel().last_drag_drop = list_song
        selection.set_uris(list_uri)

    def on_drag_data_received(self,treeview, context, x, y, selection, info, timestamp):
        #print "PLAYLIST : drop data received"
        drop_info = treeview.get_dest_row_at_pos(x, y)

        model = treeview.get_model()

        nb_element = len(model)
        if selection.target=="text/uri-list":
            if context.get_source_widget()!=None and context.get_source_widget()==self:
                position = gtk.TREE_VIEW_DROP_AFTER
                model, rows = treeview.get_selection().get_selected_rows()
                if len(rows) < 1:
                    return
                rows = [row[0] for row in rows]

                if drop_info:
                    new_pos, position = drop_info
                    new_pos = new_pos[0]
                else:
                    new_pos = len(model)-1

                if new_pos < rows[0]:
                    rows.reverse()

                i=0
                for row in rows:
                    row += i
                    iter = model.get_iter(row)
                    is_current_item = model.get_value(iter,1)
                    new_iter = model.get_iter(new_pos)
                    if position == gtk.TREE_VIEW_DROP_BEFORE or position == gtk.TREE_VIEW_DROP_INTO_OR_BEFORE:
                        self.model.move_before(iter, new_iter);
                    if position == gtk.TREE_VIEW_DROP_AFTER or position == gtk.TREE_VIEW_DROP_INTO_OR_AFTER:
                        self.model.move_after(iter, new_iter);
                    if new_pos < rows[0]:
                        if self.current_item>new_pos and self.current_item != -1:
                            self.current_item +=1
                        i += 1
                    else:
                        if self.current_item<new_pos and self.current_item != -1:
                            self.current_item -=1
                        i -= 1
                    if is_current_item:
                        self.current_item = new_pos

            elif context.get_source_widget()==None :
                pos = self.current_item
                if drop_info:
                    pos, position = drop_info
                    pos = pos[0]
                    new_pos = pos
                    if position == gtk.TREE_VIEW_DROP_AFTER:
                        new_pos += 1
                else:
                    new_pos = len(model)
                #print "URIS ", selection.data
                #self.set_model(None)
                uris = []
                for uri in selection.get_uris():
                    uris.append(uri)
                uris.reverse()
                for uri in uris:
                    uri = urllib.unquote(uri)
                    newpos = self.add_uri(uri,new_pos)

                #self.set_model(self.model)
                if pos>=0 and len(self.model)>0:
                    self.scroll_to_cell(pos)
            else:
                pos = self.current_item
                if drop_info:
                    pos, position = drop_info
                    pos = pos[0]
                    new_pos = pos
                    if position == gtk.TREE_VIEW_DROP_AFTER:
                        new_pos += 1
                else:
                    new_pos = len(model)
                #print "URIS ", selection.data
                #self.set_model(None)
                list_song = self.get_toplevel().last_drag_drop
                list_song.reverse()
                for song in list_song:
                    newpos = self.add_song(song,new_pos)

                #self.set_model(self.model)
                if pos>=0 and len(self.model)>0:
                    self.scroll_to_cell(pos)
                self.get_toplevel().last_drag_drop = []


    def add_uri(self,uri,new_pos):
        #print "AJOUT DE " , uri ," A LA POS = ", new_pos
        if utils.get_ext(uri) not in READ_EXTENTIONS and utils.get_ext(uri) not in PLAYLIST_EXTENTION:
            return new_pos

        protocol = utils.get_protocol(uri)
        if protocol=="file://":
            path = utils.get_path(uri)
            if os.path.exists(path) and os.path.isdir(path):
                list = os.listdir(path)
                for filename in list:
                    if os.path.isfile(path+"/"+filename):
                        new_pos = self.add_uri("file://"+path+"/"+filename,new_pos)
                return new_pos

        if utils.get_ext(uri) in PLAYLIST_EXTENTION:
            list_path = utils.import_playlist(utils.get_path(uri))
            for path in list_path:
                new_pos = self.add_uri("file://"+path, new_pos)
            return new_pos

        if 0<=new_pos and new_pos<len(self.model):
            iter = self.model.get_iter(new_pos)
            self.add(uri,new_pos)
            new_pos+=1
        else:
            self.add(uri)
            new_pos+=1

        return new_pos
