#!/usr/bin/env python
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

""" for testing """
if False:
    import utils
    utils.ctypes_init()

import gst
import gtk
import gnomevfs
import utils
import gobject
import sys
import config
import os
from song import Song

#Configuration
mp3_quality = {
    "cbr": (64, 96, 128, 192, 256),
    "abr": (64, 96, 128, 192, 256),
    "vbr": (9, 7, 5, 3, 1),
}
mp3_mode = {
    "cbr" : (0,"bitrate"),
    "abr" : (3,"vbr-mean-bitrate"),
    "vbr" : (4,"vbr-quality")
}
ogg_quality =  (0,0.2,0.4,0.6,0.8)

FORMAT_PERCENT_SCALE = 10000
CLOCK_SPEED = 15
"""
Encode file as a background task
"""
class Transcoder(gobject.GObject):
    __gsignals__ = {
        "finish" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_STRING,))
    }
    def __init__(self,song=None,format="mp3",quality=3,mode="cbr"):
        gobject.GObject.__init__(self)
        self.__id_pad = None

        extention="."+format
        self.song = song
        input_file = self.song.get_property("uri")

        self.output_file = config.TMP_PATH + utils.get_filename(input_file[:input_file.rindex(".")] + extention)

        if os.path.exists(self.output_file):
            os.unlink(self.output_file)
        # Add protocol for gnomevfs
        self.output_file = "file://"+self.output_file
        #self.output_file = "file:///tmp/test.mp3"

        #Make the new song instance
        self.new_song = Song()
        self.new_song.read_from_song(self.song)
        #set as no db song
        self.new_song.id=None
        #change with future file
        self.new_song.set_property("uri",self.output_file)


        self.pipeline = gst.Pipeline()
        src = gst.element_factory_make("gnomevfssrc")
        src.set_property("location",input_file)
        dbin = gst.element_factory_make("decodebin")
        ident = gst.element_factory_make("identity")
        audioconvert = gst.element_factory_make("audioconvert")
        sink = gst.element_factory_make("gnomevfssink")
        sink.set_property("location", self.output_file)
        if format=="mp3":
            encoder =  gst.element_factory_make("lame")
            encoder.set_property("quality",2)
            encoder.set_property("xingheader","true")

            encoder.set_property("vbr", mp3_mode[mode][0])
            encoder.set_property(mp3_mode[mode][1], mp3_quality[mode][quality])
            #self.add(encoder)

        if format=="ogg":
            encoder =  gst.element_factory_make("vorbisenc")
            if quality is not None:
                    encoder.set_property("quality", ogg_quality[quality] )
            #

        if format=="flac":
            encoder = gst.element_factory_make("flacenc")

        self.pipeline.add(src)
        self.pipeline.add(dbin)
        self.pipeline.add(audioconvert)
        self.pipeline.add(encoder)
        self.pipeline.add(sink)
        self.pipeline.get_bus().add_signal_watch()


	""" for the pipeline position bug """
	self.encoder = encoder

        src.link(dbin)
        audioconvert.link(encoder)
        encoder.link(sink)



        def __message(bus,message):
            if message.type == gst.MESSAGE_CLOCK_PROVIDE:
                clock = self.pipeline.get_clock()
                internal,external,rate_num,rate_denum = clock.get_calibration()
                print clock.get_calibration()
                clock.set_calibration(internal,external,rate_num*long(CLOCK_SPEED),rate_denum)
                self.pipeline.set_clock (clock)
            if message.type == gst.MESSAGE_EOS:
                self.stop()

        def _new_decoded_pad_cb(dbin, pad, is_last):
            if not "audio" in pad.get_caps().to_string():
                return
            pad.link(audioconvert.get_pad("sink"))

        dbin.connect("new-decoded-pad", _new_decoded_pad_cb)
        self.pipeline.get_bus().connect('message', __message)

    def get_state(self):
        status,state,_state = self.pipeline.get_state()
        return state

    def is_finish(self):
        if self.get_state() == gst.STATE_PLAYING:
            return False
        else:
            return True

    def get_position(self):
        if gst.STATE_NULL != self.get_state():
	    """ Use a encoder instead of pipeline because filesink and gnome vfs sink return wrong value in gstreamer 0.10.5"""
            try: p = self.encoder.query_position(gst.FORMAT_TIME)[0]
            except gst.QueryError: p = 0
            p //= gst.MSECOND
            return p
        return 0

    def get_duration(self):
        if self.get_state() != gst.STATE_NULL:
            try:
                query = gst.query_new_duration(gst.FORMAT_TIME)
                if self.encoder.query(query):
                    total = query.parse_duration()[1]
                else: return 0
            except gst.QueryError: total = 0
            total //= gst.MSECOND
            #self.debug("get_length",total)
            return total
        else:
            #self.debug("get_length",0)
            return 0

    def get_progress(self):
        """
        Gstreamer 0.10 always return QueryError whiI don't know why :(
        """
	
        try: value = self.get_position()*100/float(self.new_song.get_int("duration"))
        except: return 0
        else: return value
	


        """
        try: value = self.encoder.query_position(gst.FORMAT_PERCENT)[0]
        except gst.QueryError: value = 0
        return float(value) / float(FORMAT_PERCENT_SCALE)
        """

    def start(self):
        self.pipeline.set_state(gst.STATE_PLAYING)

    def stop(self):

        #Write tags informations
        if self.is_finish():
            #No needed write tag
            #New audioconvert in gstreamer 0.10 transfert automaticily
            #self.new_song.write_to_file()
            self.emit("finish",self.output_file)
        else:
            self.pipeline.set_state(gst.STATE_NULL)
        #del self.pipeline
        print "finish"

    def get_new_song(self):
        return self.new_song


if __name__ == "__main__":

    import signal
    signal.signal(signal.SIGINT, signal.SIG_DFL)

    song = Song()
    song.set_property("uri","file:///home/prout/Musiques/RadioHead/Kid_A/02 - RADIOHEAD (KID A) - KID A.mp3")
    song.read_from_file()
    t = Transcoder(song)
    #t.start()
    def control():
        print t.pipeline.get_state()
        print "> ",t.get_progress(),"%"
	print t.get_duration()
        print t.get_position()
        #print t.pipeline.get_state()==gst.STATE_PLAYING

        return True
    gobject.timeout_add(1000,control)

    #print dir(t.pipeline)
    t.start()

    gtk.main()
