###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gtk
import md5

import stock
import config
from media_source import *
from misc_widget import get_scrolled_window

class PreferenceDialog(gtk.Window):

    def __init__(self,parent,osd):
        gtk.Window.__init__(self)
        """,_("Preferences"),None,
                 gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                     (gtk.STOCK_CLOSE, gtk.RESPONSE_CANCEL,)
                 )"""
        self.set_title(_("Preferences"))
        self.set_resizable(False)
        self.set_position(gtk.WIN_POS_CENTER_ON_PARENT)
        self.set_border_width(12)
        self.set_property("skip-taskbar-hint",True)

        self.set_transient_for(parent)
        self.connect('delete-event', self.__hide_pref)
        #w.connect('show', self.__show_panel)

        '''self.set_position(gtk.WIN_POS_CENTER_ON_PARENT)
        self.set_resize_mode(False)
        self.set_resizable(False)
        self.set_modal(True)
        self.set_has_separator(False)'''

        self.osd = osd
        self.win_parent = parent



        vbox_general = gtk.VBox(False,2)
        vbox_general.set_border_width(12)
        vbox_general.pack_start(self.get_title_label(_("Startup")),False,False)
        vbox_general.pack_start(self.make_check_box(_("Show splashscreen"),"setting","splash"),False,False)
        vbox_general.pack_start(self.make_check_box(_("Start minimized"),"setting","start_trayicon"),False,False)
#        vbox_general.pack_start(self.make_check_box(_("Play lastest played song"),"player","play_on_startup"),False,False)

        vbox_general.pack_start(self.get_title_label(_("Behavior")),False,False)
        vbox_general.pack_start(self.make_check_box(_("Enable trayicon"),"setting","use_trayicon"),False,False)
        vbox_general.pack_start(self.make_check_box(_("Minimized to systray"),"setting","reduire_trayicon"),False,False)
        vbox_general.pack_start(self.make_check_box(_("Close to systray"),"setting","fermer_trayicon"),False,False)
        import gst
        if gst.pygst_version >= (0, 10, 3):
            vbox_general.pack_start(self.make_check_box(_("Enable visualisation (Use many CPU) (Need restart)"),"player","enable_vis"),False,False)

        vbox_general.pack_start(self.make_check_box(_("Play a random file when the playlist is empty"),"setting","empty_random"),False,False)
        vbox_general.pack_start(self.make_check_box(_("Don't clear the playlist when play a new song"),"player","enqueue"),False,False)

        #vbox_general.pack_start(self.get_title_label(_("Crossfade")),False,False)
        #vbox_general.pack_start(self.make_bar("player","crossfade_time",100,4000,50),False,False)

        vbox_general.pack_start(self.get_title_label(_("Wikipedia &amp; lyrics fonts")),False,False)
        font = gtk.FontButton(config.get("setting", "web_font"))
        font.connect('font-set', self.font_set)
        vbox_general.pack_start(font,False,False)

        vbox_audioscrobller = gtk.VBox(False,6)
        vbox_audioscrobller.set_border_width(12)
        vbox_audioscrobller.pack_start(self.get_title_label(_("Audioscrobbler")),False,False)
        vbox_audioscrobller.pack_start(self.make_check_box(_("Enable Audioscrobbler support"),"audioscrobbler","enable"),False,False)

        label = gtk.Label(_("Username"))
        label.set_alignment(0,0.5)
        t = gtk.Table(2,2)
        t.attach(label,0,1,0,1,gtk.FILL,gtk.FILL)

        label = gtk.Label(_("Password"))
        label.set_alignment(0,0.5)
        t.attach(self.make_entry(_("Username"),"audioscrobbler","username"),1,2,0,1,gtk.EXPAND|gtk.FILL,gtk.SHRINK)
        t.attach(label,0,1,1,2,gtk.FILL,gtk.FILL)
        entry = self.make_entry(_("Password"),"audioscrobbler","password")
        entry.set_invisible_char("*")
        entry.set_visibility(False)
        t.attach(entry,1,2,1,2,gtk.EXPAND|gtk.FILL,gtk.SHRINK)
        t.set_row_spacings(2)
        t.set_col_spacings(2)
        vbox_audioscrobller.pack_start(t,False,False)

        vbox_podcast = gtk.VBox(False,2)
        vbox_podcast.set_border_width(12)
        vbox_podcast.pack_start(self.get_title_label(_("Podcast behavior")),False,False)
        vbox_podcast.pack_start(self.make_check_box(_("Refresh on startup"),"podcast","startup"),False,False)
        vbox_podcast.pack_start(self.make_number(_("Refresh every"),_("minute"),"podcast","time_refresh"),False,False)
        vbox_podcast.pack_start(self.get_title_label(_("Podcast directory")),False,False)
        vbox_podcast.pack_start(self.make_file("podcast","folder"),False,False)

        vbox_webservice = gtk.VBox(False,2)
        vbox_webservice.set_border_width(12)
        vbox_webservice.pack_start(self.get_title_label(_("Web service filter")),False,False)
        vbox_webservice.pack_start(self.get_label(_("Skipped words for the web service queries")),False,False)
        vbox_webservice.pack_start(self.make_list_edit("webservice","filter"),True,True)

        notebook = gtk.Notebook()
        notebook.append_page(vbox_general,self.get_tab(_("General"),gtk.STOCK_PREFERENCES))
        notebook.append_page(vbox_podcast,self.get_tab(_("Podcast"),stock.PREF_PODCAST))
        notebook.append_page(vbox_audioscrobller,self.get_tab(_("Audioscrobbler"),stock.PREF_LASTFM))
        notebook.append_page(self.osd.PluginPreferences(),self.get_tab(_("OSD"),stock.PREF_OSD))
        notebook.append_page(vbox_webservice,self.get_tab(_("Web service"),gtk.STOCK_NETWORK))

        notebook.set_current_page(0)
        notebook.connect("switch-page",self.on_switch_page)

        btn = gtk.Button(stock=gtk.STOCK_CLOSE)
        btn.connect("clicked",self.__hide_pref)
        box_btn = gtk.HBox()
        box_btn.pack_end(btn,False,False)

        self.add(gtk.VBox(spacing=12))
        self.child.pack_start(notebook)
        self.child.pack_start(box_btn)
        #self.add(notebook)

        #self.run()
        #config.write(config.CONFIG_FILE)
        #self.osd.pref_hide_panel()
        #self.destroy()

    def make_list_edit(self,section,attribut):
        def save():
            str = ""
            filters = [row[0] for row in self.model_filter]
            config.set(section,attribut,"<###>".join(filters))

        def on_edit(cellrenderertext, path, new_text):
            old_text = self.model_filter[path][0]
            self.model_fitler[path][0] = new_text.lower()
            save()

        box = gtk.HBox(False,12)
        self.model_filter = gtk.ListStore(str)
        tree = gtk.TreeView(self.model_filter)
        cell = gtk.CellRendererText()
        cell.set_property("editable",True)
        cell.connect("edited",on_edit)
        tree.insert_column_with_attributes(0,_("Filter"),cell,text=0)

        vbox = gtk.VBox(False,6)
        btn_add = gtk.Button(stock=gtk.STOCK_ADD)
        btn_remove = gtk.Button(stock=gtk.STOCK_REMOVE)

        def add(w):
            self.model_filter.append((_("New filter"),))
            tree.get_selection().select_path(len(self.model_filter))

        def remove(w):
            model,iter = tree.get_selection().get_selected()
            if iter:
               del self.model_filter[self.model_filter.get_path(iter)]
               save()

        btn_add.connect("clicked",add)
        btn_remove.connect("clicked",remove)

        vbox.pack_start(btn_add,False,False)
        vbox.pack_start(btn_remove,False,False)

        box.pack_start(get_scrolled_window(tree),True,True)
        box.pack_start(vbox,False,False)
        filters = config.get(section,attribut).split("<###>")
        for filter in filters:
            self.model_filter.append((filter,))
        return box




    def font_set(self,font):
        config.set("setting", "web_font", font.get_font_name())

    def __hide_pref(self,widget, event=None):
        for source in self.win_parent.media_organizer.list_source:
            if isinstance(source,MLBrowserSource) or \
                isinstance(source,IPodSource) :
                source.widget.treeviews["songs"].set_visible_column()
            if isinstance(source,LocalPlaylistSource) or \
                isinstance(source,IPodPlaylistSource) :
                source.view.set_visible_column()


        config.write(config.CONFIG_FILE)
        self.osd.pref_hide_panel()
        self.destroy()

    def on_switch_page(self,notebook,page, page_num ):
        if page_num==3:
            self.osd.pref_show_panel()
        else:
            self.osd.pref_hide_panel()

    def get_tab(self,label,stock):
        tab = gtk.HBox(False,6)
        image = gtk.Image()
        image.set_from_stock(stock, gtk.ICON_SIZE_MENU)
        tab.pack_start(image,False,False)
        tab.pack_start(gtk.Label(label),False,False)
        tab.show_all()
        return tab


    def get_title_label(self,str):
        label = gtk.Label("<b>"+str+"</b>")
        label.set_use_markup(True)
        label.set_alignment(0,1)
        label.set_size_request(0,22)
        return label
    def get_label(self,str):
        label = gtk.Label("<i>"+str+"</i>")
        label.set_use_markup(True)
        label.set_alignment(0,1)
        #label.set_size_request(0,22)
        return label


    def make_gst_select_output(self):


        sink_plugins = []
        plugs = gst.registry_get_default().get_plugin_list()
        for p in plugs:
            for elem_factory in gst.registry_get_default().get_feature_list_by_plugin(p.get_name()):
                if isinstance(elem_factory,gst.ElementFactory):
                    if elem_factory.get_klass().rfind("Sink/Audio")!=-1:
                        sink_plugins.append(elem_factory)

    def make_number(self,label,label2,section,attribut):
        def save(spin):
            config.set(section,attribut,spin.get_value())
        b = gtk.SpinButton(gtk.Adjustment(float(config.get(section,attribut)),60,24*60,10 ),1.0)
        b.connect("value-changed",save)

        box = gtk.HBox(False,6)
        box.pack_start(gtk.Label(label),False,False)
        box.pack_start(b,False,False)
        box.pack_start(gtk.Label(label2),False,False)
        box.get_children()[0].set_alignment(0,0.5)
        box.get_children()[2].set_alignment(0,0.5)
        return box

    def make_file(self,section,attribut):
        dialog = gtk.FileChooserDialog(title="Select a directory", parent=None, action=gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER, buttons= (gtk.STOCK_OPEN, gtk.RESPONSE_ACCEPT,
                          gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL), backend=None)
        file = gtk.FileChooserButton(dialog)
        path = os.path.expanduser(config.get(section,attribut))
        file.set_filename(path)
        def save(dialog,response):
            if response==gtk.RESPONSE_ACCEPT:
                config.set(section,attribut,file.get_filename())

        dialog.connect("response",save)
        return file

    def make_check_box(self,label,section,attribut):
        check = gtk.CheckButton(label)
        if config.get(section,attribut)=="true":
            check.set_property("active",True)

        def save_check(widget,sect,attr):
            if widget.get_property("active"):
                config.set(sect,attr,"true")
            else:
                config.set(sect,attr,"false")
            if section=="setting" and attribut=="use_trayicon":
                if widget.get_property("active"):
                    self.win_parent.tray.tray.show_all()
                else:
                    self.win_parent.tray.tray.hide_all()

        check.connect("toggled",save_check,section,attribut)
        return check

    def make_entry(self,label,section,attribut):
        def save_entry(widget,sect,attr):
            if sect=="audioscrobbler" and attr=="password":
                hasher = md5.new()
                hasher.update(widget.get_text())
                md5_pass = hasher.hexdigest()
                config.set(sect,attr,md5_pass)
            else:
                config.set(sect,attr,widget.get_text())
        entry = gtk.Entry()
        entry.set_text(config.get(section,attribut))
        entry.connect("changed",save_entry ,section,attribut)
        if section=="audioscrobbler" and attribut=="password":
            def clear (widget,event):
                widget.set_text("")
            entry.connect("focus-in-event",clear)


        return entry

    def make_bar(self,section,attribut,lower,upper,step):
        label = gtk.Label(config.get(section,attribut)+"ms")
        value = int(config.get(section,attribut))
        bar = gtk.HScale(gtk.Adjustment(value, lower, upper, step,1,step))
        bar.set_digits(0)
        bar.set_draw_value(False)
        def on_bar_change(bar,sect,attr,label):
            value,end = divmod(bar.get_value(),50)
            value = int(value*50)
            bar.set_value(value)
            label.set_text("%sms"%value)
            config.set(sect,attr,"%d"%value)
        bar.connect("value-changed",on_bar_change,section,attribut,label)
        box = gtk.HBox(False,6)
        box.pack_start(bar)
        box.pack_start(label,False,False)
        box.set_spacing(12)
        return box

class PluginsDialog(gtk.Window):
    def __init__(self,parent):
        gtk.Window.__init__(self)

        self.set_title(_("Plugins"))
        self.set_resizable(False)
        self.set_position(gtk.WIN_POS_CENTER_ON_PARENT)
        self.set_border_width(12)
        self.set_property("skip-taskbar-hint",True)
        self.set_transient_for(parent)
        self.connect('delete-event', self.__destroy)

        self.model = gtk.ListStore(object,str,int)

        self.tree = gtk.TreeView()


        r = gtk.CellRendererToggle()
        r.set_radio(True)
        column1 = gtk.TreeViewColumn(self,name,r,text=2)

        r = gtk.CellRendererText()
        column2 = gtk.TreeViewColumn(self,name,r,text=1)


        self.tree.set_model(self.model)
        self.tree.append_column(column1)
        self.tree.append_column(column2)

        hbox = gtk.HBox()
        hbox.pack_start(self.tree,False,False)

        self.add(hbox)



    def __destroy(self):
        self.destroy()

