#!/usr/bin/env python

###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import os
import sys
import pygtk
pygtk.require("2.0")

import gtk
if gtk.pygtk_version < (2,6) or gtk.gtk_version < (2, 6):
	raise ImportError,"Need GTK > 2.6.0"

import pygst
pygst.require("0.10")


import locale
import gettext
import getopt
import bonobo
import gobject
import time
import threading
import traceback

# Go to correct path
current_path = os.path.realpath(__file__)
basedir = os.path.dirname(os.path.realpath(__file__))
if not os.path.exists(os.path.join(basedir, "listen.py")):
	if os.path.exists(os.path.join(os.getcwd(), "listen.py")):
		basedir = os.getcwd()
sys.path.insert(0, basedir)
os.chdir(basedir)

import config
import utils

config.init(config.CONFIG_FILE)

locale.setlocale(locale.LC_ALL, '')
gettext.bindtextdomain(config.GETTEXT_APP, config.GETTEXT_DIR)
gettext.textdomain(config.GETTEXT_APP)
gettext.install(config.GETTEXT_APP, config.GETTEXT_DIR, unicode=1)
utils.ctypes_init()



try:from hal import hal
except: hal = None
try:from dbus_manager import ListenDBus
except: dbus_manager = None

gtk.about_dialog_set_url_hook(utils.url_hook)

class Listen(gobject.GObject):
	def __init__(self):
		self.verbose = False
		gobject.GObject.__init__(self)


		try:
			opts, args = getopt.getopt(sys.argv[1:],
					 "h:i:aencpv",
					 ["help", "import","play-file","queue",
					   "next","previous","current-playing",
					   "play-pause","play","pause","ext-support"]
				 )
		except getopt.GetoptError:
			# print help information and exit:
			self.usage()
			sys.exit(2)

		import signal
		signal.signal(signal.SIGINT, signal.SIG_DFL)


		output = None
		verbose = False
		for o, a in opts:
			if o == "-v":
				verbose = True
			if o in ("-h", "--help"):
				self.usage()
				sys.exit()

		if len(opts)==0 and len(args) != 0:
			opts = [("-a","")]

		app = bonobo.Application("Listen")
		app.register_message("control",
						 "Control listen",
						 str, (str,str),
						 self.on_bonobo_message)

		client = app.register_unique(app.create_serverinfo(("LANG",)))

		if client==None:
			for o, a in opts:
				if o in ("-c", "--current-playing"):
					print _("No playing song")
					sys.exit(0)
				if o == "--ext-support":
					import song
					print song.get_supported_extention()
					sys.exit(0)


			#If a song is in parameter don't play the previous one
			for o, a in opts:
				if o in ("-a", "--play-file"):
					config.set("player","last_played","")

			app.new_instance(sys.argv)
			from thread_queue import ThreadQueue
			ThreadQueue.run()
			self.run()


		#connect to launched client to send command
		client_bis = app.register_unique(app.create_serverinfo(("LANG",)))

		ret = ""
		for o, a in opts:
			if o in ("-a", "--play-file"):
				uri = args.pop(0)
				if uri.find("://")==-1:
					uri = "file://"+utils.fsdecode(os.path.abspath(uri))
				res = client_bis.msg_send("control", ("play",str(uri)))
				for uri in args:
					if uri.find("://")==-1:
						uri = "file://"+utils.fsdecode(os.path.abspath(uri))
					res = client_bis.msg_send("control", ("queue",str(uri)))

			if o in ("-e", "--queue"):
				for uri in args:
					if uri.find("://")==-1:
						uri = "file://"+utils.fsdecode(os.path.abspath(uri))
					res = client_bis.msg_send("control", ("queue",str(uri)))

			if o in ("-n", "--next"):
				ret = client_bis.msg_send("control",("next",""))
			if o in ("-p", "--previous"):
				ret = client_bis.msg_send("control",("previous",""))
			if o in ("-c", "--current-playing"):
				ret = client_bis.msg_send("control",("current-song",""))
			if o in ("--play-pause","--play","--pause"):
				ret = client_bis.msg_send("control",("play-pause",""))
			print ret


		if client is None:
			gtk.main()

		app.unref()
		sys.exit(0)

	def on_bonobo_message(self,app_client, message,arg):
		if message=="current-song":
			song = self.player.current_song
			if not self.player.gst_player.paused:
				return song.sprint("title")+ " - ("+song.sprint("album")+" - "+song.sprint("artist")+")"
			else:
				return _("No playing song")
		elif message=="play":
			print "play"
			res = self.player.playlist.add(arg,False,True)
			return "Command successful"

		elif message=="queue":
			res = self.player.playlist.add(arg)
			return "Command successful"
		elif message=="next":
			self.player.btn_next.emit("clicked")
			return "Command successful"
		elif message=="previous":
			self.player.btn_previous.emit("clicked")
			return "Command successful"
		elif message=="play-pause":
			self.player.btn_play.emit("clicked")
			return "Command successful"
		else:
			return "oups"

	def usage(self):
		COL_WIDTH = 25
		print "Usage : listen.py [-h|-n|-p|-c|-a files|-e files] "
		print ""
		print "-a, --play-file files".ljust(COL_WIDTH)+_("queue and play files in the playlist")
		print "-e, --queue files".ljust(COL_WIDTH)+_("queue files in the playlist")
		print "-n, --next".ljust(COL_WIDTH)+_("play the next song in the playlist")
		print "-p, --previous".ljust(COL_WIDTH)+_("play the previous song in the playlist")
		print "	--play-pause".ljust(COL_WIDTH)+_("play or pause")
		print "	--play".ljust(COL_WIDTH)
		print "	--pause".ljust(COL_WIDTH)
		print "-c, --current-playing".ljust(COL_WIDTH)+_("show current playing song")
		print "--ext-support".ljust(COL_WIDTH)+_("show information about supported audio file")
		print ""
		print "-h, --help".ljust(COL_WIDTH)+_("show this help message")




	def run(self):

		import gst
		if gst.pygst_version < (0, 10, 1):
			raise ImportError,"Need Gstreamer >= 0.10.1"

		""" Force disable visualisation if gst < 0.10.3 """
		if gst.pygst_version < (0, 10, 3):
			config.set("player","enable_vis","false")

		config.write(config.CONFIG_FILE)
		#Some distributions don't have module "Image"
		#Why can't he use Listen for a splashscreen ?
		try : import Image
		except:
			self.splash=None
		else:
			if config.get("setting","splash")=="true":
				self.splash = Splash()
				while gtk.events_pending():gtk.main_iteration()
			else:
				self.splash=None
			#Render it


		import stock
		utils.stock_init()

		import osd
		self.osd = osd.listen_osd(self)
		self.debug( "OSD loaded.")

		from player import Player
		self.player = Player(self.osd)
		self.debug( "PLAYER loaded.")


		from media_organizer import MediaOrganizer
		self.media_organizer = MediaOrganizer(self.player,hal)
		self.debug( "Organizer Loaded.")

		try: self.dbus_service = ListenDBus(self.player)
		except: print "No DBus support"
		self.debug( "self.dbus loaded.")

		from main_window import ListenUI
		self.main_window = ListenUI(self.player,self.media_organizer,self.osd)
		self.debug( "MAIN loaded.")


		self.main_window.connect("delete-event",self.on_close_window)
		self.main_window.connect("window-state-event",self.on_window_state_event)




		from db_manager import DBManager
		if config.get("player","last_played")!="":
			self.player.current_song = DBManager.get_song_by_id(int(config.get("player","last_played")))
			if self.player.current_song!=None:
				self.player.on_playlist_changed(self.player.current_song,False)


		#self.differed_startup_cb()

		if self.splash!=None:
			self.splash.destroy()

		self.main_window.show_all()
		self.main_window.set_no_show_all(False)
		#Load library and some background tasks in a thread
		thread = threading.Thread(target=self.differed_startup_cb)
		thread.start()
		gobject.idle_add(self.start_playback)


	def start_playback(self):
		if config.get("player","last_played")!="" and self.player.current_song!=None:

			"""
			if config.get("player","play_on_startup")=="true" and config.get("player","play")=="true":
					self.player.play(self.player.current_song)
					if config.get("player","time")!="":
						self.player.gst_player.seek(int(config.get("player","time")))
				else:
			"""
			self.player.gst_player.set_song(self.player.current_song)




	def differed_startup_cb(self):

		from podcast_manager import PodcastManager
		PodcastManager.start()

		#Start hal if present
		if hal!=None:
		   gobject.timeout_add(1000,hal.start_monitor)
		   #hal.start_monitor()

		#copy source reference to don't change the display order in media_organizer
		list_source = list([source for source in self.media_organizer.list_source])
		def sort_source(a,b):
			if a.startup_priority==b.startup_priority:
				return 0
			elif a.startup_priority>b.startup_priority:
				return -1
			else:
				return 1

		# order source by highter priority
		list_source.sort(sort_source)

		""" Create a temporary DB instance in the thread only for read """
		from db_manager import ListenDBManager
		DB = ListenDBManager()
		# Load source
		for source in list_source:
			source.load(DB)

		gobject.timeout_add(1000,self.source_run,list_source)

	""" run all source """
	def source_run(self,list_source):
		for source in list_source:
			source.run()
		self.player.gst_player.set_started()

	def on_close_window(self,widget,event):
		self.main_window.tray.cacher()
		if config.get("setting","fermer_trayicon")=="true" and self.main_window.tray.tray!=None:
			return True
		else:
			self.main_window.on_quit()
			return True

	def on_window_state_event(self,widget,event):
	   state = event.new_window_state
	   #print state
	   if state == gtk.gdk.WINDOW_STATE_ICONIFIED:
		   if config.get("setting","reduire_trayicon")=="true":
			   self.main_window.tray.cacher()

	def debug(self,str):
		if self.verbose:
			print str

class Splash(gtk.Window):
	def __init__(self):
		gtk.Window.__init__(self,gtk.WINDOW_POPUP)
		width = 420
		height = 150

		self.set_decorated(False)
		self.set_position(gtk.WIN_POS_CENTER_ALWAYS)



		import Image
		image = Image.open(config.PIXMAP_DIR+"splash.png")
		IS_RGBA = image.mode=='RGBA'
		pixbuf =  gtk.gdk.pixbuf_new_from_data(
			image.tostring(), # data
			gtk.gdk.COLORSPACE_RGB, # color mode
			IS_RGBA, # has alpha
			8, # bits
			image.size[0], # width
			image.size[1], # height
			(IS_RGBA and 4 or 3) * image.size[0] # rowstride
			)
		pixmap, mask = pixbuf.render_pixmap_and_mask()
		width, height = pixmap.get_size()
		del pixbuf
		self.set_app_paintable(True)
		self.resize(width, height)
		self.realize()

		self.shape_combine_mask(mask, 0, 0)  # make it transparent
		self.window.set_back_pixmap(pixmap, False)
		del pixmap
		self.show_all()



if __name__ == "__main__":
	Listen()
