#!/usr/bin/env python

###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import sys
import gtk
import dbus
import dbus.glib
import gnomevfs
import gobject
#import CDDB, DiscI


class Hal(gobject.GObject):
    __gsignals__ = {
        "ipod-removed" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_STRING,))   ,
        "ipod-added" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_STRING,))     ,
        "cdrom-added" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,))    ,
        "cdrom-removed" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,))
    }
    def __init__(self):
        self.verbose = False
        gobject.GObject.__init__(self)

        self.ipod_udi = []
        self.ipod_mount_point = {}
        self.cdrom_udi = []

    def start_monitor(self):
        self.bus = dbus.SystemBus()
        self.vol_monitor =  gnomevfs.VolumeMonitor()
        self.vol_monitor.connect("volume_mounted",self.__volume_mounted_cb)
        self.vol_monitor.connect("volume_unmounted",self.__volume_unmounted_cb)

        volume = gnomevfs.Volume()
        for volume in self.vol_monitor.get_mounted_volumes():
            device_udi = volume.get_hal_udi()
            if device_udi!=None:
                device_dbus_obj = self.bus.get_object("org.freedesktop.Hal" ,device_udi)
                device = device_dbus_obj.GetAllProperties(dbus_interface="org.freedesktop.Hal.Device")
                """if device.has_key("volume.disc.has_audio") and device["volume.disc.has_audio"]:
                    self.cdrom_udi.append(device_udi)
                    info_cd = self.get_cddb_info_cd(self.get_cdrom_mount_point(device_udi))
                    self.emit("cdrom-added",info_cd)
                    if self.verbose: print "CDROM found: ",device_udi
                """
                if self.is_ipod(device):
                    self.ipod_udi.append(device_udi)
                    self.emit("ipod-added",device_udi)
                    if self.verbose: print "IPOD found: ",device_udi


    def __volume_mounted_cb(self,monitor,volume):
        device_udi = volume.get_hal_udi()
        device_dbus_obj = self.bus.get_object("org.freedesktop.Hal" ,device_udi)
        device = device_dbus_obj.GetAllProperties(dbus_interface="org.freedesktop.Hal.Device")
        """
        if device.has_key("volume.disc.has_audio"):
            self.cdrom_udi.append(device_udi)
            info_cd = self.get_cddb_info_cd(self.get_cdrom_mount_point(device_udi))
            self.emit("cdrom-added",info_cd)
        """
        if self.is_ipod(device):
            self.ipod_udi.append(device_udi)
            self.emit("ipod-added",device_udi)


    def __volume_unmounted_cb(self,monitor,volume):
        device_udi = volume.get_hal_udi()
        device_dbus_obj = self.bus.get_object("org.freedesktop.Hal" ,device_udi)
        device = device_dbus_obj.GetAllProperties(dbus_interface="org.freedesktop.Hal.Device")
        """
        if device_udi in self.cdrom_udi:
            self.cdrom_udi.remove(device_udi)
            self.emit("cdrom-removed",[])
        """
        if device_udi in self.ipod_udi:
            self.ipod_udi.remove(device_udi)
            self.emit("ipod-removed",device_udi)
        print "remove block"
        return False

    def get_cdrom_mount_point(self,device_udi):
            device_dbus_obj = self.bus.get_object("org.freedesktop.Hal" ,device_udi)
            device = device_dbus_obj.GetAllProperties(dbus_interface="org.freedesktop.Hal.Device")
            if device.has_key("block.device"):
                return device["block.device"]
            else:
                return ""

    def get_ipod_mount_point(self,device_udi):
            device_dbus_obj = self.bus.get_object("org.freedesktop.Hal" ,device_udi)
            device = device_dbus_obj.GetAllProperties(dbus_interface="org.freedesktop.Hal.Device")
            if device.has_key("volume.is_mounted") and device["volume.is_mounted"] and\
                device.has_key("volume.mount_point") and device["volume.mount_point"]!="":
                return device["volume.mount_point"]
            else:
                return ""

    def get_ipod_total_size(self,device_udi):
            device_dbus_obj = self.bus.get_object("org.freedesktop.Hal" ,device_udi)
            device = device_dbus_obj.GetAllProperties(dbus_interface="org.freedesktop.Hal.Device")
            if device.has_key("volume.size"):
                return device["volume.size"]
            else:
                return 0

    def is_ipod(self,device):
        if device.has_key("info.parent"):
            device_dbus_obj = self.bus.get_object("org.freedesktop.Hal" , device["info.parent"])
            device = device_dbus_obj.GetAllProperties(dbus_interface="org.freedesktop.Hal.Device")
            if device.has_key("storage.model") and device["storage.model"]=="iPod":
               return True
        return False

    def get_cddb_info_cd(self,mount_point):
        info_cd = []
        cdrom = DiscID.open(mount_point)
        disc_id = DiscID.disc_id(cdrom)
        (query_status, query_info) = CDDB.query(disc_id)
        if query_status in [211,210]:
            query_info = query_info[0]

        if query_status != 200:
            return []

        (read_status, read_info) = CDDB.read(query_info['category'], query_info['disc_id'])
        titre = read_info['DTITLE'].split(" / ")
        for i in range(disc_id[1]):
            item = {}
            item["removable"] = True
            item["tracknr"] = i
            item["title"] = read_info['TTITLE' + `i`]
            item["album"] = titre[1]
            item["artist"] = titre[0]
            item["uri"] = "cdda://%d"%(i+1)+"#"+mount_point
            second = disc_id[i+2]/75*1000
            if i+1 == disc_id[1]:
                second2 = disc_id[i+3]*1000
            else:
                second2 = disc_id[i+3]/75*1000
            item["duration"] = second2-second
            info_cd.append(item)
        return info_cd

hal = Hal()

