###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gobject
import time
import gst
import gst.interfaces
import sys
import utils

import config
from db_manager import DBManager

DEBUG = False
CROSSFADE_STEP = 0.05
class GstPlayer(gobject.GObject):
    __gsignals__ = {
        "play-end" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,)),
        "new-media" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,))
    }

    def __init__(self,player):
        gst.debug_set_default_threshold(gst.LEVEL_ERROR)
        gobject.GObject.__init__(self)

        self.__volume = 0

        self.paused = True
        self.player = player
        self.song = None

        self.imagesink=None

        try: audio_sink = gst.parse_launch("gconfaudiosink")
        except gobject.GError, err:
            try: audio_sink = gst.parse_launch("autoaudiosink")
            except gobject.GError: audio_sink = None

        try: self.vis = gst.element_factory_make(config.get("player","vis"))
        except (gobject.GError,gst.PluginNotFoundError), err:
            self.vis = None

        try: self.video_sink = gst.parse_launch("xvimagesink")
        except gobject.GError, err:
            self.video_sink = None

        if audio_sink==None:
            print "No audio sink found for Gstreamer"
            sys.exit(1)

        if self.video_sink==None:
            print "Element xvimagesink not found for Gstreamer, visualisation disable"
        if self.vis==None:
            print "No visualisation plugins found for Gstreamer, visualisation disable"

        self.bin = gst.element_factory_make('playbin')

        self.bin.set_property('audio-sink',audio_sink)

        if self.video_sink and self.vis and config.get("player","enable_vis")=="true":
            self.bin.set_property('vis-plugin',self.vis)
            self.bin.set_property('video-sink', self.video_sink)
            self.video_widget = VideoWidget(self)
            self.video_widget.show_all()
        else:
            self.video_widget = None
            self.bin.set_property('video-sink', None)

        self.bin.set_property("auto-flush-bus",True)

        bus = self.bin.get_bus()
        bus.add_signal_watch()
        if config.get("player","enable_vis")=="true":
            bus.enable_sync_message_emission()
            bus.connect('sync-message::element', self.on_sync_message)
        bus.connect('message', self.on_message)

        self.bin.set_state(gst.STATE_NULL)


        self.clock=False
        self.seek_pending = None

        self.id_message = None
        self.__id_new_media = None
        self.visu_plugins = None
        self.is_started = False

    """ Stated flag is used to not propage new-media (for startup) """
    def set_started(self):
        self.is_started = True
        if self.song:
            self.emit("new-media",self.song)

    def __notify_source(self,object,spec,uri):
        source = self.bin.get_property('source')
        source.set_property("device",uri[uri.find("#")+1:])
        self.bin.disconnect(self.handler_notify_id)


    def on_sync_message(self, bus, message):
        if message.structure is None:
            return
        self.debug("sync_message", message.structure.get_name())
        if message.structure.get_name() == 'prepare-xwindow-id':
            if self.video_sink!=None:
                self.imagesink = message.src
                self.video_widget.set_sink(self.imagesink)

    def on_message(self,bus,message):
        self.debug("message", message)

        if message.type == gst.MESSAGE_CLOCK_PROVIDE:#gst.MESSAGE_NEW_CLOCK:
            self.clock=True
            if self.seek_pending:
                self.seek_cb(self.seek_pending)

        elif message.type == gst.MESSAGE_EOS:
            if not self.paused:
                self.on_eos()

        elif message.type == gst.MESSAGE_TAG:
            self.on_tag(message.parse_tag())

        elif message.type == gst.MESSAGE_ERROR:
            err, debug = message.parse_error()
            print "Gstplayer error: %s" % err,debug
            if not self.paused:
                self.on_eos()

        return True

    def on_eos(self):
        config.set("player","play","false")
        self.clock=False
        self.bin.set_state(gst.STATE_NULL)
        self.paused = True
        self.song = None
        gobject.idle_add(self.player.playlist_next_cb)

    def on_tag(self, taglist):
        """ TAG wrapper for iRadio """
        if self.song!=None and self.song.iradio==True:
            for k in taglist.keys():
                value = str(taglist[k])
                print k," - ",value
                if not value: continue
                #Set album on current stream with for fancy wiev
                if self.song.get_property("artist")==None:
                    self.song.set_property("artist",self.song.get_property("title"))
                if k == "title":
                    self.song.set_property("title",value)
                if k == "comment":
                    self.song.set_property("album",value)
            gobject.idle_add(self.player.on_playlist_changed,self.song)
        pass

    def play_new(self,song):
        self.set_song(song)
        self.play(True);

    def set_song(self,song):
        self.song = song
        self.clock=False
        self.debug("set_song",song.sprint("title"),song.sprint("artist"),song.sprint("album"))

        self.bin.set_state(gst.STATE_NULL)

        if song.get_property("podcast") and song.get_property("podcast_local_uri")!=None and song.get_property("podcast_local_uri")!="":
            uri = song.get_property("podcast_local_uri")
        else:
            uri = song.get_property("uri")

        uri = utils.convert_to_uri(uri)

        """ No cd support for now
        if False and uri.find("cdda://")==0:
            self.bin.set_property('uri',uri[:uri.find("#")])
            self.handler_notify_id = self.bin.connect("notify::source",self.__notify_source,uri)
        else:"""

        self.bin.set_property('uri',uri)


    def play(self,new=False):
        self.debug("play")
        if self.bin.set_state(gst.STATE_PLAYING):
            self.paused = False
            config.set("player","play","true")
            self.debug("play","set_to_play")
        else:
            self.paused = True
            config.set("player","play","false")
            gobject.idle_add(self.player.playlist_next_cb)
            self.debug("play","set_to_pause")

        if self.is_started and new:
            if self.__id_new_media!=None:  gobject.source_remove(self.__id_new_media)
            def send_new_media():
                self.emit("new-media",self.song)
            self.__id_new_media = gobject.timeout_add(250,send_new_media)
            #gobject.idle_add(self.emit,"new-media",self.song)


    def pause(self):
        self.debug("pause")
        self.bin.set_state(gst.STATE_PAUSED)
        self.paused = True
        config.set("player","play","false")

    def stop(self):
        self.debug("stop")
        self.bin.set_state(gst.STATE_NULL)
        self.paused = True
        self.song = None

    def get_state(self,bin=None):
        if bin==None: bin = self.bin
        changestatus,state,_state = bin.get_state()
        return state

    def is_playable(self):
        if self.bin.get_property('uri'):
            return True
        else :
            return False

    def set_volume(self, v):
        self.debug("set_volume",v)
        self.__volume = v
        self.bin.set_property('volume', v)

    def get_volume(self):
        self.debug("get_volume")
        return self.bin.get_property('volume')
    volume = property(get_volume, set_volume)


    def get_position(self):
        if gst.STATE_NULL != self.get_state() and self.bin.get_property('uri'):
            try: p = self.bin.query_position(gst.FORMAT_TIME)[0]
            except gst.QueryError: p = 0
            p //= gst.MSECOND
            return p
        return 0

    def get_length(self):
        if self.player.current_song!=None:
            return self.player.current_song.get_int("duration")
        else:
            return 0



    def seek(self, pos):
        """self.seek_cb(pos)
        return"""
        """
        check pipeline started else keep demanded position and set it when new clock message receive
        for the seek on startup
        """

        if self.clock==True:
            self.seek_cb(pos)
        else:
            self.seek_pending = pos

    def seek_cb(self,pos):
        self.seek_pending = None
        self.debug("seek",pos)
        if self.bin.get_property('uri'):
            pos = max(0, int(pos))

            gst_time = pos * gst.MSECOND
            event = gst.event_new_seek(
                1.0, gst.FORMAT_TIME, gst.SEEK_FLAG_FLUSH | gst.SEEK_FLAG_ACCURATE,
                gst.SEEK_TYPE_SET, gst_time, gst.SEEK_TYPE_NONE, 0)
            res = self.bin.send_event(event)
            if res:
                self.bin.set_new_stream_time(0L)
            else:
                self.debug("seek","failed")



    def change_visualisation(self,widget,vis_name):
        if vis_name!=None:
            try: self.vis = gst.element_factory_make(vis_name)
            except: self.vis = None
            if self.video_sink and self.vis:
                self.bin.set_property('vis-plugin',self.vis)
        else:
            self.bin.set_property('vis-plugin',None)

    def debug(self,*param):
        if DEBUG: print "Gst_player->",param


import gtk
class VideoWidget(gtk.EventBox):
    def __init__(self,gst_player):
        self.gst_player = gst_player
        gtk.EventBox.__init__(self)
        self.connect("button_press_event", self.on_click )
        self.imagesink = None
        self.is_fullscreen = False
        self.add(VideoArea())
        self.visu_plugins = None

        self.loaded = False

    def set_sink(self, sink):
        self.imagesink = sink
        #gobject.idle_add(self.set_window_id)
        self.set_window_id()
        self.child.set_sink(sink)
        if self.is_fullscreen:
            self.fwindow.child.child.set_sink(sink)

        """
        workaround to launch the visualisation on startup
        And prevent the "Xerror GC bad" problem when visualisation start and widget not completey realize
        """
        if not self.loaded:
            self.child.do_expose_event(None)
            self.loaded = True

    def set_window_id(self):
        if self.is_fullscreen:
            self.imagesink.set_xwindow_id(self.fwindow.child.child.window.xid)
        else:
            self.imagesink.set_xwindow_id(self.child.window.xid)

    def on_click(self,btn,event):
        if self.gst_player.paused:
            return

        if event.button == 3:
            menu = gtk.Menu()
            i = 0
            for name,detail in self.get_list_plugins():
                label = gtk.Label()
                label.set_markup(detail)
                label.set_alignment(0.0, 0.0)
                item = gtk.MenuItem()
                item.add(label)
                item.connect("activate",self.gst_player.change_visualisation,name)
                menu.attach(item, 0, 1, i, i+1)
                i +=1

            menu.show_all()
            menu.popup(None, None, None, event.button, event.time)

        if event.button == 1:
            self.toggle_fullscreen()


    def toggle_fullscreen(self):

        if self.is_fullscreen:
            self.is_fullscreen = False
            self.set_window_id()
            self.fwindow.destroy()
        else:
            self.fwindow = gtk.Window(gtk.WINDOW_POPUP)
            self.fwindow.set_decorated(False)
            self.fwindow.set_position(gtk.WIN_POS_CENTER_ALWAYS)
            monitor = gtk.gdk.Screen.get_monitor_geometry(gtk.gdk.screen_get_default(), 0)
            e = gtk.EventBox()
            e.add(VideoArea(self.imagesink))
            e.connect("button_press_event", self.on_click )
            self.fwindow.add(e)
            self.fwindow.resize(monitor.width,monitor.height)
            #self.fwindow.resize(300,300)
            e.show_all()
            self.is_fullscreen = True
            self.fwindow.show_all()
            self.fwindow.set_keep_above(True)
            self.set_window_id()


    def get_list_plugins(self):
        if self.visu_plugins==None:
            self.visu_plugins = []
            plugs = gst.registry_get_default().get_plugin_list()
            for p in plugs:
                for elem_factory in gst.registry_get_default().get_feature_list_by_plugin(p.get_name()):
                    if isinstance(elem_factory,gst.ElementFactory):
                        if elem_factory.get_klass().rfind("Visualization")!=-1:
                            self.visu_plugins.append((p.get_name(),elem_factory.get_longname()))
        return self.visu_plugins

class VideoArea(gtk.DrawingArea):
    def __init__(self,imagesink=None):
        gtk.DrawingArea.__init__(self)
        self.unset_flags(gtk.DOUBLE_BUFFERED)
        self.imagesink = imagesink

    def set_sink(self,imagesink):
        self.imagesink = imagesink

    def do_expose_event(self, event):
        if self.imagesink:
            self.imagesink.expose()
            return False
        else:
            return True


