###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###
# Based on quolibet code for read/write metadata
#   (C) Copyright 2004-2005 Joe Wreschnig, Michael Urman
###

import gst
from song import READ_EXTENTIONS,WRITE_EXTENTIONS

def write(song):
    try:
        filename = song.get_path()
        f = _mp4v2.MP4Modify(
            filename, ctypes.c_uint32(0), ctypes.c_uint32(0))
        if not f: raise IOError("%s not an MP4 file" % filename)
        elif not _mp4v2.MP4MetadataDelete(f):
            raise IOError("unable to remove metadata in %s" % filename)
        for key, func in [
            ("title", _mp4v2.MP4SetMetadataName),
            ("artist", _mp4v2.MP4SetMetadataArtist),
            #("composer", _mp4v2.MP4SetMetadataWriter),
            #("comment", _mp4v2.MP4SetMetadataComment),
            ("date", _mp4v2.MP4SetMetadataYear),
            ("album", _mp4v2.MP4SetMetadataAlbum),
            #("encoder", _mp4v2.MP4SetMetadataTool),
            ("genre", _mp4v2.MP4SetMetadataGenre)
            ]:
            if key in self and not func(f, song.get_property(key).encode("utf-8")):
                raise IOError("unable to set %s in %s" % (key, filename))
        track = song.get_property("tracknr")
        if track:
            if not _mp4v2.MP4SetMetadataTrack(
                f, ctypes.c_uint16(track), ctypes.c_uint16(0)):
                    raise IOError("unable to set track in %s" % filename)
    finally:
       _mp4v2.MP4Close(f)

def read(song):
    filename = song.get_path()
    def GetAACTrack(infile):
        numtracks = _mp4v2.MP4GetNumberOfTracks(infile, None, ctypes.c_uint8(0))
        for i in range(numtracks):
            trackid = _mp4v2.MP4FindTrackId(
                infile, ctypes.c_uint16(i), None, ctypes.c_uint8(0))
            tracktype = _mp4v2.MP4GetTrackType(infile, ctypes.c_uint32(trackid))
            if tracktype == "soun": return trackid
        else: return -1
    try:
        f = _mp4v2.MP4Read(filename, ctypes.c_uint32(0))
        if not f: raise IOError("%s not an MP4 file" % filename)
        track = GetAACTrack(f)
        if track == -1: raise IOError("%s has no audio track")
        duration = _mp4v2.MP4GetTrackDuration(f, ctypes.c_uint32(track))
        length = _mp4v2.MP4ConvertFromTrackDuration(
            f, ctypes.c_uint32(track), ctypes.c_uint64(duration),
            ctypes.c_uint32(1))
        song.set_property("duration",int(length)*1000)
        from ctypes import byref
        for key, function in [
            ("title", _mp4v2.MP4GetMetadataName),
            ("artist", _mp4v2.MP4GetMetadataArtist),
            #("composer", _mp4v2.MP4GetMetadataWriter),
            #("comment", _mp4v2.MP4GetMetadataComment),
            ("date", _mp4v2.MP4GetMetadataYear),
            ("album", _mp4v2.MP4GetMetadataAlbum),
            #("encoder", _mp4v2.MP4GetMetadataTool),
            ("genre", _mp4v2.MP4GetMetadataGenre)
            ]:
            value = ctypes.c_char_p()
            if function(f, byref(value)):
                song.set_property(key,value.value.decode('utf-8'))
        cur, total = ctypes.c_uint16(), ctypes.c_uint16()
        if _mp4v2.MP4GetMetadataTrack(f, byref(cur), byref(total)):
            song.set_property("tracknr",cur.value)
    except Exception,e:
        _mp4v2.MP4Close(f)
        raise e
    else:
        _mp4v2.MP4Close(f)

try:
    import ctypes
    if ctypes._ctypes_version < "0.9.9":
        _mp4v2 = ctypes.cdll.LoadLibrary("libmp4v2.so.0")
    else:
        _mp4v2 = ctypes.cdll.load("libmp4v2.so.0")
except: 
    pass
else:
    try: gst.element_factory_make('faad')
    except:    
        pass
    else:
        _mp4v2.MP4Read.restype = ctypes.c_void_p
        _mp4v2.MP4GetTrackType.restype = ctypes.c_char_p
        _mp4v2.MP4GetTrackDuration.restype = ctypes.c_uint64
        _mp4v2.MP4ConvertFromTrackDuration.restype = ctypes.c_uint64
        _mp4v2.MP4FindTrackId.restype = ctypes.c_uint32
        _mp4v2.MP4GetNumberOfTracks.restype = ctypes.c_uint32
        WRITE_EXTENTIONS[".mp4"]= write
        WRITE_EXTENTIONS[".m4a"]= write
        READ_EXTENTIONS[".mp4"]= read
        READ_EXTENTIONS[".m4a"]= read
