###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


# Simple proxy to a Python ConfigParser.
import os
import gtk
# We don't need/want variable interpolation.
from ConfigParser import RawConfigParser as ConfigParser

_config = ConfigParser()
get = _config.get
set = _config.set
getboolean = _config.getboolean
getint = _config.getint
getfloat = _config.getfloat
write = _config.write
options = _config.options

VERSION = "0.4.3"

GETTEXT_APP="listen"
GETTEXT_DIR = "po"
CONFIG_DIR  = os.path.expanduser("~/.listen/")
if not os.path.isdir(CONFIG_DIR+"/cover"):
    os.makedirs(CONFIG_DIR+"/cover")
CONFIG_FILE  = os.path.join(CONFIG_DIR, "config")
TAG_COMPLETITION_FILE  = os.path.join(CONFIG_DIR, "tag_completition")
PIXMAP_DIR = "images/"

TMP_PATH = "/tmp/listen/"
if not os.path.isdir(TMP_PATH):
    os.makedirs(TMP_PATH)

DEFAULT_ALBUM_COVER = os.path.dirname(os.path.realpath(__file__))+"/"+PIXMAP_DIR+"listen_cover.png"
DEFAULT_ALBUM_COVER_PIXBUF = gtk.gdk.pixbuf_new_from_file_at_size(DEFAULT_ALBUM_COVER,40,40)
DEFAULT_ALBUM_COVER_PIXBUF_BIG = gtk.gdk.pixbuf_new_from_file_at_size(DEFAULT_ALBUM_COVER,75,75)
DEFAULT_ALBUM_COVER_PIXBUF_MINI = gtk.gdk.pixbuf_new_from_file_at_size(DEFAULT_ALBUM_COVER,25,25)

def write(filename):
    if isinstance(filename, str):
        if not os.path.isdir(os.path.dirname(filename)):
            os.makedirs(os.path.dirname(filename))
        f = file(filename, "w")
    else: f = filename
    _config.write(f)
    f.close()

def init(*rc_files):
    initial = {
        # State about the player, to restore on startup
        "setting":
        {
          "splash": "true",
          "start_trayicon": "false",
          "reduire_trayicon": "false",
          "fermer_trayicon": "true",
          "use_trayicon": "true",
          "mlib_smallfont": "false",
          "media_organizer_item" : "0",
          "repeat_mode":"false",
          "last_selected_podcast_feed":"",
          "wikipedia":"en",
          "empty_random":"true",
          "web_font":"Sans 12",
          "notification" : "true",
        },
        "osd":
        {
            "enable": "false",
            "osd_custom_position": "-1 -1",
            "osd_colors": "#ffffff #ffffff #ffffff #2959ac",
            "osd_font": "Sans 18",
            "osd_timeout": "7.5",
            "osd_transparency": "215",
            "osd_center_x": "1",
            "osd_center_y": "0",
        },
        "audioscrobbler":
        {
            "enable":"false",
            "username":"",
            "password":""
        },
        "player":
        {
            "volume":"1.0",
            "play_on_startup":"false",
            "play":"false",
            "time":"",
            "last_played":"",
            "crossfade":"true",
            "crossfade_time":"500",
            "enqueue":"true",
            "dynamic":"true",
            "vis":"goom",
            "enable_vis":"false"
        },
        "window":
        {
          "width" : "-1",
          "height" : "-1",
          "x" : "-1",
          "y" : "-1",
          "state" : "widthdrawn",
          "pos_organizer" : "140",
          "view":"2"
        },
        "songview":
        {
            "track":"1",
            "duration":"1",
            "artist":"1",
            "album":"1",
            "title":"1"
        },
        "mediasource":
        {
            "iradio":"1",
            "locallib":"1",
            "ipod":"1",
            "lyrics":"1",
            "lastfm":"1",
            "current":"1",
            "podcast":"1",
            "wikipedia":"1",
            "context":"1"
         },
    	 "browser":
    	 {
    	   "view":"2",
           "local" : "true",
           "ipod" : "true",
           "local_last_search":"",
           "ipod_last_search":"",
           "local_pos":"120",
           "ipod_pos":"120",
           "local_last_selected_artist":"",
           "local_last_selected_album":"",
           "local_last_selected_genre":"",
           "ipod_last_selected_artist":"",
           "ipod_last_selected_album":"",
           "ipod_last_selected_genre":"",
    	 },
         "podcast":
         {
           "startup":"true",
           "time_refresh":"120",
           "folder":"~/Podcasts/"
         },
         "webservice":
         {
           "filter":"bo<###>ost<###>cd1<###>cd2<###>cd3<###>cd 1<###>cd 2<###>cd 3<###> - <###>(<###>)"

         }


    }

    for section, values in initial.iteritems():
        _config.add_section(section)
        for key, value in values.iteritems():
            _config.set(section, key, value)

    _config.read(rc_files)

def state(arg):
    return _config.getboolean("settings", arg)
