#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#include "bouncer.h"

void parse_qmail_bounce(FILE *infile, FILE *outfile, const char *outfilename, 
                        int *errors)
{
   char buf[BIG_BUF];
   char *mptr;
   int done;

   done = 0;

   while(LMAPI->read_file(buf,BIG_BUF - 1,infile) && !done) {

      if (buf[strlen(buf) - 1] == '\n')
          buf[strlen(buf) - 1] = 0;

      mptr = &(buf[0]);

      if ((mptr[0] == '<') && (mptr[strlen(mptr) - 1] == ':') &&
          (mptr[strlen(mptr) - 2] == '>'))
      {
             char useraddr[256], *tptr, *tptr2;
             char errorstr[256], valstr[4];
             int status;
         
             memset(&useraddr[0],0,256);
             tptr = &useraddr[0]; tptr2 = mptr + 1;

             while(*tptr2 != '>') *tptr++ = *tptr2++;

             LMAPI->read_file(errorstr,255,infile);
             tptr = strrchr(errorstr,'('); 

             if (tptr) {
                *(tptr - 1) = 0;
                tptr++;

                memset(&valstr[0],0,4);
                tptr2 = &valstr[0];
                while(*tptr != ')') {
                   if (isdigit((int)(*tptr))) *tptr2++ = *tptr;
                   tptr++;
                }         
                status = atoi(valstr);
             } else {
                status = 550;
                LMAPI->buffer_printf(errorstr,255,"[unable to parse error]");
             }
             (*errors)++;
             handle_error(status,useraddr,errorstr,outfilename);
             LMAPI->write_file(outfile, "User: %s\n      (%d) %s\n\n",
                           useraddr, status, errorstr);
      } 
      else if (strncmp(mptr,"--- Below",9) == 0) done = 1;
   }
}

void parse_postfix_bounce(FILE *infile, FILE *outfile, const char *outfilename, 
                          int *errors)
{
   char buf[BIG_BUF];
   char *mptr;
   int maindone;

   maindone = 0;

   while (LMAPI->read_file(buf,BIG_BUF - 1,infile) && !maindone) {
      if (buf[strlen(buf) - 1] == '\n')
          buf[strlen(buf) - 1] = 0;

      mptr = &(buf[0]);

      if ((mptr[0] == '<') && (strstr(mptr,">:")))
      {
             char useraddr[256], *tptr, *tptr2, *eptr;
             char errorstr[256];
             int done;

             memset(&useraddr[0],0,256);
             tptr = &useraddr[0]; tptr2 = mptr + 1;

             eptr = strchr(mptr, ':');
             while (eptr && (*(eptr - 1) != '>')) eptr = strchr(eptr,':');

             if (eptr) {
                eptr++;

                while(*eptr ? isspace((int)*eptr) : 0) eptr++;

                LMAPI->buffer_printf(errorstr,255,"[No numeric] %s", 
                   *eptr ? eptr : "[No error]");
             } else {
                LMAPI->buffer_printf(errorstr,255,"[No numeric] [No error]");
             }

             done = 0;

             while (!done) {
                while(*tptr2 ? *tptr2 != '>' : 0) *tptr++ = *tptr2++;

                (*errors)++;
                handle_error(550,useraddr,errorstr,outfilename);
                LMAPI->write_file(outfile, "User: %s:\n      (%d) %s\n\n",
                           useraddr, 550, errorstr);

                memset(&useraddr[0],255,0);
                tptr = &useraddr[0];
                tptr2++;

                if (*tptr2 == ':') done = 1;

                if (!done) {
                   while(*tptr2 != '<') tptr2++;
                   tptr2++;
                }
             }
      } 
      else if (strncmp(mptr,"Received:",9) == 0) maindone = 1;
   }
}

void parse_exim_bounce(FILE *infile, FILE *outfile, const char *outfilename,
                       int *errors)
{
   int maindone;
   char useraddy[256], errorstr[256], buf[BIG_BUF];

   maindone = 0;

   while (LMAPI->read_file(buf,BIG_BUF - 1,infile) && !maindone) {
      if (buf[strlen(buf) - 1] == '\n')
          buf[strlen(buf) - 1] = 0;
 
      if ((strncmp(buf,"  ",2) == 0) && strchr(buf,'@') && strchr(buf,':')) {
         char *mptr;

         mptr = &(buf[0]);
         while (*mptr ? isspace((int)(*mptr)) : 0) mptr++;

         LMAPI->buffer_printf(useraddy,255,"%s",mptr);
         mptr = strrchr(useraddy,':');
         if (*mptr) *mptr = 0;

         LMAPI->read_file(buf,BIG_BUF - 1,infile);

         if (buf[strlen(buf) - 1] == '\n')
            buf[strlen(buf) - 1] = 0;

         mptr = &(buf[0]);
         while (*mptr ? isspace((int)(*mptr)) : 0) mptr++;

         LMAPI->buffer_printf(errorstr,255,"[No numeric] %s",mptr);

         handle_error(550,useraddy,errorstr,outfilename);
         LMAPI->write_file(outfile, "User: %s:\n      (%d) %s\n\n",
                           useraddy, 550, errorstr);

         (*errors)++;
      }
      else if (strncmp(buf,"-----",5) == 0) maindone = 1;
   }   
}
