package tests::UIDirectoryWidgetTest;

use strict;

use base qw/ Lire::Test::TestCase /;

use Lire::Config::TypeSpec;
use Lire::Test::CursesUIDriver;
use Curses::UI;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'driver'} = new Lire::Test::CursesUIDriver();
    $self->{'driver'}->setup_curses_ui();

    $self->{'ui'} = new Curses::UI();
    $self->{'driver'}->set_curses_ui( $self->{'ui'} );
    $self->{'window'} = $self->{'ui'}->add( 'window', 'Window' );

    my $spec = new Lire::Config::ConfigSpec();
    $spec->add( new Lire::Config::DirectorySpec( 'name' => 'dir_param' ) );
    $self->{'dir_param'} = $spec->get( 'dir_param' )->instance( 'value' => '/etc');
    $self->{'spec'} = $spec;

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    $self->{'driver'}->teardown_curses_ui();

    return;
}

sub test_new {
    my $self = $_[0];

    my $widget = $self->{'window'}->add( 'dir_widget', 'Lire::UI::DirectoryWidget',
                                         'value' => $self->{'dir_param'} );
    $self->assert_isa( 'Lire::UI::FileWidget',  $widget );
    $self->assert_isa( 'Lire::UI::DirectoryWidget', $widget );
}

sub test_browse_dialog {
    my $self = $_[0];

    my $dlg = '< undef >';
    my $directory = $self->{'dir_param'}->get();

    $self->{'driver'}->add_event_loop_handler(
       sub {
           $dlg = $_[1];
           $self->assert_str_equals( $directory, $dlg->{'-path'} );
           $dlg->getobj('pathvalue')->text( '/dev' );
           $dlg->getobj('buttons')->{'-selected'} = 0;
       } );

    my $widget = $self->{'window'}->add( 'test_widget','Lire::UI::DirectoryWidget',
                                         'value' => $self->{'dir_param'} );
    my $dir = $widget->browse_dialog();
    $self->assert_isa('Curses::UI::Dialog::Dirbrowser',  $dlg );
    $self->assert_str_equals( '/dev', $dir );

    $self->{'driver'}->add_event_loop_handler(
       sub {
           $dlg = $_[1];
           $dlg->getobj('pathvalue')->text( '/sbin' );
           $dlg->getobj('buttons')->{'-selected'} = 1;
       } );
    $self->assert_null( $widget->browse_dialog(),
                        'expected undef from browse_dialog()' );
}

1;
