package tests::ConfigReportSpecTest;

use strict;

use tests::ConfigSpecTest;

use base qw/tests::ConfigTypeSpecBase/;

use Lire::Config::ReportSpec;

sub new {
    my $self = shift->SUPER::new( @_ );

    return $self;
}

sub set_up {
    my $self = $_[0];

    $self->SUPER::set_up();
    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    return;
}

sub type {
    return 'Lire::Config::ReportSpec';
}

sub test_new {
    my $self = $_[0];

    $self->SUPER::test_new();

    my $spec = new Lire::Config::ReportSpec( 'name' => 'www_default' );
    $self->assert_str_equals( 'Lire::ReportConfig', $spec->class() );
    $self->assert_str_equals( 'id', $spec->label_component() );

    my $components = [ $spec->components() ];
    $self->assert_num_equals( 3, scalar @$components );
    $self->assert_isa( 'Lire::Config::StringSpec', $components->[0] );
    $self->assert_str_equals( 'id', $components->[0]->name() );
    $self->assert_not_null( $components->[0]->summary() );
    $self->assert_not_null( $components->[0]->text_description() );
    $self->assert_str_equals( 'id', $spec->label_component() );

    $self->assert_isa( 'Lire::Config::StringSpec', $components->[1] );
    $self->assert_str_equals( 'title', $components->[1]->name() );
    $self->assert_not_null( $components->[1]->summary() );
    $self->assert_not_null( $components->[1]->text_description() );

    $self->assert_isa( 'Lire::Config::ListSpec', $components->[2] );
    $self->assert_str_equals( 'sections', $components->[2]->name() );
    $self->assert_not_null( $components->[2]->summary() );
    $self->assert_not_null( $components->[2]->text_description() );

    $self->assert_num_equals( 1, scalar $components->[2]->components() );
    my ( $sections ) = $components->[2]->components();
    $self->assert_str_equals( 'section', $sections->name() );
    $self->assert_not_null( $sections->summary() );
    $self->assert_not_null( $sections->text_description() );
}


1;

