package tests::functional::LrReportCfg2XMLTest;

use strict;

use base qw/Lire::Test::FunctionalTestCase/;
use Lire::Config::Build qw/ac_info/;
use File::Basename qw/dirname/;
use Cwd 'realpath';

use Lire::Config::SpecParser;

sub new {
    my $self = shift->SUPER::new(@_);

    $self->{'testsdir'} = realpath(dirname( __FILE__ ) . "/..");
    $self->{'lr_report_cfg2xml'} = ac_info( 'PERL' ) . ' -w '
      . ' -I ' . $self->{'testsdir'} . "/.. "
      . $self->{'testsdir'} . "/../../script/lr_report_cfg2xml";
    $self->{'schemasdir'} = $self->{'testsdir'} . "/schemas";
    $self->{'reportsdir'} = $self->{'testsdir'} . "/reports";
    $self->{'filtersdir'} = $self->{'testsdir'} . "/filters";
    $self->{'cfgspecdir'} = $self->{'testsdir'} . "/../config-spec";
    $self->{'cfgfile'} = $self->{'testsdir'} . "/data/test.cfg";
    $self->{'test_report_cfg'} = $self->{'testsdir'} . "/data/test_report_cfg.xml";

    return $self;
}

sub _set_up_path {
    my ( $self, $path_name, $path ) = @_;

    my $var = Lire::Config->get_var( $path_name );
    my $dir_spec = ($var->spec()->components())[0];

    # Clear
    while ( $var->elements() ) {
        $var->remove(0);
    }

    # Adds the new dirs
    foreach my $dir ( @$path ) {
        $var->append( $dir_spec->instance( 'value' => $dir )  );
    }
    return;
}

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    Lire::Config->init();

    $self->_set_up_path( 'lr_schemas_path', [ $self->{'schemasdir'} ] );
    $self->_set_up_path( 'lr_reports_path', [ $self->{'reportsdir'} ] );
    $self->_set_up_path( 'lr_filters_path', [ $self->{'filtersdir'} ] );

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    return;
}

sub test_usage {
    my $self = $_[0];

    my $result = $self->lire_run( $self->{'lr_report_cfg2xml'} );
    $self->assert_num_not_equals( 0, $result->status() );
    $self->assert( !$result->stdout(), "stdout should be empty" );
    $self->assert_matches( qr/Usage: /, $result->stderr() );
}

sub test_lr_report_cfg2xml {
    my $self = $_[0];

    my $cmd = "$self->{'lr_report_cfg2xml'} --cfgspecdir $self->{'cfgspecdir'}" .
      " --reportsdir $self->{'reportsdir'}" .
      " --filtersdir $self->{'filtersdir'}" .
      " --schemasdir $self->{'schemasdir'}" .
      " test test_default $self->{'cfgfile'} > test_report_cfg.xml";
    my $result = $self->lire_run( $cmd );
    $self->annotate( $result->stderr() );
    $self->assert_num_equals( 0, $result->status() );
    $self->assert( !$result->stdout(), "stdout should be empty" );
    $self->assert_does_not_match( qr/ (crit|err|warning) /, $result->stderr(),
                                  "There were warnings or error messages." );

    my $parser = new Lire::Config::SpecParser();
    my $expected = $parser->parsefile( $self->{'test_report_cfg'} );
    $parser = new Lire::Config::SpecParser();
    my $generated = $parser->parsefile( $self->rundir() .
                                        "/test_report_cfg.xml" );
    $self->assert( $generated->has_component( 'test_default' ),
                   'missing "test_default"' );
    $self->assert_num_equals( 1, scalar $generated->components() );
    $self->assert( $expected->get( 'test_default' )->has_default(),
                   "missing default" );
    $self->assert( $generated->get( 'test_default' )->has_default(),
                   "missing default" );
    $self->assert_deep_equals( $expected->get( 'test_default' )->default(),
                               $generated->get( 'test_default' )->default() );
}

1;
