/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/*****************************************************************************/
/* Liquid War is a unique multiplayer wargame                                */
/* Copyright (C) 1998-2002 Christian Mauduit                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/*                                                                           */
/* Liquid War homepage : http://www.ufoot.org/liquidwar                      */
/* Contact author      : ufoot@ufoot.org                                     */
/*****************************************************************************/

/********************************************************************/
/* nom           : mouse.c                                          */
/* contenu       : gestion de la souris                             */
/* date de modif : 3 mai 98                                         */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <allegro.h>

#include "config.h"
#include "mouse.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

int MOUSE_CONTROL_REF_X;
int MOUSE_CONTROL_REF_Y;
int MOUSE_CONTROL_UP;
int MOUSE_CONTROL_RIGHT;
int MOUSE_CONTROL_DOWN;
int MOUSE_CONTROL_LEFT;

static int MOUSE_CONTROL_GAP;

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
void update_mouse_control (void)
{
 if (mouse_y<=MOUSE_CONTROL_REF_Y-MOUSE_CONTROL_GAP)
    {
     MOUSE_CONTROL_UP=1;
     MOUSE_CONTROL_REF_Y=mouse_y+MOUSE_CONTROL_GAP;
    }
 else
     MOUSE_CONTROL_UP=0;

 if (mouse_x>=MOUSE_CONTROL_REF_X+MOUSE_CONTROL_GAP)
    {
     MOUSE_CONTROL_RIGHT=1;
     MOUSE_CONTROL_REF_X=mouse_x-MOUSE_CONTROL_GAP;
    }
 else
     MOUSE_CONTROL_RIGHT=0;

 if (mouse_y>=MOUSE_CONTROL_REF_Y+MOUSE_CONTROL_GAP)
    {
     MOUSE_CONTROL_DOWN=1;
     MOUSE_CONTROL_REF_Y=mouse_y-MOUSE_CONTROL_GAP;
    }
 else
     MOUSE_CONTROL_DOWN=0;

 if (mouse_x<=MOUSE_CONTROL_REF_X-MOUSE_CONTROL_GAP)
    {
     MOUSE_CONTROL_LEFT=1;
     MOUSE_CONTROL_REF_X=mouse_x+MOUSE_CONTROL_GAP;
    }
 else
     MOUSE_CONTROL_LEFT=0;
}

/*------------------------------------------------------------------*/
void reset_mouse_control (void)
{
 MOUSE_CONTROL_REF_X=mouse_x;
 MOUSE_CONTROL_REF_Y=mouse_y;
 MOUSE_CONTROL_GAP= 2+ (8-CONFIG_MOUSE_GAP)
                       *(8-CONFIG_MOUSE_GAP);

 if (MOUSE_CONTROL_REF_X<MOUSE_CONTROL_GAP)
    MOUSE_CONTROL_REF_X=MOUSE_CONTROL_GAP;
 if (MOUSE_CONTROL_REF_Y<MOUSE_CONTROL_GAP)
    MOUSE_CONTROL_REF_Y=MOUSE_CONTROL_GAP;
 if (MOUSE_CONTROL_REF_X>SCREEN_W-MOUSE_CONTROL_GAP-1)
    MOUSE_CONTROL_REF_X=SCREEN_W-MOUSE_CONTROL_GAP-1;
 if (MOUSE_CONTROL_REF_Y>SCREEN_H-MOUSE_CONTROL_GAP-1)
    MOUSE_CONTROL_REF_Y=SCREEN_H-MOUSE_CONTROL_GAP-1;

 position_mouse (MOUSE_CONTROL_REF_X,MOUSE_CONTROL_REF_Y);
 update_mouse_control ();
}


