/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <ncurses.h>
#include <panel.h>
#include <errno.h>
#include <time.h>
#include <sys/time.h>
#include <ctype.h>
#include <pthread.h>
#include "error.h"
#include "rc.h"
#include "streamer.h"
#include "curse.h"
#include "linuxtrade.h"
#include "minihtml.h"
#include "symlookup.h"

/*
 * TODO. Oh yeah, there's bugs in here.
 */
static WINDOW	*Win;
static WINDOW	*Subwin;
static PANEL	*Panel;

static int	Cursor;		// Article line number at top of display
static int	MaxCursor;	// Maximum value for above
static int	NumLines;	// Number of lines in the article
static STREAMER	Sr = NULL;

#define	PADLINES	700

//
// TODO: make this asynchronous
//

static void
display_more(void)
{
	mvwaddch(Win, 1, getmaxx(Win)-1,
		Cursor ? ACS_UARROW : ACS_VLINE);

	mvwaddch(Win, getmaxy(Win)-2, getmaxx(Win)-1,
		(Cursor < MaxCursor) ? ACS_DARROW : ACS_VLINE);
}

static TBLCOL	Col[] =
{
	{  0, 99999},
	{  0, 9 },	//Symbol
	{ 11, 48 },	//Name
	{ 50, 59 },	//Market
	{ 61, 69 },	//Type
	{ 69, 68 },	//MoreInfo (ignore)
	{ 69, 68 },	//Add (ignore)
	{ 0, 99999 }
};
#define	NUMCOL	asizeof(Col)

static int	GotSome;

static void
postwordhook(int *tblcolp, char *wbuf,int wlen)
{
	if (*tblcolp)
		++GotSome;
}

static void
get_symlookup(char *str)
{
	FILE	*fp;
	char	buf[BUFSIZ];

	sprintf(buf, "%s \"http://finance.yahoo.com/l?m=US&s=%s&t=S\"",
			SUCKURL, str);

	fp = popen(buf, "r");
	if (!fp)
	{
		mvwprintw(Subwin, getmaxy(Subwin)/2, 20,
				"Can't access symlookup");
		touchwin(Win);
		return;
	}

	/*
	 * Eat lines until we see the table
	 */
	//minihtml_skip_past_line(fp, "  <TR align=middle><TD>");
	//minihtml_skip_past_line(fp, "<table border=0 ");
	minihtml_skip_past_line(fp, "<!--- Background table");

	/*
	 * Parse HTML
	 */
	GotSome = 0;
	minihtml_parse(Subwin, fp, Col, NUMCOL, MHP_DEFAULT,
			NULL, postwordhook, NULL, NULL);

	pclose(fp);

	if (!GotSome)
		mvwcenter(Subwin, getmaxy(Win)/2 - 1, "No Symbols Found");

	Cursor = 0;
	NumLines = getcury(Subwin) + 1;
	MaxCursor = NumLines - (getmaxy(Win) - 2);
	if (MaxCursor < 0)
		MaxCursor = 0;

	display_more();

	copywin(Subwin, Win,
			Cursor, 0,
			1, 1,
			getmaxy(Win)-2, getmaxx(Win)-2,
			FALSE);
	move(LINES-1, CursorX);
	update_panels();
	doupdate();
}

void
symlookup_popup(STREAMER sr, char *str)
{
	int	n;
	int	cols;

	// Clear alert, if any
	mvprintw(1, 7, "      ");

	n = LINES - 4 - 2 - NumStock - 12;
	if (n < 24)
		n = 24;
	Win = bestwin(n);
	if (!Win)
		error(1, "Can't create symlookup window\n");

	cols = getmaxx(Win);

	wbkgd(Win, Reverse ? A_REVERSE : A_NORMAL);

	box(Win, 0, 0);
	mvwcenter(Win, 0, "Symbol Lookup");

	//
	// Turns out, this works best for most news articles and an 80
	// column xterm. We will clip columns 78 and 79, but there are
	// only blanks there in the news articles I've seen.  For smaller
	// displays, we are screwed anyway.
	//
	Subwin = newpad(PADLINES, cols - 2);
	if (!Subwin)
		error(1, "Can't create symlookup pad\n");
	wbkgd(Subwin, Reverse ? A_REVERSE : A_NORMAL);

	Panel = new_panel(Win);

	// Paint empty frame to give user some feedback
	clearok(Win, TRUE);
	update_panels(); doupdate();

	Sr = sr;
	get_symlookup(str);
}

static void
popdown(void)
{
	hide_panel(Panel);
	update_panels();
	del_panel(Panel);
	delwin(Subwin);
	delwin(Win);
	Win = 0;
	Subwin = 0;
	Sr = NULL;
}

int
symlookup_command(int c, STREAMER sr)
{
	MEVENT	m;

	switch (c)
	{
	case '\f':
		move(LINES-1, CursorX);
		wrefresh(curscr);
		return -1;
	case 'j':
	case KEY_DOWN:
		if (++Cursor > MaxCursor)
		{
			--Cursor;
			beep();
			break;
		}
		break;
	case 'k':
	case KEY_UP:
		if (--Cursor < 0)
		{
			++Cursor;
			beep();
			break;
		}
		break;
	case '-':
	case KEY_PPAGE:
		if (Cursor == 0)
		{
			beep();
			break;
		}
		Cursor -= getmaxy(Win) - 2 - 1;
		if (Cursor < 0)
			Cursor = 0;
		break;
	case '+':
	case ' ':
	case KEY_NPAGE:
		if (Cursor == MaxCursor)
		{
			beep();
			break;
		}
		Cursor += getmaxy(Win) - 2 - 1;
		if (Cursor > MaxCursor)
			Cursor = MaxCursor;
		break;
	case '0':
	case KEY_HOME:
		Cursor = 0;
		break;
	case '$':
	case KEY_END:
		Cursor = MaxCursor;
		break;

	case KEY_F(11):
		print_rect_troff(getbegy(Win), getbegx(Win),
				getmaxy(Win), getmaxx(Win),
				NULL, "screen.tr");
		break;
	case KEY_F(12):
	case CTRL('P'):
	case KEY_PRINT:
		print_window(Subwin, NumLines,
				get_rc_value(RcFile, "print_cmd"));
		break;

		// Change stocklist on main screen
	case '1': case '2': case '3': case '4': case '5':
	case '6': case '7': case '8': case '9':
		return 3;

	case KEY_MOUSE:
		if (getmouse(&m) != OK)
			break;

		// Ignore clicks in our window
		if (m.y >= getbegy(Win)
			&& m.y < getbegy(Win) + getmaxy(Win))
			break;

		// popdown and reprocess clicks in main window
		if (ungetmouse(&m) == OK)
			Ungetch = 1;
		popdown();
		return 2;

		// Quick switches to another popup
	case 'p':
	case 'e':
		popdown();
		return 1;

		// Regular exit
	case 033:
	case 'q':
	case 'x':
		popdown();
		return 2;
	default:
		beep();
		break;
	}

	display_more();
	copywin(Subwin, Win,
			Cursor, 0,
			1, 1,
			getmaxy(Win)-2, getmaxx(Win)-2,
			FALSE);
	move(LINES-1, CursorX);
	update_panels();
	doupdate();

	return (-1);
}
