/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

typedef struct
{
	char	*name;
	char	*defvalue;
	int	type;
		#define RC_STR	0	/* A string */
		#define RC_NUM	1	/* An integer */
		#define	RC_PASS	2	/* A password */
		#define	RC_LIST	3	/* A list of valid strings */
		#define	RC_COMBO 4	/* A list of strings or user string */
	int	min;
	int	max;
	char	*comment;

	char	*value;

} RCFILE;

void	process_rc_file(RCFILE *rcp, char *filename);
int	set_rc_value(RCFILE *rcp, char *name, char *value);
char	*get_rc_value(RCFILE *rcp, char *name);
int	save_rc_file(RCFILE *rcp, char *filename);

void	print_rc_file(RCFILE *rcp, FILE *fp);
