#pragma interface
#ifndef TLMPLIB_H
#define TLMPLIB_H

#include <stdio.h>

#define _TLMP_tlmpprogram

struct _F_tlmpprogram{
	#define _F_tlmpprogram_usage(x) void x usage()
	virtual _F_tlmpprogram_usage( )=0;
	#define _F_tlmpprogram_onearg(x) int x onearg(const char *opt, const char *val)
	virtual _F_tlmpprogram_onearg( );
	#define _F_tlmpprogram_main(x) int x main(int argc, char *argv[])
	virtual _F_tlmpprogram_main( );
	#define _F_tlmpprogram_showerror(x) void x showerror(const char *msg)
	virtual _F_tlmpprogram_showerror( );
	#define _F_tlmpprogram_main_noarg(x) int x main_noarg()
	virtual _F_tlmpprogram_main_noarg( );
};

#include <sys/types.h>

#define _TLMP_loadfile

struct _F_loadfile{
	class _F_loadfile_private *priv;
	#define _F_loadfile_oneline(x) int x oneline(const char *line, off_t filepos, int noline)
	virtual _F_loadfile_oneline( )=0;
	#define _F_loadfile_start(x) void x start()
	virtual _F_loadfile_start( );
	#define _F_loadfile_end(x) void x end(off_t filepos)
	virtual _F_loadfile_end( );
	#define _F_loadfile_empty(x) void x empty()
	virtual _F_loadfile_empty( );
	#define _F_loadfile_missing(x) void x missing(const char *fname)
	virtual _F_loadfile_missing( );
};
#define _TLMP_savefile

struct _F_savefile{
	class _F_savefile_private *priv;
	#define _F_savefile_dowrite(x) int x dowrite(FILE *fout, const char *fname)
	virtual _F_savefile_dowrite( )=0;
	#define _F_savefile_openfail(x) void x openfail(const char *fname)
	virtual _F_savefile_openfail( );
	#define _F_savefile_end(x) void x end(FILE *fout, const char *fname)
	virtual _F_savefile_end( );
	#define _F_savefile_start(x) void x start(FILE *fout, const char *fname)
	virtual _F_savefile_start( );
};

#define _TLMP_walkpopen

struct _F_walkpopen{
	class _F_walkpopen_private *priv;
	void close_input();
	#define _F_walkpopen_oneline(nom) int nom oneline (const char *line, int noline, FILE *fout)
	virtual _F_walkpopen_oneline( ) = 0;
	#define _F_walkpopen_oneerr(nom) int nom oneerr (const char *line, const char *command, FILE *fout)
	virtual _F_walkpopen_oneerr( );
	#define _F_walkpopen_empty(nom) void nom empty (const char *command)
	virtual _F_walkpopen_empty( );
	#define _F_walkpopen_start(nom) void nom start (FILE *fout, bool &end)
	virtual _F_walkpopen_start( );
	#define _F_walkpopen_end(nom) void nom end ()
	virtual _F_walkpopen_end( );
	#define _F_walkpopen_fail(nom) void nom fail (const char *command)
	virtual _F_walkpopen_fail( );
	#define _F_walkpopen_init(nom) void nom init (FILE *fout, bool &end)
	virtual _F_walkpopen_init( );
};

#define _TLMP_walkfs

struct _F_walkfs{
	class _F_walkfs_private *priv;
	void end();
	#define _F_walkfs_onefile(nom) void nom onefile(const char *path, const char *basename, const char *relpath, int depth)
	virtual _F_walkfs_onefile( )=0;
	#define _F_walkfs_recurse(nom) bool nom recurse(const char *dir, const char *basename, const char *relpath, int depth)
	virtual _F_walkfs_recurse( );
};

#define _TLMP_copyfile

struct _F_copyfile{
	class _F_copyfile_private *priv;
	#define _F_copyfile_progress(x) void x progress(const char *src, const char *dst, size_t size, size_t sofar, bool &end)
	virtual _F_copyfile_progress( );
	#define _F_copyfile_fail(x) void x fail(const char *src, const char *dst, const char *details)
	virtual _F_copyfile_fail( );
};

#define _TLMP_sort
class ARRAY_OBJ;

struct _F_sort {
	#define _F_sort_cmp(x) int x cmp (const ARRAY_OBJ *o1, const ARRAY_OBJ *o2)
	virtual _F_sort_cmp( )=0;
};

class SSTREAM;
class ARRAY;

#include "tlmplib.p"

#endif

