#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <unistd.h>
#include <translat.h>
#include "shellmod.m"
#include "shellmod.h"
#include "protocol.h"
#include "../../paths.h"

static void usage()
{
	fprintf (stderr
		,MSG_U(I_PRGUSAGE
			,"shellmod [ --debug ] script [ options ]\n"
			 "\n"
			 "\tRun a Linuxconf module/script.\n"
			 "shellmod --build\n"
			 "\n"
			 "\tEnter the builder\n")
		); 
}

int perm_getuid()
{
	return getuid();
}

bool shellmod_haspriv (const char *)
{
	return true;
}

int main (int argc, char *argv[])
{
	int ret = -1;
	linuxconf_loadlibmsg("/usr/lib/linuxconf");
	linuxconf_loadmsg ("shellmod",PACKAGE_REV);
	argc = dialog_parseuioptions(argc,argv);
	translat_checkmissing();

	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	#if 0
		for (int i=0; i<argc; i++){
			printf ("argv[%d] = :%s:\n",i,argv[i]);
		}
	#endif
	if (argc < 2){
		usage();
	}else if (strcmp(pt,"shellmod")==0){
		if (argc == 2 && strcmp(argv[1],"--build")==0){
			shellmod_build();
		}else{
			shellprg_exec (argc-1,argv+1);
		}
	}else{
		shellprg_exec (argc-1,argv+1);
	}
	return ret;
}

