#!/usr/bin/shellmod --perl
# Find old files in directories. To test, either do
#	findold.pl
# or
#	linuxconf --modulemain shellmod --setmod findold.pl
#    and visit the "misc services" menu. Requires linuxconf 1.16r10

$DBGSHELLMOD=1;
require "/usr/lib/linuxconf/lib/shellmod-lib.pl";

sub register
{
    regmenu("main", "MENU_MISCSERV", "Find old files");
}

sub filedo
{
    my($file) = @_;
    notice("do something with file $file");
}

sub main
{
    my($dir) = @_;
    dialog();
    newf_str("dir", "Directory to scan", $dir);
    newf_num("days", "Number of days", 10);
    edit("find old files", "Front-end to the find command");
    my(%out) = dispatch();
    end();
    if ($out{CODE} eq "accept") {
	dialog_list();
	newf_head("Files older than $out{days} days");
	open(IN, "find $out{dir} -atime +$out{days} |");
	while (<IN>) {
	    chop;
	    new_menuitem("filedo $_", $_);
	}
	editmenu("Old files", "");
	dispatch();
	end();
    }
}
dispatch();


