#!/bin/sh
# create a new module directory and template files
if [ -d ../builder/templates ] ; then
	BUILDERDIR=../../builder/templates
	MAKEFILE=Makefile
	if [ ! -d netadm -a ! -d apache ] ; then
		echo setup.sh must be execute from the modules sub-directory
		echo of the linuxconf source tree
		exit 1
	fi
elif [ -d /usr/lib/linuxconf-devel/templates ] ; then
	BUILDERDIR=/usr/lib/linuxconf-devel/templates
	MAKEFILE=Makefile.standalone
	MAKEFILEHELP=Makefile.help
else
	echo "unable to find modules templates in ../builder/templates"
	echo "     or /usr/lib/linuxconf-devel/templates"
	echo "make sure you have them and run this script from the directory"
	echo "where you want to create the module sub-directory"
	exit 1
fi

echo
echo "About to create a new linuxconf's modules"
echo
echo -n "Enter the name of the module: "
read module
if [ -d $module ] ; then
	echo This module already exist
	exit 1
fi
echo "0-No menu entry for this module"
echo "1-MENU_NETWORK_CLIENT: Client section of the network menu"
echo "2-MENU_NETWORK_SERVER: Server section of the network menu"
echo "3-MENU_NETWORK_BOOT  : Boot services section of the network menu"
echo "4=MENU_NETWORK_FIREWALL: Firewalling section of the network menu"
echo "5-MENU_NETWORK_MISC  : Misc section of the network menu"
echo "6-MENU_MAIN_CONFIG   : Config section of the main linuxconf menu"
echo "7-MENU_MAIN_CONTROL  : Control section of the main linuxconf menu"
echo "8-MENU_CTRL_FILE     : Control files and systems"
echo "9-MENU_CONTROL_PANEL : Control panel"
echo "a-MENU_USER_STD      : Standard user account section"
echo "b-MENU_USER_SPC      : Special user account section"
echo "c-MENU_USER_POLICIES : Policies in user account section"
echo "d-MENU_USER_ALIAS    : Aliases in user account section"
echo "e=MENU_LOGS          : Logs"
echo "f=MENU_SYS_STATUS    : System status"
echo "g=MENU_MISCSERV      : Miscellaneous services"
echo "h=MENU_FSCONF        : File system configuration"
echo "i=MENU_GURUS         : Friendly gurus"
echo "j=MENU_BOOT          : Boot mode and configuration"
echo "k=MENU_HARDWARE      : Hardware/peripherals configuration"

echo
echo -n "Enter in which menu you want to insert the module "
read menu
if [ "$menu" != "0" ] ; then
	echo
	echo -n "Enter the menu entry title: "
	read menutitle
	case $menu in
	1)
		menuenum=MENU_NETWORK_CLIENT
		;;
	2)
		menuenum=MENU_NETWORK_SERVER
		;;
	3)
		menuenum=MENU_NETWORK_BOOT
		;;
	4)
		menuenum=MENU_NETWORK_FIREWALL
		;;
	5)
		menuenum=MENU_NETWORK_MISC
		;;
	6)
		menuenum=MENU_MAIN_CONFIG
		;;
	7)
		menuenum=MENU_MAIN_CONTROL
		;;
	8)
		menuenum=MENU_CTRL_FILE
		;;
	9)
		menuenum=MENU_CONTROL_PANEL
		;;
	a)
		menuenum=MENU_USER_STD
		;;
	b)
		menuenum=MENU_USER_SPC
		;;
	c)
		menuenum=MENU_USER_POLICIES
		;;
	d)
		menuenum=MENU_USER_ALIAS
		;;
	e)
		menuenum=MENU_LOGS
		;;
	f)
		menuenum=MENU_SYS_STATUS
		;;
	g)
		menuenum=MENU_MISCSERV
		;;
	h)
		menuenum=MENU_FSCONF
		;;
	i)
		menuenum=MENU_GURUS
		;;
	j)
		menuenum=MENU_BOOT
		;;
	k)
		menuenum=MENU_HARDWARE
		;;
	esac
fi

while true
do
	echo
	echo TLMP documentation is available at http://www.solucorp.qc.ca/tlmp
	echo "1-Build the module using C++"
	echo "2-Build the module using TLMP"
	echo -n "Your choice "
	read TLMP
	if [ "$TLMP" = 1 -o "$TLMP" = 2 ] ; then
		break
	else
		echo Select either 1 or 2
	fi
done

mkdir $module
cd $module
# Creating the Makefile
cat $BUILDERDIR/$MAKEFILE \
	| sed s/MODULEN/$module/ \
	| sed s/MODULEN/$module/ \
	>Makefile

if [ "$MAKEFILEHELP" != "" ] ; then
	mkdir help.files help.files/sources
	cat $BUILDERDIR/$MAKEFILEHELP | sed s/MODULEN/$module/ \
 		> help.files/sources/Makefile
fi

# Creating the main header

echo "#ifndef ${module}_h" >$module.h
echo "#define ${module}_h" >>$module.h
echo "#pragma interface" >>$module.h

echo "#ifndef MISC_H"	>>$module.h
echo "    #include <misc.h>"	>>$module.h
echo "#endif"			>>$module.h
echo "#ifndef MODULE_H"	>>$module.h
echo "    #include <module.h>" >>$module.h
echo "#endif"			>>$module.h
echo 					>>$module.h
echo "#include <modapi_def.h>"	>>$module.h
echo "#include <modapi.h>"		>>$module.h

if [ "$TLMP" = "1" ] ; then
	echo "class MODULE_$module: public LINUXCONF_MODULE{"	>>$module.h
	echo "    /*~PROTOBEG~ MODULE_$module */"	>>$module.h
	echo "    /*~PROTOEND~ MODULE_$module */"	>>$module.h
	echo "};"									>>$module.h
fi
echo										>>$module.h
echo "#include \"$module.p\""				>>$module.h
echo										>>$module.h
echo "#endif"								>>$module.h

# Creating the dispatch
if [ "$TLMP" = 1 ] ; then
	cat $BUILDERDIR/module-intro.cc \
		| sed s/MODULEN/$module/ \
		| sed s/MODULEN/$module/ >$module.cc

	echo >>$module.cc

	if [ "$menu" != "0" ] ; then

		cat $BUILDERDIR/module-menu.cc \
			| sed s/MODULEN/$module/  \
			| sed s/MENUID/$menuenum/  \
			| sed "s/MENUTITLE/$menutitle/" >>$module.cc

	fi

	echo >>$module.cc

	cat $BUILDERDIR/module-html.cc \
		| sed s/MODULEN/$module/ \
		| sed s/MODULEN/$module/ >>$module.cc

	echo >>$module.cc

	cat $BUILDERDIR/module-main.cc \
		| sed s/MODULEN/$module/ \
		| sed s/MODULEN/$module/ >>$module.cc

	echo >>$module.cc

	cat $BUILDERDIR/module-end.cc \
		| sed s/MODULEN/$module/ \
		| sed s/MODULEN/$module/ >>$module.cc
elif [ "$TLMP" = 2 ] ; then
	cat $BUILDERDIR/module-intro.tlcc | sed s/MODULEN/$module/ >$module.tlcc
	if [ "$menu" != "0" ] ; then
		cat $BUILDERDIR/module-menu.tlcc \
			| sed s/MODULEN/$module/  \
			| sed s/MENUID/$menuenum/  \
			| sed "s/MENUTITLE/$menutitle/" >>$module.tlcc
	fi
	cat $BUILDERDIR/module-end.tlcc | sed s/MODULEN/$module/ >>$module.tlcc
fi

cat $BUILDERDIR/_dict.cc | sed s/MODULEN/$module/ >_dict.cc

echo "Enter a single line summary of the module"
read line
echo $line >Summary
if [ -d ../../descriptions/eng ] ; then
	echo $line >../../descriptions/eng/$module
else
	mkdir descriptions
	echo $line >descriptions/eng
fi
echo "Enter a longer description and end with ^D"
cat >Description
echo
echo The summary and description are stored
echo in the files Summary and Description.
echo They will be used to prepare packages.
echo
echo Type \'make msg\' to create $module.m
echo \'make proto\' to create $module.p and update the C++
echo class definition. To make the latter command work, you\'ll
echo need the linuxconf-tools package from
echo ftp://ftp.solucorp.qc.ca/pub/linuxconf/tools
echo
echo -n "Enter your name "
read name
echo -n "Enter your email "
read email
echo $name >AUTHOR
echo $email >>AUTHOR
echo Your name and email were stored in the file AUTHOR.

