#ifndef lcfield_h
#define lcfield_h

/* LCFieldString */

typedef struct {
	PyObject_HEAD
	const char *prompt;
	SSTRING *value;
} LCFieldStringObject;

extern PyTypeObject LCFieldString_Type;

#define LCFieldString_Check(op) ((op)->ob_type == &LCFieldString_Type)

PyObject *LCFieldString_New(const char *prompt, SSTRING *value);
const char *LCFieldString_Prompt(PyObject *field);
SSTRING *LCFieldString_Value(PyObject *field);

/* LCFieldCombo */

typedef struct {
	LCFieldStringObject parent;
	M_FIELD_COMBO *combo;
} LCFieldComboObject;

extern PyTypeObject LCFieldCombo_Type;

#define LCFieldCombo_Check(op) ((op)->ob_type == &LCFieldCombo_Type)

PyObject *LCFieldCombo_New(M_FIELD_COMBO *combo, const char *prompt,
		           SSTRING *value);
const char *LCFieldCombo_Prompt(PyObject *field);
SSTRING *LCFieldCombo_Value(PyObject *field);
M_FIELD_COMBO *LCFieldCombo_Combo(PyObject *field);

/* LCFieldRadio */

typedef struct {
	PyObject_HEAD
	const char *prompt;
	char *value;
	DIALOG *dia;
} LCFieldRadioObject;

extern PyTypeObject LCFieldRadio_Type;

#define LCFieldRadio_Check(op) ((op)->ob_type == &LCFieldRadio_Type)

PyObject *LCFieldRadio_New(char *prompt, char *value, DIALOG *dia);
const char *LCFieldRadio_Prompt(PyObject *field);
char *LCFieldRadio_Value(PyObject *field);

/* LCFieldNumber */

typedef struct {
	PyObject_HEAD
	const char *prompt;
	int *value;
} LCFieldNumberObject;

extern PyTypeObject LCFieldNumber_Type;

#define LCFieldNumber_Check(op) ((op)->ob_type == &LCFieldNumber_Type)

PyObject *LCFieldNumber_New(const char *prompt, int *value);
const char *LCFieldNumber_Prompt(PyObject *field);
int *LCFieldNumber_Value(PyObject *field);

/* LCFieldCheck */

typedef struct {
	PyObject_HEAD
	const char *prompt;
	char *value;
} LCFieldCheckObject;

extern PyTypeObject LCFieldCheck_Type;

#define LCFieldCheck_Check(op) ((op)->ob_type == &LCFieldCheck_Type)

PyObject *LCFieldCheck_New(const char *prompt, char *value);
const char *LCFieldCheck_Prompt(PyObject *field);
char *LCFieldCheck_Value(PyObject *field);

/* LCFieldCheckStr */

typedef struct {
	LCFieldNumberObject parent;
	SSTRING *value_str;
} LCFieldCheckStrObject;

extern PyTypeObject LCFieldCheckStr_Type;

#define LCFieldCheckStr_Check(op) ((op)->ob_type == &LCFieldCheckStr_Type)

PyObject *LCFieldCheckStr_New(const char *prompt, int *value,
			      SSTRING *value_str);
const char *LCFieldCheckStr_Prompt(PyObject *field);
int *LCFieldCheckStr_Value(PyObject *field);
SSTRING *LCFieldCheckStr_ValueStr(PyObject *field);

/* LCFieldButton */

typedef struct {
	PyObject_HEAD
	PRIVATE_MESSAGE *msg;
} LCFieldButtonObject;

extern PyTypeObject LCFieldButton_Type;

#define LCFieldButton_Check(op) ((op)->ob_type == &LCFieldButton_Type)

PyObject *LCFieldButton_New(PRIVATE_MESSAGE *msg);

#endif /* lcfield_h */
