/* this part deals with settings and defaults */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "pslaveconf.h"
#include "pslaveconf.m"
#include <stdlib.h>

#include <fviews.h>

#include "ps_tools.h"
#include "ps_vars.h"

// #include <private_msg.h>
// #include <dialog.h>







/*
conf.hostname	cs-1.someisp.com
conf.ipno	192.168.42.21
conf.lockdir	/var/lock
conf.rlogin	/usr/bin/port-slave/rlogin
conf.pppd	/usr/bin/port-slave/pppd
conf.telnet	/usr/bin/telnet
conf.ssh	/usr/bin/ssh
conf.locallogins	1
conf.syslog	logger.someisp.com
conf.facility	6
conf.filterdir	/usr/portslave/filters
conf.stripnames	0

all.debug	0
all.authtype    radius
all.authhost1	mainhost.someisp.com
all.accthost1	mainhost.someisp.com
all.radtimeout	3
#all.authhost2	backuphost.someisp.com
#all.accthost2	backuphost.someisp.com
#all.realm     >-@flintstone fred wilma barney zelda
#all.realm     >-@duck donald louie "" ""
#all.realm     <+U uucpauth uucpacct "" ""
all.secret	testing123
all.protocol	rlogin
all.host	shellhost.someisp.com
all.ipno	192.168.42.65+
all.netmask	255.255.255.255
all.mtu		1500
all.issue	\n\
        Cistron Internet Services \n\
         POP Alphen aan den Rijn \n\
     Welcome to terminal server %h port S%p\n
all.prompt	Cistron login:
all.term	vt100
all.sysutmp	1
all.syswtmp	0
all.porttype	0
all.speed	115200
all.initchat	"" \d\l\dATZ OK\r\n-ATZ-OK\r\n
all.waitfor	RING
all.answer	"" ATA CONNECT@
all.aa		0
all.checktime	60
all.checkchat	"" AT OK
all.flow	hard
all.dcd		1
all.autoppp	proxyarp modem asyncmap 0 %i: \
		noipx noccp login auth require-pap refuse-chap \
		mtu %t mru %t \
		ms-dns 192.168.1.1 ms-dns 192.168.1.2 \
		uselib /usr/lib/libpsr.so
all.pppopt	proxyarp modem asyncmap 0 %i:%j \
		noipx noccp mtu %t mru %t netmask %m \
		idle %I maxconnect %T \
		ms-dns 192.168.1.1 ms-dns 192.168.1.2
		uselib /usr/lib/libpsr.so
*/

struct {
    char hostname[TYPICAL_FIELD_SIZE];
    char ipno[TYPICAL_FIELD_SIZE];
    char lockdir[TYPICAL_FIELD_SIZE];
    char rlogin[TYPICAL_FIELD_SIZE];
    char pppd[TYPICAL_FIELD_SIZE];
    char telnet[TYPICAL_FIELD_SIZE];
    char ssh[TYPICAL_FIELD_SIZE];
    char locallogins[TYPICAL_FIELD_SIZE];
    char locallogins_gui; /* needed by gui */
    char syslog[TYPICAL_FIELD_SIZE];
    char facility[TYPICAL_FIELD_SIZE];
    SSTRING facility_gui;    /* needed by gui */
    char filterdir[TYPICAL_FIELD_SIZE];
    char stripnames[TYPICAL_FIELD_SIZE];
    char stripnames_gui; /* needed by gui */
} vconf;

struct {
    char debug[TYPICAL_FIELD_SIZE];
    char debug_gui; /* needed by gui */
    char authtype[TYPICAL_FIELD_SIZE];
    SSTRING authtype_gui; /* needed by gui */
    char authhost1[TYPICAL_FIELD_SIZE];
    char accthost1[TYPICAL_FIELD_SIZE];
    char radtimeout[TYPICAL_FIELD_SIZE];
    int  radtimeout_gui; /* needed by gui */
    char authhost2[TYPICAL_FIELD_SIZE];
    char accthost2[TYPICAL_FIELD_SIZE];
//    char realm[TYPICAL_FIELD_SIZE];
//    char realm[TYPICAL_FIELD_SIZE];
//    char realm[TYPICAL_FIELD_SIZE];
    char secret[TYPICAL_FIELD_SIZE];
    char protocol[TYPICAL_FIELD_SIZE];
    SSTRING protocol_gui; /* needed by gui */
    char host[TYPICAL_FIELD_SIZE];
    char ipno[TYPICAL_FIELD_SIZE]; /* this data is splitted in two */
    char ipno_gui[TYPICAL_FIELD_SIZE]; /* needed by gui */
    char ipno2_gui; /* needed by gui */
    char netmask[TYPICAL_FIELD_SIZE];
    char mtu[TYPICAL_FIELD_SIZE];
    int  mtu_gui; /* needed by gui */
    char issue[TYPICAL_FIELD_SIZE];
    char prompt[TYPICAL_FIELD_SIZE];
    char term[TYPICAL_FIELD_SIZE];
    SSTRING term_gui; /* needed by gui */
    char sysutmp[TYPICAL_FIELD_SIZE];
    char sysutmp_gui; /* needed by gui */
    char syswtmp[TYPICAL_FIELD_SIZE];
    char syswtmp_gui; /* needed by gui */
    char porttype[TYPICAL_FIELD_SIZE];
    SSTRING porttype_gui; /* needed by gui */
    char speed[TYPICAL_FIELD_SIZE];
    SSTRING speed_gui; /* needed by gui */
    char initchat[TYPICAL_FIELD_SIZE];
    char waitfor[TYPICAL_FIELD_SIZE];
    char answer[TYPICAL_FIELD_SIZE];
    char aa[TYPICAL_FIELD_SIZE];
    char aa_gui; /* needed by gui */
    char checktime[TYPICAL_FIELD_SIZE];
    int  checktime_gui; /* needed by gui */
    char checkchat[TYPICAL_FIELD_SIZE];
    char flow[TYPICAL_FIELD_SIZE];
    SSTRING flow_gui; /* needed by gui */
    char dcd[TYPICAL_FIELD_SIZE];
    char dcd_gui; /* needed by gui */
    char autoppp[TYPICAL_FIELD_SIZE];
    char pppopt[TYPICAL_FIELD_SIZE];

    SSTRING realms;
} vall;

void manage_configuration_settings(void)
{
    MENU_STATUS my_button;
    DIALOG      dia_confset;
    int         my_selection=0;

    FIELD_LIST  *pop_facility;
    FIELD_COMBO *co_authtype;
    FIELD_COMBO *co_term;
    FIELD_LIST  *pop_porttype;
    FIELD_COMBO *co_speed;
    FIELD_LIST  *pop_flow;
    FIELD_COMBO *co_protocol;

    VIEWITEMS   vitems_pslave;     /* used with linuxconf's parser */

    // load variables with data from file
    vitems_pslave.read(cf_pslave);

    loadfromfile("conf.hostname", vconf.hostname, vitems_pslave);
    loadfromfile("conf.ipno", vconf.ipno, vitems_pslave);
    loadfromfile("conf.lockdir", vconf.lockdir, vitems_pslave);
    loadfromfile("conf.rlogin", vconf.rlogin, vitems_pslave);
    loadfromfile("conf.pppd", vconf.pppd, vitems_pslave);
    loadfromfile("conf.telnet", vconf.telnet, vitems_pslave);
    loadfromfile("conf.ssh", vconf.ssh, vitems_pslave);
    loadfromfile("conf.locallogins", vconf.locallogins, vitems_pslave);
    loadfromfile("conf.syslog", vconf.syslog, vitems_pslave);
    loadfromfile("conf.facility", vconf.facility, vitems_pslave);
    loadfromfile("conf.filterdir", vconf.filterdir, vitems_pslave);
    loadfromfile("conf.stripnames", vconf.stripnames, vitems_pslave);

    loadmultilinefromfile("all.realm", vall.realms, vitems_pslave);

    loadfromfile("all.debug", vall.debug, vitems_pslave);
    loadfromfile("all.authtype", vall.authtype, vitems_pslave);
    loadfromfile("all.authhost1", vall.authhost1, vitems_pslave);
    loadfromfile("all.accthost1", vall.accthost1, vitems_pslave);
    loadfromfile("all.radtimeout", vall.radtimeout, vitems_pslave);
    loadfromfile("all.authhost2", vall.authhost2, vitems_pslave);
    loadfromfile("all.accthost2", vall.accthost2, vitems_pslave);
//    loadfromfile("all.realm", vall.realm, vitems_pslave);
    loadfromfile("all.secret", vall.secret, vitems_pslave);
    loadfromfile("all.protocol", vall.protocol, vitems_pslave);
    loadfromfile("all.host", vall.host, vitems_pslave);
    loadfromfile("all.ipno", vall.ipno, vitems_pslave);
    loadfromfile("all.netmask", vall.netmask, vitems_pslave);
    loadfromfile("all.mtu", vall.mtu, vitems_pslave);
    loadfromfile("all.issue", vall.issue, vitems_pslave);
    loadfromfile("all.prompt", vall.prompt, vitems_pslave);
    loadfromfile("all.term", vall.term, vitems_pslave);
    loadfromfile("all.sysutmp", vall.sysutmp, vitems_pslave);
    loadfromfile("all.syswtmp", vall.syswtmp, vitems_pslave);
    loadfromfile("all.porttype", vall.porttype, vitems_pslave);
    loadfromfile("all.speed", vall.speed, vitems_pslave);
    loadfromfile("all.initchat", vall.initchat, vitems_pslave);
    loadfromfile("all.waitfor", vall.waitfor, vitems_pslave);
    loadfromfile("all.answer", vall.answer, vitems_pslave);
    loadfromfile("all.aa", vall.aa, vitems_pslave);
    loadfromfile("all.checktime", vall.checktime, vitems_pslave);
    loadfromfile("all.checkchat", vall.checkchat, vitems_pslave);
    loadfromfile("all.flow", vall.flow, vitems_pslave);
    loadfromfile("all.dcd", vall.dcd, vitems_pslave);
    loadfromfile("all.autoppp", vall.autoppp, vitems_pslave);
    loadfromfile("all.pppopt", vall.pppopt, vitems_pslave);


    /* transfer to gui variables */
    vconf.locallogins_gui=atoi(vconf.locallogins);
    vconf.facility_gui.setfrom(vconf.facility);
    vconf.stripnames_gui=atoi(vconf.stripnames);
    vall.debug_gui=atoi(vall.debug);
    vall.authtype_gui.setfrom(vall.authtype);
    vall.radtimeout_gui=atoi(vall.radtimeout);
    vall.mtu_gui=atoi(vall.mtu);
    vall.term_gui.setfrom(vall.term);
    vall.sysutmp_gui=atoi(vall.sysutmp);
    vall.syswtmp_gui=atoi(vall.syswtmp);
    vall.porttype_gui.setfrom(vall.porttype);
    vall.speed_gui.setfrom(vall.speed);
    vall.aa_gui=atoi(vall.aa);
    vall.checktime_gui=atoi(vall.checktime);
    vall.flow_gui.setfrom(vall.flow);
    vall.dcd_gui=atoi(vall.dcd);
    vall.protocol_gui.setfrom(vall.protocol);
    /* splits vall.ipno to vall.ipno_gui and vall.ipno2_gui */
    {
        int size_of_ipno_string;

        *vall.ipno_gui=0;
        vall.ipno2_gui=0;
        if((size_of_ipno_string=strlen(vall.ipno))){
            strcpy(vall.ipno_gui, vall.ipno);
            if(*(vall.ipno_gui+size_of_ipno_string-1)=='+'){
                *(vall.ipno_gui+size_of_ipno_string-1)='\0';
                vall.ipno2_gui=1;
            }
        }
    }

    /* --- settings thing --- */
    dia_confset.newf_title(MSG_U(T_SETTINGS, "Settings"), 1, "", MSG_R(T_SETTINGS));
    dia_confset.newf_str(MSG_U(F_HOSTNAME, "Hostname:"), vconf.hostname, TYPICAL_FIELD_SIZE-1);
    dia_confset.newf_str(MSG_U(F_CONFIPNUMBER, "IP number:"), vconf.ipno, TYPICAL_FIELD_SIZE-1);
    dia_confset.newf_str(MSG_U(F_LOCKDIR, "Lock dir.:"), vconf.lockdir, TYPICAL_FIELD_SIZE-1);
    dia_confset.newf_str(MSG_U(F_REMOTELOGIN, "Remote login:"), vconf.rlogin, TYPICAL_FIELD_SIZE-1);
    dia_confset.newf_str(MSG_U(F_PPPD, "PPPd:"), vconf.pppd, TYPICAL_FIELD_SIZE-1);
    dia_confset.newf_str(MSG_U(F_TELNET, "Telnet:"), vconf.telnet, TYPICAL_FIELD_SIZE-1);
    dia_confset.newf_str(MSG_U(F_SSH, "SSH:"), vconf.ssh, TYPICAL_FIELD_SIZE-1);
    // complex
    dia_confset.newf_chk("", vconf.locallogins_gui, MSG_U(F_LOCALLOGINS, "Local logins"));
    dia_confset.newf_str(MSG_U(F_SYSLOG, "Syslog:"), vconf.syslog, TYPICAL_FIELD_SIZE-1);
    // complex
    pop_facility=dia_confset.newf_list(MSG_U(F_FACILITY, "Facility:"), vconf.facility_gui);
        pop_facility->addopt("0");
        pop_facility->addopt("1");
        pop_facility->addopt("2");
        pop_facility->addopt("3");
        pop_facility->addopt("4");
        pop_facility->addopt("5");
        pop_facility->addopt("6");
        pop_facility->addopt("7");
    dia_confset.newf_str(MSG_U(F_FILTERDIR, "Filter dir.:"), vconf.filterdir, TYPICAL_FIELD_SIZE-1);
    // complex
    dia_confset.newf_chk("", vconf.stripnames_gui, MSG_U(F_STRIPNAMES, "Stripnames"));

    /* --- defaults thing --- */
    dia_confset.newf_title(MSG_U(T_PORTDEFAULTS, "Port Defaults"), 1, "", MSG_R(T_PORTDEFAULTS));
    dia_confset.newf_title(MSG_U(T_NETWORK, "Network"), 2, "", MSG_R(T_NETWORK));
    dia_confset.newf_chk("", vall.debug_gui, MSG_U(F_DEBUG, "Debug"));
    co_authtype=dia_confset.newf_combo(MSG_U(F_AUTHTYPE,"Auth type:"), vall.authtype_gui);
        co_authtype->addopt("radius");
        co_authtype->addopt("none");
    dia_confset.newf_str(MSG_U(F_AUTHHOST1, "Auth host 1:"), vall.authhost1, TYPICAL_FIELD_SIZE-1);
    dia_confset.newf_str(MSG_U(F_AUTHHOST2, "Auth host 2 (opt.):"), vall.authhost2, TYPICAL_FIELD_SIZE-1);
    dia_confset.newf_str(MSG_U(F_ACCTHOST1, "Acct host 1:"), vall.accthost1, TYPICAL_FIELD_SIZE-1);
    dia_confset.newf_str(MSG_U(F_ACCTHOST2, "Acct host 2 (opt.):"), vall.accthost2, TYPICAL_FIELD_SIZE-1);
    dia_confset.newf_num(MSG_U(F_RADTIMEOUT, "RAD timeout:"), vall.radtimeout_gui);

//    vall.realms.setfrom("dffsddfdfsdfsdfd");
    dia_confset.newf_textarea(MSG_U(F_REALMSDEF, "Realms definitions:"), vall.realms, 30, 4);

    dia_confset.newf_str(MSG_U(F_SECRET, "Secret:"), vall.secret, TYPICAL_FIELD_SIZE-1);
//    dia_confset.newf_str("Protocol:", vall.protocol, TYPICAL_FIELD_SIZE-1);
    co_protocol=dia_confset.newf_combo(MSG_U(F_PROTOCOL, "Protocol:"), vall.protocol_gui);
        co_protocol->addopt("console");
        co_protocol->addopt("cslip");
        co_protocol->addopt("login");
        co_protocol->addopt("ppp");
        co_protocol->addopt("rlogin");
        co_protocol->addopt("slip");
        co_protocol->addopt("ssh");
        co_protocol->addopt("tcpclear");
        co_protocol->addopt("tcplogin");
        co_protocol->addopt("telnet");
    dia_confset.newf_str(MSG_U(F_HOST, "Host:"), vall.host, TYPICAL_FIELD_SIZE-1);
//    dia_confset.newf_str("IP number:", vall.ipno, TYPICAL_FIELD_SIZE-1);
    dia_confset.newf_str(MSG_U(F_IPNUMBER, "IP number:"), vall.ipno_gui, TYPICAL_FIELD_SIZE-2);
    dia_confset.newf_chk("", vall.ipno2_gui, MSG_U(F_AUTOGENERATEDIPS, "Auto generated IPs (recommended)"));
    dia_confset.newf_str(MSG_U(F_NETMASK, "Netmask:"), vall.netmask, TYPICAL_FIELD_SIZE-1);
    dia_confset.newf_num(MSG_U(F_MTU, "MTU:"), vall.mtu_gui);
    dia_confset.newf_title(MSG_U(T_COMM, "Comm"), 2, "", MSG_R(T_COMM));
    dia_confset.newf_str(MSG_U(F_ISSUE, "Issue:"), vall.issue, TYPICAL_FIELD_SIZE-1);
    dia_confset.newf_str(MSG_U(F_PROMPT, "Prompt:"), vall.prompt, TYPICAL_FIELD_SIZE-1);
    co_term=dia_confset.newf_combo(MSG_U(F_TERMTYPE, "Term type:"), vall.term_gui);
        co_term->addopt("vt100");
    dia_confset.newf_chk("", vall.sysutmp_gui, MSG_U(F_UPDATEUTMP, "Update utmp"));
    dia_confset.newf_chk("", vall.syswtmp_gui, MSG_U(F_UPDATEWTMP, "Update wtmp"));
    pop_porttype=dia_confset.newf_list(MSG_U(F_PORTTYPE, "Port type:"), vall.porttype_gui);
        pop_porttype->addopt("0", MSG_U(F_PT_ASYNC, "async"), "");
        pop_porttype->addopt("1", MSG_U(F_PT_SYNC, "sync"), "");
        pop_porttype->addopt("2", MSG_U(F_PT_ISDN, "ISDN"), "");
        pop_porttype->addopt("3", MSG_U(F_PT_ISDN120, "ISDN-V120"), "");
        pop_porttype->addopt("4", MSG_U(F_PT_ISDN110, "ISDN-V110"), "");
    co_speed=dia_confset.newf_combo(MSG_U(F_SPEED, "Speed:"), vall.speed_gui);
        co_speed->addopt("300");
        co_speed->addopt("600");
        co_speed->addopt("1200");
        co_speed->addopt("2400");
        co_speed->addopt("4800");
        co_speed->addopt("9600");
        co_speed->addopt("19200");
        co_speed->addopt("38400");
        co_speed->addopt("57600");
        co_speed->addopt("115200");

//    SSTRING blah;
//    FIELD_COMBO *comb_spid=dia_confset.newf_combo("Spd:", blah);
//    comb_spid->addopt("", "Use default");
//    comb_spid->addopt("1200");
//    comb_spid->addopt("2400");

    dia_confset.newf_str(MSG_U(F_INITCHAT, "Modem init chat:"), vall.initchat, TYPICAL_FIELD_SIZE-1);
    dia_confset.newf_str(MSG_U(F_WAITFOR, "Wait for:"), vall.waitfor, TYPICAL_FIELD_SIZE-1);
    dia_confset.newf_str(MSG_U(F_ANSWER, "Answer:"), vall.answer, TYPICAL_FIELD_SIZE-1);
    dia_confset.newf_chk("", vall.aa_gui, MSG_U(F_AUTOANSWER, "Auto answer"));
    dia_confset.newf_num(MSG_U(F_CHECKTIME, "Check time:"), vall.checktime_gui);
    dia_confset.newf_str(MSG_U(F_CHECKCHAT, "Check chat:"), vall.checkchat, TYPICAL_FIELD_SIZE-1);
    pop_flow=dia_confset.newf_list(MSG_U(F_FLOWCONTROL, "Flow control:"), vall.flow_gui);
        pop_flow->addopt("hard", MSG_U(F_FC_HARD, "Hardware (RTS/CTS)"), "");
        pop_flow->addopt("soft", MSG_U(F_FC_SOFT, "Software (Xon/Xoff)"), "");
        pop_flow->addopt("none", MSG_U(F_FC_NONE, "None"), "");
    dia_confset.newf_chk("", vall.dcd_gui, MSG_U(F_USEDCD, "Use DCD line"));
    dia_confset.newf_str(MSG_U(F_AUTOPPP, "Auto PPP:"), vall.autoppp, TYPICAL_FIELD_SIZE-1);
    dia_confset.newf_str(MSG_U(F_PPPOPT, "PPP opt.:"), vall.pppopt, TYPICAL_FIELD_SIZE-1);

    //////
/*    char debug_gui; // needed by gui
    SSTRING authtype_gui; // needed by gui
    char authhost1[TYPICAL_FIELD_SIZE];
    char accthost1[TYPICAL_FIELD_SIZE];
    int  radtimeout_gui; // needed by gui
    char authhost2[TYPICAL_FIELD_SIZE];
    char accthost2[TYPICAL_FIELD_SIZE];

    char realm[TYPICAL_FIELD_SIZE];
//    char realm[TYPICAL_FIELD_SIZE];
//    char realm[TYPICAL_FIELD_SIZE];
    char secret[TYPICAL_FIELD_SIZE];
    char protocol[TYPICAL_FIELD_SIZE];
    char host[TYPICAL_FIELD_SIZE];
    char ipno[TYPICAL_FIELD_SIZE];
    char netmask[TYPICAL_FIELD_SIZE];
    int  mtu_gui; // needed by gui
    char issue[TYPICAL_FIELD_SIZE];
    char prompt[TYPICAL_FIELD_SIZE];
    SSTRING term_gui; // needed by gui
    char sysutmp_gui; // needed by gui
    char syswtmp_gui; // needed by gui
    SSTRING porttype_gui; // needed by gui
    SSTRING speed_gui; // needed by gui
    char initchat[TYPICAL_FIELD_SIZE];
    char waitfor[TYPICAL_FIELD_SIZE];
    char answer[TYPICAL_FIELD_SIZE];
    char aa_gui; // needed by gui
    int  checktime_gui; // needed by gui
    char checkchat[TYPICAL_FIELD_SIZE];
    SSTRING flow_gui; // needed by gui
    char dcd_gui; // needed by gui
    char autoppp[TYPICAL_FIELD_SIZE];
    char pppopt[TYPICAL_FIELD_SIZE];
  */







    my_button=dia_confset.editmenu(MSG_U(T_CONFIG, "Configuration for Settings and Defaults"), MSG_U(I_CONFIG, "Put a \"\" if you want\nto assign an empty value.\nEmpty field means\n\"item not defined\"."), my_confset_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT);

//    printf("--> [%s]\n", blah.get());



    /* transfer from gui variables */

    char2string(vconf.locallogins_gui, vconf.locallogins);
    strcpy(vconf.facility, vconf.facility_gui.get());
    char2string(vconf.stripnames_gui, vconf.stripnames);
    char2string(vall.debug_gui, vall.debug);
    strcpy(vall.authtype, vall.authtype_gui.get());
    int2string(vall.radtimeout_gui, vall.radtimeout);
    int2string(vall.mtu_gui, vall.mtu);
    strcpy(vall.term, vall.term_gui.get());
    char2string(vall.sysutmp_gui, vall.sysutmp);
    char2string(vall.syswtmp_gui, vall.syswtmp);
    strcpy(vall.porttype, vall.porttype_gui.get());
    strcpy(vall.speed, vall.speed_gui.get());
    char2string(vall.aa_gui, vall.aa);
    int2string(vall.checktime_gui, vall.checktime);
    strcpy(vall.flow, vall.flow_gui.get());
    char2string(vall.dcd_gui, vall.dcd);
    strcpy(vall.protocol, vall.protocol_gui.get());
    /* joins vall.ipno_gui and vall.ipno2_gui to vall.ipno */
    {
        if(vall.ipno2_gui)
            strcat(vall.ipno_gui, "+");
        strcpy(vall.ipno, vall.ipno_gui);
    }

    if(my_button==MENU_ACCEPT){

    // save variables with data to file
    writetofile("conf.hostname", vconf.hostname, vitems_pslave);
    writetofile("conf.ipno", vconf.ipno, vitems_pslave);
    writetofile("conf.lockdir", vconf.lockdir, vitems_pslave);
    writetofile("conf.rlogin", vconf.rlogin, vitems_pslave);
    writetofile("conf.pppd", vconf.pppd, vitems_pslave);
    writetofile("conf.telnet", vconf.telnet, vitems_pslave);
    writetofile("conf.ssh", vconf.ssh, vitems_pslave);
    writetofile("conf.locallogins", vconf.locallogins, vitems_pslave);
    writetofile("conf.syslog", vconf.syslog, vitems_pslave);
    writetofile("conf.facility", vconf.facility, vitems_pslave);
    writetofile("conf.filterdir", vconf.filterdir, vitems_pslave);
    writetofile("conf.stripnames", vconf.stripnames, vitems_pslave);

    updatemultilinetofile("all.realm", vall.realms, vitems_pslave);

    writetofile("all.debug", vall.debug, vitems_pslave);
    writetofile("all.authtype", vall.authtype, vitems_pslave);
    writetofile("all.authhost1", vall.authhost1, vitems_pslave);
    writetofile("all.accthost1", vall.accthost1, vitems_pslave);
    writetofile("all.radtimeout", vall.radtimeout, vitems_pslave);
    writetofile("all.authhost2", vall.authhost2, vitems_pslave);
    writetofile("all.accthost2", vall.accthost2, vitems_pslave);
//    writetofile("all.realm", vall.realm, vitems_pslave);
    writetofile("all.secret", vall.secret, vitems_pslave);
    writetofile("all.protocol", vall.protocol, vitems_pslave);
    writetofile("all.host", vall.host, vitems_pslave);
    writetofile("all.ipno", vall.ipno, vitems_pslave);
    writetofile("all.netmask", vall.netmask, vitems_pslave);
    writetofile("all.mtu", vall.mtu, vitems_pslave);
    writetofile("all.issue", vall.issue, vitems_pslave);
    writetofile("all.prompt", vall.prompt, vitems_pslave);
    writetofile("all.term", vall.term, vitems_pslave);
    writetofile("all.sysutmp", vall.sysutmp, vitems_pslave);
    writetofile("all.syswtmp", vall.syswtmp, vitems_pslave);
    writetofile("all.porttype", vall.porttype, vitems_pslave);
    writetofile("all.speed", vall.speed, vitems_pslave);
    writetofile("all.initchat", vall.initchat, vitems_pslave);
    writetofile("all.waitfor", vall.waitfor, vitems_pslave);
    writetofile("all.answer", vall.answer, vitems_pslave);
    writetofile("all.aa", vall.aa, vitems_pslave);
    writetofile("all.checktime", vall.checktime, vitems_pslave);
    writetofile("all.checkchat", vall.checkchat, vitems_pslave);
    writetofile("all.flow", vall.flow, vitems_pslave);
    writetofile("all.dcd", vall.dcd, vitems_pslave);
    writetofile("all.autoppp", vall.autoppp, vitems_pslave);
    writetofile("all.pppopt", vall.pppopt, vitems_pslave);

    vitems_pslave.write(cf_pslave, NULL);

    }


}

/* this module was programmed by
 Daniel Mealha Cabrita (dancab@conectiva.com)
 11th aug, 2000 */


