/* this just reads/write the printcap (/etc/printcap) data to
   correct variables (variables in printer_common_data listing) */

#include <stdlib.h>
#include <string.h>
#include "printer.h"
#include "printer.m"

#include "deez_parser.h"
#include "printer_common_data.h"

#include "printer_cfile.h"

t_dataprintcap defu;

//void initialise_ptrcap_defaults(void);
//void load_dataprintcap(t_dataprintcap *dataprintcap, int which_printer);

void initialise_ptrcap_defaults(void)
{

#define inis(a,b) strcpy(defu.a,b)
#define inid(a,b) defu.a=b

        /* defaults (field absent when equal to these) */

        inis(af,"");
        inid(br,0);
        inis(cf,"");
        inis(df,"");
        inid(fc,0);
        inis(ff,"\f");
        inid(fo,0);
        inid(fq,0);
        inid(fs,0);
        inis(gf,"");
        inid(hl,0);
        inid(ic,0);
        inis(if_,"");
        inis(lf,"/dev/console");
        inis(lo,"");
        inis(lp,"/dev/lp");
        inid(mx,1000);
        inis(nd,"");
        inis(nf,"");
        inis(of,"");
        inid(pc,200);
        inid(pl,66);
        inid(pw,132);
        inid(px,0);
        inid(py,0);
        inis(rf,"");
        inis(rg,"");
        inis(rm,"");
        inis(rp,"");
        inid(rs,0);
        inid(rw,0);
        inid(sb,0);
        inid(sc,0);
        inis(sd,"/var/spool/lpd");
        inid(sf,0);
        inid(sh,0);
        inis(st,"");
        inis(tf,"");
        inis(tr,"");
        inis(vf,"");
        /* new for LPRng */
        inid(lpd_bounce,0);
}


    /*
  -- af         str       NULL                   name of accounting file
     br         num       none                   if lp is a tty, set the baud
                                                 rate (ioctl(2) call)
     cf         str       NULL                   cifplot data filter
     df         str       NULL                   tex data filter (DVI format)
     fc         num       0                      if lp is a tty, clear flag
                                                 bits (sgtty.h)
     fq         bool      false                  print a form feed when device
     						 is closed
     ff         str       `\f'                   string to send for a form
                                                 feed
     fo         bool      false                  print a form feed when device
                                                 is opened
     fs         num       0                      like `fc' but set bits
     gf         str       NULL                   graph data filter (plot(3)
                                                 format
     hl         bool      false                  print the burst header page
                                                 last
     ic         bool      false                  driver supports (non
                                                 standard) ioctl to indent
                                                 printout
 --  if         str       NULL                   name of text filter which
                                                 does accounting
     lf         str       /dev/console           error logging file name
     lo         str       lock                   name of lock file
 --  lp         str       /dev/lp                device name to open for
                                                 output
 --  mx         num       1000                   maximum file size (in BUFSIZ
                                                 blocks), zero = unlimited
     nd         str       NULL                   next directory for list of
                                                 queues (unimplemented)
     nf         str       NULL                   ditroff data filter (device
                                                 independent troff)
     of         str       NULL                   name of output filtering
                                                 program
     pc         num       200                    price per foot or page in
                                                 hundredths of cents


     pl         num       66                     page length (in lines)
     pw         num       132                    page width (in characters)
     px         num       0                      page width in pixels
                                                 (horizontal)
     py         num       0                      page length in pixels
                                                 (vertical)
     rf         str       NULL                   filter for printing FORTRAN
                                                 style text files
     rg         str       NULL                   restricted group. Only
                                                 members of group allowed
                                                 access
     rm         str       NULL                   machine name for remote
                                                 printer
     rp         str       ``lp''                 remote printer name argument
     rs         bool      false                  restrict remote users to
                                                 those with local accounts
     rw         bool      false                  open the printer device for
                                                 reading and writing
     sb         bool      false                  short banner (one line only)
     sc         bool      false                  suppress multiple copies
  -- sd         str       /var/spool/lpd         spool directory
     sf         bool      false                  suppress form feeds
  -- sh         bool      false                  suppress printing of burst
                                                 page header
     st         str       status                 status file name
     tf         str       NULL                   troff data filter (cat
                                                 phototypesetter)
     tr         str       NULL                   trailer string to print when
                                                 queue empties
     vf         str       NULL                   raster image filter
 */

/* says if particle is present in string or not (for use with boolean parameters) */
/* true-present, false-not present */
int parse_bool_data(char *given_string, char *particle_to_trap)
{
    return(parse_integer_data(given_string, particle_to_trap, NULL));
}

/* returns true if successful */
int load_dataprintcap(t_dataprintcap *dataprintcap, int which_printer)
{
    FILE_CFG *printcapfile;
    int  myfilesize;
    char *my_buff,  /* used for reading whole file, then for getting printername */
         *my_buff2;
    char particle2trap[30];
    int  am_i_successful;

    initialise_ptrcap_defaults();
    am_i_successful=0;

    sprintf(particle2trap, "%s", "");

    /* create file if it doesn't exist.. */
    if(!cf_printcapfile.exist())
        cf_printcapfile.create();

//    if((printcapfile=fopen(PRTCP_FILE, "r"))){
    if((printcapfile=cf_printcapfile.fopen("r"))){
    fseek(printcapfile, 0, SEEK_END);
        myfilesize=ftell(printcapfile);
        fseek(printcapfile, 0, SEEK_SET);

        if((my_buff=(char *)malloc(myfilesize+1))){
            if((my_buff2=(char *)malloc(myfilesize+1))){
                *my_buff=0;
                *(my_buff+myfilesize)=0;
                fread(my_buff, myfilesize, 1, printcapfile);

                copy_specific_block(my_buff, particle2trap, which_printer, my_buff2);
                if(*my_buff2){
                    char *whereis_twodots;

                    am_i_successful=1;

                    strcpy(my_buff, my_buff2);
                    if((whereis_twodots=strchr(my_buff, ':'))){
                        *whereis_twodots=0;
                        strcpy(dataprintcap->printer_name, my_buff);
                    } else {
                        *(dataprintcap->printer_name)=0;
                    }

#define pstr(a,b) parse_string_data(my_buff2, a, ":", dataprintcap->b);\
    if(!parse_integer_data(my_buff2, a, NULL)) strcpy(dataprintcap->b, defu.b)
#define pboo(a,b) dataprintcap->b=parse_integer_data(my_buff2, a, NULL)
#define pint(a,b) parse_integer_data(my_buff2, a, &(dataprintcap->b));\
    if(!parse_integer_data(my_buff2, a, NULL)) dataprintcap->b=defu.b

                    pstr("af=",af);
                    pboo("br#",br);
                    pstr("cf=",cf);
                    pstr("df=",df);
                    pint("fc#",fc);
                    pstr("ff=",ff);
                    pboo("fo",fo);
                    pboo("fq",fq);
                    pint("fs#",fs);
                    pstr("gf=",gf);
                    pboo("hl",hl);
                    pboo("ic",ic);
                    pstr("if=",if_);
                    pstr("lf=",lf);
                    pstr("lo=",lo);
                    pstr("lp=",lp);
                    pint("mx#",mx);
                    pstr("nd=",nd);
                    pstr("nf=",nf);
                    pstr("of=",of);
                    pint("pc#",pc);
                    pint("pl#",pl);
                    pint("pw#",pw);
                    pint("px#",px);
                    pint("py#",py);
                    pstr("rf=",rf);
                    pstr("rg=",rg);
                    pstr("rm=",rm);
                    pstr("rp=",rp);
                    pboo("rs",rs);
                    pboo("rw",rw);
                    pboo("sb",sb);
                    pboo("sc",sc);
                    pstr("sd=",sd);
                    pboo("sf",sf);
                    pboo("sh",sh);
                    pstr("st=",st);
                    pstr("tf=",tf);
                    pstr("tr=",tr);
                    pstr("vf=",vf);
                    /* new for LPRng */
                    pboo("lpd_bounce",lpd_bounce);
                }
                free(my_buff2);
            }
            free(my_buff);
        }

        cf_printcapfile.fclose(printcapfile);
//        fclose(printcapfile);
    }
    return(am_i_successful);
}

/* printcapfile should be previously opened and the file pointer set */
void save_dataprintcap(t_dataprintcap *dataprintcap, FILE_CFG *printcapfile, char *prt_header)
{
    char tempbu[300];

#define wstr(a,b) if(strcmp(dataprintcap->b, defu.b)){\
    sprintf(tempbu, "\\\n        :%s%s:", a, dataprintcap->b);\
    fputs(tempbu, printcapfile);}
#define wboo(a,b) if(dataprintcap->b){\
    sprintf(tempbu, "\\\n        :%s:", a);\
    fputs(tempbu, printcapfile);}
#define wint(a,b) if(dataprintcap->b!=defu.b){\
    sprintf(tempbu, "\\\n        :%s%d:", a, dataprintcap->b);\
    fputs(tempbu, printcapfile);}

    sprintf(tempbu, "%s", prt_header);
    fputs(tempbu, printcapfile);

                    wstr("af=",af);
                    wboo("br#",br);
                    wstr("cf=",cf);
                    wstr("df=",df);
                    wint("fc#",fc);
                    wstr("ff=",ff);
                    wboo("fo",fo);
                    wboo("fq",fq);
                    wint("fs#",fs);
                    wstr("gf=",gf);
                    wboo("hl",hl);
                    wboo("ic",ic);
                    wstr("if=",if_);
                    wstr("lf=",lf);
                    wstr("lo=",lo);
                    wstr("lp=",lp);
                    wint("mx#",mx);
                    wstr("nd=",nd);
                    wstr("nf=",nf);
                    wstr("of=",of);
                    wint("pc#",pc);
                    wint("pl#",pl);
                    wint("pw#",pw);
                    wint("px#",px);
                    wint("py#",py);
                    wstr("rf=",rf);
                    wstr("rg=",rg);
                    wstr("rm=",rm);
                    wstr("rp=",rp);
                    wboo("rs",rs);
                    wboo("rw",rw);
                    wboo("sb",sb);
                    wboo("sc",sc);
                    wstr("sd=",sd);
                    wboo("sf",sf);
                    wboo("sh",sh);
                    wstr("st=",st);
                    wstr("tf=",tf);
                    wstr("tr=",tr);
                    wstr("vf=",vf);
                    /* new for LPRng */
                    wboo("lpd_bounce",lpd_bounce);

    sprintf(tempbu, "\n");
    fputs(tempbu, printcapfile);
}

/* incomplete (need to set to typical values) */
void load_printcap_defaults(t_dataprintcap *dataprintcap)
{
#define pdstr(a) strcpy(dataprintcap->a, defu.a)
#define pdboo(a) dataprintcap->a=defu.a
#define pdint(a) dataprintcap->a=defu.a

                    pdstr(af);
                    pdboo(br);
                    pdstr(cf);
                    pdstr(df);
                    pdint(fc);
                    pdstr(ff);
                    pdboo(fo);
                    pdboo(fq);
                    pdint(fs);
                    pdstr(gf);
                    pdboo(hl);
                    pdboo(ic);
                    pdstr(if_);
                    pdstr(lf);
                    pdstr(lo);
                    pdstr(lp);
                    pdint(mx);
                    pdstr(nd);
                    pdstr(nf);
                    pdstr(of);
                    pdint(pc);
                    pdint(pl);
                    pdint(pw);
                    pdint(px);
                    pdint(py);
                    pdstr(rf);
                    pdstr(rg);
                    pdstr(rm);
                    pdstr(rp);
                    pdboo(rs);
                    pdboo(rw);
                    pdboo(sb);
                    pdboo(sc);
                    pdstr(sd);
                    pdboo(sf);
                    pdboo(sh);
                    pdstr(st);
                    pdstr(tf);
                    pdstr(tr);
                    pdstr(vf);
                    /* new for LPRng */
                    pdboo(lpd_bounce);

                    dataprintcap->sh=1;
                    dataprintcap->mx=0;
}
