// vim: nowrap

#ifndef DATA_H
#define DATA_H

#ifndef MISC_H
	#include <misc.h>
#endif

#include <fcntl.h>
#include <popen.h>
#include <fviews.h>
#include <stdlib.h>
#include <dirent.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include "kbdconf.m"
#include "devicelist.h"

#if defined(__sparc__)
#include <sys/ioctl.h>
#include <sys/sysmacros.h>
#include <fcntl.h>
#endif

#define KBDTYPE_SUN     0
#define KBDTYPE_PC      1
#define KBDTYPE_SERIAL  2

class DATA: public ARRAY_OBJ{
public:
	SSTRING *name;
	SSTRING *desc;
public:
	DATA(const char *_name, const char *_desc);
	DATA(const char *_name);
	~DATA();
	DATA(void);
};

class DATALIST: public ARRAY{
public:
	int keyboardtype;
	const char *defkeytable;
#if defined(__sparc__)
	char *keymapdir;
#endif
	SSTRING keytable;
	
private:
	int verbose;
	DATA *getitem(int no);
	
public:
	DATALIST(int verbose_);
	~DATALIST();
	int init();
	int readcfg();
	int save ();
	int save (const char *name);
	void getKeyboardConfig (DEVICELIST &dev);
	void restoretodefault();
	int updatekeyboard();
	int execute (const char *command, const char *args);
	const char *touch ();
	const char *getlayout();
	void getlistmodels(SSTRINGS &dest);
	const char *getdescbyname(const char *name);
	const char *getnamebydesc(const char *desc);

private:
#ifdef __sparc__
	int checkSunKeyboard ();
#endif
		
};
#endif
