/*

 IRCd configurator v1.01
 by Alexandre Augustus Falcao

 v1.0  - first version done in (?/?/2000)
 v1.01 - minor changes in list windows. now the previous selection
         is kept (it was always reseting to the first entry).
       - enhanced the window for Connection Classes menu (uses
         tabs now).
         by Daniel Mealha Cabrita (dancab@conectiva.com)
         (Dec 1st, 2000)

*/

#pragma implementation
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include <misc.h>
#include <subsys.h>
#include "parse.cc"
#include "ircdconf.h"
#include "ircdconf.m"
#include "connclass.cc"
#include "server.cc"
#include "users.cc"

static LINUXCONF_SUBSYS sub ("ircdconf",P_MSG_U(IRCDCONFSUBSYS, "Configures the IRC server"));

MODULE_DEFINE_VERSION(ircdconf);

PUBLIC MODULE_ircdconf::MODULE_ircdconf()
    : LINUXCONF_MODULE("ircdconf")
{
    linuxconf_loadmsg ("ircdconf",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_ircdconf::setmenu (
                                  DIALOG &dia,
                                  MENU_CONTEXT context)
{
    if (context == MENU_NETWORK_SERVER){
        keymenu = MSG_U(M_ircd,"IRCd Server Configuration");
        dia.new_menuitem ("ipalias","",keymenu);
    }
}

PUBLIC int MODULE_ircdconf::domenu (MENU_CONTEXT context, const char *key)
{
    if (context == MENU_NETWORK_SERVER){
        if (key == keymenu){
                edit_ircdconf ();
        }
    }
    return 0;
}


PUBLIC int MODULE_ircdconf::probe(int level, int target, bool simul)
{
    // this service must be configured only
    // in network level 1 or higher
    if (target == 0){
        // Do something to turn off this service
        // if needed
    }if (level == 1){ // Client mode
        // Do something to enable the service
        // if needed
        char sum[100];

        cfg_file.md5sum(sum);
        // this function returns a md5 of a CONFIG_FILE
        // You'll want to compare a old md5 with the new one
        // to know if any changes was done.

        const char *confsum = linuxconf_getval("ircdconf", "ircdconfsum");
        // linuxconf_getval returns a value (if exists)
        // of the variable in conf.linuxconf
        // the first argument is a sub sys
        // the second is the varable name
        // if the variable does not exists
        // linuxconf_getval will return NULL

        const char *defval = "";
        // if linuxconf_getval returns NULL
        // you'll want to unNULL your pointer
        // otherwise you can get some crashes.. ;)

        if(confsum == NULL)
            confsum = defval;

	bool is_alive = process_find ("ircd",NULL) != NULL;
	#if 0
	{
		POPEN pop ("pidof","ircd");
		if (pop.isok()){
			// Wait at most 10 seconds.
			for (int i=0; i<10; i++){
				if (pop.wait(1)<0) break;
				char line[80];
				while (pop.readout(line,sizeof(line))!=-1
					&& isdigit(line[0])) is_alive = true;
			}
		}
	}
	#endif

        if(is_alive && strcmp(sum, confsum)  != 0)
            // if pidof didn't ruturned nothing
            // AND
            // the new md5 diferes from the old one...
        {
            net_prtlog(16, "killall -HUP ircd");
            // the net_prtlog logs what will be done

            if (!simul)
            {
                // netconf_system_if("killall", "-HUP ircd");
                // Teorically this function will make the changes...
                // I can't get this way...
                // So I called popen again :)
                FILE *command = popen("killall -HUP ircd", "r");
                while(!feof(command))
                {
                    getc(command);
                }
                pclose(command);

                // The lines above replaces or create if necessary
                // the variable where you will save the new md5
                // and saves conf.linuxconf
                linuxconf_replace("ircdconf", "ircdconfsum", sum);
              	linuxconf_save();
            }
        }
    }
    return 0;
}



////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// Main Menu                                                                                            ///
////////////////////////////////////////////////////////////////////////////////////////////////////////////

PUBLIC int MODULE_ircdconf::edit_ircdconf (void)
{
    if(!cfg_file.exist())
    {
        xconf_error(MSG_U(E_FILEDOESNOTEXISTS,"The ircd.conf file does not exists, verify\nthe path on linuxconf config files paths."));
    }else{
        DIALOG_MENU dia;
        MENU_STATUS menu;
        SSTRINGS *tb;
        int opt=-1;

        dia.new_menuitem("host", "", MSG_U(M_SERVER,"Server Info"));
        dia.new_menuitem("users", "", MSG_U(M_USERS,"Users Options"));
        dia.new_menuitem("network", "", MSG_U(M_LINKS,"Link Manager"));
        dia.new_menuitem("features", "" ,MSG_U(M_CONCLASS,"Connection Classes"));
        tb = opencfg();
        while(1)
        {
//            int opt=-1;
            menu = dia.editmenu(MSG_R(M_ircd),MSG_U(I_MDESC,"Here you can set all of IRCd options."),help_main,opt,MENUBUT_QUIT);
            if(menu == MENU_ESCAPE || menu == MENU_QUIT)
                break;
            else {
                switch(opt)
                {
                case 0:
                    dia_server(tb);
                    break;
                case 1:
                    dia_users(tb);
                    break;
                case 2:
                    dia_links(tb);
                    break;
                case 3:
                    dia_conclass(tb);
                    break;
                default:
                    return(0);
                }
            }
        }
    }
    return (0);
}

// LINK MANAGER
PUBLIC void dia_links(SSTRINGS *tb)
{
    DIALOG_RECORDS dia;
    int opt=-1;

    dia.newf_head("", MSG_U(I_LHEAD, "Server name\tClass"));
    while(1)
    {
        SSTRINGS *temp_tb = cat_opts("Cc", tb);
        int tb_size = temp_tb->getnb();
        for(int x=0;x<tb_size;x++)
        {
            dia.set_menuitem(x, get_opt(temp_tb, x, 3), get_opt(temp_tb,x,5));
        }
        dia.remove_last(tb_size+1);
//        int opt=-1;
        MENU_STATUS menu = dia.editmenu(MSG_R(M_LINKS), MSG_U(I_LKDES, "Here you can link your server with others server."), help_main, opt, MENUBUT_ADD|MENUBUT_QUIT);
        MENU_STATUS oldmenu = menu;
        if ( menu == MENU_ESCAPE || menu == MENU_QUIT || menu == MENU_CANCEL)
            break;
        else if(( menu == MENU_OK && opt > -1) || menu == MENU_ADD)
        {
            DIALOG dia_add;
            int nof=0;
            SSTRING server, ip, pass, cclass;
            int port=0;
            FIELD_LIST *classlist;
            SSTRING *temp;
            if(oldmenu == MENU_ADD)
            {
                temp = new SSTRING();
            }
            else
            {
                temp = temp_tb->getitem(opt);
                ip.append(get_opt(temp_tb, opt, 1));
                server.append(get_opt(temp_tb, opt, 3));
                pass.append(get_opt(temp_tb, opt, 2));
                cclass.append(get_opt(temp_tb, opt, 5));
                port = atoi(get_opt(temp_tb, opt, 4));
            }
            dia_add.newf_str(MSG_U(F_LHN,"Hostname or IP"), ip);
            dia_add.newf_str(MSG_U(F_LSN,"Server Name"), server);
            dia_add.newf_str(MSG_U(F_LPS,"Password"), pass);
            dia_add.newf_num(MSG_U(F_LSP,"Server Port"), port);
            const char *classes[] = { "", "50", "70", "80", "90" };
            classlist = dia_add.newf_list(MSG_U(F_LSCC,"Class"), cclass);
            for(int x=0;x<5;x++)
                classlist->addopt(classes[x],"");
            MENU_STATUS menu2 = dia_add.edit(MSG_U(M_LINK_EDIT, "Edit/Add a server link"), MSG_R(I_LKDES), help_main, nof, MENUBUT_DEL|MENUBUT_ACCEPT|MENUBUT_CANCEL);
            switch(menu2)
            {
            case MENU_ACCEPT:
                if(verify_str(ip, server, pass))
                {
                    temp->setfromf("C:%s:%s:%s:%d:%s", ip.get(), pass.get(), server.get(), port, cclass.get());
                    if(oldmenu == MENU_ADD)
                        temp_tb->add(temp);
                }
                break;
            case MENU_DEL:
                if(oldmenu != MENU_ADD)
                    temp_tb->remove_del(temp);
                break;
            default:
                break;
            }
            SSTRINGS links_tb;
            for(int x=0;x<temp_tb->getnb();x++)
            {
                char line[256];
                links_tb.add(temp_tb->getitem(x));
                if (atoi(get_opt(temp_tb, x, 5)) == 90)
                {
                    sprintf(line, "H:*.*:%s", get_opt(temp_tb, x, 3));
                    links_tb.add(new SSTRING(line));
                }
                else if (atoi(get_opt(temp_tb, x, 5)) == 50)
                {
                    sprintf(line, "L::%s", get_opt(temp_tb, x, 3));
                    links_tb.add(new SSTRING(line));
                }
            }
            if (!cfg_compare(&links_tb, cat_opts("CcHhLl", tb)))
                change_opts("CcHhLl", tb, &links_tb);
            if(!cfg_compare(tb, &cfg_old))
                savecfg(tb);
        }
    }
}


PUBLIC int MODULE_ircdconf::dohtml (const char *key)
{
    int ret = LNCF_NOT_APPLICABLE;
    if (strcmp(key,"ircdconf")==0){
        // ### Insert any menu and dialog here
        ret = 0;
    }
    return ret;
}


static void usage()
{
    xconf_error (MSG_U(T_USAGE
                       ,"Module ircdconf\n"
                       "linuxconf --modulemain ircdconf [ specific options ]\n"
                       "\n")
                );
}

PUBLIC void MODULE_ircdconf::usage (SSTRINGS &tb)
{
    tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_ircdconf::execmain (int argc , char *argv[], bool)
{
    int ret = LNCF_NOT_APPLICABLE;
    const char *pt = strrchr(argv[0],'/');
    if (pt != NULL){
        pt++;
    }else{
        pt = argv[0];
    }
    if (strcmp(pt,"ircdconf")==0){
        ret = -1;
        if (argc == 1){
            edit_ircdconf();
            // ### Place call to main menu of the module
        }else{
            // ### Add some option parsing for the module
            ::usage();
        }
    }
    return ret;
}


static MODULE_ircdconf ircdconf;

