#pragma implementation
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <misc.h>
#include <configf.h>
#include <userconf.h>
#include <translat.h>
#include <subsys.h>
#include <fviews.h>
#include "inetdconf.h"
#include "inetdconf.m"
#include "etcprotocol.h"

static HELP_FILE help_etcprotocol ("inetdconf","etcprotocol");
static CONFIG_FILE f_config_file(
		"/etc/protocols"
		,help_etcprotocol
		,0
		,"root"
		,"root"
		,0644
		,subsys_inetdconf);

/*
 * ETCPROTOCOL
 */
#define	K_FIELD_PROTOCOL		1
#define	K_FIELD_NUMBER			2
#define	K_FIELD_ALIASES			3
#define	K_FIELD_COMMENT			4

PRIVATE void ETCPROTOCOL::init()
{
//fprintf(stderr,"ETCPROTOCOL::init\n");
	new_etcprotocol = 0;
	number = 0;
}

PUBLIC ETCPROTOCOL::ETCPROTOCOL(const char *_protocol_name)
{
//fprintf(stderr,"ETCPROTOCOL::ETCPROTOCOL _protocol_name=%s\n", _protocol_name);
	protocol_name.setfrom (_protocol_name);
	init();
}

PUBLIC ETCPROTOCOL::ETCPROTOCOL( )
{
//fprintf(stderr,"ETCPROTOCOL::ETCPROTOCOL\n");
	init();
}

/**
 * ETCPROTOCOLLIST
 */

PUBLIC ETCPROTOCOL *ETCPROTOCOLLIST::getitem (int no) const
{
	return (ETCPROTOCOL*)ARRAY::getitem (no);
}

PUBLIC ETCPROTOCOL *ETCPROTOCOLLIST::getitem (const char *_protocol_name) const
{
	ETCPROTOCOL *ret = NULL;
	int n = getnb();
	for (int i=0; i<n; i++) {
		ETCPROTOCOL *etcprotocol = getitem(i);
		if (etcprotocol->protocol_name.cmp(_protocol_name)==0){
			ret = etcprotocol;
			break;
		}
	}
	return ret;
}

PUBLIC ETCPROTOCOL *ETCPROTOCOLLIST::getitem_alias(const char *_service_name) const
{
//fprintf(stderr,"etcprotocol.cc: getitem_alias: service_name=%s getnb()=%d\n", _service_name, getnb() );
	ETCPROTOCOL *ret = NULL;
	int n = getnb();
	for (int i=0; i<n; i++) {
		ETCPROTOCOL *etcprotocol = getitem(i);
//fprintf(stderr,"etcprotocol.cc: getitem_alias: service_name=%s etcprotocol->protocol_name=%s\n", _service_name, etcprotocol->protocol_name.get() );
		char word[100];
		const char *p = etcprotocol->aliases.get( );
		while ( *p ) {
			p = str_copyword( word, p, sizeof( word ) );
//fprintf(stderr,"etcprotocol.cc: getitem_alias: service_name=%s word=%s\n", _service_name, word );
			if (strcmp(word, _service_name)==0) {
				return( etcprotocol );
			}
		}
	}
	return ret;
}

PUBLIC ETCPROTOCOLLIST::ETCPROTOCOLLIST( )
{
//fprintf(stderr,"ETCPROTOCOLLIST::ETCPROTOCOLLIST\n");
}

PRIVATE char * ETCPROTOCOLLIST::next_word( char *d, char *s, int size )
{
	while ( *s ) {
		switch ( *s ) {
			case ' ':
			case '\t':
				s++;
				continue;
			default:
				break;
		}
		break;
	}
	for ( size--; *s && size; size-- ) {
		switch ( *s ) {
			case ' ':
			case '\t':
			case '\n':
				*d = '\0';
				return( s );
			case '#':
				*d++ = *s++;
				*d = '\0';
				return( s );
			default:
				*d++ = *s++;
				break;
		}
	}
	*d = '\0';
	return( s );
}

PRIVATE int ETCPROTOCOLLIST::valid_number( char *word, ETCPROTOCOL *etcprotocol )
{
int valid_digits = 0;
	char *p = word;
	char *s = word;
	for ( ; *p && isdigit( (int)*p); p++ ) valid_digits++;
	*p++ = '\0';
	if ( ! valid_digits ) return( 0 );
	etcprotocol->number = atoi( s );
//fprintf(stderr,"valid_number: %d\n", etcprotocol->number );
	return( 1 );
}

PRIVATE void ETCPROTOCOLLIST::valid_aliases( char *word, ETCPROTOCOL *etcprotocol )
{
//fprintf(stderr,"valid_aliases: %s\n", word);
	if ( etcprotocol->aliases.is_empty( ) ) {
		etcprotocol->aliases.setfrom( word );
	} else {
		etcprotocol->aliases.append( " " );
		etcprotocol->aliases.append( word );
	}
}

PUBLIC void ETCPROTOCOLLIST::add_protocol( int line_number, VIEWITEM *item )
{
//fprintf(stderr,"etcprotocol.cc: add_protocol: item->line.get()=%s\n", item->line.get());
	ETCPROTOCOL *etcprotocol = NULL;
	char word[1024];
	char *line = (char *)item->line.get();
	char *p = line;
	if ( *p && *p == '#' ) {
		return;
	}
	if ( strlen( p ) < 3 ) return;
	int field = 1;
	int valid_keywords = 0;
	while ( 1 ) {
		p = next_word( word, p, sizeof( word ));
		if ( strlen( word ) == 0 ) {
			break;
		}
//fprintf(stderr,"etcprotocol.cc: add_protocol: field=%d word=\"%s\" length=%d\n", field, word, strlen(word));
		switch ( field ) {
			case K_FIELD_PROTOCOL:
				etcprotocol = new ETCPROTOCOL();
				etcprotocol->protocol_name.setfrom( word );
				field++;
				break;
			case K_FIELD_NUMBER:
				if ( valid_number( word, etcprotocol ) ) {
					valid_keywords++;
				}
				field++;
				break;
			case K_FIELD_ALIASES:
				if ( word[0] == '#' ) {
					field = K_FIELD_COMMENT;
					break;
				}
				valid_aliases( word, etcprotocol );
				break;
			case K_FIELD_COMMENT:
				if ( etcprotocol->comment.is_empty( ) ) {
					etcprotocol->comment.setfrom( word );
				} else {
					etcprotocol->comment.append( " " );
					etcprotocol->comment.append( word );
				}
				break;
		}
	}
	if ( valid_keywords > 0 ) {
		add( etcprotocol );
	} else {
		delete( etcprotocol );
	}
	return;
}

/**
 * Read config file and parse etc/protocols
 */
PUBLIC void ETCPROTOCOLLIST::read()
{
	VIEWITEMS items;
	items.setcomcar( '\002' );	// Set comment to "impossible" char
	items.read( f_config_file );	// Read config file
//fprintf(stderr,"ETCPROTOCOLLIST::read items.getnb()=%d\n", items.getnb());
	for ( int i=0; i<items.getnb(); i++ ) {
		VIEWITEM *item = items.getitem( i );
		add_protocol( i, item );
	}
}

/**
 * Edit etcprotocollist
 */
PUBLIC int ETCPROTOCOLLIST::edit()
{
//fprintf(stderr,"ETCPROTOCOLLIST::edit\n");
	DIALOG_LISTE *dia = NULL;
	int nof = 0;
	while (1) {
		if (dia == NULL) {
			dia = new DIALOG_LISTE;
			dia->newf_head ("",MSG_U(H_ETCPROTOCOL,"Server\tPort/Protocol"));
			for (int i=0; i<getnb(); i++) {
				ETCPROTOCOL *etcprotocol = getitem(i);
				SSTRING string;
				string.setfrom( etcprotocol->number );
				dia->new_menuitem (etcprotocol->protocol_name, string);
			}
		}
		MENU_STATUS code = dia->editmenu (MSG_U(T_ETCPROTOCOLLIST,"Services")
			,MSG_U(I_ETCPROTOCOLLIST,"This is the list of all protocols.")
			,help_etcprotocol
			,nof,0);
		bool mustdelete=false;
		if (code == MENU_QUIT || code == MENU_ESCAPE) {
			break;
		} else if (code == MENU_ADD) {
			ETCPROTOCOL *etcprotocol = new ETCPROTOCOL;
			etcprotocol->new_etcprotocol = true;
			if ( editone(etcprotocol) != -1 ) mustdelete = true;
		} else {
			ETCPROTOCOL *etcprotocol = getitem( nof );
			etcprotocol->new_etcprotocol = false;
//fprintf(stderr,"editone: %s\n", etcprotocol->protocol_name.get());
			switch ( editone(nof) ) {
				case -1:
					mustdelete = false;
					break;
				case 1:
					mustdelete = true;
					break;
				case 0:
					mustdelete = false;
					break;
			}
		}
		if (mustdelete){
			delete dia;
			dia = NULL;
		}
	}
	delete dia;
	return 0;
}
