#include <dialog.h>
#include "dnsconf.h"
#include "dnsconf.m"
#include "internal.h"
#include <string.h>

static DNSCONF_HELP_FILE help_features ("features");
static DNSCONF_HELP_FILE help_access   ("access");

const char K_DNSCONF[]="dnsconf";
const char K_CHROOT[]="chroot";
const char K_TEMPLATEDOM[]="templatedom";
static const char K_SYNCBASICHOST[]="syncbasichost";


/*
	Return true is linuxconf is allowed to update the DNS using the
	basic host information screen.
*/
bool features_getsyncbasichost()
{
	return linuxconf_getvalnum (K_DNSCONF,K_SYNCBASICHOST,1) != 0;
}


/*
	Set a list of records in a dialog.
	Add 3 extra empty fields at the end.
*/
void feature_editlist (
	DIALOG &dia,
	int level,
	const char *ftitle,
	SSTRINGS &tb)
{
	dia.newf_title (ftitle,level,"",ftitle);
	for (int i=0; i<3; i++) tb.add(new SSTRING);
	for (int i=0; i<tb.getnb(); i++){
		dia.newf_str ("",*tb.getitem(i));
	}
}

static void features_removeempty(DNS_OPTIONS &options)
{
	options.allowtrans.remove_empty();
	options.allowquery.remove_empty();
	options.allowrecursion.remove_empty();
	options.listenon.remove_empty();
}


PUBLIC void DNS::editaccess()
{
	DIALOG dia;
	feature_editlist (dia,1,MSG_U(F_ALLOWTRANS,"Allow transfer to")
		,options.allowtrans);
	feature_editlist (dia,1,MSG_U(F_ALLOWQUERY,"Allow query from")
		,options.allowquery);
	feature_editlist (dia,1,MSG_U(F_ALLOWRECURSION,"Allow recursion from")
		,options.allowrecursion);
	feature_editlist (dia,1,MSG_U(F_LISTENON,"Listen on")
		,options.listenon);
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (MSG_U(T_DNSACCESS,"General access control")
			,""
			,help_access
			,nof);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			dia.restore();
			features_removeempty(options);
			break;
		}else{
			features_removeempty(options);
			write();
			break;
		}
	}
}

/*
	Validate the chroot directory. Make sure the directory exist
	and ends with a / (all the code assume the /).
*/
int features_chkchroot (SSTRING &root)
{
	int ret = -1;
	const char *pt = root.get();
	if (file_type(pt)!=1){
		xconf_error (MSG_U(E_NODIRCHROOT
			,"The root directory %s does not exist")
			,pt);
	}else{
		int len = strlen(pt);
		if (len > 0 && pt[len-1] != '/') root.append ("/");
		ret = 0;
	}
	return ret;
}

/*
	Return the domain to use as template
*/
const char *features_gettemplatedom()
{
	const char *ret = linuxconf_getval (K_DNSCONF,K_TEMPLATEDOM);
	if (ret != NULL && ret[0] == '\0') ret = NULL;
	return ret;
}

PUBLIC void DNS::editfeatures()
{
	DIALOG dia;
	SSTRING templatedom;
	templatedom.setfrom (features_gettemplatedom());
	dia.newf_str (MSG_U(F_TEMPLATEDOM,"Template domain"),templatedom);
	char syncbasic = features_getsyncbasichost() ? 1 : 0;
	dia.newf_chk (MSG_U(F_SYNCBASIC,"Syncrhonise DNS"),syncbasic
		,MSG_U(I_SYNCBASIC,"from basic host information"));
	dia.newf_chk (MSG_U(F_FORWARDONLY,"Forward only"),options.forward_only
		,MSG_U(I_FORWARDONLY,"Let the forwarders resolve"));
	dia.newf_chk (MSG_U(F_NORECURSE,"No recursion"),options.no_recursion
		,MSG_U(I_NORECURSE,""));
	dia.newf_chk (MSG_U(F_NOFETCHGLUE,"No fetch glue"),options.no_fetch_glue
		,MSG_U(I_NOFETCHGLUE,""));
	if (!bind8){
		dia.newf_chk (MSG_U(F_QUERYLOG,"Log each query"),options.query_log
			,"");
	}
	dia.newf_chk (MSG_U(F_FAKEIQUERY,"Fake iquery"),options.fake_iquery,"");
	if (!bind8){
		dia.newf_str (MSG_U(F_XFERNETS,"Limit zone transfer to networks")
			,xfernets);
		dia.newf_str (MSG_U(F_BOGUSNS,"Don't use those servers"),bogusns);
		dia.newf_str (MSG_U(F_SEARCHLIST,"Search list"),searchlist);
	}
	if (bind8){
		dia.newf_chk (MSG_U(F_NOTIFY,"Notify"),options.notify
			,"");
	}
	SSTRING chroot (linuxconf_getval(K_DNSCONF,K_CHROOT,""));
	dia.newf_str (MSG_U(F_CHROOT,"Root directory"),chroot);
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (MSG_U(T_DNSFEATURES,"DNS features")
			,""
			,help_features
			,nof);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			dia.restore();
			break;
		}else if (!templatedom.is_empty()
			&& locate_domain(templatedom.get())==NULL){
			nof = 0;
			xconf_error (MSG_U(E_TEMPLATEDOM
				,"Unknown domain %s\n"
				 "Can't be used as template"),templatedom.get());
		}else{
			if (options.forward_only && forwarders.getnb() == 0){
				xconf_notice (MSG_U(N_NOFORWARDER
					,"You have selected the option forward only\n"
					 "but there are no forwarders defined.\n"
					 "\n"
					 "Input accepted anyway"));
			}
			if (chroot.is_empty()
				|| features_chkchroot(chroot) != -1){
				linuxconf_replace (K_DNSCONF,K_CHROOT,chroot);
				linuxconf_replace (K_DNSCONF,K_SYNCBASICHOST,syncbasic);
				if (templatedom.is_empty()){
					linuxconf_removeall (K_DNSCONF,K_TEMPLATEDOM);
				}else{
					linuxconf_replace (K_DNSCONF,K_TEMPLATEDOM,templatedom);
				}
				linuxconf_save();
				pathcfg.setfromf ("%s%s",chroot.get(),pathcfg_conf.get());
				write();
				break;
			}
		}
	}
}


