#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "dhcpd.h"
#include "dhcpd.m"
#include <module_apis/dhcp_api.h>

MODULE_DEFINE_VERSION(dhcpd);
extern CONFIG_FILE f_lease;


PUBLIC MODULE_DHCPD::MODULE_DHCPD()
	: LINUXCONF_MODULE ("dhcpd")
{
	linuxconf_loadmsg ("dhcpd",PACKAGE_REV);
	module_register_api (DHCP_API_KEY,DHCP_API_REV
		,dhcp_api_get,dhcp_api_release);
}
static const char *keymenu=NULL;

PUBLIC void MODULE_DHCPD::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_BOOT){
		keymenu = MSG_U(M_DHCP,"DHCP/BOOTP server");
		dia.new_menuitem ("dhcpd","",keymenu);
	}
}

PUBLIC int MODULE_DHCPD::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_SERVER){
		if (key == keymenu){
			module_requestpkg ("dhcpserver");
			dhcp_edit();
		}
	}
	return 0;
}

PUBLIC int MODULE_DHCPD::probe (
	int level,
	int ,
	bool)
{
	if (level == 2 || simul_ishint()){
		dhcp_probe();
	}
	return 0;
}

PUBLIC void MODULE_DHCPD::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_U(E_USAGE
		,"Module dhcpd\n"
		 "linuxconf --modulemain dhcpd [ specific options ]\n"
		 "\n"
		 "    --updatedns [ --domain dns-domain ] [ --leasesfile file ]\n"
		 "    Without argument, start the main menu\n"
		 "\n")));
}


static void usage()
{
	fprintf (stderr,MSG_R(E_USAGE));
}

PUBLIC int MODULE_DHCPD::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"dhcpd")==0 || strcmp(pt,"dhcpdconf")==0){
		ret = -1;
		if (argc >= 2 && strcmp(argv[1],"--updatedns")==0){
			const char *fname = f_lease.getpath();
			const char *domain = dhcp_getdefdom();
			for (int i=2; i<argc; i++){
				if (strcmp(argv[i],"--domain")==0 && i < argc - 1){
					domain = argv[++i];
				}else if (strcmp(argv[i],"--leasesfile")==0 && i < argc - 1){
					fname = argv[++i];
				}else{
					::usage();
					break;
				}
			}
			ret = dhcpd_updatedns(false,fname,domain);
		}else if (argc == 2 && strcmp(argv[1],"--help")==0){
			::usage();
		}else if (argc == 1){
			dhcp_edit();
		}else{
			::usage();
		}
	}
	return ret;
}


static MODULE_DHCPD dhcpd;
